/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.completion.test.handlers;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/idea-completion/testData/handlers/basic")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BasicCompletionHandlerTestGenerated extends AbstractBasicCompletionHandlerTest {
    @TestMetadata("AddLabelToReturn.kt")
    public void testAddLabelToReturn() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/AddLabelToReturn.kt");
        doTest(fileName);
    }

    public void testAllFilesPresentInBasic() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("ClassKeywordBeforeName.kt")
    public void testClassKeywordBeforeName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/ClassKeywordBeforeName.kt");
        doTest(fileName);
    }

    @TestMetadata("ClassWithClassObject.kt")
    public void testClassWithClassObject() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/ClassWithClassObject.kt");
        doTest(fileName);
    }

    @TestMetadata("DoNotUseParenthesisOnNextLine.kt")
    public void testDoNotUseParenthesisOnNextLine() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/DoNotUseParenthesisOnNextLine.kt");
        doTest(fileName);
    }

    @TestMetadata("EA70229.kt")
    public void testEA70229() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/EA70229.kt");
        doTest(fileName);
    }

    @TestMetadata("ExtensionFunctionTypeVariable1.kt")
    public void testExtensionFunctionTypeVariable1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/ExtensionFunctionTypeVariable1.kt");
        doTest(fileName);
    }

    @TestMetadata("ExtensionFunctionTypeVariable2.kt")
    public void testExtensionFunctionTypeVariable2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/ExtensionFunctionTypeVariable2.kt");
        doTest(fileName);
    }

    @TestMetadata("ExtensionReceiverTypeArg.kt")
    public void testExtensionReceiverTypeArg() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/ExtensionReceiverTypeArg.kt");
        doTest(fileName);
    }

    @TestMetadata("FirstTypeArgument.kt")
    public void testFirstTypeArgument() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/FirstTypeArgument.kt");
        doTest(fileName);
    }

    @TestMetadata("GenericFunctionWithTab.kt")
    public void testGenericFunctionWithTab() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/GenericFunctionWithTab.kt");
        doTest(fileName);
    }

    @TestMetadata("GenericFunctionWithTab2.kt")
    public void testGenericFunctionWithTab2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/GenericFunctionWithTab2.kt");
        doTest(fileName);
    }

    @TestMetadata("GetOperator.kt")
    public void testGetOperator() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/GetOperator.kt");
        doTest(fileName);
    }

    @TestMetadata("InterfaceNameBeforeRunBug.kt")
    public void testInterfaceNameBeforeRunBug() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/InterfaceNameBeforeRunBug.kt");
        doTest(fileName);
    }

    @TestMetadata("JavaSAM.kt")
    public void testJavaSAM() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/JavaSAM.kt");
        doTest(fileName);
    }

    @TestMetadata("KT11633.kt")
    public void testKT11633() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/KT11633.kt");
        doTest(fileName);
    }

    @TestMetadata("KT12328.kt")
    public void testKT12328() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/KT12328.kt");
        doTest(fileName);
    }

    @TestMetadata("KT14130.kt")
    public void testKT14130() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/KT14130.kt");
        doTest(fileName);
    }

    @TestMetadata("NestedTypeArg.kt")
    public void testNestedTypeArg() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/NestedTypeArg.kt");
        doTest(fileName);
    }

    @TestMetadata("NoTailFromSmart.kt")
    public void testNoTailFromSmart() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/NoTailFromSmart.kt");
        doTest(fileName);
    }

    @TestMetadata("PreferClassToConstructor.kt")
    public void testPreferClassToConstructor() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/PreferClassToConstructor.kt");
        doTest(fileName);
    }

    @TestMetadata("PreferMatchingKeyword.kt")
    public void testPreferMatchingKeyword() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/PreferMatchingKeyword.kt");
        doTest(fileName);
    }

    @TestMetadata("ReplaceFunctionCallByProperty.kt")
    public void testReplaceFunctionCallByProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/ReplaceFunctionCallByProperty.kt");
        doTest(fileName);
    }

    @TestMetadata("ReplaceFunctionCallByPropertyArgs.kt")
    public void testReplaceFunctionCallByPropertyArgs() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/ReplaceFunctionCallByPropertyArgs.kt");
        doTest(fileName);
    }

    @TestMetadata("SecondTypeArg.kt")
    public void testSecondTypeArg() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/SecondTypeArg.kt");
        doTest(fileName);
    }

    @TestMetadata("SpaceAfterParenthesisBug.kt")
    public void testSpaceAfterParenthesisBug() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/SpaceAfterParenthesisBug.kt");
        doTest(fileName);
    }

    @TestMetadata("SuperMethod.kt")
    public void testSuperMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/SuperMethod.kt");
        doTest(fileName);
    }

    @TestMetadata("SuperMethod2.kt")
    public void testSuperMethod2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/SuperMethod2.kt");
        doTest(fileName);
    }

    @TestMetadata("SuperTypeArg.kt")
    public void testSuperTypeArg() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/SuperTypeArg.kt");
        doTest(fileName);
    }

    @TestMetadata("SyntheticExtension.kt")
    public void testSyntheticExtension() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/SyntheticExtension.kt");
        doTest(fileName);
    }

    @TestMetadata("TypeParameter.kt")
    public void testTypeParameter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/TypeParameter.kt");
        doTest(fileName);
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/annotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotation extends AbstractBasicCompletionHandlerTest {
        public void testAllFilesPresentInAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/annotation"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnnotationInBrackets.kt")
        public void testAnnotationInBrackets() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/annotation/AnnotationInBrackets.kt");
            doTest(fileName);
        }

        @TestMetadata("AnnotationInClassAddImport.kt")
        public void testAnnotationInClassAddImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/annotation/AnnotationInClassAddImport.kt");
            doTest(fileName);
        }

        @TestMetadata("AnnotationInCompanionObjectAddImport.kt")
        public void testAnnotationInCompanionObjectAddImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/annotation/AnnotationInCompanionObjectAddImport.kt");
            doTest(fileName);
        }

        @TestMetadata("KT12077.kt")
        public void testKT12077() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/annotation/KT12077.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractBasicCompletionHandlerTest {
        public void testAllFilesPresentInCallableReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ClassConstructor.kt")
        public void testClassConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/callableReference/ClassConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyQualifier.kt")
        public void testEmptyQualifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/callableReference/EmptyQualifier.kt");
            doTest(fileName);
        }

        @TestMetadata("NonEmptyQualifier.kt")
        public void testNonEmptyQualifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/callableReference/NonEmptyQualifier.kt");
            doTest(fileName);
        }

        @TestMetadata("NotImportedTopLevel.kt")
        public void testNotImportedTopLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/callableReference/NotImportedTopLevel.kt");
            doTest(fileName);
        }

        @TestMetadata("Property.kt")
        public void testProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/callableReference/Property.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/exclChar")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExclChar extends AbstractBasicCompletionHandlerTest {
        @TestMetadata("1.kt")
        public void test1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/exclChar/1.kt");
            doTest(fileName);
        }

        @TestMetadata("2.kt")
        public void test2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/exclChar/2.kt");
            doTest(fileName);
        }

        @TestMetadata("3.kt")
        public void test3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/exclChar/3.kt");
            doTest(fileName);
        }

        @TestMetadata("4.kt")
        public void test4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/exclChar/4.kt");
            doTest(fileName);
        }

        @TestMetadata("5.kt")
        public void test5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/exclChar/5.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInExclChar() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/exclChar"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class HighOrderFunctions extends AbstractBasicCompletionHandlerTest {
        public void testAllFilesPresentInHighOrderFunctions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/highOrderFunctions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ContextVariable.kt")
        public void testContextVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/ContextVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("ContextVariableDot.kt")
        public void testContextVariableDot() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/ContextVariableDot.kt");
            doTest(fileName);
        }

        @TestMetadata("ContextVariableTypeArgsNeeded.kt")
        public void testContextVariableTypeArgsNeeded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/ContextVariableTypeArgsNeeded.kt");
            doTest(fileName);
        }

        @TestMetadata("ForceParenthesisForTabChar.kt")
        public void testForceParenthesisForTabChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/ForceParenthesisForTabChar.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionLiteralInsertOnSpace.kt")
        public void testFunctionLiteralInsertOnSpace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/FunctionLiteralInsertOnSpace.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionLiteralInsertWhenNoSpacesForBraces.kt")
        public void testFunctionLiteralInsertWhenNoSpacesForBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/FunctionLiteralInsertWhenNoSpacesForBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("HigherOrderFunction.kt")
        public void testHigherOrderFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/HigherOrderFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("HigherOrderFunctionWithArg.kt")
        public void testHigherOrderFunctionWithArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/HigherOrderFunctionWithArg.kt");
            doTest(fileName);
        }

        @TestMetadata("HigherOrderFunctionWithArgs1.kt")
        public void testHigherOrderFunctionWithArgs1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/HigherOrderFunctionWithArgs1.kt");
            doTest(fileName);
        }

        @TestMetadata("HigherOrderFunctionWithArgs2.kt")
        public void testHigherOrderFunctionWithArgs2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/HigherOrderFunctionWithArgs2.kt");
            doTest(fileName);
        }

        @TestMetadata("HigherOrderFunctionWithArgs3.kt")
        public void testHigherOrderFunctionWithArgs3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/HigherOrderFunctionWithArgs3.kt");
            doTest(fileName);
        }

        @TestMetadata("InsertFunctionWithSingleParameterWithBrace.kt")
        public void testInsertFunctionWithSingleParameterWithBrace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/InsertFunctionWithSingleParameterWithBrace.kt");
            doTest(fileName);
        }

        @TestMetadata("OptionalParameters1.kt")
        public void testOptionalParameters1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/OptionalParameters1.kt");
            doTest(fileName);
        }

        @TestMetadata("OptionalParameters2.kt")
        public void testOptionalParameters2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/OptionalParameters2.kt");
            doTest(fileName);
        }

        @TestMetadata("OptionalParameters3.kt")
        public void testOptionalParameters3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/OptionalParameters3.kt");
            doTest(fileName);
        }

        @TestMetadata("ParameterTypeIsDerivedFromFunction.kt")
        public void testParameterTypeIsDerivedFromFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/ParameterTypeIsDerivedFromFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("ReplaceByLambdaTemplateNoClosingParenth.kt")
        public void testReplaceByLambdaTemplateNoClosingParenth() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/ReplaceByLambdaTemplateNoClosingParenth.kt");
            doTest(fileName);
        }

        @TestMetadata("WithArgsEmptyLambdaAfter.kt")
        public void testWithArgsEmptyLambdaAfter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/WithArgsEmptyLambdaAfter.kt");
            doTest(fileName);
        }

        @TestMetadata("WithArgsNonEmptyLambdaAfter.kt")
        public void testWithArgsNonEmptyLambdaAfter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/highOrderFunctions/WithArgsNonEmptyLambdaAfter.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/override")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Override extends AbstractBasicCompletionHandlerTest {
        @TestMetadata("AfterFunKeyword.kt")
        public void testAfterFunKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/AfterFunKeyword.kt");
            doTest(fileName);
        }

        @TestMetadata("AfterFunKeywordKeepModifiersBefore.kt")
        public void testAfterFunKeywordKeepModifiersBefore() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/AfterFunKeywordKeepModifiersBefore.kt");
            doTest(fileName);
        }

        @TestMetadata("AfterValKeyword.kt")
        public void testAfterValKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/AfterValKeyword.kt");
            doTest(fileName);
        }

        @TestMetadata("AfterValKeywordInConstructorParameter.kt")
        public void testAfterValKeywordInConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/AfterValKeywordInConstructorParameter.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInOverride() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/override"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ImplementFunction.kt")
        public void testImplementFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/ImplementFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("ImplementVal.kt")
        public void testImplementVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/ImplementVal.kt");
            doTest(fileName);
        }

        @TestMetadata("ImplementVar.kt")
        public void testImplementVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/ImplementVar.kt");
            doTest(fileName);
        }

        @TestMetadata("KeepAnnotationBefore.kt")
        public void testKeepAnnotationBefore() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/KeepAnnotationBefore.kt");
            doTest(fileName);
        }

        @TestMetadata("KeepModifiersBefore.kt")
        public void testKeepModifiersBefore() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/KeepModifiersBefore.kt");
            doTest(fileName);
        }

        @TestMetadata("OverrideFunction.kt")
        public void testOverrideFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/OverrideFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("OverrideVar.kt")
        public void testOverrideVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/OverrideVar.kt");
            doTest(fileName);
        }

        @TestMetadata("PublicValInConstructorParameter.kt")
        public void testPublicValInConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/PublicValInConstructorParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("TypeFunctionName.kt")
        public void testTypeFunctionName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/TypeFunctionName.kt");
            doTest(fileName);
        }

        @TestMetadata("TypeNameInConstructorParameter.kt")
        public void testTypeNameInConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/TypeNameInConstructorParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("ValInConstructorParameter.kt")
        public void testValInConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/ValInConstructorParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("ValInConstructorParameter2.kt")
        public void testValInConstructorParameter2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/ValInConstructorParameter2.kt");
            doTest(fileName);
        }

        @TestMetadata("ValInConstructorParameter3.kt")
        public void testValInConstructorParameter3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/ValInConstructorParameter3.kt");
            doTest(fileName);
        }

        @TestMetadata("ValInConstructorParameter4.kt")
        public void testValInConstructorParameter4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/override/ValInConstructorParameter4.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ParameterNameAndType extends AbstractBasicCompletionHandlerTest {
        public void testAllFilesPresentInParameterNameAndType() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/parameterNameAndType"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("CodeStyleSettings.kt")
        public void testCodeStyleSettings() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/CodeStyleSettings.kt");
            doTest(fileName);
        }

        @TestMetadata("Comma.kt")
        public void testComma() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/Comma.kt");
            doTest(fileName);
        }

        @TestMetadata("InsertImport.kt")
        public void testInsertImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/InsertImport.kt");
            doTest(fileName);
        }

        @TestMetadata("NoInsertionOnTypingColon.kt")
        public void testNoInsertionOnTypingColon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/NoInsertionOnTypingColon.kt");
            doTest(fileName);
        }

        @TestMetadata("NoInsertionOnTypingSpace.kt")
        public void testNoInsertionOnTypingSpace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/NoInsertionOnTypingSpace.kt");
            doTest(fileName);
        }

        @TestMetadata("ParameterInFile.kt")
        public void testParameterInFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/ParameterInFile.kt");
            doTest(fileName);
        }

        @TestMetadata("ParameterInFile2.kt")
        public void testParameterInFile2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/ParameterInFile2.kt");
            doTest(fileName);
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/Simple.kt");
            doTest(fileName);
        }

        @TestMetadata("TabReplace1.kt")
        public void testTabReplace1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/TabReplace1.kt");
            doTest(fileName);
        }

        @TestMetadata("TabReplace2.kt")
        public void testTabReplace2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/TabReplace2.kt");
            doTest(fileName);
        }

        @TestMetadata("TypeParameter.kt")
        public void testTypeParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/TypeParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("UserPrefix.kt")
        public void testUserPrefix() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/parameterNameAndType/UserPrefix.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/staticMembers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StaticMembers extends AbstractBasicCompletionHandlerTest {
        public void testAllFilesPresentInStaticMembers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/staticMembers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classObjectMethod.kt")
        public void testClassObjectMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/staticMembers/classObjectMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("ImportFromCompanionObject.kt")
        public void testImportFromCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/staticMembers/ImportFromCompanionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("ImportJavaStaticMethod.kt")
        public void testImportJavaStaticMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/staticMembers/ImportJavaStaticMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("JavaStaticMethod.kt")
        public void testJavaStaticMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/staticMembers/JavaStaticMethod.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StringTemplate extends AbstractBasicCompletionHandlerTest {
        @TestMetadata("1.kt")
        public void test1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/1.kt");
            doTest(fileName);
        }

        @TestMetadata("2.kt")
        public void test2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/2.kt");
            doTest(fileName);
        }

        @TestMetadata("3.kt")
        public void test3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/3.kt");
            doTest(fileName);
        }

        @TestMetadata("4.kt")
        public void test4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/4.kt");
            doTest(fileName);
        }

        @TestMetadata("AfterDot1.kt")
        public void testAfterDot1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/AfterDot1.kt");
            doTest(fileName);
        }

        @TestMetadata("AfterDot2.kt")
        public void testAfterDot2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/AfterDot2.kt");
            doTest(fileName);
        }

        @TestMetadata("AfterDot3.kt")
        public void testAfterDot3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/AfterDot3.kt");
            doTest(fileName);
        }

        @TestMetadata("AfterThisDot.kt")
        public void testAfterThisDot() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/AfterThisDot.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/stringTemplate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("GlobalVal.kt")
        public void testGlobalVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/GlobalVal.kt");
            doTest(fileName);
        }

        @TestMetadata("GlobalValInCurlyBraces.kt")
        public void testGlobalValInCurlyBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/GlobalValInCurlyBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("InsertCurlyBracesBeforeLetter.kt")
        public void testInsertCurlyBracesBeforeLetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/InsertCurlyBracesBeforeLetter.kt");
            doTest(fileName);
        }

        @TestMetadata("NotEmptyPrefix.kt")
        public void testNotEmptyPrefix() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/NotEmptyPrefix.kt");
            doTest(fileName);
        }

        @TestMetadata("Replace.kt")
        public void testReplace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/Replace.kt");
            doTest(fileName);
        }

        @TestMetadata("ValInObject.kt")
        public void testValInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/stringTemplate/ValInObject.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeArgsForCall extends AbstractBasicCompletionHandlerTest {
        @TestMetadata("AfterElse.kt")
        public void testAfterElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/AfterElse.kt");
            doTest(fileName);
        }

        @TestMetadata("AfterElvis.kt")
        public void testAfterElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/AfterElvis.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInTypeArgsForCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/basic/typeArgsForCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ExpectedTypeDoesNotHelp.kt")
        public void testExpectedTypeDoesNotHelp() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/ExpectedTypeDoesNotHelp.kt");
            doTest(fileName);
        }

        @TestMetadata("ExpectedTypeDoesNotHelp2.kt")
        public void testExpectedTypeDoesNotHelp2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/ExpectedTypeDoesNotHelp2.kt");
            doTest(fileName);
        }

        @TestMetadata("ExplicitLambdaSignature.kt")
        public void testExplicitLambdaSignature() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/ExplicitLambdaSignature.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionTypeParameter1.kt")
        public void testFunctionTypeParameter1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/FunctionTypeParameter1.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionTypeParameter2.kt")
        public void testFunctionTypeParameter2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/FunctionTypeParameter2.kt");
            doTest(fileName);
        }

        @TestMetadata("HasExpectedType.kt")
        public void testHasExpectedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/HasExpectedType.kt");
            doTest(fileName);
        }

        @TestMetadata("NotAllTypeArgumentsFromParameters.kt")
        public void testNotAllTypeArgumentsFromParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/NotAllTypeArgumentsFromParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("ReplaceByTab1.kt")
        public void testReplaceByTab1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/ReplaceByTab1.kt");
            doTest(fileName);
        }

        @TestMetadata("ReplaceByTab2.kt")
        public void testReplaceByTab2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/ReplaceByTab2.kt");
            doTest(fileName);
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/Simple.kt");
            doTest(fileName);
        }

        @TestMetadata("TypeArgumentsFromParameters.kt")
        public void testTypeArgumentsFromParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/basic/typeArgsForCall/TypeArgumentsFromParameters.kt");
            doTest(fileName);
        }
    }
}
