/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.completion.test.handlers;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/idea-completion/testData/handlers/charFilter")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class CompletionCharFilterTestGenerated extends AbstractCompletionCharFilterTest {
    public void testAllFilesPresentInCharFilter() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/charFilter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("Colon.kt")
    public void testColon() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Colon.kt");
        doTest(fileName);
    }

    @TestMetadata("Comma1.kt")
    public void testComma1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Comma1.kt");
        doTest(fileName);
    }

    @TestMetadata("Comma2.kt")
    public void testComma2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Comma2.kt");
        doTest(fileName);
    }

    @TestMetadata("Comma3.kt")
    public void testComma3() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Comma3.kt");
        doTest(fileName);
    }

    @TestMetadata("Comma4.kt")
    public void testComma4() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Comma4.kt");
        doTest(fileName);
    }

    @TestMetadata("Comma5.kt")
    public void testComma5() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Comma5.kt");
        doTest(fileName);
    }

    @TestMetadata("CommaForFunction1.kt")
    public void testCommaForFunction1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/CommaForFunction1.kt");
        doTest(fileName);
    }

    @TestMetadata("CommaForFunction2.kt")
    public void testCommaForFunction2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/CommaForFunction2.kt");
        doTest(fileName);
    }

    @TestMetadata("ConstructorWithLambdaArg1.kt")
    public void testConstructorWithLambdaArg1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/ConstructorWithLambdaArg1.kt");
        doTest(fileName);
    }

    @TestMetadata("ConstructorWithLambdaArg2.kt")
    public void testConstructorWithLambdaArg2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/ConstructorWithLambdaArg2.kt");
        doTest(fileName);
    }

    @TestMetadata("Dot.kt")
    public void testDot() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Dot.kt");
        doTest(fileName);
    }

    @TestMetadata("DotAfterFun1.kt")
    public void testDotAfterFun1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/DotAfterFun1.kt");
        doTest(fileName);
    }

    @TestMetadata("DotAfterFun2.kt")
    public void testDotAfterFun2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/DotAfterFun2.kt");
        doTest(fileName);
    }

    @TestMetadata("Eq1.kt")
    public void testEq1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Eq1.kt");
        doTest(fileName);
    }

    @TestMetadata("Eq2.kt")
    public void testEq2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Eq2.kt");
        doTest(fileName);
    }

    @TestMetadata("FunctionLiteralParameter1.kt")
    public void testFunctionLiteralParameter1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/FunctionLiteralParameter1.kt");
        doTest(fileName);
    }

    @TestMetadata("FunctionLiteralParameter2.kt")
    public void testFunctionLiteralParameter2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/FunctionLiteralParameter2.kt");
        doTest(fileName);
    }

    @TestMetadata("FunctionLiteralParameter3.kt")
    public void testFunctionLiteralParameter3() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/FunctionLiteralParameter3.kt");
        doTest(fileName);
    }

    @TestMetadata("FunctionWithLambdaArg1.kt")
    public void testFunctionWithLambdaArg1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/FunctionWithLambdaArg1.kt");
        doTest(fileName);
    }

    @TestMetadata("FunctionWithLambdaArg2.kt")
    public void testFunctionWithLambdaArg2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/FunctionWithLambdaArg2.kt");
        doTest(fileName);
    }

    @TestMetadata("InfixCallAndSpace.kt")
    public void testInfixCallAndSpace() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/InfixCallAndSpace.kt");
        doTest(fileName);
    }

    @TestMetadata("KeywordAndSpace.kt")
    public void testKeywordAndSpace() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/KeywordAndSpace.kt");
        doTest(fileName);
    }

    @TestMetadata("LParenth.kt")
    public void testLParenth() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/LParenth.kt");
        doTest(fileName);
    }

    @TestMetadata("NamedParameter1.kt")
    public void testNamedParameter1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/NamedParameter1.kt");
        doTest(fileName);
    }

    @TestMetadata("NamedParameter2.kt")
    public void testNamedParameter2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/NamedParameter2.kt");
        doTest(fileName);
    }

    @TestMetadata("QualifiedThis.kt")
    public void testQualifiedThis() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/QualifiedThis.kt");
        doTest(fileName);
    }

    @TestMetadata("RangeTyping.kt")
    public void testRangeTyping() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/RangeTyping.kt");
        doTest(fileName);
    }

    @TestMetadata("Space.kt")
    public void testSpace() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/charFilter/Space.kt");
        doTest(fileName);
    }
}
