/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.maven;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/idea-maven/testData/maven-inspections")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class KotlinMavenInspectionTestGenerated extends AbstractKotlinMavenInspectionTest {
    public void testAllFilesPresentInMaven_inspections() throws Exception {
        KotlinTestUtils.assertAllTestsPresentInSingleGeneratedClass(this.getClass(), new File("idea/idea-maven/testData/maven-inspections"), Pattern.compile("^([\\w\\-]+).xml$"), TargetBackend.ANY);
    }

    @TestMetadata("bothCompileAndTestCompileInTheSameExecution.xml")
    public void testBothCompileAndTestCompileInTheSameExecution() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/bothCompileAndTestCompileInTheSameExecution.xml");
        doTest(fileName);
    }

    @TestMetadata("dependencyWithNoExecution.xml")
    public void testDependencyWithNoExecution() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/dependencyWithNoExecution.xml");
        doTest(fileName);
    }

    @TestMetadata("ideAndMavenVersions.xml")
    public void testIdeAndMavenVersions() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/ideAndMavenVersions.xml");
        doTest(fileName);
    }

    @TestMetadata("ideAndMavenVersionsSuppression.xml")
    public void testIdeAndMavenVersionsSuppression() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/ideAndMavenVersionsSuppression.xml");
        doTest(fileName);
    }

    @TestMetadata("kotlinTestWithJunit.xml")
    public void testKotlinTestWithJunit() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/kotlinTestWithJunit.xml");
        doTest(fileName);
    }

    @TestMetadata("missingDependencies.xml")
    public void testMissingDependencies() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/missingDependencies.xml");
        doTest(fileName);
    }

    @TestMetadata("noExecutions.xml")
    public void testNoExecutions() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/noExecutions.xml");
        doTest(fileName);
    }

    @TestMetadata("sameVersionPluginLibrary.xml")
    public void testSameVersionPluginLibrary() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/sameVersionPluginLibrary.xml");
        doTest(fileName);
    }

    @TestMetadata("sameVersionPluginLibrarySuppression.xml")
    public void testSameVersionPluginLibrarySuppression() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/sameVersionPluginLibrarySuppression.xml");
        doTest(fileName);
    }

    @TestMetadata("wrongJsExecution.xml")
    public void testWrongJsExecution() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/wrongJsExecution.xml");
        doTest(fileName);
    }

    @TestMetadata("wrongPhaseExecution.xml")
    public void testWrongPhaseExecution() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-maven/testData/maven-inspections/wrongPhaseExecution.xml");
        doTest(fileName);
    }
}
