/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.findUsages;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class FindUsagesTestGenerated extends AbstractFindUsagesTest {
    @TestMetadata("idea/testData/findUsages/kotlin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Kotlin extends AbstractFindUsagesTest {
        public void testAllFilesPresentInKotlin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/findUsages/kotlin/companionObject")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompanionObject extends AbstractFindUsagesTest {
            public void testAllFilesPresentInCompanionObject() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/companionObject"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inContainingClass.0.kt")
            public void testInContainingClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/companionObject/inContainingClass.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaUsage.0.kt")
            public void testJavaUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/companionObject/javaUsage.0.kt");
                doTest(fileName);
            }

            @TestMetadata("named.0.kt")
            public void testNamed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/companionObject/named.0.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.0.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/companionObject/simple.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/conventions")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Conventions extends AbstractFindUsagesTest {
            public void testAllFilesPresentInConventions() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/conventions"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compareTo.0.kt")
            public void testCompareTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/compareTo.0.kt");
                doTest(fileName);
            }

            @TestMetadata("contains.0.kt")
            public void testContains() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/contains.0.kt");
                doTest(fileName);
            }

            @TestMetadata("equals.0.kt")
            public void testEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/equals.0.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsNotAny.0.kt")
            public void testEqualsNotAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/equalsNotAny.0.kt");
                doTest(fileName);
            }

            @TestMetadata("forIteration.0.kt")
            public void testForIteration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/forIteration.0.kt");
                doTest(fileName);
            }

            @TestMetadata("get.0.kt")
            public void testGet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/get.0.kt");
                doTest(fileName);
            }

            @TestMetadata("getAsPropertyDelegate.0.kt")
            public void testGetAsPropertyDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/getAsPropertyDelegate.0.kt");
                doTest(fileName);
            }

            @TestMetadata("inc.0.kt")
            public void testInc() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/inc.0.kt");
                doTest(fileName);
            }

            @TestMetadata("invoke.0.kt")
            public void testInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/invoke.0.kt");
                doTest(fileName);
            }

            @TestMetadata("plus.0.kt")
            public void testPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/plus.0.kt");
                doTest(fileName);
            }

            @TestMetadata("plusAssign.0.kt")
            public void testPlusAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/plusAssign.0.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyDelegatedFunction.0.kt")
            public void testPropertyDelegatedFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/propertyDelegatedFunction.0.kt");
                doTest(fileName);
            }

            @TestMetadata("set.0.kt")
            public void testSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/set.0.kt");
                doTest(fileName);
            }

            @TestMetadata("setAsPropertyDelegate.0.kt")
            public void testSetAsPropertyDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/setAsPropertyDelegate.0.kt");
                doTest(fileName);
            }

            @TestMetadata("unaryMinus.0.kt")
            public void testUnaryMinus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/unaryMinus.0.kt");
                doTest(fileName);
            }

            @TestMetadata("idea/testData/findUsages/kotlin/conventions/components")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Components extends AbstractFindUsagesTest {
                public void testAllFilesPresentInComponents() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/conventions/components"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("callableReferences.0.kt")
                public void testCallableReferences() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/callableReferences.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("companionObjectAccess.0.kt")
                public void testCompanionObjectAccess() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/companionObjectAccess.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("componentFunForGenericType1.0.kt")
                public void testComponentFunForGenericType1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/componentFunForGenericType1.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("componentFunForGenericType2.0.kt")
                public void testComponentFunForGenericType2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/componentFunForGenericType2.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("dataClass.0.kt")
                public void testDataClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/dataClass.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("dataClassComponentByRef.0.kt")
                public void testDataClassComponentByRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/dataClassComponentByRef.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("dataClassFromStdlib.0.kt")
                public void testDataClassFromStdlib() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/dataClassFromStdlib.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("dataClassInsideDataClass.0.kt")
                public void testDataClassInsideDataClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/dataClassInsideDataClass.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionComponentFun.0.kt")
                public void testExtensionComponentFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/extensionComponentFun.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("for.0.kt")
                public void testFor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/for.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("isAndAs.0.kt")
                public void testIsAndAs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/isAndAs.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("lambdas.0.kt")
                public void testLambdas() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/lambdas.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("mayTypeAffectAncestors.0.kt")
                public void testMayTypeAffectAncestors() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/mayTypeAffectAncestors.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberComponentFun.0.kt")
                public void testMemberComponentFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/memberComponentFun.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("operators.0.kt")
                public void testOperators() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/operators.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveDataClass1.0.kt")
                public void testRecursiveDataClass1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/recursiveDataClass1.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveDataClass2.0.kt")
                public void testRecursiveDataClass2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/recursiveDataClass2.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("SAM.0.kt")
                public void testSAM() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/SAM.0.kt");
                    doTest(fileName);
                }

                @TestMetadata("when.0.kt")
                public void testWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/conventions/components/when.0.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findClassUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindClassUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindClassUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findClassUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classUsedInPlainText.0.kt")
            public void testClassUsedInPlainText() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/classUsedInPlainText.0.kt");
                doTest(fileName);
            }

            @TestMetadata("classUsedInTextAsRef.0.kt")
            public void testClassUsedInTextAsRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/classUsedInTextAsRef.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassAllUsages.0.kt")
            public void testJavaClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaClassAllUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassConstructorUsages.0.kt")
            public void testJavaClassConstructorUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaClassConstructorUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassFunctionUsages1.0.kt")
            public void testJavaClassFunctionUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaClassFunctionUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassFunctionUsages2.0.kt")
            public void testJavaClassFunctionUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaClassFunctionUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassNonConstructorUsages.0.kt")
            public void testJavaClassNonConstructorUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaClassNonConstructorUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassPropertyUsages1.0.kt")
            public void testJavaClassPropertyUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaClassPropertyUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassPropertyUsages2.0.kt")
            public void testJavaClassPropertyUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaClassPropertyUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassSecondaryCtrUsages.0.kt")
            public void testJavaClassSecondaryCtrUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaClassSecondaryCtrUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaDerivedClassUsages1.0.kt")
            public void testJavaDerivedClassUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaDerivedClassUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaDerivedClassUsages2.0.kt")
            public void testJavaDerivedClassUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaDerivedClassUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaDerivedInterfaceUsages1.0.kt")
            public void testJavaDerivedInterfaceUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaDerivedInterfaceUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaDerivedInterfaceUsages2.0.kt")
            public void testJavaDerivedInterfaceUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/javaDerivedInterfaceUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassAllUsages.0.kt")
            public void testKotlinClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassAllUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassAllUsages2.0.kt")
            public void testKotlinClassAllUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassAllUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassAllUsages3.0.kt")
            public void testKotlinClassAllUsages3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassAllUsages3.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassAllUsagesNoImport.0.kt")
            public void testKotlinClassAllUsagesNoImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassAllUsagesNoImport.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassConstructorUsages.0.kt")
            public void testKotlinClassConstructorUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassConstructorUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedAnonymousObjects.0.kt")
            public void testKotlinClassDerivedAnonymousObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedAnonymousObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedClasses.0.kt")
            public void testKotlinClassDerivedClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedClasses.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedInnerClasses.0.kt")
            public void testKotlinClassDerivedInnerClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedInnerClasses.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedInnerObjects.0.kt")
            public void testKotlinClassDerivedInnerObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedInnerObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedLocalClasses.0.kt")
            public void testKotlinClassDerivedLocalClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedLocalClasses.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedLocalObjects.0.kt")
            public void testKotlinClassDerivedLocalObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedLocalObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedLocalTraits.0.kt")
            public void testKotlinClassDerivedLocalTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedLocalTraits.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedObjects.0.kt")
            public void testKotlinClassDerivedObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassDerivedTraits.0.kt")
            public void testKotlinClassDerivedTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassDerivedTraits.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassFunctionUsages1.0.kt")
            public void testKotlinClassFunctionUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassFunctionUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassFunctionUsages2.0.kt")
            public void testKotlinClassFunctionUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassFunctionUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassNonConstructorUsages.0.kt")
            public void testKotlinClassNonConstructorUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassNonConstructorUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassPropertyUsages1.0.kt")
            public void testKotlinClassPropertyUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassPropertyUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassPropertyUsages2.0.kt")
            public void testKotlinClassPropertyUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassPropertyUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassSecondaryCtorUsages.0.kt")
            public void testKotlinClassSecondaryCtorUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinClassSecondaryCtorUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinDeeplyNestedClassAllUsages.0.kt")
            public void testKotlinDeeplyNestedClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinDeeplyNestedClassAllUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinInnerClassAllUsages.0.kt")
            public void testKotlinInnerClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinInnerClassAllUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalClassDerivedAnonymousObjects.0.kt")
            public void testKotlinLocalClassDerivedAnonymousObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassDerivedAnonymousObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalClassDerivedLocalClasses.0.kt")
            public void testKotlinLocalClassDerivedLocalClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassDerivedLocalClasses.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalClassDerivedLocalObjects.0.kt")
            public void testKotlinLocalClassDerivedLocalObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassDerivedLocalObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalClassDerivedLocalTraits.0.kt")
            public void testKotlinLocalClassDerivedLocalTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassDerivedLocalTraits.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalClassUsages1.0.kt")
            public void testKotlinLocalClassUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalClassUsages2.0.kt")
            public void testKotlinLocalClassUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinLocalClassUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinNestedClassAllUsages.0.kt")
            public void testKotlinNestedClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinNestedClassAllUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPrivateClassUsages.0.kt")
            public void testKotlinPrivateClassUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinPrivateClassUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedAnonymousObjects.0.kt")
            public void testKotlinTraitDerivedAnonymousObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedAnonymousObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedClasses.0.kt")
            public void testKotlinTraitDerivedClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedClasses.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedInnerClasses.0.kt")
            public void testKotlinTraitDerivedInnerClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedInnerClasses.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedInnerObjects.0.kt")
            public void testKotlinTraitDerivedInnerObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedInnerObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedLocalClasses.0.kt")
            public void testKotlinTraitDerivedLocalClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedLocalClasses.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedLocalObjects.0.kt")
            public void testKotlinTraitDerivedLocalObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedLocalObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedLocalTraits.0.kt")
            public void testKotlinTraitDerivedLocalTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedLocalTraits.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedObjects.0.kt")
            public void testKotlinTraitDerivedObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedObjects.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitDerivedTraits.0.kt")
            public void testKotlinTraitDerivedTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/kotlinTraitDerivedTraits.0.kt");
                doTest(fileName);
            }

            @TestMetadata("localAndNonLocalClass.0.kt")
            public void testLocalAndNonLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/localAndNonLocalClass.0.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructorWithDefaultParams.0.kt")
            public void testPrimaryConstructorWithDefaultParams() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/primaryConstructorWithDefaultParams.0.kt");
                doTest(fileName);
            }

            @TestMetadata("usageInTypeAlias.0.kt")
            public void testUsageInTypeAlias() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findClassUsages/usageInTypeAlias.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findFunctionUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindFunctionUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindFunctionUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findFunctionUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumFunctionUsages.0.kt")
            public void testEnumFunctionUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/enumFunctionUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("functionUsedInPlainText.0.kt")
            public void testFunctionUsedInPlainText() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/functionUsedInPlainText.0.kt");
                doTest(fileName);
            }

            @TestMetadata("highlightingOfSuperUsages.0.kt")
            public void testHighlightingOfSuperUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/highlightingOfSuperUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaAndKotlinOverrides.0.kt")
            public void testJavaAndKotlinOverrides() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/javaAndKotlinOverrides.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaMethodUsages.0.kt")
            public void testJavaMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/javaMethodUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmOverloaded.0.kt")
            public void testJvmOverloaded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/jvmOverloaded.0.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmStaticFun.0.kt")
            public void testJvmStaticFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/jvmStaticFun.0.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmStaticJvmOverloadsFun.0.kt")
            public void testJvmStaticJvmOverloadsFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/jvmStaticJvmOverloadsFun.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinInternalMethodUsages.0.kt")
            public void testKotlinInternalMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinInternalMethodUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalMethodUsages1.0.kt")
            public void testKotlinLocalMethodUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinLocalMethodUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalMethodUsages2.0.kt")
            public void testKotlinLocalMethodUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinLocalMethodUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinMethodUsages.0.kt")
            public void testKotlinMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinMethodUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinMultiRefInImport.0.kt")
            public void testKotlinMultiRefInImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinMultiRefInImport.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinNestedClassMethodUsages.0.kt")
            public void testKotlinNestedClassMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinNestedClassMethodUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinOverloadAndExtensionUsages.0.kt")
            public void testKotlinOverloadAndExtensionUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinOverloadAndExtensionUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinOverloadAndExtensionUsages2.0.kt")
            public void testKotlinOverloadAndExtensionUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinOverloadAndExtensionUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPrivateMethodUsages.0.kt")
            public void testKotlinPrivateMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinPrivateMethodUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTopLevelMethodUsages.0.kt")
            public void testKotlinTopLevelMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTopLevelMethodUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTopLevelMethodUsagesMultifile.0.kt")
            public void testKotlinTopLevelMethodUsagesMultifile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTopLevelMethodUsagesMultifile.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTopLevelMethodUsagesNoImport.0.kt")
            public void testKotlinTopLevelMethodUsagesNoImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTopLevelMethodUsagesNoImport.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTopLevelMethodUsagesWithRenamedFile.0.kt")
            public void testKotlinTopLevelMethodUsagesWithRenamedFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTopLevelMethodUsagesWithRenamedFile.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitImplThroughDelegate.0.kt")
            public void testKotlinTraitImplThroughDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTraitImplThroughDelegate.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTraitNoImplThroughDelegate.0.kt")
            public void testKotlinTraitNoImplThroughDelegate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/kotlinTraitNoImplThroughDelegate.0.kt");
                doTest(fileName);
            }

            @TestMetadata("localClassMember.0.kt")
            public void testLocalClassMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/localClassMember.0.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExpressionDeepMember.0.kt")
            public void testObjectExpressionDeepMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/objectExpressionDeepMember.0.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExpressionMember.0.kt")
            public void testObjectExpressionMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/objectExpressionMember.0.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExpressionMember2.0.kt")
            public void testObjectExpressionMember2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/objectExpressionMember2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("objectExpressionMemberInClass.0.kt")
            public void testObjectExpressionMemberInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/objectExpressionMemberInClass.0.kt");
                doTest(fileName);
            }

            @TestMetadata("synthesizedFunction.0.kt")
            public void testSynthesizedFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/synthesizedFunction.0.kt");
                doTest(fileName);
            }

            @TestMetadata("usagesOfBaseForFunction.0.kt")
            public void testUsagesOfBaseForFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findFunctionUsages/usagesOfBaseForFunction.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findJavaPropertyUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaPropertyUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindJavaPropertyUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findJavaPropertyUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaPropertyUsagesK.0.kt")
            public void testJavaPropertyUsagesK() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findJavaPropertyUsages/javaPropertyUsagesK.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyUsagesKJK.0.kt")
            public void testJavaPropertyUsagesKJK() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findJavaPropertyUsages/javaPropertyUsagesKJK.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyUsagesKK.0.kt")
            public void testJavaPropertyUsagesKK() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findJavaPropertyUsages/javaPropertyUsagesKK.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findObjectUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindObjectUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindObjectUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findObjectUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaObjectUsages.0.kt")
            public void testJavaObjectUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findObjectUsages/javaObjectUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinImportedObjectUsages.0.kt")
            public void testKotlinImportedObjectUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findObjectUsages/kotlinImportedObjectUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalObjectUsages1.0.kt")
            public void testKotlinLocalObjectUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findObjectUsages/kotlinLocalObjectUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalObjectUsages2.0.kt")
            public void testKotlinLocalObjectUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findObjectUsages/kotlinLocalObjectUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinNestedObjectUsages.0.kt")
            public void testKotlinNestedObjectUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findObjectUsages/kotlinNestedObjectUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinObjectUsages.0.kt")
            public void testKotlinObjectUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findObjectUsages/kotlinObjectUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPrivateObjectUsages.0.kt")
            public void testKotlinPrivateObjectUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findObjectUsages/kotlinPrivateObjectUsages.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findPackageUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindPackageUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindPackageUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findPackageUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinPackageUsages.0.kt")
            public void testKotlinPackageUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPackageUsages/kotlinPackageUsages.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findParameterUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindParameterUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindParameterUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findParameterUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinAnnotationConstructorParameterUsages.0.kt")
            public void testKotlinAnnotationConstructorParameterUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findParameterUsages/kotlinAnnotationConstructorParameterUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinComponentFunctionParameterUsages.0.kt")
            public void testKotlinComponentFunctionParameterUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findParameterUsages/kotlinComponentFunctionParameterUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinConstructorParameterUsages.0.kt")
            public void testKotlinConstructorParameterUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findParameterUsages/kotlinConstructorParameterUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinDefaultAnnotationParameterUsages.0.kt")
            public void testKotlinDefaultAnnotationParameterUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findParameterUsages/kotlinDefaultAnnotationParameterUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinFunctionParameterUsages.0.kt")
            public void testKotlinFunctionParameterUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findParameterUsages/kotlinFunctionParameterUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinHighlightParameterUsages.0.kt")
            public void testKotlinHighlightParameterUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findParameterUsages/kotlinHighlightParameterUsages.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindPrimaryConstructorUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindPrimaryConstructorUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("jvmOverloaded.0.kt")
            public void testJvmOverloaded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/jvmOverloaded.0.kt");
                doTest(fileName);
            }

            @TestMetadata("missingName.0.kt")
            public void testMissingName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/missingName.0.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructorByRef.0.kt")
            public void testPrimaryConstructorByRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/primaryConstructorByRef.0.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructorNoKeyword.0.kt")
            public void testPrimaryConstructorNoKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/primaryConstructorNoKeyword.0.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructorWithKeyword.0.kt")
            public void testPrimaryConstructorWithKeyword() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPrimaryConstructorUsages/primaryConstructorWithKeyword.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findPropertyUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindPropertyUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindPropertyUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findPropertyUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("extensionPropertyUsages.0.kt")
            public void testExtensionPropertyUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/extensionPropertyUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaAndKotlinOverrides.0.kt")
            public void testJavaAndKotlinOverrides() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaAndKotlinOverrides.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaAndKotlinOverrides2.0.kt")
            public void testJavaAndKotlinOverrides2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaAndKotlinOverrides2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaClassObjectPropertyUsages.0.kt")
            public void testJavaClassObjectPropertyUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaClassObjectPropertyUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyReadUsages.0.kt")
            public void testJavaPropertyReadUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyReadUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyReadUsages2.0.kt")
            public void testJavaPropertyReadUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyReadUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyUsages.0.kt")
            public void testJavaPropertyUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyUsages2.0.kt")
            public void testJavaPropertyUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyWriteUsages.0.kt")
            public void testJavaPropertyWriteUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyWriteUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("javaPropertyWriteUsages2.0.kt")
            public void testJavaPropertyWriteUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/javaPropertyWriteUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmStaticProperty.0.kt")
            public void testJvmStaticProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/jvmStaticProperty.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinClassObjectPropertyUsage.0.kt")
            public void testKotlinClassObjectPropertyUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinClassObjectPropertyUsage.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalPropertyUsages1.0.kt")
            public void testKotlinLocalPropertyUsages1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinLocalPropertyUsages1.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinLocalPropertyUsages2.0.kt")
            public void testKotlinLocalPropertyUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinLocalPropertyUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinMultiRefInImport.0.kt")
            public void testKotlinMultiRefInImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinMultiRefInImport.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinNestedClassPropertyUsages.0.kt")
            public void testKotlinNestedClassPropertyUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinNestedClassPropertyUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPrivatePropertyInClassObjectUsages.0.kt")
            public void testKotlinPrivatePropertyInClassObjectUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPrivatePropertyInClassObjectUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPrivatePropertyUsages.0.kt")
            public void testKotlinPrivatePropertyUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPrivatePropertyUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPrivatePropertyUsages2.0.kt")
            public void testKotlinPrivatePropertyUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPrivatePropertyUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertyReadUsages.0.kt")
            public void testKotlinPropertyReadUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyReadUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertyReadUsages2.0.kt")
            public void testKotlinPropertyReadUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyReadUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertySameNameAsMethodUsages.0.kt")
            public void testKotlinPropertySameNameAsMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertySameNameAsMethodUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertyUsages.0.kt")
            public void testKotlinPropertyUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertyUsages2.0.kt")
            public void testKotlinPropertyUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertyWriteUsages.0.kt")
            public void testKotlinPropertyWriteUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyWriteUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertyWriteUsages2.0.kt")
            public void testKotlinPropertyWriteUsages2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinPropertyWriteUsages2.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinTopLevelPropertyUsages.0.kt")
            public void testKotlinTopLevelPropertyUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kotlinTopLevelPropertyUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kt7656.0.kt")
            public void testKt7656() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findPropertyUsages/kt7656.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindSecondaryConstructorUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindSecondaryConstructorUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("defaultSecondaryConstructor.0.kt")
            public void testDefaultSecondaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages/defaultSecondaryConstructor.0.kt");
                doTest(fileName);
            }

            @TestMetadata("jvmOverloaded.0.kt")
            public void testJvmOverloaded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages/jvmOverloaded.0.kt");
                doTest(fileName);
            }

            @TestMetadata("secondaryConstructor.0.kt")
            public void testSecondaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findSecondaryConstructorUsages/secondaryConstructor.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findTypeAliasUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindTypeAliasUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindTypeAliasUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findTypeAliasUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("objectAlias.0.kt")
            public void testObjectAlias() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findTypeAliasUsages/objectAlias.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findTypeParameterUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindTypeParameterUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindTypeParameterUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findTypeParameterUsages"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinClassTypeParameterUsages.0.kt")
            public void testKotlinClassTypeParameterUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findTypeParameterUsages/kotlinClassTypeParameterUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinFunctionTypeParameterUsages.0.kt")
            public void testKotlinFunctionTypeParameterUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findTypeParameterUsages/kotlinFunctionTypeParameterUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyWithTypeParameter.0.kt")
            public void testPropertyWithTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findTypeParameterUsages/propertyWithTypeParameter.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findWithFilteringImports")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindWithFilteringImports extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindWithFilteringImports() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findWithFilteringImports"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("findWithFilteringImports.0.kt")
            public void testFindWithFilteringImports() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findWithFilteringImports/findWithFilteringImports.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/findWithStructuralGrouping")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindWithStructuralGrouping extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindWithStructuralGrouping() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/findWithStructuralGrouping"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kotlinClassAllUsages.0.kt")
            public void testKotlinClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findWithStructuralGrouping/kotlinClassAllUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinMethodUsages.0.kt")
            public void testKotlinMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findWithStructuralGrouping/kotlinMethodUsages.0.kt");
                doTest(fileName);
            }

            @TestMetadata("kotlinPropertyUsages.0.kt")
            public void testKotlinPropertyUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/findWithStructuralGrouping/kotlinPropertyUsages.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/propertyFiles")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PropertyFiles extends AbstractFindUsagesTest {
            public void testAllFilesPresentInPropertyFiles() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/propertyFiles"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("propertyFileUsagesByRef.0.kt")
            public void testPropertyFileUsagesByRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/propertyFiles/propertyFileUsagesByRef.0.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyUsagesByRef.0.kt")
            public void testPropertyUsagesByRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/propertyFiles/propertyUsagesByRef.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/unresolvedAnnotation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnresolvedAnnotation extends AbstractFindUsagesTest {
            public void testAllFilesPresentInUnresolvedAnnotation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/unresolvedAnnotation"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("unresolvedAnnotation.0.kt")
            public void testUnresolvedAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/unresolvedAnnotation/unresolvedAnnotation.0.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/kotlin/variable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Variable extends AbstractFindUsagesTest {
            public void testAllFilesPresentInVariable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/kotlin/variable"), Pattern.compile("^(.+)\\.0\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("plusAssignFun.0.kt")
            public void testPlusAssignFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/variable/plusAssignFun.0.kt");
                doTest(fileName);
            }

            @TestMetadata("readAccess.0.kt")
            public void testReadAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/variable/readAccess.0.kt");
                doTest(fileName);
            }

            @TestMetadata("varInDoWhile.0.kt")
            public void testVarInDoWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/variable/varInDoWhile.0.kt");
                doTest(fileName);
            }

            @TestMetadata("writeAccess.0.kt")
            public void testWriteAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/kotlin/variable/writeAccess.0.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/findUsages/java")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Java extends AbstractFindUsagesTest {
        public void testAllFilesPresentInJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/findUsages/java/findConstructorUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindConstructorUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindConstructorUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findConstructorUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaConstructorInDelegationCall.0.java")
            public void testJavaConstructorInDelegationCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findConstructorUsages/javaConstructorInDelegationCall.0.java");
                doTest(fileName);
            }

            @TestMetadata("javaDefaultConstructorInDelegationCall.0.java")
            public void testJavaDefaultConstructorInDelegationCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findConstructorUsages/javaDefaultConstructorInDelegationCall.0.java");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructorByJavaRef.0.java")
            public void testPrimaryConstructorByJavaRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findConstructorUsages/primaryConstructorByJavaRef.0.java");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructorByJavaSuperRef.0.java")
            public void testPrimaryConstructorByJavaSuperRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findConstructorUsages/primaryConstructorByJavaSuperRef.0.java");
                doTest(fileName);
            }

            @TestMetadata("secondaryConstructorByJavaNewExpression.0.java")
            public void testSecondaryConstructorByJavaNewExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findConstructorUsages/secondaryConstructorByJavaNewExpression.0.java");
                doTest(fileName);
            }

            @TestMetadata("secondaryConstructorByJavaSuperCall.0.java")
            public void testSecondaryConstructorByJavaSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findConstructorUsages/secondaryConstructorByJavaSuperCall.0.java");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/java/findJavaClassUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaClassUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindJavaClassUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findJavaClassUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("JKClassAllUsages.0.java")
            public void testJKClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassAllUsages.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassDerivedAnonymousObjects.0.java")
            public void testJKClassDerivedAnonymousObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedAnonymousObjects.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassDerivedClasses.0.java")
            public void testJKClassDerivedClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedClasses.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassDerivedInnerClasses.0.java")
            public void testJKClassDerivedInnerClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedInnerClasses.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassDerivedInnerObjects.0.java")
            public void testJKClassDerivedInnerObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedInnerObjects.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassDerivedLocalClasses.0.java")
            public void testJKClassDerivedLocalClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedLocalClasses.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassDerivedLocalObjects.0.java")
            public void testJKClassDerivedLocalObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedLocalObjects.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassDerivedObjects.0.java")
            public void testJKClassDerivedObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassDerivedObjects.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassFieldsUsages.0.java")
            public void testJKClassFieldsUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassFieldsUsages.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassMethodsUsages.0.java")
            public void testJKClassMethodsUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassMethodsUsages.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKClassWithImplicitConstructorAllUsages.0.java")
            public void testJKClassWithImplicitConstructorAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKClassWithImplicitConstructorAllUsages.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKDerivedInterfaces.0.java")
            public void testJKDerivedInterfaces() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKDerivedInterfaces.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInnerClassAllUsages.0.java")
            public void testJKInnerClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInnerClassAllUsages.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInterfaceDerivedAnonymousObjects.0.java")
            public void testJKInterfaceDerivedAnonymousObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedAnonymousObjects.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInterfaceDerivedClasses.0.java")
            public void testJKInterfaceDerivedClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedClasses.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInterfaceDerivedInnerClasses.0.java")
            public void testJKInterfaceDerivedInnerClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedInnerClasses.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInterfaceDerivedInnerObjects.0.java")
            public void testJKInterfaceDerivedInnerObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedInnerObjects.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInterfaceDerivedLocalClasses.0.java")
            public void testJKInterfaceDerivedLocalClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedLocalClasses.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInterfaceDerivedLocalObjects.0.java")
            public void testJKInterfaceDerivedLocalObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedLocalObjects.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInterfaceDerivedLocalTraits.0.java")
            public void testJKInterfaceDerivedLocalTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedLocalTraits.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKInterfaceDerivedObjects.0.java")
            public void testJKInterfaceDerivedObjects() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKInterfaceDerivedObjects.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKNestedClassAllUsages.0.java")
            public void testJKNestedClassAllUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaClassUsages/JKNestedClassAllUsages.0.java");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/java/findJavaFieldUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaFieldUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindJavaFieldUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findJavaFieldUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("JKFieldUsages.0.java")
            public void testJKFieldUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaFieldUsages/JKFieldUsages.0.java");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/java/findJavaMethodUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaMethodUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindJavaMethodUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findJavaMethodUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ConventionUsages.0.java")
            public void testConventionUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaMethodUsages/ConventionUsages.0.java");
                doTest(fileName);
            }

            @TestMetadata("defaultJavaAnnotationMethodUsages.0.java")
            public void testDefaultJavaAnnotationMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaMethodUsages/defaultJavaAnnotationMethodUsages.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKMethodOverrides.0.java")
            public void testJKMethodOverrides() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaMethodUsages/JKMethodOverrides.0.java");
                doTest(fileName);
            }

            @TestMetadata("JKMethodUsages.0.java")
            public void testJKMethodUsages() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaMethodUsages/JKMethodUsages.0.java");
                doTest(fileName);
            }

            @TestMetadata("javaComponentFunctions.0.java")
            public void testJavaComponentFunctions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaMethodUsages/javaComponentFunctions.0.java");
                doTest(fileName);
            }

            @TestMetadata("javaInvoke.0.java")
            public void testJavaInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaMethodUsages/javaInvoke.0.java");
                doTest(fileName);
            }

            @TestMetadata("OverriddenMethodSyntheticAccessor.0.java")
            public void testOverriddenMethodSyntheticAccessor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaMethodUsages/OverriddenMethodSyntheticAccessor.0.java");
                doTest(fileName);
            }

            @TestMetadata("SyntheticProperties.0.java")
            public void testSyntheticProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaMethodUsages/SyntheticProperties.0.java");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/findUsages/java/findJavaPropertyUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FindJavaPropertyUsages extends AbstractFindUsagesTest {
            public void testAllFilesPresentInFindJavaPropertyUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/java/findJavaPropertyUsages"), Pattern.compile("^(.+)\\.0\\.java$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaPropertyGetterUsagesKJ.0.java")
            public void testJavaPropertyGetterUsagesKJ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaPropertyUsages/javaPropertyGetterUsagesKJ.0.java");
                doTest(fileName);
            }

            @TestMetadata("javaPropertySetterUsagesKJ.0.java")
            public void testJavaPropertySetterUsagesKJ() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/java/findJavaPropertyUsages/javaPropertySetterUsagesKJ.0.java");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/findUsages/propertyFiles")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PropertyFiles extends AbstractFindUsagesTest {
        public void testAllFilesPresentInPropertyFiles() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/findUsages/propertyFiles"), Pattern.compile("^(.+)\\.0\\.properties$"), TargetBackend.ANY, true);
        }

        @TestMetadata("propertyFileUsages.0.properties")
        public void testPropertyFileUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/propertyFiles/propertyFileUsages.0.properties");
            doTest(fileName);
        }

        @TestMetadata("propertyUsages.0.properties")
        public void testPropertyUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/findUsages/propertyFiles/propertyUsages.0.properties");
            doTest(fileName);
        }
    }
}
