/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.formatter;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class FormatterTestGenerated extends AbstractFormatterTest {
    @TestMetadata("idea/testData/formatter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Formatter extends AbstractFormatterTest {
        @TestMetadata("AfterSemiColonInEnumClass.after.kt")
        public void testAfterSemiColonInEnumClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/AfterSemiColonInEnumClass.after.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInFormatter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnnotationBeforeExpression.after.kt")
        public void testAnnotationBeforeExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/AnnotationBeforeExpression.after.kt");
            doTest(fileName);
        }

        @TestMetadata("AnonymousInitializers.after.kt")
        public void testAnonymousInitializers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/AnonymousInitializers.after.kt");
            doTest(fileName);
        }

        @TestMetadata("AnonymousInitializersLineBreak.after.kt")
        public void testAnonymousInitializersLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/AnonymousInitializersLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ArrayAccess.after.kt")
        public void testArrayAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ArrayAccess.after.kt");
            doTest(fileName);
        }

        @TestMetadata("BinaryExpressionAlignmentSpread.after.kt")
        public void testBinaryExpressionAlignmentSpread() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/BinaryExpressionAlignmentSpread.after.kt");
            doTest(fileName);
        }

        @TestMetadata("BinaryExpressions.after.kt")
        public void testBinaryExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/BinaryExpressions.after.kt");
            doTest(fileName);
        }

        @TestMetadata("BinaryExpressionsBoolean.after.kt")
        public void testBinaryExpressionsBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/BinaryExpressionsBoolean.after.kt");
            doTest(fileName);
        }

        @TestMetadata("BinaryExpressionsWithoutAlignment.after.kt")
        public void testBinaryExpressionsWithoutAlignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/BinaryExpressionsWithoutAlignment.after.kt");
            doTest(fileName);
        }

        @TestMetadata("BlockFor.after.kt")
        public void testBlockFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/BlockFor.after.kt");
            doTest(fileName);
        }

        @TestMetadata("Cast.after.kt")
        public void testCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Cast.after.kt");
            doTest(fileName);
        }

        @TestMetadata("CatchFinallyOnNewLine.after.kt")
        public void testCatchFinallyOnNewLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/CatchFinallyOnNewLine.after.kt");
            doTest(fileName);
        }

        @TestMetadata("Class.after.kt")
        public void testClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Class.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ClassInBody.after.kt")
        public void testClassInBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ClassInBody.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ClassLineBreak.after.kt")
        public void testClassLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ClassLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ClassTypeParam.after.kt")
        public void testClassTypeParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ClassTypeParam.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ColonSpaces.after.kt")
        public void testColonSpaces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ColonSpaces.after.kt");
            doTest(fileName);
        }

        @TestMetadata("CommentInFunctionLiteral.after.kt")
        public void testCommentInFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/CommentInFunctionLiteral.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ConsecutiveCalls.after.kt")
        public void testConsecutiveCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ConsecutiveCalls.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ConsecutiveSafeCallsIndent.after.kt")
        public void testConsecutiveSafeCallsIndent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ConsecutiveSafeCallsIndent.after.kt");
            doTest(fileName);
        }

        @TestMetadata("CurlyBraceStringInterpolation.after.kt")
        public void testCurlyBraceStringInterpolation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/CurlyBraceStringInterpolation.after.kt");
            doTest(fileName);
        }

        @TestMetadata("DelegationList.after.kt")
        public void testDelegationList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/DelegationList.after.kt");
            doTest(fileName);
        }

        @TestMetadata("DoWhileLineBreak.after.kt")
        public void testDoWhileLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/DoWhileLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("DoWhileSpacing.after.kt")
        public void testDoWhileSpacing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/DoWhileSpacing.after.kt");
            doTest(fileName);
        }

        @TestMetadata("DocComments.after.kt")
        public void testDocComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/DocComments.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ElseOnNewLine.after.kt")
        public void testElseOnNewLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ElseOnNewLine.after.kt");
            doTest(fileName);
        }

        @TestMetadata("Elvis.after.kt")
        public void testElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Elvis.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineAfterObjectDeclaration.after.kt")
        public void testEmptyLineAfterObjectDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineAfterObjectDeclaration.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineAfterPackage.after.kt")
        public void testEmptyLineAfterPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineAfterPackage.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineBetweeAbstractFunctions.after.kt")
        public void testEmptyLineBetweeAbstractFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineBetweeAbstractFunctions.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineBetweenClassAndFunction.after.kt")
        public void testEmptyLineBetweenClassAndFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineBetweenClassAndFunction.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineBetweenClasses.after.kt")
        public void testEmptyLineBetweenClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineBetweenClasses.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineBetweenEnumEntries.after.kt")
        public void testEmptyLineBetweenEnumEntries() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineBetweenEnumEntries.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineBetweenFunAndProperty.after.kt")
        public void testEmptyLineBetweenFunAndProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineBetweenFunAndProperty.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineBetweenFunctions.after.kt")
        public void testEmptyLineBetweenFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineBetweenFunctions.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EmptyLineBetweenProperties.after.kt")
        public void testEmptyLineBetweenProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyLineBetweenProperties.after.kt");
            doTest(fileName);
        }

        @TestMetadata("EnumArguments.after.kt")
        public void testEnumArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EnumArguments.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ForLineBreak.after.kt")
        public void testForLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ForLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ForNoBraces.after.kt")
        public void testForNoBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ForNoBraces.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ForSpacing.after.kt")
        public void testForSpacing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ForSpacing.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FormatFirstColumnComments.after.kt")
        public void testFormatFirstColumnComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FormatFirstColumnComments.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FormatFirstColumnCommentsBeforeDeclaration.after.kt")
        public void testFormatFirstColumnCommentsBeforeDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FormatFirstColumnCommentsBeforeDeclaration.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionCallParametersAlign.after.kt")
        public void testFunctionCallParametersAlign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionCallParametersAlign.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionDefParametersAlign.after.kt")
        public void testFunctionDefParametersAlign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionDefParametersAlign.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionExpression.after.kt")
        public void testFunctionExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionExpression.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionLineBreak.after.kt")
        public void testFunctionLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionLiteralsInChainCalls.after.kt")
        public void testFunctionLiteralsInChainCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionLiteralsInChainCalls.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionWithInference.after.kt")
        public void testFunctionWithInference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionWithInference.after.kt");
            doTest(fileName);
        }

        @TestMetadata("FunctionalType.after.kt")
        public void testFunctionalType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionalType.after.kt");
            doTest(fileName);
        }

        @TestMetadata("GetterAndSetter.after.kt")
        public void testGetterAndSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/GetterAndSetter.after.kt");
            doTest(fileName);
        }

        @TestMetadata("If.after.kt")
        public void testIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/If.after.kt");
            doTest(fileName);
        }

        @TestMetadata("IfElseRemoveLineBreak.after.kt")
        public void testIfElseRemoveLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/IfElseRemoveLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("IfElseWithLineBreak.after.kt")
        public void testIfElseWithLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/IfElseWithLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("IfElseWithTrickyComments.after.kt")
        public void testIfElseWithTrickyComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/IfElseWithTrickyComments.after.kt");
            doTest(fileName);
        }

        @TestMetadata("IfSpacing.after.kt")
        public void testIfSpacing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/IfSpacing.after.kt");
            doTest(fileName);
        }

        @TestMetadata("In.after.kt")
        public void testIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/In.after.kt");
            doTest(fileName);
        }

        @TestMetadata("InfixCall.after.kt")
        public void testInfixCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/InfixCall.after.kt");
            doTest(fileName);
        }

        @TestMetadata("Is.after.kt")
        public void testIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Is.after.kt");
            doTest(fileName);
        }

        @TestMetadata("KDoc.after.kt")
        public void testKDoc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/KDoc.after.kt");
            doTest(fileName);
        }

        @TestMetadata("LabeledExpression.after.kt")
        public void testLabeledExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/LabeledExpression.after.kt");
            doTest(fileName);
        }

        @TestMetadata("LambdaArrow.after.kt")
        public void testLambdaArrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/LambdaArrow.after.kt");
            doTest(fileName);
        }

        @TestMetadata("LoopParameterWithExplicitType.after.kt")
        public void testLoopParameterWithExplicitType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/LoopParameterWithExplicitType.after.kt");
            doTest(fileName);
        }

        @TestMetadata("MethodCall.after.kt")
        public void testMethodCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/MethodCall.after.kt");
            doTest(fileName);
        }

        @TestMetadata("Multideclaration.after.kt")
        public void testMultideclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Multideclaration.after.kt");
            doTest(fileName);
        }

        @TestMetadata("MultilineFunctionLiteral.after.kt")
        public void testMultilineFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/MultilineFunctionLiteral.after.kt");
            doTest(fileName);
        }

        @TestMetadata("MultilineFunctionLiteralWithParams.after.kt")
        public void testMultilineFunctionLiteralWithParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/MultilineFunctionLiteralWithParams.after.kt");
            doTest(fileName);
        }

        @TestMetadata("NewLineForRBrace.after.kt")
        public void testNewLineForRBrace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/NewLineForRBrace.after.kt");
            doTest(fileName);
        }

        @TestMetadata("NotIn.after.kt")
        public void testNotIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/NotIn.after.kt");
            doTest(fileName);
        }

        @TestMetadata("NotIs.after.kt")
        public void testNotIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/NotIs.after.kt");
            doTest(fileName);
        }

        @TestMetadata("NullableType.after.kt")
        public void testNullableType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/NullableType.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ObjectInBody.after.kt")
        public void testObjectInBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ObjectInBody.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ParameterDocComments.after.kt")
        public void testParameterDocComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ParameterDocComments.after.kt");
            doTest(fileName);
        }

        @TestMetadata("Parameters.after.kt")
        public void testParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Parameters.after.kt");
            doTest(fileName);
        }

        @TestMetadata("PrimaryConstructor.after.kt")
        public void testPrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/PrimaryConstructor.after.kt");
            doTest(fileName);
        }

        @TestMetadata("PropertyAccessors.after.kt")
        public void testPropertyAccessors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/PropertyAccessors.after.kt");
            doTest(fileName);
        }

        @TestMetadata("PropertyTypeParameterList.after.kt")
        public void testPropertyTypeParameterList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/PropertyTypeParameterList.after.kt");
            doTest(fileName);
        }

        @TestMetadata("PropertyWithInference.after.kt")
        public void testPropertyWithInference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/PropertyWithInference.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ReferenceExpressionFunctionLiteral.after.kt")
        public void testReferenceExpressionFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ReferenceExpressionFunctionLiteral.after.kt");
            doTest(fileName);
        }

        @TestMetadata("RemoveSpacesAroundOperations.after.kt")
        public void testRemoveSpacesAroundOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/RemoveSpacesAroundOperations.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ReturnExpression.after.kt")
        public void testReturnExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ReturnExpression.after.kt");
            doTest(fileName);
        }

        @TestMetadata("RightBracketOnNewLine.after.kt")
        public void testRightBracketOnNewLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/RightBracketOnNewLine.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SaveSpacesInDocComments.after.kt")
        public void testSaveSpacesInDocComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SaveSpacesInDocComments.after.kt");
            doTest(fileName);
        }

        @TestMetadata("Script.after.kts")
        public void testScript() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Script.after.kts");
            doTest(fileName);
        }

        @TestMetadata("SecondaryConstructors.after.kt")
        public void testSecondaryConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SecondaryConstructors.after.kt");
            doTest(fileName);
        }

        @TestMetadata("secondaryCtorLineBreak.after.kt")
        public void testSecondaryCtorLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/secondaryCtorLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("Semicolon.after.kt")
        public void testSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Semicolon.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SingleLineFunctionLiteral.after.kt")
        public void testSingleLineFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SingleLineFunctionLiteral.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpaceAroundExtendColon.after.kt")
        public void testSpaceAroundExtendColon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpaceAroundExtendColon.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpaceAroundExtendColonInObjects.after.kt")
        public void testSpaceAroundExtendColonInObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpaceAroundExtendColonInObjects.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpaceAroundExtendColonInSecondaryCtr.after.kt")
        public void testSpaceAroundExtendColonInSecondaryCtr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpaceAroundExtendColonInSecondaryCtr.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpaceBeforeFunctionLiteral.after.kt")
        public void testSpaceBeforeFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpaceBeforeFunctionLiteral.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpacedInsideParans.after.kt")
        public void testSpacedInsideParans() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpacedInsideParans.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpacesAroundOperations.after.kt")
        public void testSpacesAroundOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpacesAroundOperations.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpacesAroundUnaryOperations.after.kt")
        public void testSpacesAroundUnaryOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpacesAroundUnaryOperations.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpacesInDeclarations.after.kt")
        public void testSpacesInDeclarations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpacesInDeclarations.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SpacesInQualifiedExpressions.after.kt")
        public void testSpacesInQualifiedExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpacesInQualifiedExpressions.after.kt");
            doTest(fileName);
        }

        @TestMetadata("SuperListIndent.after.kt")
        public void testSuperListIndent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SuperListIndent.after.kt");
            doTest(fileName);
        }

        @TestMetadata("TryCatchLineBreak.after.kt")
        public void testTryCatchLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/TryCatchLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("UnnecessarySpacesInParametersLists.after.kt")
        public void testUnnecessarySpacesInParametersLists() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/UnnecessarySpacesInParametersLists.after.kt");
            doTest(fileName);
        }

        @TestMetadata("ValVarSpaces.after.kt")
        public void testValVarSpaces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ValVarSpaces.after.kt");
            doTest(fileName);
        }

        @TestMetadata("When.after.kt")
        public void testWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/When.after.kt");
            doTest(fileName);
        }

        @TestMetadata("WhenArrow.after.kt")
        public void testWhenArrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhenArrow.after.kt");
            doTest(fileName);
        }

        @TestMetadata("WhenEntryExpr.after.kt")
        public void testWhenEntryExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhenEntryExpr.after.kt");
            doTest(fileName);
        }

        @TestMetadata("WhenLineBreak.after.kt")
        public void testWhenLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhenLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("WhenLinesBeforeLbrace.after.kt")
        public void testWhenLinesBeforeLbrace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhenLinesBeforeLbrace.after.kt");
            doTest(fileName);
        }

        @TestMetadata("WhileLineBreak.after.kt")
        public void testWhileLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhileLineBreak.after.kt");
            doTest(fileName);
        }

        @TestMetadata("WhileOnNewLine.after.kt")
        public void testWhileOnNewLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhileOnNewLine.after.kt");
            doTest(fileName);
        }

        @TestMetadata("WhileSpacing.after.kt")
        public void testWhileSpacing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhileSpacing.after.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/formatter/fileAnnotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FileAnnotations extends AbstractFormatterTest {
            @TestMetadata("afterComment.after.kt")
            public void testAfterComment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/fileAnnotations/afterComment.after.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInFileAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/fileAnnotations"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("beforeDeclaration.after.kt")
            public void testBeforeDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/fileAnnotations/beforeDeclaration.after.kt");
                doTest(fileName);
            }

            @TestMetadata("beforeImportList.after.kt")
            public void testBeforeImportList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/fileAnnotations/beforeImportList.after.kt");
                doTest(fileName);
            }

            @TestMetadata("beforePackage.after.kt")
            public void testBeforePackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/fileAnnotations/beforePackage.after.kt");
                doTest(fileName);
            }

            @TestMetadata("inEmptyFile.after.kt")
            public void testInEmptyFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/fileAnnotations/inEmptyFile.after.kt");
                doTest(fileName);
            }

            @TestMetadata("manyLinesFromFileBegin.after.kt")
            public void testManyLinesFromFileBegin() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/fileAnnotations/manyLinesFromFileBegin.after.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/formatter/modifierList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ModifierList extends AbstractFormatterTest {
            public void testAllFilesPresentInModifierList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/modifierList"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("funAnnotationBeforeAnnotation.after.kt")
            public void testFunAnnotationBeforeAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funAnnotationBeforeAnnotation.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funAnnotationBeforeAnnotationEntry.after.kt")
            public void testFunAnnotationBeforeAnnotationEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funAnnotationBeforeAnnotationEntry.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funAnnotationBeforeModifiers.after.kt")
            public void testFunAnnotationBeforeModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funAnnotationBeforeModifiers.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funAnnotationEntryBeforeAnnotation.after.kt")
            public void testFunAnnotationEntryBeforeAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funAnnotationEntryBeforeAnnotation.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funAnnotationEntryBeforeAnnotationEntry.after.kt")
            public void testFunAnnotationEntryBeforeAnnotationEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funAnnotationEntryBeforeAnnotationEntry.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funAnnotationEntryBeforeModifiers.after.kt")
            public void testFunAnnotationEntryBeforeModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funAnnotationEntryBeforeModifiers.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funModifierBeforeAnnotation.after.kt")
            public void testFunModifierBeforeAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funModifierBeforeAnnotation.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funModifierBeforeAnnotationEntry.after.kt")
            public void testFunModifierBeforeAnnotationEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funModifierBeforeAnnotationEntry.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funModifierBeforeModifiers.after.kt")
            public void testFunModifierBeforeModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funModifierBeforeModifiers.after.kt");
                doTest(fileName);
            }

            @TestMetadata("funTheOnlyModifier.after.kt")
            public void testFunTheOnlyModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/funTheOnlyModifier.after.kt");
                doTest(fileName);
            }

            @TestMetadata("memberFunTheOnlyModifier.after.kt")
            public void testMemberFunTheOnlyModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/memberFunTheOnlyModifier.after.kt");
                doTest(fileName);
            }

            @TestMetadata("memberValTheOnlyModifier.after.kt")
            public void testMemberValTheOnlyModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/memberValTheOnlyModifier.after.kt");
                doTest(fileName);
            }

            @TestMetadata("memberVarTheOnlyModifier.after.kt")
            public void testMemberVarTheOnlyModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/memberVarTheOnlyModifier.after.kt");
                doTest(fileName);
            }

            @TestMetadata("secondMemberFunTheOnlyModifier.after.kt")
            public void testSecondMemberFunTheOnlyModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/secondMemberFunTheOnlyModifier.after.kt");
                doTest(fileName);
            }

            @TestMetadata("secondMemberValTheOnlyModifier.after.kt")
            public void testSecondMemberValTheOnlyModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/secondMemberValTheOnlyModifier.after.kt");
                doTest(fileName);
            }

            @TestMetadata("secondMemberVarTheOnlyModifier.after.kt")
            public void testSecondMemberVarTheOnlyModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/modifierList/secondMemberVarTheOnlyModifier.after.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/formatter/parameterList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ParameterList extends AbstractFormatterTest {
            public void testAllFilesPresentInParameterList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter/parameterList"), Pattern.compile("^([^\\.]+)\\.after\\.kt.*$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ArgumentListChopAsNeeded.after.kt")
            public void testArgumentListChopAsNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/parameterList/ArgumentListChopAsNeeded.after.kt");
                doTest(fileName);
            }

            @TestMetadata("ArgumentListDoNotWrap.after.kt")
            public void testArgumentListDoNotWrap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/parameterList/ArgumentListDoNotWrap.after.kt");
                doTest(fileName);
            }

            @TestMetadata("ArgumentListWrapAlways.after.kt")
            public void testArgumentListWrapAlways() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/parameterList/ArgumentListWrapAlways.after.kt");
                doTest(fileName);
            }

            @TestMetadata("ArgumentListWrapAsNeeded.after.kt")
            public void testArgumentListWrapAsNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/parameterList/ArgumentListWrapAsNeeded.after.kt");
                doTest(fileName);
            }

            @TestMetadata("ParameterListChopAsNeeded.after.kt")
            public void testParameterListChopAsNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/parameterList/ParameterListChopAsNeeded.after.kt");
                doTest(fileName);
            }

            @TestMetadata("ParameterListDoNotWrap.after.kt")
            public void testParameterListDoNotWrap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/parameterList/ParameterListDoNotWrap.after.kt");
                doTest(fileName);
            }

            @TestMetadata("ParameterListWrapAlways.after.kt")
            public void testParameterListWrapAlways() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/parameterList/ParameterListWrapAlways.after.kt");
                doTest(fileName);
            }

            @TestMetadata("ParameterListWrapAsNeeded.after.kt")
            public void testParameterListWrapAsNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/parameterList/ParameterListWrapAsNeeded.after.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/formatter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FormatterInverted extends AbstractFormatterTest {
        public void testAllFilesPresentInFormatterInverted() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/formatter"), Pattern.compile("^([^\\.]+)\\.after\\.inv\\.kt.*$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnonymousInitializersLineBreak.after.inv.kt")
        public void testAnonymousInitializersLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/AnonymousInitializersLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("BinaryExpressions.after.inv.kt")
        public void testBinaryExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/BinaryExpressions.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("BinaryExpressionsBoolean.after.inv.kt")
        public void testBinaryExpressionsBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/BinaryExpressionsBoolean.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("BinaryExpressionsWithoutAlignment.after.inv.kt")
        public void testBinaryExpressionsWithoutAlignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/BinaryExpressionsWithoutAlignment.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("CatchFinallyOnNewLine.after.inv.kt")
        public void testCatchFinallyOnNewLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/CatchFinallyOnNewLine.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("ClassLineBreak.after.inv.kt")
        public void testClassLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ClassLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("ColonSpaces.after.inv.kt")
        public void testColonSpaces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ColonSpaces.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("DelegationList.after.inv.kt")
        public void testDelegationList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/DelegationList.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("DoWhileLineBreak.after.inv.kt")
        public void testDoWhileLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/DoWhileLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("ElseOnNewLine.after.inv.kt")
        public void testElseOnNewLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ElseOnNewLine.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("Elvis.after.inv.kt")
        public void testElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Elvis.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("EmptyBlocks.after.inv.kt")
        public void testEmptyBlocks() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/EmptyBlocks.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("ForLineBreak.after.inv.kt")
        public void testForLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/ForLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("FormatFirstColumnComments.after.inv.kt")
        public void testFormatFirstColumnComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FormatFirstColumnComments.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("FormatFirstColumnCommentsBeforeDeclaration.after.inv.kt")
        public void testFormatFirstColumnCommentsBeforeDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FormatFirstColumnCommentsBeforeDeclaration.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("FunctionLineBreak.after.inv.kt")
        public void testFunctionLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("FunctionalType.after.inv.kt")
        public void testFunctionalType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/FunctionalType.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("IfElseWithTrickyComments.after.inv.kt")
        public void testIfElseWithTrickyComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/IfElseWithTrickyComments.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("LambdaArrow.after.inv.kt")
        public void testLambdaArrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/LambdaArrow.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("MultilineFunctionLiteralWithParams.after.inv.kt")
        public void testMultilineFunctionLiteralWithParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/MultilineFunctionLiteralWithParams.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("Parameters.after.inv.kt")
        public void testParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/Parameters.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("RightBracketOnNewLine.after.inv.kt")
        public void testRightBracketOnNewLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/RightBracketOnNewLine.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("secondaryCtorLineBreak.after.inv.kt")
        public void testSecondaryCtorLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/secondaryCtorLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("SingleLineFunctionLiteral.after.inv.kt")
        public void testSingleLineFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SingleLineFunctionLiteral.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("SpaceAroundExtendColon.after.inv.kt")
        public void testSpaceAroundExtendColon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpaceAroundExtendColon.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("SpaceAroundExtendColonInObjects.after.inv.kt")
        public void testSpaceAroundExtendColonInObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpaceAroundExtendColonInObjects.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("SpaceAroundExtendColonInSecondaryCtr.after.inv.kt")
        public void testSpaceAroundExtendColonInSecondaryCtr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpaceAroundExtendColonInSecondaryCtr.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("SpacesAroundOperations.after.inv.kt")
        public void testSpacesAroundOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpacesAroundOperations.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("SpacesAroundUnaryOperations.after.inv.kt")
        public void testSpacesAroundUnaryOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/SpacesAroundUnaryOperations.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("TryCatchLineBreak.after.inv.kt")
        public void testTryCatchLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/TryCatchLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("When.after.inv.kt")
        public void testWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/When.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("WhenArrow.after.inv.kt")
        public void testWhenArrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhenArrow.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("WhenLineBreak.after.inv.kt")
        public void testWhenLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhenLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("WhileLineBreak.after.inv.kt")
        public void testWhileLineBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhileLineBreak.after.inv.kt");
            doTestInverted(fileName);
        }

        @TestMetadata("WhileOnNewLine.after.inv.kt")
        public void testWhileOnNewLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/formatter/WhileOnNewLine.after.inv.kt");
            doTestInverted(fileName);
        }

    }
}
