/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/smartSelection")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class SmartSelectionTestGenerated extends AbstractSmartSelectionTest {
    public void testAllFilesPresentInSmartSelection() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/smartSelection"), Pattern.compile("^([^.]+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("commentsAndExtraSpaces.kt")
    public void testCommentsAndExtraSpaces() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/commentsAndExtraSpaces.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("labelledStatement.kt")
    public void testLabelledStatement() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/labelledStatement.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("labelledThis.kt")
    public void testLabelledThis() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/labelledThis.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("lambdaCalls.kt")
    public void testLambdaCalls() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/lambdaCalls.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("multilineCalls.kt")
    public void testMultilineCalls() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/multilineCalls.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("multilineOperations.kt")
    public void testMultilineOperations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/multilineOperations.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("objectLiteral.kt")
    public void testObjectLiteral() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/objectLiteral.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("parenthesized.kt")
    public void testParenthesized() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/parenthesized.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("simple.kt")
    public void testSimple() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/simple.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("superExpression.kt")
    public void testSuperExpression() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/superExpression.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("superExpressionWithLabel.kt")
    public void testSuperExpressionWithLabel() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/superExpressionWithLabel.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("superExpressionWithLabelAndType.kt")
    public void testSuperExpressionWithLabelAndType() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/superExpressionWithLabelAndType.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("superExpressionWithType.kt")
    public void testSuperExpressionWithType() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/superExpressionWithType.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("typeInSuperExpression.kt")
    public void testTypeInSuperExpression() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/typeInSuperExpression.kt");
        doTestSmartSelection(fileName);
    }

    @TestMetadata("typeInSuperExpressionWithLabel.kt")
    public void testTypeInSuperExpressionWithLabel() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/smartSelection/typeInSuperExpressionWithLabel.kt");
        doTestSmartSelection(fileName);
    }
}
