/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.actions;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/navigation/gotoTestOrCode")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class GotoTestOrCodeActionTestGenerated extends AbstractGotoTestOrCodeActionTest {
    public void testAllFilesPresentInGotoTestOrCode() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/navigation/gotoTestOrCode"), Pattern.compile("^(.+)\\.main\\..+$"), TargetBackend.ANY, true);
    }

    @TestMetadata("fromJavaClassToTest.main.java")
    public void testFromJavaClassToTest() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/navigation/gotoTestOrCode/fromJavaClassToTest.main.java");
        doTest(fileName);
    }

    @TestMetadata("fromJavaTestToKotlinClass.main.java")
    public void testFromJavaTestToKotlinClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/navigation/gotoTestOrCode/fromJavaTestToKotlinClass.main.java");
        doTest(fileName);
    }

    @TestMetadata("fromJavaTestToKotlinFile.main.java")
    public void testFromJavaTestToKotlinFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/navigation/gotoTestOrCode/fromJavaTestToKotlinFile.main.java");
        doTest(fileName);
    }

    @TestMetadata("fromKotlinClassToTest.main.kt")
    public void testFromKotlinClassToTest() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/navigation/gotoTestOrCode/fromKotlinClassToTest.main.kt");
        doTest(fileName);
    }

    @TestMetadata("fromKotlinFileToTest.main.kt")
    public void testFromKotlinFileToTest() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/navigation/gotoTestOrCode/fromKotlinFileToTest.main.kt");
        doTest(fileName);
    }

    @TestMetadata("fromKotlinTestToJavaClass.main.kt")
    public void testFromKotlinTestToJavaClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/navigation/gotoTestOrCode/fromKotlinTestToJavaClass.main.kt");
        doTest(fileName);
    }

    @TestMetadata("fromKotlinTestToKotlinClass.main.kt")
    public void testFromKotlinTestToKotlinClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/navigation/gotoTestOrCode/fromKotlinTestToKotlinClass.main.kt");
        doTest(fileName);
    }

    @TestMetadata("fromKotlinTestToKotlinFile.main.kt")
    public void testFromKotlinTestToKotlinFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/navigation/gotoTestOrCode/fromKotlinTestToKotlinFile.main.kt");
        doTest(fileName);
    }
}
