/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/codeInsight/breadcrumbs")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BreadcrumbsTestGenerated extends AbstractBreadcrumbsTest {
    public void testAllFilesPresentInBreadcrumbs() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/breadcrumbs"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("AnonymousObjects.kt")
    public void testAnonymousObjects() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/AnonymousObjects.kt");
        doTest(fileName);
    }

    @TestMetadata("Declarations.kt")
    public void testDeclarations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/Declarations.kt");
        doTest(fileName);
    }

    @TestMetadata("For.kt")
    public void testFor() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/For.kt");
        doTest(fileName);
    }

    @TestMetadata("If.kt")
    public void testIf() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/If.kt");
        doTest(fileName);
    }

    @TestMetadata("LabeledStatements.kt")
    public void testLabeledStatements() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/LabeledStatements.kt");
        doTest(fileName);
    }

    @TestMetadata("Lambdas.kt")
    public void testLambdas() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/Lambdas.kt");
        doTest(fileName);
    }

    @TestMetadata("OnIfCondition.kt")
    public void testOnIfCondition() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/OnIfCondition.kt");
        doTest(fileName);
    }

    @TestMetadata("OnWhenEntryCondition.kt")
    public void testOnWhenEntryCondition() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/OnWhenEntryCondition.kt");
        doTest(fileName);
    }

    @TestMetadata("PropertyAccessor.kt")
    public void testPropertyAccessor() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/PropertyAccessor.kt");
        doTest(fileName);
    }

    @TestMetadata("Try.kt")
    public void testTry() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/Try.kt");
        doTest(fileName);
    }

    @TestMetadata("When.kt")
    public void testWhen() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/When.kt");
        doTest(fileName);
    }

    @TestMetadata("While.kt")
    public void testWhile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/breadcrumbs/While.kt");
        doTest(fileName);
    }
}
