/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/codeInsight/expressionType")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class ExpressionTypeTestGenerated extends AbstractExpressionTypeTest {
    public void testAllFilesPresentInExpressionType() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/expressionType"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("BlockBodyFunction.kt")
    public void testBlockBodyFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/BlockBodyFunction.kt");
        doTest(fileName);
    }

    @TestMetadata("IfAsExpression.kt")
    public void testIfAsExpression() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/IfAsExpression.kt");
        doTest(fileName);
    }

    @TestMetadata("IfAsExpressionInsideBlock.kt")
    public void testIfAsExpressionInsideBlock() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/IfAsExpressionInsideBlock.kt");
        doTest(fileName);
    }

    @TestMetadata("Kt11601.kt")
    public void testKt11601() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/Kt11601.kt");
        doTest(fileName);
    }

    @TestMetadata("Lambda.kt")
    public void testLambda() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/Lambda.kt");
        doTest(fileName);
    }

    @TestMetadata("MethodName.kt")
    public void testMethodName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/MethodName.kt");
        doTest(fileName);
    }

    @TestMetadata("MethodReference.kt")
    public void testMethodReference() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/MethodReference.kt");
        doTest(fileName);
    }

    @TestMetadata("MultiDeclaration.kt")
    public void testMultiDeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/MultiDeclaration.kt");
        doTest(fileName);
    }

    @TestMetadata("MultiDeclarationInLambda.kt")
    public void testMultiDeclarationInLambda() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/MultiDeclarationInLambda.kt");
        doTest(fileName);
    }

    @TestMetadata("MultiDeclarationInLoop.kt")
    public void testMultiDeclarationInLoop() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/MultiDeclarationInLoop.kt");
        doTest(fileName);
    }

    @TestMetadata("PropertyAccessor.kt")
    public void testPropertyAccessor() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/PropertyAccessor.kt");
        doTest(fileName);
    }

    @TestMetadata("SmartCast.kt")
    public void testSmartCast() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/SmartCast.kt");
        doTest(fileName);
    }

    @TestMetadata("SoftSmartCast.kt")
    public void testSoftSmartCast() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/SoftSmartCast.kt");
        doTest(fileName);
    }

    @TestMetadata("SoftSmartCastMultipleTypes.kt")
    public void testSoftSmartCastMultipleTypes() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/SoftSmartCastMultipleTypes.kt");
        doTest(fileName);
    }

    @TestMetadata("VariableDeclaration.kt")
    public void testVariableDeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/expressionType/VariableDeclaration.kt");
        doTest(fileName);
    }
}
