/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.codeInsight.surroundWith;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class SurroundWithTestGenerated extends AbstractSurroundWithTest {
    @TestMetadata("idea/testData/codeInsight/surroundWith/if")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class If extends AbstractSurroundWithTest {
        public void testAllFilesPresentInIf() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("block.kt")
        public void testBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/block.kt");
            doTestWithIfSurrounder(fileName);
        }

        @TestMetadata("emptyLine.kt")
        public void testEmptyLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/emptyLine.kt");
            doTestWithIfSurrounder(fileName);
        }

        @TestMetadata("severalStatements.kt")
        public void testSeveralStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/severalStatements.kt");
            doTestWithIfSurrounder(fileName);
        }

        @TestMetadata("singleStatement.kt")
        public void testSingleStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/singleStatement.kt");
            doTestWithIfSurrounder(fileName);
        }

        @TestMetadata("singleStatementAtCaret.kt")
        public void testSingleStatementAtCaret() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/singleStatementAtCaret.kt");
            doTestWithIfSurrounder(fileName);
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/variable.kt");
            doTestWithIfSurrounder(fileName);
        }

        @TestMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MoveDeclarationsOut extends AbstractSurroundWithTest {
            public void testAllFilesPresentInMoveDeclarationsOut() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/class")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Class extends AbstractSurroundWithTest {
                public void testAllFilesPresentInClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/class"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classInType.kt")
                public void testClassInType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/class/classInType.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/class/localClass.kt");
                    doTestWithIfSurrounder(fileName);
                }
            }

            @TestMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/function")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Function extends AbstractSurroundWithTest {
                public void testAllFilesPresentInFunction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/function"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("firstChildLocalFun.kt")
                public void testFirstChildLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/function/firstChildLocalFun.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("localFun.kt")
                public void testLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/function/localFun.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("unusedLocalFun.kt")
                public void testUnusedLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/function/unusedLocalFun.kt");
                    doTestWithIfSurrounder(fileName);
                }
            }

            @TestMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/object")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Object extends AbstractSurroundWithTest {
                public void testAllFilesPresentInObject() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/object"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("localObject.kt")
                public void testLocalObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/object/localObject.kt");
                    doTestWithIfSurrounder(fileName);
                }
            }

            @TestMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/order")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Order extends AbstractSurroundWithTest {
                public void testAllFilesPresentInOrder() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/order"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("twoClasses.kt")
                public void testTwoClasses() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/order/twoClasses.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("valAndClass.kt")
                public void testValAndClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/order/valAndClass.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("valOrder.kt")
                public void testValOrder() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/order/valOrder.kt");
                    doTestWithIfSurrounder(fileName);
                }
            }

            @TestMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/val")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Val extends AbstractSurroundWithTest {
                public void testAllFilesPresentInVal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/val"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("fullQualifiedType.kt")
                public void testFullQualifiedType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/val/fullQualifiedType.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("fullQualifiedTypeWithoutTypeRef.kt")
                public void testFullQualifiedTypeWithoutTypeRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/val/fullQualifiedTypeWithoutTypeRef.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("valWithTypeWithInitializer.kt")
                public void testValWithTypeWithInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/val/valWithTypeWithInitializer.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("valWithTypeWoInitializer.kt")
                public void testValWithTypeWoInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/val/valWithTypeWoInitializer.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("valWoTypeWithInitializer.kt")
                public void testValWoTypeWithInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/val/valWoTypeWithInitializer.kt");
                    doTestWithIfSurrounder(fileName);
                }
            }

            @TestMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Var extends AbstractSurroundWithTest {
                public void testAllFilesPresentInVar() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("varWithNotNullableTypeWithInitializer.kt")
                public void testVarWithNotNullableTypeWithInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var/varWithNotNullableTypeWithInitializer.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("varWithTypeWoInitializer.kt")
                public void testVarWithTypeWoInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var/varWithTypeWoInitializer.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("varWoTypeWithInitializer.kt")
                public void testVarWoTypeWithInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var/varWoTypeWithInitializer.kt");
                    doTestWithIfSurrounder(fileName);
                }

                @TestMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var/defaultValue")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class DefaultValue extends AbstractSurroundWithTest {
                    public void testAllFilesPresentInDefaultValue() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var/defaultValue"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("boolean.kt")
                    public void testBoolean() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var/defaultValue/boolean.kt");
                        doTestWithIfSurrounder(fileName);
                    }

                    @TestMetadata("nullable.kt")
                    public void testNullable() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var/defaultValue/nullable.kt");
                        doTestWithIfSurrounder(fileName);
                    }

                    @TestMetadata("primitiveNumbers.kt")
                    public void testPrimitiveNumbers() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/if/moveDeclarationsOut/var/defaultValue/primitiveNumbers.kt");
                        doTestWithIfSurrounder(fileName);
                    }
                }
            }
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/ifElse")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IfElse extends AbstractSurroundWithTest {
        public void testAllFilesPresentInIfElse() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/ifElse"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("block.kt")
        public void testBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/ifElse/block.kt");
            doTestWithIfElseSurrounder(fileName);
        }

        @TestMetadata("moveDeclarationsOutVal.kt")
        public void testMoveDeclarationsOutVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/ifElse/moveDeclarationsOutVal.kt");
            doTestWithIfElseSurrounder(fileName);
        }

        @TestMetadata("moveDeclarationsOutVar.kt")
        public void testMoveDeclarationsOutVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/ifElse/moveDeclarationsOutVar.kt");
            doTestWithIfElseSurrounder(fileName);
        }

        @TestMetadata("severalStatements.kt")
        public void testSeveralStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/ifElse/severalStatements.kt");
            doTestWithIfElseSurrounder(fileName);
        }

        @TestMetadata("singleStatement.kt")
        public void testSingleStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/ifElse/singleStatement.kt");
            doTestWithIfElseSurrounder(fileName);
        }

        @TestMetadata("singleStatementAtCaret.kt")
        public void testSingleStatementAtCaret() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/ifElse/singleStatementAtCaret.kt");
            doTestWithIfElseSurrounder(fileName);
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/ifElse/variable.kt");
            doTestWithIfElseSurrounder(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/not")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Not extends AbstractSurroundWithTest {
        public void testAllFilesPresentInNot() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/not"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("booleanExpr.kt")
        public void testBooleanExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/not/booleanExpr.kt");
            doTestWithNotSurrounder(fileName);
        }

        @TestMetadata("booleanExprAtCaret.kt")
        public void testBooleanExprAtCaret() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/not/booleanExprAtCaret.kt");
            doTestWithNotSurrounder(fileName);
        }

        @TestMetadata("expressionInIf.kt")
        public void testExpressionInIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/not/expressionInIf.kt");
            doTestWithNotSurrounder(fileName);
        }

        @TestMetadata("notExpression.kt")
        public void testNotExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/not/notExpression.kt");
            doTestWithNotSurrounder(fileName);
        }

        @TestMetadata("severalExpr.kt")
        public void testSeveralExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/not/severalExpr.kt");
            doTestWithNotSurrounder(fileName);
        }

        @TestMetadata("severalExprAtCaret.kt")
        public void testSeveralExprAtCaret() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/not/severalExprAtCaret.kt");
            doTestWithNotSurrounder(fileName);
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/not/variable.kt");
            doTestWithNotSurrounder(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/parentheses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Parentheses extends AbstractSurroundWithTest {
        public void testAllFilesPresentInParentheses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/parentheses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("expr.kt")
        public void testExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/expr.kt");
            doTestWithParenthesesSurrounder(fileName);
        }

        @TestMetadata("inIf.kt")
        public void testInIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/inIf.kt");
            doTestWithParenthesesSurrounder(fileName);
        }

        @TestMetadata("partOfExpr.kt")
        public void testPartOfExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/partOfExpr.kt");
            doTestWithParenthesesSurrounder(fileName);
        }

        @TestMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NotApplicable extends AbstractSurroundWithTest {
            public void testAllFilesPresentInNotApplicable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/parentheses/notApplicable"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("if.kt")
            public void testIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/if.kt");
                doTestWithParenthesesSurrounder(fileName);
            }

            @TestMetadata("import.kt")
            public void testImport() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/import.kt");
                doTestWithParenthesesSurrounder(fileName);
            }

            @TestMetadata("importQualifiedFirst.kt")
            public void testImportQualifiedFirst() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/importQualifiedFirst.kt");
                doTestWithParenthesesSurrounder(fileName);
            }

            @TestMetadata("importQualifiedSecond.kt")
            public void testImportQualifiedSecond() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/importQualifiedSecond.kt");
                doTestWithParenthesesSurrounder(fileName);
            }

            @TestMetadata("packageName.kt")
            public void testPackageName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/packageName.kt");
                doTestWithParenthesesSurrounder(fileName);
            }

            @TestMetadata("parameterName.kt")
            public void testParameterName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/parameterName.kt");
                doTestWithParenthesesSurrounder(fileName);
            }

            @TestMetadata("parameterWithType.kt")
            public void testParameterWithType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/parameterWithType.kt");
                doTestWithParenthesesSurrounder(fileName);
            }

            @TestMetadata("qualifiedExpressionSecond.kt")
            public void testQualifiedExpressionSecond() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/qualifiedExpressionSecond.kt");
                doTestWithParenthesesSurrounder(fileName);
            }

            @TestMetadata("qualifiedExpressionSecondWithBracket.kt")
            public void testQualifiedExpressionSecondWithBracket() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/parentheses/notApplicable/qualifiedExpressionSecondWithBracket.kt");
                doTestWithParenthesesSurrounder(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/stringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StringTemplate extends AbstractSurroundWithTest {
        public void testAllFilesPresentInStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/stringTemplate"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multiExpression.kt")
        public void testMultiExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/stringTemplate/multiExpression.kt");
            doTestWithStringTemplateSurrounder(fileName);
        }

        @TestMetadata("multiExpressionConstant.kt")
        public void testMultiExpressionConstant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/stringTemplate/multiExpressionConstant.kt");
            doTestWithStringTemplateSurrounder(fileName);
        }

        @TestMetadata("singleConstant.kt")
        public void testSingleConstant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/stringTemplate/singleConstant.kt");
            doTestWithStringTemplateSurrounder(fileName);
        }

        @TestMetadata("singleExpression.kt")
        public void testSingleExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/stringTemplate/singleExpression.kt");
            doTestWithStringTemplateSurrounder(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/when")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class When extends AbstractSurroundWithTest {
        public void testAllFilesPresentInWhen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/when"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/when/enum.kt");
            doTestWithWhenSurrounder(fileName);
        }

        @TestMetadata("multiExpression.kt")
        public void testMultiExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/when/multiExpression.kt");
            doTestWithWhenSurrounder(fileName);
        }

        @TestMetadata("singleExpression.kt")
        public void testSingleExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/when/singleExpression.kt");
            doTestWithWhenSurrounder(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/tryCatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TryCatch extends AbstractSurroundWithTest {
        public void testAllFilesPresentInTryCatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/tryCatch"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("moveDeclarationsOut.kt")
        public void testMoveDeclarationsOut() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/tryCatch/moveDeclarationsOut.kt");
            doTestWithTryCatchSurrounder(fileName);
        }

        @TestMetadata("multiExpression.kt")
        public void testMultiExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/tryCatch/multiExpression.kt");
            doTestWithTryCatchSurrounder(fileName);
        }

        @TestMetadata("singleExpression.kt")
        public void testSingleExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/tryCatch/singleExpression.kt");
            doTestWithTryCatchSurrounder(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/tryCatchFinally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TryCatchFinally extends AbstractSurroundWithTest {
        public void testAllFilesPresentInTryCatchFinally() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/tryCatchFinally"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multiExpression.kt")
        public void testMultiExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/tryCatchFinally/multiExpression.kt");
            doTestWithTryCatchFinallySurrounder(fileName);
        }

        @TestMetadata("singleExpression.kt")
        public void testSingleExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/tryCatchFinally/singleExpression.kt");
            doTestWithTryCatchFinallySurrounder(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/tryFinally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TryFinally extends AbstractSurroundWithTest {
        public void testAllFilesPresentInTryFinally() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/tryFinally"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multiExpression.kt")
        public void testMultiExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/tryFinally/multiExpression.kt");
            doTestWithTryFinallySurrounder(fileName);
        }

        @TestMetadata("singleExpression.kt")
        public void testSingleExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/tryFinally/singleExpression.kt");
            doTestWithTryFinallySurrounder(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/functionLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FunctionLiteral extends AbstractSurroundWithTest {
        public void testAllFilesPresentInFunctionLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/functionLiteral"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("moveDeclarationsOut.kt")
        public void testMoveDeclarationsOut() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/functionLiteral/moveDeclarationsOut.kt");
            doTestWithFunctionLiteralSurrounder(fileName);
        }

        @TestMetadata("multiStatement.kt")
        public void testMultiStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/functionLiteral/multiStatement.kt");
            doTestWithFunctionLiteralSurrounder(fileName);
        }

        @TestMetadata("singleStatement.kt")
        public void testSingleStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/functionLiteral/singleStatement.kt");
            doTestWithFunctionLiteralSurrounder(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/withIfExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WithIfExpression extends AbstractSurroundWithTest {
        public void testAllFilesPresentInWithIfExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/withIfExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexBoolean.kt")
        public void testComplexBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/withIfExpression/complexBoolean.kt");
            doTestWithSurroundWithIfExpression(fileName);
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/withIfExpression/variable.kt");
            doTestWithSurroundWithIfExpression(fileName);
        }
    }

    @TestMetadata("idea/testData/codeInsight/surroundWith/withIfElseExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WithIfElseExpression extends AbstractSurroundWithTest {
        public void testAllFilesPresentInWithIfElseExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/surroundWith/withIfElseExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexBoolean.kt")
        public void testComplexBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/withIfElseExpression/complexBoolean.kt");
            doTestWithSurroundWithIfElseExpression(fileName);
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/codeInsight/surroundWith/withIfElseExpression/variable.kt");
            doTestWithSurroundWithIfElseExpression(fileName);
        }
    }
}
