/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/copyPaste/plainTextConversion")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class TextJavaToKotlinCopyPasteConversionTestGenerated extends AbstractTextJavaToKotlinCopyPasteConversionTest {
    public void testAllFilesPresentInPlainTextConversion() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/copyPaste/plainTextConversion"), Pattern.compile("^([^\\.]+)\\.txt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("AsExpression.txt")
    public void testAsExpression() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/AsExpression.txt");
        doTest(fileName);
    }

    @TestMetadata("AsExpressionBody.txt")
    public void testAsExpressionBody() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/AsExpressionBody.txt");
        doTest(fileName);
    }

    @TestMetadata("ImportResolve.txt")
    public void testImportResolve() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/ImportResolve.txt");
        doTest(fileName);
    }

    @TestMetadata("InsideIdentifier.txt")
    public void testInsideIdentifier() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/InsideIdentifier.txt");
        doTest(fileName);
    }

    @TestMetadata("IntoComment.txt")
    public void testIntoComment() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/IntoComment.txt");
        doTest(fileName);
    }

    @TestMetadata("IntoRawStringLiteral.txt")
    public void testIntoRawStringLiteral() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/IntoRawStringLiteral.txt");
        doTest(fileName);
    }

    @TestMetadata("IntoStringLiteral.txt")
    public void testIntoStringLiteral() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/IntoStringLiteral.txt");
        doTest(fileName);
    }

    @TestMetadata("KT13529.txt")
    public void testKT13529() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/KT13529.txt");
        doTest(fileName);
    }

    @TestMetadata("KT13529_1.txt")
    public void testKT13529_1() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/KT13529_1.txt");
        doTest(fileName);
    }

    @TestMetadata("MembersIntoClass.txt")
    public void testMembersIntoClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/MembersIntoClass.txt");
        doTest(fileName);
    }

    @TestMetadata("MembersToTopLevel.txt")
    public void testMembersToTopLevel() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/MembersToTopLevel.txt");
        doTest(fileName);
    }

    @TestMetadata("Override.txt")
    public void testOverride() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/Override.txt");
        doTest(fileName);
    }

    @TestMetadata("OverrideInterface.txt")
    public void testOverrideInterface() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/OverrideInterface.txt");
        doTest(fileName);
    }

    @TestMetadata("PostProcessing.txt")
    public void testPostProcessing() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/PostProcessing.txt");
        doTest(fileName);
    }

    @TestMetadata("StatementsIntoFunction.txt")
    public void testStatementsIntoFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/StatementsIntoFunction.txt");
        doTest(fileName);
    }

    @TestMetadata("WholeFile.txt")
    public void testWholeFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/copyPaste/plainTextConversion/WholeFile.txt");
        doTest(fileName);
    }
}
