/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.debugger;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/debugger/insertBeforeExtractFunction")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BeforeExtractFunctionInsertionTestGenerated extends AbstractBeforeExtractFunctionInsertionTest {
    public void testAllFilesPresentInInsertBeforeExtractFunction() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/insertBeforeExtractFunction"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("emptyImportDirective.kt")
    public void testEmptyImportDirective() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/insertBeforeExtractFunction/emptyImportDirective.kt");
        doTest(fileName);
    }

    @TestMetadata("emptyImportDirective2.kt")
    public void testEmptyImportDirective2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/insertBeforeExtractFunction/emptyImportDirective2.kt");
        doTest(fileName);
    }

    @TestMetadata("emptyPackageDirective.kt")
    public void testEmptyPackageDirective() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/insertBeforeExtractFunction/emptyPackageDirective.kt");
        doTest(fileName);
    }

    @TestMetadata("emptyPackageDirective2.kt")
    public void testEmptyPackageDirective2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/insertBeforeExtractFunction/emptyPackageDirective2.kt");
        doTest(fileName);
    }

    @TestMetadata("manyImports.kt")
    public void testManyImports() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/insertBeforeExtractFunction/manyImports.kt");
        doTest(fileName);
    }
}
