/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/idea-completion/testData/handlers/runtimeCast")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class CodeFragmentCompletionHandlerTestGenerated extends AbstractCodeFragmentCompletionHandlerTest {
    public void testAllFilesPresentInRuntimeCast() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/idea-completion/testData/handlers/runtimeCast"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("CastPrivateFun.kt")
    public void testCastPrivateFun() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/runtimeCast/CastPrivateFun.kt");
        doTest(fileName);
    }

    @TestMetadata("CastPropertyWithSmartCast.kt")
    public void testCastPropertyWithSmartCast() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/runtimeCast/CastPropertyWithSmartCast.kt");
        doTest(fileName);
    }

    @TestMetadata("InsertExtFunction.kt")
    public void testInsertExtFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/runtimeCast/InsertExtFunction.kt");
        doTest(fileName);
    }

    @TestMetadata("InsertFunction.kt")
    public void testInsertFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/runtimeCast/InsertFunction.kt");
        doTest(fileName);
    }

    @TestMetadata("InsertImport.kt")
    public void testInsertImport() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/runtimeCast/InsertImport.kt");
        doTest(fileName);
    }

    @TestMetadata("NotImportedExtension.kt")
    public void testNotImportedExtension() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/idea-completion/testData/handlers/runtimeCast/NotImportedExtension.kt");
        doTest(fileName);
    }
}
