/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class KotlinEvaluateExpressionTestGenerated extends AbstractKotlinEvaluateExpressionTest {
    @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SingleBreakpoint extends AbstractKotlinEvaluateExpressionTest {
        @TestMetadata("abstractFunCall.kt")
        public void testAbstractFunCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/abstractFunCall.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("accessToOverridenPropertyWithBackingField.kt")
        public void testAccessToOverridenPropertyWithBackingField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/accessToOverridenPropertyWithBackingField.kt");
            doSingleBreakpointTest(fileName);
        }

        public void testAllFilesPresentInSingleBreakpoint() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObjects.kt")
        public void testAnonymousObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/anonymousObjects.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("arrays.kt")
        public void testArrays() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/arrays.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("boxParam.kt")
        public void testBoxParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/boxParam.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("boxReturnValue.kt")
        public void testBoxReturnValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/boxReturnValue.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("breakpointInInlineFun.kt")
        public void testBreakpointInInlineFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/breakpointInInlineFun.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("callableBug.kt")
        public void testCallableBug() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/callableBug.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("classFromAnotherPackage.kt")
        public void testClassFromAnotherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/classFromAnotherPackage.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("classObjectVal.kt")
        public void testClassObjectVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/classObjectVal.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("collections.kt")
        public void testCollections() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/collections.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("delegatedPropertyInOtherFile.kt")
        public void testDelegatedPropertyInOtherFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/delegatedPropertyInOtherFile.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("dependentOnFile.kt")
        public void testDependentOnFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/dependentOnFile.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("doubles.kt")
        public void testDoubles() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/doubles.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("enums.kt")
        public void testEnums() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/enums.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("errors.kt")
        public void testErrors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/errors.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("extractLocalVariables.kt")
        public void testExtractLocalVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extractLocalVariables.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("extractThis.kt")
        public void testExtractThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extractThis.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("extractThisInTrait.kt")
        public void testExtractThisInTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extractThisInTrait.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("extractVariablesFromCall.kt")
        public void testExtractVariablesFromCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extractVariablesFromCall.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("fileWithError.kt")
        public void testFileWithError() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/fileWithError.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("funFromSuperClass.kt")
        public void testFunFromSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/funFromSuperClass.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("genericCrossinlineArgument.kt")
        public void testGenericCrossinlineArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/genericCrossinlineArgument.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("imports.kt")
        public void testImports() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/imports.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("importsLambdaContext.kt")
        public void testImportsLambdaContext() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/importsLambdaContext.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("inlineFunction.kt")
        public void testInlineFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/inlineFunction.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("inlineFunctionBreakpointAnotherFile.kt")
        public void testInlineFunctionBreakpointAnotherFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/inlineFunctionBreakpointAnotherFile.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("inlineFunctionBreakpointVariants.kt")
        public void testInlineFunctionBreakpointVariants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/inlineFunctionBreakpointVariants.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/innerClass.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("insertInBlock.kt")
        public void testInsertInBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/insertInBlock.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("kt12206BasePropertyWithoutBackingField.kt")
        public void testKt12206BasePropertyWithoutBackingField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt12206BasePropertyWithoutBackingField.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("kt5554OnlyIntsShouldBeCoerced.kt")
        public void testKt5554OnlyIntsShouldBeCoerced() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt5554OnlyIntsShouldBeCoerced.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("kt7046localVarInInline.kt")
        public void testKt7046localVarInInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/kt7046localVarInInline.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("localClass.kt")
        public void testLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/localClass.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("localVariables.kt")
        public void testLocalVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/localVariables.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("methodWithBreakpoint.kt")
        public void testMethodWithBreakpoint() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/methodWithBreakpoint.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("multilineExpressionAtBreakpoint.kt")
        public void testMultilineExpressionAtBreakpoint() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/multilineExpressionAtBreakpoint.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("nestedInlineArguments.kt")
        public void testNestedInlineArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/nestedInlineArguments.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("onClassHeader.kt")
        public void testOnClassHeader() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/onClassHeader.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("onGetter.kt")
        public void testOnGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/onGetter.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("onObjectHeader.kt")
        public void testOnObjectHeader() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/onObjectHeader.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("package.kt")
        public void testPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/package.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("parametersOfInlineFun.kt")
        public void testParametersOfInlineFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/parametersOfInlineFun.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("parametersOfInlineFunSeveralOnLine.kt")
        public void testParametersOfInlineFunSeveralOnLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/parametersOfInlineFunSeveralOnLine.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("privateClass.kt")
        public void testPrivateClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/privateClass.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("privateMember.kt")
        public void testPrivateMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/privateMember.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("privatePropertyWithExplicitDefaultGetter.kt")
        public void testPrivatePropertyWithExplicitDefaultGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/privatePropertyWithExplicitDefaultGetter.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("protectedMember.kt")
        public void testProtectedMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/protectedMember.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("rawTypeskt11831.kt")
        public void testRawTypeskt11831() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/rawTypeskt11831.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/simple.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("stdlib.kt")
        public void testStdlib() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/stdlib.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("typeParameterRef.kt")
        public void testTypeParameterRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/typeParameterRef.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("unboxParam.kt")
        public void testUnboxParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/unboxParam.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("unsafeCall.kt")
        public void testUnsafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/unsafeCall.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("vars.kt")
        public void testVars() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/vars.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata(".kt.kt")
        public void test_kt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/.kt.kt");
            doSingleBreakpointTest(fileName);
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompilingEvaluator extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInCompilingEvaluator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ceAnonymousObject.kt")
            public void testCeAnonymousObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceAnonymousObject.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceAnonymousObjectCapturedInClosure.kt")
            public void testCeAnonymousObjectCapturedInClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceAnonymousObjectCapturedInClosure.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceAnonymousObjectThisAsReceiver.kt")
            public void testCeAnonymousObjectThisAsReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceAnonymousObjectThisAsReceiver.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceLambda.kt")
            public void testCeLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceLambda.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceLocalClass.kt")
            public void testCeLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceLocalClass.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceLocalClassMembers.kt")
            public void testCeLocalClassMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceLocalClassMembers.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceLocalClassWithSuperClass.kt")
            public void testCeLocalClassWithSuperClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceLocalClassWithSuperClass.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceMembers.kt")
            public void testCeMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceMembers.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceObject.kt")
            public void testCeObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceObject.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceSeveralLambdas.kt")
            public void testCeSeveralLambdas() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceSeveralLambdas.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ceSuperAccess.kt")
            public void testCeSuperAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/compilingEvaluator/ceSuperAccess.kt");
                doSingleBreakpointTest(fileName);
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateExpression extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInCreateExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("createExpressionCastToBuiltIn.kt")
            public void testCreateExpressionCastToBuiltIn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression/createExpressionCastToBuiltIn.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("createExpressionSimple.kt")
            public void testCreateExpressionSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression/createExpressionSimple.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("createExpressionWithArray.kt")
            public void testCreateExpressionWithArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/createExpression/createExpressionWithArray.kt");
                doSingleBreakpointTest(fileName);
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtraVariables extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInExtraVariables() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("evBreakpointOnPropertyDeclaration.kt")
            public void testEvBreakpointOnPropertyDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evBreakpointOnPropertyDeclaration.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evDelegatedProperty.kt")
            public void testEvDelegatedProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evDelegatedProperty.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evDuplicateItems.kt")
            public void testEvDuplicateItems() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evDuplicateItems.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evFinalProperty.kt")
            public void testEvFinalProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evFinalProperty.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evFunctionDeclaration.kt")
            public void testEvFunctionDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evFunctionDeclaration.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evLineRange.kt")
            public void testEvLineRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evLineRange.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evProperty.kt")
            public void testEvProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evProperty.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evPropertyRefExpr.kt")
            public void testEvPropertyRefExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evPropertyRefExpr.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evSkipAnonymousObject.kt")
            public void testEvSkipAnonymousObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evSkipAnonymousObject.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evSkipLambda.kt")
            public void testEvSkipLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evSkipLambda.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("evSkipLocalClass.kt")
            public void testEvSkipLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/extraVariables/evSkipLocalClass.kt");
                doSingleBreakpointTest(fileName);
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Frame extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInFrame() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegatedPropertyInClass.kt")
            public void testDelegatedPropertyInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/delegatedPropertyInClass.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("delegatedPropertyInClassWithToString.kt")
            public void testDelegatedPropertyInClassWithToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/delegatedPropertyInClassWithToString.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("delegatedPropertyInClassWoRenderer.kt")
            public void testDelegatedPropertyInClassWoRenderer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/delegatedPropertyInClassWoRenderer.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameAnonymousObject.kt")
            public void testFrameAnonymousObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameAnonymousObject.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameClassObject.kt")
            public void testFrameClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameClassObject.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameClosingBracket.kt")
            public void testFrameClosingBracket() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameClosingBracket.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameExtFunExtFun.kt")
            public void testFrameExtFunExtFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameExtFunExtFun.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameExtensionFun.kt")
            public void testFrameExtensionFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameExtensionFun.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameInlineArgument.kt")
            public void testFrameInlineArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineArgument.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameInlineArgumentInsideInlineFun.kt")
            public void testFrameInlineArgumentInsideInlineFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineArgumentInsideInlineFun.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameInlineFun.kt")
            public void testFrameInlineFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineFun.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameInlineFunCallInsideInlineFun.kt")
            public void testFrameInlineFunCallInsideInlineFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInlineFunCallInsideInlineFun.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameInnerClass.kt")
            public void testFrameInnerClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInnerClass.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameInnerLambda.kt")
            public void testFrameInnerLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameInnerLambda.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameLambda.kt")
            public void testFrameLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameLambda.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameLambdaNotUsed.kt")
            public void testFrameLambdaNotUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameLambdaNotUsed.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameLocalVariable.kt")
            public void testFrameLocalVariable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameLocalVariable.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameObject.kt")
            public void testFrameObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameObject.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameSharedVar.kt")
            public void testFrameSharedVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameSharedVar.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameSharedVarLocalVar.kt")
            public void testFrameSharedVarLocalVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameSharedVarLocalVar.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameSimple.kt")
            public void testFrameSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameSimple.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameThis0.kt")
            public void testFrameThis0() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameThis0.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameThis0Ext.kt")
            public void testFrameThis0Ext() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameThis0Ext.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("frameThis0This0.kt")
            public void testFrameThis0This0() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/frame/frameThis0This0.kt");
                doSingleBreakpointTest(fileName);
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaContext extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInJavaContext() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("jcBlock.kt")
            public void testJcBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcBlock.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("jcImports.kt")
            public void testJcImports() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcImports.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("jcLocalVariable.kt")
            public void testJcLocalVariable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcLocalVariable.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("jcMarkedObject.kt")
            public void testJcMarkedObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcMarkedObject.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("jcProperty.kt")
            public void testJcProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcProperty.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("jcSimple.kt")
            public void testJcSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/javaContext/jcSimple.kt");
                doSingleBreakpointTest(fileName);
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Labels extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInLabels() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("lCallOnLabeledObj.kt")
            public void testLCallOnLabeledObj() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/lCallOnLabeledObj.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("lIdentifier.kt")
            public void testLIdentifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/lIdentifier.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("lSeveralLabels.kt")
            public void testLSeveralLabels() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/lSeveralLabels.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("lSimple.kt")
            public void testLSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/lSimple.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("ldifferentTypes.kt")
            public void testLdifferentTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/labels/ldifferentTypes.kt");
                doSingleBreakpointTest(fileName);
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lambdas extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInLambdas() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("destructuringParam.kt")
            public void testDestructuringParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/destructuringParam.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("inlineFunctionalExpression.kt")
            public void testInlineFunctionalExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/inlineFunctionalExpression.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("inlineLambda.kt")
            public void testInlineLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/inlineLambda.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("lambdaOnSecondLine.kt")
            public void testLambdaOnSecondLine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/lambdaOnSecondLine.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("oneLineFunctionalExpression.kt")
            public void testOneLineFunctionalExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/oneLineFunctionalExpression.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("oneLineLambda.kt")
            public void testOneLineLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/oneLineLambda.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("twoLambdasOnOneLineFirst.kt")
            public void testTwoLambdasOnOneLineFirst() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/twoLambdasOnOneLineFirst.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("twoLambdasOnOneLineSecond.kt")
            public void testTwoLambdasOnOneLineSecond() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/twoLambdasOnOneLineSecond.kt");
                doSingleBreakpointTest(fileName);
            }

            @TestMetadata("underscoreNames.kt")
            public void testUnderscoreNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/lambdas/underscoreNames.kt");
                doSingleBreakpointTest(fileName);
            }
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/renderer")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Renderer extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInRenderer() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/renderer"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("toStringRenderer.kt")
            public void testToStringRenderer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/singleBreakpoint/renderer/toStringRenderer.kt");
                doSingleBreakpointTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultipleBreakpoints extends AbstractKotlinEvaluateExpressionTest {
        public void testAllFilesPresentInMultipleBreakpoints() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("clearCache.kt")
        public void testClearCache() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/clearCache.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("constructors.kt")
        public void testConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/constructors.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("exceptions.kt")
        public void testExceptions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/exceptions.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("extensionMemberFunction.kt")
        public void testExtensionMemberFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/extensionMemberFunction.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("extensionMemberProperty.kt")
        public void testExtensionMemberProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/extensionMemberProperty.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("funFromOuterClassInLamdba.kt")
        public void testFunFromOuterClassInLamdba() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/funFromOuterClassInLamdba.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("initializer.kt")
        public void testInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/initializer.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("isInsideInlineLambda.kt")
        public void testIsInsideInlineLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/isInsideInlineLambda.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/localFun.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("multipleBreakpointsAtLine.kt")
        public void testMultipleBreakpointsAtLine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/multipleBreakpointsAtLine.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("privateMembersPriority.kt")
        public void testPrivateMembersPriority() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/privateMembersPriority.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("remappedParameterInInline.kt")
        public void testRemappedParameterInInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/remappedParameterInInline.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("smartcasts.kt")
        public void testSmartcasts() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/smartcasts.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("whenEntry.kt")
        public void testWhenEntry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/whenEntry.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("withoutBodyFunctions.kt")
        public void testWithoutBodyFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/withoutBodyFunctions.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("withoutBodyProperties.kt")
        public void testWithoutBodyProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/withoutBodyProperties.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("withoutBodyProperties2.kt")
        public void testWithoutBodyProperties2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/withoutBodyProperties2.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("withoutBodyTypeParameters.kt")
        public void testWithoutBodyTypeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/withoutBodyTypeParameters.kt");
            doMultipleBreakpointsTest(fileName);
        }

        @TestMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/library")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Library extends AbstractKotlinEvaluateExpressionTest {
            public void testAllFilesPresentInLibrary() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/library"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("customLibClassName.kt")
            public void testCustomLibClassName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/library/customLibClassName.kt");
                doMultipleBreakpointsTest(fileName);
            }

            @TestMetadata("localFunInLibrary.kt")
            public void testLocalFunInLibrary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/debugger/tinyApp/src/evaluate/multipleBreakpoints/library/localFunInLibrary.kt");
                doMultipleBreakpointsTest(fileName);
            }
        }
    }
}
