/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.intentions;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/intentions")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IntentionTestGenerated extends AbstractIntentionTest {
    public void testAllFilesPresentInIntentions() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("idea/testData/intentions/addBraces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddBraces extends AbstractIntentionTest {
        @TestMetadata("addBracesForDoWhile.kt")
        public void testAddBracesForDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/addBracesForDoWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("addBracesForElse.kt")
        public void testAddBracesForElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/addBracesForElse.kt");
            doTest(fileName);
        }

        @TestMetadata("addBracesForFor.kt")
        public void testAddBracesForFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/addBracesForFor.kt");
            doTest(fileName);
        }

        @TestMetadata("addBracesForIf.kt")
        public void testAddBracesForIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/addBracesForIf.kt");
            doTest(fileName);
        }

        @TestMetadata("addBracesForIfWithNoSpace.kt")
        public void testAddBracesForIfWithNoSpace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/addBracesForIfWithNoSpace.kt");
            doTest(fileName);
        }

        @TestMetadata("addBracesForIfWithSemicolon.kt")
        public void testAddBracesForIfWithSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/addBracesForIfWithSemicolon.kt");
            doTest(fileName);
        }

        @TestMetadata("addBracesForWhile.kt")
        public void testAddBracesForWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/addBracesForWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("addBracesWithBraces.kt")
        public void testAddBracesWithBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/addBracesWithBraces.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInAddBraces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addBraces"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notInsideElseIfBlock.kt")
        public void testNotInsideElseIfBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/notInsideElseIfBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("whenHasBraces.kt")
        public void testWhenHasBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/whenHasBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("whenSimple.kt")
        public void testWhenSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addBraces/whenSimple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/addConstModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddConstModifier extends AbstractIntentionTest {
        public void testAllFilesPresentInAddConstModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addConstModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicableToConst.kt")
        public void testInapplicableToConst() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addConstModifier/inapplicableToConst.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableToOverride.kt")
        public void testInapplicableToOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addConstModifier/inapplicableToOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("removeJvmField.kt")
        public void testRemoveJvmField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addConstModifier/removeJvmField.kt");
            doTest(fileName);
        }

        @TestMetadata("removeJvmStatic.kt")
        public void testRemoveJvmStatic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addConstModifier/removeJvmStatic.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addConstModifier/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/addForLoopIndices")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddForLoopIndices extends AbstractIntentionTest {
        public void testAllFilesPresentInAddForLoopIndices() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addForLoopIndices"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("explicitParamType.kt")
        public void testExplicitParamType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/explicitParamType.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableExistingIndices.kt")
        public void testInapplicableExistingIndices() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/inapplicableExistingIndices.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableInBody.kt")
        public void testInapplicableInBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/inapplicableInBody.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableOnMap.kt")
        public void testInapplicableOnMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/inapplicableOnMap.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableOverridenFunction.kt")
        public void testInapplicableOverridenFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/inapplicableOverridenFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableUnresolved.kt")
        public void testInapplicableUnresolved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/inapplicableUnresolved.kt");
            doTest(fileName);
        }

        @TestMetadata("intArray.kt")
        public void testIntArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/intArray.kt");
            doTest(fileName);
        }

        @TestMetadata("iterable.kt")
        public void testIterable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/iterable.kt");
            doTest(fileName);
        }

        @TestMetadata("noBody.kt")
        public void testNoBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/noBody.kt");
            doTest(fileName);
        }

        @TestMetadata("objectArray.kt")
        public void testObjectArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/objectArray.kt");
            doTest(fileName);
        }

        @TestMetadata("sequence.kt")
        public void testSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/sequence.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleIntList.kt")
        public void testSimpleIntList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/simpleIntList.kt");
            doTest(fileName);
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addForLoopIndices/string.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/addJvmOverloads")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddJvmOverloads extends AbstractIntentionTest {
        public void testAllFilesPresentInAddJvmOverloads() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addJvmOverloads"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyHasAnnotation.kt")
        public void testAlreadyHasAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addJvmOverloads/alreadyHasAnnotation.kt");
            doTest(fileName);
        }

        @TestMetadata("method.kt")
        public void testMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addJvmOverloads/method.kt");
            doTest(fileName);
        }

        @TestMetadata("noDefaultParams.kt")
        public void testNoDefaultParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addJvmOverloads/noDefaultParams.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryConstructor.kt")
        public void testPrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addJvmOverloads/primaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryConstructorOneWithDefault.kt")
        public void testPrimaryConstructorOneWithDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addJvmOverloads/primaryConstructorOneWithDefault.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryConstructorWithConstructorKeyword.kt")
        public void testPrimaryConstructorWithConstructorKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addJvmOverloads/primaryConstructorWithConstructorKeyword.kt");
            doTest(fileName);
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addJvmOverloads/secondaryConstructor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/addNameToArgument")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddNameToArgument extends AbstractIntentionTest {
        public void testAllFilesPresentInAddNameToArgument() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addNameToArgument"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyNamed.kt")
        public void testAlreadyNamed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/alreadyNamed.kt");
            doTest(fileName);
        }

        @TestMetadata("ambiguousCall.kt")
        public void testAmbiguousCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/ambiguousCall.kt");
            doTest(fileName);
        }

        @TestMetadata("beforeOtherNamed.kt")
        public void testBeforeOtherNamed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/beforeOtherNamed.kt");
            doTest(fileName);
        }

        @TestMetadata("functionLiteralArgument.kt")
        public void testFunctionLiteralArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/functionLiteralArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("incompleteCall.kt")
        public void testIncompleteCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/incompleteCall.kt");
            doTest(fileName);
        }

        @TestMetadata("javaMethod.kt")
        public void testJavaMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/javaMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11679.kt")
        public void testKt11679() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/kt11679.kt");
            doTest(fileName);
        }

        @TestMetadata("notInsideIndices.kt")
        public void testNotInsideIndices() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/notInsideIndices.kt");
            doTest(fileName);
        }

        @TestMetadata("notInsideNestedArgumentList.kt")
        public void testNotInsideNestedArgumentList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/notInsideNestedArgumentList.kt");
            doTest(fileName);
        }

        @TestMetadata("notInsideNestedArgumentList2.kt")
        public void testNotInsideNestedArgumentList2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/notInsideNestedArgumentList2.kt");
            doTest(fileName);
        }

        @TestMetadata("notLast.kt")
        public void testNotLast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/notLast.kt");
            doTest(fileName);
        }

        @TestMetadata("notResolved.kt")
        public void testNotResolved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/notResolved.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeForLambda1.kt")
        public void testRangeForLambda1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/rangeForLambda1.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeForLambda2.kt")
        public void testRangeForLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/rangeForLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeForLambda3.kt")
        public void testRangeForLambda3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/rangeForLambda3.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("superClassConstructor.kt")
        public void testSuperClassConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/superClassConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg1.kt")
        public void testVararg1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/vararg1.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg2.kt")
        public void testVararg2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/vararg2.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg3.kt")
        public void testVararg3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addNameToArgument/vararg3.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/addOperatorModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddOperatorModifier extends AbstractIntentionTest {
        public void testAllFilesPresentInAddOperatorModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addOperatorModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("containsBool.kt")
        public void testContainsBool() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addOperatorModifier/containsBool.kt");
            doTest(fileName);
        }

        @TestMetadata("containsInt.kt")
        public void testContainsInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addOperatorModifier/containsInt.kt");
            doTest(fileName);
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addOperatorModifier/extension.kt");
            doTest(fileName);
        }

        @TestMetadata("forOverride.kt")
        public void testForOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addOperatorModifier/forOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("overridden.kt")
        public void testOverridden() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addOperatorModifier/overridden.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addOperatorModifier/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("toplevel.kt")
        public void testToplevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addOperatorModifier/toplevel.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/addValOrVar")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddValOrVar extends AbstractIntentionTest {
        @TestMetadata("addVal.kt")
        public void testAddVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addValOrVar/addVal.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInAddValOrVar() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addValOrVar"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addValOrVar/dataClass.kt");
            doTest(fileName);
        }

        @TestMetadata("funParameter.kt")
        public void testFunParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addValOrVar/funParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("hasVal.kt")
        public void testHasVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addValOrVar/hasVal.kt");
            doTest(fileName);
        }

        @TestMetadata("hasVar.kt")
        public void testHasVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addValOrVar/hasVar.kt");
            doTest(fileName);
        }

        @TestMetadata("outOfRange.kt")
        public void testOutOfRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addValOrVar/outOfRange.kt");
            doTest(fileName);
        }

        @TestMetadata("secondaryConstructorParameter.kt")
        public void testSecondaryConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/addValOrVar/secondaryConstructorParameter.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/anonymousFunctionToLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AnonymousFunctionToLambda extends AbstractIntentionTest {
        public void testAllFilesPresentInAnonymousFunctionToLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/anonymousFunctionToLambda"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callMultiline.kt")
        public void testCallMultiline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/callMultiline.kt");
            doTest(fileName);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyBody.kt")
        public void testEmptyBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/emptyBody.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionBody.kt")
        public void testExpressionBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/expressionBody.kt");
            doTest(fileName);
        }

        @TestMetadata("fullParam.kt")
        public void testFullParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/fullParam.kt");
            doTest(fileName);
        }

        @TestMetadata("moveOut.kt")
        public void testMoveOut() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/moveOut.kt");
            doTest(fileName);
        }

        @TestMetadata("paramName.kt")
        public void testParamName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/paramName.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceReturnWithExpression.kt")
        public void testReplaceReturnWithExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/replaceReturnWithExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceReturnWithLabel.kt")
        public void testReplaceReturnWithLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/replaceReturnWithLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/anonymousFunctionToLambda/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/branched")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Branched extends AbstractIntentionTest {
        public void testAllFilesPresentInBranched() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/branched/doubleBangToIfThen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DoubleBangToIfThen extends AbstractIntentionTest {
            public void testAllFilesPresentInDoubleBangToIfThen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/doubleBangToIfThen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/callExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("callExpressionParens.kt")
            public void testCallExpressionParens() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/callExpressionParens.kt");
                doTest(fileName);
            }

            @TestMetadata("exceptionTextEscapesQuotes.kt")
            public void testExceptionTextEscapesQuotes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/exceptionTextEscapesQuotes.kt");
                doTest(fileName);
            }

            @TestMetadata("exceptionTextHandlesMultiline.kt")
            public void testExceptionTextHandlesMultiline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/exceptionTextHandlesMultiline.kt");
                doTest(fileName);
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/localVal.kt");
                doTest(fileName);
            }

            @TestMetadata("localVar.kt")
            public void testLocalVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/localVar.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleNameExpressionInParens.kt")
            public void testSimpleNameExpressionInParens() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/simpleNameExpressionInParens.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVal.kt")
            public void testTopLevelVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/topLevelVal.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelValCustomGetter.kt")
            public void testTopLevelValCustomGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/topLevelValCustomGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVar.kt")
            public void testTopLevelVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/topLevelVar.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVarCustomGetter.kt")
            public void testTopLevelVarCustomGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/topLevelVarCustomGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInAssignment.kt")
            public void testUsedInAssignment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/doubleBangToIfThen/usedInAssignment.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/branched/elvisToIfThen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ElvisToIfThen extends AbstractIntentionTest {
            public void testAllFilesPresentInElvisToIfThen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/elvisToIfThen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/callExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("callExpressionParens.kt")
            public void testCallExpressionParens() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/callExpressionParens.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisAsExpression.kt")
            public void testElvisAsExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/elvisAsExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("localValLhs.kt")
            public void testLocalValLhs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/localValLhs.kt");
                doTest(fileName);
            }

            @TestMetadata("localVarLhs.kt")
            public void testLocalVarLhs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/localVarLhs.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleNameExpression.kt")
            public void testSimpleNameExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/simpleNameExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleNameExpressionInParens.kt")
            public void testSimpleNameExpressionInParens() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/simpleNameExpressionInParens.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVal.kt")
            public void testTopLevelVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/topLevelVal.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelValCustomGetter.kt")
            public void testTopLevelValCustomGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/topLevelValCustomGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVar.kt")
            public void testTopLevelVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/topLevelVar.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVarCustomGetter.kt")
            public void testTopLevelVarCustomGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/elvisToIfThen/topLevelVarCustomGetter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/branched/folding")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Folding extends AbstractIntentionTest {
            public void testAllFilesPresentInFolding() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/folding"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/branched/folding/ifToAssignment")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class IfToAssignment extends AbstractIntentionTest {
                public void testAllFilesPresentInIfToAssignment() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/folding/ifToAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ifElseIf.kt")
                public void testIfElseIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/ifElseIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifElseIfElse.kt")
                public void testIfElseIfElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/ifElseIfElse.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifElseifElseInconsistent.kt")
                public void testIfElseifElseInconsistent() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/ifElseifElseInconsistent.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerIfTransformed.kt")
                public void testInnerIfTransformed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/innerIfTransformed.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/simpleIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithAugmentedAssignment.kt")
                public void testSimpleIfWithAugmentedAssignment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/simpleIfWithAugmentedAssignment.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/simpleIfWithBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithShadowedVar.kt")
                public void testSimpleIfWithShadowedVar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/simpleIfWithShadowedVar.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithUnmatchedAssignmentOps.kt")
                public void testSimpleIfWithUnmatchedAssignmentOps() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/simpleIfWithUnmatchedAssignmentOps.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithUnmatchedAssignments.kt")
                public void testSimpleIfWithUnmatchedAssignments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/simpleIfWithUnmatchedAssignments.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithoutElse.kt")
                public void testSimpleIfWithoutElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/simpleIfWithoutElse.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithoutTerminatingAssignment.kt")
                public void testSimpleIfWithoutTerminatingAssignment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToAssignment/simpleIfWithoutTerminatingAssignment.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/folding/ifToReturn")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class IfToReturn extends AbstractIntentionTest {
                public void testAllFilesPresentInIfToReturn() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/folding/ifToReturn"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ifElseIf.kt")
                public void testIfElseIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturn/ifElseIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifElseIfElse.kt")
                public void testIfElseIfElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturn/ifElseIfElse.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifElseIfElseInconsistent.kt")
                public void testIfElseIfElseInconsistent() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturn/ifElseIfElseInconsistent.kt");
                    doTest(fileName);
                }

                @TestMetadata("innerIfTransformed.kt")
                public void testInnerIfTransformed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturn/innerIfTransformed.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturn/simpleIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturn/simpleIfWithBlocks.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class IfToReturnAsymmetrically extends AbstractIntentionTest {
                public void testAllFilesPresentInIfToReturnAsymmetrically() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically/simpleIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically/simpleIfWithBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithComments.kt")
                public void testSimpleIfWithComments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically/simpleIfWithComments.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/folding/whenToAssignment")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WhenToAssignment extends AbstractIntentionTest {
                public void testAllFilesPresentInWhenToAssignment() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/folding/whenToAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerWhenTransformed.kt")
                public void testInnerWhenTransformed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToAssignment/innerWhenTransformed.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhen.kt")
                public void testSimpleWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToAssignment/simpleWhen.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithBlocks.kt")
                public void testSimpleWhenWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToAssignment/simpleWhenWithBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithShadowedVar.kt")
                public void testSimpleWhenWithShadowedVar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToAssignment/simpleWhenWithShadowedVar.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithUnmatchedAssignments.kt")
                public void testSimpleWhenWithUnmatchedAssignments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToAssignment/simpleWhenWithUnmatchedAssignments.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithoutTerminatingAssignment.kt")
                public void testSimpleWhenWithoutTerminatingAssignment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToAssignment/simpleWhenWithoutTerminatingAssignment.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/folding/whenToReturn")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WhenToReturn extends AbstractIntentionTest {
                public void testAllFilesPresentInWhenToReturn() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/folding/whenToReturn"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerWhenTransformed.kt")
                public void testInnerWhenTransformed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToReturn/innerWhenTransformed.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhen.kt")
                public void testSimpleWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToReturn/simpleWhen.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithBlocks.kt")
                public void testSimpleWhenWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/folding/whenToReturn/simpleWhenWithBlocks.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/intentions/branched/ifThenToDoubleBang")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IfThenToDoubleBang extends AbstractIntentionTest {
            @TestMetadata("acceptableEmptyElseBlockForStatement.kt")
            public void testAcceptableEmptyElseBlockForStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/acceptableEmptyElseBlockForStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("acceptableEmptyThenBlockForStatement.kt")
            public void testAcceptableEmptyThenBlockForStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/acceptableEmptyThenBlockForStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("acceptableWithoutElseBlockForStatementWithFun.kt")
            public void testAcceptableWithoutElseBlockForStatementWithFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/acceptableWithoutElseBlockForStatementWithFun.kt");
                doTest(fileName);
            }

            @TestMetadata("acceptableWithoutElseBlockForStatementWithVal.kt")
            public void testAcceptableWithoutElseBlockForStatementWithVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/acceptableWithoutElseBlockForStatementWithVal.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInIfThenToDoubleBang() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifThenToDoubleBang"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("blockHasMoreThanOneStatement.kt")
            public void testBlockHasMoreThanOneStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/blockHasMoreThanOneStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("blockUsesDifferentVar.kt")
            public void testBlockUsesDifferentVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/blockUsesDifferentVar.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionComparesNullWithNull.kt")
            public void testConditionComparesNullWithNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/conditionComparesNullWithNull.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionInvalidBinaryExp.kt")
            public void testConditionInvalidBinaryExp() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/conditionInvalidBinaryExp.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionNotBinaryExpr.kt")
            public void testConditionNotBinaryExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/conditionNotBinaryExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("doesNotinlineValueIfUsedMoreThanOnce.kt")
            public void testDoesNotinlineValueIfUsedMoreThanOnce() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/doesNotinlineValueIfUsedMoreThanOnce.kt");
                doTest(fileName);
            }

            @TestMetadata("doesNotinlineValueOutsideOfScope.kt")
            public void testDoesNotinlineValueOutsideOfScope() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/doesNotinlineValueOutsideOfScope.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyCondition.kt")
            public void testEmptyCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/emptyCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyElseBlock.kt")
            public void testEmptyElseBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/emptyElseBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyThenBlock.kt")
            public void testEmptyThenBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/emptyThenBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAndElseBothInBlocks.kt")
            public void testIfAndElseBothInBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/ifAndElseBothInBlocks.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAndElseNotInBlocks.kt")
            public void testIfAndElseNotInBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/ifAndElseNotInBlocks.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAsExpression.kt")
            public void testIfAsExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/ifAsExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("lhsEqualsNull.kt")
            public void testLhsEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/lhsEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("lhsNotEqualsNull.kt")
            public void testLhsNotEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/lhsNotEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("missingElseClause.kt")
            public void testMissingElseClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/missingElseClause.kt");
                doTest(fileName);
            }

            @TestMetadata("missingThenClause.kt")
            public void testMissingThenClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/missingThenClause.kt");
                doTest(fileName);
            }

            @TestMetadata("noCondition.kt")
            public void testNoCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/noCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("noNullInCondition.kt")
            public void testNoNullInCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/noNullInCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableForFunction.kt")
            public void testNotApplicableForFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/notApplicableForFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableForLocalVar.kt")
            public void testNotApplicableForLocalVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/notApplicableForLocalVar.kt");
                doTest(fileName);
            }

            @TestMetadata("nullBranchAlsoNull.kt")
            public void testNullBranchAlsoNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/nullBranchAlsoNull.kt");
                doTest(fileName);
            }

            @TestMetadata("otherBlockHasMoreThanOneStatement.kt")
            public void testOtherBlockHasMoreThanOneStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/otherBlockHasMoreThanOneStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("rhsEqualsNull.kt")
            public void testRhsEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/rhsEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("rhsNotEqualsNull.kt")
            public void testRhsNotEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/rhsNotEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("thenAndElseBothNull.kt")
            public void testThenAndElseBothNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/thenAndElseBothNull.kt");
                doTest(fileName);
            }

            @TestMetadata("throwByFqName.kt")
            public void testThrowByFqName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/throwByFqName.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableEmptyElseBlockForExpression.kt")
            public void testUnacceptableEmptyElseBlockForExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/unacceptableEmptyElseBlockForExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableEmptyThenBlockForExpression.kt")
            public void testUnacceptableEmptyThenBlockForExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/unacceptableEmptyThenBlockForExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("willNotInlineClassProperty.kt")
            public void testWillNotInlineClassProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToDoubleBang/willNotInlineClassProperty.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/branched/ifThenToElvis")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IfThenToElvis extends AbstractIntentionTest {
            public void testAllFilesPresentInIfThenToElvis() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifThenToElvis"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("blockHasMoreThanOneStatement.kt")
            public void testBlockHasMoreThanOneStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/blockHasMoreThanOneStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("blockUsesDifferentVar.kt")
            public void testBlockUsesDifferentVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/blockUsesDifferentVar.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionComparesNullWithNull.kt")
            public void testConditionComparesNullWithNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/conditionComparesNullWithNull.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionInvalidBinaryExp.kt")
            public void testConditionInvalidBinaryExp() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/conditionInvalidBinaryExp.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionNotBinaryExpr.kt")
            public void testConditionNotBinaryExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/conditionNotBinaryExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("doesNotInlineVariableInMultiDeclaration.kt")
            public void testDoesNotInlineVariableInMultiDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/doesNotInlineVariableInMultiDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("doesNotinlineValueIfUsedMoreThanOnce.kt")
            public void testDoesNotinlineValueIfUsedMoreThanOnce() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/doesNotinlineValueIfUsedMoreThanOnce.kt");
                doTest(fileName);
            }

            @TestMetadata("doesNotinlineValueOutsideOfScope.kt")
            public void testDoesNotinlineValueOutsideOfScope() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/doesNotinlineValueOutsideOfScope.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyCondition.kt")
            public void testEmptyCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/emptyCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyElseBlock.kt")
            public void testEmptyElseBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/emptyElseBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyThenBlock.kt")
            public void testEmptyThenBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/emptyThenBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAndElseBothInBlocks.kt")
            public void testIfAndElseBothInBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/ifAndElseBothInBlocks.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAndElseNotInBlocks.kt")
            public void testIfAndElseNotInBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/ifAndElseNotInBlocks.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAsExpression.kt")
            public void testIfAsExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/ifAsExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAsPartOfExpression.kt")
            public void testIfAsPartOfExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/ifAsPartOfExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("isCheck.kt")
            public void testIsCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/isCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("isCheckForNullableType.kt")
            public void testIsCheckForNullableType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/isCheckForNullableType.kt");
                doTest(fileName);
            }

            @TestMetadata("isCheckForUnrelatedType.kt")
            public void testIsCheckForUnrelatedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/isCheckForUnrelatedType.kt");
                doTest(fileName);
            }

            @TestMetadata("isCheckWithSelector.kt")
            public void testIsCheckWithSelector() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/isCheckWithSelector.kt");
                doTest(fileName);
            }

            @TestMetadata("isCheckWithSelectorChain.kt")
            public void testIsCheckWithSelectorChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/isCheckWithSelectorChain.kt");
                doTest(fileName);
            }

            @TestMetadata("lhsEqualsNull.kt")
            public void testLhsEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/lhsEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("lhsNotEqualsNull.kt")
            public void testLhsNotEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/lhsNotEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("missingElseClause.kt")
            public void testMissingElseClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/missingElseClause.kt");
                doTest(fileName);
            }

            @TestMetadata("missingThenClause.kt")
            public void testMissingThenClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/missingThenClause.kt");
                doTest(fileName);
            }

            @TestMetadata("noCondition.kt")
            public void testNoCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/noCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("noNullInCondition.kt")
            public void testNoNullInCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/noNullInCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableForFunction.kt")
            public void testNotApplicableForFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/notApplicableForFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableForLocalVar.kt")
            public void testNotApplicableForLocalVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/notApplicableForLocalVar.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableForSimpleKotlinNPE.kt")
            public void testNotApplicableForSimpleKotlinNPE() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/notApplicableForSimpleKotlinNPE.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableForSimpleNPE.kt")
            public void testNotApplicableForSimpleNPE() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/notApplicableForSimpleNPE.kt");
                doTest(fileName);
            }

            @TestMetadata("notIsCheck.kt")
            public void testNotIsCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/notIsCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("nullBranchAlsoNull.kt")
            public void testNullBranchAlsoNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/nullBranchAlsoNull.kt");
                doTest(fileName);
            }

            @TestMetadata("nullCheckWithSelector.kt")
            public void testNullCheckWithSelector() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/nullCheckWithSelector.kt");
                doTest(fileName);
            }

            @TestMetadata("nullCheckWithSelectorCall.kt")
            public void testNullCheckWithSelectorCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/nullCheckWithSelectorCall.kt");
                doTest(fileName);
            }

            @TestMetadata("nullCheckWithSelectorCallChain.kt")
            public void testNullCheckWithSelectorCallChain() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/nullCheckWithSelectorCallChain.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableThen.kt")
            public void testNullableThen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/nullableThen.kt");
                doTest(fileName);
            }

            @TestMetadata("otherBlockHasMoreThanOneStatement.kt")
            public void testOtherBlockHasMoreThanOneStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/otherBlockHasMoreThanOneStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("rhsEqualsNull.kt")
            public void testRhsEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/rhsEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("rhsNotEqualsNull.kt")
            public void testRhsNotEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/rhsNotEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("thenAndElseBothNull.kt")
            public void testThenAndElseBothNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/thenAndElseBothNull.kt");
                doTest(fileName);
            }

            @TestMetadata("throwsNPEwithArgument.kt")
            public void testThrowsNPEwithArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/throwsNPEwithArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("unitResult.kt")
            public void testUnitResult() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/unitResult.kt");
                doTest(fileName);
            }

            @TestMetadata("willNotInlineClassProperty.kt")
            public void testWillNotInlineClassProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToElvis/willNotInlineClassProperty.kt");
                doTest(fileName);
            }

        }

        @TestMetadata("idea/testData/intentions/branched/ifThenToSafeAccess")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IfThenToSafeAccess extends AbstractIntentionTest {
            public void testAllFilesPresentInIfThenToSafeAccess() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifThenToSafeAccess"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("blockHasMoreThanOneStatement.kt")
            public void testBlockHasMoreThanOneStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/blockHasMoreThanOneStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("blockUsesDifferentVar.kt")
            public void testBlockUsesDifferentVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/blockUsesDifferentVar.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionComparesNullWithNull.kt")
            public void testConditionComparesNullWithNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/conditionComparesNullWithNull.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionInvalidBinaryExp.kt")
            public void testConditionInvalidBinaryExp() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/conditionInvalidBinaryExp.kt");
                doTest(fileName);
            }

            @TestMetadata("conditionNotBinaryExpr.kt")
            public void testConditionNotBinaryExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/conditionNotBinaryExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("doesNotinlineValueIfUsedMoreThanOnce.kt")
            public void testDoesNotinlineValueIfUsedMoreThanOnce() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/doesNotinlineValueIfUsedMoreThanOnce.kt");
                doTest(fileName);
            }

            @TestMetadata("doesNotinlineValueOutsideOfScope.kt")
            public void testDoesNotinlineValueOutsideOfScope() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/doesNotinlineValueOutsideOfScope.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyCondition.kt")
            public void testEmptyCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/emptyCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyElseBlock.kt")
            public void testEmptyElseBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/emptyElseBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyThenBlock.kt")
            public void testEmptyThenBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/emptyThenBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAndElseBothInBlocks.kt")
            public void testIfAndElseBothInBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/ifAndElseBothInBlocks.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAndElseNotInBlocks.kt")
            public void testIfAndElseNotInBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/ifAndElseNotInBlocks.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAsExpression.kt")
            public void testIfAsExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/ifAsExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("lhsEqualsNull.kt")
            public void testLhsEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/lhsEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("lhsNotEqualsNull.kt")
            public void testLhsNotEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/lhsNotEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("missingNecessaryElseClause.kt")
            public void testMissingNecessaryElseClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/missingNecessaryElseClause.kt");
                doTest(fileName);
            }

            @TestMetadata("missingNecessaryThenClause.kt")
            public void testMissingNecessaryThenClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/missingNecessaryThenClause.kt");
                doTest(fileName);
            }

            @TestMetadata("noCondition.kt")
            public void testNoCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/noCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("noElseBlock.kt")
            public void testNoElseBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/noElseBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("noNullInCondition.kt")
            public void testNoNullInCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/noNullInCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("noNullInCondition2.kt")
            public void testNoNullInCondition2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/noNullInCondition2.kt");
                doTest(fileName);
            }

            @TestMetadata("noThenBlock.kt")
            public void testNoThenBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/noThenBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableForFunction.kt")
            public void testNotApplicableForFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/notApplicableForFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableForLocalVar.kt")
            public void testNotApplicableForLocalVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/notApplicableForLocalVar.kt");
                doTest(fileName);
            }

            @TestMetadata("otherBlockHasMoreThanOneStatement.kt")
            public void testOtherBlockHasMoreThanOneStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/otherBlockHasMoreThanOneStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("rhsEqualsNull.kt")
            public void testRhsEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/rhsEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("rhsNotEqualsNull.kt")
            public void testRhsNotEqualsNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/rhsNotEqualsNull.kt");
                doTest(fileName);
            }

            @TestMetadata("thenAndElseBothNull.kt")
            public void testThenAndElseBothNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/thenAndElseBothNull.kt");
                doTest(fileName);
            }

            @TestMetadata("thenAndElseNotNull.kt")
            public void testThenAndElseNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/thenAndElseNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableEmptyElseBlock.kt")
            public void testUnacceptableEmptyElseBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/unacceptableEmptyElseBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableEmptyThenBlock.kt")
            public void testUnacceptableEmptyThenBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/unacceptableEmptyThenBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableNoElseBlock.kt")
            public void testUnacceptableNoElseBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/unacceptableNoElseBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableNoThenBlock.kt")
            public void testUnacceptableNoThenBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/unacceptableNoThenBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("willNotInlineClassProperty.kt")
            public void testWillNotInlineClassProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifThenToSafeAccess/willNotInlineClassProperty.kt");
                doTest(fileName);
            }

        }

        @TestMetadata("idea/testData/intentions/branched/ifWhen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IfWhen extends AbstractIntentionTest {
            public void testAllFilesPresentInIfWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifWhen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class IfToWhen extends AbstractIntentionTest {
                public void testAllFilesPresentInIfToWhen() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifWhen/ifToWhen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("combinedIf.kt")
                public void testCombinedIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/combinedIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("comment.kt")
                public void testComment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/comment.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifElseSwallowComments.kt")
                public void testIfElseSwallowComments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifElseSwallowComments.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifElseSwallowReturnComment.kt")
                public void testIfElseSwallowReturnComment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifElseSwallowReturnComment.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifElseSwallowTail.kt")
                public void testIfElseSwallowTail() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifElseSwallowTail.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithEqualityTests.kt")
                public void testIfWithEqualityTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithEqualityTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithIs.kt")
                public void testIfWithIs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithIs.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithMultiConditions.kt")
                public void testIfWithMultiConditions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithMultiConditions.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithNegativeIs.kt")
                public void testIfWithNegativeIs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithNegativeIs.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithNegativeRangeTests.kt")
                public void testIfWithNegativeRangeTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithNegativeRangeTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithRangeTests.kt")
                public void testIfWithRangeTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithRangeTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithRangeTestsAndMultiConditions.kt")
                public void testIfWithRangeTestsAndMultiConditions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithRangeTestsAndMultiConditions.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithRangeTestsAndUnparenthesizedMultiConditions.kt")
                public void testIfWithRangeTestsAndUnparenthesizedMultiConditions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithRangeTestsAndUnparenthesizedMultiConditions.kt");
                    doTest(fileName);
                }

                @TestMetadata("ifWithoutElse.kt")
                public void testIfWithoutElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithoutElse.kt");
                    doTest(fileName);
                }

                @TestMetadata("multipleIfFake.kt")
                public void testMultipleIfFake() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/multipleIfFake.kt");
                    doTest(fileName);
                }

                @TestMetadata("multipleIfWithLongBranches.kt")
                public void testMultipleIfWithLongBranches() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/multipleIfWithLongBranches.kt");
                    doTest(fileName);
                }

                @TestMetadata("multipleIfWithReturns.kt")
                public void testMultipleIfWithReturns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/multipleIfWithReturns.kt");
                    doTest(fileName);
                }

                @TestMetadata("multipleIfWithSingleReturns.kt")
                public void testMultipleIfWithSingleReturns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/multipleIfWithSingleReturns.kt");
                    doTest(fileName);
                }

                @TestMetadata("secondIfNoThen.kt")
                public void testSecondIfNoThen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/secondIfNoThen.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithMultipleConditionTypes.kt")
                public void testWhenWithMultipleConditionTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen/whenWithMultipleConditionTypes.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/ifWhen/whenToIf")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WhenToIf extends AbstractIntentionTest {
                public void testAllFilesPresentInWhenToIf() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifWhen/whenToIf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("comment.kt")
                public void testComment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/comment.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt12040.kt")
                public void testKt12040() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/kt12040.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt13884.kt")
                public void testKt13884() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/kt13884.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithDotQualifiedExpression.kt")
                public void testWhenWithDotQualifiedExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithDotQualifiedExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithEqualityTests.kt")
                public void testWhenWithEqualityTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithEqualityTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithIf.kt")
                public void testWhenWithIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithMultiConditions.kt")
                public void testWhenWithMultiConditions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithMultiConditions.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithMultipleConditionTypes.kt")
                public void testWhenWithMultipleConditionTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithMultipleConditionTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithNegativePatterns.kt")
                public void testWhenWithNegativePatterns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithNegativePatterns.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithNegativeRangeTests.kt")
                public void testWhenWithNegativeRangeTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithNegativeRangeTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithPatterns.kt")
                public void testWhenWithPatterns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithPatterns.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithRangeTests.kt")
                public void testWhenWithRangeTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithRangeTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithRangeTestsAndMultiConditions.kt")
                public void testWhenWithRangeTestsAndMultiConditions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithRangeTestsAndMultiConditions.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithoutElse.kt")
                public void testWhenWithoutElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithoutElse.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithoutSubject.kt")
                public void testWhenWithoutSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithoutSubject.kt");
                    doTest(fileName);
                }

                @TestMetadata("wrongIsAndInNoEnd.kt")
                public void testWrongIsAndInNoEnd() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/wrongIsAndInNoEnd.kt");
                    doTest(fileName);
                }

                @TestMetadata("wrongIsAndInNoSubject.kt")
                public void testWrongIsAndInNoSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/ifWhen/whenToIf/wrongIsAndInNoSubject.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/intentions/branched/safeAccessToIfThen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SafeAccessToIfThen extends AbstractIntentionTest {
            public void testAllFilesPresentInSafeAccessToIfThen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/safeAccessToIfThen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("binaryExpressionLhs.kt")
            public void testBinaryExpressionLhs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/binaryExpressionLhs.kt");
                doTest(fileName);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/callExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("callExpressionParens.kt")
            public void testCallExpressionParens() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/callExpressionParens.kt");
                doTest(fileName);
            }

            @TestMetadata("customGetterAsReceiver.kt")
            public void testCustomGetterAsReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/customGetterAsReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("localValAsReceiver.kt")
            public void testLocalValAsReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/localValAsReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("localValLhs.kt")
            public void testLocalValLhs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/localValLhs.kt");
                doTest(fileName);
            }

            @TestMetadata("localVarLhs.kt")
            public void testLocalVarLhs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/localVarLhs.kt");
                doTest(fileName);
            }

            @TestMetadata("resultAssignedToLocalVal.kt")
            public void testResultAssignedToLocalVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/resultAssignedToLocalVal.kt");
                doTest(fileName);
            }

            @TestMetadata("safeAccessAsFunctionArgument.kt")
            public void testSafeAccessAsFunctionArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/safeAccessAsFunctionArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleNameExpression.kt")
            public void testSimpleNameExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/simpleNameExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleNameExpressionInParens.kt")
            public void testSimpleNameExpressionInParens() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/simpleNameExpressionInParens.kt");
                doTest(fileName);
            }

            @TestMetadata("simplePropertyAsReceiver.kt")
            public void testSimplePropertyAsReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/simplePropertyAsReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("simplePropertyAsReceiver2.kt")
            public void testSimplePropertyAsReceiver2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/simplePropertyAsReceiver2.kt");
                doTest(fileName);
            }

            @TestMetadata("simplePropertyAsReceiver3.kt")
            public void testSimplePropertyAsReceiver3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/simplePropertyAsReceiver3.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVal.kt")
            public void testTopLevelVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/topLevelVal.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelValCustomGetter.kt")
            public void testTopLevelValCustomGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/topLevelValCustomGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVar.kt")
            public void testTopLevelVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/topLevelVar.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVarCustomGetter.kt")
            public void testTopLevelVarCustomGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/topLevelVarCustomGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("usedAsFunctionRhs.kt")
            public void testUsedAsFunctionRhs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/usedAsFunctionRhs.kt");
                doTest(fileName);
            }

            @TestMetadata("usedAsResultOfCheckedIf.kt")
            public void testUsedAsResultOfCheckedIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/usedAsResultOfCheckedIf.kt");
                doTest(fileName);
            }

            @TestMetadata("usedAsReturnValue.kt")
            public void testUsedAsReturnValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/usedAsReturnValue.kt");
                doTest(fileName);
            }

            @TestMetadata("usedInUncheckedIfExpression.kt")
            public void testUsedInUncheckedIfExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/safeAccessToIfThen/usedInUncheckedIfExpression.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/branched/unfolding")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Unfolding extends AbstractIntentionTest {
            public void testAllFilesPresentInUnfolding() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AssignmentToIf extends AbstractIntentionTest {
                public void testAllFilesPresentInAssignmentToIf() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/assignmentToIf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerIfTransformed.kt")
                public void testInnerIfTransformed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf/innerIfTransformed.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedIfs.kt")
                public void testNestedIfs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf/nestedIfs.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithAugmentedAssignment.kt")
                public void testSimpleIfWithAugmentedAssignment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIfWithAugmentedAssignment.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIfWithBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithComplexAssignmentLHS.kt")
                public void testSimpleIfWithComplexAssignmentLHS() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIfWithComplexAssignmentLHS.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithoutAssignment.kt")
                public void testSimpleIfWithoutAssignment() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIfWithoutAssignment.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/assignmentToWhen")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AssignmentToWhen extends AbstractIntentionTest {
                public void testAllFilesPresentInAssignmentToWhen() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/assignmentToWhen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerWhenTransformed.kt")
                public void testInnerWhenTransformed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToWhen/innerWhenTransformed.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhen.kt")
                public void testSimpleWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToWhen/simpleWhen.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithBlocks.kt")
                public void testSimpleWhenWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToWhen/simpleWhenWithBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithComplexAssignmentLHS.kt")
                public void testSimpleWhenWithComplexAssignmentLHS() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/assignmentToWhen/simpleWhenWithComplexAssignmentLHS.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/propertyToIf")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PropertyToIf extends AbstractIntentionTest {
                public void testAllFilesPresentInPropertyToIf() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/propertyToIf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("nestedIfs.kt")
                public void testNestedIfs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/nestedIfs.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedIfs2.kt")
                public void testNestedIfs2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/nestedIfs2.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonLocalProperty.kt")
                public void testNonLocalProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/nonLocalProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonLocalProperty2.kt")
                public void testNonLocalProperty2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/nonLocalProperty2.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIf2.kt")
                public void testSimpleIf2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIf2.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIfWithBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithBlocks2.kt")
                public void testSimpleIfWithBlocks2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIfWithBlocks2.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithType.kt")
                public void testSimpleIfWithType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIfWithType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PropertyToWhen extends AbstractIntentionTest {
                public void testAllFilesPresentInPropertyToWhen() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/propertyToWhen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("nonLocalProperty.kt")
                public void testNonLocalProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen/nonLocalProperty.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonLocalProperty2.kt")
                public void testNonLocalProperty2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen/nonLocalProperty2.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhen.kt")
                public void testSimpleWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhen.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhen2.kt")
                public void testSimpleWhen2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhen2.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithBlocks.kt")
                public void testSimpleWhenWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhenWithBlocks.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithBlocks2.kt")
                public void testSimpleWhenWithBlocks2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhenWithBlocks2.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithType.kt")
                public void testSimpleWhenWithType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhenWithType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/returnToIf")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReturnToIf extends AbstractIntentionTest {
                public void testAllFilesPresentInReturnToIf() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/returnToIf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerIfTransformed.kt")
                public void testInnerIfTransformed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/returnToIf/innerIfTransformed.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/returnToIf/simpleIf.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/returnToIf/simpleIfWithBlocks.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/returnToWhen")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReturnToWhen extends AbstractIntentionTest {
                public void testAllFilesPresentInReturnToWhen() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/returnToWhen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerWhenTransformed.kt")
                public void testInnerWhenTransformed() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/returnToWhen/innerWhenTransformed.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhen.kt")
                public void testSimpleWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/returnToWhen/simpleWhen.kt");
                    doTest(fileName);
                }

                @TestMetadata("simpleWhenWithBlocks.kt")
                public void testSimpleWhenWithBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/unfolding/returnToWhen/simpleWhenWithBlocks.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/intentions/branched/when")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class When extends AbstractIntentionTest {
            public void testAllFilesPresentInWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/branched/when/eliminateSubject")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class EliminateSubject extends AbstractIntentionTest {
                public void testAllFilesPresentInEliminateSubject() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when/eliminateSubject"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("lineBreaksAndComments.kt")
                public void testLineBreaksAndComments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/lineBreaksAndComments.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithEqualityTests.kt")
                public void testWhenWithEqualityTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/whenWithEqualityTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithMultipleConditionTypes.kt")
                public void testWhenWithMultipleConditionTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/whenWithMultipleConditionTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithNegativePatterns.kt")
                public void testWhenWithNegativePatterns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/whenWithNegativePatterns.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithNegativeRangeTests.kt")
                public void testWhenWithNegativeRangeTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/whenWithNegativeRangeTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithPatterns.kt")
                public void testWhenWithPatterns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/whenWithPatterns.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithRangeTests.kt")
                public void testWhenWithRangeTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/whenWithRangeTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithRangeTestsAndMultiConditions.kt")
                public void testWhenWithRangeTestsAndMultiConditions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/whenWithRangeTestsAndMultiConditions.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithoutSubject.kt")
                public void testWhenWithoutSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/eliminateSubject/whenWithoutSubject.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/when/flatten")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Flatten extends AbstractIntentionTest {
                public void testAllFilesPresentInFlatten() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when/flatten"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("flattenWithSubject.kt")
                public void testFlattenWithSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/flatten/flattenWithSubject.kt");
                    doTest(fileName);
                }

                @TestMetadata("flattenWithUnmatchedSubjects.kt")
                public void testFlattenWithUnmatchedSubjects() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/flatten/flattenWithUnmatchedSubjects.kt");
                    doTest(fileName);
                }

                @TestMetadata("flattenWithoutSubject.kt")
                public void testFlattenWithoutSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/flatten/flattenWithoutSubject.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/when/introduceSubject")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class IntroduceSubject extends AbstractIntentionTest {
                public void testAllFilesPresentInIntroduceSubject() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when/introduceSubject"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("lineBreaksAndComments.kt")
                public void testLineBreaksAndComments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/lineBreaksAndComments.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithEqualityTests.kt")
                public void testWhenWithEqualityTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithEqualityTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithMultipleConditionTypes.kt")
                public void testWhenWithMultipleConditionTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithMultipleConditionTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithNegativePatterns.kt")
                public void testWhenWithNegativePatterns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithNegativePatterns.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithNegativeRangeTests.kt")
                public void testWhenWithNegativeRangeTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithNegativeRangeTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithNondivisibleConditions.kt")
                public void testWhenWithNondivisibleConditions() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithNondivisibleConditions.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithPatterns.kt")
                public void testWhenWithPatterns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithPatterns.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithRangeTests.kt")
                public void testWhenWithRangeTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithRangeTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithSubject.kt")
                public void testWhenWithSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithSubject.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithSwappedEqualityTests.kt")
                public void testWhenWithSwappedEqualityTests() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithSwappedEqualityTests.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenWithUnmatchedCandidateSubjects.kt")
                public void testWhenWithUnmatchedCandidateSubjects() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/introduceSubject/whenWithUnmatchedCandidateSubjects.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/intentions/branched/when/merge")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Merge extends AbstractIntentionTest {
                public void testAllFilesPresentInMerge() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when/merge"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("mergeBlockWithBlock.kt")
                public void testMergeBlockWithBlock() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeBlockWithBlock.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeBlockWithSingle.kt")
                public void testMergeBlockWithSingle() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeBlockWithSingle.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithConflictingDeclarations.kt")
                public void testMergeWithConflictingDeclarations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithConflictingDeclarations.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithDeclarations.kt")
                public void testMergeWithDeclarations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithDeclarations.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithReturnAfter.kt")
                public void testMergeWithReturnAfter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithReturnAfter.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithReturnBefore.kt")
                public void testMergeWithReturnBefore() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithReturnBefore.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithSubject.kt")
                public void testMergeWithSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithSubject.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedConditions1.kt")
                public void testMergeWithUnmatchedConditions1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions1.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedConditions2.kt")
                public void testMergeWithUnmatchedConditions2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions2.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedConditions3.kt")
                public void testMergeWithUnmatchedConditions3() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions3.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedConditions4.kt")
                public void testMergeWithUnmatchedConditions4() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions4.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedConditions5.kt")
                public void testMergeWithUnmatchedConditions5() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions5.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedConditions6.kt")
                public void testMergeWithUnmatchedConditions6() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions6.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedConditions7.kt")
                public void testMergeWithUnmatchedConditions7() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions7.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedSubjects1.kt")
                public void testMergeWithUnmatchedSubjects1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedSubjects1.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithUnmatchedSubjects2.kt")
                public void testMergeWithUnmatchedSubjects2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedSubjects2.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithVarSubject.kt")
                public void testMergeWithVarSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithVarSubject.kt");
                    doTest(fileName);
                }

                @TestMetadata("mergeWithoutSubject.kt")
                public void testMergeWithoutSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/branched/when/merge/mergeWithoutSubject.kt");
                    doTest(fileName);
                }
            }
        }
    }

    @TestMetadata("idea/testData/intentions/changeVisibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeVisibility extends AbstractIntentionTest {
        public void testAllFilesPresentInChangeVisibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/changeVisibility/internal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Internal extends AbstractIntentionTest {
            public void testAllFilesPresentInInternal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility/internal"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/internal/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("valParameter.kt")
            public void testValParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/internal/valParameter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/changeVisibility/private")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Private extends AbstractIntentionTest {
            public void testAllFilesPresentInPrivate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility/private"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noModifierListClass.kt")
            public void testNoModifierListClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/noModifierListClass.kt");
                doTest(fileName);
            }

            @TestMetadata("noModifierListFun.kt")
            public void testNoModifierListFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/noModifierListFun.kt");
                doTest(fileName);
            }

            @TestMetadata("noModifierListInterface.kt")
            public void testNoModifierListInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/noModifierListInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("noModifierListObject.kt")
            public void testNoModifierListObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/noModifierListObject.kt");
                doTest(fileName);
            }

            @TestMetadata("noModifierListPrimaryConstructor.kt")
            public void testNoModifierListPrimaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/noModifierListPrimaryConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("noModifierListSecondaryConstructor.kt")
            public void testNoModifierListSecondaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/noModifierListSecondaryConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("noModifierListVal.kt")
            public void testNoModifierListVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/noModifierListVal.kt");
                doTest(fileName);
            }

            @TestMetadata("noModifierListValParam.kt")
            public void testNoModifierListValParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/noModifierListValParam.kt");
                doTest(fileName);
            }

            @TestMetadata("notForAbstract.kt")
            public void testNotForAbstract() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/notForAbstract.kt");
                doTest(fileName);
            }

            @TestMetadata("notForLocal.kt")
            public void testNotForLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/notForLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("notForParameter.kt")
            public void testNotForParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/notForParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("onAnnotation.kt")
            public void testOnAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/onAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("onAnnotationParameter.kt")
            public void testOnAnnotationParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/onAnnotationParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("withAnnotations.kt")
            public void testWithAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/private/withAnnotations.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/changeVisibility/protected")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Protected extends AbstractIntentionTest {
            public void testAllFilesPresentInProtected() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility/protected"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("caretAfter.kt")
            public void testCaretAfter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/protected/caretAfter.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorParameter.kt")
            public void testConstructorParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/protected/constructorParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("noModifier.kt")
            public void testNoModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/protected/noModifier.kt");
                doTest(fileName);
            }

            @TestMetadata("notForNonValParameter.kt")
            public void testNotForNonValParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/protected/notForNonValParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("notForObjectMember.kt")
            public void testNotForObjectMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/protected/notForObjectMember.kt");
                doTest(fileName);
            }

            @TestMetadata("notForOverride.kt")
            public void testNotForOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/protected/notForOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("notForTopLevel.kt")
            public void testNotForTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/protected/notForTopLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/protected/simple.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/changeVisibility/public")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Public extends AbstractIntentionTest {
            public void testAllFilesPresentInPublic() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility/public"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("alreadyPublic.kt")
            public void testAlreadyPublic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/public/alreadyPublic.kt");
                doTest(fileName);
            }

            @TestMetadata("destructuringPropertyException.kt")
            public void testDestructuringPropertyException() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/public/destructuringPropertyException.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/public/primaryConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("primaryConstructorPublicByDefault.kt")
            public void testPrimaryConstructorPublicByDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/public/primaryConstructorPublicByDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("publicByDefault.kt")
            public void testPublicByDefault() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/public/publicByDefault.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/changeVisibility/public/simple.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/conventionNameCalls")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConventionNameCalls extends AbstractIntentionTest {
        public void testAllFilesPresentInConventionNameCalls() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceCallWithBinaryOperator extends AbstractIntentionTest {
            public void testAllFilesPresentInReplaceCallWithBinaryOperator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("divSanityTest.kt")
            public void testDivSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/divSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("equals.kt")
            public void testEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/equals.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsCompareTo.kt")
            public void testEqualsCompareTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/equalsCompareTo.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsExtensionFunction.kt")
            public void testEqualsExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/equalsExtensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/extensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralArgument.kt")
            public void testFunctionLiteralArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/functionLiteralArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("greater.kt")
            public void testGreater() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/greater.kt");
                doTest(fileName);
            }

            @TestMetadata("lessEquals.kt")
            public void testLessEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/lessEquals.kt");
                doTest(fileName);
            }

            @TestMetadata("minusSanityTest.kt")
            public void testMinusSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/minusSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("missingDefaultArgument.kt")
            public void testMissingDefaultArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/missingDefaultArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("modSanityTest.kt")
            public void testModSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/modSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleArguments.kt")
            public void testMultipleArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/multipleArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("notEquals.kt")
            public void testNotEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/notEquals.kt");
                doTest(fileName);
            }

            @TestMetadata("notEqualsBrackets.kt")
            public void testNotEqualsBrackets() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/notEqualsBrackets.kt");
                doTest(fileName);
            }

            @TestMetadata("notEqualsBracketsComplex.kt")
            public void testNotEqualsBracketsComplex() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/notEqualsBracketsComplex.kt");
                doTest(fileName);
            }

            @TestMetadata("plusSanityTest.kt")
            public void testPlusSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/plusSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifier.kt")
            public void testQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/qualifier.kt");
                doTest(fileName);
            }

            @TestMetadata("rangeToSanityTest.kt")
            public void testRangeToSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/rangeToSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCompareTo.kt")
            public void testSafeCompareTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/safeCompareTo.kt");
                doTest(fileName);
            }

            @TestMetadata("super.kt")
            public void testSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/super.kt");
                doTest(fileName);
            }

            @TestMetadata("timesSanityTest.kt")
            public void testTimesSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/timesSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("typeArguments.kt")
            public void testTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/typeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableVararg1.kt")
            public void testUnacceptableVararg1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/unacceptableVararg1.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableVararg2.kt")
            public void testUnacceptableVararg2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/unacceptableVararg2.kt");
                doTest(fileName);
            }

            @TestMetadata("validNamedArgument.kt")
            public void testValidNamedArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithBinaryOperator/validNamedArgument.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceCallWithUnaryOperator extends AbstractIntentionTest {
            public void testAllFilesPresentInReplaceCallWithUnaryOperator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("complexPlus.kt")
            public void testComplexPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/complexPlus.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/extensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralArgument.kt")
            public void testFunctionLiteralArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/functionLiteralArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("minusSanityTest.kt")
            public void testMinusSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/minusSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("namedValueArgument.kt")
            public void testNamedValueArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/namedValueArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("notSanityTest.kt")
            public void testNotSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/notSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("plusPlus.kt")
            public void testPlusPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/plusPlus.kt");
                doTest(fileName);
            }

            @TestMetadata("plusSanityTest.kt")
            public void testPlusSanityTest() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/plusSanityTest.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifier.kt")
            public void testQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/qualifier.kt");
                doTest(fileName);
            }

            @TestMetadata("super.kt")
            public void testSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/super.kt");
                doTest(fileName);
            }

            @TestMetadata("typeArguments.kt")
            public void testTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/typeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableVararg.kt")
            public void testUnacceptableVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/unacceptableVararg.kt");
                doTest(fileName);
            }

            @TestMetadata("valueArgument.kt")
            public void testValueArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/valueArgument.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/conventionNameCalls/replaceContains")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceContains extends AbstractIntentionTest {
            public void testAllFilesPresentInReplaceContains() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls/replaceContains"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("containsFromJava.kt")
            public void testContainsFromJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/containsFromJava.kt");
                doTest(fileName);
            }

            @TestMetadata("containsInExpression.kt")
            public void testContainsInExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/containsInExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/extensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralArgument.kt")
            public void testFunctionLiteralArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/functionLiteralArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralArgumentAfterSemicolon.kt")
            public void testFunctionLiteralArgumentAfterSemicolon() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/functionLiteralArgumentAfterSemicolon.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralArgumentAtStartOfBlock.kt")
            public void testFunctionLiteralArgumentAtStartOfBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/functionLiteralArgumentAtStartOfBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralArgumentInExpression.kt")
            public void testFunctionLiteralArgumentInExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/functionLiteralArgumentInExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("invalidArgument.kt")
            public void testInvalidArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/invalidArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("missingArgument.kt")
            public void testMissingArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/missingArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("missingDefaultArgument.kt")
            public void testMissingDefaultArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/missingDefaultArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleArguments.kt")
            public void testMultipleArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/multipleArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("notContains.kt")
            public void testNotContains() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/notContains.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifier.kt")
            public void testQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/qualifier.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleArgument.kt")
            public void testSimpleArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/simpleArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleStringLiteral.kt")
            public void testSimpleStringLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/simpleStringLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("super.kt")
            public void testSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/super.kt");
                doTest(fileName);
            }

            @TestMetadata("twoArgsContainsFromJava.kt")
            public void testTwoArgsContainsFromJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/twoArgsContainsFromJava.kt");
                doTest(fileName);
            }

            @TestMetadata("typeArguments.kt")
            public void testTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/typeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableVararg1.kt")
            public void testUnacceptableVararg1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/unacceptableVararg1.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableVararg2.kt")
            public void testUnacceptableVararg2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/unacceptableVararg2.kt");
                doTest(fileName);
            }

            @TestMetadata("withoutOperatorModifier.kt")
            public void testWithoutOperatorModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceContains/withoutOperatorModifier.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceGetOrSet extends AbstractIntentionTest {
            @TestMetadata("acceptableVararg.kt")
            public void testAcceptableVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/acceptableVararg.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInReplaceGetOrSet() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls/replaceGetOrSet"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("argumentAndFunction.kt")
            public void testArgumentAndFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/argumentAndFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("duplicateArguments.kt")
            public void testDuplicateArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/duplicateArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/extensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("functionalArgument.kt")
            public void testFunctionalArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/functionalArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("invalidArgument.kt")
            public void testInvalidArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/invalidArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("missingDefaultArgument.kt")
            public void testMissingDefaultArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/missingDefaultArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("multiArgument.kt")
            public void testMultiArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/multiArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("noArgument.kt")
            public void testNoArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/noArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("notOperator.kt")
            public void testNotOperator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/notOperator.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifier.kt")
            public void testQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/qualifier.kt");
                doTest(fileName);
            }

            @TestMetadata("sanityCheck.kt")
            public void testSanityCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/sanityCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("set.kt")
            public void testSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/set.kt");
                doTest(fileName);
            }

            @TestMetadata("set2.kt")
            public void testSet2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/set2.kt");
                doTest(fileName);
            }

            @TestMetadata("setValueUsed.kt")
            public void testSetValueUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/setValueUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("setWithNoParameters.kt")
            public void testSetWithNoParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/setWithNoParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("setWithVararg.kt")
            public void testSetWithVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/setWithVararg.kt");
                doTest(fileName);
            }

            @TestMetadata("singleArgument.kt")
            public void testSingleArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/singleArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("staticMethod.kt")
            public void testStaticMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/staticMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("super.kt")
            public void testSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/super.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFun.kt")
            public void testTopLevelFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/topLevelFun.kt");
                doTest(fileName);
            }

            @TestMetadata("unacceptableVararg.kt")
            public void testUnacceptableVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/unacceptableVararg.kt");
                doTest(fileName);
            }

            @TestMetadata("unnamedAndNamed.kt")
            public void testUnnamedAndNamed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceGetOrSet/unnamedAndNamed.kt");
                doTest(fileName);
            }

        }

        @TestMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceInvoke extends AbstractIntentionTest {
            public void testAllFilesPresentInReplaceInvoke() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls/replaceInvoke"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("expressionReceiver.kt")
            public void testExpressionReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/expressionReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/extensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralInvoke.kt")
            public void testFunctionLiteralInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/functionLiteralInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeInExpression.kt")
            public void testInvokeInExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/invokeInExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("namedArgumentInvoke.kt")
            public void testNamedArgumentInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/namedArgumentInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("noArgumentInvoke.kt")
            public void testNoArgumentInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/noArgumentInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("typeAndValueArgument.kt")
            public void testTypeAndValueArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/typeAndValueArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("typeArgumentAndFunctionLiteral.kt")
            public void testTypeArgumentAndFunctionLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/typeArgumentAndFunctionLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("valueAndFunctionLiteralInvoke.kt")
            public void testValueAndFunctionLiteralInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/valueAndFunctionLiteralInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("valueArgumentInvoke.kt")
            public void testValueArgumentInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/valueArgumentInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("varargInvoke.kt")
            public void testVarargInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke/varargInvoke.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/convertAssertToIf")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertAssertToIf extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertAssertToIf() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertAssertToIf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assertErrorOverloaded.kt")
        public void testAssertErrorOverloaded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/assertErrorOverloaded.kt");
            doTest(fileName);
        }

        @TestMetadata("booleanCondition.kt")
        public void testBooleanCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/booleanCondition.kt");
            doTest(fileName);
        }

        @TestMetadata("booleanConditionSimplified.kt")
        public void testBooleanConditionSimplified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/booleanConditionSimplified.kt");
            doTest(fileName);
        }

        @TestMetadata("booleanConditionSimplified2.kt")
        public void testBooleanConditionSimplified2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/booleanConditionSimplified2.kt");
            doTest(fileName);
        }

        @TestMetadata("booleanConditionWithVariables.kt")
        public void testBooleanConditionWithVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/booleanConditionWithVariables.kt");
            doTest(fileName);
        }

        @TestMetadata("doNotShortenReferenceInsideMessage.kt")
        public void testDoNotShortenReferenceInsideMessage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/doNotShortenReferenceInsideMessage.kt");
            doTest(fileName);
        }

        @TestMetadata("dotQualifiedCall.kt")
        public void testDotQualifiedCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/dotQualifiedCall.kt");
            doTest(fileName);
        }

        @TestMetadata("functionCallCondition.kt")
        public void testFunctionCallCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/functionCallCondition.kt");
            doTest(fileName);
        }

        @TestMetadata("functionMessageInsideParentheses.kt")
        public void testFunctionMessageInsideParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/functionMessageInsideParentheses.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableAssertOverloaded.kt")
        public void testInapplicableAssertOverloaded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/inapplicableAssertOverloaded.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableAssertOverloadedWithPackage.kt")
        public void testInapplicableAssertOverloadedWithPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/inapplicableAssertOverloadedWithPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableNoCondition.kt")
        public void testInapplicableNoCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/inapplicableNoCondition.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaMessageInsideParentheses.kt")
        public void testLambdaMessageInsideParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/lambdaMessageInsideParentheses.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaMessageOutsideParentheses.kt")
        public void testLambdaMessageOutsideParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/lambdaMessageOutsideParentheses.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaMultiStatementMessageInsideParentheses.kt")
        public void testLambdaMultiStatementMessageInsideParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/lambdaMultiStatementMessageInsideParentheses.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaMultiStatementMessageOutsideParentheses.kt")
        public void testLambdaMultiStatementMessageOutsideParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/lambdaMultiStatementMessageOutsideParentheses.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaVariable.kt")
        public void testLambdaVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/lambdaVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("noMessage.kt")
        public void testNoMessage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/noMessage.kt");
            doTest(fileName);
        }

        @TestMetadata("parenthesizedCondition.kt")
        public void testParenthesizedCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/parenthesizedCondition.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleConvert.kt")
        public void testSimpleConvert() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/simpleConvert.kt");
            doTest(fileName);
        }

        @TestMetadata("stringVariable.kt")
        public void testStringVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertAssertToIf/stringVariable.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertCamelCaseTestFunctionToSpaced extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertCamelCaseTestFunctionToSpaced() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nonFunction.kt")
        public void testNonFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/nonFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("notAtIdentifier.kt")
        public void testNotAtIdentifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/notAtIdentifier.kt");
            doTest(fileName);
        }

        @TestMetadata("notTestFunction.kt")
        public void testNotTestFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/notTestFunction.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertEnumToSealedClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertEnumToSealedClass extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertEnumToSealedClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertEnumToSealedClass"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("entriesAndMembers.kt")
        public void testEntriesAndMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertEnumToSealedClass/entriesAndMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("entriesOnly.kt")
        public void testEntriesOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertEnumToSealedClass/entriesOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("membersOnly.kt")
        public void testMembersOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertEnumToSealedClass/membersOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("notEnum.kt")
        public void testNotEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertEnumToSealedClass/notEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("outOfRange.kt")
        public void testOutOfRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertEnumToSealedClass/outOfRange.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertForEachToForLoop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertForEachToForLoop extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertForEachToForLoop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertForEachToForLoop"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexReceiver.kt")
        public void testComplexReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/complexReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitFunctionLiteral.kt")
        public void testExplicitFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/explicitFunctionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("extraArguments.kt")
        public void testExtraArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/extraArguments.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitFunctionLiteralParameter.kt")
        public void testImplicitFunctionLiteralParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/implicitFunctionLiteralParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("infixCall.kt")
        public void testInfixCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/infixCall.kt");
            doTest(fileName);
        }

        @TestMetadata("infixCallNotAvailable.kt")
        public void testInfixCallNotAvailable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/infixCallNotAvailable.kt");
            doTest(fileName);
        }

        @TestMetadata("keepComments.kt")
        public void testKeepComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/keepComments.kt");
            doTest(fileName);
        }

        @TestMetadata("parenthesizedExpression.kt")
        public void testParenthesizedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/parenthesizedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleCharSequence.kt")
        public void testSimpleCharSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/simpleCharSequence.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleSequence.kt")
        public void testSimpleSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/simpleSequence.kt");
            doTest(fileName);
        }

        @TestMetadata("typeArgumentPresent.kt")
        public void testTypeArgumentPresent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/typeArgumentPresent.kt");
            doTest(fileName);
        }

        @TestMetadata("userDefined.kt")
        public void testUserDefined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/userDefined.kt");
            doTest(fileName);
        }

        @TestMetadata("zeroArguments.kt")
        public void testZeroArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertForEachToForLoop/zeroArguments.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertFunctionToProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertFunctionToProperty extends AbstractIntentionTest {
        @TestMetadata("addExplicitAnonymousType.kt")
        public void testAddExplicitAnonymousType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/addExplicitAnonymousType.kt");
            doTest(fileName);
        }

        @TestMetadata("addExplicitLocalType.kt")
        public void testAddExplicitLocalType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/addExplicitLocalType.kt");
            doTest(fileName);
        }

        @TestMetadata("addExplicitType.kt")
        public void testAddExplicitType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/addExplicitType.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInConvertFunctionToProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertFunctionToProperty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("blockBody.kt")
        public void testBlockBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/blockBody.kt");
            doTest(fileName);
        }

        @TestMetadata("existingPropertyConflict.kt")
        public void testExistingPropertyConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/existingPropertyConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("existingPropertyJavaConflict.kt")
        public void testExistingPropertyJavaConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/existingPropertyJavaConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionBody.kt")
        public void testExpressionBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/expressionBody.kt");
            doTest(fileName);
        }

        @TestMetadata("extraArgumentsConflict.kt")
        public void testExtraArgumentsConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/extraArgumentsConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithParameters.kt")
        public void testFunWithParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/funWithParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("invoke.kt")
        public void testInvoke() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/invoke.kt");
            doTest(fileName);
        }

        @TestMetadata("iterator.kt")
        public void testIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/iterator.kt");
            doTest(fileName);
        }

        @TestMetadata("javaUsages.kt")
        public void testJavaUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/javaUsages.kt");
            doTest(fileName);
        }

        @TestMetadata("javaUsagesGet.kt")
        public void testJavaUsagesGet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/javaUsagesGet.kt");
            doTest(fileName);
        }

        @TestMetadata("javaUsagesIs.kt")
        public void testJavaUsagesIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/javaUsagesIs.kt");
            doTest(fileName);
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/localFun.kt");
            doTest(fileName);
        }

        @TestMetadata("nothingFun.kt")
        public void testNothingFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/nothingFun.kt");
            doTest(fileName);
        }

        @TestMetadata("otherRefs.kt")
        public void testOtherRefs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/otherRefs.kt");
            doTest(fileName);
        }

        @TestMetadata("otherRefsGet.kt")
        public void testOtherRefsGet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/otherRefsGet.kt");
            doTest(fileName);
        }

        @TestMetadata("otherRefsIs.kt")
        public void testOtherRefsIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/otherRefsIs.kt");
            doTest(fileName);
        }

        @TestMetadata("overrides.kt")
        public void testOverrides() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/overrides.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveFunction.kt")
        public void testRecursiveFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/recursiveFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("typeArgumentsConflict.kt")
        public void testTypeArgumentsConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/typeArgumentsConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("unaryOp.kt")
        public void testUnaryOp() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/unaryOp.kt");
            doTest(fileName);
        }

        @TestMetadata("unchangedElements.kt")
        public void testUnchangedElements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/unchangedElements.kt");
            doTest(fileName);
        }

        @TestMetadata("unitFun.kt")
        public void testUnitFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertFunctionToProperty/unitFun.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertIfWithThrowToAssert")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertIfWithThrowToAssert extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertIfWithThrowToAssert() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertIfWithThrowToAssert"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assertOverloaded.kt")
        public void testAssertOverloaded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/assertOverloaded.kt");
            doTest(fileName);
        }

        @TestMetadata("assertOverloaded2.kt")
        public void testAssertOverloaded2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/assertOverloaded2.kt");
            doTest(fileName);
        }

        @TestMetadata("booleanCondition.kt")
        public void testBooleanCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/booleanCondition.kt");
            doTest(fileName);
        }

        @TestMetadata("dotQualifiedThrow.kt")
        public void testDotQualifiedThrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/dotQualifiedThrow.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableAssertionErrorOverloaded.kt")
        public void testInapplicableAssertionErrorOverloaded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableAssertionErrorOverloaded.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableCauseSent.kt")
        public void testInapplicableCauseSent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableCauseSent.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableHasElse.kt")
        public void testInapplicableHasElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableHasElse.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableMoreThanSingleExpression.kt")
        public void testInapplicableMoreThanSingleExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableMoreThanSingleExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableMoreThanSingleExpression2.kt")
        public void testInapplicableMoreThanSingleExpression2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableMoreThanSingleExpression2.kt");
            doTest(fileName);
        }

        @TestMetadata("noMessageSent.kt")
        public void testNoMessageSent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/noMessageSent.kt");
            doTest(fileName);
        }

        @TestMetadata("nullSent.kt")
        public void testNullSent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/nullSent.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleConvert.kt")
        public void testSimpleConvert() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/simpleConvert.kt");
            doTest(fileName);
        }

        @TestMetadata("simplifiedCondition.kt")
        public void testSimplifiedCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertIfWithThrowToAssert/simplifiedCondition.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertLambdaToReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertLambdaToReference extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertLambdaToReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertLambdaToReference"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentWithReceiver.kt")
        public void testArgumentWithReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/argumentWithReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("conversion.kt")
        public void testConversion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/conversion.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultArgument.kt")
        public void testDefaultArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/defaultArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultBeforeLambda.kt")
        public void testDefaultBeforeLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/defaultBeforeLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultNamed.kt")
        public void testDefaultNamed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/defaultNamed.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultOverridden.kt")
        public void testDefaultOverridden() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/defaultOverridden.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultUnnamed.kt")
        public void testDefaultUnnamed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/defaultUnnamed.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyBrackets.kt")
        public void testEmptyBrackets() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/emptyBrackets.kt");
            doTest(fileName);
        }

        @TestMetadata("erasedReceiver.kt")
        public void testErasedReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/erasedReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/extension.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionProperty.kt")
        public void testExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/extensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("fqNameForReceiver.kt")
        public void testFqNameForReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/fqNameForReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/generic.kt");
            doTest(fileName);
        }

        @TestMetadata("globalProperty.kt")
        public void testGlobalProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/globalProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("globalPropertyNoArgs.kt")
        public void testGlobalPropertyNoArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/globalPropertyNoArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("goodNamedOrder.kt")
        public void testGoodNamedOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/goodNamedOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/inner.kt");
            doTest(fileName);
        }

        @TestMetadata("mapTo.kt")
        public void testMapTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/mapTo.kt");
            doTest(fileName);
        }

        @TestMetadata("mapToFqName.kt")
        public void testMapToFqName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/mapToFqName.kt");
            doTest(fileName);
        }

        @TestMetadata("member.kt")
        public void testMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/member.kt");
            doTest(fileName);
        }

        @TestMetadata("memberExtension.kt")
        public void testMemberExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/memberExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("name.kt")
        public void testName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/name.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedLambda.kt")
        public void testNestedLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/nestedLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedLambdaWithReceiver.kt")
        public void testNestedLambdaWithReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/nestedLambdaWithReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/nullable.kt");
            doTest(fileName);
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/object.kt");
            doTest(fileName);
        }

        @TestMetadata("platformType.kt")
        public void testPlatformType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/platformType.kt");
            doTest(fileName);
        }

        @TestMetadata("receiverParameter.kt")
        public void testReceiverParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/receiverParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("receiverParameterReversed.kt")
        public void testReceiverParameterReversed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/receiverParameterReversed.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("syntheticProperty.kt")
        public void testSyntheticProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/syntheticProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("threeParameters.kt")
        public void testThreeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/threeParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/toString.kt");
            doTest(fileName);
        }

        @TestMetadata("typeFromJava.kt")
        public void testTypeFromJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/typeFromJava.kt");
            doTest(fileName);
        }

        @TestMetadata("typeFromJavaFlexibleRecursive.kt")
        public void testTypeFromJavaFlexibleRecursive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/typeFromJavaFlexibleRecursive.kt");
            doTest(fileName);
        }

        @TestMetadata("unit.kt")
        public void testUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/unit.kt");
            doTest(fileName);
        }

        @TestMetadata("unwrap.kt")
        public void testUnwrap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/unwrap.kt");
            doTest(fileName);
        }

        @TestMetadata("wrongNamedOrder.kt")
        public void testWrongNamedOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/wrongNamedOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("wrongParameterNumber.kt")
        public void testWrongParameterNumber() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/wrongParameterNumber.kt");
            doTest(fileName);
        }

        @TestMetadata("wrongParameterOrder.kt")
        public void testWrongParameterOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertLambdaToReference/wrongParameterOrder.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertNegatedBooleanSequence")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertNegatedBooleanSequence extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertNegatedBooleanSequence() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertNegatedBooleanSequence"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexNegatedSequence.kt")
        public void testComplexNegatedSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/complexNegatedSequence.kt");
            doTest(fileName);
        }

        @TestMetadata("conjunctionOfThreeNegations.kt")
        public void testConjunctionOfThreeNegations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/conjunctionOfThreeNegations.kt");
            doTest(fileName);
        }

        @TestMetadata("conjunctionOfTwoNegations.kt")
        public void testConjunctionOfTwoNegations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/conjunctionOfTwoNegations.kt");
            doTest(fileName);
        }

        @TestMetadata("disjunctionOfTwoNegations.kt")
        public void testDisjunctionOfTwoNegations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/disjunctionOfTwoNegations.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleParenthesizedExpression.kt")
        public void testDoubleParenthesizedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/doubleParenthesizedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableMixedOperators.kt")
        public void testInapplicableMixedOperators() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/inapplicableMixedOperators.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableMixedSequence.kt")
        public void testInapplicableMixedSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/inapplicableMixedSequence.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableSingleExpression.kt")
        public void testInapplicableSingleExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/inapplicableSingleExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("negatedFunction.kt")
        public void testNegatedFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/negatedFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("parenthesizedConjunctionOfTwoNegations.kt")
        public void testParenthesizedConjunctionOfTwoNegations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedBooleanSequence/parenthesizedConjunctionOfTwoNegations.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertNegatedExpressionWithDemorgansLaw extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertNegatedExpressionWithDemorgansLaw() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexNegation1.kt")
        public void testComplexNegation1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/complexNegation1.kt");
            doTest(fileName);
        }

        @TestMetadata("complexNegation2.kt")
        public void testComplexNegation2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/complexNegation2.kt");
            doTest(fileName);
        }

        @TestMetadata("conjunctionNegation1.kt")
        public void testConjunctionNegation1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/conjunctionNegation1.kt");
            doTest(fileName);
        }

        @TestMetadata("conjunctionNegation2.kt")
        public void testConjunctionNegation2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/conjunctionNegation2.kt");
            doTest(fileName);
        }

        @TestMetadata("disjunctionNegation1.kt")
        public void testDisjunctionNegation1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/disjunctionNegation1.kt");
            doTest(fileName);
        }

        @TestMetadata("disjunctionNegation2.kt")
        public void testDisjunctionNegation2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/disjunctionNegation2.kt");
            doTest(fileName);
        }

        @TestMetadata("dontAddRedundantParenthesis.kt")
        public void testDontAddRedundantParenthesis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/dontAddRedundantParenthesis.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleNegation.kt")
        public void testDoubleNegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/doubleNegation.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableNormalExpression.kt")
        public void testInapplicableNormalExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/inapplicableNormalExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableOperator.kt")
        public void testInapplicableOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/inapplicableOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableTriple.kt")
        public void testInapplicableTriple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/inapplicableTriple.kt");
            doTest(fileName);
        }

        @TestMetadata("longMixedExpression.kt")
        public void testLongMixedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/longMixedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("mixedExpression.kt")
        public void testMixedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/mixedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("nonstandardPrefixOperator.kt")
        public void testNonstandardPrefixOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/nonstandardPrefixOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("retainedParens.kt")
        public void testRetainedParens() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertNegatedExpressionWithDemorgansLaw/retainedParens.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertParameterToReceiver")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertParameterToReceiver extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertParameterToReceiver() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertParameterToReceiver"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classParameter.kt")
        public void testClassParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/classParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("companionAsReceiver.kt")
        public void testCompanionAsReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/companionAsReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/functionExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("functionExpressionWithThisConflict.kt")
        public void testFunctionExpressionWithThisConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/functionExpressionWithThisConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaParameter.kt")
        public void testLambdaParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/lambdaParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/localFun.kt");
            doTest(fileName);
        }

        @TestMetadata("localObject.kt")
        public void testLocalObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/localObject.kt");
            doTest(fileName);
        }

        @TestMetadata("localObjectWithFunctionNameConflict.kt")
        public void testLocalObjectWithFunctionNameConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/localObjectWithFunctionNameConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("memberFun.kt")
        public void testMemberFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/memberFun.kt");
            doTest(fileName);
        }

        @TestMetadata("noParameterUnderCaret.kt")
        public void testNoParameterUnderCaret() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/noParameterUnderCaret.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelFun.kt")
        public void testTopLevelFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/topLevelFun.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/vararg.kt");
            doTest(fileName);
        }

        @TestMetadata("withExtensionReceiver.kt")
        public void testWithExtensionReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertParameterToReceiver/withExtensionReceiver.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertPrimaryConstructorToSecondary extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertPrimaryConstructorToSecondary() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertPrimaryConstructorToSecondary"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotatedConstructor.kt")
        public void testAnnotatedConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/annotatedConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("annotatedParam.kt")
        public void testAnnotatedParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/annotatedParam.kt");
            doTest(fileName);
        }

        @TestMetadata("annotatedProperty.kt")
        public void testAnnotatedProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/annotatedProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultValueChain.kt")
        public void testDefaultValueChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/defaultValueChain.kt");
            doTest(fileName);
        }

        @TestMetadata("independentProperty.kt")
        public void testIndependentProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/independentProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("independentProperty2.kt")
        public void testIndependentProperty2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/independentProperty2.kt");
            doTest(fileName);
        }

        @TestMetadata("independentProperty3.kt")
        public void testIndependentProperty3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/independentProperty3.kt");
            doTest(fileName);
        }

        @TestMetadata("initAndParams.kt")
        public void testInitAndParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/initAndParams.kt");
            doTest(fileName);
        }

        @TestMetadata("initWithoutAssignments.kt")
        public void testInitWithoutAssignments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/initWithoutAssignments.kt");
            doTest(fileName);
        }

        @TestMetadata("noArgName.kt")
        public void testNoArgName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/noArgName.kt");
            doTest(fileName);
        }

        @TestMetadata("paramsAndProperties.kt")
        public void testParamsAndProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/paramsAndProperties.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedConstructor.kt")
        public void testProtectedConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/protectedConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("useParam.kt")
        public void testUseParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/useParam.kt");
            doTest(fileName);
        }

        @TestMetadata("useParamChain.kt")
        public void testUseParamChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/useParamChain.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/vararg.kt");
            doTest(fileName);
        }

        @TestMetadata("varargVal.kt")
        public void testVarargVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/varargVal.kt");
            doTest(fileName);
        }

        @TestMetadata("withBaseClass.kt")
        public void testWithBaseClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/withBaseClass.kt");
            doTest(fileName);
        }

        @TestMetadata("withComments.kt")
        public void testWithComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/withComments.kt");
            doTest(fileName);
        }

        @TestMetadata("withMultipleInheritance.kt")
        public void testWithMultipleInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/withMultipleInheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("withProperties.kt")
        public void testWithProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary/withProperties.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertPropertyInitializerToGetter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertPropertyInitializerToGetter extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertPropertyInitializerToGetter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertPropertyInitializerToGetter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicableIfExtensionProperty.kt")
        public void testInapplicableIfExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/inapplicableIfExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableIfLocalVariableInFun.kt")
        public void testInapplicableIfLocalVariableInFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/inapplicableIfLocalVariableInFun.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableIfLocalVariableInInitBlock.kt")
        public void testInapplicableIfLocalVariableInInitBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/inapplicableIfLocalVariableInInitBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableIfNoInitializer.kt")
        public void testInapplicableIfNoInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/inapplicableIfNoInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("notInLambda.kt")
        public void testNotInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/notInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithInitializerWithSetter.kt")
        public void testPropertyWithInitializerWithSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/propertyWithInitializerWithSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithInitializerWithoutAccessors.kt")
        public void testPropertyWithInitializerWithoutAccessors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/propertyWithInitializerWithoutAccessors.kt");
            doTest(fileName);
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/semicolon.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelDeclaration.kt")
        public void testTopLevelDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyInitializerToGetter/topLevelDeclaration.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertPropertyToFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertPropertyToFunction extends AbstractIntentionTest {
        @TestMetadata("accessorCallGroovy.kt")
        public void testAccessorCallGroovy() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/accessorCallGroovy.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInConvertPropertyToFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertPropertyToFunction"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("blockBody.kt")
        public void testBlockBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/blockBody.kt");
            doTest(fileName);
        }

        @TestMetadata("delegatingProperty.kt")
        public void testDelegatingProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/delegatingProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("existingFunConflict.kt")
        public void testExistingFunConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/existingFunConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("existingFunJavaConflict.kt")
        public void testExistingFunJavaConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/existingFunJavaConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionBody.kt")
        public void testExpressionBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/expressionBody.kt");
            doTest(fileName);
        }

        @TestMetadata("initializer.kt")
        public void testInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/initializer.kt");
            doTest(fileName);
        }

        @TestMetadata("javaUsageAsField.kt")
        public void testJavaUsageAsField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/javaUsageAsField.kt");
            doTest(fileName);
        }

        @TestMetadata("javaUsages.kt")
        public void testJavaUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/javaUsages.kt");
            doTest(fileName);
        }

        @TestMetadata("otherRefs.kt")
        public void testOtherRefs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/otherRefs.kt");
            doTest(fileName);
        }

        @TestMetadata("overrides.kt")
        public void testOverrides() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/overrides.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyCallGroovy.kt")
        public void testPropertyCallGroovy() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/propertyCallGroovy.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveAccessor.kt")
        public void testRecursiveAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/recursiveAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("unchangedElements.kt")
        public void testUnchangedElements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/unchangedElements.kt");
            doTest(fileName);
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertPropertyToFunction/var.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertReceiverToParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertReceiverToParameter extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertReceiverToParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertReceiverToParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/functionExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("genericReceiver.kt")
        public void testGenericReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/genericReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/localFun.kt");
            doTest(fileName);
        }

        @TestMetadata("memberFun.kt")
        public void testMemberFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/memberFun.kt");
            doTest(fileName);
        }

        @TestMetadata("noReceiverUnderCaret.kt")
        public void testNoReceiverUnderCaret() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/noReceiverUnderCaret.kt");
            doTest(fileName);
        }

        @TestMetadata("notExtension.kt")
        public void testNotExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/notExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceThis.kt")
        public void testReplaceThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/replaceThis.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelFun.kt")
        public void testTopLevelFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/topLevelFun.kt");
            doTest(fileName);
        }

        @TestMetadata("validOverload.kt")
        public void testValidOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReceiverToParameter/validOverload.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertReferenceToLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertReferenceToLambda extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertReferenceToLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertReferenceToLambda"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("boundReference.kt")
        public void testBoundReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/boundReference.kt");
            doTest(fileName);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("conversion.kt")
        public void testConversion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/conversion.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionProperty.kt")
        public void testExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/extensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("fqNameForReceiver.kt")
        public void testFqNameForReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/fqNameForReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/inner.kt");
            doTest(fileName);
        }

        @TestMetadata("length.kt")
        public void testLength() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/length.kt");
            doTest(fileName);
        }

        @TestMetadata("name.kt")
        public void testName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/name.kt");
            doTest(fileName);
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/nullable.kt");
            doTest(fileName);
        }

        @TestMetadata("receiverParameter.kt")
        public void testReceiverParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/receiverParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("threeParameters.kt")
        public void testThreeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/threeParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/toString.kt");
            doTest(fileName);
        }

        @TestMetadata("unwrap.kt")
        public void testUnwrap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertReferenceToLambda/unwrap.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertSealedClassToEnum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertSealedClassToEnum extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertSealedClassToEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertSealedClassToEnum"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dropDefaultConstructorCall.kt")
        public void testDropDefaultConstructorCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/dropDefaultConstructorCall.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritorsWithMultipleSupertypes.kt")
        public void testInheritorsWithMultipleSupertypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/inheritorsWithMultipleSupertypes.kt");
            doTest(fileName);
        }

        @TestMetadata("instancesAndMembers.kt")
        public void testInstancesAndMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/instancesAndMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("instancesOnly.kt")
        public void testInstancesOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/instancesOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("membersOnly.kt")
        public void testMembersOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/membersOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("nonNestedInheritors.kt")
        public void testNonNestedInheritors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/nonNestedInheritors.kt");
            doTest(fileName);
        }

        @TestMetadata("notSealedClass.kt")
        public void testNotSealedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/notSealedClass.kt");
            doTest(fileName);
        }

        @TestMetadata("outOfRange.kt")
        public void testOutOfRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/outOfRange.kt");
            doTest(fileName);
        }

        @TestMetadata("withNonObjectInheritors.kt")
        public void testWithNonObjectInheritors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/withNonObjectInheritors.kt");
            doTest(fileName);
        }

        @TestMetadata("withSuperclass.kt")
        public void testWithSuperclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSealedClassToEnum/withSuperclass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertSecondaryConstructorToPrimary extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertSecondaryConstructorToPrimary() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertSecondaryConstructorToPrimary"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("defaultValueChain.kt")
        public void testDefaultValueChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/defaultValueChain.kt");
            doTest(fileName);
        }

        @TestMetadata("init.kt")
        public void testInit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/init.kt");
            doTest(fileName);
        }

        @TestMetadata("initAndParams.kt")
        public void testInitAndParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/initAndParams.kt");
            doTest(fileName);
        }

        @TestMetadata("nonReachable.kt")
        public void testNonReachable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/nonReachable.kt");
            doTest(fileName);
        }

        @TestMetadata("nonReachableLoop.kt")
        public void testNonReachableLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/nonReachableLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedConstructor.kt")
        public void testProtectedConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/protectedConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("useParam.kt")
        public void testUseParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/useParam.kt");
            doTest(fileName);
        }

        @TestMetadata("varArg.kt")
        public void testVarArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/varArg.kt");
            doTest(fileName);
        }

        @TestMetadata("varargVal.kt")
        public void testVarargVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/varargVal.kt");
            doTest(fileName);
        }

        @TestMetadata("withBaseClass.kt")
        public void testWithBaseClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withBaseClass.kt");
            doTest(fileName);
        }

        @TestMetadata("withBaseClassNoArgs.kt")
        public void testWithBaseClassNoArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withBaseClassNoArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("withComments.kt")
        public void testWithComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withComments.kt");
            doTest(fileName);
        }

        @TestMetadata("withComposedModifiers.kt")
        public void testWithComposedModifiers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withComposedModifiers.kt");
            doTest(fileName);
        }

        @TestMetadata("withDelegation.kt")
        public void testWithDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("withDifferentTypeProperty.kt")
        public void testWithDifferentTypeProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withDifferentTypeProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("withModifiers.kt")
        public void testWithModifiers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withModifiers.kt");
            doTest(fileName);
        }

        @TestMetadata("withParameters.kt")
        public void testWithParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("withPrimary.kt")
        public void testWithPrimary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withPrimary.kt");
            doTest(fileName);
        }

        @TestMetadata("withProperties.kt")
        public void testWithProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary/withProperties.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertToBlockBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToBlockBody extends AbstractIntentionTest {
        @TestMetadata("addSpace.kt")
        public void testAddSpace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/addSpace.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInConvertToBlockBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToBlockBody"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotatedExpr.kt")
        public void testAnnotatedExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/annotatedExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitlyNonUnitFun.kt")
        public void testExplicitlyNonUnitFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/explicitlyNonUnitFun.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitlyTypedFunWithUnresolvedExpression.kt")
        public void testExplicitlyTypedFunWithUnresolvedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/explicitlyTypedFunWithUnresolvedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitlyTypedFunWithUnresolvedType.kt")
        public void testExplicitlyTypedFunWithUnresolvedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/explicitlyTypedFunWithUnresolvedType.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitlyUnitFun.kt")
        public void testExplicitlyUnitFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/explicitlyUnitFun.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitlyUnitFunWithUnresolvedExpression.kt")
        public void testExplicitlyUnitFunWithUnresolvedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/explicitlyUnitFunWithUnresolvedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithCustomUnitClass.kt")
        public void testFunWithCustomUnitClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/funWithCustomUnitClass.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithThrow.kt")
        public void testFunWithThrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/funWithThrow.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithUnit.kt")
        public void testFunWithUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/funWithUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("getter.kt")
        public void testGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/getter.kt");
            doTest(fileName);
        }

        @TestMetadata("getterWithThrow.kt")
        public void testGetterWithThrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/getterWithThrow.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWhenUnit.kt")
        public void testIfWhenUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/ifWhenUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitlyNonUnitFun.kt")
        public void testImplicitlyNonUnitFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/implicitlyNonUnitFun.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitlyTypedFunWithUnresolvedType.kt")
        public void testImplicitlyTypedFunWithUnresolvedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/implicitlyTypedFunWithUnresolvedType.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitlyUnitFun.kt")
        public void testImplicitlyUnitFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/implicitlyUnitFun.kt");
            doTest(fileName);
        }

        @TestMetadata("labeledExpr.kt")
        public void testLabeledExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/labeledExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("nothingFun.kt")
        public void testNothingFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/nothingFun.kt");
            doTest(fileName);
        }

        @TestMetadata("setter.kt")
        public void testSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/setter.kt");
            doTest(fileName);
        }

        @TestMetadata("valueIsAnonymousObject.kt")
        public void testValueIsAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/valueIsAnonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("valueIsAnonymousObject2.kt")
        public void testValueIsAnonymousObject2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/valueIsAnonymousObject2.kt");
            doTest(fileName);
        }

        @TestMetadata("valueIsAnonymousObject3.kt")
        public void testValueIsAnonymousObject3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/valueIsAnonymousObject3.kt");
            doTest(fileName);
        }

        @TestMetadata("valueIsAnonymousObject4.kt")
        public void testValueIsAnonymousObject4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/valueIsAnonymousObject4.kt");
            doTest(fileName);
        }

        @TestMetadata("whenUnit.kt")
        public void testWhenUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToBlockBody/whenUnit.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertToConcatenatedString")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToConcatenatedString extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertToConcatenatedString() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToConcatenatedString"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("embeddedIf.kt")
        public void testEmbeddedIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/embeddedIf.kt");
            doTest(fileName);
        }

        @TestMetadata("embeddedIfBraces.kt")
        public void testEmbeddedIfBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/embeddedIfBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyBraces.kt")
        public void testEmptyBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/emptyBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("handlesEscapeString.kt")
        public void testHandlesEscapeString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/handlesEscapeString.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolate2StringConstants.kt")
        public void testInterpolate2StringConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolate2StringConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolate3.kt")
        public void testInterpolate3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolate3.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateChar.kt")
        public void testInterpolateChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolateChar.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateConstants.kt")
        public void testInterpolateConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolateConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateMapAccess.kt")
        public void testInterpolateMapAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolateMapAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateMethodInvoke.kt")
        public void testInterpolateMethodInvoke() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolateMethodInvoke.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateSimpleWithBraces.kt")
        public void testInterpolateSimpleWithBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolateSimpleWithBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateStringWithFloat.kt")
        public void testInterpolateStringWithFloat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolateStringWithFloat.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateStringWithInt.kt")
        public void testInterpolateStringWithInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/interpolateStringWithInt.kt");
            doTest(fileName);
        }

        @TestMetadata("lastExprIsNamedExpression.kt")
        public void testLastExprIsNamedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/lastExprIsNamedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("multilineString.kt")
        public void testMultilineString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/multilineString.kt");
            doTest(fileName);
        }

        @TestMetadata("multilineWhenExpr.kt")
        public void testMultilineWhenExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/multilineWhenExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("namedExprBetweenConstants.kt")
        public void testNamedExprBetweenConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/namedExprBetweenConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableForErrorElement.kt")
        public void testNotApplicableForErrorElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/notApplicableForErrorElement.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableForSimple.kt")
        public void testNotApplicableForSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/notApplicableForSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("notAvailableForDollarSignLiteral.kt")
        public void testNotAvailableForDollarSignLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/notAvailableForDollarSignLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("singleVar.kt")
        public void testSingleVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/singleVar.kt");
            doTest(fileName);
        }

        @TestMetadata("startsWithInt.kt")
        public void testStartsWithInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/startsWithInt.kt");
            doTest(fileName);
        }

        @TestMetadata("startsWithStringExpression.kt")
        public void testStartsWithStringExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/startsWithStringExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("tricky.kt")
        public void testTricky() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/tricky.kt");
            doTest(fileName);
        }

        @TestMetadata("withAndWithoutBraces.kt")
        public void testWithAndWithoutBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToConcatenatedString/withAndWithoutBraces.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertToExpressionBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToExpressionBody extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertToExpressionBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToExpressionBody"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObjectExpression.kt")
        public void testAnonymousObjectExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/anonymousObjectExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("assignPlus.kt")
        public void testAssignPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/assignPlus.kt");
            doTest(fileName);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/assignment.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorWithEmptyBody.kt")
        public void testConstructorWithEmptyBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/constructorWithEmptyBody.kt");
            doTest(fileName);
        }

        @TestMetadata("declaration.kt")
        public void testDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/declaration.kt");
            doTest(fileName);
        }

        @TestMetadata("elvisIfElseUnit.kt")
        public void testElvisIfElseUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/elvisIfElseUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("elvisIfUnit.kt")
        public void testElvisIfUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/elvisIfUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("elvisWhenUnitNonExhaustive.kt")
        public void testElvisWhenUnitNonExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/elvisWhenUnitNonExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyList.kt")
        public void testEmptyList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/emptyList.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionWithReturns1.kt")
        public void testExpressionWithReturns1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/expressionWithReturns1.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionWithReturns2.kt")
        public void testExpressionWithReturns2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/expressionWithReturns2.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithEmptyBody.kt")
        public void testFunWithEmptyBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithEmptyBody.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithEmptyBody2.kt")
        public void testFunWithEmptyBody2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithEmptyBody2.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithImplicitUnitTypeWithThrow.kt")
        public void testFunWithImplicitUnitTypeWithThrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithImplicitUnitTypeWithThrow.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithNoBlock.kt")
        public void testFunWithNoBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithNoBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithNothingType.kt")
        public void testFunWithNothingType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithNothingType.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithReturn.kt")
        public void testFunWithReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithUnitType.kt")
        public void testFunWithUnitType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithUnitType.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithUnitType2.kt")
        public void testFunWithUnitType2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithUnitType2.kt");
            doTest(fileName);
        }

        @TestMetadata("funWithUnitTypeWithThrow.kt")
        public void testFunWithUnitTypeWithThrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/funWithUnitTypeWithThrow.kt");
            doTest(fileName);
        }

        @TestMetadata("functionLiteral.kt")
        public void testFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/functionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("getWithReturn.kt")
        public void testGetWithReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/getWithReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("ifElseUnit.kt")
        public void testIfElseUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/ifElseUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("ifUnit.kt")
        public void testIfUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/ifUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWhenUnitExhaustive.kt")
        public void testIfWhenUnitExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/ifWhenUnitExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWhenUnitNonExhaustive.kt")
        public void testIfWhenUnitNonExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/ifWhenUnitNonExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaIfUnit.kt")
        public void testLambdaIfUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/lambdaIfUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWhenUnitNonExhaustive.kt")
        public void testLambdaWhenUnitNonExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/lambdaWhenUnitNonExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleStatements.kt")
        public void testMultipleStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/multipleStatements.kt");
            doTest(fileName);
        }

        @TestMetadata("overridePublicFun.kt")
        public void testOverridePublicFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/overridePublicFun.kt");
            doTest(fileName);
        }

        @TestMetadata("returnFromLambda.kt")
        public void testReturnFromLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/returnFromLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("returnFromLambda2.kt")
        public void testReturnFromLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/returnFromLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("returnWithNoValue.kt")
        public void testReturnWithNoValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/returnWithNoValue.kt");
            doTest(fileName);
        }

        @TestMetadata("whenIfUnitExhaustive.kt")
        public void testWhenIfUnitExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/whenIfUnitExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("whenIfUnitNonExhaustive.kt")
        public void testWhenIfUnitNonExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/whenIfUnitNonExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("whenUnitExhaustive.kt")
        public void testWhenUnitExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/whenUnitExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("whenUnitNonExhaustive.kt")
        public void testWhenUnitNonExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/whenUnitNonExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("whenUnitWithElse.kt")
        public void testWhenUnitWithElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/whenUnitWithElse.kt");
            doTest(fileName);
        }

        @TestMetadata("whenWhenNonExhaustive.kt")
        public void testWhenWhenNonExhaustive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/whenWhenNonExhaustive.kt");
            doTest(fileName);
        }

        @TestMetadata("while.kt")
        public void testWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/while.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/intentions/convertToExpressionBody/keepComments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KeepComments extends AbstractIntentionTest {
            @TestMetadata("1.kt")
            public void test1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/keepComments/1.kt");
                doTest(fileName);
            }

            @TestMetadata("2.kt")
            public void test2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/keepComments/2.kt");
                doTest(fileName);
            }

            @TestMetadata("3.kt")
            public void test3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/keepComments/3.kt");
                doTest(fileName);
            }

            @TestMetadata("4.kt")
            public void test4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToExpressionBody/keepComments/4.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInKeepComments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToExpressionBody/keepComments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/convertToForEachFunctionCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToForEachFunctionCall extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertToForEachFunctionCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToForEachFunctionCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("binaryExpressionLoopRange.kt")
        public void testBinaryExpressionLoopRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/binaryExpressionLoopRange.kt");
            doTest(fileName);
        }

        @TestMetadata("blockBodyExpression.kt")
        public void testBlockBodyExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/blockBodyExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("commentsInBody.kt")
        public void testCommentsInBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/commentsInBody.kt");
            doTest(fileName);
        }

        @TestMetadata("commentsInBody2.kt")
        public void testCommentsInBody2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/commentsInBody2.kt");
            doTest(fileName);
        }

        @TestMetadata("commentsOutsideBody.kt")
        public void testCommentsOutsideBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/commentsOutsideBody.kt");
            doTest(fileName);
        }

        @TestMetadata("continueToReturnWithLabel.kt")
        public void testContinueToReturnWithLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/continueToReturnWithLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("continueToReturnWithoutLabel.kt")
        public void testContinueToReturnWithoutLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/continueToReturnWithoutLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyBody.kt")
        public void testEmptyBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/emptyBody.kt");
            doTest(fileName);
        }

        @TestMetadata("iterativeElementTypeSpecified.kt")
        public void testIterativeElementTypeSpecified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/iterativeElementTypeSpecified.kt");
            doTest(fileName);
        }

        @TestMetadata("noCurlyBraces.kt")
        public void testNoCurlyBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/noCurlyBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("noStatements.kt")
        public void testNoStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/noStatements.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAnnotatedWithNonBlockBody.kt")
        public void testTypeAnnotatedWithNonBlockBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToForEachFunctionCall/typeAnnotatedWithNonBlockBody.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/convertToStringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToStringTemplate extends AbstractIntentionTest {
        public void testAllFilesPresentInConvertToStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToStringTemplate"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("backslashNMultilineString.kt")
        public void testBackslashNMultilineString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/backslashNMultilineString.kt");
            doTest(fileName);
        }

        @TestMetadata("combineEmptyStrings.kt")
        public void testCombineEmptyStrings() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/combineEmptyStrings.kt");
            doTest(fileName);
        }

        @TestMetadata("combinesNonStringsAsStrings.kt")
        public void testCombinesNonStringsAsStrings() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/combinesNonStringsAsStrings.kt");
            doTest(fileName);
        }

        @TestMetadata("combinesNonStringsAsStrings2.kt")
        public void testCombinesNonStringsAsStrings2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/combinesNonStringsAsStrings2.kt");
            doTest(fileName);
        }

        @TestMetadata("comment.kt")
        public void testComment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/comment.kt");
            doTest(fileName);
        }

        @TestMetadata("consecutiveNewlines.kt")
        public void testConsecutiveNewlines() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/consecutiveNewlines.kt");
            doTest(fileName);
        }

        @TestMetadata("doesNotCorruptExistingTemplate.kt")
        public void testDoesNotCorruptExistingTemplate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/doesNotCorruptExistingTemplate.kt");
            doTest(fileName);
        }

        @TestMetadata("doesNotCorruptExistingTemplateWithBraces.kt")
        public void testDoesNotCorruptExistingTemplateWithBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/doesNotCorruptExistingTemplateWithBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("endOfLineComment.kt")
        public void testEndOfLineComment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/endOfLineComment.kt");
            doTest(fileName);
        }

        @TestMetadata("insertBracesForSimpleNamedExpression.kt")
        public void testInsertBracesForSimpleNamedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/insertBracesForSimpleNamedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolate2StringConstants.kt")
        public void testInterpolate2StringConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolate2StringConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolate2Vals.kt")
        public void testInterpolate2Vals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolate2Vals.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolate3Left.kt")
        public void testInterpolate3Left() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolate3Left.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolate3Right.kt")
        public void testInterpolate3Right() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolate3Right.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateChar.kt")
        public void testInterpolateChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolateChar.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateDollarSign.kt")
        public void testInterpolateDollarSign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolateDollarSign.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateMapAccess.kt")
        public void testInterpolateMapAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolateMapAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateMethodInvoke.kt")
        public void testInterpolateMethodInvoke() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolateMethodInvoke.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateMultiline.kt")
        public void testInterpolateMultiline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolateMultiline.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateStringWithFloat.kt")
        public void testInterpolateStringWithFloat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolateStringWithFloat.kt");
            doTest(fileName);
        }

        @TestMetadata("interpolateStringWithInt.kt")
        public void testInterpolateStringWithInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/interpolateStringWithInt.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11295.kt")
        public void testKt11295() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/kt11295.kt");
            doTest(fileName);
        }

        @TestMetadata("longTemplatePlusStringLiteral.kt")
        public void testLongTemplatePlusStringLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/longTemplatePlusStringLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("multilineString.kt")
        public void testMultilineString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/multilineString.kt");
            doTest(fileName);
        }

        @TestMetadata("noBracesForLastSimpleExpression.kt")
        public void testNoBracesForLastSimpleExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/noBracesForLastSimpleExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("noBracesSimpleFollowedByDot.kt")
        public void testNoBracesSimpleFollowedByDot() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/noBracesSimpleFollowedByDot.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableForErrorElement.kt")
        public void testNotApplicableForErrorElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/notApplicableForErrorElement.kt");
            doTest(fileName);
        }

        @TestMetadata("numberLiterals.kt")
        public void testNumberLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/numberLiterals.kt");
            doTest(fileName);
        }

        @TestMetadata("onMultipleLines.kt")
        public void testOnMultipleLines() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/onMultipleLines.kt");
            doTest(fileName);
        }

        @TestMetadata("onlyForConcat.kt")
        public void testOnlyForConcat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/onlyForConcat.kt");
            doTest(fileName);
        }

        @TestMetadata("onlyForStrings.kt")
        public void testOnlyForStrings() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/onlyForStrings.kt");
            doTest(fileName);
        }

        @TestMetadata("requiresPlusOperator.kt")
        public void testRequiresPlusOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/requiresPlusOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("specialCharsInCharLiteral.kt")
        public void testSpecialCharsInCharLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/specialCharsInCharLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("stringPlusStringLiteral.kt")
        public void testStringPlusStringLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/stringPlusStringLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("templatePlusStringLiteral.kt")
        public void testTemplatePlusStringLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/templatePlusStringLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("tricky.kt")
        public void testTricky() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/tricky.kt");
            doTest(fileName);
        }

        @TestMetadata("unescapeSingleQuote.kt")
        public void testUnescapeSingleQuote() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/convertToStringTemplate/unescapeSingleQuote.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/intentions/copyConcatenatedStringToClipboard")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CopyConcatenatedStringToClipboard extends AbstractIntentionTest {
        public void testAllFilesPresentInCopyConcatenatedStringToClipboard() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/copyConcatenatedStringToClipboard"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constants.kt")
        public void testConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/copyConcatenatedStringToClipboard/constants.kt");
            doTest(fileName);
        }

        @TestMetadata("numbers.kt")
        public void testNumbers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/copyConcatenatedStringToClipboard/numbers.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/copyConcatenatedStringToClipboard/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleString.kt")
        public void testSimpleString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/copyConcatenatedStringToClipboard/simpleString.kt");
            doTest(fileName);
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/copyConcatenatedStringToClipboard/variables.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/declarations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Declarations extends AbstractIntentionTest {
        public void testAllFilesPresentInDeclarations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/declarations"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/declarations/convertMemberToExtension")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertMemberToExtension extends AbstractIntentionTest {
            @TestMetadata("abstract.kt")
            public void testAbstract() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/abstract.kt");
                doTest(fileName);
            }

            @TestMetadata("abstractProperty.kt")
            public void testAbstractProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/abstractProperty.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInConvertMemberToExtension() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/declarations/convertMemberToExtension"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("explicitUnit.kt")
            public void testExplicitUnit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/explicitUnit.kt");
                doTest(fileName);
            }

            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/extension.kt");
                doTest(fileName);
            }

            @TestMetadata("final.kt")
            public void testFinal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/final.kt");
                doTest(fileName);
            }

            @TestMetadata("funcitonNoName.kt")
            public void testFuncitonNoName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/funcitonNoName.kt");
                doTest(fileName);
            }

            @TestMetadata("functionType.kt")
            public void testFunctionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/functionType.kt");
                doTest(fileName);
            }

            @TestMetadata("genericClass.kt")
            public void testGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/genericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("genericFun.kt")
            public void testGenericFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/genericFun.kt");
                doTest(fileName);
            }

            @TestMetadata("genericFunInGenericClass.kt")
            public void testGenericFunInGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/genericFunInGenericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("genericFunInGenericClassWithUpperBounds.kt")
            public void testGenericFunInGenericClassWithUpperBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/genericFunInGenericClassWithUpperBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("genericFunParamAfterName.kt")
            public void testGenericFunParamAfterName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/genericFunParamAfterName.kt");
                doTest(fileName);
            }

            @TestMetadata("inFunctionBody.kt")
            public void testInFunctionBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/inFunctionBody.kt");
                doTest(fileName);
            }

            @TestMetadata("inObject.kt")
            public void testInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/inObject.kt");
                doTest(fileName);
            }

            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/internal.kt");
                doTest(fileName);
            }

            @TestMetadata("KDoc.kt")
            public void testKDoc() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/KDoc.kt");
                doTest(fileName);
            }

            @TestMetadata("localFunction.kt")
            public void testLocalFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/localFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("nonBlockBodyNoType.kt")
            public void testNonBlockBodyNoType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/nonBlockBodyNoType.kt");
                doTest(fileName);
            }

            @TestMetadata("nonBlockBodyWithType.kt")
            public void testNonBlockBodyWithType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/nonBlockBodyWithType.kt");
                doTest(fileName);
            }

            @TestMetadata("open.kt")
            public void testOpen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/open.kt");
                doTest(fileName);
            }

            @TestMetadata("outsideFunction.kt")
            public void testOutsideFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/outsideFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("override.kt")
            public void testOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/override.kt");
                doTest(fileName);
            }

            @TestMetadata("private.kt")
            public void testPrivate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/private.kt");
                doTest(fileName);
            }

            @TestMetadata("protected.kt")
            public void testProtected() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/protected.kt");
                doTest(fileName);
            }

            @TestMetadata("public.kt")
            public void testPublic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/public.kt");
                doTest(fileName);
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/secondaryConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunction.kt")
            public void testTopLevelFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/topLevelFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("typeFqName.kt")
            public void testTypeFqName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/typeFqName.kt");
                doTest(fileName);
            }

            @TestMetadata("unknownType.kt")
            public void testUnknownType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/unknownType.kt");
                doTest(fileName);
            }

            @TestMetadata("valWithDefaultGetter.kt")
            public void testValWithDefaultGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/valWithDefaultGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("valWithGetter.kt")
            public void testValWithGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/valWithGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("valWithGetterBlockBody.kt")
            public void testValWithGetterBlockBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/valWithGetterBlockBody.kt");
                doTest(fileName);
            }

            @TestMetadata("varWithDefaultGetterAndSetter.kt")
            public void testVarWithDefaultGetterAndSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/varWithDefaultGetterAndSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("varWithDefaultSetter.kt")
            public void testVarWithDefaultSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/varWithDefaultSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("varWithGetter.kt")
            public void testVarWithGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/varWithGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("varWithGetterAndSetter.kt")
            public void testVarWithGetterAndSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/varWithGetterAndSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("varWithSetter.kt")
            public void testVarWithSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/varWithSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("withType.kt")
            public void testWithType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/convertMemberToExtension/withType.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/declarations/split")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Split extends AbstractIntentionTest {
            public void testAllFilesPresentInSplit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/declarations/split"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("longInit.kt")
            public void testLongInit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/longInit.kt");
                doTest(fileName);
            }

            @TestMetadata("longInit2.kt")
            public void testLongInit2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/longInit2.kt");
                doTest(fileName);
            }

            @TestMetadata("noInitializer.kt")
            public void testNoInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/noInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("noInitializer2.kt")
            public void testNoInitializer2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/noInitializer2.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLocalProperty.kt")
            public void testNonLocalProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/nonLocalProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLocalProperty2.kt")
            public void testNonLocalProperty2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/nonLocalProperty2.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleInit.kt")
            public void testSimpleInit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/simpleInit.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleInit2.kt")
            public void testSimpleInit2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/simpleInit2.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleInitWithErrorType.kt")
            public void testSimpleInitWithErrorType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/simpleInitWithErrorType.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleInitWithErrorType2.kt")
            public void testSimpleInitWithErrorType2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/simpleInitWithErrorType2.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleInitWithType.kt")
            public void testSimpleInitWithType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/simpleInitWithType.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleInitWithType2.kt")
            public void testSimpleInitWithType2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/declarations/split/simpleInitWithType2.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeprecatedCallableAddReplaceWith extends AbstractIntentionTest {
        public void testAllFilesPresentInDeprecatedCallableAddReplaceWith() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/deprecatedCallableAddReplaceWith"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AlreadyWithReplaceWith.kt")
        public void testAlreadyWithReplaceWith() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/AlreadyWithReplaceWith.kt");
            doTest(fileName);
        }

        @TestMetadata("CommentInBody.kt")
        public void testCommentInBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/CommentInBody.kt");
            doTest(fileName);
        }

        @TestMetadata("DeclarationInside.kt")
        public void testDeclarationInside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/DeclarationInside.kt");
            doTest(fileName);
        }

        @TestMetadata("ExceptionInPropertyDestructuringEntry.kt")
        public void testExceptionInPropertyDestructuringEntry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/ExceptionInPropertyDestructuringEntry.kt");
            doTest(fileName);
        }

        @TestMetadata("ExpressionBody.kt")
        public void testExpressionBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/ExpressionBody.kt");
            doTest(fileName);
        }

        @TestMetadata("If.kt")
        public void testIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/If.kt");
            doTest(fileName);
        }

        @TestMetadata("Imports.kt")
        public void testImports() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/Imports.kt");
            doTest(fileName);
        }

        @TestMetadata("NoCompanionObjectImport.kt")
        public void testNoCompanionObjectImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/NoCompanionObjectImport.kt");
            doTest(fileName);
        }

        @TestMetadata("NoDefaultImport.kt")
        public void testNoDefaultImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/NoDefaultImport.kt");
            doTest(fileName);
        }

        @TestMetadata("NoReturn.kt")
        public void testNoReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/NoReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("NotAvailableOnDocComment.kt")
        public void testNotAvailableOnDocComment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/NotAvailableOnDocComment.kt");
            doTest(fileName);
        }

        @TestMetadata("PrivateSymbolUsed.kt")
        public void testPrivateSymbolUsed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/PrivateSymbolUsed.kt");
            doTest(fileName);
        }

        @TestMetadata("QualifiedCall.kt")
        public void testQualifiedCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/QualifiedCall.kt");
            doTest(fileName);
        }

        @TestMetadata("Return.kt")
        public void testReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/Return.kt");
            doTest(fileName);
        }

        @TestMetadata("ReturnInside.kt")
        public void testReturnInside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/ReturnInside.kt");
            doTest(fileName);
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/Simple.kt");
            doTest(fileName);
        }

        @TestMetadata("StringLiteral.kt")
        public void testStringLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/StringLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("StringTemplate.kt")
        public void testStringTemplate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/StringTemplate.kt");
            doTest(fileName);
        }

        @TestMetadata("TwoStatements.kt")
        public void testTwoStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/TwoStatements.kt");
            doTest(fileName);
        }

        @TestMetadata("ValProperty.kt")
        public void testValProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/ValProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("ValPropertyWithReturn.kt")
        public void testValPropertyWithReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/deprecatedCallableAddReplaceWith/ValPropertyWithReturn.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/intentions/destructuringInLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DestructuringInLambda extends AbstractIntentionTest {
        public void testAllFilesPresentInDestructuringInLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/destructuringInLambda"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("caret.kt")
        public void testCaret() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/caret.kt");
            doTest(fileName);
        }

        @TestMetadata("dependentLocal.kt")
        public void testDependentLocal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/dependentLocal.kt");
            doTest(fileName);
        }

        @TestMetadata("firstProperties.kt")
        public void testFirstProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/firstProperties.kt");
            doTest(fileName);
        }

        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/fold.kt");
            doTest(fileName);
        }

        @TestMetadata("last.kt")
        public void testLast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/last.kt");
            doTest(fileName);
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/list.kt");
            doTest(fileName);
        }

        @TestMetadata("noIt.kt")
        public void testNoIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/noIt.kt");
            doTest(fileName);
        }

        @TestMetadata("noItVariables.kt")
        public void testNoItVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/noItVariables.kt");
            doTest(fileName);
        }

        @TestMetadata("noItWithDestructuring.kt")
        public void testNoItWithDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/noItWithDestructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/nullable.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringInLambda/variables.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/intentions/destructuringVariables")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DestructuringVariables extends AbstractIntentionTest {
        public void testAllFilesPresentInDestructuringVariables() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/destructuringVariables"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("caret.kt")
        public void testCaret() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringVariables/caret.kt");
            doTest(fileName);
        }

        @TestMetadata("changingVar.kt")
        public void testChangingVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringVariables/changingVar.kt");
            doTest(fileName);
        }

        @TestMetadata("noInitializer.kt")
        public void testNoInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringVariables/noInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringVariables/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringVariables/var.kt");
            doTest(fileName);
        }

        @TestMetadata("withModifiers.kt")
        public void testWithModifiers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/destructuringVariables/withModifiers.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/foldInitializerAndIfToElvis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FoldInitializerAndIfToElvis extends AbstractIntentionTest {
        public void testAllFilesPresentInFoldInitializerAndIfToElvis() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/foldInitializerAndIfToElvis"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("Break.kt")
        public void testBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/Break.kt");
            doTest(fileName);
        }

        @TestMetadata("CommentInBlock.kt")
        public void testCommentInBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/CommentInBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("Comments.kt")
        public void testComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/Comments.kt");
            doTest(fileName);
        }

        @TestMetadata("Comments2.kt")
        public void testComments2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/Comments2.kt");
            doTest(fileName);
        }

        @TestMetadata("Continue.kt")
        public void testContinue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/Continue.kt");
            doTest(fileName);
        }

        @TestMetadata("ExplicitValType.kt")
        public void testExplicitValType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/ExplicitValType.kt");
            doTest(fileName);
        }

        @TestMetadata("ExplicitVarType.kt")
        public void testExplicitVarType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/ExplicitVarType.kt");
            doTest(fileName);
        }

        @TestMetadata("IfNotNull.kt")
        public void testIfNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/IfNotNull.kt");
            doTest(fileName);
        }

        @TestMetadata("ifStatementPriority.kt")
        public void testIfStatementPriority() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/ifStatementPriority.kt");
            doTest(fileName);
        }

        @TestMetadata("MultiStatementBlock.kt")
        public void testMultiStatementBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/MultiStatementBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("NotExit.kt")
        public void testNotExit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/NotExit.kt");
            doTest(fileName);
        }

        @TestMetadata("NotIs.kt")
        public void testNotIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/NotIs.kt");
            doTest(fileName);
        }

        @TestMetadata("OtherVar1.kt")
        public void testOtherVar1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/OtherVar1.kt");
            doTest(fileName);
        }

        @TestMetadata("OtherVar2.kt")
        public void testOtherVar2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/OtherVar2.kt");
            doTest(fileName);
        }

        @TestMetadata("Return.kt")
        public void testReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/Return.kt");
            doTest(fileName);
        }

        @TestMetadata("ThrowInBlock.kt")
        public void testThrowInBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/ThrowInBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("Var.kt")
        public void testVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/foldInitializerAndIfToElvis/Var.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/implementAbstractMember")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImplementAbstractMember extends AbstractIntentionTest {
        public void testAllFilesPresentInImplementAbstractMember() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/implementAbstractMember"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/implementAbstractMember/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractIntentionTest {
            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/implementAbstractMember/function"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumClass.kt")
            public void testEnumClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/enumClass.kt");
                doTest(fileName);
            }

            @TestMetadata("enumClassWithSemicolon.kt")
            public void testEnumClassWithSemicolon() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/enumClassWithSemicolon.kt");
                doTest(fileName);
            }

            @TestMetadata("enumClassWithSemicolonAndMembers.kt")
            public void testEnumClassWithSemicolonAndMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/enumClassWithSemicolonAndMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntries.kt")
            public void testEnumEntries() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/enumEntries.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntriesWithArgs.kt")
            public void testEnumEntriesWithArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/enumEntriesWithArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("implementAll.kt")
            public void testImplementAll() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/implementAll.kt");
                doTest(fileName);
            }

            @TestMetadata("inFinalClass.kt")
            public void testInFinalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/inFinalClass.kt");
                doTest(fileName);
            }

            @TestMetadata("inObject.kt")
            public void testInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/inObject.kt");
                doTest(fileName);
            }

            @TestMetadata("noDirectOverridesNeeded.kt")
            public void testNoDirectOverridesNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/noDirectOverridesNeeded.kt");
                doTest(fileName);
            }

            @TestMetadata("noInheritors.kt")
            public void testNoInheritors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/noInheritors.kt");
                doTest(fileName);
            }

            @TestMetadata("notAbstractInClass.kt")
            public void testNotAbstractInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/notAbstractInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("notAbstractInInterface.kt")
            public void testNotAbstractInInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/notAbstractInInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("notAbstractNoBodyInClass.kt")
            public void testNotAbstractNoBodyInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/function/notAbstractNoBodyInClass.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/implementAbstractMember/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractIntentionTest {
            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/implementAbstractMember/property"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumClass.kt")
            public void testEnumClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/enumClass.kt");
                doTest(fileName);
            }

            @TestMetadata("enumClassWithSemicolon.kt")
            public void testEnumClassWithSemicolon() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/enumClassWithSemicolon.kt");
                doTest(fileName);
            }

            @TestMetadata("enumClassWithSemicolonAndMembers.kt")
            public void testEnumClassWithSemicolonAndMembers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/enumClassWithSemicolonAndMembers.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntries.kt")
            public void testEnumEntries() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/enumEntries.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntriesWithArgs.kt")
            public void testEnumEntriesWithArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/enumEntriesWithArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("implementAll.kt")
            public void testImplementAll() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/implementAll.kt");
                doTest(fileName);
            }

            @TestMetadata("inFinalClass.kt")
            public void testInFinalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/inFinalClass.kt");
                doTest(fileName);
            }

            @TestMetadata("inObject.kt")
            public void testInObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/inObject.kt");
                doTest(fileName);
            }

            @TestMetadata("noDirectOverridesNeeded.kt")
            public void testNoDirectOverridesNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/noDirectOverridesNeeded.kt");
                doTest(fileName);
            }

            @TestMetadata("noInheritors.kt")
            public void testNoInheritors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/noInheritors.kt");
                doTest(fileName);
            }

            @TestMetadata("notAbstractInClass.kt")
            public void testNotAbstractInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/notAbstractInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("notAbstractNoBodyInClass.kt")
            public void testNotAbstractNoBodyInClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/notAbstractNoBodyInClass.kt");
                doTest(fileName);
            }

            @TestMetadata("notAbstractWithGetterInInterface.kt")
            public void testNotAbstractWithGetterInInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAbstractMember/property/notAbstractWithGetterInInterface.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/implementAsConstructorParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImplementAsConstructorParameter extends AbstractIntentionTest {
        public void testAllFilesPresentInImplementAsConstructorParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/implementAsConstructorParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("enumClass.kt")
        public void testEnumClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/enumClass.kt");
            doTest(fileName);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/function.kt");
            doTest(fileName);
        }

        @TestMetadata("implementAll.kt")
        public void testImplementAll() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/implementAll.kt");
            doTest(fileName);
        }

        @TestMetadata("inEnumClass.kt")
        public void testInEnumClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/inEnumClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inFinalClass.kt")
        public void testInFinalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/inFinalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inObject.kt")
        public void testInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/inObject.kt");
            doTest(fileName);
        }

        @TestMetadata("noDirectOverridesNeeded.kt")
        public void testNoDirectOverridesNeeded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/noDirectOverridesNeeded.kt");
            doTest(fileName);
        }

        @TestMetadata("noInheritors.kt")
        public void testNoInheritors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/noInheritors.kt");
            doTest(fileName);
        }

        @TestMetadata("notAbstractInClass.kt")
        public void testNotAbstractInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/notAbstractInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("notAbstractNoBodyInClass.kt")
        public void testNotAbstractNoBodyInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/notAbstractNoBodyInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("notAbstractWithGetterInInterface.kt")
        public void testNotAbstractWithGetterInInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/implementAsConstructorParameter/notAbstractWithGetterInInterface.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/importAllMembers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImportAllMembers extends AbstractIntentionTest {
        public void testAllFilesPresentInImportAllMembers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/importAllMembers"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AlreadyImported.kt")
        public void testAlreadyImported() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/AlreadyImported.kt");
            doTest(fileName);
        }

        @TestMetadata("AlreadyImportedWithStar.kt")
        public void testAlreadyImportedWithStar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/AlreadyImportedWithStar.kt");
            doTest(fileName);
        }

        @TestMetadata("AmbiguousCalls.kt")
        public void testAmbiguousCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/AmbiguousCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("EnumMembers.kt")
        public void testEnumMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/EnumMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("NotFromCompanionObject.kt")
        public void testNotFromCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/NotFromCompanionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("NotFromObject.kt")
        public void testNotFromObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/NotFromObject.kt");
            doTest(fileName);
        }

        @TestMetadata("QualifiedName.kt")
        public void testQualifiedName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/QualifiedName.kt");
            doTest(fileName);
        }

        @TestMetadata("QualifiedName2.kt")
        public void testQualifiedName2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/QualifiedName2.kt");
            doTest(fileName);
        }

        @TestMetadata("RemoveSingleImports.kt")
        public void testRemoveSingleImports() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/RemoveSingleImports.kt");
            doTest(fileName);
        }

        @TestMetadata("StaticJavaMembers.kt")
        public void testStaticJavaMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/StaticJavaMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("UnresolvedMember.kt")
        public void testUnresolvedMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importAllMembers/UnresolvedMember.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/importMember")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImportMember extends AbstractIntentionTest {
        public void testAllFilesPresentInImportMember() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/importMember"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("EnumMember.kt")
        public void testEnumMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/EnumMember.kt");
            doTest(fileName);
        }

        @TestMetadata("FromCompanionObject.kt")
        public void testFromCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/FromCompanionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("NestedClass1.kt")
        public void testNestedClass1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/NestedClass1.kt");
            doTest(fileName);
        }

        @TestMetadata("NestedClass2.kt")
        public void testNestedClass2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/NestedClass2.kt");
            doTest(fileName);
        }

        @TestMetadata("NoTarget.kt")
        public void testNoTarget() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/NoTarget.kt");
            doTest(fileName);
        }

        @TestMetadata("NotForQualifier.kt")
        public void testNotForQualifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/NotForQualifier.kt");
            doTest(fileName);
        }

        @TestMetadata("ObjectMethod.kt")
        public void testObjectMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/ObjectMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("StaticJavaField.kt")
        public void testStaticJavaField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/StaticJavaField.kt");
            doTest(fileName);
        }

        @TestMetadata("StaticJavaMethod.kt")
        public void testStaticJavaMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/StaticJavaMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("TopLevelFun.kt")
        public void testTopLevelFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/importMember/TopLevelFun.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/infixCallToOrdinary")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InfixCallToOrdinary extends AbstractIntentionTest {
        public void testAllFilesPresentInInfixCallToOrdinary() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/infixCallToOrdinary"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("functionCallAfterInfixCall.kt")
        public void testFunctionCallAfterInfixCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/infixCallToOrdinary/functionCallAfterInfixCall.kt");
            doTest(fileName);
        }

        @TestMetadata("functionLiteralArgument.kt")
        public void testFunctionLiteralArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/infixCallToOrdinary/functionLiteralArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("nonApplicableBinaryOperation.kt")
        public void testNonApplicableBinaryOperation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/infixCallToOrdinary/nonApplicableBinaryOperation.kt");
            doTest(fileName);
        }

        @TestMetadata("nullAssertedCall.kt")
        public void testNullAssertedCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/infixCallToOrdinary/nullAssertedCall.kt");
            doTest(fileName);
        }

        @TestMetadata("parenthesesAroundRightHandArgument.kt")
        public void testParenthesesAroundRightHandArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/infixCallToOrdinary/parenthesesAroundRightHandArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInfixFunctionCall.kt")
        public void testSimpleInfixFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/infixCallToOrdinary/simpleInfixFunctionCall.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/insertCurlyBracesToTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InsertCurlyBracesToTemplate extends AbstractIntentionTest {
        public void testAllFilesPresentInInsertCurlyBracesToTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/insertCurlyBracesToTemplate"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dontInsertBrackets1.kt")
        public void testDontInsertBrackets1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertCurlyBracesToTemplate/dontInsertBrackets1.kt");
            doTest(fileName);
        }

        @TestMetadata("insertBrackets1.kt")
        public void testInsertBrackets1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets1.kt");
            doTest(fileName);
        }

        @TestMetadata("insertBrackets2.kt")
        public void testInsertBrackets2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets2.kt");
            doTest(fileName);
        }

        @TestMetadata("insertBrackets3.kt")
        public void testInsertBrackets3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets3.kt");
            doTest(fileName);
        }

        @TestMetadata("insertBrackets4.kt")
        public void testInsertBrackets4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets4.kt");
            doTest(fileName);
        }

        @TestMetadata("insertBrackets5.kt")
        public void testInsertBrackets5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets5.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/insertExplicitTypeArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InsertExplicitTypeArguments extends AbstractIntentionTest {
        public void testAllFilesPresentInInsertExplicitTypeArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/insertExplicitTypeArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicableAlreadyTyped.kt")
        public void testInapplicableAlreadyTyped() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/inapplicableAlreadyTyped.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableNotGeneric.kt")
        public void testInapplicableNotGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/inapplicableNotGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableNotInCallable.kt")
        public void testInapplicableNotInCallable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/inapplicableNotInCallable.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableNotInCallable2.kt")
        public void testInapplicableNotInCallable2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/inapplicableNotInCallable2.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableTypeNotInferred.kt")
        public void testInapplicableTypeNotInferred() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/inapplicableTypeNotInferred.kt");
            doTest(fileName);
        }

        @TestMetadata("insertImportForArg.kt")
        public void testInsertImportForArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertImportForArg.kt");
            doTest(fileName);
        }

        @TestMetadata("insertManyTypes.kt")
        public void testInsertManyTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertManyTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("insertManyTypesInDifferentOrder.kt")
        public void testInsertManyTypesInDifferentOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertManyTypesInDifferentOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("insertMultipleSomeWithClashingName.kt")
        public void testInsertMultipleSomeWithClashingName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertMultipleSomeWithClashingName.kt");
            doTest(fileName);
        }

        @TestMetadata("insertTwoTypesFun.kt")
        public void testInsertTwoTypesFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertTwoTypesFun.kt");
            doTest(fileName);
        }

        @TestMetadata("insertTypeAny.kt")
        public void testInsertTypeAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertTypeAny.kt");
            doTest(fileName);
        }

        @TestMetadata("insertTypeThatIsAFunction.kt")
        public void testInsertTypeThatIsAFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertTypeThatIsAFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("insertTypeThatIsATypeArg.kt")
        public void testInsertTypeThatIsATypeArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertTypeThatIsATypeArg.kt");
            doTest(fileName);
        }

        @TestMetadata("insertTypeWithClashingName.kt")
        public void testInsertTypeWithClashingName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertTypeWithClashingName.kt");
            doTest(fileName);
        }

        @TestMetadata("insertTypeWithLambda.kt")
        public void testInsertTypeWithLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertTypeWithLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("insertTypeWithTypeArguments.kt")
        public void testInsertTypeWithTypeArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertTypeWithTypeArguments.kt");
            doTest(fileName);
        }

        @TestMetadata("insertTypeWithVarargs.kt")
        public void testInsertTypeWithVarargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/insertTypeWithVarargs.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInsertTypeClass.kt")
        public void testSimpleInsertTypeClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/simpleInsertTypeClass.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInsertTypeFun.kt")
        public void testSimpleInsertTypeFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/insertExplicitTypeArguments/simpleInsertTypeFun.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/introduceBackingProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceBackingProperty extends AbstractIntentionTest {
        public void testAllFilesPresentInIntroduceBackingProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/introduceBackingProperty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("backingFieldRef.kt")
        public void testBackingFieldRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/backingFieldRef.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableAbstractProperty.kt")
        public void testInapplicableAbstractProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/inapplicableAbstractProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableNoBackingField.kt")
        public void testInapplicableNoBackingField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/inapplicableNoBackingField.kt");
            doTest(fileName);
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/semicolon.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleVal.kt")
        public void testSimpleVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/simpleVal.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleValWithType.kt")
        public void testSimpleValWithType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/simpleValWithType.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleVar.kt")
        public void testSimpleVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/simpleVar.kt");
            doTest(fileName);
        }

        @TestMetadata("valWithAccessor.kt")
        public void testValWithAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/valWithAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("varWithAccessor.kt")
        public void testVarWithAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceBackingProperty/varWithAccessor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/introduceVariable")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceVariable extends AbstractIntentionTest {
        @TestMetadata("afterExpression.kt")
        public void testAfterExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceVariable/afterExpression.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInIntroduceVariable() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/introduceVariable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("atExpressionEnd.kt")
        public void testAtExpressionEnd() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceVariable/atExpressionEnd.kt");
            doTest(fileName);
        }

        @TestMetadata("atExpressionStart.kt")
        public void testAtExpressionStart() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceVariable/atExpressionStart.kt");
            doTest(fileName);
        }

        @TestMetadata("atNestedExpression.kt")
        public void testAtNestedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceVariable/atNestedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("beforeExpression.kt")
        public void testBeforeExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceVariable/beforeExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("noType.kt")
        public void testNoType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceVariable/noType.kt");
            doTest(fileName);
        }

        @TestMetadata("nothingType.kt")
        public void testNothingType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceVariable/nothingType.kt");
            doTest(fileName);
        }

        @TestMetadata("unitType.kt")
        public void testUnitType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/introduceVariable/unitType.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/invertIfCondition")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InvertIfCondition extends AbstractIntentionTest {
        @TestMetadata("addSurroundingBlock_preserveComments.kt")
        public void testAddSurroundingBlock_preserveComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/addSurroundingBlock_preserveComments.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInInvertIfCondition() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/invertIfCondition"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignedToValue.kt")
        public void testAssignedToValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/assignedToValue.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryExpression.kt")
        public void testBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/binaryExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("booleanLiteral.kt")
        public void testBooleanLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/booleanLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("branchingIfStatements.kt")
        public void testBranchingIfStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/branchingIfStatements.kt");
            doTest(fileName);
        }

        @TestMetadata("endOfLineCommentBug.kt")
        public void testEndOfLineCommentBug() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/endOfLineCommentBug.kt");
            doTest(fileName);
        }

        @TestMetadata("forLoopWithMultipleExpressions.kt")
        public void testForLoopWithMultipleExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/forLoopWithMultipleExpressions.kt");
            doTest(fileName);
        }

        @TestMetadata("functionWithReturnExpression.kt")
        public void testFunctionWithReturnExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/functionWithReturnExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("ifExpressionInsideForLoop.kt")
        public void testIfExpressionInsideForLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/ifExpressionInsideForLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("ifExpressionWithReturn.kt")
        public void testIfExpressionWithReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/ifExpressionWithReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("ifThenReturn.kt")
        public void testIfThenReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/ifThenReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("ifThenReturn2.kt")
        public void testIfThenReturn2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/ifThenReturn2.kt");
            doTest(fileName);
        }

        @TestMetadata("ifThenReturn3.kt")
        public void testIfThenReturn3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/ifThenReturn3.kt");
            doTest(fileName);
        }

        @TestMetadata("ifThenReturn4.kt")
        public void testIfThenReturn4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/ifThenReturn4.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWithBothBranchesReturn.kt")
        public void testIfWithBothBranchesReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/ifWithBothBranchesReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWithBothBranchesSetter.kt")
        public void testIfWithBothBranchesSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/ifWithBothBranchesSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/in.kt");
            doTest(fileName);
        }

        @TestMetadata("invertableOperator.kt")
        public void testInvertableOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/invertableOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/is.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaNonLocalAndLocalReturn.kt")
        public void testLambdaNonLocalAndLocalReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lambdaNonLocalAndLocalReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaNonLocalReturn.kt")
        public void testLambdaNonLocalReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lambdaNonLocalReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatement1.kt")
        public void testLastStatement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatement1.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatement2.kt")
        public void testLastStatement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatement2.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatement3.kt")
        public void testLastStatement3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatement3.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatementBeforeBreak.kt")
        public void testLastStatementBeforeBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatementBeforeBreak.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatementBeforeContinue.kt")
        public void testLastStatementBeforeContinue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatementBeforeContinue.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatementBeforeReturn.kt")
        public void testLastStatementBeforeReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatementBeforeReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatementInLambda.kt")
        public void testLastStatementInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatementInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatementInLoop.kt")
        public void testLastStatementInLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatementInLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatementInLoop2.kt")
        public void testLastStatementInLoop2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatementInLoop2.kt");
            doTest(fileName);
        }

        @TestMetadata("lastStatementNonUnitMethod.kt")
        public void testLastStatementNonUnitMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/lastStatementNonUnitMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("negatedExpression.kt")
        public void testNegatedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/negatedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedIfWithReturn.kt")
        public void testNestedIfWithReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/nestedIfWithReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("notIn.kt")
        public void testNotIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/notIn.kt");
            doTest(fileName);
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/notIs.kt");
            doTest(fileName);
        }

        @TestMetadata("returnIfExpression.kt")
        public void testReturnIfExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/returnIfExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("valueAndReturnBranches.kt")
        public void testValueAndReturnBranches() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/invertIfCondition/valueAndReturnBranches.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/iterateExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IterateExpression extends AbstractIntentionTest {
        public void testAllFilesPresentInIterateExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/iterateExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("collectionIteratorWithComponents.kt")
        public void testCollectionIteratorWithComponents() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/collectionIteratorWithComponents.kt");
            doTest(fileName);
        }

        @TestMetadata("dataClassCollectionIterator.kt")
        public void testDataClassCollectionIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/dataClassCollectionIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionIterator.kt")
        public void testExtensionIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/extensionIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionIteratorWithPartialSubstitution1.kt")
        public void testExtensionIteratorWithPartialSubstitution1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/extensionIteratorWithPartialSubstitution1.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionIteratorWithPartialSubstitution2.kt")
        public void testExtensionIteratorWithPartialSubstitution2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/extensionIteratorWithPartialSubstitution2.kt");
            doTest(fileName);
        }

        @TestMetadata("functionCall.kt")
        public void testFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/functionCall.kt");
            doTest(fileName);
        }

        @TestMetadata("mapIterator.kt")
        public void testMapIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/mapIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("nameSuggestion.kt")
        public void testNameSuggestion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/nameSuggestion.kt");
            doTest(fileName);
        }

        @TestMetadata("noNameConflict.kt")
        public void testNoNameConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/noNameConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("nonOperatorIterator.kt")
        public void testNonOperatorIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/nonOperatorIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("nonOperatotExtensionIterator.kt")
        public void testNonOperatotExtensionIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/nonOperatotExtensionIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterateExpression/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/iterationOverMap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IterationOverMap extends AbstractIntentionTest {
        public void testAllFilesPresentInIterationOverMap() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/iterationOverMap"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AlreadyDestructing.kt")
        public void testAlreadyDestructing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/AlreadyDestructing.kt");
            doTest(fileName);
        }

        @TestMetadata("CaretOffset.kt")
        public void testCaretOffset() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/CaretOffset.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClass.kt")
        public void testDataClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClass.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassDependentLocal.kt")
        public void testDataClassDependentLocal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassDependentLocal.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassFirstNPropertiesUsed.kt")
        public void testDataClassFirstNPropertiesUsed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassFirstNPropertiesUsed.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassFirstVariable.kt")
        public void testDataClassFirstVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassFirstVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassLast.kt")
        public void testDataClassLast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassLast.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassNameConflict.kt")
        public void testDataClassNameConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassNameConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassNoVariablesInside.kt")
        public void testDataClassNoVariablesInside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassNoVariablesInside.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassNoVariablesMultiUsages.kt")
        public void testDataClassNoVariablesMultiUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassNoVariablesMultiUsages.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassNotAllPropertiesUsed.kt")
        public void testDataClassNotAllPropertiesUsed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassNotAllPropertiesUsed.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassNullable.kt")
        public void testDataClassNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassParametersOrder.kt")
        public void testDataClassParametersOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassParametersOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassPropertyBetweenUsages.kt")
        public void testDataClassPropertyBetweenUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassPropertyBetweenUsages.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassSecondVariable.kt")
        public void testDataClassSecondVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassSecondVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassTwoDifferentLocals.kt")
        public void testDataClassTwoDifferentLocals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassTwoDifferentLocals.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassUnused.kt")
        public void testDataClassUnused() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassUnused.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassWithAssignmentInside.kt")
        public void testDataClassWithAssignmentInside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassWithAssignmentInside.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassWithDestructuring.kt")
        public void testDataClassWithDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassWithDestructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassWithDestructuringConflict.kt")
        public void testDataClassWithDestructuringConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassWithDestructuringConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassWithDestructuringFakeConflict.kt")
        public void testDataClassWithDestructuringFakeConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassWithDestructuringFakeConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassWithDestructuringPartial.kt")
        public void testDataClassWithDestructuringPartial() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassWithDestructuringPartial.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassWithExternalUsage.kt")
        public void testDataClassWithExternalUsage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassWithExternalUsage.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassWithIncrementInside.kt")
        public void testDataClassWithIncrementInside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassWithIncrementInside.kt");
            doTest(fileName);
        }

        @TestMetadata("DataClassWithLocalPropertyModified.kt")
        public void testDataClassWithLocalPropertyModified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/DataClassWithLocalPropertyModified.kt");
            doTest(fileName);
        }

        @TestMetadata("EntriesCallIsMissing.kt")
        public void testEntriesCallIsMissing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/EntriesCallIsMissing.kt");
            doTest(fileName);
        }

        @TestMetadata("FakeEntries.kt")
        public void testFakeEntries() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/FakeEntries.kt");
            doTest(fileName);
        }

        @TestMetadata("Getters.kt")
        public void testGetters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/Getters.kt");
            doTest(fileName);
        }

        @TestMetadata("KeyOnly.kt")
        public void testKeyOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/KeyOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("KeyOnlyWithDestructuring.kt")
        public void testKeyOnlyWithDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/KeyOnlyWithDestructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("KeyValueWithDestructuring.kt")
        public void testKeyValueWithDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/KeyValueWithDestructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("MapNoProperties.kt")
        public void testMapNoProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/MapNoProperties.kt");
            doTest(fileName);
        }

        @TestMetadata("OnlyKeyUsed.kt")
        public void testOnlyKeyUsed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/OnlyKeyUsed.kt");
            doTest(fileName);
        }

        @TestMetadata("OtherUsages.kt")
        public void testOtherUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/OtherUsages.kt");
            doTest(fileName);
        }

        @TestMetadata("OtherUsages2.kt")
        public void testOtherUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/OtherUsages2.kt");
            doTest(fileName);
        }

        @TestMetadata("PropertiesNames.kt")
        public void testPropertiesNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/PropertiesNames.kt");
            doTest(fileName);
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/Simple.kt");
            doTest(fileName);
        }

        @TestMetadata("SomeQualifiedExpressionInRange.kt")
        public void testSomeQualifiedExpressionInRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/SomeQualifiedExpressionInRange.kt");
            doTest(fileName);
        }

        @TestMetadata("ValueOnly.kt")
        public void testValueOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/iterationOverMap/ValueOnly.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/intentions/joinDeclarationAndAssignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JoinDeclarationAndAssignment extends AbstractIntentionTest {
        public void testAllFilesPresentInJoinDeclarationAndAssignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/joinDeclarationAndAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignmentInIf.kt")
        public void testAssignmentInIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/assignmentInIf.kt");
            doTest(fileName);
        }

        @TestMetadata("cannotRemoveType.kt")
        public void testCannotRemoveType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/cannotRemoveType.kt");
            doTest(fileName);
        }

        @TestMetadata("cannotRemoveType2.kt")
        public void testCannotRemoveType2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/cannotRemoveType2.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedInitialization.kt")
        public void testCapturedInitialization() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/capturedInitialization.kt");
            doTest(fileName);
        }

        @TestMetadata("comment.kt")
        public void testComment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/comment.kt");
            doTest(fileName);
        }

        @TestMetadata("correctConditionalAssignment.kt")
        public void testCorrectConditionalAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/correctConditionalAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("deleteInitBlock.kt")
        public void testDeleteInitBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/deleteInitBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("incorrectConditionalAssignment.kt")
        public void testIncorrectConditionalAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/incorrectConditionalAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleConstructors.kt")
        public void testMultipleConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/multipleConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyReassignment.kt")
        public void testPropertyReassignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/propertyReassignment.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleLocal.kt")
        public void testSimpleLocal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/simpleLocal.kt");
            doTest(fileName);
        }

        @TestMetadata("singleConstructor.kt")
        public void testSingleConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/singleConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("usedLocal.kt")
        public void testUsedLocal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/usedLocal.kt");
            doTest(fileName);
        }

        @TestMetadata("usedLocal2.kt")
        public void testUsedLocal2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/usedLocal2.kt");
            doTest(fileName);
        }

        @TestMetadata("varReassignment.kt")
        public void testVarReassignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/joinDeclarationAndAssignment/varReassignment.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LoopToCallChain extends AbstractIntentionTest {
        public void testAllFilesPresentInLoopToCallChain() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/array.kt");
            doTest(fileName);
        }

        @TestMetadata("asSequenceOnly.kt")
        public void testAsSequenceOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/asSequenceOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("customTypeWithIterator.kt")
        public void testCustomTypeWithIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/customTypeWithIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("embeddedBreak1.kt")
        public void testEmbeddedBreak1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/embeddedBreak1.kt");
            doTest(fileName);
        }

        @TestMetadata("embeddedBreak2.kt")
        public void testEmbeddedBreak2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/embeddedBreak2.kt");
            doTest(fileName);
        }

        @TestMetadata("embeddedContinue.kt")
        public void testEmbeddedContinue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/embeddedContinue.kt");
            doTest(fileName);
        }

        @TestMetadata("intArray.kt")
        public void testIntArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/intArray.kt");
            doTest(fileName);
        }

        @TestMetadata("itAlreadyUsed.kt")
        public void testItAlreadyUsed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/itAlreadyUsed.kt");
            doTest(fileName);
        }

        @TestMetadata("KT14191.kt")
        public void testKT14191() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/KT14191.kt");
            doTest(fileName);
        }

        @TestMetadata("lastOrNull_ifAssign.kt")
        public void testLastOrNull_ifAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/lastOrNull_ifAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("moveInitializationsCloserToLoop.kt")
        public void testMoveInitializationsCloserToLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/moveInitializationsCloserToLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("range.kt")
        public void testRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/range.kt");
            doTest(fileName);
        }

        @TestMetadata("twoInitializationsBeforeLoop.kt")
        public void testTwoInitializationsBeforeLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/twoInitializationsBeforeLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/any")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Any extends AbstractIntentionTest {
            public void testAllFilesPresentInAny() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/any"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anyNotNull.kt")
            public void testAnyNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/anyNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign.kt")
            public void testIfAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/ifAssign.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_moveDeclaration.kt")
            public void testIfAssign_moveDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/ifAssign_moveDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_moveInitialization.kt")
            public void testIfAssign_moveInitialization() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/ifAssign_moveInitialization.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_noBreak.kt")
            public void testIfAssign_noBreak() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/ifAssign_noBreak.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_nonBooleanResult.kt")
            public void testIfAssign_nonBooleanResult() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/ifAssign_nonBooleanResult.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_nonBooleanResult2.kt")
            public void testIfAssign_nonBooleanResult2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/ifAssign_nonBooleanResult2.kt");
                doTest(fileName);
            }

            @TestMetadata("ifReturn.kt")
            public void testIfReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/ifReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("ifReturn_nonBooleanResult.kt")
            public void testIfReturn_nonBooleanResult() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/ifReturn_nonBooleanResult.kt");
                doTest(fileName);
            }

            @TestMetadata("indexNeeded.kt")
            public void testIndexNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/indexNeeded.kt");
                doTest(fileName);
            }

            @TestMetadata("KT13998.kt")
            public void testKT13998() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/KT13998.kt");
                doTest(fileName);
            }

            @TestMetadata("KT13998_1.kt")
            public void testKT13998_1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/KT13998_1.kt");
                doTest(fileName);
            }

            @TestMetadata("none.kt")
            public void testNone() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/none.kt");
                doTest(fileName);
            }

            @TestMetadata("return.kt")
            public void testReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/any/return.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/contains")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Contains extends AbstractIntentionTest {
            @TestMetadata("1.kt")
            public void test1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/contains/1.kt");
                doTest(fileName);
            }

            @TestMetadata("2.kt")
            public void test2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/contains/2.kt");
                doTest(fileName);
            }

            @TestMetadata("3.kt")
            public void test3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/contains/3.kt");
                doTest(fileName);
            }

            @TestMetadata("4.kt")
            public void test4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/contains/4.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInContains() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/contains"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/count")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Count extends AbstractIntentionTest {
            @TestMetadata("1.kt")
            public void test1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/1.kt");
                doTest(fileName);
            }

            @TestMetadata("2.kt")
            public void test2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/2.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInCount() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/count"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("countIsInstance.kt")
            public void testCountIsInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/countIsInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("countNotNull.kt")
            public void testCountNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/countNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("countSomethingAndNotNull.kt")
            public void testCountSomethingAndNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/countSomethingAndNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/long.kt");
                doTest(fileName);
            }

            @TestMetadata("nonConstantInitial.kt")
            public void testNonConstantInitial() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/nonConstantInitial.kt");
                doTest(fileName);
            }

            @TestMetadata("nonZeroInitial.kt")
            public void testNonZeroInitial() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/nonZeroInitial.kt");
                doTest(fileName);
            }

            @TestMetadata("prefix.kt")
            public void testPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/prefix.kt");
                doTest(fileName);
            }

            @TestMetadata("variableUsedBefore.kt")
            public void testVariableUsedBefore() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/count/variableUsedBefore.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/filter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Filter extends AbstractIntentionTest {
            public void testAllFilesPresentInFilter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/filter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assign.kt")
            public void testAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assign.kt");
                doTest(fileName);
            }

            @TestMetadata("assign2.kt")
            public void testAssign2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assign2.kt");
                doTest(fileName);
            }

            @TestMetadata("assignFilterIndexed.kt")
            public void testAssignFilterIndexed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assignFilterIndexed.kt");
                doTest(fileName);
            }

            @TestMetadata("assignFilterNotNull.kt")
            public void testAssignFilterNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assignFilterNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("assign_ArrayListRequired.kt")
            public void testAssign_ArrayListRequired() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired.kt");
                doTest(fileName);
            }

            @TestMetadata("assign_ArrayListRequired2.kt")
            public void testAssign_ArrayListRequired2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired2.kt");
                doTest(fileName);
            }

            @TestMetadata("assign_ArrayListRequired3.kt")
            public void testAssign_ArrayListRequired3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired3.kt");
                doTest(fileName);
            }

            @TestMetadata("assign_MutableListRequired.kt")
            public void testAssign_MutableListRequired() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assign_MutableListRequired.kt");
                doTest(fileName);
            }

            @TestMetadata("assign_breakAndContinue.kt")
            public void testAssign_breakAndContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/assign_breakAndContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("cannotSplitOutFilterIsInstance.kt")
            public void testCannotSplitOutFilterIsInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/cannotSplitOutFilterIsInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("doNotSplitOutFilterIsInstance.kt")
            public void testDoNotSplitOutFilterIsInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/doNotSplitOutFilterIsInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("doNotSplitOutFilterNotNull.kt")
            public void testDoNotSplitOutFilterNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/doNotSplitOutFilterNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed.kt")
            public void testFilterIndexed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed2.kt")
            public void testFilterIndexed2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed2.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexedAndFlatMapWithContinue.kt")
            public void testFilterIndexedAndFlatMapWithContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexedAndFlatMapWithContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexedTo.kt")
            public void testFilterIndexedTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexedTo.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexedTo2.kt")
            public void testFilterIndexedTo2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexedTo2.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_indexChangedTwice.kt")
            public void testFilterIndexed_indexChangedTwice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexChangedTwice.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_indexStartNotZero.kt")
            public void testFilterIndexed_indexStartNotZero() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexStartNotZero.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_indexUsedAfter.kt")
            public void testFilterIndexed_indexUsedAfter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexUsedAfter.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_indexUsedEarlierInLoop.kt")
            public void testFilterIndexed_indexUsedEarlierInLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexUsedEarlierInLoop.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_merge1.kt")
            public void testFilterIndexed_merge1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge1.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_merge2.kt")
            public void testFilterIndexed_merge2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge2.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_merge3.kt")
            public void testFilterIndexed_merge3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge3.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_merge4.kt")
            public void testFilterIndexed_merge4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge4.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_twoIndices.kt")
            public void testFilterIndexed_twoIndices() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_twoIndices.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIndexed_twoIndicesUsed.kt")
            public void testFilterIndexed_twoIndicesUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIndexed_twoIndicesUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIsInstance.kt")
            public void testFilterIsInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIsInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIsInstanceTo.kt")
            public void testFilterIsInstanceTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIsInstanceTo.kt");
                doTest(fileName);
            }

            @TestMetadata("filterIsInstance_ifContinue.kt")
            public void testFilterIsInstance_ifContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterIsInstance_ifContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("filterNotNull.kt")
            public void testFilterNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("filterNotNullTo.kt")
            public void testFilterNotNullTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterNotNullTo.kt");
                doTest(fileName);
            }

            @TestMetadata("filterNotNullTo2.kt")
            public void testFilterNotNullTo2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterNotNullTo2.kt");
                doTest(fileName);
            }

            @TestMetadata("filterNotNull_ifContinue.kt")
            public void testFilterNotNull_ifContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterNotNull_ifContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("filterNotTo.kt")
            public void testFilterNotTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterNotTo.kt");
                doTest(fileName);
            }

            @TestMetadata("filterNot_ifContinue.kt")
            public void testFilterNot_ifContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterNot_ifContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("filterTo.kt")
            public void testFilterTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterTo.kt");
                doTest(fileName);
            }

            @TestMetadata("filterTo2.kt")
            public void testFilterTo2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/filterTo2.kt");
                doTest(fileName);
            }

            @TestMetadata("glueTogetherFilterNotNull.kt")
            public void testGlueTogetherFilterNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/glueTogetherFilterNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("ifContinue.kt")
            public void testIfContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/ifContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("ifContinue2.kt")
            public void testIfContinue2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/ifContinue2.kt");
                doTest(fileName);
            }

            @TestMetadata("ifContinueInBlock.kt")
            public void testIfContinueInBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/ifContinueInBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("ifContinueWithLabel.kt")
            public void testIfContinueWithLabel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/ifContinueWithLabel.kt");
                doTest(fileName);
            }

            @TestMetadata("ifElse.kt")
            public void testIfElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/ifElse.kt");
                doTest(fileName);
            }

            @TestMetadata("inputVarNotUsed.kt")
            public void testInputVarNotUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/inputVarNotUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("inputVariableNotUsed.kt")
            public void testInputVariableNotUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/inputVariableNotUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("mergeMultiple.kt")
            public void testMergeMultiple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/mergeMultiple.kt");
                doTest(fileName);
            }

            @TestMetadata("splitOutFilterIsInstance.kt")
            public void testSplitOutFilterIsInstance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/splitOutFilterIsInstance.kt");
                doTest(fileName);
            }

            @TestMetadata("splitOutFilterNotNull.kt")
            public void testSplitOutFilterNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/splitOutFilterNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("splitOutFilterNotNull2.kt")
            public void testSplitOutFilterNotNull2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/filter/splitOutFilterNotNull2.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/firstOrNull")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FirstOrNull extends AbstractIntentionTest {
            public void testAllFilesPresentInFirstOrNull() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/firstOrNull"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignmentInitialization.kt")
            public void testAssignmentInitialization() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/assignmentInitialization.kt");
                doTest(fileName);
            }

            @TestMetadata("cannotUseLet.kt")
            public void testCannotUseLet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/cannotUseLet.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign.kt")
            public void testIfAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_breakWithLabel.kt")
            public void testIfAssign_breakWithLabel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_breakWithLabel.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_cannotBeVal.kt")
            public void testIfAssign_cannotBeVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_cannotBeVal.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_preserveComments.kt")
            public void testIfAssign_preserveComments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_preserveComments.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAssign_variableUsedBefore.kt")
            public void testIfAssign_variableUsedBefore() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_variableUsedBefore.kt");
                doTest(fileName);
            }

            @TestMetadata("ifReturn.kt")
            public void testIfReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/ifReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("KT14292.kt")
            public void testKT14292() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/KT14292.kt");
                doTest(fileName);
            }

            @TestMetadata("let.kt")
            public void testLet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/let.kt");
                doTest(fileName);
            }

            @TestMetadata("let2.kt")
            public void testLet2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/let2.kt");
                doTest(fileName);
            }

            @TestMetadata("letOrNotNull.kt")
            public void testLetOrNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/letOrNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("return.kt")
            public void testReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/return.kt");
                doTest(fileName);
            }

            @TestMetadata("returnExpression.kt")
            public void testReturnExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/returnExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("returnExpressionOrNotNull.kt")
            public void testReturnExpressionOrNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/returnExpressionOrNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("returnNotNullIfNone.kt")
            public void testReturnNotNullIfNone() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/returnNotNullIfNone.kt");
                doTest(fileName);
            }

            @TestMetadata("returnNotNullIfNone2.kt")
            public void testReturnNotNullIfNone2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/returnNotNullIfNone2.kt");
                doTest(fileName);
            }

            @TestMetadata("return_comment.kt")
            public void testReturn_comment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/return_comment.kt");
                doTest(fileName);
            }

            @TestMetadata("safeDotExpression.kt")
            public void testSafeDotExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/safeDotExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("withMergedFilter.kt")
            public void testWithMergedFilter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/firstOrNull/withMergedFilter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/flatMap")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FlatMap extends AbstractIntentionTest {
            public void testAllFilesPresentInFlatMap() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/flatMap"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("break.kt")
            public void testBreak() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/break.kt");
                doTest(fileName);
            }

            @TestMetadata("continue.kt")
            public void testContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/continue.kt");
                doTest(fileName);
            }

            @TestMetadata("flatMapTo.kt")
            public void testFlatMapTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo.kt");
                doTest(fileName);
            }

            @TestMetadata("flatMapTo2.kt")
            public void testFlatMapTo2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo2.kt");
                doTest(fileName);
            }

            @TestMetadata("flatMapTo3.kt")
            public void testFlatMapTo3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo3.kt");
                doTest(fileName);
            }

            @TestMetadata("indexUsed.kt")
            public void testIndexUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/indexUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("inputVarStillNeeded.kt")
            public void testInputVarStillNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/inputVarStillNeeded.kt");
                doTest(fileName);
            }

            @TestMetadata("notIterable.kt")
            public void testNotIterable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/notIterable.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongBreak.kt")
            public void testWrongBreak() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/wrongBreak.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongContinue.kt")
            public void testWrongContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/flatMap/wrongContinue.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/forEach")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForEach extends AbstractIntentionTest {
            public void testAllFilesPresentInForEach() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/forEach"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("indexed.kt")
            public void testIndexed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/forEach/indexed.kt");
                doTest(fileName);
            }

            @TestMetadata("indexed_nothingElse.kt")
            public void testIndexed_nothingElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/forEach/indexed_nothingElse.kt");
                doTest(fileName);
            }

            @TestMetadata("KT14341.kt")
            public void testKT14341() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/forEach/KT14341.kt");
                doTest(fileName);
            }

            @TestMetadata("notAvailable.kt")
            public void testNotAvailable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/forEach/notAvailable.kt");
                doTest(fileName);
            }

            @TestMetadata("notIndexed.kt")
            public void testNotIndexed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/forEach/notIndexed.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/forEach/simple.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/indexOf")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IndexOf extends AbstractIntentionTest {
            public void testAllFilesPresentInIndexOf() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/indexOf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("indexOf.kt")
            public void testIndexOf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/indexOf/indexOf.kt");
                doTest(fileName);
            }

            @TestMetadata("indexOfFirst_ifAssign.kt")
            public void testIndexOfFirst_ifAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_ifAssign.kt");
                doTest(fileName);
            }

            @TestMetadata("indexOfFirst_ifReturn.kt")
            public void testIndexOfFirst_ifReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_ifReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("indexOfFirst_mustBeNoIndexInCondition.kt")
            public void testIndexOfFirst_mustBeNoIndexInCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_mustBeNoIndexInCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("indexOfLast_ifAssign.kt")
            public void testIndexOfLast_ifAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/indexOf/indexOfLast_ifAssign.kt");
                doTest(fileName);
            }

            @TestMetadata("KT14303.kt")
            public void testKT14303() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/indexOf/KT14303.kt");
                doTest(fileName);
            }

            @TestMetadata("lastIndexOf.kt")
            public void testLastIndexOf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/indexOf/lastIndexOf.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/introduceIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntroduceIndex extends AbstractIntentionTest {
            public void testAllFilesPresentInIntroduceIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/introduceIndex"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("indexPlusPlusInsideExpression.kt")
            public void testIndexPlusPlusInsideExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("indexPlusPlusInsideExpression_indexUsedAfterIncrement.kt")
            public void testIndexPlusPlusInsideExpression_indexUsedAfterIncrement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedAfterIncrement.kt");
                doTest(fileName);
            }

            @TestMetadata("indexPlusPlusInsideExpression_indexUsedBeforeIncrement.kt")
            public void testIndexPlusPlusInsideExpression_indexUsedBeforeIncrement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedBeforeIncrement.kt");
                doTest(fileName);
            }

            @TestMetadata("indexPlusPlusInsideExpression_indexUsedBeforeIncrement2.kt")
            public void testIndexPlusPlusInsideExpression_indexUsedBeforeIncrement2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedBeforeIncrement2.kt");
                doTest(fileName);
            }

            @TestMetadata("indexPlusPlusIsNotLastStatement.kt")
            public void testIndexPlusPlusIsNotLastStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusIsNotLastStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("indexPlusPlusIsNotLastStatement_indexUsedAfterIncrement.kt")
            public void testIndexPlusPlusIsNotLastStatement_indexUsedAfterIncrement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusIsNotLastStatement_indexUsedAfterIncrement.kt");
                doTest(fileName);
            }

            @TestMetadata("indexWithNestedLoop.kt")
            public void testIndexWithNestedLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/introduceIndex/indexWithNestedLoop.kt");
                doTest(fileName);
            }

            @TestMetadata("prefixIndexPlusPlusInsideExpression.kt")
            public void testPrefixIndexPlusPlusInsideExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/introduceIndex/prefixIndexPlusPlusInsideExpression.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/map")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Map extends AbstractIntentionTest {
            public void testAllFilesPresentInMap() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/map"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignMap.kt")
            public void testAssignMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/assignMap.kt");
                doTest(fileName);
            }

            @TestMetadata("assignMap2.kt")
            public void testAssignMap2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/assignMap2.kt");
                doTest(fileName);
            }

            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/map.kt");
                doTest(fileName);
            }

            @TestMetadata("mapAndFilterIndexed.kt")
            public void testMapAndFilterIndexed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapAndFilterIndexed.kt");
                doTest(fileName);
            }

            @TestMetadata("mapIndexed.kt")
            public void testMapIndexed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapIndexed.kt");
                doTest(fileName);
            }

            @TestMetadata("mapIndexedNotNull.kt")
            public void testMapIndexedNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("mapIndexedNotNullTo.kt")
            public void testMapIndexedNotNullTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNullTo.kt");
                doTest(fileName);
            }

            @TestMetadata("mapIndexedNotNullTo_elvisContinue.kt")
            public void testMapIndexedNotNullTo_elvisContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNullTo_elvisContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("mapIndexedNotNull_elvisContinue.kt")
            public void testMapIndexedNotNull_elvisContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNull_elvisContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("mapIndexedTo.kt")
            public void testMapIndexedTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapIndexedTo.kt");
                doTest(fileName);
            }

            @TestMetadata("mapIndexed_afterFilter.kt")
            public void testMapIndexed_afterFilter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapIndexed_afterFilter.kt");
                doTest(fileName);
            }

            @TestMetadata("mapIndexed_twice.kt")
            public void testMapIndexed_twice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapIndexed_twice.kt");
                doTest(fileName);
            }

            @TestMetadata("mapNotNull.kt")
            public void testMapNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("mapNotNullTo.kt")
            public void testMapNotNullTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapNotNullTo.kt");
                doTest(fileName);
            }

            @TestMetadata("mapNotNullTo_elvisContinue.kt")
            public void testMapNotNullTo_elvisContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapNotNullTo_elvisContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("mapNotNull_elvisContinue.kt")
            public void testMapNotNull_elvisContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapNotNull_elvisContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("mapNotNull_nestedLoopElvisContinue.kt")
            public void testMapNotNull_nestedLoopElvisContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapNotNull_nestedLoopElvisContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("mapNotNull_wrongElvisContinue.kt")
            public void testMapNotNull_wrongElvisContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapNotNull_wrongElvisContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("mapTo.kt")
            public void testMapTo() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapTo.kt");
                doTest(fileName);
            }

            @TestMetadata("mapTo2.kt")
            public void testMapTo2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapTo2.kt");
                doTest(fileName);
            }

            @TestMetadata("mapTo3.kt")
            public void testMapTo3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapTo3.kt");
                doTest(fileName);
            }

            @TestMetadata("mapTo4.kt")
            public void testMapTo4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapTo4.kt");
                doTest(fileName);
            }

            @TestMetadata("mapTo_inputVarNotUsed.kt")
            public void testMapTo_inputVarNotUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapTo_inputVarNotUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("mapUsesOldIndexAfterFilter.kt")
            public void testMapUsesOldIndexAfterFilter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapUsesOldIndexAfterFilter.kt");
                doTest(fileName);
            }

            @TestMetadata("mapVar.kt")
            public void testMapVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/mapVar.kt");
                doTest(fileName);
            }

            @TestMetadata("map_var.kt")
            public void testMap_var() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/map_var.kt");
                doTest(fileName);
            }

            @TestMetadata("map_variableStillNeeded.kt")
            public void testMap_variableStillNeeded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/map/map_variableStillNeeded.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/maxMin")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MaxMin extends AbstractIntentionTest {
            public void testAllFilesPresentInMaxMin() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/maxMin"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("KT14210.kt")
            public void testKT14210() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/KT14210.kt");
                doTest(fileName);
            }

            @TestMetadata("max1.kt")
            public void testMax1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/max1.kt");
                doTest(fileName);
            }

            @TestMetadata("max2.kt")
            public void testMax2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/max2.kt");
                doTest(fileName);
            }

            @TestMetadata("max3.kt")
            public void testMax3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/max3.kt");
                doTest(fileName);
            }

            @TestMetadata("max4.kt")
            public void testMax4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/max4.kt");
                doTest(fileName);
            }

            @TestMetadata("max5.kt")
            public void testMax5() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/max5.kt");
                doTest(fileName);
            }

            @TestMetadata("max6.kt")
            public void testMax6() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/max6.kt");
                doTest(fileName);
            }

            @TestMetadata("max7.kt")
            public void testMax7() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/max7.kt");
                doTest(fileName);
            }

            @TestMetadata("min1.kt")
            public void testMin1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/min1.kt");
                doTest(fileName);
            }

            @TestMetadata("min2.kt")
            public void testMin2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/min2.kt");
                doTest(fileName);
            }

            @TestMetadata("min3.kt")
            public void testMin3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/min3.kt");
                doTest(fileName);
            }

            @TestMetadata("min4.kt")
            public void testMin4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/min4.kt");
                doTest(fileName);
            }

            @TestMetadata("min5.kt")
            public void testMin5() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/maxMin/min5.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/smartCasts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SmartCasts extends AbstractIntentionTest {
            public void testAllFilesPresentInSmartCasts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/smartCasts"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("errorOutsideLoop.kt")
            public void testErrorOutsideLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/errorOutsideLoop.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastNotBroken.kt")
            public void testSmartCastNotBroken() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastNotBroken2.kt")
            public void testSmartCastNotBroken2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken2.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastNotBroken3.kt")
            public void testSmartCastNotBroken3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken3.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastNotBroken4.kt")
            public void testSmartCastNotBroken4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken4.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastNotBroken5.kt")
            public void testSmartCastNotBroken5() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken5.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastNotNullRequired.kt")
            public void testSmartCastNotNullRequired() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotNullRequired.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastNotRequired.kt")
            public void testSmartCastNotRequired() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotRequired.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastRequired.kt")
            public void testSmartCastRequired() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastRequired2.kt")
            public void testSmartCastRequired2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired2.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastRequired3.kt")
            public void testSmartCastRequired3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired3.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastRequired4.kt")
            public void testSmartCastRequired4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired4.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastRequired5.kt")
            public void testSmartCastRequired5() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired5.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastRequired6.kt")
            public void testSmartCastRequired6() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired6.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastThisRequired.kt")
            public void testSmartCastThisRequired() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/smartCasts/smartCastThisRequired.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/sum")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Sum extends AbstractIntentionTest {
            public void testAllFilesPresentInSum() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/sum"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("bytes.kt")
            public void testBytes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/bytes.kt");
                doTest(fileName);
            }

            @TestMetadata("doubles.kt")
            public void testDoubles() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/doubles.kt");
                doTest(fileName);
            }

            @TestMetadata("floats.kt")
            public void testFloats() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/floats.kt");
                doTest(fileName);
            }

            @TestMetadata("floatsIntoDouble.kt")
            public void testFloatsIntoDouble() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/floatsIntoDouble.kt");
                doTest(fileName);
            }

            @TestMetadata("indexUsed.kt")
            public void testIndexUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/indexUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("indexUsed2.kt")
            public void testIndexUsed2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/indexUsed2.kt");
                doTest(fileName);
            }

            @TestMetadata("ints.kt")
            public void testInts() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/ints.kt");
                doTest(fileName);
            }

            @TestMetadata("longs.kt")
            public void testLongs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/longs.kt");
                doTest(fileName);
            }

            @TestMetadata("nonNumbers.kt")
            public void testNonNumbers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/nonNumbers.kt");
                doTest(fileName);
            }

            @TestMetadata("nonZeroInitial.kt")
            public void testNonZeroInitial() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/nonZeroInitial.kt");
                doTest(fileName);
            }

            @TestMetadata("short.kt")
            public void testShort() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/short.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCast.kt")
            public void testSmartCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/smartCast.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastNotNull.kt")
            public void testSmartCastNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/smartCastNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("sumByDouble.kt")
            public void testSumByDouble() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/sumByDouble.kt");
                doTest(fileName);
            }

            @TestMetadata("sumByInts.kt")
            public void testSumByInts() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/sumByInts.kt");
                doTest(fileName);
            }

            @TestMetadata("sumByIntsIntoLong.kt")
            public void testSumByIntsIntoLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/sumByIntsIntoLong.kt");
                doTest(fileName);
            }

            @TestMetadata("sumByShorts.kt")
            public void testSumByShorts() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/sum/sumByShorts.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/takeWhile")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TakeWhile extends AbstractIntentionTest {
            public void testAllFilesPresentInTakeWhile() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/takeWhile"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ifElse1.kt")
            public void testIfElse1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/takeWhile/ifElse1.kt");
                doTest(fileName);
            }

            @TestMetadata("ifElse2.kt")
            public void testIfElse2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/takeWhile/ifElse2.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedLoop.kt")
            public void testNestedLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/takeWhile/nestedLoop.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/takeWhile/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongBreak.kt")
            public void testWrongBreak() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/takeWhile/wrongBreak.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/toCollection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ToCollection extends AbstractIntentionTest {
            @TestMetadata("addAfterLoop.kt")
            public void testAddAfterLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/addAfterLoop.kt");
                doTest(fileName);
            }

            @TestMetadata("addToCollection.kt")
            public void testAddToCollection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/addToCollection.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInToCollection() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/toCollection"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("badReceiver1.kt")
            public void testBadReceiver1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/badReceiver1.kt");
                doTest(fileName);
            }

            @TestMetadata("badReceiver2.kt")
            public void testBadReceiver2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/badReceiver2.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitValType.kt")
            public void testExplicitValType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/explicitValType.kt");
                doTest(fileName);
            }

            @TestMetadata("goodReceiver.kt")
            public void testGoodReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/goodReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("resultCollectionUsedInsideLoop.kt")
            public void testResultCollectionUsedInsideLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/resultCollectionUsedInsideLoop.kt");
                doTest(fileName);
            }

            @TestMetadata("toList.kt")
            public void testToList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/toList.kt");
                doTest(fileName);
            }

            @TestMetadata("toList2.kt")
            public void testToList2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/toList2.kt");
                doTest(fileName);
            }

            @TestMetadata("toList3.kt")
            public void testToList3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/toList3.kt");
                doTest(fileName);
            }

            @TestMetadata("toMutableSet.kt")
            public void testToMutableSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet.kt");
                doTest(fileName);
            }

            @TestMetadata("toMutableSet2.kt")
            public void testToMutableSet2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet2.kt");
                doTest(fileName);
            }

            @TestMetadata("toMutableSet3.kt")
            public void testToMutableSet3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet3.kt");
                doTest(fileName);
            }

            @TestMetadata("toSet.kt")
            public void testToSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/toSet.kt");
                doTest(fileName);
            }

            @TestMetadata("toSetWithMap.kt")
            public void testToSetWithMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/loopToCallChain/toCollection/toSetWithMap.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/moveLambdaInsideParentheses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveLambdaInsideParentheses extends AbstractIntentionTest {
        public void testAllFilesPresentInMoveLambdaInsideParentheses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveLambdaInsideParentheses"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicable1.kt")
        public void testInapplicable1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/inapplicable1.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicable2.kt")
        public void testInapplicable2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/inapplicable2.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLabeledLambda1.kt")
        public void testMoveLabeledLambda1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLabeledLambda1.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLabeledLambda2.kt")
        public void testMoveLabeledLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLabeledLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda1.kt")
        public void testMoveLambda1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda1.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda10.kt")
        public void testMoveLambda10() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda10.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda11.kt")
        public void testMoveLambda11() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda11.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda12.kt")
        public void testMoveLambda12() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda12.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda2.kt")
        public void testMoveLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda3.kt")
        public void testMoveLambda3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda3.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda4.kt")
        public void testMoveLambda4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda4.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda5.kt")
        public void testMoveLambda5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda5.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda6.kt")
        public void testMoveLambda6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda6.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda7.kt")
        public void testMoveLambda7() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda7.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda8.kt")
        public void testMoveLambda8() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda8.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda9.kt")
        public void testMoveLambda9() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda9.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/moveLambdaOutsideParentheses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveLambdaOutsideParentheses extends AbstractIntentionTest {
        public void testAllFilesPresentInMoveLambdaOutsideParentheses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveLambdaOutsideParentheses"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ambigousOverload.kt")
        public void testAmbigousOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/ambigousOverload.kt");
            doTest(fileName);
        }

        @TestMetadata("functionalValueCall.kt")
        public void testFunctionalValueCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/functionalValueCall.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicable1.kt")
        public void testInapplicable1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/inapplicable1.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicable2.kt")
        public void testInapplicable2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/inapplicable2.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicable3.kt")
        public void testInapplicable3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/inapplicable3.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableAlreadyHasFunctionLiteral.kt")
        public void testInapplicableAlreadyHasFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/inapplicableAlreadyHasFunctionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableOptionalParametersAfter.kt")
        public void testInapplicableOptionalParametersAfter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/inapplicableOptionalParametersAfter.kt");
            doTest(fileName);
        }

        @TestMetadata("labeledLambda.kt")
        public void testLabeledLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/labeledLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithCommas.kt")
        public void testLambdaWithCommas() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/lambdaWithCommas.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithCommas2.kt")
        public void testLambdaWithCommas2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/lambdaWithCommas2.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithCommas3.kt")
        public void testLambdaWithCommas3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/lambdaWithCommas3.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda1.kt")
        public void testMoveLambda1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/moveLambda1.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda2.kt")
        public void testMoveLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/moveLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda3.kt")
        public void testMoveLambda3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/moveLambda3.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda4.kt")
        public void testMoveLambda4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/moveLambda4.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda5.kt")
        public void testMoveLambda5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/moveLambda5.kt");
            doTest(fileName);
        }

        @TestMetadata("moveLambda6.kt")
        public void testMoveLambda6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/moveLambda6.kt");
            doTest(fileName);
        }

        @TestMetadata("noTwoConsequentLambdas.kt")
        public void testNoTwoConsequentLambdas() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveLambdaOutsideParentheses/noTwoConsequentLambdas.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/moveOutOfCompanion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveOutOfCompanion extends AbstractIntentionTest {
        public void testAllFilesPresentInMoveOutOfCompanion() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveOutOfCompanion"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("moveAndDropCompanion.kt")
        public void testMoveAndDropCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveOutOfCompanion/moveAndDropCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("moveFunction.kt")
        public void testMoveFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveOutOfCompanion/moveFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("moveFunctionWithExternalRefs.kt")
        public void testMoveFunctionWithExternalRefs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveOutOfCompanion/moveFunctionWithExternalRefs.kt");
            doTest(fileName);
        }

        @TestMetadata("moveProperty.kt")
        public void testMoveProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveOutOfCompanion/moveProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("movePropertyWithExternalRefs.kt")
        public void testMovePropertyWithExternalRefs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveOutOfCompanion/movePropertyWithExternalRefs.kt");
            doTest(fileName);
        }

        @TestMetadata("notCompanion1.kt")
        public void testNotCompanion1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveOutOfCompanion/notCompanion1.kt");
            doTest(fileName);
        }

        @TestMetadata("notCompanion2.kt")
        public void testNotCompanion2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveOutOfCompanion/notCompanion2.kt");
            doTest(fileName);
        }

        @TestMetadata("redeclarationConflict.kt")
        public void testRedeclarationConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveOutOfCompanion/redeclarationConflict.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/moveToCompanion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveToCompanion extends AbstractIntentionTest {
        @TestMetadata("abstractFunction.kt")
        public void testAbstractFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/abstractFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractProperty.kt")
        public void testAbstractProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/abstractProperty.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInMoveToCompanion() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveToCompanion"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doNotQualifyThisLabel.kt")
        public void testDoNotQualifyThisLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/doNotQualifyThisLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("dropFinal.kt")
        public void testDropFinal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/dropFinal.kt");
            doTest(fileName);
        }

        @TestMetadata("dropOpen.kt")
        public void testDropOpen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/dropOpen.kt");
            doTest(fileName);
        }

        @TestMetadata("enumEntry.kt")
        public void testEnumEntry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/enumEntry.kt");
            doTest(fileName);
        }

        @TestMetadata("functionWithOverride.kt")
        public void testFunctionWithOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/functionWithOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("functionWithoutBody.kt")
        public void testFunctionWithoutBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/functionWithoutBody.kt");
            doTest(fileName);
        }

        @TestMetadata("genericFunction.kt")
        public void testGenericFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/genericFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/genericProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitDispatchReceiver.kt")
        public void testImplicitDispatchReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/implicitDispatchReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("inInnerClass.kt")
        public void testInInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/inInnerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inLocalClass.kt")
        public void testInLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/inLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inObject.kt")
        public void testInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/inObject.kt");
            doTest(fileName);
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/localFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("overriddenFunction.kt")
        public void testOverriddenFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/overriddenFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("overriddenProperty.kt")
        public void testOverriddenProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/overriddenProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyUsingClassInstance.kt")
        public void testPropertyUsingClassInstance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/propertyUsingClassInstance.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithOverride.kt")
        public void testPropertyWithOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/propertyWithOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("redeclarationConflict.kt")
        public void testRedeclarationConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/redeclarationConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelFunction.kt")
        public void testTopLevelFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/moveToCompanion/topLevelFunction.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/objectLiteralToLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ObjectLiteralToLambda extends AbstractIntentionTest {
        public void testAllFilesPresentInObjectLiteralToLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/objectLiteralToLambda"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("EmptyBody.kt")
        public void testEmptyBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/EmptyBody.kt");
            doTest(fileName);
        }

        @TestMetadata("ExpressionBody.kt")
        public void testExpressionBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ExpressionBody.kt");
            doTest(fileName);
        }

        @TestMetadata("HasData.kt")
        public void testHasData() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/HasData.kt");
            doTest(fileName);
        }

        @TestMetadata("MultipleBases.kt")
        public void testMultipleBases() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/MultipleBases.kt");
            doTest(fileName);
        }

        @TestMetadata("MultipleParameters.kt")
        public void testMultipleParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/MultipleParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("NoSamAdapterNeeded.kt")
        public void testNoSamAdapterNeeded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/NoSamAdapterNeeded.kt");
            doTest(fileName);
        }

        @TestMetadata("NotInRange1.kt")
        public void testNotInRange1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/NotInRange1.kt");
            doTest(fileName);
        }

        @TestMetadata("NotInRange2.kt")
        public void testNotInRange2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/NotInRange2.kt");
            doTest(fileName);
        }

        @TestMetadata("NotJavaSAM.kt")
        public void testNotJavaSAM() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/NotJavaSAM.kt");
            doTest(fileName);
        }

        @TestMetadata("ParametersNotUsed.kt")
        public void testParametersNotUsed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ParametersNotUsed.kt");
            doTest(fileName);
        }

        @TestMetadata("ParametersNotUsedMoreThanOne.kt")
        public void testParametersNotUsedMoreThanOne() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ParametersNotUsedMoreThanOne.kt");
            doTest(fileName);
        }

        @TestMetadata("QualifiedReturn.kt")
        public void testQualifiedReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/QualifiedReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("Recursive.kt")
        public void testRecursive() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/Recursive.kt");
            doTest(fileName);
        }

        @TestMetadata("ReturnNoValue.kt")
        public void testReturnNoValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ReturnNoValue.kt");
            doTest(fileName);
        }

        @TestMetadata("ReturnNotLast.kt")
        public void testReturnNotLast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ReturnNotLast.kt");
            doTest(fileName);
        }

        @TestMetadata("ReturnsInIf.kt")
        public void testReturnsInIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ReturnsInIf.kt");
            doTest(fileName);
        }

        @TestMetadata("ReturnsInWhen.kt")
        public void testReturnsInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ReturnsInWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("SamAdapterNeededBecauseOfLabeledReturn.kt")
        public void testSamAdapterNeededBecauseOfLabeledReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/SamAdapterNeededBecauseOfLabeledReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("ShortGenericArgument.kt")
        public void testShortGenericArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ShortGenericArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/Simple.kt");
            doTest(fileName);
        }

        @TestMetadata("SingleReturn.kt")
        public void testSingleReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/SingleReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("StatementAndReturn.kt")
        public void testStatementAndReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/StatementAndReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("ThisReference.kt")
        public void testThisReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/ThisReference.kt");
            doTest(fileName);
        }

        @TestMetadata("TwoFunctions.kt")
        public void testTwoFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/objectLiteralToLambda/TwoFunctions.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/intentions/operatorToFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class OperatorToFunction extends AbstractIntentionTest {
        public void testAllFilesPresentInOperatorToFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/operatorToFunction"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayAccessMultipleIndex.kt")
        public void testArrayAccessMultipleIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/arrayAccessMultipleIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayAccessOneIndex.kt")
        public void testArrayAccessOneIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/arrayAccessOneIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayAssignmentMultipleIndex.kt")
        public void testArrayAssignmentMultipleIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/arrayAssignmentMultipleIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/assignment.kt");
            doTest(fileName);
        }

        @TestMetadata("binarayNotEqNullable.kt")
        public void testBinarayNotEqNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binarayNotEqNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryEqEqNonNullable.kt")
        public void testBinaryEqEqNonNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binaryEqEqNonNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryEqEqNullable.kt")
        public void testBinaryEqEqNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binaryEqEqNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryNotEqNonNullable.kt")
        public void testBinaryNotEqNonNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binaryNotEqNonNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryNotIn.kt")
        public void testBinaryNotIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binaryNotIn.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryPlus.kt")
        public void testBinaryPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binaryPlus.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryPlusEquals.kt")
        public void testBinaryPlusEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binaryPlusEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryPlusEqualsNotResolved.kt")
        public void testBinaryPlusEqualsNotResolved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binaryPlusEqualsNotResolved.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryRangeTo.kt")
        public void testBinaryRangeTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/binaryRangeTo.kt");
            doTest(fileName);
        }

        @TestMetadata("compoundAssignment.kt")
        public void testCompoundAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/compoundAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("compoundAssignment2.kt")
        public void testCompoundAssignment2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/compoundAssignment2.kt");
            doTest(fileName);
        }

        @TestMetadata("functionCallMultipleArgument.kt")
        public void testFunctionCallMultipleArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/functionCallMultipleArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("functionCallWithMultipleArgumentsAndSingleLambda.kt")
        public void testFunctionCallWithMultipleArgumentsAndSingleLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/functionCallWithMultipleArgumentsAndSingleLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("functionCallWithSingleLambda.kt")
        public void testFunctionCallWithSingleLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/functionCallWithSingleLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("inRightSideOfAssignment.kt")
        public void testInRightSideOfAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/inRightSideOfAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("keepComments.kt")
        public void testKeepComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/keepComments.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableAssignment.kt")
        public void testNotApplicableAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/notApplicableAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableCallWithInvokeMethod.kt")
        public void testNotApplicableCallWithInvokeMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/notApplicableCallWithInvokeMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableFunctionCallWithCallableReference.kt")
        public void testNotApplicableFunctionCallWithCallableReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/notApplicableFunctionCallWithCallableReference.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableNewClassObject.kt")
        public void testNotApplicableNewClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/notApplicableNewClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("pluPlus.kt")
        public void testPluPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/pluPlus.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixMinusMinus.kt")
        public void testPostfixMinusMinus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/postfixMinusMinus.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixPlus.kt")
        public void testPrefixPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/prefixPlus.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixPlusPlus.kt")
        public void testPrefixPlusPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/operatorToFunction/prefixPlusPlus.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/reconstructTypeInCastOrIs")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReconstructTypeInCastOrIs extends AbstractIntentionTest {
        public void testAllFilesPresentInReconstructTypeInCastOrIs() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/reconstructTypeInCastOrIs"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("completeGenericType.kt")
        public void testCompleteGenericType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/reconstructTypeInCastOrIs/completeGenericType.kt");
            doTest(fileName);
        }

        @TestMetadata("completeType.kt")
        public void testCompleteType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/reconstructTypeInCastOrIs/completeType.kt");
            doTest(fileName);
        }

        @TestMetadata("errorType.kt")
        public void testErrorType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/reconstructTypeInCastOrIs/errorType.kt");
            doTest(fileName);
        }

        @TestMetadata("reconstructableType.kt")
        public void testReconstructableType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/reconstructTypeInCastOrIs/reconstructableType.kt");
            doTest(fileName);
        }

        @TestMetadata("typeInDeclaration.kt")
        public void testTypeInDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/reconstructTypeInCastOrIs/typeInDeclaration.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeArgumentName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveArgumentName extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveArgumentName() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeArgumentName"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("namedArgumentBefore.kt")
        public void testNamedArgumentBefore() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/namedArgumentBefore.kt");
            doTest(fileName);
        }

        @TestMetadata("noExpression.kt")
        public void testNoExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/noExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("notInPosition.kt")
        public void testNotInPosition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/notInPosition.kt");
            doTest(fileName);
        }

        @TestMetadata("notInRange.kt")
        public void testNotInRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/notInRange.kt");
            doTest(fileName);
        }

        @TestMetadata("notNamed.kt")
        public void testNotNamed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/notNamed.kt");
            doTest(fileName);
        }

        @TestMetadata("notResolved.kt")
        public void testNotResolved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/notResolved.kt");
            doTest(fileName);
        }

        @TestMetadata("range.kt")
        public void testRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/range.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("star.kt")
        public void testStar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/star.kt");
            doTest(fileName);
        }

        @TestMetadata("superClassConstructor.kt")
        public void testSuperClassConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeArgumentName/superClassConstructor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeAtFromAnnotationArgument")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveAtFromAnnotationArgument extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveAtFromAnnotationArgument() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeAtFromAnnotationArgument"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("atmarkArgument.kt")
        public void testAtmarkArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeAtFromAnnotationArgument/atmarkArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("atmarkArrayArguments.kt")
        public void testAtmarkArrayArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeAtFromAnnotationArgument/atmarkArrayArguments.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleAtmarkArguments.kt")
        public void testMultipleAtmarkArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeAtFromAnnotationArgument/multipleAtmarkArguments.kt");
            doTest(fileName);
        }

        @TestMetadata("stringAtmark.kt")
        public void testStringAtmark() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeAtFromAnnotationArgument/stringAtmark.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeBraces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveBraces extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveBraces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeBraces"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/doWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhileWithTwoStatements.kt")
        public void testDoWhileWithTwoStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/doWhileWithTwoStatements.kt");
            doTest(fileName);
        }

        @TestMetadata("else.kt")
        public void testElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/else.kt");
            doTest(fileName);
        }

        @TestMetadata("for.kt")
        public void testFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/for.kt");
            doTest(fileName);
        }

        @TestMetadata("forWithLocalVariable.kt")
        public void testForWithLocalVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/forWithLocalVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("if.kt")
        public void testIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/if.kt");
            doTest(fileName);
        }

        @TestMetadata("ifInsideIf.kt")
        public void testIfInsideIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/ifInsideIf.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWithComment.kt")
        public void testIfWithComment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/ifWithComment.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWithNoStatement.kt")
        public void testIfWithNoStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/ifWithNoStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWithSemicolon.kt")
        public void testIfWithSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/ifWithSemicolon.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWithTwoStatements.kt")
        public void testIfWithTwoStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/ifWithTwoStatements.kt");
            doTest(fileName);
        }

        @TestMetadata("removeBracesFromIfWithCommentedCode.kt")
        public void testRemoveBracesFromIfWithCommentedCode() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/removeBracesFromIfWithCommentedCode.kt");
            doTest(fileName);
        }

        @TestMetadata("whenLambda.kt")
        public void testWhenLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/whenLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("whenMultiple.kt")
        public void testWhenMultiple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/whenMultiple.kt");
            doTest(fileName);
        }

        @TestMetadata("whenNoBraces.kt")
        public void testWhenNoBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/whenNoBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("whenSimple.kt")
        public void testWhenSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/whenSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("whenSimpleOutsideBlock.kt")
        public void testWhenSimpleOutsideBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/whenSimpleOutsideBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("whenStatement.kt")
        public void testWhenStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/whenStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("while.kt")
        public void testWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/while.kt");
            doTest(fileName);
        }

        @TestMetadata("whileOutsideBlock.kt")
        public void testWhileOutsideBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/whileOutsideBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("whileWithTwoStatements.kt")
        public void testWhileWithTwoStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeBraces/whileWithTwoStatements.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveCurlyBracesFromTemplate extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveCurlyBracesFromTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeCurlyBracesFromTemplate"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("necessaryBrackets1.kt")
        public void testNecessaryBrackets1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets1.kt");
            doTest(fileName);
        }

        @TestMetadata("necessaryBrackets2.kt")
        public void testNecessaryBrackets2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets2.kt");
            doTest(fileName);
        }

        @TestMetadata("necessaryBrackets3.kt")
        public void testNecessaryBrackets3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets3.kt");
            doTest(fileName);
        }

        @TestMetadata("necessaryBrackets4.kt")
        public void testNecessaryBrackets4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets4.kt");
            doTest(fileName);
        }

        @TestMetadata("necessaryBrackets5.kt")
        public void testNecessaryBrackets5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets5.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryBrackets1.kt")
        public void testUnnecessaryBrackets1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets1.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryBrackets2.kt")
        public void testUnnecessaryBrackets2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets2.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryBrackets3.kt")
        public void testUnnecessaryBrackets3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets3.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryBrackets4.kt")
        public void testUnnecessaryBrackets4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets4.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryBrackets5.kt")
        public void testUnnecessaryBrackets5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets5.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryBrackets6.kt")
        public void testUnnecessaryBrackets6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets6.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeEmptyClassBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveEmptyClassBody extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveEmptyClassBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeEmptyClassBody"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousInterfaceObject.kt")
        public void testAnonymousInterfaceObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/anonymousInterfaceObject.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObject.kt")
        public void testAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/anonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyClass.kt")
        public void testEmptyClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/emptyClass.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyDataClass.kt")
        public void testEmptyDataClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/emptyDataClass.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyInterface.kt")
        public void testEmptyInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/emptyInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/innerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedAnonymous.kt")
        public void testNestedAnonymous() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/nestedAnonymous.kt");
            doTest(fileName);
        }

        @TestMetadata("noneEmptyClass.kt")
        public void testNoneEmptyClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/noneEmptyClass.kt");
            doTest(fileName);
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyClassBody/object.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveEmptyParenthesesFromLambdaCall extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveEmptyParenthesesFromLambdaCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeEmptyPrimaryConstructor")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveEmptyPrimaryConstructor extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveEmptyPrimaryConstructor() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeEmptyPrimaryConstructor"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotation.kt")
        public void testAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyPrimaryConstructor/annotation.kt");
            doTest(fileName);
        }

        @TestMetadata("keyword.kt")
        public void testKeyword() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyPrimaryConstructor/keyword.kt");
            doTest(fileName);
        }

        @TestMetadata("modifier.kt")
        public void testModifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyPrimaryConstructor/modifier.kt");
            doTest(fileName);
        }

        @TestMetadata("secondary.kt")
        public void testSecondary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyPrimaryConstructor/secondary.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptyPrimaryConstructor/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeEmptySecondaryConstructorBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveEmptySecondaryConstructorBody extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveEmptySecondaryConstructorBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeEmptySecondaryConstructorBody"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("comment.kt")
        public void testComment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptySecondaryConstructorBody/comment.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeEmptySecondaryConstructorBody/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeExplicitLambdaParameterTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExplicitLambdaParameterTypes extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveExplicitLambdaParameterTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitLambdaParameterTypes"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("invalidCursorPosition.kt")
        public void testInvalidCursorPosition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitLambdaParameterTypes/invalidCursorPosition.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithLambdaAsParam.kt")
        public void testLambdaWithLambdaAsParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitLambdaParameterTypes/lambdaWithLambdaAsParam.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleExplicitParams.kt")
        public void testMultipleExplicitParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitLambdaParameterTypes/multipleExplicitParams.kt");
            doTest(fileName);
        }

        @TestMetadata("paramTypeDeclared.kt")
        public void testParamTypeDeclared() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitLambdaParameterTypes/paramTypeDeclared.kt");
            doTest(fileName);
        }

        @TestMetadata("singleExplicitParam.kt")
        public void testSingleExplicitParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitLambdaParameterTypes/singleExplicitParam.kt");
            doTest(fileName);
        }

        @TestMetadata("typesAlreadyImplicit.kt")
        public void testTypesAlreadyImplicit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitLambdaParameterTypes/typesAlreadyImplicit.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeExplicitSuperQualifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExplicitSuperQualifier extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveExplicitSuperQualifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitSuperQualifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AmbiguousSuperMethod.kt")
        public void testAmbiguousSuperMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/AmbiguousSuperMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("AmbiguousSuperProperty.kt")
        public void testAmbiguousSuperProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/AmbiguousSuperProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("DataFlowInfoUsed.kt")
        public void testDataFlowInfoUsed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/DataFlowInfoUsed.kt");
            doTest(fileName);
        }

        @TestMetadata("IncompleteCall.kt")
        public void testIncompleteCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/IncompleteCall.kt");
            doTest(fileName);
        }

        @TestMetadata("IncompleteCallAmbiguous.kt")
        public void testIncompleteCallAmbiguous() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/IncompleteCallAmbiguous.kt");
            doTest(fileName);
        }

        @TestMetadata("SingleSuper.kt")
        public void testSingleSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/SingleSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("SuperWithLabel.kt")
        public void testSuperWithLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/SuperWithLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("UnambiguousSuperMethod.kt")
        public void testUnambiguousSuperMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/UnambiguousSuperMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("UnambiguousSuperProperty.kt")
        public void testUnambiguousSuperProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/UnambiguousSuperProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("WrongOffset1.kt")
        public void testWrongOffset1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/WrongOffset1.kt");
            doTest(fileName);
        }

        @TestMetadata("WrongOffset2.kt")
        public void testWrongOffset2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitSuperQualifier/WrongOffset2.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/intentions/removeExplicitType")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExplicitType extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveExplicitType() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitType"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notOnParameterOfFunctionType.kt")
        public void testNotOnParameterOfFunctionType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitType/notOnParameterOfFunctionType.kt");
            doTest(fileName);
        }

        @TestMetadata("onOverride.kt")
        public void testOnOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitType/onOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("onOverrideInTrait.kt")
        public void testOnOverrideInTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitType/onOverrideInTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("onSetterParameter.kt")
        public void testOnSetterParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitType/onSetterParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("onType.kt")
        public void testOnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitType/onType.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyTypeFromGetter.kt")
        public void testPropertyTypeFromGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitType/propertyTypeFromGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("removeUnresolvedType.kt")
        public void testRemoveUnresolvedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitType/removeUnresolvedType.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeExplicitTypeArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExplicitTypeArguments extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveExplicitTypeArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitTypeArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fourLiterals.kt")
        public void testFourLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/fourLiterals.kt");
            doTest(fileName);
        }

        @TestMetadata("functionBodyIsCallWithUnnecessaryTypeArgs.kt")
        public void testFunctionBodyIsCallWithUnnecessaryTypeArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/functionBodyIsCallWithUnnecessaryTypeArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableTypeThatIsAFunItCannotBeInferred.kt")
        public void testInapplicableTypeThatIsAFunItCannotBeInferred() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/inapplicableTypeThatIsAFunItCannotBeInferred.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaType.kt")
        public void testLambdaType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/lambdaType.kt");
            doTest(fileName);
        }

        @TestMetadata("literalAny.kt")
        public void testLiteralAny() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/literalAny.kt");
            doTest(fileName);
        }

        @TestMetadata("literalString.kt")
        public void testLiteralString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/literalString.kt");
            doTest(fileName);
        }

        @TestMetadata("literalStringWithClass.kt")
        public void testLiteralStringWithClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/literalStringWithClass.kt");
            doTest(fileName);
        }

        @TestMetadata("literalsWhenTypeArgHasTypeArg.kt")
        public void testLiteralsWhenTypeArgHasTypeArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/literalsWhenTypeArgHasTypeArg.kt");
            doTest(fileName);
        }

        @TestMetadata("mapGet.kt")
        public void testMapGet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/mapGet.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedCall-KT-5028.kt")
        public void testNestedCall_KT_5028() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/nestedCall-KT-5028.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableNotEnoughtInfo.kt")
        public void testNotApplicableNotEnoughtInfo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/notApplicableNotEnoughtInfo.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableSupertypeOfInferred.kt")
        public void testNotApplicableSupertypeOfInferred() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/notApplicableSupertypeOfInferred.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicableSupertypeOfInferredClass.kt")
        public void testNotApplicableSupertypeOfInferredClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/notApplicableSupertypeOfInferredClass.kt");
            doTest(fileName);
        }

        @TestMetadata("platforrmType1.kt")
        public void testPlatforrmType1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/platforrmType1.kt");
            doTest(fileName);
        }

        @TestMetadata("platforrmType2.kt")
        public void testPlatforrmType2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/platforrmType2.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyInitializerIsCallWithUnnecessaryTypeArgs.kt")
        public void testPropertyInitializerIsCallWithUnnecessaryTypeArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/propertyInitializerIsCallWithUnnecessaryTypeArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("returnCallWithUnnecessaryTypeArgs.kt")
        public void testReturnCallWithUnnecessaryTypeArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/returnCallWithUnnecessaryTypeArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("twoLiteralValues.kt")
        public void testTwoLiteralValues() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/twoLiteralValues.kt");
            doTest(fileName);
        }

        @TestMetadata("variableString.kt")
        public void testVariableString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/variableString.kt");
            doTest(fileName);
        }

        @TestMetadata("variableString2.kt")
        public void testVariableString2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/variableString2.kt");
            doTest(fileName);
        }

        @TestMetadata("variableStringFartherScope.kt")
        public void testVariableStringFartherScope() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/variableStringFartherScope.kt");
            doTest(fileName);
        }

        @TestMetadata("variablesAndLiterals.kt")
        public void testVariablesAndLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeExplicitTypeArguments/variablesAndLiterals.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/intentions/removeForLoopIndices")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveForLoopIndices extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveForLoopIndices() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeForLoopIndices"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicableForLoop.kt")
        public void testInapplicableForLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeForLoopIndices/inapplicableForLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableIndexUse.kt")
        public void testInapplicableIndexUse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeForLoopIndices/inapplicableIndexUse.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableOverridenFunction.kt")
        public void testInapplicableOverridenFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeForLoopIndices/inapplicableOverridenFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("loopWithType.kt")
        public void testLoopWithType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeForLoopIndices/loopWithType.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleLoopWithIndices.kt")
        public void testSimpleLoopWithIndices() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeForLoopIndices/simpleLoopWithIndices.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleLoopWithIndicesOverCharSequence.kt")
        public void testSimpleLoopWithIndicesOverCharSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeForLoopIndices/simpleLoopWithIndicesOverCharSequence.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleLoopWithIndicesOverSequence.kt")
        public void testSimpleLoopWithIndicesOverSequence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeForLoopIndices/simpleLoopWithIndicesOverSequence.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveRedundantCallsOfConversionMethods extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveRedundantCallsOfConversionMethods() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeRedundantCallsOfConversionMethods"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("byte.kt")
        public void testByte() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/byte.kt");
            doTest(fileName);
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/char.kt");
            doTest(fileName);
        }

        @TestMetadata("double.kt")
        public void testDouble() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/double.kt");
            doTest(fileName);
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/float.kt");
            doTest(fileName);
        }

        @TestMetadata("int.kt")
        public void testInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/int.kt");
            doTest(fileName);
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/list.kt");
            doTest(fileName);
        }

        @TestMetadata("list2.kt")
        public void testList2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/list2.kt");
            doTest(fileName);
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/long.kt");
            doTest(fileName);
        }

        @TestMetadata("mutableList.kt")
        public void testMutableList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/mutableList.kt");
            doTest(fileName);
        }

        @TestMetadata("mutableSet.kt")
        public void testMutableSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/mutableSet.kt");
            doTest(fileName);
        }

        @TestMetadata("platformTypes.kt")
        public void testPlatformTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/platformTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("safeSortedMap.kt")
        public void testSafeSortedMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/safeSortedMap.kt");
            doTest(fileName);
        }

        @TestMetadata("safeString.kt")
        public void testSafeString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/safeString.kt");
            doTest(fileName);
        }

        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/set.kt");
            doTest(fileName);
        }

        @TestMetadata("short.kt")
        public void testShort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/short.kt");
            doTest(fileName);
        }

        @TestMetadata("sortedMap.kt")
        public void testSortedMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/sortedMap.kt");
            doTest(fileName);
        }

        @TestMetadata("sortedSet.kt")
        public void testSortedSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/sortedSet.kt");
            doTest(fileName);
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/string.kt");
            doTest(fileName);
        }

        @TestMetadata("toOtherType.kt")
        public void testToOtherType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/toOtherType.kt");
            doTest(fileName);
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods/variable.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveSingleExpressionStringTemplate extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveSingleExpressionStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeSingleExpressionStringTemplate"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("emptyString.kt")
        public void testEmptyString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate/emptyString.kt");
            doTest(fileName);
        }

        @TestMetadata("justString.kt")
        public void testJustString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate/justString.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleStringTemplate.kt")
        public void testMultipleStringTemplate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate/multipleStringTemplate.kt");
            doTest(fileName);
        }

        @TestMetadata("singleExpressionStringTemplate.kt")
        public void testSingleExpressionStringTemplate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate/singleExpressionStringTemplate.kt");
            doTest(fileName);
        }

        @TestMetadata("singleExpressionStringTemplateWithMethodCall.kt")
        public void testSingleExpressionStringTemplateWithMethodCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate/singleExpressionStringTemplateWithMethodCall.kt");
            doTest(fileName);
        }

        @TestMetadata("singleExpressionStringTemplateWithNonStringType.kt")
        public void testSingleExpressionStringTemplateWithNonStringType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate/singleExpressionStringTemplateWithNonStringType.kt");
            doTest(fileName);
        }

        @TestMetadata("stringTemplateWithText.kt")
        public void testStringTemplateWithText() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate/stringTemplateWithText.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/removeUnnecessaryParentheses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveUnnecessaryParentheses extends AbstractIntentionTest {
        public void testAllFilesPresentInRemoveUnnecessaryParentheses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeUnnecessaryParentheses"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("necessaryParentheses1.kt")
        public void testNecessaryParentheses1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses1.kt");
            doTest(fileName);
        }

        @TestMetadata("necessaryParentheses2.kt")
        public void testNecessaryParentheses2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses2.kt");
            doTest(fileName);
        }

        @TestMetadata("necessaryParentheses3.kt")
        public void testNecessaryParentheses3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses3.kt");
            doTest(fileName);
        }

        @TestMetadata("necessaryParentheses4.kt")
        public void testNecessaryParentheses4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses4.kt");
            doTest(fileName);
        }

        @TestMetadata("necessaryParentheses5.kt")
        public void testNecessaryParentheses5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses5.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryParentheses1.kt")
        public void testUnnecessaryParentheses1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses1.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryParentheses2.kt")
        public void testUnnecessaryParentheses2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses2.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryParentheses3.kt")
        public void testUnnecessaryParentheses3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses3.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryParentheses4.kt")
        public void testUnnecessaryParentheses4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses4.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryParentheses5.kt")
        public void testUnnecessaryParentheses5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses5.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryParentheses6.kt")
        public void testUnnecessaryParentheses6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses6.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryParentheses7.kt")
        public void testUnnecessaryParentheses7() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses7.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryParentheses8.kt")
        public void testUnnecessaryParentheses8() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses8.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceArrayEqualityOpWithArraysEquals")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceArrayEqualityOpWithArraysEquals extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceArrayEqualityOpWithArraysEquals() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceArrayEqualityOpWithArraysEquals"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayAndOtherTypeEQEQ.kt")
        public void testArrayAndOtherTypeEQEQ() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceArrayEqualityOpWithArraysEquals/arrayAndOtherTypeEQEQ.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayEQEQ.kt")
        public void testArrayEQEQ() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceArrayEqualityOpWithArraysEquals/arrayEQEQ.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveArrayEQEQ.kt")
        public void testPrimitiveArrayEQEQ() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceArrayEqualityOpWithArraysEquals/primitiveArrayEQEQ.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceExplicitFunctionLiteralParamWithIt extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceExplicitFunctionLiteralParamWithIt() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("applicable_cursofOverParamInInnerLiteral.kt")
        public void testApplicable_cursofOverParamInInnerLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_cursofOverParamInInnerLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("applicable_cursorOverParameterDeclaration.kt")
        public void testApplicable_cursorOverParameterDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_cursorOverParameterDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("applicable_cursorOverParameterUse.kt")
        public void testApplicable_cursorOverParameterUse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_cursorOverParameterUse.kt");
            doTest(fileName);
        }

        @TestMetadata("applicable_formatsProperly.kt")
        public void testApplicable_formatsProperly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_formatsProperly.kt");
            doTest(fileName);
        }

        @TestMetadata("applicable_nestedLiteralsNoUseInside.kt")
        public void testApplicable_nestedLiteralsNoUseInside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_nestedLiteralsNoUseInside.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_alreadyUsesImplicitIt.kt")
        public void testNotApplicable_alreadyUsesImplicitIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_alreadyUsesImplicitIt.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_hasMultipleParameters.kt")
        public void testNotApplicable_hasMultipleParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_hasMultipleParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_itFromOuterLambda.kt")
        public void testNotApplicable_itFromOuterLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_itFromOuterLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_nestedLiterals.kt")
        public void testNotApplicable_nestedLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_nestedLiterals.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_nestedLiteralsNoIt.kt")
        public void testNotApplicable_nestedLiteralsNoIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_nestedLiteralsNoIt.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_notFunctionLiteralParameter.kt")
        public void testNotApplicable_notFunctionLiteralParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_notFunctionLiteralParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_parameterHasExplicitType.kt")
        public void testNotApplicable_parameterHasExplicitType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_parameterHasExplicitType.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_wrongPosition.kt")
        public void testNotApplicable_wrongPosition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_wrongPosition.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceItWithExplicitFunctionLiteralParam extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceItWithExplicitFunctionLiteralParam() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("applicable.kt")
        public void testApplicable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/applicable.kt");
            doTest(fileName);
        }

        @TestMetadata("applicable_nestedFunctionLiterals.kt")
        public void testApplicable_nestedFunctionLiterals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/applicable_nestedFunctionLiterals.kt");
            doTest(fileName);
        }

        @TestMetadata("applicable_nestedFunctionWithIt.kt")
        public void testApplicable_nestedFunctionWithIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/applicable_nestedFunctionWithIt.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_localVariableIt.kt")
        public void testNotApplicable_localVariableIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/notApplicable_localVariableIt.kt");
            doTest(fileName);
        }

        @TestMetadata("notApplicable_parameterExplicitlyNamedIt.kt")
        public void testNotApplicable_parameterExplicitlyNamedIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/notApplicable_parameterExplicitlyNamedIt.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceMathMaxWithCoerceAtLeast extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceMathMaxWithCoerceAtLeast() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("customMaxMethod.kt")
        public void testCustomMaxMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/customMaxMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("doubles.kt")
        public void testDoubles() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/doubles.kt");
            doTest(fileName);
        }

        @TestMetadata("moreThan2ValueArg.kt")
        public void testMoreThan2ValueArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/moreThan2ValueArg.kt");
            doTest(fileName);
        }

        @TestMetadata("noImport.kt")
        public void testNoImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/noImport.kt");
            doTest(fileName);
        }

        @TestMetadata("oneValueArg.kt")
        public void testOneValueArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/oneValueArg.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceMathMinWithCoerceAtMost")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceMathMinWithCoerceAtMost extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceMathMinWithCoerceAtMost() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceMathMinWithCoerceAtMost"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("customMinMethod.kt")
        public void testCustomMinMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMinWithCoerceAtMost/customMinMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("doubles.kt")
        public void testDoubles() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMinWithCoerceAtMost/doubles.kt");
            doTest(fileName);
        }

        @TestMetadata("moreThan2ValueArg.kt")
        public void testMoreThan2ValueArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMinWithCoerceAtMost/moreThan2ValueArg.kt");
            doTest(fileName);
        }

        @TestMetadata("noImport.kt")
        public void testNoImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMinWithCoerceAtMost/noImport.kt");
            doTest(fileName);
        }

        @TestMetadata("oneValueArg.kt")
        public void testOneValueArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMinWithCoerceAtMost/oneValueArg.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceMathMinWithCoerceAtMost/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceRangeToWithUntil")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceRangeToWithUntil extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceRangeToWithUntil() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceRangeToWithUntil"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("closedRange.kt")
        public void testClosedRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceRangeToWithUntil/closedRange.kt");
            doTest(fileName);
        }

        @TestMetadata("minusTwo.kt")
        public void testMinusTwo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceRangeToWithUntil/minusTwo.kt");
            doTest(fileName);
        }

        @TestMetadata("notMinusOne.kt")
        public void testNotMinusOne() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceRangeToWithUntil/notMinusOne.kt");
            doTest(fileName);
        }

        @TestMetadata("operator.kt")
        public void testOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceRangeToWithUntil/operator.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorLong.kt")
        public void testOperatorLong() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceRangeToWithUntil/operatorLong.kt");
            doTest(fileName);
        }

        @TestMetadata("plusOne.kt")
        public void testPlusOne() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceRangeToWithUntil/plusOne.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeTo.kt")
        public void testRangeTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceRangeToWithUntil/rangeTo.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSingleLineLetIntention")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSingleLineLetIntention extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceSingleLineLetIntention() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSingleLineLetIntention"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/assignment.kt");
            doTest(fileName);
        }

        @TestMetadata("comparisons.kt")
        public void testComparisons() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/comparisons.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithBinaryExpression.kt")
        public void testLambdaWithBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/lambdaWithBinaryExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithBinaryExpression2.kt")
        public void testLambdaWithBinaryExpression2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/lambdaWithBinaryExpression2.kt");
            doTest(fileName);
        }

        @TestMetadata("let.kt")
        public void testLet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/let.kt");
            doTest(fileName);
        }

        @TestMetadata("letMultipleLines.kt")
        public void testLetMultipleLines() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letMultipleLines.kt");
            doTest(fileName);
        }

        @TestMetadata("letNoSafeCall.kt")
        public void testLetNoSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letNoSafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("letNotUseParameterReceiver.kt")
        public void testLetNotUseParameterReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letNotUseParameterReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("letNotUseReceiver.kt")
        public void testLetNotUseReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letNotUseReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("letUseIt.kt")
        public void testLetUseIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letUseIt.kt");
            doTest(fileName);
        }

        @TestMetadata("letUseItAsParamWithBinaryExpression.kt")
        public void testLetUseItAsParamWithBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letUseItAsParamWithBinaryExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("letUseItWithBinaryExpression.kt")
        public void testLetUseItWithBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithBinaryExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("letUseItWithBinaryExpression2.kt")
        public void testLetUseItWithBinaryExpression2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithBinaryExpression2.kt");
            doTest(fileName);
        }

        @TestMetadata("letUseItWithMultipleMethodCall1.kt")
        public void testLetUseItWithMultipleMethodCall1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithMultipleMethodCall1.kt");
            doTest(fileName);
        }

        @TestMetadata("letUseItWithMultipleMethodCall2.kt")
        public void testLetUseItWithMultipleMethodCall2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithMultipleMethodCall2.kt");
            doTest(fileName);
        }

        @TestMetadata("letUseItWithMultipleMethodCall3.kt")
        public void testLetUseItWithMultipleMethodCall3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithMultipleMethodCall3.kt");
            doTest(fileName);
        }

        @TestMetadata("letUseParameter.kt")
        public void testLetUseParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letUseParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("letWithBinaryExpression.kt")
        public void testLetWithBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letWithBinaryExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("letWithMethodCall.kt")
        public void testLetWithMethodCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letWithMethodCall.kt");
            doTest(fileName);
        }

        @TestMetadata("letWithMultipleMethodCall.kt")
        public void testLetWithMultipleMethodCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letWithMultipleMethodCall.kt");
            doTest(fileName);
        }

        @TestMetadata("letWithParameter.kt")
        public void testLetWithParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letWithParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("letWithSimpleBinaryExpression.kt")
        public void testLetWithSimpleBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letWithSimpleBinaryExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("letWithThisBinaryExpression.kt")
        public void testLetWithThisBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letWithThisBinaryExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("letWithThisShortBinaryExpression.kt")
        public void testLetWithThisShortBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/letWithThisShortBinaryExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleReceiver.kt")
        public void testMultipleReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/multipleReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleReceiver2.kt")
        public void testMultipleReceiver2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/multipleReceiver2.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleReceiver3.kt")
        public void testMultipleReceiver3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/multipleReceiver3.kt");
            doTest(fileName);
        }

        @TestMetadata("plusNullable.kt")
        public void testPlusNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/plusNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("receiverWithLambda.kt")
        public void testReceiverWithLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/receiverWithLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("receiverWithLambda2.kt")
        public void testReceiverWithLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/receiverWithLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("sameLets.kt")
        public void testSameLets() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/sameLets.kt");
            doTest(fileName);
        }

        @TestMetadata("smartCastInBody.kt")
        public void testSmartCastInBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/smartCastInBody.kt");
            doTest(fileName);
        }

        @TestMetadata("this.kt")
        public void testThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/this.kt");
            doTest(fileName);
        }

        @TestMetadata("thisShort.kt")
        public void testThisShort() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/thisShort.kt");
            doTest(fileName);
        }

        @TestMetadata("typeChecks.kt")
        public void testTypeChecks() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSingleLineLetIntention/typeChecks.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSizeCheckWithIsNotEmpty extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceSizeCheckWithIsNotEmpty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/array.kt");
            doTest(fileName);
        }

        @TestMetadata("array2.kt")
        public void testArray2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/array2.kt");
            doTest(fileName);
        }

        @TestMetadata("collection.kt")
        public void testCollection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/collection.kt");
            doTest(fileName);
        }

        @TestMetadata("gt.kt")
        public void testGt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/gt.kt");
            doTest(fileName);
        }

        @TestMetadata("gteq.kt")
        public void testGteq() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/gteq.kt");
            doTest(fileName);
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/list.kt");
            doTest(fileName);
        }

        @TestMetadata("list2.kt")
        public void testList2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/list2.kt");
            doTest(fileName);
        }

        @TestMetadata("lt.kt")
        public void testLt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/lt.kt");
            doTest(fileName);
        }

        @TestMetadata("lteq.kt")
        public void testLteq() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/lteq.kt");
            doTest(fileName);
        }

        @TestMetadata("map.kt")
        public void testMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/map.kt");
            doTest(fileName);
        }

        @TestMetadata("oppositeSign.kt")
        public void testOppositeSign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/oppositeSign.kt");
            doTest(fileName);
        }

        @TestMetadata("oppositeSign2.kt")
        public void testOppositeSign2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/oppositeSign2.kt");
            doTest(fileName);
        }

        @TestMetadata("primitiveArray.kt")
        public void testPrimitiveArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/primitiveArray.kt");
            doTest(fileName);
        }

        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/set.kt");
            doTest(fileName);
        }

        @TestMetadata("sizeCheck.kt")
        public void testSizeCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/sizeCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/string.kt");
            doTest(fileName);
        }

        @TestMetadata("string2.kt")
        public void testString2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/string2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSizeZeroCheckWithIsEmpty extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceSizeZeroCheckWithIsEmpty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/array.kt");
            doTest(fileName);
        }

        @TestMetadata("array2.kt")
        public void testArray2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/array2.kt");
            doTest(fileName);
        }

        @TestMetadata("gt.kt")
        public void testGt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/gt.kt");
            doTest(fileName);
        }

        @TestMetadata("gteq.kt")
        public void testGteq() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/gteq.kt");
            doTest(fileName);
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/list.kt");
            doTest(fileName);
        }

        @TestMetadata("list2.kt")
        public void testList2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/list2.kt");
            doTest(fileName);
        }

        @TestMetadata("lt.kt")
        public void testLt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/lt.kt");
            doTest(fileName);
        }

        @TestMetadata("lteq.kt")
        public void testLteq() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/lteq.kt");
            doTest(fileName);
        }

        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/set.kt");
            doTest(fileName);
        }

        @TestMetadata("sizeCheck.kt")
        public void testSizeCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/sizeCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/string.kt");
            doTest(fileName);
        }

        @TestMetadata("string2.kt")
        public void testString2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/string2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithDropLast")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithDropLast extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceSubstringWithDropLast() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithDropLast"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("immutableProperty.kt")
        public void testImmutableProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithDropLast/immutableProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("methodCallReceiver.kt")
        public void testMethodCallReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithDropLast/methodCallReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("nonZeroFirstArgument.kt")
        public void testNonZeroFirstArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithDropLast/nonZeroFirstArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceWithDropLast.kt")
        public void testReplaceWithDropLast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithDropLast/replaceWithDropLast.kt");
            doTest(fileName);
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithDropLast/semicolon.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithSubstringAfter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithSubstringAfter extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceSubstringWithSubstringAfter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithSubstringAfter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("immutableProperty.kt")
        public void testImmutableProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringAfter/immutableProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("methodCallReceiver.kt")
        public void testMethodCallReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringAfter/methodCallReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceWithSubstringAfter.kt")
        public void testReplaceWithSubstringAfter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringAfter/replaceWithSubstringAfter.kt");
            doTest(fileName);
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringAfter/semicolon.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithSubstringBefore")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithSubstringBefore extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceSubstringWithSubstringBefore() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithSubstringBefore"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("immutableProperty.kt")
        public void testImmutableProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringBefore/immutableProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("methodCallReceiver.kt")
        public void testMethodCallReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringBefore/methodCallReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("nonZeroFirstArgument.kt")
        public void testNonZeroFirstArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringBefore/nonZeroFirstArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceWithSubstringBefore.kt")
        public void testReplaceWithSubstringBefore() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringBefore/replaceWithSubstringBefore.kt");
            doTest(fileName);
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithSubstringBefore/semicolon.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithTake")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithTake extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceSubstringWithTake() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithTake"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constantAsFirstArgument.kt")
        public void testConstantAsFirstArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithTake/constantAsFirstArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionAsFirstArgument.kt")
        public void testExpressionAsFirstArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithTake/expressionAsFirstArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("nonZeroFirstArgument.kt")
        public void testNonZeroFirstArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithTake/nonZeroFirstArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceWithTake.kt")
        public void testReplaceWithTake() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithTake/replaceWithTake.kt");
            doTest(fileName);
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceSubstringWithTake/semicolon.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceUntilWithRangeTo")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceUntilWithRangeTo extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceUntilWithRangeTo() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceUntilWithRangeTo"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceUntilWithRangeTo/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceWithOperatorAssignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceWithOperatorAssignment extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceWithOperatorAssignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceWithOperatorAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("flexibleTypeBug.kt")
        public void testFlexibleTypeBug() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/flexibleTypeBug.kt");
            doTest(fileName);
        }

        @TestMetadata("illegalMultipleOperators.kt")
        public void testIllegalMultipleOperators() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/illegalMultipleOperators.kt");
            doTest(fileName);
        }

        @TestMetadata("illegalMultipleOperatorsMiddle.kt")
        public void testIllegalMultipleOperatorsMiddle() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/illegalMultipleOperatorsMiddle.kt");
            doTest(fileName);
        }

        @TestMetadata("invalidSubtraction.kt")
        public void testInvalidSubtraction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/invalidSubtraction.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperators.kt")
        public void testMultipleOperators() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/multipleOperators.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperatorsRightSideRepeat.kt")
        public void testMultipleOperatorsRightSideRepeat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/multipleOperatorsRightSideRepeat.kt");
            doTest(fileName);
        }

        @TestMetadata("nonCommutativeRepeat.kt")
        public void testNonCommutativeRepeat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/nonCommutativeRepeat.kt");
            doTest(fileName);
        }

        @TestMetadata("nonRepeatingAssignment.kt")
        public void testNonRepeatingAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/nonRepeatingAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("plusAssignConflict.kt")
        public void testPlusAssignConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/plusAssignConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("rightSideRepeat.kt")
        public void testRightSideRepeat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/rightSideRepeat.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleAssign.kt")
        public void testSimpleAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/simpleAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("validSubtraction.kt")
        public void testValidSubtraction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOperatorAssignment/validSubtraction.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/replaceWithOrdinaryAssignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceWithOrdinaryAssignment extends AbstractIntentionTest {
        public void testAllFilesPresentInReplaceWithOrdinaryAssignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceWithOrdinaryAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexRightExpression.kt")
        public void testComplexRightExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOrdinaryAssignment/complexRightExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("nonAssignmentExpression.kt")
        public void testNonAssignmentExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOrdinaryAssignment/nonAssignmentExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("nonAugmentedAssign.kt")
        public void testNonAugmentedAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOrdinaryAssignment/nonAugmentedAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/replaceWithOrdinaryAssignment/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/simplifyAssertNotNull")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SimplifyAssertNotNull extends AbstractIntentionTest {
        public void testAllFilesPresentInSimplifyAssertNotNull() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/simplifyAssertNotNull"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("comments.kt")
        public void testComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/comments.kt");
            doTest(fileName);
        }

        @TestMetadata("commentsNoMessage.kt")
        public void testCommentsNoMessage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/commentsNoMessage.kt");
            doTest(fileName);
        }

        @TestMetadata("complicatedMessageLambda.kt")
        public void testComplicatedMessageLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/complicatedMessageLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("eqNull.kt")
        public void testEqNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/eqNull.kt");
            doTest(fileName);
        }

        @TestMetadata("errorFunctionInContext.kt")
        public void testErrorFunctionInContext() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/errorFunctionInContext.kt");
            doTest(fileName);
        }

        @TestMetadata("falseAssert.kt")
        public void testFalseAssert() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/falseAssert.kt");
            doTest(fileName);
        }

        @TestMetadata("noMessage.kt")
        public void testNoMessage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/noMessage.kt");
            doTest(fileName);
        }

        @TestMetadata("otherVariable.kt")
        public void testOtherVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/otherVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("qualifiedAccess.kt")
        public void testQualifiedAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/qualifiedAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("withMessage.kt")
        public void testWithMessage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/withMessage.kt");
            doTest(fileName);
        }

        @TestMetadata("withMessageLambdaOutside.kt")
        public void testWithMessageLambdaOutside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyAssertNotNull/withMessageLambdaOutside.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/simplifyBooleanWithConstants")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SimplifyBooleanWithConstants extends AbstractIntentionTest {
        public void testAllFilesPresentInSimplifyBooleanWithConstants() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/simplifyBooleanWithConstants"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("deeplyParenthesized.kt")
        public void testDeeplyParenthesized() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/deeplyParenthesized.kt");
            doTest(fileName);
        }

        @TestMetadata("equalsConjunction.kt")
        public void testEqualsConjunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/equalsConjunction.kt");
            doTest(fileName);
        }

        @TestMetadata("equalsDisjunction.kt")
        public void testEqualsDisjunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/equalsDisjunction.kt");
            doTest(fileName);
        }

        @TestMetadata("equalsFalse.kt")
        public void testEqualsFalse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/equalsFalse.kt");
            doTest(fileName);
        }

        @TestMetadata("equalsTrue.kt")
        public void testEqualsTrue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/equalsTrue.kt");
            doTest(fileName);
        }

        @TestMetadata("equalsTrueOrFalse.kt")
        public void testEqualsTrueOrFalse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/equalsTrueOrFalse.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableNoConstants.kt")
        public void testInapplicableNoConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableNoConstants.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableNotBinary.kt")
        public void testInapplicableNotBinary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableNotBinary.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableUsesVals.kt")
        public void testInapplicableUsesVals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableUsesVals.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableUsesVals2.kt")
        public void testInapplicableUsesVals2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableUsesVals2.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableUsesVals3.kt")
        public void testInapplicableUsesVals3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableUsesVals3.kt");
            doTest(fileName);
        }

        @TestMetadata("notEqualsFalse.kt")
        public void testNotEqualsFalse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/notEqualsFalse.kt");
            doTest(fileName);
        }

        @TestMetadata("notEqualsTrue.kt")
        public void testNotEqualsTrue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/notEqualsTrue.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableBoolean.kt")
        public void testNullableBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/nullableBoolean.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableComplex.kt")
        public void testNullableComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/nullableComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("reduceableBinary.kt")
        public void testReduceableBinary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/reduceableBinary.kt");
            doTest(fileName);
        }

        @TestMetadata("reduceableBinary2.kt")
        public void testReduceableBinary2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/reduceableBinary2.kt");
            doTest(fileName);
        }

        @TestMetadata("reduceableBinary3.kt")
        public void testReduceableBinary3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/reduceableBinary3.kt");
            doTest(fileName);
        }

        @TestMetadata("reduceableBinaryWithParenthese.kt")
        public void testReduceableBinaryWithParenthese() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/reduceableBinaryWithParenthese.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithMoreBinaries.kt")
        public void testSimpleWithMoreBinaries() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinaries.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithMoreBinaries2.kt")
        public void testSimpleWithMoreBinaries2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinaries2.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithMoreBinaries3.kt")
        public void testSimpleWithMoreBinaries3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinaries3.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithMoreBinariesAndParentheses.kt")
        public void testSimpleWithMoreBinariesAndParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinariesAndParentheses.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithMoreBinariesAndParentheses2.kt")
        public void testSimpleWithMoreBinariesAndParentheses2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinariesAndParentheses2.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithMoreBinariesAndParentheses3.kt")
        public void testSimpleWithMoreBinariesAndParentheses3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinariesAndParentheses3.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithNonsensical2.kt")
        public void testSimpleWithNonsensical2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithNonsensical2.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithParentheses.kt")
        public void testSimpleWithParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithParentheses.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleWithParentheses2.kt")
        public void testSimpleWithParentheses2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithParentheses2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SimplifyNegatedBinaryExpression extends AbstractIntentionTest {
        public void testAllFilesPresentInSimplifyNegatedBinaryExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/simplifyNegatedBinaryExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/equals.kt");
            doTest(fileName);
        }

        @TestMetadata("greaterThan.kt")
        public void testGreaterThan() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/greaterThan.kt");
            doTest(fileName);
        }

        @TestMetadata("greaterThanOrEquals.kt")
        public void testGreaterThanOrEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/greaterThanOrEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/in.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableBinaryOperation.kt")
        public void testInapplicableBinaryOperation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/inapplicableBinaryOperation.kt");
            doTest(fileName);
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/is.kt");
            doTest(fileName);
        }

        @TestMetadata("lessThan.kt")
        public void testLessThan() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/lessThan.kt");
            doTest(fileName);
        }

        @TestMetadata("lessThanOrEquals.kt")
        public void testLessThanOrEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/lessThanOrEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("notEquals.kt")
        public void testNotEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/notEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("notIn.kt")
        public void testNotIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/notIn.kt");
            doTest(fileName);
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/notIs.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInvert.kt")
        public void testSimpleInvert() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/simplifyNegatedBinaryExpression/simpleInvert.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/intentions/specifyExplicitLambdaSignature")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SpecifyExplicitLambdaSignature extends AbstractIntentionTest {
        public void testAllFilesPresentInSpecifyExplicitLambdaSignature() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/specifyExplicitLambdaSignature"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/coercionToUnit.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyParamListWithBrackets.kt")
        public void testEmptyParamListWithBrackets() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/emptyParamListWithBrackets.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyParamListWithIt.kt")
        public void testEmptyParamListWithIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/emptyParamListWithIt.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyParamListWithWhiteSpace.kt")
        public void testEmptyParamListWithWhiteSpace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/emptyParamListWithWhiteSpace.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyParamListWithoutItWithArrow.kt")
        public void testEmptyParamListWithoutItWithArrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/emptyParamListWithoutItWithArrow.kt");
            doTest(fileName);
        }

        @TestMetadata("invalidCursorPosition.kt")
        public void testInvalidCursorPosition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/invalidCursorPosition.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithLambdaAsParam.kt")
        public void testLambdaWithLambdaAsParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/lambdaWithLambdaAsParam.kt");
            doTest(fileName);
        }

        @TestMetadata("manyNewlines.kt")
        public void testManyNewlines() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/manyNewlines.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleParam.kt")
        public void testMultipleParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/multipleParam.kt");
            doTest(fileName);
        }

        @TestMetadata("shortenReferencesForParams.kt")
        public void testShortenReferencesForParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/shortenReferencesForParams.kt");
            doTest(fileName);
        }

        @TestMetadata("singleParam.kt")
        public void testSingleParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/singleParam.kt");
            doTest(fileName);
        }

        @TestMetadata("typesAlreadyExplicit.kt")
        public void testTypesAlreadyExplicit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/typesAlreadyExplicit.kt");
            doTest(fileName);
        }

        @TestMetadata("typesNotInferable.kt")
        public void testTypesNotInferable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyExplicitLambdaSignature/typesNotInferable.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/specifyTypeExplicitly")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SpecifyTypeExplicitly extends AbstractIntentionTest {
        public void testAllFilesPresentInSpecifyTypeExplicitly() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/specifyTypeExplicitly"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObject.kt")
        public void testAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/anonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("badCaretPosition.kt")
        public void testBadCaretPosition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/badCaretPosition.kt");
            doTest(fileName);
        }

        @TestMetadata("classNameClashing.kt")
        public void testClassNameClashing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/classNameClashing.kt");
            doTest(fileName);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("enumType.kt")
        public void testEnumType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/enumType.kt");
            doTest(fileName);
        }

        @TestMetadata("functionType.kt")
        public void testFunctionType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/functionType.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaParam.kt")
        public void testLambdaParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/lambdaParam.kt");
            doTest(fileName);
        }

        @TestMetadata("localClass.kt")
        public void testLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/localClass.kt");
            doTest(fileName);
        }

        @TestMetadata("loopParameter.kt")
        public void testLoopParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/loopParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyTypeFromGetter.kt")
        public void testPropertyTypeFromGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/propertyTypeFromGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("publicMember.kt")
        public void testPublicMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/publicMember.kt");
            doTest(fileName);
        }

        @TestMetadata("stringRedefined.kt")
        public void testStringRedefined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/stringRedefined.kt");
            doTest(fileName);
        }

        @TestMetadata("typeAlreadyProvided.kt")
        public void testTypeAlreadyProvided() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/typeAlreadyProvided.kt");
            doTest(fileName);
        }

        @TestMetadata("unitType.kt")
        public void testUnitType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/unitType.kt");
            doTest(fileName);
        }

        @TestMetadata("unknownType.kt")
        public void testUnknownType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/specifyTypeExplicitly/unknownType.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/splitIf")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SplitIf extends AbstractIntentionTest {
        public void testAllFilesPresentInSplitIf() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/splitIf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("and.kt")
        public void testAnd() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/and.kt");
            doTest(fileName);
        }

        @TestMetadata("caretOnIf.kt")
        public void testCaretOnIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/caretOnIf.kt");
            doTest(fileName);
        }

        @TestMetadata("ifAndOr.kt")
        public void testIfAndOr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/ifAndOr.kt");
            doTest(fileName);
        }

        @TestMetadata("ifAndOrWithBraces.kt")
        public void testIfAndOrWithBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/ifAndOrWithBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("ifAndWithBraces.kt")
        public void testIfAndWithBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/ifAndWithBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("ifOrReturn.kt")
        public void testIfOrReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/ifOrReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("ifWithElse.kt")
        public void testIfWithElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/ifWithElse.kt");
            doTest(fileName);
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/localFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedIf.kt")
        public void testNestedIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/nestedIf.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedIfNotApplicable.kt")
        public void testNestedIfNotApplicable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/nestedIfNotApplicable.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedIfOutside.kt")
        public void testNestedIfOutside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/nestedIfOutside.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedInside.kt")
        public void testNestedInside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/nestedInside.kt");
            doTest(fileName);
        }

        @TestMetadata("notIf.kt")
        public void testNotIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/notIf.kt");
            doTest(fileName);
        }

        @TestMetadata("onIfWithOr.kt")
        public void testOnIfWithOr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/onIfWithOr.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorAsFunctionParam.kt")
        public void testOperatorAsFunctionParam() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/operatorAsFunctionParam.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorOutsideIf.kt")
        public void testOperatorOutsideIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/operatorOutsideIf.kt");
            doTest(fileName);
        }

        @TestMetadata("orAnd.kt")
        public void testOrAnd() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/orAnd.kt");
            doTest(fileName);
        }

        @TestMetadata("orWithBraces.kt")
        public void testOrWithBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/orWithBraces.kt");
            doTest(fileName);
        }

        @TestMetadata("twoOperatorsFirst.kt")
        public void testTwoOperatorsFirst() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/twoOperatorsFirst.kt");
            doTest(fileName);
        }

        @TestMetadata("twoOperatorsSecond.kt")
        public void testTwoOperatorsSecond() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/twoOperatorsSecond.kt");
            doTest(fileName);
        }

        @TestMetadata("withNotOperator.kt")
        public void testWithNotOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/withNotOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("withNotOperatorGood.kt")
        public void testWithNotOperatorGood() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/withNotOperatorGood.kt");
            doTest(fileName);
        }

        @TestMetadata("withOR.kt")
        public void testWithOR() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/withOR.kt");
            doTest(fileName);
        }

        @TestMetadata("withORElse.kt")
        public void testWithORElse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/withORElse.kt");
            doTest(fileName);
        }

        @TestMetadata("wrongCaretLocation.kt")
        public void testWrongCaretLocation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/wrongCaretLocation.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/intentions/splitIf/keepComments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KeepComments extends AbstractIntentionTest {
            public void testAllFilesPresentInKeepComments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/splitIf/keepComments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ifOrReturn.kt")
            public void testIfOrReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/keepComments/ifOrReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("twoOperators.kt")
            public void testTwoOperators() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/keepComments/twoOperators.kt");
                doTest(fileName);
            }

            @TestMetadata("withAnd.kt")
            public void testWithAnd() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/keepComments/withAnd.kt");
                doTest(fileName);
            }

            @TestMetadata("withOR.kt")
            public void testWithOR() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/splitIf/keepComments/withOR.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/swapBinaryExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SwapBinaryExpression extends AbstractIntentionTest {
        public void testAllFilesPresentInSwapBinaryExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/swapBinaryExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/assignment.kt");
            doTest(fileName);
        }

        @TestMetadata("conjunction.kt")
        public void testConjunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/conjunction.kt");
            doTest(fileName);
        }

        @TestMetadata("conjunctionLiteral.kt")
        public void testConjunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/conjunctionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("disjunction.kt")
        public void testDisjunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/disjunction.kt");
            doTest(fileName);
        }

        @TestMetadata("disjunctionLiteral.kt")
        public void testDisjunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/disjunctionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("divide.kt")
        public void testDivide() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/divide.kt");
            doTest(fileName);
        }

        @TestMetadata("divideAssign.kt")
        public void testDivideAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/divideAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/equals.kt");
            doTest(fileName);
        }

        @TestMetadata("greaterThan.kt")
        public void testGreaterThan() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/greaterThan.kt");
            doTest(fileName);
        }

        @TestMetadata("greaterThanEquals.kt")
        public void testGreaterThanEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/greaterThanEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("identityEquals.kt")
        public void testIdentityEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/identityEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/in.kt");
            doTest(fileName);
        }

        @TestMetadata("infixFunction.kt")
        public void testInfixFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/infixFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/is.kt");
            doTest(fileName);
        }

        @TestMetadata("lessThan.kt")
        public void testLessThan() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/lessThan.kt");
            doTest(fileName);
        }

        @TestMetadata("lessThanEquals.kt")
        public void testLessThanEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/lessThanEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("minus.kt")
        public void testMinus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/minus.kt");
            doTest(fileName);
        }

        @TestMetadata("minusAssign.kt")
        public void testMinusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/minusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperands.kt")
        public void testMultipleOperands() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multipleOperands.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence.kt")
        public void testMultipleOperandsWithDifferentPrecedence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence2.kt")
        public void testMultipleOperandsWithDifferentPrecedence2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence2.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence3.kt")
        public void testMultipleOperandsWithDifferentPrecedence3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence3.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence4.kt")
        public void testMultipleOperandsWithDifferentPrecedence4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence4.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence5.kt")
        public void testMultipleOperandsWithDifferentPrecedence5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence5.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence6.kt")
        public void testMultipleOperandsWithDifferentPrecedence6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence6.kt");
            doTest(fileName);
        }

        @TestMetadata("multiply.kt")
        public void testMultiply() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multiply.kt");
            doTest(fileName);
        }

        @TestMetadata("multiplyAssign.kt")
        public void testMultiplyAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/multiplyAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("nonBinaryExpr.kt")
        public void testNonBinaryExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/nonBinaryExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("notEquals.kt")
        public void testNotEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/notEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("notIdentityEquals.kt")
        public void testNotIdentityEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/notIdentityEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("notIn.kt")
        public void testNotIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/notIn.kt");
            doTest(fileName);
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/notIs.kt");
            doTest(fileName);
        }

        @TestMetadata("nullOperand.kt")
        public void testNullOperand() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/nullOperand.kt");
            doTest(fileName);
        }

        @TestMetadata("plus.kt")
        public void testPlus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/plus.kt");
            doTest(fileName);
        }

        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/plusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("plusInt.kt")
        public void testPlusInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/plusInt.kt");
            doTest(fileName);
        }

        @TestMetadata("plusMinus.kt")
        public void testPlusMinus() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/plusMinus.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeTo.kt")
        public void testRangeTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/rangeTo.kt");
            doTest(fileName);
        }

        @TestMetadata("remainder.kt")
        public void testRemainder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/remainder.kt");
            doTest(fileName);
        }

        @TestMetadata("remainderAssign.kt")
        public void testRemainderAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/remainderAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("times.kt")
        public void testTimes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/times.kt");
            doTest(fileName);
        }

        @TestMetadata("timesAssign.kt")
        public void testTimesAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/timesAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("xor.kt")
        public void testXor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/swapBinaryExpression/xor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/toInfixCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToInfixCall extends AbstractIntentionTest {
        public void testAllFilesPresentInToInfixCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/toInfixCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("binaryExpressionArgument.kt")
        public void testBinaryExpressionArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/binaryExpressionArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("caretInsideCalleeExpr.kt")
        public void testCaretInsideCalleeExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/caretInsideCalleeExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("caretInsideReceiverExpr.kt")
        public void testCaretInsideReceiverExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/caretInsideReceiverExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleFunctionCall.kt")
        public void testDoubleFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/doubleFunctionCall.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleFunctionCallWithoutParentheses.kt")
        public void testDoubleFunctionCallWithoutParentheses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/doubleFunctionCallWithoutParentheses.kt");
            doTest(fileName);
        }

        @TestMetadata("functionLiteralArgument.kt")
        public void testFunctionLiteralArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/functionLiteralArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("functionSafeCall.kt")
        public void testFunctionSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/functionSafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("inapplicableCaretPosition.kt")
        public void testInapplicableCaretPosition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/inapplicableCaretPosition.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleArguments.kt")
        public void testMultipleArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/multipleArguments.kt");
            doTest(fileName);
        }

        @TestMetadata("namedArgument.kt")
        public void testNamedArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/namedArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("noExplicitReceiver.kt")
        public void testNoExplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/noExplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("notInfix.kt")
        public void testNotInfix() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/notInfix.kt");
            doTest(fileName);
        }

        @TestMetadata("nullAssertedReceiver.kt")
        public void testNullAssertedReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/nullAssertedReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("packageFunctionCall.kt")
        public void testPackageFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/packageFunctionCall.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccess.kt")
        public void testPropertyAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/propertyAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("secondParameterLabeled.kt")
        public void testSecondParameterLabeled() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/secondParameterLabeled.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleArgumentAndFunctionLiteralArgument.kt")
        public void testSimpleArgumentAndFunctionLiteralArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/simpleArgumentAndFunctionLiteralArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleMethodCall.kt")
        public void testSimpleMethodCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/simpleMethodCall.kt");
            doTest(fileName);
        }

        @TestMetadata("singlePackageFunctionCall.kt")
        public void testSinglePackageFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/singlePackageFunctionCall.kt");
            doTest(fileName);
        }

        @TestMetadata("zeroArguments.kt")
        public void testZeroArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toInfixCall/zeroArguments.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/toOrdinaryStringLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToOrdinaryStringLiteral extends AbstractIntentionTest {
        public void testAllFilesPresentInToOrdinaryStringLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/toOrdinaryStringLiteral"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lineBreakInExpression.kt")
        public void testLineBreakInExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toOrdinaryStringLiteral/lineBreakInExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("quotesAndSlashes.kt")
        public void testQuotesAndSlashes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toOrdinaryStringLiteral/quotesAndSlashes.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toOrdinaryStringLiteral/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/toRawStringLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToRawStringLiteral extends AbstractIntentionTest {
        @TestMetadata("3quotes.kt")
        public void test3quotes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/3quotes.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInToRawStringLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/toRawStringLiteral"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyRaw.kt")
        public void testAlreadyRaw() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/alreadyRaw.kt");
            doTest(fileName);
        }

        @TestMetadata("dollar.kt")
        public void testDollar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/dollar.kt");
            doTest(fileName);
        }

        @TestMetadata("dollar2.kt")
        public void testDollar2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/dollar2.kt");
            doTest(fileName);
        }

        @TestMetadata("quotesAndSlashes.kt")
        public void testQuotesAndSlashes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/quotesAndSlashes.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("specialChar.kt")
        public void testSpecialChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/specialChar.kt");
            doTest(fileName);
        }

        @TestMetadata("tabCharacter.kt")
        public void testTabCharacter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/tabCharacter.kt");
            doTest(fileName);
        }

        @TestMetadata("trailingSpace.kt")
        public void testTrailingSpace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/trailingSpace.kt");
            doTest(fileName);
        }

        @TestMetadata("trailingSpace2.kt")
        public void testTrailingSpace2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/trailingSpace2.kt");
            doTest(fileName);
        }

        @TestMetadata("trailingSpace3.kt")
        public void testTrailingSpace3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/toRawStringLiteral/trailingSpace3.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/usePropertyAccessSyntax")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UsePropertyAccessSyntax extends AbstractIntentionTest {
        @TestMetadata("accessThroughKotlinClassInstance.kt")
        public void testAccessThroughKotlinClassInstance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/accessThroughKotlinClassInstance.kt");
            doTest(fileName);
        }

        @TestMetadata("accessThroughKotlinClassInstanceWithOverride.kt")
        public void testAccessThroughKotlinClassInstanceWithOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/accessThroughKotlinClassInstanceWithOverride.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInUsePropertyAccessSyntax() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/usePropertyAccessSyntax"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conflict1.kt")
        public void testConflict1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/conflict1.kt");
            doTest(fileName);
        }

        @TestMetadata("conflict2.kt")
        public void testConflict2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/conflict2.kt");
            doTest(fileName);
        }

        @TestMetadata("genericClassMethod.kt")
        public void testGenericClassMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/genericClassMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("get.kt")
        public void testGet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/get.kt");
            doTest(fileName);
        }

        @TestMetadata("getImplicitReceiver.kt")
        public void testGetImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/getImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("getSafeCall.kt")
        public void testGetSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/getSafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("isGet.kt")
        public void testIsGet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/isGet.kt");
            doTest(fileName);
        }

        @TestMetadata("isSet.kt")
        public void testIsSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/isSet.kt");
            doTest(fileName);
        }

        @TestMetadata("nonVoidSetter1.kt")
        public void testNonVoidSetter1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/nonVoidSetter1.kt");
            doTest(fileName);
        }

        @TestMetadata("nonVoidSetter2.kt")
        public void testNonVoidSetter2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/nonVoidSetter2.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyTypeIsMoreSpecific1.kt")
        public void testPropertyTypeIsMoreSpecific1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/propertyTypeIsMoreSpecific1.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyTypeIsMoreSpecific2.kt")
        public void testPropertyTypeIsMoreSpecific2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/propertyTypeIsMoreSpecific2.kt");
            doTest(fileName);
        }

        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/set.kt");
            doTest(fileName);
        }

        @TestMetadata("setAsExpressionBody.kt")
        public void testSetAsExpressionBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/setAsExpressionBody.kt");
            doTest(fileName);
        }

        @TestMetadata("setAsExpressionBodyProperty.kt")
        public void testSetAsExpressionBodyProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/setAsExpressionBodyProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("setAsExpressionBodyUnqualified.kt")
        public void testSetAsExpressionBodyUnqualified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/setAsExpressionBodyUnqualified.kt");
            doTest(fileName);
        }

        @TestMetadata("setImplicitReceiver.kt")
        public void testSetImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/setImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("setSafeCall.kt")
        public void testSetSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/setSafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("smartCast.kt")
        public void testSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/smartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("superCall.kt")
        public void testSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/superCall.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParameterReceiver.kt")
        public void testTypeParameterReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/usePropertyAccessSyntax/typeParameterReceiver.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/intentions/useWithIndex")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UseWithIndex extends AbstractIntentionTest {
        public void testAllFilesPresentInUseWithIndex() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/useWithIndex"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyWithIndex.kt")
        public void testAlreadyWithIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/useWithIndex/alreadyWithIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("customTypeWithIterator.kt")
        public void testCustomTypeWithIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/useWithIndex/customTypeWithIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("indexIncrementTwice.kt")
        public void testIndexIncrementTwice() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/useWithIndex/indexIncrementTwice.kt");
            doTest(fileName);
        }

        @TestMetadata("indexPlusPlusInsideExpression.kt")
        public void testIndexPlusPlusInsideExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/useWithIndex/indexPlusPlusInsideExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("indexUsedAfterLoop.kt")
        public void testIndexUsedAfterLoop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/useWithIndex/indexUsedAfterLoop.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixPlusPlusInsideExpression.kt")
        public void testPrefixPlusPlusInsideExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/useWithIndex/prefixPlusPlusInsideExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/intentions/useWithIndex/simple.kt");
            doTest(fileName);
        }
    }
}
