/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/kdoc/typing")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class KDocTypingTestGenerated extends AbstractKDocTypingTest {
    public void testAllFilesPresentInTyping() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/kdoc/typing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("closingBracketNotInLink.kt")
    public void testClosingBracketNotInLink() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/kdoc/typing/closingBracketNotInLink.kt");
        doTest(fileName);
    }

    @TestMetadata("closingBracketOvertype.kt")
    public void testClosingBracketOvertype() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/kdoc/typing/closingBracketOvertype.kt");
        doTest(fileName);
    }

    @TestMetadata("closingBracketOvertypeEmpty.kt")
    public void testClosingBracketOvertypeEmpty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/kdoc/typing/closingBracketOvertypeEmpty.kt");
        doTest(fileName);
    }

    @TestMetadata("closingBracketRefLinkOvertype.kt")
    public void testClosingBracketRefLinkOvertype() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/kdoc/typing/closingBracketRefLinkOvertype.kt");
        doTest(fileName);
    }

    @TestMetadata("closingParenOvertype.kt")
    public void testClosingParenOvertype() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/kdoc/typing/closingParenOvertype.kt");
        doTest(fileName);
    }

    @TestMetadata("openingBracket.kt")
    public void testOpeningBracket() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/kdoc/typing/openingBracket.kt");
        doTest(fileName);
    }

    @TestMetadata("openingBracketRefLink.kt")
    public void testOpeningBracketRefLink() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/kdoc/typing/openingBracketRefLink.kt");
        doTest(fileName);
    }

    @TestMetadata("openingParen.kt")
    public void testOpeningParen() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/kdoc/typing/openingParen.kt");
        doTest(fileName);
    }
}
