/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/quickfix")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class QuickFixTestGenerated extends AbstractQuickFixTest {
    public void testAllFilesPresentInQuickfix() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("idea/testData/quickfix/abstract")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Abstract extends AbstractQuickFixTest {
        @TestMetadata("abstractFunctionInNonAbstractClass.kt")
        public void testAbstractFunctionInNonAbstractClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractFunctionInNonAbstractClass.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractFunctionWithBody.kt")
        public void testAbstractFunctionWithBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractFunctionWithBody.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractFunctionWithBody2.kt")
        public void testAbstractFunctionWithBody2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractFunctionWithBody2.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractFunctionWithBody3.kt")
        public void testAbstractFunctionWithBody3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractFunctionWithBody3.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractFunctionWithBodyWithComments.kt")
        public void testAbstractFunctionWithBodyWithComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractFunctionWithBodyWithComments.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractFunctionWithBodyWithComments2.kt")
        public void testAbstractFunctionWithBodyWithComments2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractFunctionWithBodyWithComments2.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyInCompanionObject.kt")
        public void testAbstractPropertyInCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyInCompanionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyInNonAbstractClass1.kt")
        public void testAbstractPropertyInNonAbstractClass1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyInNonAbstractClass1.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyInNonAbstractClass2.kt")
        public void testAbstractPropertyInNonAbstractClass2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyInNonAbstractClass2.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyInNonAbstractClass3.kt")
        public void testAbstractPropertyInNonAbstractClass3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyInNonAbstractClass3.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyInPrimaryConstructorParameters.kt")
        public void testAbstractPropertyInPrimaryConstructorParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyInPrimaryConstructorParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyNotInClass.kt")
        public void testAbstractPropertyNotInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyNotInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyWIthInitializer2.kt")
        public void testAbstractPropertyWIthInitializer2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyWIthInitializer2.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyWIthInitializer3.kt")
        public void testAbstractPropertyWIthInitializer3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyWIthInitializer3.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyWithGetter1.kt")
        public void testAbstractPropertyWithGetter1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyWithGetter1.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyWithGetter2.kt")
        public void testAbstractPropertyWithGetter2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyWithGetter2.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyWithInitializer1.kt")
        public void testAbstractPropertyWithInitializer1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyWithInitializer1.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractPropertyWithSetter.kt")
        public void testAbstractPropertyWithSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/abstractPropertyWithSetter.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInAbstract() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/abstract"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("makeEnumEntryAbstract.kt")
        public void testMakeEnumEntryAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/makeEnumEntryAbstract.kt");
            doTest(fileName);
        }

        @TestMetadata("makeObjectMemberAbstract.kt")
        public void testMakeObjectMemberAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/makeObjectMemberAbstract.kt");
            doTest(fileName);
        }

        @TestMetadata("makeTopLevelAbstract.kt")
        public void testMakeTopLevelAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/makeTopLevelAbstract.kt");
            doTest(fileName);
        }

        @TestMetadata("manyImpl.kt")
        public void testManyImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/manyImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("mustBeInitializedOrBeAbstract.kt")
        public void testMustBeInitializedOrBeAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/mustBeInitializedOrBeAbstract.kt");
            doTest(fileName);
        }

        @TestMetadata("nonAbstractFunctionWithNoBody.kt")
        public void testNonAbstractFunctionWithNoBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/nonAbstractFunctionWithNoBody.kt");
            doTest(fileName);
        }

        @TestMetadata("nonMemberAbstractFunction.kt")
        public void testNonMemberAbstractFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/nonMemberAbstractFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("nonMemberFunctionNoBody.kt")
        public void testNonMemberFunctionNoBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/nonMemberFunctionNoBody.kt");
            doTest(fileName);
        }

        @TestMetadata("notImplementedMember.kt")
        public void testNotImplementedMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/notImplementedMember.kt");
            doTest(fileName);
        }

        @TestMetadata("notImplementedMemberFromAbstractClass.kt")
        public void testNotImplementedMemberFromAbstractClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/notImplementedMemberFromAbstractClass.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceOpen.kt")
        public void testReplaceOpen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/abstract/replaceOpen.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addCrossinline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddCrossinline extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddCrossinline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addCrossinline"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addCrossinline/basic.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addGenericUpperBound")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddGenericUpperBound extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddGenericUpperBound() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addGenericUpperBound"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addGenericUpperBound/basic.kt");
            doTest(fileName);
        }

        @TestMetadata("boundAlreadyExists.kt")
        public void testBoundAlreadyExists() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addGenericUpperBound/boundAlreadyExists.kt");
            doTest(fileName);
        }

        @TestMetadata("inferenceTwoParams.kt")
        public void testInferenceTwoParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addGenericUpperBound/inferenceTwoParams.kt");
            doTest(fileName);
        }

        @TestMetadata("kClassRuntime.kt")
        public void testKClassRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addGenericUpperBound/kClassRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("paramAsBound.kt")
        public void testParamAsBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addGenericUpperBound/paramAsBound.kt");
            doTest(fileName);
        }

        @TestMetadata("withinDeclaration.kt")
        public void testWithinDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addGenericUpperBound/withinDeclaration.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addInitializer")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddInitializer extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddInitializer() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addInitializer"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("localVar.kt")
        public void testLocalVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/localVar.kt");
            doTest(fileName);
        }

        @TestMetadata("memberExtensionProperty.kt")
        public void testMemberExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/memberExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("memberExtensionPropertyVarGetterOnly.kt")
        public void testMemberExtensionPropertyVarGetterOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/memberExtensionPropertyVarGetterOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("memberExtensionPropertyVarSetterOnly.kt")
        public void testMemberExtensionPropertyVarSetterOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/memberExtensionPropertyVarSetterOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("memberProperty.kt")
        public void testMemberProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/memberProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyVarGetterOnly.kt")
        public void testMemberPropertyVarGetterOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/memberPropertyVarGetterOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyVarSetterOnly.kt")
        public void testMemberPropertyVarSetterOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/memberPropertyVarSetterOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyWithAccessor.kt")
        public void testMemberPropertyWithAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/memberPropertyWithAccessor.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyWithDelegateRuntime.kt")
        public void testMemberPropertyWithDelegateRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/memberPropertyWithDelegateRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelExtensionProperty.kt")
        public void testTopLevelExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/topLevelExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelExtensionPropertySetterOnly.kt")
        public void testTopLevelExtensionPropertySetterOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/topLevelExtensionPropertySetterOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/topLevelProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelPropertyVarGetterOnly.kt")
        public void testTopLevelPropertyVarGetterOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/topLevelPropertyVarGetterOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelPropertyVarSetterOnly.kt")
        public void testTopLevelPropertyVarSetterOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/topLevelPropertyVarSetterOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelPropertyWithDelegateRuntime.kt")
        public void testTopLevelPropertyWithDelegateRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/topLevelPropertyWithDelegateRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelPropertyWithGetter.kt")
        public void testTopLevelPropertyWithGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInitializer/topLevelPropertyWithGetter.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addInlineToReifiedFunctionFix")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddInlineToReifiedFunctionFix extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddInlineToReifiedFunctionFix() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addInlineToReifiedFunctionFix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addInlineToReifiedFunctionFix/basic.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addNewLineAfterAnnotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddNewLineAfterAnnotations extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddNewLineAfterAnnotations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addNewLineAfterAnnotations"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addNewLineAfterAnnotations/basic.kt");
            doTest(fileName);
        }

        @TestMetadata("manyAnnotations.kt")
        public void testManyAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addNewLineAfterAnnotations/manyAnnotations.kt");
            doTest(fileName);
        }

        @TestMetadata("poorlyFormattedExpression.kt")
        public void testPoorlyFormattedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addNewLineAfterAnnotations/poorlyFormattedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("preserveComments.kt")
        public void testPreserveComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addNewLineAfterAnnotations/preserveComments.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addNoinline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddNoinline extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddNoinline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addNoinline"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addNoinline/basic.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddReifiedToTypeParameterOfFunctionFix extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddReifiedToTypeParameterOfFunctionFix() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doubleColonClass.kt")
        public void testDoubleColonClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix/doubleColonClass.kt");
            doTest(fileName);
        }

        @TestMetadata("secondTypeParameter.kt")
        public void testSecondTypeParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix/secondTypeParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("toTypedArray.kt")
        public void testToTypedArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix/toTypedArray.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addRunBeforeLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddRunBeforeLambda extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddRunBeforeLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addRunBeforeLambda"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addRunBeforeLambda/basic.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addStarProjections")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddStarProjections extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddStarProjections() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("qualifiedArrayList.kt")
        public void testQualifiedArrayList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/qualifiedArrayList.kt");
            doTest(fileName);
        }

        @TestMetadata("qualifiedList.kt")
        public void testQualifiedList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/qualifiedList.kt");
            doTest(fileName);
        }

        @TestMetadata("qualifiedMap.kt")
        public void testQualifiedMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/qualifiedMap.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedList.kt")
        public void testUnqualifiedList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/unqualifiedList.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedMap.kt")
        public void testUnqualifiedMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/unqualifiedMap.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedMapOneArg.kt")
        public void testUnqualifiedMapOneArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/unqualifiedMapOneArg.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/quickfix/addStarProjections/cast")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Cast extends AbstractQuickFixTest {
            public void testAllFilesPresentInCast() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections/cast"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeFunctionalToStarProjection.kt")
            public void testChangeFunctionalToStarProjection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/cast/changeFunctionalToStarProjection.kt");
                doTest(fileName);
            }

            @TestMetadata("changeToStarProjection.kt")
            public void testChangeToStarProjection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/cast/changeToStarProjection.kt");
                doTest(fileName);
            }

            @TestMetadata("changeToStarProjectionNullable.kt")
            public void testChangeToStarProjectionNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/cast/changeToStarProjectionNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("uncheckedCastOnTypeParameter.kt")
            public void testUncheckedCastOnTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/cast/uncheckedCastOnTypeParameter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/addStarProjections/checkType")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CheckType extends AbstractQuickFixTest {
            public void testAllFilesPresentInCheckType() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections/checkType"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeToStarProjectionMultipleParameters.kt")
            public void testChangeToStarProjectionMultipleParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/checkType/changeToStarProjectionMultipleParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("changeToStarProjectionNullable.kt")
            public void testChangeToStarProjectionNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/checkType/changeToStarProjectionNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("changeToStarProjectionSingleParameter.kt")
            public void testChangeToStarProjectionSingleParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/checkType/changeToStarProjectionSingleParameter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/addStarProjections/when")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class When extends AbstractQuickFixTest {
            public void testAllFilesPresentInWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections/when"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("qualifiedArrayList.kt")
            public void testQualifiedArrayList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/when/qualifiedArrayList.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifiedList.kt")
            public void testQualifiedList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/when/qualifiedList.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifiedMap.kt")
            public void testQualifiedMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/when/qualifiedMap.kt");
                doTest(fileName);
            }

            @TestMetadata("unqualifiedList.kt")
            public void testUnqualifiedList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/when/unqualifiedList.kt");
                doTest(fileName);
            }

            @TestMetadata("unqualifiedMap.kt")
            public void testUnqualifiedMap() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/when/unqualifiedMap.kt");
                doTest(fileName);
            }

            @TestMetadata("unqualifiedMapOneArg.kt")
            public void testUnqualifiedMapOneArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addStarProjections/when/unqualifiedMapOneArg.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/addTypeAnnotationToValueParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddTypeAnnotationToValueParameter extends AbstractQuickFixTest {
        public void testAllFilesPresentInAddTypeAnnotationToValueParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addTypeAnnotationToValueParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("noDefaultValue.kt")
        public void testNoDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addTypeAnnotationToValueParameter/noDefaultValue.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addTypeAnnotationToValueParameter/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/addValVar")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddValVar extends AbstractQuickFixTest {
        @TestMetadata("addVal.kt")
        public void testAddVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addValVar/addVal.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInAddValVar() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addValVar"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }
    }

    @TestMetadata("idea/testData/quickfix/addVarianceModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddVarianceModifier extends AbstractQuickFixTest {
        @TestMetadata("abstractIn.kt")
        public void testAbstractIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addVarianceModifier/abstractIn.kt");
            doTest(fileName);
        }

        @TestMetadata("abstractOut.kt")
        public void testAbstractOut() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addVarianceModifier/abstractOut.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInAddVarianceModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addVarianceModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("emptyTest.kt")
        public void testEmptyTest() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/addVarianceModifier/emptyTest.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/autoImports")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AutoImports extends AbstractQuickFixTest {
        public void testAllFilesPresentInAutoImports() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/autoImports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("checkNoStackOverflowInImportInnerClassInCurrentFile.kt")
        public void testCheckNoStackOverflowInImportInnerClassInCurrentFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/checkNoStackOverflowInImportInnerClassInCurrentFile.kt");
            doTest(fileName);
        }

        @TestMetadata("infixCallAndObject.kt")
        public void testInfixCallAndObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/infixCallAndObject.kt");
            doTest(fileName);
        }

        @TestMetadata("libraryPropertyJsRuntime.kt")
        public void testLibraryPropertyJsRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/libraryPropertyJsRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("libraryPropertyRuntime.kt")
        public void testLibraryPropertyRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/libraryPropertyRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("libraryTopLevelFunctionImportJsRuntime.kt")
        public void testLibraryTopLevelFunctionImportJsRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/libraryTopLevelFunctionImportJsRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("libraryTopLevelFunctionImportRuntime.kt")
        public void testLibraryTopLevelFunctionImportRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/libraryTopLevelFunctionImportRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("namelessClass.kt")
        public void testNamelessClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/namelessClass.kt");
            doTest(fileName);
        }

        @TestMetadata("namelessFunction.kt")
        public void testNamelessFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/namelessFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("namelessObject.kt")
        public void testNamelessObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/namelessObject.kt");
            doTest(fileName);
        }

        @TestMetadata("namelessParameter.kt")
        public void testNamelessParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/namelessParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("namelessProperty.kt")
        public void testNamelessProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/namelessProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("noImportForAlreadyImported.kt")
        public void testNoImportForAlreadyImported() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/noImportForAlreadyImported.kt");
            doTest(fileName);
        }

        @TestMetadata("noImportForIndex.kt")
        public void testNoImportForIndex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/noImportForIndex.kt");
            doTest(fileName);
        }

        @TestMetadata("notForThisLabel.kt")
        public void testNotForThisLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/notForThisLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("sAMConstructorFromLambda.kt")
        public void testSAMConstructorFromLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/sAMConstructorFromLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("unresolvedReferenceInCall.kt")
        public void testUnresolvedReferenceInCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/autoImports/unresolvedReferenceInCall.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/quickfix/canBeParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CanBeParameter extends AbstractQuickFixTest {
        public void testAllFilesPresentInCanBeParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/canBeParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("usedInDerivedClass.kt")
        public void testUsedInDerivedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/canBeParameter/usedInDerivedClass.kt");
            doTest(fileName);
        }

        @TestMetadata("usedInProperty.kt")
        public void testUsedInProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/canBeParameter/usedInProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("usedPrivateInInitializer.kt")
        public void testUsedPrivateInInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/canBeParameter/usedPrivateInInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("usedVarArg.kt")
        public void testUsedVarArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/canBeParameter/usedVarArg.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/canBePrimaryConstructorProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CanBePrimaryConstructorProperty extends AbstractQuickFixTest {
        public void testAllFilesPresentInCanBePrimaryConstructorProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/canBePrimaryConstructorProperty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("commentAfter.kt")
        public void testCommentAfter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/canBePrimaryConstructorProperty/commentAfter.kt");
            doTest(fileName);
        }

        @TestMetadata("commentAhead.kt")
        public void testCommentAhead() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/canBePrimaryConstructorProperty/commentAhead.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedOpenVar.kt")
        public void testProtectedOpenVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/canBePrimaryConstructorProperty/protectedOpenVar.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/canBePrimaryConstructorProperty/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/changeSignature")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeSignature extends AbstractQuickFixTest {
        @TestMetadata("addConstructorParameter.kt")
        public void testAddConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/addConstructorParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("addFunctionParameter.kt")
        public void testAddFunctionParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/addFunctionParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("addFunctionParameterAndChangeTypes.kt")
        public void testAddFunctionParameterAndChangeTypes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/addFunctionParameterAndChangeTypes.kt");
            doTest(fileName);
        }

        @TestMetadata("addFunctionParameterLongNameRuntime.kt")
        public void testAddFunctionParameterLongNameRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/addFunctionParameterLongNameRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("addNothingReturnType.kt")
        public void testAddNothingReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/addNothingReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("addParameterNotAvailableForBuiltins.kt")
        public void testAddParameterNotAvailableForBuiltins() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/addParameterNotAvailableForBuiltins.kt");
            doTest(fileName);
        }

        @TestMetadata("addParameterNotAvailableForLibrary.kt")
        public void testAddParameterNotAvailableForLibrary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/addParameterNotAvailableForLibrary.kt");
            doTest(fileName);
        }

        @TestMetadata("addParameterToFakeOverride.kt")
        public void testAddParameterToFakeOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/addParameterToFakeOverride.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInChangeSignature() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeSignature"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("changeFunctionLiteralParameters1.kt")
        public void testChangeFunctionLiteralParameters1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/changeFunctionLiteralParameters1.kt");
            doTest(fileName);
        }

        @TestMetadata("changeFunctionLiteralParameters2.kt")
        public void testChangeFunctionLiteralParameters2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/changeFunctionLiteralParameters2.kt");
            doTest(fileName);
        }

        @TestMetadata("complexHierarchy.kt")
        public void testComplexHierarchy() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/complexHierarchy.kt");
            doTest(fileName);
        }

        @TestMetadata("complexHierarchyHead.kt")
        public void testComplexHierarchyHead() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/complexHierarchyHead.kt");
            doTest(fileName);
        }

        @TestMetadata("complexHierarchyTail.kt")
        public void testComplexHierarchyTail() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/complexHierarchyTail.kt");
            doTest(fileName);
        }

        @TestMetadata("fixExtensionLambdaSignature.kt")
        public void testFixExtensionLambdaSignature() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/fixExtensionLambdaSignature.kt");
            doTest(fileName);
        }

        @TestMetadata("linearHierarchy.kt")
        public void testLinearHierarchy() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/linearHierarchy.kt");
            doTest(fileName);
        }

        @TestMetadata("notAvailableForSynthesized.kt")
        public void testNotAvailableForSynthesized() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/notAvailableForSynthesized.kt");
            doTest(fileName);
        }

        @TestMetadata("notEditable.kt")
        public void testNotEditable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/notEditable.kt");
            doTest(fileName);
        }

        @TestMetadata("removeConstructorParameter.kt")
        public void testRemoveConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeConstructorParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("removeFunctionFirstParameter.kt")
        public void testRemoveFunctionFirstParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeFunctionFirstParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("removeFunctionSecondParameter1.kt")
        public void testRemoveFunctionSecondParameter1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeFunctionSecondParameter1.kt");
            doTest(fileName);
        }

        @TestMetadata("removeFunctionSecondParameter2.kt")
        public void testRemoveFunctionSecondParameter2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeFunctionSecondParameter2.kt");
            doTest(fileName);
        }

        @TestMetadata("removeNamedParameter.kt")
        public void testRemoveNamedParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeNamedParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("removeParameterFromFakeOverride.kt")
        public void testRemoveParameterFromFakeOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeParameterFromFakeOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("removeParameterNotAvailableForBuiltins.kt")
        public void testRemoveParameterNotAvailableForBuiltins() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeParameterNotAvailableForBuiltins.kt");
            doTest(fileName);
        }

        @TestMetadata("removeUnusedExtensionParameter.kt")
        public void testRemoveUnusedExtensionParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeUnusedExtensionParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("removeUnusedParameter.kt")
        public void testRemoveUnusedParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/changeSignature/removeUnusedParameter.kt");
            doTest(fileName);
        }

    }

    @TestMetadata("idea/testData/quickfix/checkArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CheckArguments extends AbstractQuickFixTest {
        public void testAllFilesPresentInCheckArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/checkArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nonVarargSpread.kt")
        public void testNonVarargSpread() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/checkArguments/nonVarargSpread.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/quickfix/checkArguments/addNameToArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AddNameToArgument extends AbstractQuickFixTest {
            public void testAllFilesPresentInAddNameToArgument() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/checkArguments/addNameToArgument"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("invokeOnString.kt")
            public void testInvokeOnString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/checkArguments/addNameToArgument/invokeOnString.kt");
                doTest(fileName);
            }

            @TestMetadata("mixedNamedAndPositionalArguments.kt")
            public void testMixedNamedAndPositionalArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsConstructor.kt")
            public void testMixedNamedAndPositionalArgumentsConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsMultiple.kt")
            public void testMixedNamedAndPositionalArgumentsMultiple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsMultiple.kt");
                doTest(fileName);
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsSubtype.kt")
            public void testMixedNamedAndPositionalArgumentsSubtype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsSubtype.kt");
                doTest(fileName);
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsUsedNamed.kt")
            public void testMixedNamedAndPositionalArgumentsUsedNamed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsUsedNamed.kt");
                doTest(fileName);
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsUsedPositional.kt")
            public void testMixedNamedAndPositionalArgumentsUsedPositional() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsUsedPositional.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/conflictingImports")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConflictingImports extends AbstractQuickFixTest {
        public void testAllFilesPresentInConflictingImports() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/conflictingImports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("removeConflictingImport.kt")
        public void testRemoveConflictingImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/conflictingImports/removeConflictingImport.kt");
            doTest(fileName);
        }

        @TestMetadata("removeDuplicateImport.kt")
        public void testRemoveDuplicateImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/conflictingImports/removeDuplicateImport.kt");
            doTest(fileName);
        }

        @TestMetadata("removeDuplicateImportWithAlias.kt")
        public void testRemoveDuplicateImportWithAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/conflictingImports/removeDuplicateImportWithAlias.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/createFromUsage")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CreateFromUsage extends AbstractQuickFixTest {
        public void testAllFilesPresentInCreateFromUsage() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateClass extends AbstractQuickFixTest {
            public void testAllFilesPresentInCreateClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AnnotationEntry extends AbstractQuickFixTest {
                public void testAllFilesPresentInAnnotationEntry() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/annotationEntry"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationNoBrackets.kt")
                public void testAnnotationNoBrackets() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationNoBrackets.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationNoParamList.kt")
                public void testAnnotationNoParamList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationNoParamList.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationNoParams.kt")
                public void testAnnotationNoParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationNoParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationWithParams.kt")
                public void testAnnotationWithParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationWithParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationWithTypeParams.kt")
                public void testAnnotationWithTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationWithTypeParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("notAnnotation.kt")
                public void testNotAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/notAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("singleArgAnnotation.kt")
                public void testSingleArgAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/singleArgAnnotation.kt");
                    doTest(fileName);
                }

                @TestMetadata("singleNamedArgAnnotation.kt")
                public void testSingleNamedArgAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/singleNamedArgAnnotation.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallExpression extends AbstractQuickFixTest {
                public void testAllFilesPresentInCallExpression() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/callExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("callInAnnotationEntry.kt")
                public void testCallInAnnotationEntry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInAnnotationEntry.kt");
                    doTest(fileName);
                }

                @TestMetadata("callInLambda.kt")
                public void testCallInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("callInLocalFunNoReceiver.kt")
                public void testCallInLocalFunNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInLocalFunNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("callInMemberFunNoReceiver.kt")
                public void testCallInMemberFunNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInMemberFunNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("callInMemberValDelegateRuntime.kt")
                public void testCallInMemberValDelegateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInMemberValDelegateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("callInMemberVarDelegateRuntime.kt")
                public void testCallInMemberVarDelegateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInMemberVarDelegateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("callNoReceiver.kt")
                public void testCallNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithClassQualifier.kt")
                public void testCallWithClassQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithClassQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithExplicitParamNames.kt")
                public void testCallWithExplicitParamNames() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithExplicitParamNames.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithExtraArgs.kt")
                public void testCallWithExtraArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithExtraArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithFinalSupertype.kt")
                public void testCallWithFinalSupertype() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithFinalSupertype.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithGenericReceiver.kt")
                public void testCallWithGenericReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithGenericReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithLambdaArg.kt")
                public void testCallWithLambdaArg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithLambdaArg.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithLambdaArgOnly.kt")
                public void testCallWithLambdaArgOnly() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithLambdaArgOnly.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithLibClassQualifier.kt")
                public void testCallWithLibClassQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithLibClassQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithMissingArgs.kt")
                public void testCallWithMissingArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithMissingArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithObjectQualifier.kt")
                public void testCallWithObjectQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithObjectQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithPackageName.kt")
                public void testCallWithPackageName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithPackageName.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithReceiver.kt")
                public void testCallWithReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithSuperclassNoConstructorParams.kt")
                public void testCallWithSuperclassNoConstructorParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithSuperclassNoConstructorParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithSuperclassWithConstructorParams.kt")
                public void testCallWithSuperclassWithConstructorParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithSuperclassWithConstructorParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithSupertrait.kt")
                public void testCallWithSupertrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithSupertrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithThisReceiverInClass.kt")
                public void testCallWithThisReceiverInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithThisReceiverInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithThisReceiverInExtension.kt")
                public void testCallWithThisReceiverInExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithThisReceiverInExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithThisReceiverInNestedClass1.kt")
                public void testCallWithThisReceiverInNestedClass1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithThisReceiverInNestedClass1.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithThisReceiverInNestedClass2.kt")
                public void testCallWithThisReceiverInNestedClass2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithThisReceiverInNestedClass2.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithTypeArgsInAnnotationEntry.kt")
                public void testCallWithTypeArgsInAnnotationEntry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithTypeArgsInAnnotationEntry.kt");
                    doTest(fileName);
                }

                @TestMetadata("quotedName.kt")
                public void testQuotedName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/quotedName.kt");
                    doTest(fileName);
                }

                @TestMetadata("singleArgCallInAnnotationEntry.kt")
                public void testSingleArgCallInAnnotationEntry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/singleArgCallInAnnotationEntry.kt");
                    doTest(fileName);
                }

                @TestMetadata("singleNamedArgCallInAnnotationEntry.kt")
                public void testSingleNamedArgCallInAnnotationEntry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/singleNamedArgCallInAnnotationEntry.kt");
                    doTest(fileName);
                }

                @TestMetadata("unusedCallResult.kt")
                public void testUnusedCallResult() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/unusedCallResult.kt");
                    doTest(fileName);
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class TypeArguments extends AbstractQuickFixTest {
                    public void testAllFilesPresentInTypeArguments() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("callWithStarProjection.kt")
                    public void testCallWithStarProjection() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/callWithStarProjection.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classMember.kt")
                    public void testClassMember() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMember.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classMemberInner.kt")
                    public void testClassMemberInner() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMemberInner.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classMemberInnerPartialSubstitution.kt")
                    public void testClassMemberInnerPartialSubstitution() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMemberInnerPartialSubstitution.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classMemberInnerWithReceiverArg.kt")
                    public void testClassMemberInnerWithReceiverArg() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMemberInnerWithReceiverArg.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classMemberPartialSubstitution.kt")
                    public void testClassMemberPartialSubstitution() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMemberPartialSubstitution.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("extension.kt")
                    public void testExtension() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/extension.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("noReceiver.kt")
                    public void testNoReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/noReceiver.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("noReceiverExtraArgs.kt")
                    public void testNoReceiverExtraArgs() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/noReceiverExtraArgs.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("noReceiverLongName.kt")
                    public void testNoReceiverLongName() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/noReceiverLongName.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("noReceiverPartialSubstitution.kt")
                    public void testNoReceiverPartialSubstitution() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/noReceiverPartialSubstitution.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("withExpectedTypeNoReceiver.kt")
                    public void testWithExpectedTypeNoReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/withExpectedTypeNoReceiver.kt");
                        doTest(fileName);
                    }
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DelegationSpecifier extends AbstractQuickFixTest {
                public void testAllFilesPresentInDelegationSpecifier() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classDelegatorToSuperclass.kt")
                public void testClassDelegatorToSuperclass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/classDelegatorToSuperclass.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegatorToSupercallNoReceiver.kt")
                public void testDelegatorToSupercallNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegatorToSupercallWithClassQualifier.kt")
                public void testDelegatorToSupercallWithClassQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallWithClassQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegatorToSupercallWithPackageQualifier.kt")
                public void testDelegatorToSupercallWithPackageQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallWithPackageQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegatorToSupercallWithParamNames.kt")
                public void testDelegatorToSupercallWithParamNames() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallWithParamNames.kt");
                    doTest(fileName);
                }

                @TestMetadata("delegatorToSupercallWithTypeParams.kt")
                public void testDelegatorToSupercallWithTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallWithTypeParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitDelegatorToSuperclass.kt")
                public void testTraitDelegatorToSuperclass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/traitDelegatorToSuperclass.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ImportDirective extends AbstractQuickFixTest {
                public void testAllFilesPresentInImportDirective() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/importDirective"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationInPackage.kt")
                public void testAnnotationInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/annotationInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationWithQualifier.kt")
                public void testAnnotationWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/annotationWithQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("classInPackage.kt")
                public void testClassInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/classInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("classWithQualifier.kt")
                public void testClassWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/classWithQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryInEnum.kt")
                public void testEnumEntryInEnum() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumEntryInEnum.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryInPackage.kt")
                public void testEnumEntryInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumEntryInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryWithQualifier.kt")
                public void testEnumEntryWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumEntryWithQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumInPackage.kt")
                public void testEnumInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumWithQualifier.kt")
                public void testEnumWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumWithQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectInPackage.kt")
                public void testObjectInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/objectInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectWithQualifier.kt")
                public void testObjectWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/objectWithQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitInPackage.kt")
                public void testTraitInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/traitInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitWithQualifier.kt")
                public void testTraitWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/traitWithQualifier.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReferenceExpression extends AbstractQuickFixTest {
                public void testAllFilesPresentInReferenceExpression() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/referenceExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationNoReceiver.kt")
                public void testAnnotationNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/annotationNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("classByNestedQualifier.kt")
                public void testClassByNestedQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classByNestedQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("classByQualifier.kt")
                public void testClassByQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classByQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("classInPackage.kt")
                public void testClassInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("classNoReceiver.kt")
                public void testClassNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("classWithQualifier.kt")
                public void testClassWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classWithQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("classWithReceiver.kt")
                public void testClassWithReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classWithReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumByQualifier.kt")
                public void testEnumByQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumByQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryAddComma.kt")
                public void testEnumEntryAddComma() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryAddComma.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryHasComma.kt")
                public void testEnumEntryHasComma() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryHasComma.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryNoReceiver.kt")
                public void testEnumEntryNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryWithEnumQualifier.kt")
                public void testEnumEntryWithEnumQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithEnumQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryWithEnumQualifierAndParams.kt")
                public void testEnumEntryWithEnumQualifierAndParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithEnumQualifierAndParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryWithEnumSuperclass.kt")
                public void testEnumEntryWithEnumSuperclass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithEnumSuperclass.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryWithQualifier.kt")
                public void testEnumEntryWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryWithReceiver.kt")
                public void testEnumEntryWithReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryWithSuperclass.kt")
                public void testEnumEntryWithSuperclass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithSuperclass.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumNoReceiver.kt")
                public void testEnumNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectByQualifier.kt")
                public void testObjectByQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectByQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectInPackage.kt")
                public void testObjectInPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectInPackage.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectNoReceiver.kt")
                public void testObjectNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectWithQualifier.kt")
                public void testObjectWithQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectWithQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectWithReceiver.kt")
                public void testObjectWithReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectWithReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectWithSuperclass.kt")
                public void testObjectWithSuperclass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectWithSuperclass.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectWithSupertrait.kt")
                public void testObjectWithSupertrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectWithSupertrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveBound.kt")
                public void testRecursiveBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/recursiveBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitByQualifier.kt")
                public void testTraitByQualifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/traitByQualifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitNoReceiver.kt")
                public void testTraitNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/traitNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("unusedReference.kt")
                public void testUnusedReference() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/unusedReference.kt");
                    doTest(fileName);
                }

                @TestMetadata("valDelegateExpressionRuntime.kt")
                public void testValDelegateExpressionRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/valDelegateExpressionRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("varDelegateExpressionRuntime.kt")
                public void testVarDelegateExpressionRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/varDelegateExpressionRuntime.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TypeReference extends AbstractQuickFixTest {
                public void testAllFilesPresentInTypeReference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/typeReference"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationNotQualifierNoTypeArgs.kt")
                public void testAnnotationNotQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/annotationNotQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationNotQualifierWithTypeArgs.kt")
                public void testAnnotationNotQualifierWithTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/annotationNotQualifierWithTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("annotationQualifierNoTypeArgs.kt")
                public void testAnnotationQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/annotationQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("classCurrentPackageReceiver.kt")
                public void testClassCurrentPackageReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/classCurrentPackageReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("classLibTypeReceiver.kt")
                public void testClassLibTypeReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/classLibTypeReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("classNotQualifierNoTypeArgs.kt")
                public void testClassNotQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/classNotQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("classNotQualifierWithStarProjection.kt")
                public void testClassNotQualifierWithStarProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/classNotQualifierWithStarProjection.kt");
                    doTest(fileName);
                }

                @TestMetadata("classNotQualifierWithTypeArgs.kt")
                public void testClassNotQualifierWithTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/classNotQualifierWithTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("classQualifierNoTypeArgs.kt")
                public void testClassQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/classQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("classUserTypeReceiver.kt")
                public void testClassUserTypeReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/classUserTypeReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("classUserTypeReceiverNoBody.kt")
                public void testClassUserTypeReceiverNoBody() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/classUserTypeReceiverNoBody.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumEntryNotQualifierNoTypeArgs.kt")
                public void testEnumEntryNotQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/enumEntryNotQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumNotQualifierNoTypeArgs.kt")
                public void testEnumNotQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/enumNotQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("enumNotQualifierWithTypeArgs.kt")
                public void testEnumNotQualifierWithTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/enumNotQualifierWithTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedClassByTypeArgumentRefNoBody.kt")
                public void testNestedClassByTypeArgumentRefNoBody() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/nestedClassByTypeArgumentRefNoBody.kt");
                    doTest(fileName);
                }

                @TestMetadata("nestedClassByTypeArgumentRefWithBody.kt")
                public void testNestedClassByTypeArgumentRefWithBody() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/nestedClassByTypeArgumentRefWithBody.kt");
                    doTest(fileName);
                }

                @TestMetadata("noAnnotationForTypeBound.kt")
                public void testNoAnnotationForTypeBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/noAnnotationForTypeBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("noAnnotationForTypeConstraint.kt")
                public void testNoAnnotationForTypeConstraint() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/noAnnotationForTypeConstraint.kt");
                    doTest(fileName);
                }

                @TestMetadata("noEnumForTypeBound.kt")
                public void testNoEnumForTypeBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/noEnumForTypeBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("noEnumForTypeConstraint.kt")
                public void testNoEnumForTypeConstraint() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/noEnumForTypeConstraint.kt");
                    doTest(fileName);
                }

                @TestMetadata("noObjectForTypeBound.kt")
                public void testNoObjectForTypeBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/noObjectForTypeBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("noObjectForTypeConstraint.kt")
                public void testNoObjectForTypeConstraint() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/noObjectForTypeConstraint.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectNotQualifierNoTypeArgs.kt")
                public void testObjectNotQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/objectNotQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectNotQualifierWithTypeArgs.kt")
                public void testObjectNotQualifierWithTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/objectNotQualifierWithTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectQualifierNoTypeArgs.kt")
                public void testObjectQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/objectQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("traitNotQualifierNoTypeArgs.kt")
                public void testTraitNotQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference/traitNotQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateFunction extends AbstractQuickFixTest {
            public void testAllFilesPresentInCreateFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class BinaryOperations extends AbstractQuickFixTest {
                public void testAllFilesPresentInBinaryOperations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("customOperationOnUserType.kt")
                public void testCustomOperationOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/customOperationOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("greaterOrEqualOnUserType.kt")
                public void testGreaterOrEqualOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/greaterOrEqualOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("inOnUserType.kt")
                public void testInOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/inOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("lessOnUserType.kt")
                public void testLessOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/lessOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("notInOnUserType.kt")
                public void testNotInOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/notInOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("plusAssignOnUserType.kt")
                public void testPlusAssignOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusAssignOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("plusExtraArgs.kt")
                public void testPlusExtraArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusExtraArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("plusForAssignmentOnUserType.kt")
                public void testPlusForAssignmentOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusForAssignmentOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("plusMissingArgs.kt")
                public void testPlusMissingArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusMissingArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("plusOnLibType.kt")
                public void testPlusOnLibType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusOnLibType.kt");
                    doTest(fileName);
                }

                @TestMetadata("plusOnUserType.kt")
                public void testPlusOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("plusOnUserTypeWithTypeParams.kt")
                public void testPlusOnUserTypeWithTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusOnUserTypeWithTypeParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("quotedName.kt")
                public void testQuotedName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/quotedName.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeMismatch.kt")
                public void testTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/typeMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenInOnUserType.kt")
                public void testWhenInOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/whenInOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("whenNotInOnUserType.kt")
                public void testWhenNotInOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/whenNotInOnUserType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/call")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Call extends AbstractQuickFixTest {
                public void testAllFilesPresentInCall() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/call"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("approximateAnonymousObjectRuntime.kt")
                public void testApproximateAnonymousObjectRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/approximateAnonymousObjectRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("approximateLocalClassRuntime.kt")
                public void testApproximateLocalClassRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/approximateLocalClassRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("argumentTypeMismatch.kt")
                public void testArgumentTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/argumentTypeMismatch.kt");
                    doTest(fileName);
                }

                @TestMetadata("callInAnnotationEntry.kt")
                public void testCallInAnnotationEntry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/callInAnnotationEntry.kt");
                    doTest(fileName);
                }

                @TestMetadata("callInStringTemplateRuntime.kt")
                public void testCallInStringTemplateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/callInStringTemplateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithLambdaArg.kt")
                public void testCallWithLambdaArg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/callWithLambdaArg.kt");
                    doTest(fileName);
                }

                @TestMetadata("callWithLambdaArgOnly.kt")
                public void testCallWithLambdaArgOnly() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/callWithLambdaArgOnly.kt");
                    doTest(fileName);
                }

                @TestMetadata("doNotStripPrefix.kt")
                public void testDoNotStripPrefix() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/doNotStripPrefix.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionFunOnTrait.kt")
                public void testExtensionFunOnTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionFunOnTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionRefInImport.kt")
                public void testExtensionRefInImport() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionRefInImport.kt");
                    doTest(fileName);
                }

                @TestMetadata("funExtraArgs.kt")
                public void testFunExtraArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funExtraArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("funMissingArgs.kt")
                public void testFunMissingArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funMissingArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnClassNoClassObject.kt")
                public void testFunOnClassNoClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnClassNoClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnClassObject.kt")
                public void testFunOnClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnLibObject.kt")
                public void testFunOnLibObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnLibObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnLibType.kt")
                public void testFunOnLibType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnLibType.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnTrait.kt")
                public void testFunOnTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnUserObject.kt")
                public void testFunOnUserObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnUserObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnUserType.kt")
                public void testFunOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnUserTypeWithDeclarations.kt")
                public void testFunOnUserTypeWithDeclarations() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnUserTypeWithDeclarations.kt");
                    doTest(fileName);
                }

                @TestMetadata("funOnUserTypeWithTypeParams.kt")
                public void testFunOnUserTypeWithTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funOnUserTypeWithTypeParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("funPlacement.kt")
                public void testFunPlacement() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funPlacement.kt");
                    doTest(fileName);
                }

                @TestMetadata("funWithExplicitParamNamesOnUserType.kt")
                public void testFunWithExplicitParamNamesOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funWithExplicitParamNamesOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("funWithNullableParamType.kt")
                public void testFunWithNullableParamType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funWithNullableParamType.kt");
                    doTest(fileName);
                }

                @TestMetadata("funWithNullableType.kt")
                public void testFunWithNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funWithNullableType.kt");
                    doTest(fileName);
                }

                @TestMetadata("funWithNullableTypeParameter.kt")
                public void testFunWithNullableTypeParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funWithNullableTypeParameter.kt");
                    doTest(fileName);
                }

                @TestMetadata("funWithPackageName.kt")
                public void testFunWithPackageName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/funWithPackageName.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionalType.kt")
                public void testFunctionalType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/functionalType.kt");
                    doTest(fileName);
                }

                @TestMetadata("functionalTypeInReceiver.kt")
                public void testFunctionalTypeInReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/functionalTypeInReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLambda.kt")
                public void testInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/inLambda.kt");
                    doTest(fileName);
                }

                @TestMetadata("inconsistentTypes.kt")
                public void testInconsistentTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/inconsistentTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("kt10983.kt")
                public void testKt10983() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/kt10983.kt");
                    doTest(fileName);
                }

                @TestMetadata("localFunNoReceiver.kt")
                public void testLocalFunNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/localFunNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberFunNoReceiver.kt")
                public void testMemberFunNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/memberFunNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberValDelegateRuntime.kt")
                public void testMemberValDelegateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/memberValDelegateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberVarDelegateRuntime.kt")
                public void testMemberVarDelegateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/memberVarDelegateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("notExactArgument.kt")
                public void testNotExactArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/notExactArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectMemberFunNoReceiver.kt")
                public void testObjectMemberFunNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/objectMemberFunNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("privateForMembers.kt")
                public void testPrivateForMembers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/privateForMembers.kt");
                    doTest(fileName);
                }

                @TestMetadata("propertyOnUserType.kt")
                public void testPropertyOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/propertyOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("qualifiedCallInStringTemplateRuntime.kt")
                public void testQualifiedCallInStringTemplateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/qualifiedCallInStringTemplateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("refInImport.kt")
                public void testRefInImport() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/refInImport.kt");
                    doTest(fileName);
                }

                @TestMetadata("smartCastWithIs.kt")
                public void testSmartCastWithIs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/smartCastWithIs.kt");
                    doTest(fileName);
                }

                @TestMetadata("smartCastWithNullCheck.kt")
                public void testSmartCastWithNullCheck() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/smartCastWithNullCheck.kt");
                    doTest(fileName);
                }

                @TestMetadata("stripPrefix.kt")
                public void testStripPrefix() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/stripPrefix.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInClass.kt")
                public void testThisInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/thisInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInExtension.kt")
                public void testThisInExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/thisInExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInNestedClass1.kt")
                public void testThisInNestedClass1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/thisInNestedClass1.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInNestedClass2.kt")
                public void testThisInNestedClass2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/thisInNestedClass2.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelFunNoReceiver.kt")
                public void testTopLevelFunNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/topLevelFunNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelFunPlacement.kt")
                public void testTopLevelFunPlacement() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/topLevelFunPlacement.kt");
                    doTest(fileName);
                }

                @TestMetadata("unitFun.kt")
                public void testUnitFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/unitFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("unknownType.kt")
                public void testUnknownType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/unknownType.kt");
                    doTest(fileName);
                }

                @TestMetadata("unresolvedSupertype.kt")
                public void testUnresolvedSupertype() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/unresolvedSupertype.kt");
                    doTest(fileName);
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/abstract")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Abstract extends AbstractQuickFixTest {
                    public void testAllFilesPresentInAbstract() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/call/abstract"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("classNoExplicitReceiver.kt")
                    public void testClassNoExplicitReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/classNoExplicitReceiver.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("explicitReceiverOfContainingClass.kt")
                    public void testExplicitReceiverOfContainingClass() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/explicitReceiverOfContainingClass.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("interfaceNoExplicitReceiver.kt")
                    public void testInterfaceNoExplicitReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/interfaceNoExplicitReceiver.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("notAbstractClass.kt")
                    public void testNotAbstractClass() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/notAbstractClass.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("otherExplicitReceiver.kt")
                    public void testOtherExplicitReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/otherExplicitReceiver.kt");
                        doTest(fileName);
                    }
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ExtensionByExtensionReceiver extends AbstractQuickFixTest {
                    public void testAllFilesPresentInExtensionByExtensionReceiver() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("extensionFunction.kt")
                    public void testExtensionFunction() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/extensionFunction.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("extensionLambda.kt")
                    public void testExtensionLambda() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/extensionLambda.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("extensionPropertyGetter.kt")
                    public void testExtensionPropertyGetter() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/extensionPropertyGetter.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("extensionPropertySetter.kt")
                    public void testExtensionPropertySetter() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/extensionPropertySetter.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("notExtensionCallable.kt")
                    public void testNotExtensionCallable() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/notExtensionCallable.kt");
                        doTest(fileName);
                    }
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class TypeArguments extends AbstractQuickFixTest {
                    public void testAllFilesPresentInTypeArguments() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("callWithStarProjection.kt")
                    public void testCallWithStarProjection() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/callWithStarProjection.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classMember.kt")
                    public void testClassMember() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/classMember.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classMemberPartialSubstitution.kt")
                    public void testClassMemberPartialSubstitution() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/classMemberPartialSubstitution.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("classMemberWithReceiverArg.kt")
                    public void testClassMemberWithReceiverArg() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/classMemberWithReceiverArg.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("extension.kt")
                    public void testExtension() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/extension.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("extensionPartialSubstitution.kt")
                    public void testExtensionPartialSubstitution() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/extensionPartialSubstitution.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("extensionWithReceiverArg.kt")
                    public void testExtensionWithReceiverArg() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/extensionWithReceiverArg.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("extensionWithTypeParameterAsReceiver.kt")
                    public void testExtensionWithTypeParameterAsReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/extensionWithTypeParameterAsReceiver.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("memberWithTypeParameterAsReceiver.kt")
                    public void testMemberWithTypeParameterAsReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/memberWithTypeParameterAsReceiver.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("noReceiver.kt")
                    public void testNoReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/noReceiver.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("noReceiverExtraArgs.kt")
                    public void testNoReceiverExtraArgs() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/noReceiverExtraArgs.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("noReceiverLongName.kt")
                    public void testNoReceiverLongName() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/noReceiverLongName.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("noReceiverPartialSubstitution.kt")
                    public void testNoReceiverPartialSubstitution() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/noReceiverPartialSubstitution.kt");
                        doTest(fileName);
                    }
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/callableReferences")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallableReferences extends AbstractQuickFixTest {
                public void testAllFilesPresentInCallableReferences() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/callableReferences"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("extensionNoReceiverInCallableRef.kt")
                public void testExtensionNoReceiverInCallableRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/extensionNoReceiverInCallableRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionWithReceiverInCallableRef.kt")
                public void testExtensionWithReceiverInCallableRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/extensionWithReceiverInCallableRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("noExpectedReturnType.kt")
                public void testNoExpectedReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/noExpectedReturnType.kt");
                    doTest(fileName);
                }

                @TestMetadata("noFunctionalType.kt")
                public void testNoFunctionalType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/noFunctionalType.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonExtensionWithReceiverInCallableRef.kt")
                public void testNonExtensionWithReceiverInCallableRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/nonExtensionWithReceiverInCallableRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("withExpectedReturnType.kt")
                public void testWithExpectedReturnType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/withExpectedReturnType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/component")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Component extends AbstractQuickFixTest {
                public void testAllFilesPresentInComponent() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/component"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createComponentFromUsage1.kt")
                public void testCreateComponentFromUsage1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/component/createComponentFromUsage1.kt");
                    doTest(fileName);
                }

                @TestMetadata("createComponentFromUsage2.kt")
                public void testCreateComponentFromUsage2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/component/createComponentFromUsage2.kt");
                    doTest(fileName);
                }

                @TestMetadata("createComponentFromUsage3.kt")
                public void testCreateComponentFromUsage3() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/component/createComponentFromUsage3.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DelegateAccessors extends AbstractQuickFixTest {
                public void testAllFilesPresentInDelegateAccessors() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("val.kt")
                public void testVal() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/val.kt");
                    doTest(fileName);
                }

                @TestMetadata("var.kt")
                public void testVar() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/var.kt");
                    doTest(fileName);
                }

                @TestMetadata("varMissingGet.kt")
                public void testVarMissingGet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/varMissingGet.kt");
                    doTest(fileName);
                }

                @TestMetadata("varMissingSet.kt")
                public void testVarMissingSet() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/varMissingSet.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/get")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Get extends AbstractQuickFixTest {
                public void testAllFilesPresentInGet() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/get"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createGetFromUsage1.kt")
                public void testCreateGetFromUsage1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage1.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage10.kt")
                public void testCreateGetFromUsage10() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage10.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage11.kt")
                public void testCreateGetFromUsage11() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage11.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage12.kt")
                public void testCreateGetFromUsage12() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage12.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage13.kt")
                public void testCreateGetFromUsage13() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage13.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage2.kt")
                public void testCreateGetFromUsage2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage2.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage3.kt")
                public void testCreateGetFromUsage3() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage3.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage4.kt")
                public void testCreateGetFromUsage4() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage4.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage5.kt")
                public void testCreateGetFromUsage5() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage5.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage7.kt")
                public void testCreateGetFromUsage7() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage7.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage8.kt")
                public void testCreateGetFromUsage8() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage8.kt");
                    doTest(fileName);
                }

                @TestMetadata("createGetFromUsage9.kt")
                public void testCreateGetFromUsage9() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage9.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeMismatch.kt")
                public void testTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/get/typeMismatch.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/hasNext")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class HasNext extends AbstractQuickFixTest {
                public void testAllFilesPresentInHasNext() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/hasNext"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createHasNextFromUsage1.kt")
                public void testCreateHasNextFromUsage1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/hasNext/createHasNextFromUsage1.kt");
                    doTest(fileName);
                }

                @TestMetadata("createHasNextFromUsage2.kt")
                public void testCreateHasNextFromUsage2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/hasNext/createHasNextFromUsage2.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/invoke")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invoke extends AbstractQuickFixTest {
                public void testAllFilesPresentInInvoke() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/invoke"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("invokeOnLibType.kt")
                public void testInvokeOnLibType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/invoke/invokeOnLibType.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeOnUserType.kt")
                public void testInvokeOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/invoke/invokeOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeOnUserTypeWithTypeParams.kt")
                public void testInvokeOnUserTypeWithTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/invoke/invokeOnUserTypeWithTypeParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("invokeWithExplicitParamNamesOnUserType.kt")
                public void testInvokeWithExplicitParamNamesOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/invoke/invokeWithExplicitParamNamesOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("lambdaArgument.kt")
                public void testLambdaArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/invoke/lambdaArgument.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/iterator")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Iterator extends AbstractQuickFixTest {
                public void testAllFilesPresentInIterator() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/iterator"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createIteratorFromUsage1.kt")
                public void testCreateIteratorFromUsage1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/iterator/createIteratorFromUsage1.kt");
                    doTest(fileName);
                }

                @TestMetadata("createIteratorFromUsage2.kt")
                public void testCreateIteratorFromUsage2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/iterator/createIteratorFromUsage2.kt");
                    doTest(fileName);
                }

                @TestMetadata("createIteratorFromUsage3.kt")
                public void testCreateIteratorFromUsage3() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/iterator/createIteratorFromUsage3.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/next")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Next extends AbstractQuickFixTest {
                public void testAllFilesPresentInNext() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/next"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createNextFromUsage1.kt")
                public void testCreateNextFromUsage1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/next/createNextFromUsage1.kt");
                    doTest(fileName);
                }

                @TestMetadata("createNextFromUsage2.kt")
                public void testCreateNextFromUsage2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/next/createNextFromUsage2.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/set")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Set extends AbstractQuickFixTest {
                public void testAllFilesPresentInSet() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/set"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createSetFromUsage1.kt")
                public void testCreateSetFromUsage1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/set/createSetFromUsage1.kt");
                    doTest(fileName);
                }

                @TestMetadata("createSetFromUsage2.kt")
                public void testCreateSetFromUsage2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/set/createSetFromUsage2.kt");
                    doTest(fileName);
                }

                @TestMetadata("setterForIncrement.kt")
                public void testSetterForIncrement() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/set/setterForIncrement.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeMismatch.kt")
                public void testTypeMismatch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/set/typeMismatch.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UnaryOperations extends AbstractQuickFixTest {
                public void testAllFilesPresentInUnaryOperations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("incOnUserType.kt")
                public void testIncOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/incOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("minusMissingArgs.kt")
                public void testMinusMissingArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/minusMissingArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("minusOnLibType.kt")
                public void testMinusOnLibType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/minusOnLibType.kt");
                    doTest(fileName);
                }

                @TestMetadata("minusOnUserType.kt")
                public void testMinusOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/minusOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("minusOnUserTypeWithTypeParams.kt")
                public void testMinusOnUserTypeWithTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/minusOnUserTypeWithTypeParams.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateSecondaryConstructor extends AbstractQuickFixTest {
            public void testAllFilesPresentInCreateSecondaryConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createSecondaryConstructor"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("argumentTypeMismatch.kt")
            public void testArgumentTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/argumentTypeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("callWithExpectedType.kt")
            public void testCallWithExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/callWithExpectedType.kt");
                doTest(fileName);
            }

            @TestMetadata("callWithTypeArguments.kt")
            public void testCallWithTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/callWithTypeArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("classWithBody.kt")
            public void testClassWithBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/classWithBody.kt");
                doTest(fileName);
            }

            @TestMetadata("classWithoutBody.kt")
            public void testClassWithoutBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/classWithoutBody.kt");
                doTest(fileName);
            }

            @TestMetadata("delegatorToSuperCall.kt")
            public void testDelegatorToSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/delegatorToSuperCall.kt");
                doTest(fileName);
            }

            @TestMetadata("delegatorToSuperCallNoClass.kt")
            public void testDelegatorToSuperCallNoClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/delegatorToSuperCallNoClass.kt");
                doTest(fileName);
            }

            @TestMetadata("noParametersImplicitSuperCall.kt")
            public void testNoParametersImplicitSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/noParametersImplicitSuperCall.kt");
                doTest(fileName);
            }

            @TestMetadata("noParametersSuperCall.kt")
            public void testNoParametersSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/noParametersSuperCall.kt");
                doTest(fileName);
            }

            @TestMetadata("noParametersThisCall.kt")
            public void testNoParametersThisCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/noParametersThisCall.kt");
                doTest(fileName);
            }

            @TestMetadata("noneApplicable.kt")
            public void testNoneApplicable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/noneApplicable.kt");
                doTest(fileName);
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/superCall.kt");
                doTest(fileName);
            }

            @TestMetadata("superCallNoClass.kt")
            public void testSuperCallNoClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/superCallNoClass.kt");
                doTest(fileName);
            }

            @TestMetadata("thisCall.kt")
            public void testThisCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/thisCall.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongExpectedType.kt")
            public void testWrongExpectedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/wrongExpectedType.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateTypeAlias extends AbstractQuickFixTest {
            public void testAllFilesPresentInCreateTypeAlias() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createTypeAlias"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TypeReference extends AbstractQuickFixTest {
                public void testAllFilesPresentInTypeReference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("currentPackageReceiver.kt")
                public void testCurrentPackageReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/currentPackageReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("libTypeReceiver.kt")
                public void testLibTypeReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/libTypeReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("notQualifierNoTypeArgs.kt")
                public void testNotQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/notQualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("notQualifierWithStarProjection.kt")
                public void testNotQualifierWithStarProjection() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/notQualifierWithStarProjection.kt");
                    doTest(fileName);
                }

                @TestMetadata("notQualifierWithTypeArgs.kt")
                public void testNotQualifierWithTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/notQualifierWithTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("qualifierNoTypeArgs.kt")
                public void testQualifierNoTypeArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/qualifierNoTypeArgs.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveTypeBound1.kt")
                public void testRecursiveTypeBound1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/recursiveTypeBound1.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveTypeBound2.kt")
                public void testRecursiveTypeBound2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/recursiveTypeBound2.kt");
                    doTest(fileName);
                }

                @TestMetadata("typeParameterDependency.kt")
                public void testTypeParameterDependency() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/typeParameterDependency.kt");
                    doTest(fileName);
                }

                @TestMetadata("userTypeReceiver.kt")
                public void testUserTypeReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/userTypeReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("userTypeReceiverNoBody.kt")
                public void testUserTypeReceiverNoBody() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/userTypeReceiverNoBody.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateTypeParameter extends AbstractQuickFixTest {
            public void testAllFilesPresentInCreateTypeParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createTypeParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classNoExplication.kt")
            public void testClassNoExplication() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/classNoExplication.kt");
                doTest(fileName);
            }

            @TestMetadata("classWithExplication.kt")
            public void testClassWithExplication() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/classWithExplication.kt");
                doTest(fileName);
            }

            @TestMetadata("classWithExplicationAndRecursiveUpperBound.kt")
            public void testClassWithExplicationAndRecursiveUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/classWithExplicationAndRecursiveUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("classWithExplicationAndUpperBound.kt")
            public void testClassWithExplicationAndUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/classWithExplicationAndUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("functionNoExplication.kt")
            public void testFunctionNoExplication() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/functionNoExplication.kt");
                doTest(fileName);
            }

            @TestMetadata("functionWithExplication.kt")
            public void testFunctionWithExplication() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/functionWithExplication.kt");
                doTest(fileName);
            }

            @TestMetadata("functionWithExplicationAndRecursiveUpperBound.kt")
            public void testFunctionWithExplicationAndRecursiveUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/functionWithExplicationAndRecursiveUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("functionWithExplicationAndUpperBound.kt")
            public void testFunctionWithExplicationAndUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/functionWithExplicationAndUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifiedType.kt")
            public void testQualifiedType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/qualifiedType.kt");
                doTest(fileName);
            }

            @TestMetadata("typeQualifier.kt")
            public void testTypeQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/typeQualifier.kt");
                doTest(fileName);
            }

            @TestMetadata("withTypeArguments.kt")
            public void testWithTypeArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/withTypeArguments.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateVariable extends AbstractQuickFixTest {
            public void testAllFilesPresentInCreateVariable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class LocalVariable extends AbstractQuickFixTest {
                public void testAllFilesPresentInLocalVariable() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/localVariable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("assignedInFun.kt")
                public void testAssignedInFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/assignedInFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("callableRef.kt")
                public void testCallableRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/callableRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessor.kt")
                public void testInAccessor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inAccessor.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessorWithExpressionBody.kt")
                public void testInAccessorWithExpressionBody() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inAccessorWithExpressionBody.kt");
                    doTest(fileName);
                }

                @TestMetadata("inBinaryOperation.kt")
                public void testInBinaryOperation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inBinaryOperation.kt");
                    doTest(fileName);
                }

                @TestMetadata("inClass.kt")
                public void testInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inFun.kt")
                public void testInFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("inFunWithExpressionBody.kt")
                public void testInFunWithExpressionBody() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inFunWithExpressionBody.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLabelRef.kt")
                public void testInLabelRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inLabelRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLambdaNoParams.kt")
                public void testInLambdaNoParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inLambdaNoParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLambdaWithParams.kt")
                public void testInLambdaWithParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inLambdaWithParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("inMultiLineLambdaNoParams.kt")
                public void testInMultiLineLambdaNoParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inMultiLineLambdaNoParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("inMultiLineLambdaWithParams.kt")
                public void testInMultiLineLambdaWithParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inMultiLineLambdaWithParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("inWhen.kt")
                public void testInWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inWhen.kt");
                    doTest(fileName);
                }

                @TestMetadata("localWithPackageName.kt")
                public void testLocalWithPackageName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/localWithPackageName.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonIdentifier.kt")
                public void testNonIdentifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/nonIdentifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("nullableType.kt")
                public void testNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/nullableType.kt");
                    doTest(fileName);
                }

                @TestMetadata("onTopLevel.kt")
                public void testOnTopLevel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/onTopLevel.kt");
                    doTest(fileName);
                }

                @TestMetadata("positionNextToUsage.kt")
                public void testPositionNextToUsage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/positionNextToUsage.kt");
                    doTest(fileName);
                }

                @TestMetadata("qualifiedInFun.kt")
                public void testQualifiedInFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/qualifiedInFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("unitTypedInFun.kt")
                public void testUnitTypedInFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable/unitTypedInFun.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Parameter extends AbstractQuickFixTest {
                public void testAllFilesPresentInParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/parameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("assignedInFun.kt")
                public void testAssignedInFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/assignedInFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("assignedInFunInClass.kt")
                public void testAssignedInFunInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/assignedInFunInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("callableRef.kt")
                public void testCallableRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/callableRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessorInClass.kt")
                public void testInAccessorInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessorInClassObject.kt")
                public void testInAccessorInClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessorInGenClass.kt")
                public void testInAccessorInGenClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInGenClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessorInObject.kt")
                public void testInAccessorInObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessorInTrait.kt")
                public void testInAccessorInTrait() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInTrait.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessorNoClass.kt")
                public void testInAccessorNoClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorNoClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAccessorWithExpressionBodyInClass.kt")
                public void testInAccessorWithExpressionBodyInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorWithExpressionBodyInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAnonymousObject.kt")
                public void testInAnonymousObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAnonymousObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("inAnonymousObjectInSecondaryConstructor.kt")
                public void testInAnonymousObjectInSecondaryConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAnonymousObjectInSecondaryConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("inBinaryOperation.kt")
                public void testInBinaryOperation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inBinaryOperation.kt");
                    doTest(fileName);
                }

                @TestMetadata("inClassInitializer.kt")
                public void testInClassInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inClassInitializer.kt");
                    doTest(fileName);
                }

                @TestMetadata("inClassObjectInitializer.kt")
                public void testInClassObjectInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inClassObjectInitializer.kt");
                    doTest(fileName);
                }

                @TestMetadata("inFun.kt")
                public void testInFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("inFunInClass.kt")
                public void testInFunInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inFunInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inFunInGenClass.kt")
                public void testInFunInGenClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inFunInGenClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inGenAccessorInClass.kt")
                public void testInGenAccessorInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inGenAccessorInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inGenAccessorInGenClass.kt")
                public void testInGenAccessorInGenClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inGenAccessorInGenClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inGenFunInClass.kt")
                public void testInGenFunInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inGenFunInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inGenFunInGenClass.kt")
                public void testInGenFunInGenClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inGenFunInGenClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLabelRef.kt")
                public void testInLabelRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLabelRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLambdaNoParams.kt")
                public void testInLambdaNoParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLambdaNoParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLambdaWithIt.kt")
                public void testInLambdaWithIt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLambdaWithIt.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLambdaWithParams.kt")
                public void testInLambdaWithParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLambdaWithParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLambdaWithTypedParams.kt")
                public void testInLambdaWithTypedParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLambdaWithTypedParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("inMultiLineLambdaNoParams.kt")
                public void testInMultiLineLambdaNoParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inMultiLineLambdaNoParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializerInClass.kt")
                public void testInPropertyInitializerInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializerInClassObject.kt")
                public void testInPropertyInitializerInClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializerInEnumClass.kt")
                public void testInPropertyInitializerInEnumClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInEnumClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializerInEnumEntry.kt")
                public void testInPropertyInitializerInEnumEntry() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInEnumEntry.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializerInGenClass.kt")
                public void testInPropertyInitializerInGenClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInGenClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializerInNestedClass.kt")
                public void testInPropertyInitializerInNestedClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInNestedClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializerInObject.kt")
                public void testInPropertyInitializerInObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializerNoClass.kt")
                public void testInPropertyInitializerNoClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerNoClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("inSecondaryConstructor.kt")
                public void testInSecondaryConstructor() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/inSecondaryConstructor.kt");
                    doTest(fileName);
                }

                @TestMetadata("namedArgInConstructorCall.kt")
                public void testNamedArgInConstructorCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/namedArgInConstructorCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("namedArgInFunctionCall.kt")
                public void testNamedArgInFunctionCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/namedArgInFunctionCall.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonIdentifier.kt")
                public void testNonIdentifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/nonIdentifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("nullableType.kt")
                public void testNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/nullableType.kt");
                    doTest(fileName);
                }

                @TestMetadata("parameterFromClassDelegationSpecifier.kt")
                public void testParameterFromClassDelegationSpecifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/parameterFromClassDelegationSpecifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("parameterFromEnumEntryDelegationSpecifier.kt")
                public void testParameterFromEnumEntryDelegationSpecifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/parameterFromEnumEntryDelegationSpecifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("parameterFromObjectDelegationSpecifier.kt")
                public void testParameterFromObjectDelegationSpecifier() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/parameterFromObjectDelegationSpecifier.kt");
                    doTest(fileName);
                }

                @TestMetadata("qualifiedInFun.kt")
                public void testQualifiedInFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/qualifiedInFun.kt");
                    doTest(fileName);
                }

                @TestMetadata("quotedName.kt")
                public void testQuotedName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/quotedName.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveBound.kt")
                public void testRecursiveBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/recursiveBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("withPackageName.kt")
                public void testWithPackageName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/withPackageName.kt");
                    doTest(fileName);
                }

                @TestMetadata("wrongReceiver.kt")
                public void testWrongReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter/wrongReceiver.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PrimaryParameter extends AbstractQuickFixTest {
                public void testAllFilesPresentInPrimaryParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("localValNoReceiver.kt")
                public void testLocalValNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/localValNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberValNoReceiver.kt")
                public void testMemberValNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/memberValNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberVarNoReceiver.kt")
                public void testMemberVarNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/memberVarNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectMemberValNoReceiver.kt")
                public void testObjectMemberValNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/objectMemberValNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInClass.kt")
                public void testThisInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/thisInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInExtension.kt")
                public void testThisInExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/thisInExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInNestedClass1.kt")
                public void testThisInNestedClass1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/thisInNestedClass1.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInNestedClass2.kt")
                public void testThisInNestedClass2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/thisInNestedClass2.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelValNoReceiver.kt")
                public void testTopLevelValNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/topLevelValNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnCompanionObject.kt")
                public void testValOnCompanionObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/valOnCompanionObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnLibType.kt")
                public void testValOnLibType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/valOnLibType.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnUserType.kt")
                public void testValOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/valOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("varOnUserType.kt")
                public void testVarOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/varOnUserType.kt");
                    doTest(fileName);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/property")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Property extends AbstractQuickFixTest {
                public void testAllFilesPresentInProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/property"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("callOnUserType.kt")
                public void testCallOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/callOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("callableRef.kt")
                public void testCallableRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/callableRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionRefInImport.kt")
                public void testExtensionRefInImport() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/extensionRefInImport.kt");
                    doTest(fileName);
                }

                @TestMetadata("extensionWithTypeParameterAsReceiver.kt")
                public void testExtensionWithTypeParameterAsReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/extensionWithTypeParameterAsReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("inBinaryOperation.kt")
                public void testInBinaryOperation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/inBinaryOperation.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLabelRef.kt")
                public void testInLabelRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/inLabelRef.kt");
                    doTest(fileName);
                }

                @TestMetadata("inconsistentTypes.kt")
                public void testInconsistentTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/inconsistentTypes.kt");
                    doTest(fileName);
                }

                @TestMetadata("localValDelegateRuntime.kt")
                public void testLocalValDelegateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/localValDelegateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("localValNoReceiver.kt")
                public void testLocalValNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/localValNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberValDelegateRuntime.kt")
                public void testMemberValDelegateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/memberValDelegateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberValNoReceiver.kt")
                public void testMemberValNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/memberValNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberVarDelegateRuntime.kt")
                public void testMemberVarDelegateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/memberVarDelegateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("memberWithTypeParameterAsReceiver.kt")
                public void testMemberWithTypeParameterAsReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/memberWithTypeParameterAsReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("nonAbstractInInterface.kt")
                public void testNonAbstractInInterface() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/nonAbstractInInterface.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectMemberValNoReceiver.kt")
                public void testObjectMemberValNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/objectMemberValNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("privateForMembers.kt")
                public void testPrivateForMembers() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/privateForMembers.kt");
                    doTest(fileName);
                }

                @TestMetadata("qualifiedRefInStringTemplateRuntime.kt")
                public void testQualifiedRefInStringTemplateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/qualifiedRefInStringTemplateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("quotedName.kt")
                public void testQuotedName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/quotedName.kt");
                    doTest(fileName);
                }

                @TestMetadata("recursiveBound.kt")
                public void testRecursiveBound() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/recursiveBound.kt");
                    doTest(fileName);
                }

                @TestMetadata("refInImport.kt")
                public void testRefInImport() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/refInImport.kt");
                    doTest(fileName);
                }

                @TestMetadata("refInStringTemplateRuntime.kt")
                public void testRefInStringTemplateRuntime() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/refInStringTemplateRuntime.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInClass.kt")
                public void testThisInClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/thisInClass.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInExtension.kt")
                public void testThisInExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/thisInExtension.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInNestedClass1.kt")
                public void testThisInNestedClass1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/thisInNestedClass1.kt");
                    doTest(fileName);
                }

                @TestMetadata("thisInNestedClass2.kt")
                public void testThisInNestedClass2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/thisInNestedClass2.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelValNoReceiver.kt")
                public void testTopLevelValNoReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/topLevelValNoReceiver.kt");
                    doTest(fileName);
                }

                @TestMetadata("topLevelValWithPackageName.kt")
                public void testTopLevelValWithPackageName() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/topLevelValWithPackageName.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnClassNoClassObject.kt")
                public void testValOnClassNoClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/valOnClassNoClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnClassObject.kt")
                public void testValOnClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/valOnClassObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnLibObject.kt")
                public void testValOnLibObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/valOnLibObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnLibType.kt")
                public void testValOnLibType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/valOnLibType.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnUserObject.kt")
                public void testValOnUserObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/valOnUserObject.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnUserType.kt")
                public void testValOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/valOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("valOnUserTypeWithTypeParams.kt")
                public void testValOnUserTypeWithTypeParams() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/valOnUserTypeWithTypeParams.kt");
                    doTest(fileName);
                }

                @TestMetadata("valWithNullableType.kt")
                public void testValWithNullableType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/valWithNullableType.kt");
                    doTest(fileName);
                }

                @TestMetadata("varOnLibType.kt")
                public void testVarOnLibType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/varOnLibType.kt");
                    doTest(fileName);
                }

                @TestMetadata("varOnUserType.kt")
                public void testVarOnUserType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/varOnUserType.kt");
                    doTest(fileName);
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/abstract")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Abstract extends AbstractQuickFixTest {
                    public void testAllFilesPresentInAbstract() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/property/abstract"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("classNoExplicitReceiver.kt")
                    public void testClassNoExplicitReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/classNoExplicitReceiver.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("explicitReceiverOfContainingClass.kt")
                    public void testExplicitReceiverOfContainingClass() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/explicitReceiverOfContainingClass.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("interfaceNoExplicitReceiver.kt")
                    public void testInterfaceNoExplicitReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/interfaceNoExplicitReceiver.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("notAbstractClass.kt")
                    public void testNotAbstractClass() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/notAbstractClass.kt");
                        doTest(fileName);
                    }

                    @TestMetadata("otherExplicitReceiver.kt")
                    public void testOtherExplicitReceiver() throws Exception {
                        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/otherExplicitReceiver.kt");
                        doTest(fileName);
                    }
                }
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/decreaseVisibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DecreaseVisibility extends AbstractQuickFixTest {
        public void testAllFilesPresentInDecreaseVisibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/decreaseVisibility"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("exposedParameterType.kt")
        public void testExposedParameterType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedParameterType.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedPropertyType.kt")
        public void testExposedPropertyType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedPropertyType.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedReceiverType.kt")
        public void testExposedReceiverType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedReceiverType.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedReturnType.kt")
        public void testExposedReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperClass.kt")
        public void testExposedSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedSuperClass.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperClassProtectedBase.kt")
        public void testExposedSuperClassProtectedBase() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedSuperClassProtectedBase.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperClassProtectedInAnother.kt")
        public void testExposedSuperClassProtectedInAnother() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedSuperClassProtectedInAnother.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperInterface.kt")
        public void testExposedSuperInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedSuperInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperInterfacePrivate.kt")
        public void testExposedSuperInterfacePrivate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedSuperInterfacePrivate.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedTypeParameterBound.kt")
        public void testExposedTypeParameterBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/decreaseVisibility/exposedTypeParameterBound.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeprecatedSymbolUsage extends AbstractQuickFixTest {
        @TestMetadata("addImplicitReceiverNested.kt")
        public void testAddImplicitReceiverNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/addImplicitReceiverNested.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInDeprecatedSymbolUsage() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callChainBug.kt")
        public void testCallChainBug() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/callChainBug.kt");
            doTest(fileName);
        }

        @TestMetadata("callWithError.kt")
        public void testCallWithError() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/callWithError.kt");
            doTest(fileName);
        }

        @TestMetadata("changeThis1.kt")
        public void testChangeThis1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/changeThis1.kt");
            doTest(fileName);
        }

        @TestMetadata("changeThis2.kt")
        public void testChangeThis2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/changeThis2.kt");
            doTest(fileName);
        }

        @TestMetadata("changeThisToOuterThis.kt")
        public void testChangeThisToOuterThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/changeThisToOuterThis.kt");
            doTest(fileName);
        }

        @TestMetadata("classLiteralAndTypeArgsRuntime.kt")
        public void testClassLiteralAndTypeArgsRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classLiteralAndTypeArgsRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("deprecationLevel.kt")
        public void testDeprecationLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/deprecationLevel.kt");
            doTest(fileName);
        }

        @TestMetadata("doNotShortenUserReferences.kt")
        public void testDoNotShortenUserReferences() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/doNotShortenUserReferences.kt");
            doTest(fileName);
        }

        @TestMetadata("doNotShortenUsersExplicitThis.kt")
        public void testDoNotShortenUsersExplicitThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/doNotShortenUsersExplicitThis.kt");
            doTest(fileName);
        }

        @TestMetadata("dropReceiver.kt")
        public void testDropReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/dropReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionForGenericClass.kt")
        public void testExtensionForGenericClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/extensionForGenericClass.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitCompanionObjectThis.kt")
        public void testImplicitCompanionObjectThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/implicitCompanionObjectThis.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitQualifiedThisRuntime.kt")
        public void testImplicitQualifiedThisRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/implicitQualifiedThisRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("incorrectArgs.kt")
        public void testIncorrectArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/incorrectArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("incorrectReplacement.kt")
        public void testIncorrectReplacement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/incorrectReplacement.kt");
            doTest(fileName);
        }

        @TestMetadata("infixCall.kt")
        public void testInfixCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/infixCall.kt");
            doTest(fileName);
        }

        @TestMetadata("keepArgumentNamed.kt")
        public void testKeepArgumentNamed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepArgumentNamed.kt");
            doTest(fileName);
        }

        @TestMetadata("keepInfixCall.kt")
        public void testKeepInfixCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepInfixCall.kt");
            doTest(fileName);
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/localFun.kt");
            doTest(fileName);
        }

        @TestMetadata("mailformedExpression.kt")
        public void testMailformedExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/mailformedExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("memberFunction.kt")
        public void testMemberFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/memberFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("memberFunctionImplicitReceiver.kt")
        public void testMemberFunctionImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/memberFunctionImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("memberFunctionInGenericClass.kt")
        public void testMemberFunctionInGenericClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/memberFunctionInGenericClass.kt");
            doTest(fileName);
        }

        @TestMetadata("methodToProperty.kt")
        public void testMethodToProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/methodToProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("noReplacement.kt")
        public void testNoReplacement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/noReplacement.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorCall.kt")
        public void testOperatorCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/operatorCall.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorCall2.kt")
        public void testOperatorCall2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/operatorCall2.kt");
            doTest(fileName);
        }

        @TestMetadata("parameters.kt")
        public void testParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/parameters.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyToMethod.kt")
        public void testPropertyToMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/propertyToMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyToSyntheticExtension.kt")
        public void testPropertyToSyntheticExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/propertyToSyntheticExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceCallWithArgument.kt")
        public void testReplaceCallWithArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/replaceCallWithArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("replaceCallWithReceiver.kt")
        public void testReplaceCallWithReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/replaceCallWithReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("shortenReferences.kt")
        public void testShortenReferences() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/shortenReferences.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("stringTemplate.kt")
        public void testStringTemplate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/stringTemplate.kt");
            doTest(fileName);
        }

        @TestMetadata("toOuterClassMethod.kt")
        public void testToOuterClassMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/toOuterClassMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("twoValuesCombined.kt")
        public void testTwoValuesCombined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/twoValuesCombined.kt");
            doTest(fileName);
        }

        @TestMetadata("usageInDerivedClass.kt")
        public void testUsageInDerivedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/usageInDerivedClass.kt");
            doTest(fileName);
        }

        @TestMetadata("usageInDerivedClassGeneric.kt")
        public void testUsageInDerivedClassGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/usageInDerivedClassGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ArgumentSideEffects extends AbstractQuickFixTest {
            public void testAllFilesPresentInArgumentSideEffects() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("complexExpressionNotUsed1.kt")
            public void testComplexExpressionNotUsed1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed1.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionNotUsed2.kt")
            public void testComplexExpressionNotUsed2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed2.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionNotUsed3Runtime.kt")
            public void testComplexExpressionNotUsed3Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed3Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionNotUsed4Runtime.kt")
            public void testComplexExpressionNotUsed4Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed4Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionNotUsed5Runtime.kt")
            public void testComplexExpressionNotUsed5Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed5Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionNotUsedSafeCall.kt")
            public void testComplexExpressionNotUsedSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsedSafeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionNotUsedSafeCall2Runtime.kt")
            public void testComplexExpressionNotUsedSafeCall2Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsedSafeCall2Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionNotUsedShortenRefsRuntime.kt")
            public void testComplexExpressionNotUsedShortenRefsRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsedShortenRefsRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionUsedTwice.kt")
            public void testComplexExpressionUsedTwice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionUsedTwice2.kt")
            public void testComplexExpressionUsedTwice2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice2.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionUsedTwice3Runtime.kt")
            public void testComplexExpressionUsedTwice3Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice3Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionUsedTwice4.kt")
            public void testComplexExpressionUsedTwice4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice4.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionUsedTwice5Runtime.kt")
            public void testComplexExpressionUsedTwice5Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice5Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("complexExpressionUsedTwice6Runtime.kt")
            public void testComplexExpressionUsedTwice6Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice6Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleExpressionNotUsed.kt")
            public void testSimpleExpressionNotUsed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/simpleExpressionNotUsed.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleExpressionUsedTwice.kt")
            public void testSimpleExpressionUsedTwice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/simpleExpressionUsedTwice.kt");
                doTest(fileName);
            }

            @TestMetadata("stringLiteralUsedTwice.kt")
            public void testStringLiteralUsedTwice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/stringLiteralUsedTwice.kt");
                doTest(fileName);
            }

            @TestMetadata("stringTemplateUsedTwice.kt")
            public void testStringTemplateUsedTwice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/stringTemplateUsedTwice.kt");
                doTest(fileName);
            }

            @TestMetadata("stringTemplateUsedTwice2.kt")
            public void testStringTemplateUsedTwice2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/stringTemplateUsedTwice2.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassUsages extends AbstractQuickFixTest {
            public void testAllFilesPresentInClassUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/classUsages"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotation1.kt")
            public void testAnnotation1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotation1.kt");
                doTest(fileName);
            }

            @TestMetadata("annotation2.kt")
            public void testAnnotation2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotation2.kt");
                doTest(fileName);
            }

            @TestMetadata("annotation3.kt")
            public void testAnnotation3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotation3.kt");
                doTest(fileName);
            }

            @TestMetadata("annotation4.kt")
            public void testAnnotation4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotation4.kt");
                doTest(fileName);
            }

            @TestMetadata("annotationKeepNamedArgs.kt")
            public void testAnnotationKeepNamedArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotationKeepNamedArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorUsage1.kt")
            public void testConstructorUsage1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/constructorUsage1.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorUsage2.kt")
            public void testConstructorUsage2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/constructorUsage2.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorUsage3.kt")
            public void testConstructorUsage3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/constructorUsage3.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorUsage4.kt")
            public void testConstructorUsage4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/constructorUsage4.kt");
                doTest(fileName);
            }

            @TestMetadata("imports.kt")
            public void testImports() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/imports.kt");
                doTest(fileName);
            }

            @TestMetadata("inTypeArgument.kt")
            public void testInTypeArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/inTypeArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedClassToNestedClass.kt")
            public void testNestedClassToNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/nestedClassToNestedClass.kt");
                doTest(fileName);
            }

            @TestMetadata("noAnnotationConstructorUsage.kt")
            public void testNoAnnotationConstructorUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/noAnnotationConstructorUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifiedClassName.kt")
            public void testQualifiedClassName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/qualifiedClassName.kt");
                doTest(fileName);
            }

            @TestMetadata("qualifiedClassNameInPattern.kt")
            public void testQualifiedClassNameInPattern() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/qualifiedClassNameInPattern.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/wholeProject")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WholeProject extends AbstractQuickFixTest {
                public void testAllFilesPresentInWholeProject() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/wholeProject"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("inheritance.kt")
                public void testInheritance() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/wholeProject/inheritance.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionLiteralArguments extends AbstractQuickFixTest {
            public void testAllFilesPresentInFunctionLiteralArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("cannotKeepOutside.kt")
            public void testCannotKeepOutside() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments/cannotKeepOutside.kt");
                doTest(fileName);
            }

            @TestMetadata("keepInside.kt")
            public void testKeepInside() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments/keepInside.kt");
                doTest(fileName);
            }

            @TestMetadata("keepOutside.kt")
            public void testKeepOutside() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments/keepOutside.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KeepComments extends AbstractQuickFixTest {
            @TestMetadata("addArguments.kt")
            public void testAddArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/addArguments.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInKeepComments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/keepComments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("commentBeforeArgument.kt")
            public void testCommentBeforeArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/commentBeforeArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("dropArgument.kt")
            public void testDropArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/dropArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleArguments.kt")
            public void testMultipleArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/multipleArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("usedTwice.kt")
            public void testUsedTwice() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/usedTwice.kt");
                doTest(fileName);
            }

            @TestMetadata("variableForArgument.kt")
            public void testVariableForArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/variableForArgument.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KeepLineBreaks extends AbstractQuickFixTest {
            @TestMetadata("addArgument.kt")
            public void testAddArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks/addArgument.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInKeepLineBreaks() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("lineBreakAfterReceiverRuntime.kt")
            public void testLineBreakAfterReceiverRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks/lineBreakAfterReceiverRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks/simple.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/operatorCalls")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OperatorCalls extends AbstractQuickFixTest {
            public void testAllFilesPresentInOperatorCalls() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/operatorCalls"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("in.kt")
            public void testIn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/operatorCalls/in.kt");
                doTest(fileName);
            }

            @TestMetadata("plusAssign.kt")
            public void testPlusAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/operatorCalls/plusAssign.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OptionalParameters extends AbstractQuickFixTest {
            public void testAllFilesPresentInOptionalParameters() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dropAll.kt")
            public void testDropAll() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/dropAll.kt");
                doTest(fileName);
            }

            @TestMetadata("functionalLiteralArgument.kt")
            public void testFunctionalLiteralArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/functionalLiteralArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("namedArgument.kt")
            public void testNamedArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/namedArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("optionalParameters1.kt")
            public void testOptionalParameters1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters1.kt");
                doTest(fileName);
            }

            @TestMetadata("optionalParameters2.kt")
            public void testOptionalParameters2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters2.kt");
                doTest(fileName);
            }

            @TestMetadata("optionalParameters3.kt")
            public void testOptionalParameters3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters3.kt");
                doTest(fileName);
            }

            @TestMetadata("optionalParameters4.kt")
            public void testOptionalParameters4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters4.kt");
                doTest(fileName);
            }

            @TestMetadata("optionalParameters5.kt")
            public void testOptionalParameters5() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters5.kt");
                doTest(fileName);
            }

            @TestMetadata("optionalParameters7.kt")
            public void testOptionalParameters7() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters7.kt");
                doTest(fileName);
            }

            @TestMetadata("optionalParameters9.kt")
            public void testOptionalParameters9() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters9.kt");
                doTest(fileName);
            }

            @TestMetadata("overridingMethod.kt")
            public void testOverridingMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/overridingMethod.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SafeCall extends AbstractQuickFixTest {
            public void testAllFilesPresentInSafeCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/safeCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeThisSafeCall.kt")
            public void testChangeThisSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("changeThisSafeCallWithValue1Runtime.kt")
            public void testChangeThisSafeCallWithValue1Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValue1Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("changeThisSafeCallWithValue2Runtime.kt")
            public void testChangeThisSafeCallWithValue2Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValue2Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("changeThisSafeCallWithValue3Runtime.kt")
            public void testChangeThisSafeCallWithValue3Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValue3Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("changeThisSafeCallWithValue4Runtime.kt")
            public void testChangeThisSafeCallWithValue4Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValue4Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("changeThisSafeCallWithValueRuntime.kt")
            public void testChangeThisSafeCallWithValueRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValueRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("dropReceiverSafeCall.kt")
            public void testDropReceiverSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/dropReceiverSafeCall.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCall.kt")
            public void testSafeCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/safeCall.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeArguments extends AbstractQuickFixTest {
            public void testAllFilesPresentInTypeArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("emptyVarargRuntime.kt")
            public void testEmptyVarargRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/emptyVarargRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitInPatternImplicitInUsage.kt")
            public void testExplicitInPatternImplicitInUsage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/explicitInPatternImplicitInUsage.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitTypeArg.kt")
            public void testExplicitTypeArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/explicitTypeArg.kt");
                doTest(fileName);
            }

            @TestMetadata("keepInUserCodeRuntime.kt")
            public void testKeepInUserCodeRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/keepInUserCodeRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("keepOriginalIfQualified.kt")
            public void testKeepOriginalIfQualified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/keepOriginalIfQualified.kt");
                doTest(fileName);
            }

            @TestMetadata("noImplicitTypeArgImportRuntime.kt")
            public void testNoImplicitTypeArgImportRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/noImplicitTypeArgImportRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("nonEmptyVarargRuntime.kt")
            public void testNonEmptyVarargRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/nonEmptyVarargRuntime.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Vararg extends AbstractQuickFixTest {
            @TestMetadata("addedNamedArgumentAfterRuntime.kt")
            public void testAddedNamedArgumentAfterRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/addedNamedArgumentAfterRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("addedPositionalArgumentAfterRuntime.kt")
            public void testAddedPositionalArgumentAfterRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/addedPositionalArgumentAfterRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("addedSpreadArgumentAfterRuntime.kt")
            public void testAddedSpreadArgumentAfterRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/addedSpreadArgumentAfterRuntime.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInVararg() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/vararg"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("booleanArrayRuntime.kt")
            public void testBooleanArrayRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/booleanArrayRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("byteArrayRuntime.kt")
            public void testByteArrayRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/byteArrayRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("doNotShortenUserReferences2Runtime.kt")
            public void testDoNotShortenUserReferences2Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/doNotShortenUserReferences2Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("doNotShortenUserReferencesRuntime.kt")
            public void testDoNotShortenUserReferencesRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/doNotShortenUserReferencesRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("doNotSimplifyOriginalCallRuntime.kt")
            public void testDoNotSimplifyOriginalCallRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/doNotSimplifyOriginalCallRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("doubleArrayRuntime.kt")
            public void testDoubleArrayRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/doubleArrayRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("floatArrayRuntime.kt")
            public void testFloatArrayRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/floatArrayRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("longArrayRuntime.kt")
            public void testLongArrayRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/longArrayRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleSpreadArguments2Runtime.kt")
            public void testMultipleSpreadArguments2Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/multipleSpreadArguments2Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleSpreadArgumentsRuntime.kt")
            public void testMultipleSpreadArgumentsRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/multipleSpreadArgumentsRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("noImportRuntime.kt")
            public void testNoImportRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/noImportRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("shortArrayRuntime.kt")
            public void testShortArrayRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/shortArrayRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg1Runtime.kt")
            public void testVararg1Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg1Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg2Runtime.kt")
            public void testVararg2Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg2Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg3Runtime.kt")
            public void testVararg3Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg3Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg4.kt")
            public void testVararg4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg4.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg5.kt")
            public void testVararg5() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg5.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg6Runtime.kt")
            public void testVararg6Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg6Runtime.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg7.kt")
            public void testVararg7() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg7.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg8Runtime.kt")
            public void testVararg8Runtime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg8Runtime.kt");
                doTest(fileName);
            }
        }

    }

    @TestMetadata("idea/testData/quickfix/expressions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expressions extends AbstractQuickFixTest {
        public void testAllFilesPresentInExpressions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/expressions"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fixNullableBinaryWithExclExcl.kt")
        public void testFixNullableBinaryWithExclExcl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/fixNullableBinaryWithExclExcl.kt");
            doTest(fileName);
        }

        @TestMetadata("fixNullableInfixWithExclExcl.kt")
        public void testFixNullableInfixWithExclExcl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/fixNullableInfixWithExclExcl.kt");
            doTest(fileName);
        }

        @TestMetadata("fixNullableIterableGenericWithExclExcl.kt")
        public void testFixNullableIterableGenericWithExclExcl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/fixNullableIterableGenericWithExclExcl.kt");
            doTest(fileName);
        }

        @TestMetadata("fixNullableIterableWithExclExcl.kt")
        public void testFixNullableIterableWithExclExcl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/fixNullableIterableWithExclExcl.kt");
            doTest(fileName);
        }

        @TestMetadata("fixNullableUnaryWithExclExcl.kt")
        public void testFixNullableUnaryWithExclExcl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/fixNullableUnaryWithExclExcl.kt");
            doTest(fileName);
        }

        @TestMetadata("fixNullableWithExclExclAbsentWithBadIterator.kt")
        public void testFixNullableWithExclExclAbsentWithBadIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/fixNullableWithExclExclAbsentWithBadIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("fixNullableWithIteratorWithExclExcl.kt")
        public void testFixNullableWithIteratorWithExclExcl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/fixNullableWithIteratorWithExclExcl.kt");
            doTest(fileName);
        }

        @TestMetadata("kt11594.kt")
        public void testKt11594() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/kt11594.kt");
            doTest(fileName);
        }

        @TestMetadata("removeUselessCast.kt")
        public void testRemoveUselessCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/removeUselessCast.kt");
            doTest(fileName);
        }

        @TestMetadata("removeUselessCastInParens.kt")
        public void testRemoveUselessCastInParens() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/removeUselessCastInParens.kt");
            doTest(fileName);
        }

        @TestMetadata("removeUselessCastUnderSmartCast.kt")
        public void testRemoveUselessCastUnderSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/removeUselessCastUnderSmartCast.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryNonNullAssertion1.kt")
        public void testUnnecessaryNonNullAssertion1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unnecessaryNonNullAssertion1.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryNonNullAssertion2.kt")
        public void testUnnecessaryNonNullAssertion2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unnecessaryNonNullAssertion2.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessaryNonNullAssertion3.kt")
        public void testUnnecessaryNonNullAssertion3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unnecessaryNonNullAssertion3.kt");
            doTest(fileName);
        }

        @TestMetadata("unnecessarySafeCall1.kt")
        public void testUnnecessarySafeCall1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unnecessarySafeCall1.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCall1.kt")
        public void testUnsafeCall1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unsafeCall1.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCall2.kt")
        public void testUnsafeCall2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unsafeCall2.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCall3.kt")
        public void testUnsafeCall3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unsafeCall3.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCall4.kt")
        public void testUnsafeCall4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unsafeCall4.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCall5.kt")
        public void testUnsafeCall5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/unsafeCall5.kt");
            doTest(fileName);
        }

        @TestMetadata("uselessCastStaticAssertIsFine.kt")
        public void testUselessCastStaticAssertIsFine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/uselessCastStaticAssertIsFine.kt");
            doTest(fileName);
        }

        @TestMetadata("uselessElvis.kt")
        public void testUselessElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/expressions/uselessElvis.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/foldTryCatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FoldTryCatch extends AbstractQuickFixTest {
        public void testAllFilesPresentInFoldTryCatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/foldTryCatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conditional.kt")
        public void testConditional() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/foldTryCatch/conditional.kt");
            doTest(fileName);
        }

        @TestMetadata("emptyFinally.kt")
        public void testEmptyFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/foldTryCatch/emptyFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleExceptions.kt")
        public void testMultipleExceptions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/foldTryCatch/multipleExceptions.kt");
            doTest(fileName);
        }

        @TestMetadata("shadow.kt")
        public void testShadow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/foldTryCatch/shadow.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/foldTryCatch/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/implement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Implement extends AbstractQuickFixTest {
        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/abstract.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInImplement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/implement"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotation.kt")
        public void testAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/annotation.kt");
            doTest(fileName);
        }

        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/enum.kt");
            doTest(fileName);
        }

        @TestMetadata("finalClass.kt")
        public void testFinalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/finalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inCompanion.kt")
        public void testInCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/inCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("inInternalCompanion.kt")
        public void testInInternalCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/inInternalCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("inPrivateCompanion.kt")
        public void testInPrivateCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/inPrivateCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("inProtectedCompanion.kt")
        public void testInProtectedCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/inProtectedCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("incorrectRange.kt")
        public void testIncorrectRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/incorrectRange.kt");
            doTest(fileName);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/inner.kt");
            doTest(fileName);
        }

        @TestMetadata("interface.kt")
        public void testInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/interface.kt");
            doTest(fileName);
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/local.kt");
            doTest(fileName);
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/nested.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedPrivateInterface.kt")
        public void testNestedPrivateInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/nestedPrivateInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("noDefaultConstructor.kt")
        public void testNoDefaultConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/noDefaultConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("private.kt")
        public void testPrivate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/private.kt");
            doTest(fileName);
        }

        @TestMetadata("privateConstructor.kt")
        public void testPrivateConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/privateConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("privateNested.kt")
        public void testPrivateNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/privateNested.kt");
            doTest(fileName);
        }

        @TestMetadata("privateNestedWithConflict.kt")
        public void testPrivateNestedWithConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/privateNestedWithConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/protected.kt");
            doTest(fileName);
        }

        @TestMetadata("sealed.kt")
        public void testSealed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/sealed.kt");
            doTest(fileName);
        }

        @TestMetadata("sealedEmpty.kt")
        public void testSealedEmpty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/sealedEmpty.kt");
            doTest(fileName);
        }

        @TestMetadata("sealedWithConflict.kt")
        public void testSealedWithConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/sealedWithConflict.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParameter.kt")
        public void testTypeParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/typeParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParameterOut.kt")
        public void testTypeParameterOut() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/typeParameterOut.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParameterWhere.kt")
        public void testTypeParameterWhere() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/typeParameterWhere.kt");
            doTest(fileName);
        }

        @TestMetadata("typeParametersClass.kt")
        public void testTypeParametersClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/implement/typeParametersClass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/increaseVisibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IncreaseVisibility extends AbstractQuickFixTest {
        public void testAllFilesPresentInIncreaseVisibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/increaseVisibility"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("exposedParameterType.kt")
        public void testExposedParameterType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedParameterType.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedParameterTypePublic.kt")
        public void testExposedParameterTypePublic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedParameterTypePublic.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedPropertyType.kt")
        public void testExposedPropertyType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedPropertyType.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedReceiverType.kt")
        public void testExposedReceiverType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedReceiverType.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedReturnType.kt")
        public void testExposedReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperClass.kt")
        public void testExposedSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedSuperClass.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperClassProtectedBase.kt")
        public void testExposedSuperClassProtectedBase() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedSuperClassProtectedBase.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperClassProtectedInAnother.kt")
        public void testExposedSuperClassProtectedInAnother() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedSuperClassProtectedInAnother.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperClassProtectedInAnotherFromPrivate.kt")
        public void testExposedSuperClassProtectedInAnotherFromPrivate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedSuperClassProtectedInAnotherFromPrivate.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedSuperInterface.kt")
        public void testExposedSuperInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedSuperInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("exposedTypeParameterBound.kt")
        public void testExposedTypeParameterBound() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/exposedTypeParameterBound.kt");
            doTest(fileName);
        }

        @TestMetadata("overriddenProtectedMemberToPublicSingleFile.kt")
        public void testOverriddenProtectedMemberToPublicSingleFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/overriddenProtectedMemberToPublicSingleFile.kt");
            doTest(fileName);
        }

        @TestMetadata("privateMemberToInternalSingleFile.kt")
        public void testPrivateMemberToInternalSingleFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/privateMemberToInternalSingleFile.kt");
            doTest(fileName);
        }

        @TestMetadata("privateMemberToInternalWithExposed.kt")
        public void testPrivateMemberToInternalWithExposed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/privateMemberToInternalWithExposed.kt");
            doTest(fileName);
        }

        @TestMetadata("privateMemberToPublicSingleFile.kt")
        public void testPrivateMemberToPublicSingleFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/privateMemberToPublicSingleFile.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedMemberToPublicSingleFile.kt")
        public void testProtectedMemberToPublicSingleFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/increaseVisibility/protectedMemberToPublicSingleFile.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/initializeWithConstructorParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InitializeWithConstructorParameter extends AbstractQuickFixTest {
        public void testAllFilesPresentInInitializeWithConstructorParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/initializeWithConstructorParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constructorWithThisDelegation.kt")
        public void testConstructorWithThisDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/constructorWithThisDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("localVar.kt")
        public void testLocalVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/localVar.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassNameClashInPrimaryConstructor.kt")
        public void testMemberPropertyInClassNameClashInPrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassNameClashInPrimaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassNameClashInSecondaryConstructor.kt")
        public void testMemberPropertyInClassNameClashInSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassNameClashInSecondaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassNoConstructors.kt")
        public void testMemberPropertyInClassNoConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassNoConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassPrimaryAndSecondaryConstructors.kt")
        public void testMemberPropertyInClassPrimaryAndSecondaryConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassPrimaryAndSecondaryConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassPrimaryConstructorOnly.kt")
        public void testMemberPropertyInClassPrimaryConstructorOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassPrimaryConstructorOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassSecondaryConstructorsOnly.kt")
        public void testMemberPropertyInClassSecondaryConstructorsOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassSecondaryConstructorsOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInInterface.kt")
        public void testMemberPropertyInInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInObject.kt")
        public void testMemberPropertyInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyNoAccessorsInClassNoConstructors.kt")
        public void testMemberPropertyNoAccessorsInClassNoConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyNoAccessorsInClassNoConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyNoAccessorsInClassPrimaryAndSecondaryConstructors.kt")
        public void testMemberPropertyNoAccessorsInClassPrimaryAndSecondaryConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyNoAccessorsInClassPrimaryAndSecondaryConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyNoAccessorsInClassPrimaryConstructorOnly.kt")
        public void testMemberPropertyNoAccessorsInClassPrimaryConstructorOnly() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyNoAccessorsInClassPrimaryConstructorOnly.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyWithDelegateRuntime.kt")
        public void testMemberPropertyWithDelegateRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyWithDelegateRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/initializeWithConstructorParameter/topLevelProperty.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/inlineTypeParameterFix")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineTypeParameterFix extends AbstractQuickFixTest {
        public void testAllFilesPresentInInlineTypeParameterFix() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/inlineTypeParameterFix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/inlineTypeParameterFix/basic.kt");
            doTest(fileName);
        }

        @TestMetadata("basicMultipleDef.kt")
        public void testBasicMultipleDef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/inlineTypeParameterFix/basicMultipleDef.kt");
            doTest(fileName);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/inlineTypeParameterFix/function.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/insertDelegationCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InsertDelegationCall extends AbstractQuickFixTest {
        public void testAllFilesPresentInInsertDelegationCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/insertDelegationCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nonApplicableInsertSuper.kt")
        public void testNonApplicableInsertSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/insertDelegationCall/nonApplicableInsertSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("nonApplicableInsertThis.kt")
        public void testNonApplicableInsertThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/insertDelegationCall/nonApplicableInsertThis.kt");
            doTest(fileName);
        }

        @TestMetadata("nonApplicableOnEmpty.kt")
        public void testNonApplicableOnEmpty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/insertDelegationCall/nonApplicableOnEmpty.kt");
            doTest(fileName);
        }

        @TestMetadata("nonApplicableWithOneConstructor.kt")
        public void testNonApplicableWithOneConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/insertDelegationCall/nonApplicableWithOneConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryRequiredNoSuper.kt")
        public void testPrimaryRequiredNoSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/insertDelegationCall/primaryRequiredNoSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryRequiredParameterless.kt")
        public void testPrimaryRequiredParameterless() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/insertDelegationCall/primaryRequiredParameterless.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryRequiredWithBody.kt")
        public void testPrimaryRequiredWithBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/insertDelegationCall/primaryRequiredWithBody.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryRequiredWithParameter.kt")
        public void testPrimaryRequiredWithParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/insertDelegationCall/primaryRequiredWithParameter.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/kdocMissingDocumentation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KdocMissingDocumentation extends AbstractQuickFixTest {
        public void testAllFilesPresentInKdocMissingDocumentation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/kdocMissingDocumentation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/kdocMissingDocumentation/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/lateinit")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Lateinit extends AbstractQuickFixTest {
        public void testAllFilesPresentInLateinit() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/lateinit"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/lateinit/nullable.kt");
            doTest(fileName);
        }

        @TestMetadata("val.kt")
        public void testVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/lateinit/val.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/leakingThis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LeakingThis extends AbstractQuickFixTest {
        @TestMetadata("accessOpenProperty.kt")
        public void testAccessOpenProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/leakingThis/accessOpenProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("accessOpenPropertyClass.kt")
        public void testAccessOpenPropertyClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/leakingThis/accessOpenPropertyClass.kt");
            doTest(fileName);
        }

        @TestMetadata("accessOverriddenProperty.kt")
        public void testAccessOverriddenProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/leakingThis/accessOverriddenProperty.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInLeakingThis() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/leakingThis"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callOpenMethod.kt")
        public void testCallOpenMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/leakingThis/callOpenMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("callOpenMethodClass.kt")
        public void testCallOpenMethodClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/leakingThis/callOpenMethodClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inAbstract.kt")
        public void testInAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/leakingThis/inAbstract.kt");
            doTest(fileName);
        }

        @TestMetadata("inNonFinal.kt")
        public void testInNonFinal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/leakingThis/inNonFinal.kt");
            doTest(fileName);
        }

        @TestMetadata("inOverridden.kt")
        public void testInOverridden() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/leakingThis/inOverridden.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/libraries")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Libraries extends AbstractQuickFixTest {
        public void testAllFilesPresentInLibraries() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/libraries"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("junit.kt")
        public void testJunit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/libraries/junit.kt");
            doTest(fileName);
        }

        @TestMetadata("testNG.kt")
        public void testTestNG() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/libraries/testNG.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/makeConstructorParameterProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MakeConstructorParameterProperty extends AbstractQuickFixTest {
        public void testAllFilesPresentInMakeConstructorParameterProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/makeConstructorParameterProperty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/makeConstructorParameterProperty/inner.kt");
            doTest(fileName);
        }

        @TestMetadata("override.kt")
        public void testOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/makeConstructorParameterProperty/override.kt");
            doTest(fileName);
        }

        @TestMetadata("val.kt")
        public void testVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/makeConstructorParameterProperty/val.kt");
            doTest(fileName);
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/makeConstructorParameterProperty/var.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/migration")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Migration extends AbstractQuickFixTest {
        @TestMetadata("addOverrideToEqualsHashCodeToString.kt")
        public void testAddOverrideToEqualsHashCodeToString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/addOverrideToEqualsHashCodeToString.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInMigration() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/migration/addTypeToLHSOfCallableReference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AddTypeToLHSOfCallableReference extends AbstractQuickFixTest {
            public void testAllFilesPresentInAddTypeToLHSOfCallableReference() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/addTypeToLHSOfCallableReference"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("member.kt")
            public void testMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/addTypeToLHSOfCallableReference/member.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/commasInWhenWithoutArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CommasInWhenWithoutArgument extends AbstractQuickFixTest {
            public void testAllFilesPresentInCommasInWhenWithoutArgument() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/commasInWhenWithoutArgument"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("commasInConditionWithNoArguments.kt")
            public void testCommasInConditionWithNoArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/commasInWhenWithoutArgument/commasInConditionWithNoArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("commasInConditionWithNoArguments2.kt")
            public void testCommasInConditionWithNoArguments2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/commasInWhenWithoutArgument/commasInConditionWithNoArguments2.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/conflictingExtension")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConflictingExtension extends AbstractQuickFixTest {
            public void testAllFilesPresentInConflictingExtension() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/conflictingExtension"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("explicitThis.kt")
            public void testExplicitThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/explicitThis.kt");
                doTest(fileName);
            }

            @TestMetadata("markHiddenAndDeprecated.kt")
            public void testMarkHiddenAndDeprecated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/markHiddenAndDeprecated.kt");
                doTest(fileName);
            }

            @TestMetadata("memberExtension.kt")
            public void testMemberExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/memberExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("returnInGetter.kt")
            public void testReturnInGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/returnInGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("setterWithExpressionBody.kt")
            public void testSetterWithExpressionBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/setterWithExpressionBody.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("valInsteadOfVar.kt")
            public void testValInsteadOfVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/valInsteadOfVar.kt");
                doTest(fileName);
            }

            @TestMetadata("varInsteadOfVal.kt")
            public void testVarInsteadOfVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/varInsteadOfVal.kt");
                doTest(fileName);
            }

            @TestMetadata("withSetter.kt")
            public void testWithSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/withSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongExplicitThis.kt")
            public void testWrongExplicitThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/wrongExplicitThis.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongExplicitThis2.kt")
            public void testWrongExplicitThis2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/wrongExplicitThis2.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongGetter.kt")
            public void testWrongGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/wrongGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongGetter2.kt")
            public void testWrongGetter2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/wrongGetter2.kt");
                doTest(fileName);
            }

            @TestMetadata("wrongSetter.kt")
            public void testWrongSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/conflictingExtension/wrongSetter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/missingConstructorKeyword")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MissingConstructorKeyword extends AbstractQuickFixTest {
            public void testAllFilesPresentInMissingConstructorKeyword() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/missingConstructorKeyword"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/missingConstructorKeyword/basic.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/obsoleteLabelSyntax")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ObsoleteLabelSyntax extends AbstractQuickFixTest {
            public void testAllFilesPresentInObsoleteLabelSyntax() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/obsoleteLabelSyntax"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/obsoleteLabelSyntax/lambda.kt");
                doTest(fileName);
            }

            @TestMetadata("loop.kt")
            public void testLoop() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/obsoleteLabelSyntax/loop.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/removeNameFromFunctionExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RemoveNameFromFunctionExpression extends AbstractQuickFixTest {
            public void testAllFilesPresentInRemoveNameFromFunctionExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/removeNameFromFunctionExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/removeNameFromFunctionExpression/basic.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/typeParameterList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeParameterList extends AbstractQuickFixTest {
            public void testAllFilesPresentInTypeParameterList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/typeParameterList"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/typeParameterList/basic.kt");
                doTest(fileName);
            }

            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/migration/typeParameterList/extension.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/modifiers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Modifiers extends AbstractQuickFixTest {
        @TestMetadata("abstractModifierInEnum.kt")
        public void testAbstractModifierInEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/abstractModifierInEnum.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInModifiers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/modifiers"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("cannotMakeClassAnnotation.kt")
        public void testCannotMakeClassAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/cannotMakeClassAnnotation.kt");
            doTest(fileName);
        }

        @TestMetadata("finalTrait.kt")
        public void testFinalTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/finalTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("illegalEnumAnnotation1.kt")
        public void testIllegalEnumAnnotation1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/illegalEnumAnnotation1.kt");
            doTest(fileName);
        }

        @TestMetadata("illegalEnumAnnotation2.kt")
        public void testIllegalEnumAnnotation2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/illegalEnumAnnotation2.kt");
            doTest(fileName);
        }

        @TestMetadata("infixModifier.kt")
        public void testInfixModifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/infixModifier.kt");
            doTest(fileName);
        }

        @TestMetadata("kt10409.kt")
        public void testKt10409() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/kt10409.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedClassNotAllowed.kt")
        public void testNestedClassNotAllowed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/nestedClassNotAllowed.kt");
            doTest(fileName);
        }

        @TestMetadata("noAbstractForAnonymousObject.kt")
        public void testNoAbstractForAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/noAbstractForAnonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("noAbstractForObject.kt")
        public void testNoAbstractForObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/noAbstractForObject.kt");
            doTest(fileName);
        }

        @TestMetadata("notAnAnnotationClass.kt")
        public void testNotAnAnnotationClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/notAnAnnotationClass.kt");
            doTest(fileName);
        }

        @TestMetadata("openMemberInFinalClass1.kt")
        public void testOpenMemberInFinalClass1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/openMemberInFinalClass1.kt");
            doTest(fileName);
        }

        @TestMetadata("openMemberInFinalClass2.kt")
        public void testOpenMemberInFinalClass2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/openMemberInFinalClass2.kt");
            doTest(fileName);
        }

        @TestMetadata("openMemberInFinalClass3.kt")
        public void testOpenMemberInFinalClass3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/openMemberInFinalClass3.kt");
            doTest(fileName);
        }

        @TestMetadata("openMemberInFinalClass4.kt")
        public void testOpenMemberInFinalClass4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/openMemberInFinalClass4.kt");
            doTest(fileName);
        }

        @TestMetadata("openModifierInEnum.kt")
        public void testOpenModifierInEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/openModifierInEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("openVarWithPrivateSetter.kt")
        public void testOpenVarWithPrivateSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/openVarWithPrivateSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorModifier.kt")
        public void testOperatorModifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/operatorModifier.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorModifierCollection.kt")
        public void testOperatorModifierCollection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/operatorModifierCollection.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorModifierComponent.kt")
        public void testOperatorModifierComponent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/operatorModifierComponent.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorModifierGet.kt")
        public void testOperatorModifierGet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/operatorModifierGet.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorModifierInherited.kt")
        public void testOperatorModifierInherited() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/operatorModifierInherited.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideWithPrivateSetter.kt")
        public void testOverrideWithPrivateSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/overrideWithPrivateSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("packageMemberCannotBeProtected.kt")
        public void testPackageMemberCannotBeProtected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/packageMemberCannotBeProtected.kt");
            doTest(fileName);
        }

        @TestMetadata("redundantOpenInInterface.kt")
        public void testRedundantOpenInInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/redundantOpenInInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("removeAbstractModifier.kt")
        public void testRemoveAbstractModifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeAbstractModifier.kt");
            doTest(fileName);
        }

        @TestMetadata("removeIncompatibleModifier.kt")
        public void testRemoveIncompatibleModifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeIncompatibleModifier.kt");
            doTest(fileName);
        }

        @TestMetadata("removeInnerForClassInTrait.kt")
        public void testRemoveInnerForClassInTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeInnerForClassInTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("removeProtectedModifier.kt")
        public void testRemoveProtectedModifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeProtectedModifier.kt");
            doTest(fileName);
        }

        @TestMetadata("removeRedundantModifier1.kt")
        public void testRemoveRedundantModifier1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeRedundantModifier1.kt");
            doTest(fileName);
        }

        @TestMetadata("removeRedundantModifier2.kt")
        public void testRemoveRedundantModifier2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeRedundantModifier2.kt");
            doTest(fileName);
        }

        @TestMetadata("removeRedundantModifier3.kt")
        public void testRemoveRedundantModifier3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeRedundantModifier3.kt");
            doTest(fileName);
        }

        @TestMetadata("removeSupertype1.kt")
        public void testRemoveSupertype1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeSupertype1.kt");
            doTest(fileName);
        }

        @TestMetadata("removeSupertype2.kt")
        public void testRemoveSupertype2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeSupertype2.kt");
            doTest(fileName);
        }

        @TestMetadata("removeSupertype3.kt")
        public void testRemoveSupertype3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeSupertype3.kt");
            doTest(fileName);
        }

        @TestMetadata("removeSupertype4.kt")
        public void testRemoveSupertype4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/removeSupertype4.kt");
            doTest(fileName);
        }

        @TestMetadata("visibilityModifer1.kt")
        public void testVisibilityModifer1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/visibilityModifer1.kt");
            doTest(fileName);
        }

        @TestMetadata("visibilityModifer2.kt")
        public void testVisibilityModifer2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/visibilityModifer2.kt");
            doTest(fileName);
        }

        @TestMetadata("visibilityModiferOverrideJavaRuntime.kt")
        public void testVisibilityModiferOverrideJavaRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/visibilityModiferOverrideJavaRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("visibilityModiferParameter.kt")
        public void testVisibilityModiferParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/visibilityModiferParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AddOpenToClassDeclaration extends AbstractQuickFixTest {
            public void testAllFilesPresentInAddOpenToClassDeclaration() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/modifiers/addOpenToClassDeclaration"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumSupertype.kt")
            public void testEnumSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/enumSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("enumUpperBound.kt")
            public void testEnumUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/enumUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitlyFinalSupertype.kt")
            public void testExplicitlyFinalSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/explicitlyFinalSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitlyFinalUpperBound.kt")
            public void testExplicitlyFinalUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/explicitlyFinalUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("finalLibrarySupertype.kt")
            public void testFinalLibrarySupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalLibrarySupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("finalLibraryUpperBound.kt")
            public void testFinalLibraryUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalLibraryUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("finalSupertype.kt")
            public void testFinalSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("finalUpperBound.kt")
            public void testFinalUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("implementTraitFinalSupertype.kt")
            public void testImplementTraitFinalSupertype() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/implementTraitFinalSupertype.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedFinalClass.kt")
            public void testNestedFinalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/nestedFinalClass.kt");
                doTest(fileName);
            }

            @TestMetadata("secondaryCtrDelegationInHeader.kt")
            public void testSecondaryCtrDelegationInHeader() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/secondaryCtrDelegationInHeader.kt");
                doTest(fileName);
            }

            @TestMetadata("secondaryCtrDelegationInSecondary.kt")
            public void testSecondaryCtrDelegationInSecondary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/secondaryCtrDelegationInSecondary.kt");
                doTest(fileName);
            }

            @TestMetadata("withConstructor.kt")
            public void testWithConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/withConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalJavaClass")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FinalJavaClass extends AbstractQuickFixTest {
                public void testAllFilesPresentInFinalJavaClass() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalJavaClass"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalJavaClass/javaCode")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class JavaCode extends AbstractQuickFixTest {
                    public void testAllFilesPresentInJavaCode() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalJavaClass/javaCode"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                }
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/moveToConstructorParameters")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveToConstructorParameters extends AbstractQuickFixTest {
        public void testAllFilesPresentInMoveToConstructorParameters() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/moveToConstructorParameters"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("localVar.kt")
        public void testLocalVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/localVar.kt");
            doTest(fileName);
        }

        @TestMetadata("memberExtensionProperty.kt")
        public void testMemberExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassNameClash.kt")
        public void testMemberPropertyInClassNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassNoPrimaryConstructor.kt")
        public void testMemberPropertyInClassNoPrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassNoPrimaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassWithConstructorDelegatingToSuper.kt")
        public void testMemberPropertyInClassWithConstructorDelegatingToSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassWithConstructorDelegatingToSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassWithImplicitlyDelegatingConstructor.kt")
        public void testMemberPropertyInClassWithImplicitlyDelegatingConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassWithImplicitlyDelegatingConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInClassWithPrimaryConstructor.kt")
        public void testMemberPropertyInClassWithPrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassWithPrimaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInInterface.kt")
        public void testMemberPropertyInInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyInObject.kt")
        public void testMemberPropertyInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("memberPropertyWithDelegateRuntime.kt")
        public void testMemberPropertyWithDelegateRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/memberPropertyWithDelegateRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithModifiersAndComments.kt")
        public void testPropertyWithModifiersAndComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/propertyWithModifiersAndComments.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/moveToConstructorParameters/topLevelProperty.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/nullables")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Nullables extends AbstractQuickFixTest {
        public void testAllFilesPresentInNullables() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/nullables"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("removeRedundantNullable.kt")
        public void testRemoveRedundantNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/removeRedundantNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("removeSupertypeNullable1.kt")
        public void testRemoveSupertypeNullable1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/removeSupertypeNullable1.kt");
            doTest(fileName);
        }

        @TestMetadata("removeSupertypeNullable2.kt")
        public void testRemoveSupertypeNullable2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/removeSupertypeNullable2.kt");
            doTest(fileName);
        }

        @TestMetadata("removeUselessNullable.kt")
        public void testRemoveUselessNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/removeUselessNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/quickfix/nullables/unsafeInfixCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnsafeInfixCall extends AbstractQuickFixTest {
            public void testAllFilesPresentInUnsafeInfixCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/nullables/unsafeInfixCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noComparison.kt")
            public void testNoComparison() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/noComparison.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeComparisonInCondition.kt")
            public void testUnsafeComparisonInCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeComparisonInCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeComparisonInLogic.kt")
            public void testUnsafeComparisonInLogic() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeComparisonInLogic.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeComparisonInWhen.kt")
            public void testUnsafeComparisonInWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeComparisonInWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeComparisonInWhile.kt")
            public void testUnsafeComparisonInWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeComparisonInWhile.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeGet.kt")
            public void testUnsafeGet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeGet.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeInfixCall.kt")
            public void testUnsafeInfixCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeInfixCall.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeInvoke.kt")
            public void testUnsafeInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeInvokeWithReceiver.kt")
            public void testUnsafeInvokeWithReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeInvokeWithReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafePlus.kt")
            public void testUnsafePlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafePlus.kt");
                doTest(fileName);
            }

            @TestMetadata("unsafeSet.kt")
            public void testUnsafeSet() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeSet.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/optimizeImports")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class OptimizeImports extends AbstractQuickFixTest {
        public void testAllFilesPresentInOptimizeImports() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/optimizeImports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("destructuringAtTop.kt")
        public void testDestructuringAtTop() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/optimizeImports/destructuringAtTop.kt");
            doTest(fileName);
        }

        @TestMetadata("fileRuntime.kt")
        public void testFileRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/optimizeImports/fileRuntime.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/override")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Override extends AbstractQuickFixTest {
        public void testAllFilesPresentInOverride() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/override"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("changeToInvocation.kt")
        public void testChangeToInvocation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/changeToInvocation.kt");
            doTest(fileName);
        }

        @TestMetadata("implemenAsConstructorParameter.kt")
        public void testImplemenAsConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/implemenAsConstructorParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("implemenAsConstructorParameterFunction.kt")
        public void testImplemenAsConstructorParameterFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/implemenAsConstructorParameterFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("implemenAsConstructorParameterInObject.kt")
        public void testImplemenAsConstructorParameterInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/implemenAsConstructorParameterInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("implementMember.kt")
        public void testImplementMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/implementMember.kt");
            doTest(fileName);
        }

        @TestMetadata("implementMemberFromAbstractClass.kt")
        public void testImplementMemberFromAbstractClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/implementMemberFromAbstractClass.kt");
            doTest(fileName);
        }

        @TestMetadata("overriddingMultipleFinalMethods.kt")
        public void testOverriddingMultipleFinalMethods() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/overriddingMultipleFinalMethods.kt");
            doTest(fileName);
        }

        @TestMetadata("overridingDelegatedMethod.kt")
        public void testOverridingDelegatedMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/overridingDelegatedMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("overridingFakeOverride.kt")
        public void testOverridingFakeOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/overridingFakeOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("overridingFinalJavaMethod.kt")
        public void testOverridingFinalJavaMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/overridingFinalJavaMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("overridingFinalMethod.kt")
        public void testOverridingFinalMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/overridingFinalMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("overridingFinalMethodInLocal.kt")
        public void testOverridingFinalMethodInLocal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/overridingFinalMethodInLocal.kt");
            doTest(fileName);
        }

        @TestMetadata("overridingFinalProperty.kt")
        public void testOverridingFinalProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/overridingFinalProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("parameterNameChangedAmbiguousRename.kt")
        public void testParameterNameChangedAmbiguousRename() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/parameterNameChangedAmbiguousRename.kt");
            doTest(fileName);
        }

        @TestMetadata("parameterNameChangedMultipleOverrideRenamePossible.kt")
        public void testParameterNameChangedMultipleOverrideRenamePossible() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/parameterNameChangedMultipleOverrideRenamePossible.kt");
            doTest(fileName);
        }

        @TestMetadata("parameterNameChangedRenamePossible.kt")
        public void testParameterNameChangedRenamePossible() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/parameterNameChangedRenamePossible.kt");
            doTest(fileName);
        }

        @TestMetadata("virtualMethodHidden.kt")
        public void testVirtualMethodHidden() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/virtualMethodHidden.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/quickfix/override/nothingToOverride")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NothingToOverride extends AbstractQuickFixTest {
            @TestMetadata("addFunction.kt")
            public void testAddFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("addFunctionAbstractClass.kt")
            public void testAddFunctionAbstractClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addFunctionAbstractClass.kt");
                doTest(fileName);
            }

            @TestMetadata("addFunctionInLocalDeclaration.kt")
            public void testAddFunctionInLocalDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addFunctionInLocalDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("addFunctionNoBody.kt")
            public void testAddFunctionNoBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addFunctionNoBody.kt");
                doTest(fileName);
            }

            @TestMetadata("addFunctionNonUnitReturnType.kt")
            public void testAddFunctionNonUnitReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addFunctionNonUnitReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("addFunctionTrait.kt")
            public void testAddFunctionTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addFunctionTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("addFunctionTwoSuperclasses.kt")
            public void testAddFunctionTwoSuperclasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addFunctionTwoSuperclasses.kt");
                doTest(fileName);
            }

            @TestMetadata("addFunctionTwoTraits.kt")
            public void testAddFunctionTwoTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addFunctionTwoTraits.kt");
                doTest(fileName);
            }

            @TestMetadata("addParameter.kt")
            public void testAddParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("addParameterGenericClass.kt")
            public void testAddParameterGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addParameterGenericClass.kt");
                doTest(fileName);
            }

            @TestMetadata("addParameterMultiple.kt")
            public void testAddParameterMultiple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addParameterMultiple.kt");
                doTest(fileName);
            }

            @TestMetadata("addParameterPreserveVisibility.kt")
            public void testAddParameterPreserveVisibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addParameterPreserveVisibility.kt");
                doTest(fileName);
            }

            @TestMetadata("addParameterTwoSupertraits.kt")
            public void testAddParameterTwoSupertraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addParameterTwoSupertraits.kt");
                doTest(fileName);
            }

            @TestMetadata("addParameterTwoSupertypes.kt")
            public void testAddParameterTwoSupertypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/addParameterTwoSupertypes.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInNothingToOverride() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/override/nothingToOverride"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeParameterType.kt")
            public void testChangeParameterType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeParameterType.kt");
                doTest(fileName);
            }

            @TestMetadata("changeParameterTypeAbstractSuperclass.kt")
            public void testChangeParameterTypeAbstractSuperclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeAbstractSuperclass.kt");
                doTest(fileName);
            }

            @TestMetadata("changeParameterTypeInTrait.kt")
            public void testChangeParameterTypeInTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeInTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("changeParameterTypeMatchNames.kt")
            public void testChangeParameterTypeMatchNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeMatchNames.kt");
                doTest(fileName);
            }

            @TestMetadata("changeParameterTypeModifyOrder.kt")
            public void testChangeParameterTypeModifyOrder() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeModifyOrder.kt");
                doTest(fileName);
            }

            @TestMetadata("changeParameterTypeOpenOverride.kt")
            public void testChangeParameterTypeOpenOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeOpenOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("changeParameterTypeSingleExpressionFunction.kt")
            public void testChangeParameterTypeSingleExpressionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeSingleExpressionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("changeParameterTypeSuperTrait.kt")
            public void testChangeParameterTypeSuperTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeSuperTrait.kt");
                doTest(fileName);
            }

            @TestMetadata("changeReturnType.kt")
            public void testChangeReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/changeReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("doNotLooseAnnotations.kt")
            public void testDoNotLooseAnnotations() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/doNotLooseAnnotations.kt");
                doTest(fileName);
            }

            @TestMetadata("noDefaultValuesInOverride.kt")
            public void testNoDefaultValuesInOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/noDefaultValuesInOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("noOpenSuperFunction.kt")
            public void testNoOpenSuperFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/noOpenSuperFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("overrideJavaMethod.kt")
            public void testOverrideJavaMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/overrideJavaMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("removeOverride.kt")
            public void testRemoveOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/removeOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("removeParameter.kt")
            public void testRemoveParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/removeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("removeParameterTwoTraits.kt")
            public void testRemoveParameterTwoTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/removeParameterTwoTraits.kt");
                doTest(fileName);
            }

            @TestMetadata("swapParametersGenericClass.kt")
            public void testSwapParametersGenericClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/nothingToOverride/swapParametersGenericClass.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/override/typeMismatchOnOverride")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeMismatchOnOverride extends AbstractQuickFixTest {
            public void testAllFilesPresentInTypeMismatchOnOverride() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/override/typeMismatchOnOverride"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("cantChangeMultipleOverriddenPropertiesTypes.kt")
            public void testCantChangeMultipleOverriddenPropertiesTypes() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/cantChangeMultipleOverriddenPropertiesTypes.kt");
                doTest(fileName);
            }

            @TestMetadata("cantChangeOverriddenPropertyTypeToMatchOverridingProperty.kt")
            public void testCantChangeOverriddenPropertyTypeToMatchOverridingProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/cantChangeOverriddenPropertyTypeToMatchOverridingProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("cantChangePropertyTypeToMatchOverridenProperties.kt")
            public void testCantChangePropertyTypeToMatchOverridenProperties() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/cantChangePropertyTypeToMatchOverridenProperties.kt");
                doTest(fileName);
            }

            @TestMetadata("cantChangeReturnTypeOfOverriddenFunction.kt")
            public void testCantChangeReturnTypeOfOverriddenFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/cantChangeReturnTypeOfOverriddenFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("changeOverriddenPropertyType1.kt")
            public void testChangeOverriddenPropertyType1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/changeOverriddenPropertyType1.kt");
                doTest(fileName);
            }

            @TestMetadata("changeOverriddenPropertyType2.kt")
            public void testChangeOverriddenPropertyType2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/changeOverriddenPropertyType2.kt");
                doTest(fileName);
            }

            @TestMetadata("changeOverridingPropertyTypeToFunctionType.kt")
            public void testChangeOverridingPropertyTypeToFunctionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/changeOverridingPropertyTypeToFunctionType.kt");
                doTest(fileName);
            }

            @TestMetadata("changeReturnTypeOfOverriddenFunction.kt")
            public void testChangeReturnTypeOfOverriddenFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/changeReturnTypeOfOverriddenFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("namedFunctionReturnOverrideInsideVariableInitializer.kt")
            public void testNamedFunctionReturnOverrideInsideVariableInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/namedFunctionReturnOverrideInsideVariableInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("objectInsideBody.kt")
            public void testObjectInsideBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/objectInsideBody.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyReturnTypeMismatchOnOverride.kt")
            public void testPropertyReturnTypeMismatchOnOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/propertyReturnTypeMismatchOnOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyTypeMismatchOnOverrideIntLong.kt")
            public void testPropertyTypeMismatchOnOverrideIntLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/propertyTypeMismatchOnOverrideIntLong.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyTypeMismatchOnOverrideIntUnit.kt")
            public void testPropertyTypeMismatchOnOverrideIntUnit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/propertyTypeMismatchOnOverrideIntUnit.kt");
                doTest(fileName);
            }

            @TestMetadata("returnTypeMismatchOnMultipleOverride.kt")
            public void testReturnTypeMismatchOnMultipleOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnMultipleOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("returnTypeMismatchOnMultipleOverrideAmbiguity.kt")
            public void testReturnTypeMismatchOnMultipleOverrideAmbiguity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnMultipleOverrideAmbiguity.kt");
                doTest(fileName);
            }

            @TestMetadata("returnTypeMismatchOnOverrideIntLong.kt")
            public void testReturnTypeMismatchOnOverrideIntLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnOverrideIntLong.kt");
                doTest(fileName);
            }

            @TestMetadata("returnTypeMismatchOnOverrideIntUnit.kt")
            public void testReturnTypeMismatchOnOverrideIntUnit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnOverrideIntUnit.kt");
                doTest(fileName);
            }

            @TestMetadata("returnTypeMismatchOnOverrideUnitInt.kt")
            public void testReturnTypeMismatchOnOverrideUnitInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnOverrideUnitInt.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/platformClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PlatformClasses extends AbstractQuickFixTest {
        public void testAllFilesPresentInPlatformClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/platformClasses"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("mapPlatformClassToKotlin1.kt")
        public void testMapPlatformClassToKotlin1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/platformClasses/mapPlatformClassToKotlin1.kt");
            doTest(fileName);
        }

        @TestMetadata("mapPlatformClassToKotlin2.kt")
        public void testMapPlatformClassToKotlin2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/platformClasses/mapPlatformClassToKotlin2.kt");
            doTest(fileName);
        }

        @TestMetadata("mapPlatformClassToKotlin3.kt")
        public void testMapPlatformClassToKotlin3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/platformClasses/mapPlatformClassToKotlin3.kt");
            doTest(fileName);
        }

        @TestMetadata("mapPlatformClassToKotlin4.kt")
        public void testMapPlatformClassToKotlin4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/platformClasses/mapPlatformClassToKotlin4.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/platformTypesInspection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PlatformTypesInspection extends AbstractQuickFixTest {
        public void testAllFilesPresentInPlatformTypesInspection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/platformTypesInspection"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nestedNoAssertRuntime.kt")
        public void testNestedNoAssertRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/platformTypesInspection/nestedNoAssertRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedRuntime.kt")
        public void testNestedRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/platformTypesInspection/nestedRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableAssertRuntime.kt")
        public void testNullableAssertRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/platformTypesInspection/nullableAssertRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableRuntime.kt")
        public void testNullableRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/platformTypesInspection/nullableRuntime.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/properties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Properties extends AbstractQuickFixTest {
        public void testAllFilesPresentInProperties() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/properties"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtensionPropertyInitializerToGetter extends AbstractQuickFixTest {
            public void testAllFilesPresentInExtensionPropertyInitializerToGetter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("baseCase.kt")
            public void testBaseCase() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/baseCase.kt");
                doTest(fileName);
            }

            @TestMetadata("baseCaseWithoutTypeAnnotation.kt")
            public void testBaseCaseWithoutTypeAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/baseCaseWithoutTypeAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("dontShowQuickfixOnExistingAccessors.kt")
            public void testDontShowQuickfixOnExistingAccessors() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/dontShowQuickfixOnExistingAccessors.kt");
                doTest(fileName);
            }

            @TestMetadata("insertGetterBeforeExistingSetter.kt")
            public void testInsertGetterBeforeExistingSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/insertGetterBeforeExistingSetter.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/protectedInFinal")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ProtectedInFinal extends AbstractQuickFixTest {
        public void testAllFilesPresentInProtectedInFinal() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/protectedInFinal"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/protectedInFinal/protected.kt");
            doTest(fileName);
        }

        @TestMetadata("protected2.kt")
        public void testProtected2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/protectedInFinal/protected2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantIf")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantIf extends AbstractQuickFixTest {
        public void testAllFilesPresentInRedundantIf() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantIf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignExpression.kt")
        public void testAssignExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantIf/assignExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantIf/assignment.kt");
            doTest(fileName);
        }

        @TestMetadata("assignmentFake.kt")
        public void testAssignmentFake() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantIf/assignmentFake.kt");
            doTest(fileName);
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantIf/expression.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionBody.kt")
        public void testExpressionBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantIf/expressionBody.kt");
            doTest(fileName);
        }

        @TestMetadata("negate.kt")
        public void testNegate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantIf/negate.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantIf/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantModalityModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantModalityModifier extends AbstractQuickFixTest {
        public void testAllFilesPresentInRedundantModalityModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantModalityModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("redundantAbstract.kt")
        public void testRedundantAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantModalityModifier/redundantAbstract.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantModalityModifier/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantSemicolon")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantSemicolon extends AbstractQuickFixTest {
        @TestMetadata("afterImport.kt")
        public void testAfterImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantSemicolon/afterImport.kt");
            doTest(fileName);
        }

        @TestMetadata("afterStatement.kt")
        public void testAfterStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantSemicolon/afterStatement.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInRedundantSemicolon() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantSemicolon"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantVisibilityModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantVisibilityModifier extends AbstractQuickFixTest {
        public void testAllFilesPresentInRedundantVisibilityModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantVisibilityModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/redundantVisibilityModifier/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/removeAnnotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveAnnotation extends AbstractQuickFixTest {
        public void testAllFilesPresentInRemoveAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeAnnotation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("jvmOverloads.kt")
        public void testJvmOverloads() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeAnnotation/jvmOverloads.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/removeFinalUpperBound")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveFinalUpperBound extends AbstractQuickFixTest {
        public void testAllFilesPresentInRemoveFinalUpperBound() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeFinalUpperBound"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeFinalUpperBound/basic.kt");
            doTest(fileName);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeFinalUpperBound/function.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/removeRedundantAssignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveRedundantAssignment extends AbstractQuickFixTest {
        public void testAllFilesPresentInRemoveRedundantAssignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeRedundantAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constant.kt")
        public void testConstant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeRedundantAssignment/constant.kt");
            doTest(fileName);
        }

        @TestMetadata("functionCall.kt")
        public void testFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeRedundantAssignment/functionCall.kt");
            doTest(fileName);
        }

        @TestMetadata("notRedundant.kt")
        public void testNotRedundant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeRedundantAssignment/notRedundant.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleRef.kt")
        public void testSimpleRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeRedundantAssignment/simpleRef.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/removeSingleLambdaParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveSingleLambdaParameter extends AbstractQuickFixTest {
        public void testAllFilesPresentInRemoveSingleLambdaParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeSingleLambdaParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multiple.kt")
        public void testMultiple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeSingleLambdaParameter/multiple.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeSingleLambdaParameter/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/removeToStringInStringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveToStringInStringTemplate extends AbstractQuickFixTest {
        public void testAllFilesPresentInRemoveToStringInStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeToStringInStringTemplate"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeToStringInStringTemplate/call.kt");
            doTest(fileName);
        }

        @TestMetadata("name.kt")
        public void testName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeToStringInStringTemplate/name.kt");
            doTest(fileName);
        }

        @TestMetadata("nameWithPostfix.kt")
        public void testNameWithPostfix() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeToStringInStringTemplate/nameWithPostfix.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeToStringInStringTemplate/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/removeUnused")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveUnused extends AbstractQuickFixTest {
        public void testAllFilesPresentInRemoveUnused() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeUnused"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("deledage.kt")
        public void testDeledage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/deledage.kt");
            doTest(fileName);
        }

        @TestMetadata("importEnumValues.kt")
        public void testImportEnumValues() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/importEnumValues.kt");
            doTest(fileName);
        }

        @TestMetadata("importObjectFun.kt")
        public void testImportObjectFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/importObjectFun.kt");
            doTest(fileName);
        }

        @TestMetadata("notTriangle.kt")
        public void testNotTriangle() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/notTriangle.kt");
            doTest(fileName);
        }

        @TestMetadata("triangle.kt")
        public void testTriangle() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/triangle.kt");
            doTest(fileName);
        }

        @TestMetadata("triangle2.kt")
        public void testTriangle2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/triangle2.kt");
            doTest(fileName);
        }

        @TestMetadata("unusedClass.kt")
        public void testUnusedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/unusedClass.kt");
            doTest(fileName);
        }

        @TestMetadata("unusedConstructor.kt")
        public void testUnusedConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/unusedConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("unusedFunction.kt")
        public void testUnusedFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/unusedFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("unusedProperty.kt")
        public void testUnusedProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/unusedProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("unusedPropertyAsConstructorParameter.kt")
        public void testUnusedPropertyAsConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/unusedPropertyAsConstructorParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("unusedTypeParameter.kt")
        public void testUnusedTypeParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/unusedTypeParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("usedClassAsAlias.kt")
        public void testUsedClassAsAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/usedClassAsAlias.kt");
            doTest(fileName);
        }

        @TestMetadata("usedFunAsAlias.kt")
        public void testUsedFunAsAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/usedFunAsAlias.kt");
            doTest(fileName);
        }

        @TestMetadata("usedObjectAsAlias.kt")
        public void testUsedObjectAsAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/usedObjectAsAlias.kt");
            doTest(fileName);
        }

        @TestMetadata("usedVarAsAlias.kt")
        public void testUsedVarAsAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnused/usedVarAsAlias.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/removeUnusedReceiver")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveUnusedReceiver extends AbstractQuickFixTest {
        public void testAllFilesPresentInRemoveUnusedReceiver() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeUnusedReceiver"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inFunction.kt")
        public void testInFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnusedReceiver/inFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("inProperty.kt")
        public void testInProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/removeUnusedReceiver/inProperty.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/renameToUnderscore")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RenameToUnderscore extends AbstractQuickFixTest {
        public void testAllFilesPresentInRenameToUnderscore() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/renameToUnderscore"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("commonDestructuring.kt")
        public void testCommonDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameToUnderscore/commonDestructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("forDestructuring.kt")
        public void testForDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameToUnderscore/forDestructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("functionExpressionParameterNoRemoveParameter.kt")
        public void testFunctionExpressionParameterNoRemoveParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameToUnderscore/functionExpressionParameterNoRemoveParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaDestructuring.kt")
        public void testLambdaDestructuring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameToUnderscore/lambdaDestructuring.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaParameter.kt")
        public void testLambdaParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameToUnderscore/lambdaParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaParameterNoRemoveParameter.kt")
        public void testLambdaParameterNoRemoveParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameToUnderscore/lambdaParameterNoRemoveParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("noActionForCommonFunction.kt")
        public void testNoActionForCommonFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameToUnderscore/noActionForCommonFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("noActionForCommonVal.kt")
        public void testNoActionForCommonVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameToUnderscore/noActionForCommonVal.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/renameUnresolvedReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RenameUnresolvedReference extends AbstractQuickFixTest {
        public void testAllFilesPresentInRenameUnresolvedReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/renameUnresolvedReference"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("qualifiedFunRef.kt")
        public void testQualifiedFunRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameUnresolvedReference/qualifiedFunRef.kt");
            doTest(fileName);
        }

        @TestMetadata("qualifiedPropertyRef.kt")
        public void testQualifiedPropertyRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameUnresolvedReference/qualifiedPropertyRef.kt");
            doTest(fileName);
        }

        @TestMetadata("typeRef.kt")
        public void testTypeRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameUnresolvedReference/typeRef.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedFunRef.kt")
        public void testUnqualifiedFunRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameUnresolvedReference/unqualifiedFunRef.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedPropertyRef.kt")
        public void testUnqualifiedPropertyRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameUnresolvedReference/unqualifiedPropertyRef.kt");
            doTest(fileName);
        }

        @TestMetadata("unqualifiedPropertyRefWithPackageError.kt")
        public void testUnqualifiedPropertyRefWithPackageError() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/renameUnresolvedReference/unqualifiedPropertyRefWithPackageError.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/simplifyComparison")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SimplifyComparison extends AbstractQuickFixTest {
        public void testAllFilesPresentInSimplifyComparison() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/simplifyComparison"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doubleNull.kt")
        public void testDoubleNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/simplifyComparison/doubleNull.kt");
            doTest(fileName);
        }

        @TestMetadata("notNull.kt")
        public void testNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/simplifyComparison/notNull.kt");
            doTest(fileName);
        }

        @TestMetadata("nullOrNotNull.kt")
        public void testNullOrNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/simplifyComparison/nullOrNotNull.kt");
            doTest(fileName);
        }

        @TestMetadata("somethingAndNotNull.kt")
        public void testSomethingAndNotNull() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/simplifyComparison/somethingAndNotNull.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/superTypeIsExtensionType")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SuperTypeIsExtensionType extends AbstractQuickFixTest {
        public void testAllFilesPresentInSuperTypeIsExtensionType() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/superTypeIsExtensionType"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("typeWith1Argument.kt")
        public void testTypeWith1Argument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/superTypeIsExtensionType/typeWith1Argument.kt");
            doTest(fileName);
        }

        @TestMetadata("typeWithNoArgument.kt")
        public void testTypeWithNoArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/superTypeIsExtensionType/typeWithNoArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("typeWithTypeArgument.kt")
        public void testTypeWithTypeArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/superTypeIsExtensionType/typeWithTypeArgument.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/supercalls")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Supercalls extends AbstractQuickFixTest {
        public void testAllFilesPresentInSupercalls() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/supercalls"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("typeArgumentsRedundantInSuperQualifier.kt")
        public void testTypeArgumentsRedundantInSuperQualifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supercalls/typeArgumentsRedundantInSuperQualifier.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/supertypeInitialization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SupertypeInitialization extends AbstractQuickFixTest {
        @TestMetadata("addImport.kt")
        public void testAddImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/addImport.kt");
            doTest(fileName);
        }

        @TestMetadata("addParameters.kt")
        public void testAddParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/addParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("addParenthesis.kt")
        public void testAddParenthesis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/addParenthesis.kt");
            doTest(fileName);
        }

        @TestMetadata("addParenthesisDefaultParameters.kt")
        public void testAddParenthesisDefaultParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/addParenthesisDefaultParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("addParenthesisEmptyConstructor.kt")
        public void testAddParenthesisEmptyConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/addParenthesisEmptyConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("addParenthesisForLocalClass.kt")
        public void testAddParenthesisForLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/addParenthesisForLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("addParenthesisForObjectExpression.kt")
        public void testAddParenthesisForObjectExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/addParenthesisForObjectExpression.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInSupertypeInitialization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/supertypeInitialization"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("baseConstructorError.kt")
        public void testBaseConstructorError() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/baseConstructorError.kt");
            doTest(fileName);
        }

        @TestMetadata("createConstructor.kt")
        public void testCreateConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/createConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("displayLongSignatures1.kt")
        public void testDisplayLongSignatures1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/displayLongSignatures1.kt");
            doTest(fileName);
        }

        @TestMetadata("displayLongSignatures2.kt")
        public void testDisplayLongSignatures2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/displayLongSignatures2.kt");
            doTest(fileName);
        }

        @TestMetadata("genericClass.kt")
        public void testGenericClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/genericClass.kt");
            doTest(fileName);
        }

        @TestMetadata("incompleteConstructor.kt")
        public void testIncompleteConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/incompleteConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("keywordName.kt")
        public void testKeywordName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/keywordName.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleConstructors.kt")
        public void testMultipleConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/multipleConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("noAccessibleConstructors.kt")
        public void testNoAccessibleConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/noAccessibleConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("noParameters.kt")
        public void testNoParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/noParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("primaryConstructorInaccessible.kt")
        public void testPrimaryConstructorInaccessible() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/primaryConstructorInaccessible.kt");
            doTest(fileName);
        }

        @TestMetadata("someParametersAlreadyExist.kt")
        public void testSomeParametersAlreadyExist() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/someParametersAlreadyExist.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg1.kt")
        public void testVararg1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/vararg1.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg2.kt")
        public void testVararg2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/vararg2.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg3.kt")
        public void testVararg3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/supertypeInitialization/vararg3.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/suppress")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Suppress extends AbstractQuickFixTest {
        public void testAllFilesPresentInSuppress() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/suppress/annotationPosition")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationPosition extends AbstractQuickFixTest {
            public void testAllFilesPresentInAnnotationPosition() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/annotationPosition"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("paramWithModifier.kt")
            public void testParamWithModifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/paramWithModifier.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionModifierOnThePreviousLine.kt")
            public void testTopLevelFunctionModifierOnThePreviousLine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionModifierOnThePreviousLine.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionModifierOnTheSameLine.kt")
            public void testTopLevelFunctionModifierOnTheSameLine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionModifierOnTheSameLine.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionNoModifiers.kt")
            public void testTopLevelFunctionNoModifiers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionNoModifiers.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressAnotherPreviousLine.kt")
            public void testTopLevelFunctionSuppressAnotherPreviousLine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressAnotherPreviousLine.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressEmptyArgsPreviousLine.kt")
            public void testTopLevelFunctionSuppressEmptyArgsPreviousLine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressEmptyArgsPreviousLine.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressNoArgsPreviousLine.kt")
            public void testTopLevelFunctionSuppressNoArgsPreviousLine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressNoArgsPreviousLine.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressNoArgsPreviousLineBare.kt")
            public void testTopLevelFunctionSuppressNoArgsPreviousLineBare() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressNoArgsPreviousLineBare.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressNoArgsTheSameLine.kt")
            public void testTopLevelFunctionSuppressNoArgsTheSameLine() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressNoArgsTheSameLine.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressNoArgsTheSameLineBare.kt")
            public void testTopLevelFunctionSuppressNoArgsTheSameLineBare() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressNoArgsTheSameLineBare.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressOnFile.kt")
            public void testTopLevelFunctionSuppressOnFile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressOnFile.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressOnFileOtherAnnotation.kt")
            public void testTopLevelFunctionSuppressOnFileOtherAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressOnFileOtherAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressOnFileWithPackage.kt")
            public void testTopLevelFunctionSuppressOnFileWithPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressOnFileWithPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionSuppressOnFileWithSuppress.kt")
            public void testTopLevelFunctionSuppressOnFileWithSuppress() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressOnFileWithSuppress.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionUnrelatedAnnotation.kt")
            public void testTopLevelFunctionUnrelatedAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionUnrelatedAnnotation.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionUnrelatedAnnotationBare.kt")
            public void testTopLevelFunctionUnrelatedAnnotationBare() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionUnrelatedAnnotationBare.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/availability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Availability extends AbstractQuickFixTest {
            public void testAllFilesPresentInAvailability() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/availability"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("localFunSuppressForLocal.kt")
            public void testLocalFunSuppressForLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/localFunSuppressForLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("localFunSuppressForOuter.kt")
            public void testLocalFunSuppressForOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/localFunSuppressForOuter.kt");
                doTest(fileName);
            }

            @TestMetadata("localValSuppressForFun.kt")
            public void testLocalValSuppressForFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/localValSuppressForFun.kt");
                doTest(fileName);
            }

            @TestMetadata("localValSuppressForVal.kt")
            public void testLocalValSuppressForVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/localValSuppressForVal.kt");
                doTest(fileName);
            }

            @TestMetadata("memberOfNestedSuppressForMember.kt")
            public void testMemberOfNestedSuppressForMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/memberOfNestedSuppressForMember.kt");
                doTest(fileName);
            }

            @TestMetadata("memberOfNestedSuppressForNested.kt")
            public void testMemberOfNestedSuppressForNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/memberOfNestedSuppressForNested.kt");
                doTest(fileName);
            }

            @TestMetadata("memberOfNestedSuppressForOuter.kt")
            public void testMemberOfNestedSuppressForOuter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/memberOfNestedSuppressForOuter.kt");
                doTest(fileName);
            }

            @TestMetadata("memberSuppressForClass.kt")
            public void testMemberSuppressForClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/memberSuppressForClass.kt");
                doTest(fileName);
            }

            @TestMetadata("memberSuppressForMember.kt")
            public void testMemberSuppressForMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/memberSuppressForMember.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFunctionAlreadySuppressed.kt")
            public void testTopLevelFunctionAlreadySuppressed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/availability/topLevelFunctionAlreadySuppressed.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/declarationKinds")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DeclarationKinds extends AbstractQuickFixTest {
            public void testAllFilesPresentInDeclarationKinds() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/declarationKinds"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("class.kt")
            public void testClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/class.kt");
                doTest(fileName);
            }

            @TestMetadata("classObject.kt")
            public void testClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/classObject.kt");
                doTest(fileName);
            }

            @TestMetadata("enumEntry.kt")
            public void testEnumEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/enumEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("fun.kt")
            public void testFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/fun.kt");
                doTest(fileName);
            }

            @TestMetadata("multiVal.kt")
            public void testMultiVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/multiVal.kt");
                doTest(fileName);
            }

            @TestMetadata("multiVar.kt")
            public void testMultiVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/multiVar.kt");
                doTest(fileName);
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/object.kt");
                doTest(fileName);
            }

            @TestMetadata("param.kt")
            public void testParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/param.kt");
                doTest(fileName);
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/secondaryConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("trait.kt")
            public void testTrait() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/trait.kt");
                doTest(fileName);
            }

            @TestMetadata("val.kt")
            public void testVal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/val.kt");
                doTest(fileName);
            }

            @TestMetadata("var.kt")
            public void testVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/declarationKinds/var.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/errorRecovery")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ErrorRecovery extends AbstractQuickFixTest {
            public void testAllFilesPresentInErrorRecovery() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/errorRecovery"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("nonStringInSuppress.kt")
            public void testNonStringInSuppress() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/errorRecovery/nonStringInSuppress.kt");
                doTest(fileName);
            }

            @TestMetadata("unresolvedAnnotation.kt")
            public void testUnresolvedAnnotation() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/errorRecovery/unresolvedAnnotation.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/forStatement")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForStatement extends AbstractQuickFixTest {
            public void testAllFilesPresentInForStatement() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/forStatement"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("andAnd.kt")
            public void testAndAnd() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/andAnd.kt");
                doTest(fileName);
            }

            @TestMetadata("annotatedExpr.kt")
            public void testAnnotatedExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/annotatedExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("annotatedExprWithSuppress.kt")
            public void testAnnotatedExprWithSuppress() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/annotatedExprWithSuppress.kt");
                doTest(fileName);
            }

            @TestMetadata("arrayRead.kt")
            public void testArrayRead() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/arrayRead.kt");
                doTest(fileName);
            }

            @TestMetadata("as.kt")
            public void testAs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/as.kt");
                doTest(fileName);
            }

            @TestMetadata("asSafe.kt")
            public void testAsSafe() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/asSafe.kt");
                doTest(fileName);
            }

            @TestMetadata("assign.kt")
            public void testAssign() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/assign.kt");
                doTest(fileName);
            }

            @TestMetadata("call.kt")
            public void testCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/call.kt");
                doTest(fileName);
            }

            @TestMetadata("doWhile.kt")
            public void testDoWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/doWhile.kt");
                doTest(fileName);
            }

            @TestMetadata("dotQualified.kt")
            public void testDotQualified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/dotQualified.kt");
                doTest(fileName);
            }

            @TestMetadata("elvis.kt")
            public void testElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/elvis.kt");
                doTest(fileName);
            }

            @TestMetadata("eqEq.kt")
            public void testEqEq() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/eqEq.kt");
                doTest(fileName);
            }

            @TestMetadata("for.kt")
            public void testFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/for.kt");
                doTest(fileName);
            }

            @TestMetadata("if.kt")
            public void testIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/if.kt");
                doTest(fileName);
            }

            @TestMetadata("in.kt")
            public void testIn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/in.kt");
                doTest(fileName);
            }

            @TestMetadata("infix.kt")
            public void testInfix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/infix.kt");
                doTest(fileName);
            }

            @TestMetadata("is.kt")
            public void testIs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/is.kt");
                doTest(fileName);
            }

            @TestMetadata("labeled.kt")
            public void testLabeled() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/labeled.kt");
                doTest(fileName);
            }

            @TestMetadata("less.kt")
            public void testLess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/less.kt");
                doTest(fileName);
            }

            @TestMetadata("mul.kt")
            public void testMul() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/mul.kt");
                doTest(fileName);
            }

            @TestMetadata("orOr.kt")
            public void testOrOr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/orOr.kt");
                doTest(fileName);
            }

            @TestMetadata("parenthesized.kt")
            public void testParenthesized() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/parenthesized.kt");
                doTest(fileName);
            }

            @TestMetadata("plus.kt")
            public void testPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/plus.kt");
                doTest(fileName);
            }

            @TestMetadata("postfix.kt")
            public void testPostfix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/postfix.kt");
                doTest(fileName);
            }

            @TestMetadata("postfixPlusPlus.kt")
            public void testPostfixPlusPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/postfixPlusPlus.kt");
                doTest(fileName);
            }

            @TestMetadata("prefixPlusPlus.kt")
            public void testPrefixPlusPlus() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/prefixPlusPlus.kt");
                doTest(fileName);
            }

            @TestMetadata("range.kt")
            public void testRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/range.kt");
                doTest(fileName);
            }

            @TestMetadata("return.kt")
            public void testReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/return.kt");
                doTest(fileName);
            }

            @TestMetadata("safeQualified.kt")
            public void testSafeQualified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/safeQualified.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleName.kt")
            public void testSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/simpleName.kt");
                doTest(fileName);
            }

            @TestMetadata("stringTemplate.kt")
            public void testStringTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/stringTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("throw.kt")
            public void testThrow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/throw.kt");
                doTest(fileName);
            }

            @TestMetadata("try.kt")
            public void testTry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/try.kt");
                doTest(fileName);
            }

            @TestMetadata("whenExpressionEntry.kt")
            public void testWhenExpressionEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/whenExpressionEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("whenInEntry.kt")
            public void testWhenInEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/whenInEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("whenIsEntry.kt")
            public void testWhenIsEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/whenIsEntry.kt");
                doTest(fileName);
            }

            @TestMetadata("whenSubject.kt")
            public void testWhenSubject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/whenSubject.kt");
                doTest(fileName);
            }

            @TestMetadata("while.kt")
            public void testWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/while.kt");
                doTest(fileName);
            }

            @TestMetadata("idea/testData/quickfix/suppress/forStatement/unavailable")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Unavailable extends AbstractQuickFixTest {
                public void testAllFilesPresentInUnavailable() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/forStatement/unavailable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("inAnnotationArgument.kt")
                public void testInAnnotationArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/inAnnotationArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("inClassHeader.kt")
                public void testInClassHeader() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/inClassHeader.kt");
                    doTest(fileName);
                }

                @TestMetadata("inDefaultArgument.kt")
                public void testInDefaultArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/inDefaultArgument.kt");
                    doTest(fileName);
                }

                @TestMetadata("inExpressionBody.kt")
                public void testInExpressionBody() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/inExpressionBody.kt");
                    doTest(fileName);
                }

                @TestMetadata("inLocalValInitializer.kt")
                public void testInLocalValInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/inLocalValInitializer.kt");
                    doTest(fileName);
                }

                @TestMetadata("inParameterType.kt")
                public void testInParameterType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/inParameterType.kt");
                    doTest(fileName);
                }

                @TestMetadata("inParameterTypeInFunctionLiteral.kt")
                public void testInParameterTypeInFunctionLiteral() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/inParameterTypeInFunctionLiteral.kt");
                    doTest(fileName);
                }

                @TestMetadata("inPropertyInitializer.kt")
                public void testInPropertyInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/inPropertyInitializer.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectLiteral.kt")
                public void testObjectLiteral() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/objectLiteral.kt");
                    doTest(fileName);
                }

                @TestMetadata("objectLiteralInsideExpression.kt")
                public void testObjectLiteralInsideExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/objectLiteralInsideExpression.kt");
                    doTest(fileName);
                }

                @TestMetadata("supretype.kt")
                public void testSupretype() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/forStatement/unavailable/supretype.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/inspections")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inspections extends AbstractQuickFixTest {
            public void testAllFilesPresentInInspections() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/inspections"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ifNullToElvis.kt")
            public void testIfNullToElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/inspections/ifNullToElvis.kt");
                doTest(fileName);
            }

            @TestMetadata("unusedImports.kt")
            public void testUnusedImports() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/suppress/inspections/unusedImports.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/surroundWithNullCheck")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SurroundWithNullCheck extends AbstractQuickFixTest {
        public void testAllFilesPresentInSurroundWithNullCheck() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/surroundWithNullCheck"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentNullable.kt")
        public void testArgumentNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/argumentNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("chainedUnsafeCall.kt")
        public void testChainedUnsafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/chainedUnsafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionUnsafeCall.kt")
        public void testExpressionUnsafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/expressionUnsafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("infixUnsafeCall.kt")
        public void testInfixUnsafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/infixUnsafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("invokeFuncUnsafe.kt")
        public void testInvokeFuncUnsafe() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/invokeFuncUnsafe.kt");
            doTest(fileName);
        }

        @TestMetadata("invokeUnsafe.kt")
        public void testInvokeUnsafe() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/invokeUnsafe.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorUnsafe.kt")
        public void testIteratorUnsafe() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/iteratorUnsafe.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableInCondition.kt")
        public void testNullableInCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/nullableInCondition.kt");
            doTest(fileName);
        }

        @TestMetadata("objectQualifier.kt")
        public void testObjectQualifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/objectQualifier.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleUnsafeCall.kt")
        public void testSimpleUnsafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/simpleUnsafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCallInBinary.kt")
        public void testUnsafeCallInBinary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInBinary.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCallInDeclaration.kt")
        public void testUnsafeCallInDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCallInGetter.kt")
        public void testUnsafeCallInGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCallInsideAnonymous.kt")
        public void testUnsafeCallInsideAnonymous() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInsideAnonymous.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCallInsideIf.kt")
        public void testUnsafeCallInsideIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInsideIf.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCallInsideWhen.kt")
        public void testUnsafeCallInsideWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInsideWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("unsafeCallInsideWhile.kt")
        public void testUnsafeCallInsideWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInsideWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("unstableValue.kt")
        public void testUnstableValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/surroundWithNullCheck/unstableValue.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/toString")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToString extends AbstractQuickFixTest {
        public void testAllFilesPresentInToString() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/toString"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notNullableExpectedNullable.kt")
        public void testNotNullableExpectedNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/toString/notNullableExpectedNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableExpectedNotNullable.kt")
        public void testNullableExpectedNotNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/toString/nullableExpectedNotNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("nullableExpectedNullable.kt")
        public void testNullableExpectedNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/toString/nullableExpectedNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/toString/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/tooLongCharLiteralToString")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TooLongCharLiteralToString extends AbstractQuickFixTest {
        public void testAllFilesPresentInTooLongCharLiteralToString() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/tooLongCharLiteralToString"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("backslashShouldNotBeEscaped.kt")
        public void testBackslashShouldNotBeEscaped() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/tooLongCharLiteralToString/backslashShouldNotBeEscaped.kt");
            doTest(fileName);
        }

        @TestMetadata("dollarShouldNotBeEscaped.kt")
        public void testDollarShouldNotBeEscaped() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/tooLongCharLiteralToString/dollarShouldNotBeEscaped.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleQuotesShouldBeEscaped.kt")
        public void testDoubleQuotesShouldBeEscaped() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/tooLongCharLiteralToString/doubleQuotesShouldBeEscaped.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/typeAddition")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeAddition extends AbstractQuickFixTest {
        public void testAllFilesPresentInTypeAddition() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeAddition"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ambiguousFunctionReturnType.kt")
        public void testAmbiguousFunctionReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/ambiguousFunctionReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("ambiguousPropertyReturnType.kt")
        public void testAmbiguousPropertyReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/ambiguousPropertyReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("changeAccessorTypeToFunctionType.kt")
        public void testChangeAccessorTypeToFunctionType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/changeAccessorTypeToFunctionType.kt");
            doTest(fileName);
        }

        @TestMetadata("noAddErrorType.kt")
        public void testNoAddErrorType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/noAddErrorType.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithGetterWithBlockBody.kt")
        public void testPropertyWithGetterWithBlockBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/propertyWithGetterWithBlockBody.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithGetterWithInferredType.kt")
        public void testPropertyWithGetterWithInferredType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/propertyWithGetterWithInferredType.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithGetterWithoutType.kt")
        public void testPropertyWithGetterWithoutType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/propertyWithGetterWithoutType.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithRecursiveGetter.kt")
        public void testPropertyWithRecursiveGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/propertyWithRecursiveGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithSetterWithoutType.kt")
        public void testPropertyWithSetterWithoutType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/propertyWithSetterWithoutType.kt");
            doTest(fileName);
        }

        @TestMetadata("protectedFunWithoutReturnType.kt")
        public void testProtectedFunWithoutReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/protectedFunWithoutReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("publicFunWithoutBody.kt")
        public void testPublicFunWithoutBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/publicFunWithoutBody.kt");
            doTest(fileName);
        }

        @TestMetadata("publicFunWithoutReturnType.kt")
        public void testPublicFunWithoutReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/publicFunWithoutReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("publicFunWithoutReturnTypeCaretOnParameter.kt")
        public void testPublicFunWithoutReturnTypeCaretOnParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/publicFunWithoutReturnTypeCaretOnParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("publicValWithoutReturnType.kt")
        public void testPublicValWithoutReturnType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/publicValWithoutReturnType.kt");
            doTest(fileName);
        }

        @TestMetadata("publicValWithoutReturnTypeCaretOnPublic.kt")
        public void testPublicValWithoutReturnTypeCaretOnPublic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/publicValWithoutReturnTypeCaretOnPublic.kt");
            doTest(fileName);
        }

        @TestMetadata("wrongGetterParameterType.kt")
        public void testWrongGetterParameterType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/wrongGetterParameterType.kt");
            doTest(fileName);
        }

        @TestMetadata("wrongGetterParameterTypeLongNameRuntime.kt")
        public void testWrongGetterParameterTypeLongNameRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/wrongGetterParameterTypeLongNameRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("wrongSetterParameterType.kt")
        public void testWrongSetterParameterType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeAddition/wrongSetterParameterType.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/typeImports")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeImports extends AbstractQuickFixTest {
        public void testAllFilesPresentInTypeImports() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeImports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("hasThisImport.kt")
        public void testHasThisImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeImports/hasThisImport.kt");
            doTest(fileName);
        }

        @TestMetadata("noImportFromTheSameFile.kt")
        public void testNoImportFromTheSameFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeImports/noImportFromTheSameFile.kt");
            doTest(fileName);
        }

        @TestMetadata("noImportJavaLang.kt")
        public void testNoImportJavaLang() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeImports/noImportJavaLang.kt");
            doTest(fileName);
        }

        @TestMetadata("noImportJetStandard.kt")
        public void testNoImportJetStandard() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeImports/noImportJetStandard.kt");
            doTest(fileName);
        }

        @TestMetadata("toImport1.kt")
        public void testToImport1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeImports/toImport1.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/typeInferenceExpectedTypeMismatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeInferenceExpectedTypeMismatch extends AbstractQuickFixTest {
        public void testAllFilesPresentInTypeInferenceExpectedTypeMismatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeInferenceExpectedTypeMismatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("convertClassToKClass1Runtime.kt")
        public void testConvertClassToKClass1Runtime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeInferenceExpectedTypeMismatch/convertClassToKClass1Runtime.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/typeMismatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeMismatch extends AbstractQuickFixTest {
        @TestMetadata("accessibleLocalClassInReturn.kt")
        public void testAccessibleLocalClassInReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/accessibleLocalClassInReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("addArrayOfType.kt")
        public void testAddArrayOfType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/addArrayOfType.kt");
            doTest(fileName);
        }

        @TestMetadata("addArrayOfTypeForNamedParameter.kt")
        public void testAddArrayOfTypeForNamedParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/addArrayOfTypeForNamedParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("addExclExclToRemoveNullability.kt")
        public void testAddExclExclToRemoveNullability() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/addExclExclToRemoveNullability.kt");
            doTest(fileName);
        }

        @TestMetadata("addExclExclToRemoveNullabilityDisabledWhenItCannotHelp.kt")
        public void testAddExclExclToRemoveNullabilityDisabledWhenItCannotHelp() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/addExclExclToRemoveNullabilityDisabledWhenItCannotHelp.kt");
            doTest(fileName);
        }

        @TestMetadata("addExclExclToRemoveNullabilityForGeneric.kt")
        public void testAddExclExclToRemoveNullabilityForGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/addExclExclToRemoveNullabilityForGeneric.kt");
            doTest(fileName);
        }

        @TestMetadata("addExclExclToRemoveNullabilityForSubclass.kt")
        public void testAddExclExclToRemoveNullabilityForSubclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/addExclExclToRemoveNullabilityForSubclass.kt");
            doTest(fileName);
        }

        @TestMetadata("addExclExclWhenSmartCastImpossible.kt")
        public void testAddExclExclWhenSmartCastImpossible() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/addExclExclWhenSmartCastImpossible.kt");
            doTest(fileName);
        }

        @TestMetadata("addIntArrayOf.kt")
        public void testAddIntArrayOf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/addIntArrayOf.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInTypeMismatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObjectInCall.kt")
        public void testAnonymousObjectInCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/anonymousObjectInCall.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectInInfixCall.kt")
        public void testAnonymousObjectInInfixCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/anonymousObjectInInfixCall.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectInInitializer.kt")
        public void testAnonymousObjectInInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/anonymousObjectInInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectInReturn.kt")
        public void testAnonymousObjectInReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/anonymousObjectInReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("anyInReturn.kt")
        public void testAnyInReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/anyInReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("changeFunctionLiteralParameterTypeToFunctionType.kt")
        public void testChangeFunctionLiteralParameterTypeToFunctionType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeFunctionLiteralParameterTypeToFunctionType.kt");
            doTest(fileName);
        }

        @TestMetadata("changeFunctionLiteralParameterTypeToFunctionTypeLongNameRuntime.kt")
        public void testChangeFunctionLiteralParameterTypeToFunctionTypeLongNameRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeFunctionLiteralParameterTypeToFunctionTypeLongNameRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("changeFunctionReturnTypeToMatchExpectedTypeOfCall.kt")
        public void testChangeFunctionReturnTypeToMatchExpectedTypeOfCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeFunctionReturnTypeToMatchExpectedTypeOfCall.kt");
            doTest(fileName);
        }

        @TestMetadata("changeFunctionReturnTypeToMatchExpectedTypeOfCallLongNameRuntime.kt")
        public void testChangeFunctionReturnTypeToMatchExpectedTypeOfCallLongNameRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeFunctionReturnTypeToMatchExpectedTypeOfCallLongNameRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("changeReturnTypeNoFqNameForAnonymousObject.kt")
        public void testChangeReturnTypeNoFqNameForAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForAnonymousObject.kt");
            doTest(fileName);
        }

        @TestMetadata("changeReturnTypeNoFqNameForCompanionObject.kt")
        public void testChangeReturnTypeNoFqNameForCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForCompanionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("changeReturnTypeNoFqNameForLocalClass.kt")
        public void testChangeReturnTypeNoFqNameForLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("changeReturnTypeNoFqNameForNestedClass.kt")
        public void testChangeReturnTypeNoFqNameForNestedClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForNestedClass.kt");
            doTest(fileName);
        }

        @TestMetadata("changeReturnTypeNoFqNameForTopLevelClass.kt")
        public void testChangeReturnTypeNoFqNameForTopLevelClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForTopLevelClass.kt");
            doTest(fileName);
        }

        @TestMetadata("changeReturnTypeToSpecificNullable.kt")
        public void testChangeReturnTypeToSpecificNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeReturnTypeToSpecificNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("changeReturnTypeWhenFunctionNameIsMissing.kt")
        public void testChangeReturnTypeWhenFunctionNameIsMissing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeReturnTypeWhenFunctionNameIsMissing.kt");
            doTest(fileName);
        }

        @TestMetadata("changeReturnTypeWhenValueParameterListIsAbsent.kt")
        public void testChangeReturnTypeWhenValueParameterListIsAbsent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/changeReturnTypeWhenValueParameterListIsAbsent.kt");
            doTest(fileName);
        }

        @TestMetadata("compareToTypeMismatch.kt")
        public void testCompareToTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/compareToTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("constantTypeMismatch.kt")
        public void testConstantTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/constantTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("dontChangeOverriddenPropertyTypeToErrorType.kt")
        public void testDontChangeOverriddenPropertyTypeToErrorType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/dontChangeOverriddenPropertyTypeToErrorType.kt");
            doTest(fileName);
        }

        @TestMetadata("expectedParameterTypeMismatch.kt")
        public void testExpectedParameterTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/expectedParameterTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("expectedParameterTypeMismatchLongNameRuntime.kt")
        public void testExpectedParameterTypeMismatchLongNameRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/expectedParameterTypeMismatchLongNameRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("hasNextFunctionReturnTypeMismatch.kt")
        public void testHasNextFunctionReturnTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/hasNextFunctionReturnTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("intToShortTypeMismatch.kt")
        public void testIntToShortTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/intToShortTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("letClassImplementAdditionalInterface.kt")
        public void testLetClassImplementAdditionalInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letClassImplementAdditionalInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("letClassImplementGenericInterface.kt")
        public void testLetClassImplementGenericInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letClassImplementGenericInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("letClassImplementGenericInterfaceTwice.kt")
        public void testLetClassImplementGenericInterfaceTwice() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letClassImplementGenericInterfaceTwice.kt");
            doTest(fileName);
        }

        @TestMetadata("letClassImplementGenericStarInterface.kt")
        public void testLetClassImplementGenericStarInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letClassImplementGenericStarInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("letClassImplementIndirectlyInheritedInterface.kt")
        public void testLetClassImplementIndirectlyInheritedInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letClassImplementIndirectlyInheritedInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("letClassImplementInterface.kt")
        public void testLetClassImplementInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letClassImplementInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("letClassImplementInterfaceNullable.kt")
        public void testLetClassImplementInterfaceNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letClassImplementInterfaceNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("letInterfaceExtendInterface.kt")
        public void testLetInterfaceExtendInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letInterfaceExtendInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("letObjectImplementAdditionalInterface.kt")
        public void testLetObjectImplementAdditionalInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letObjectImplementAdditionalInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("letObjectLiteralImplementInterface.kt")
        public void testLetObjectLiteralImplementInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letObjectLiteralImplementInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("letStringImplementInterface.kt")
        public void testLetStringImplementInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/letStringImplementInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("localClassInReturn1.kt")
        public void testLocalClassInReturn1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/localClassInReturn1.kt");
            doTest(fileName);
        }

        @TestMetadata("localClassInReturn2.kt")
        public void testLocalClassInReturn2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/localClassInReturn2.kt");
            doTest(fileName);
        }

        @TestMetadata("longToDoubleTypeMismatch.kt")
        public void testLongToDoubleTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/longToDoubleTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("longToIntTypeMismatch.kt")
        public void testLongToIntTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/longToIntTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("makeReturnTypeNullable.kt")
        public void testMakeReturnTypeNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/makeReturnTypeNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("noReturnInFunctionWithBlockBody.kt")
        public void testNoReturnInFunctionWithBlockBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/noReturnInFunctionWithBlockBody.kt");
            doTest(fileName);
        }

        @TestMetadata("nullArgumentForNonNullParameter.kt")
        public void testNullArgumentForNonNullParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/nullArgumentForNonNullParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyTypeMismatch.kt")
        public void testPropertyTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/propertyTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyTypeMismatchLongNameRuntime.kt")
        public void testPropertyTypeMismatchLongNameRuntime() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/propertyTypeMismatchLongNameRuntime.kt");
            doTest(fileName);
        }

        @TestMetadata("resolvableTypeParams.kt")
        public void testResolvableTypeParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/resolvableTypeParams.kt");
            doTest(fileName);
        }

        @TestMetadata("returnTypeMismatch.kt")
        public void testReturnTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/returnTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("shortToByteTypeMismatch.kt")
        public void testShortToByteTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/shortToByteTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("tooManyArgumentsException.kt")
        public void testTooManyArgumentsException() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/tooManyArgumentsException.kt");
            doTest(fileName);
        }

        @TestMetadata("unresolvableTypeParams.kt")
        public void testUnresolvableTypeParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/unresolvableTypeParams.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/casts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Casts extends AbstractQuickFixTest {
            public void testAllFilesPresentInCasts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/casts"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("castToFunctionType.kt")
            public void testCastToFunctionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/castToFunctionType.kt");
                doTest(fileName);
            }

            @TestMetadata("smartcastImpossible1.kt")
            public void testSmartcastImpossible1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/smartcastImpossible1.kt");
                doTest(fileName);
            }

            @TestMetadata("smartcastImpossible2.kt")
            public void testSmartcastImpossible2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/smartcastImpossible2.kt");
                doTest(fileName);
            }

            @TestMetadata("smartcastImpossible3.kt")
            public void testSmartcastImpossible3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/smartcastImpossible3.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatch1.kt")
            public void testTypeMismatch1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/typeMismatch1.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatch2.kt")
            public void testTypeMismatch2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/typeMismatch2.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatch3.kt")
            public void testTypeMismatch3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/typeMismatch3.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatch4.kt")
            public void testTypeMismatch4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/typeMismatch4.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchLongNameRuntime.kt")
            public void testTypeMismatchLongNameRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/casts/typeMismatchLongNameRuntime.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ComponentFunctionReturnTypeMismatch extends AbstractQuickFixTest {
            public void testAllFilesPresentInComponentFunctionReturnTypeMismatch() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("componentFunctionReturnTypeMismatch1.kt")
            public void testComponentFunctionReturnTypeMismatch1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch1.kt");
                doTest(fileName);
            }

            @TestMetadata("componentFunctionReturnTypeMismatch2.kt")
            public void testComponentFunctionReturnTypeMismatch2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch2.kt");
                doTest(fileName);
            }

            @TestMetadata("componentFunctionReturnTypeMismatch3.kt")
            public void testComponentFunctionReturnTypeMismatch3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch3.kt");
                doTest(fileName);
            }

            @TestMetadata("componentFunctionReturnTypeMismatch4.kt")
            public void testComponentFunctionReturnTypeMismatch4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch4.kt");
                doTest(fileName);
            }

            @TestMetadata("componentFunctionReturnTypeMismatch5.kt")
            public void testComponentFunctionReturnTypeMismatch5() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch5.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/fixOverloadedOperator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FixOverloadedOperator extends AbstractQuickFixTest {
            public void testAllFilesPresentInFixOverloadedOperator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/fixOverloadedOperator"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeNotFunctionReturnType.kt")
            public void testChangeNotFunctionReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/fixOverloadedOperator/changeNotFunctionReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("changePlusFunctionReturnType.kt")
            public void testChangePlusFunctionReturnType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/fixOverloadedOperator/changePlusFunctionReturnType.kt");
                doTest(fileName);
            }

            @TestMetadata("changeTimesFunctionParameterType.kt")
            public void testChangeTimesFunctionParameterType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/fixOverloadedOperator/changeTimesFunctionParameterType.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/numberConversion")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NumberConversion extends AbstractQuickFixTest {
            public void testAllFilesPresentInNumberConversion() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/numberConversion"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("convertBinaryExpression.kt")
            public void testConvertBinaryExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/numberConversion/convertBinaryExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("convertExpression.kt")
            public void testConvertExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/numberConversion/convertExpression.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ParameterTypeMismatch extends AbstractQuickFixTest {
            public void testAllFilesPresentInParameterTypeMismatch() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/parameterTypeMismatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeFunctionParameterType1.kt")
            public void testChangeFunctionParameterType1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeFunctionParameterType1.kt");
                doTest(fileName);
            }

            @TestMetadata("changeFunctionParameterType2.kt")
            public void testChangeFunctionParameterType2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeFunctionParameterType2.kt");
                doTest(fileName);
            }

            @TestMetadata("changeFunctionParameterType3.kt")
            public void testChangeFunctionParameterType3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeFunctionParameterType3.kt");
                doTest(fileName);
            }

            @TestMetadata("changeFunctionParameterType4.kt")
            public void testChangeFunctionParameterType4() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeFunctionParameterType4.kt");
                doTest(fileName);
            }

            @TestMetadata("changeParameterTypeLongNameRuntime.kt")
            public void testChangeParameterTypeLongNameRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeParameterTypeLongNameRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("changePrimaryConstructorParameterType.kt")
            public void testChangePrimaryConstructorParameterType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changePrimaryConstructorParameterType.kt");
                doTest(fileName);
            }

            @TestMetadata("multiFakeOverride.kt")
            public void testMultiFakeOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/multiFakeOverride.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeMismatchOnReturnedExpression extends AbstractQuickFixTest {
            public void testAllFilesPresentInTypeMismatchOnReturnedExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignmentTypeMismatch.kt")
            public void testAssignmentTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/assignmentTypeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("changeFunctionReturnTypeToFunctionType.kt")
            public void testChangeFunctionReturnTypeToFunctionType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/changeFunctionReturnTypeToFunctionType.kt");
                doTest(fileName);
            }

            @TestMetadata("changeFunctionReturnTypeToMatchReturnTypeOfReturnedLiteral.kt")
            public void testChangeFunctionReturnTypeToMatchReturnTypeOfReturnedLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/changeFunctionReturnTypeToMatchReturnTypeOfReturnedLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("dontChangeFunctionReturnTypeToErrorType.kt")
            public void testDontChangeFunctionReturnTypeToErrorType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/dontChangeFunctionReturnTypeToErrorType.kt");
                doTest(fileName);
            }

            @TestMetadata("literalPropertyWithGetter.kt")
            public void testLiteralPropertyWithGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/literalPropertyWithGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("multiFakeOverride.kt")
            public void testMultiFakeOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/multiFakeOverride.kt");
                doTest(fileName);
            }

            @TestMetadata("multiFakeOverrideForOperatorConvention.kt")
            public void testMultiFakeOverrideForOperatorConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/multiFakeOverrideForOperatorConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLocalReturnRuntime.kt")
            public void testNonLocalReturnRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/nonLocalReturnRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("nonLocalReturnWithLabelRuntime.kt")
            public void testNonLocalReturnWithLabelRuntime() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/nonLocalReturnWithLabelRuntime.kt");
                doTest(fileName);
            }

            @TestMetadata("notApplicableToConstructor.kt")
            public void testNotApplicableToConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/notApplicableToConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyGetterInitializerTypeMismatch.kt")
            public void testPropertyGetterInitializerTypeMismatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/propertyGetterInitializerTypeMismatch.kt");
                doTest(fileName);
            }

            @TestMetadata("returnedExpressionTypeMismatchFunctionParameterType.kt")
            public void testReturnedExpressionTypeMismatchFunctionParameterType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/returnedExpressionTypeMismatchFunctionParameterType.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchInIfStatementReturnedByFunction.kt")
            public void testTypeMismatchInIfStatementReturnedByFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/typeMismatchInIfStatementReturnedByFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchInIfStatementReturnedByLiteral.kt")
            public void testTypeMismatchInIfStatementReturnedByLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/typeMismatchInIfStatementReturnedByLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchInInitializer.kt")
            public void testTypeMismatchInInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/typeMismatchInInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("typeMismatchInReturnStatement.kt")
            public void testTypeMismatchInReturnStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/typeMismatchInReturnStatement.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class WrongPrimitive extends AbstractQuickFixTest {
            public void testAllFilesPresentInWrongPrimitive() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/wrongPrimitive"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("doubleToIntDecimalPlaces.kt")
            public void testDoubleToIntDecimalPlaces() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/doubleToIntDecimalPlaces.kt");
                doTest(fileName);
            }

            @TestMetadata("doubleToLongNotInRange.kt")
            public void testDoubleToLongNotInRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/doubleToLongNotInRange.kt");
                doTest(fileName);
            }

            @TestMetadata("doubleToShortNotInRange.kt")
            public void testDoubleToShortNotInRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/doubleToShortNotInRange.kt");
                doTest(fileName);
            }

            @TestMetadata("floatToDoubleWithDecimal.kt")
            public void testFloatToDoubleWithDecimal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/floatToDoubleWithDecimal.kt");
                doTest(fileName);
            }

            @TestMetadata("floatToInt.kt")
            public void testFloatToInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/floatToInt.kt");
                doTest(fileName);
            }

            @TestMetadata("floatToInt2.kt")
            public void testFloatToInt2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/floatToInt2.kt");
                doTest(fileName);
            }

            @TestMetadata("floatToLong.kt")
            public void testFloatToLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/floatToLong.kt");
                doTest(fileName);
            }

            @TestMetadata("hexToFloat.kt")
            public void testHexToFloat() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/hexToFloat.kt");
                doTest(fileName);
            }

            @TestMetadata("intToFloat.kt")
            public void testIntToFloat() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/intToFloat.kt");
                doTest(fileName);
            }

            @TestMetadata("longToDouble.kt")
            public void testLongToDouble() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/longToDouble.kt");
                doTest(fileName);
            }

            @TestMetadata("longToInt.kt")
            public void testLongToInt() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/longToInt.kt");
                doTest(fileName);
            }

            @TestMetadata("longToIntBinary.kt")
            public void testLongToIntBinary() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive/longToIntBinary.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/typeParameters")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeParameters extends AbstractQuickFixTest {
        public void testAllFilesPresentInTypeParameters() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeParameters"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("misplacedClassTypeParameter.kt")
        public void testMisplacedClassTypeParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeParameters/misplacedClassTypeParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("misplacedFunctionTypeParameter.kt")
        public void testMisplacedFunctionTypeParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeParameters/misplacedFunctionTypeParameter.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/typeProjection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeProjection extends AbstractQuickFixTest {
        public void testAllFilesPresentInTypeProjection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeProjection"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conflictingProjection.kt")
        public void testConflictingProjection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeProjection/conflictingProjection.kt");
            doTest(fileName);
        }

        @TestMetadata("projectionInImmediateArgumentToSupertype.kt")
        public void testProjectionInImmediateArgumentToSupertype() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeProjection/projectionInImmediateArgumentToSupertype.kt");
            doTest(fileName);
        }

        @TestMetadata("projectionOnNonClassTypeArgument1.kt")
        public void testProjectionOnNonClassTypeArgument1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeProjection/projectionOnNonClassTypeArgument1.kt");
            doTest(fileName);
        }

        @TestMetadata("projectionOnNonClassTypeArgument2.kt")
        public void testProjectionOnNonClassTypeArgument2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeProjection/projectionOnNonClassTypeArgument2.kt");
            doTest(fileName);
        }

        @TestMetadata("removeRedundantProjection1.kt")
        public void testRemoveRedundantProjection1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeProjection/removeRedundantProjection1.kt");
            doTest(fileName);
        }

        @TestMetadata("removeRedundantProjection2.kt")
        public void testRemoveRedundantProjection2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeProjection/removeRedundantProjection2.kt");
            doTest(fileName);
        }

        @TestMetadata("removeVariance.kt")
        public void testRemoveVariance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/typeProjection/removeVariance.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/unnecessaryLateinit")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnnecessaryLateinit extends AbstractQuickFixTest {
        public void testAllFilesPresentInUnnecessaryLateinit() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/unnecessaryLateinit"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lateinitWithConstructor.kt")
        public void testLateinitWithConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unnecessaryLateinit/lateinitWithConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("lateinitWithInit.kt")
        public void testLateinitWithInit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unnecessaryLateinit/lateinitWithInit.kt");
            doTest(fileName);
        }

        @TestMetadata("lateinitWithMultipleConstructors.kt")
        public void testLateinitWithMultipleConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unnecessaryLateinit/lateinitWithMultipleConstructors.kt");
            doTest(fileName);
        }

        @TestMetadata("lateinitWithMultipleConstructorsAndDelegation.kt")
        public void testLateinitWithMultipleConstructorsAndDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unnecessaryLateinit/lateinitWithMultipleConstructorsAndDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("lateinitWithMultipleInit.kt")
        public void testLateinitWithMultipleInit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unnecessaryLateinit/lateinitWithMultipleInit.kt");
            doTest(fileName);
        }

        @TestMetadata("secondaryConstructorDelegateItself.kt")
        public void testSecondaryConstructorDelegateItself() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unnecessaryLateinit/secondaryConstructorDelegateItself.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/unusedSuppressAnnotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnusedSuppressAnnotation extends AbstractQuickFixTest {
        public void testAllFilesPresentInUnusedSuppressAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/unusedSuppressAnnotation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notForDeprecated.kt")
        public void testNotForDeprecated() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unusedSuppressAnnotation/notForDeprecated.kt");
            doTest(fileName);
        }

        @TestMetadata("notForJava.kt")
        public void testNotForJava() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unusedSuppressAnnotation/notForJava.kt");
            doTest(fileName);
        }

        @TestMetadata("notForJetBrains.kt")
        public void testNotForJetBrains() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unusedSuppressAnnotation/notForJetBrains.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/unusedSuppressAnnotation/simple.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/variables")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Variables extends AbstractQuickFixTest {
        public void testAllFilesPresentInVariables() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("unusedVariableWithInitializer.kt")
        public void testUnusedVariableWithInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/unusedVariableWithInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("unusedVariableWithoutInitializer.kt")
        public void testUnusedVariableWithoutInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/unusedVariableWithoutInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("idea/testData/quickfix/variables/changeMutability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ChangeMutability extends AbstractQuickFixTest {
            public void testAllFilesPresentInChangeMutability() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/changeMutability"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("capturedValInitialization.kt")
            public void testCapturedValInitialization() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/capturedValInitialization.kt");
                doTest(fileName);
            }

            @TestMetadata("funParameter.kt")
            public void testFunParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/funParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("localInGetter.kt")
            public void testLocalInGetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/localInGetter.kt");
                doTest(fileName);
            }

            @TestMetadata("valOverrideVar.kt")
            public void testValOverrideVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/valOverrideVar.kt");
                doTest(fileName);
            }

            @TestMetadata("valOverrideVarConstructorParameter.kt")
            public void testValOverrideVarConstructorParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/valOverrideVarConstructorParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("valReassignmentLocal.kt")
            public void testValReassignmentLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/valReassignmentLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("valReassignmentOuterDecl.kt")
            public void testValReassignmentOuterDecl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/valReassignmentOuterDecl.kt");
                doTest(fileName);
            }

            @TestMetadata("valReassignmentProperty.kt")
            public void testValReassignmentProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/valReassignmentProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("valReassignmentPropertyConstructorParameter.kt")
            public void testValReassignmentPropertyConstructorParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/valReassignmentPropertyConstructorParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("valWithSetter.kt")
            public void testValWithSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/valWithSetter.kt");
                doTest(fileName);
            }

            @TestMetadata("idea/testData/quickfix/variables/changeMutability/canBeVal")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CanBeVal extends AbstractQuickFixTest {
                public void testAllFilesPresentInCanBeVal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/changeMutability/canBeVal"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("multiVariable.kt")
                public void testMultiVariable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/canBeVal/multiVariable.kt");
                    doTest(fileName);
                }

                @TestMetadata("singleVariable.kt")
                public void testSingleVariable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeMutability/canBeVal/singleVariable.kt");
                    doTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/variables/changeToFunctionInvocation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ChangeToFunctionInvocation extends AbstractQuickFixTest {
            public void testAllFilesPresentInChangeToFunctionInvocation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/changeToFunctionInvocation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("funInvWithoutParentheses.kt")
            public void testFunInvWithoutParentheses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeToFunctionInvocation/funInvWithoutParentheses.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/variables/changeToPropertyAccess")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ChangeToPropertyAccess extends AbstractQuickFixTest {
            public void testAllFilesPresentInChangeToPropertyAccess() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/changeToPropertyAccess"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("nonSimpleName.kt")
            public void testNonSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeToPropertyAccess/nonSimpleName.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyCall.kt")
            public void testPropertyCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeToPropertyAccess/propertyCall.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyCallWithArguments.kt")
            public void testPropertyCallWithArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/changeToPropertyAccess/propertyCallWithArguments.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("idea/testData/quickfix/variables/removeValVarFromParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RemoveValVarFromParameter extends AbstractQuickFixTest {
            public void testAllFilesPresentInRemoveValVarFromParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/removeValVarFromParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("catchParameter.kt")
            public void testCatchParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/removeValVarFromParameter/catchParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorParameter.kt")
            public void testConstructorParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/removeValVarFromParameter/constructorParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("funParameter.kt")
            public void testFunParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/removeValVarFromParameter/funParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("loopMultiParameter.kt")
            public void testLoopMultiParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/removeValVarFromParameter/loopMultiParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("loopParameter.kt")
            public void testLoopParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/removeValVarFromParameter/loopParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("parameterWithComment.kt")
            public void testParameterWithComment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/removeValVarFromParameter/parameterWithComment.kt");
                doTest(fileName);
            }

            @TestMetadata("secondaryConstructorParameter.kt")
            public void testSecondaryConstructorParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/variables/removeValVarFromParameter/secondaryConstructorParameter.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/when")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class When extends AbstractQuickFixTest {
        @TestMetadata("addElseBranchEnumStatement.kt")
        public void testAddElseBranchEnumStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/addElseBranchEnumStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("addRemainingBranchesBoolean.kt")
        public void testAddRemainingBranchesBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/addRemainingBranchesBoolean.kt");
            doTest(fileName);
        }

        @TestMetadata("addRemainingBranchesEnum.kt")
        public void testAddRemainingBranchesEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/addRemainingBranchesEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("addRemainingBranchesEnumStatement.kt")
        public void testAddRemainingBranchesEnumStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/addRemainingBranchesEnumStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("addRemainingBranchesInNonDefaultPackage.kt")
        public void testAddRemainingBranchesInNonDefaultPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/addRemainingBranchesInNonDefaultPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("addRemainingBranchesSealed.kt")
        public void testAddRemainingBranchesSealed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/addRemainingBranchesSealed.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInWhen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/when"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("breakInWhen.kt")
        public void testBreakInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/breakInWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("commasInConditionWithNoArguments.kt")
        public void testCommasInConditionWithNoArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/commasInConditionWithNoArguments.kt");
            doTest(fileName);
        }

        @TestMetadata("commasInConditionWithNoArguments2.kt")
        public void testCommasInConditionWithNoArguments2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/commasInConditionWithNoArguments2.kt");
            doTest(fileName);
        }

        @TestMetadata("continueInWhen.kt")
        public void testContinueInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/continueInWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("continueInWhenWithLabel.kt")
        public void testContinueInWhenWithLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/continueInWhenWithLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("elseNotLastInWhen.kt")
        public void testElseNotLastInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/elseNotLastInWhen.kt");
            doTest(fileName);
        }

        @TestMetadata("noElseInWhenWithBranches.kt")
        public void testNoElseInWhenWithBranches() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/noElseInWhenWithBranches.kt");
            doTest(fileName);
        }

        @TestMetadata("noElseInWhenWithoutBranches.kt")
        public void testNoElseInWhenWithoutBranches() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/noElseInWhenWithoutBranches.kt");
            doTest(fileName);
        }

        @TestMetadata("twoElseBranchesInWhen.kt")
        public void testTwoElseBranchesInWhen() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/when/twoElseBranchesInWhen.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/wrapWithSafeLetCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WrapWithSafeLetCall extends AbstractQuickFixTest {
        public void testAllFilesPresentInWrapWithSafeLetCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/wrapWithSafeLetCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentNullable.kt")
        public void testArgumentNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/argumentNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("chainedCallTypeMismatch.kt")
        public void testChainedCallTypeMismatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/chainedCallTypeMismatch.kt");
            doTest(fileName);
        }

        @TestMetadata("chainedUnsafeCall.kt")
        public void testChainedUnsafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/chainedUnsafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionUnsafeCall.kt")
        public void testExpressionUnsafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/expressionUnsafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("insideLet.kt")
        public void testInsideLet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/insideLet.kt");
            doTest(fileName);
        }

        @TestMetadata("invokeFuncUnsafe.kt")
        public void testInvokeFuncUnsafe() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/invokeFuncUnsafe.kt");
            doTest(fileName);
        }

        @TestMetadata("invokeUnsafe.kt")
        public void testInvokeUnsafe() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/invokeUnsafe.kt");
            doTest(fileName);
        }

        @TestMetadata("objectQualifier.kt")
        public void testObjectQualifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/objectQualifier.kt");
            doTest(fileName);
        }

        @TestMetadata("unstableValue.kt")
        public void testUnstableValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrapWithSafeLetCall/unstableValue.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("idea/testData/quickfix/wrongLongSuffix")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WrongLongSuffix extends AbstractQuickFixTest {
        public void testAllFilesPresentInWrongLongSuffix() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/wrongLongSuffix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/quickfix/wrongLongSuffix/simple.kt");
            doTest(fileName);
        }
    }
}
