/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.refactoring.introduce;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class ExtractionTestGenerated extends AbstractExtractionTest {
    @TestMetadata("idea/testData/refactoring/introduceVariable")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceVariable extends AbstractExtractionTest {
        public void testAllFilesPresentInIntroduceVariable() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceVariable"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ArrayAccessExpr.kt")
        public void testArrayAccessExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/ArrayAccessExpr.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("arrayAssignment.kt")
        public void testArrayAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/arrayAssignment.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("callUnderSmartCast.kt")
        public void testCallUnderSmartCast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/callUnderSmartCast.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("CantIntroduceToClass.kt")
        public void testCantIntroduceToClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/CantIntroduceToClass.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("CantIntroduceToFile.kt")
        public void testCantIntroduceToFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/CantIntroduceToFile.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("commentSkipping.kt")
        public void testCommentSkipping() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/commentSkipping.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("ComplexCallee.kt")
        public void testComplexCallee() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/ComplexCallee.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("ConstructorDelegationCall.kt")
        public void testConstructorDelegationCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/ConstructorDelegationCall.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("DelegatorByExpressionInDelegate.kt")
        public void testDelegatorByExpressionInDelegate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/DelegatorByExpressionInDelegate.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("DelegatorByExpressionInType.kt")
        public void testDelegatorByExpressionInType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/DelegatorByExpressionInType.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("DelegatorToSuperCallInArgument.kt")
        public void testDelegatorToSuperCallInArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/DelegatorToSuperCallInArgument.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("DelegatorToSuperCallInType.kt")
        public void testDelegatorToSuperCallInType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/DelegatorToSuperCallInType.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("DelegatorToSuperClass.kt")
        public void testDelegatorToSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/DelegatorToSuperClass.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("DoWhileAddBlock.kt")
        public void testDoWhileAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/DoWhileAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("DoWhileAddBlockInner.kt")
        public void testDoWhileAddBlockInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/DoWhileAddBlockInner.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("dynamicType.kt")
        public void testDynamicType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/dynamicType.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("FewOccurrences.kt")
        public void testFewOccurrences() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/FewOccurrences.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("FunctionAddBlock.kt")
        public void testFunctionAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/FunctionAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("FunctionAddBlockInner.kt")
        public void testFunctionAddBlockInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/FunctionAddBlockInner.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("FunctionLiteral.kt")
        public void testFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/FunctionLiteral.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("FunctionLiteralFromExpected.kt")
        public void testFunctionLiteralFromExpected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/FunctionLiteralFromExpected.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("FunctionLiteralWithExtraArgs.kt")
        public void testFunctionLiteralWithExtraArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/FunctionLiteralWithExtraArgs.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("IfCondition.kt")
        public void testIfCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/IfCondition.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("IfElseAddBlock.kt")
        public void testIfElseAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/IfElseAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("IfElseAddBlockInner.kt")
        public void testIfElseAddBlockInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/IfElseAddBlockInner.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("IfThenAddBlock.kt")
        public void testIfThenAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/IfThenAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("IfThenAddBlockInner.kt")
        public void testIfThenAddBlockInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/IfThenAddBlockInner.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("IfThenValuedAddBlock.kt")
        public void testIfThenValuedAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/IfThenValuedAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("InsideOfInitializerAnnotation.kt")
        public void testInsideOfInitializerAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/InsideOfInitializerAnnotation.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("IntroduceAndCreateBlock.kt")
        public void testIntroduceAndCreateBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/IntroduceAndCreateBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("IntroduceLambdaAndCreateBlock.kt")
        public void testIntroduceLambdaAndCreateBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/IntroduceLambdaAndCreateBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("It.kt")
        public void testIt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/It.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("kt10808.kt")
        public void testKt10808() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/kt10808.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("LoopRange.kt")
        public void testLoopRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/LoopRange.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("ManyInnerOccurences.kt")
        public void testManyInnerOccurences() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/ManyInnerOccurences.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("ManyOccurrences.kt")
        public void testManyOccurrences() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/ManyOccurrences.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("multilineBinaryExpression.kt")
        public void testMultilineBinaryExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multilineBinaryExpression.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("multilineBinaryExpressionWithComments.kt")
        public void testMultilineBinaryExpressionWithComments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multilineBinaryExpressionWithComments.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("multilineNestedBinaryExpression1.kt")
        public void testMultilineNestedBinaryExpression1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multilineNestedBinaryExpression1.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("multilineNestedBinaryExpression2.kt")
        public void testMultilineNestedBinaryExpression2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multilineNestedBinaryExpression2.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("NameSuggestionBug1.kt")
        public void testNameSuggestionBug1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/NameSuggestionBug1.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("NameSuggestionBug2.kt")
        public void testNameSuggestionBug2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/NameSuggestionBug2.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("NameSuggestionCheckVisibility.kt")
        public void testNameSuggestionCheckVisibility() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/NameSuggestionCheckVisibility.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("noConflictWithInnerVariable.kt")
        public void testNoConflictWithInnerVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/noConflictWithInnerVariable.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("NoExplicitReceivers.kt")
        public void testNoExplicitReceivers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/NoExplicitReceivers.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("NoExplicitReceiversUnresolved.kt")
        public void testNoExplicitReceiversUnresolved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/NoExplicitReceiversUnresolved.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("NoNewLinesInBetween.kt")
        public void testNoNewLinesInBetween() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/NoNewLinesInBetween.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("NoNewLinesInBetweenNoBraces.kt")
        public void testNoNewLinesInBetweenNoBraces() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/NoNewLinesInBetweenNoBraces.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("nonEquivalentReceivers.kt")
        public void testNonEquivalentReceivers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/nonEquivalentReceivers.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("notNullAssertion.kt")
        public void testNotNullAssertion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/notNullAssertion.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("OccurrencesInStringTemplate.kt")
        public void testOccurrencesInStringTemplate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/OccurrencesInStringTemplate.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("onAssignmentLHS.kt")
        public void testOnAssignmentLHS() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/onAssignmentLHS.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("OneExplicitReceiver.kt")
        public void testOneExplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/OneExplicitReceiver.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("PropertyAccessorAddBlock.kt")
        public void testPropertyAccessorAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/PropertyAccessorAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("PropertyAccessorAddBlockInner.kt")
        public void testPropertyAccessorAddBlockInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/PropertyAccessorAddBlockInner.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("qualifier.kt")
        public void testQualifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/qualifier.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("ReplaceOccurence.kt")
        public void testReplaceOccurence() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/ReplaceOccurence.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("selectorAssignment.kt")
        public void testSelectorAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/selectorAssignment.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/Simple.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("SimpleCreateValue.kt")
        public void testSimpleCreateValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/SimpleCreateValue.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("skipClassReference.kt")
        public void testSkipClassReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/skipClassReference.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("skipUsageInAssignmentLHS.kt")
        public void testSkipUsageInAssignmentLHS() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/skipUsageInAssignmentLHS.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("StringInjection.kt")
        public void testStringInjection() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/StringInjection.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("SuperReference.kt")
        public void testSuperReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/SuperReference.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("thisAsCallee.kt")
        public void testThisAsCallee() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/thisAsCallee.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("ThisReference.kt")
        public void testThisReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/ThisReference.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("TwoExplicitReceivers.kt")
        public void testTwoExplicitReceivers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/TwoExplicitReceivers.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("TypeElement.kt")
        public void testTypeElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/TypeElement.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("UnresolvedOccurrences.kt")
        public void testUnresolvedOccurrences() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/UnresolvedOccurrences.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("UsedAndUnusedExpressions1.kt")
        public void testUsedAndUnusedExpressions1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/UsedAndUnusedExpressions1.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("UsedAndUnusedExpressions2.kt")
        public void testUsedAndUnusedExpressions2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/UsedAndUnusedExpressions2.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("WhenAddBlock.kt")
        public void testWhenAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/WhenAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("WhenAddBlockInner.kt")
        public void testWhenAddBlockInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/WhenAddBlockInner.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("WhenEntryCondition.kt")
        public void testWhenEntryCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/WhenEntryCondition.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("WhenParts.kt")
        public void testWhenParts() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/WhenParts.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("WhenValuedAddBlock.kt")
        public void testWhenValuedAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/WhenValuedAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("WhileAddBlock.kt")
        public void testWhileAddBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/WhileAddBlock.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("WhileAddBlockInner.kt")
        public void testWhileAddBlockInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/WhileAddBlockInner.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("WhileCondition.kt")
        public void testWhileCondition() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/WhileCondition.kt");
            doIntroduceVariableTest(fileName);
        }

        @TestMetadata("idea/testData/refactoring/introduceVariable/explicateTypeArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExplicateTypeArguments extends AbstractExtractionTest {
            public void testAllFilesPresentInExplicateTypeArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceVariable/explicateTypeArguments"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("DeeperNestedCall.kt")
            public void testDeeperNestedCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/explicateTypeArguments/DeeperNestedCall.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("NestedCall.kt")
            public void testNestedCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/explicateTypeArguments/NestedCall.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("Parenthesized.kt")
            public void testParenthesized() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/explicateTypeArguments/Parenthesized.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("Qualified.kt")
            public void testQualified() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/explicateTypeArguments/Qualified.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/explicateTypeArguments/Simple.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("UnmatchedOccurrences.kt")
            public void testUnmatchedOccurrences() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/explicateTypeArguments/UnmatchedOccurrences.kt");
                doIntroduceVariableTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceVariable/extractToScope")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtractToScope extends AbstractExtractionTest {
            public void testAllFilesPresentInExtractToScope() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceVariable/extractToScope"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("implicitOuterThisInsideNestedLamba.kt")
            public void testImplicitOuterThisInsideNestedLamba() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/implicitOuterThisInsideNestedLamba.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("implicitThisInsideNestedLamba.kt")
            public void testImplicitThisInsideNestedLamba() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/implicitThisInsideNestedLamba.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("insideFunExpression.kt")
            public void testInsideFunExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/insideFunExpression.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("insideFunExpressionWithBlock.kt")
            public void testInsideFunExpressionWithBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/insideFunExpressionWithBlock.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("insideLamba.kt")
            public void testInsideLamba() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/insideLamba.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("insideNestedFunExpression.kt")
            public void testInsideNestedFunExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/insideNestedFunExpression.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("insideNestedFunExpressionInLambda.kt")
            public void testInsideNestedFunExpressionInLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/insideNestedFunExpressionInLambda.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("insideNestedLamba.kt")
            public void testInsideNestedLamba() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/insideNestedLamba.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("insideNestedLambdaInFunExpression.kt")
            public void testInsideNestedLambdaInFunExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/insideNestedLambdaInFunExpression.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("itInsideNestedLamba.kt")
            public void testItInsideNestedLamba() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/itInsideNestedLamba.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("outerItInsideNestedLamba.kt")
            public void testOuterItInsideNestedLamba() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/extractToScope/outerItInsideNestedLamba.kt");
                doIntroduceVariableTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MultiDeclarations extends AbstractExtractionTest {
            public void testAllFilesPresentInMultiDeclarations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceVariable/multiDeclarations"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/array.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("intArray.kt")
            public void testIntArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/intArray.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("list.kt")
            public void testList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/list.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("notOperators.kt")
            public void testNotOperators() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/notOperators.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("singleComponent.kt")
            public void testSingleComponent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/singleComponent.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("unresolvedComponent3.kt")
            public void testUnresolvedComponent3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/unresolvedComponent3.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("unusedExpr.kt")
            public void testUnusedExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/unusedExpr.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("usedExpr.kt")
            public void testUsedExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/usedExpr.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("userDataClass.kt")
            public void testUserDataClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/multiDeclarations/userDataClass.kt");
                doIntroduceVariableTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceVariable/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractExtractionTest {
            public void testAllFilesPresentInScript() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceVariable/script"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ExpressionPart.kts")
            public void testExpressionPart() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/script/ExpressionPart.kts");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("NotExpression.kts")
            public void testNotExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/script/NotExpression.kts");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("TopLevelExpression.kts")
            public void testTopLevelExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/script/TopLevelExpression.kts");
                doIntroduceVariableTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceVariable/stringTemplates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringTemplates extends AbstractExtractionTest {
            public void testAllFilesPresentInStringTemplates() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceVariable/stringTemplates"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("brokenEntryWithBlockExpr.kt")
            public void testBrokenEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/brokenEntryWithBlockExpr.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("brokenEntryWithExpr.kt")
            public void testBrokenEntryWithExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/brokenEntryWithExpr.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("brokenEscapeEntry.kt")
            public void testBrokenEscapeEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/brokenEscapeEntry.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("extractFalse.kt")
            public void testExtractFalse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/extractFalse.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("extractIntegerLiteral.kt")
            public void testExtractIntegerLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/extractIntegerLiteral.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("extractTrue.kt")
            public void testExtractTrue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/extractTrue.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("extractTrueWithSpaces.kt")
            public void testExtractTrueWithSpaces() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/extractTrueWithSpaces.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("fullContent.kt")
            public void testFullContent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/fullContent.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("fullEntryWithBlockExpr.kt")
            public void testFullEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/fullEntryWithBlockExpr.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("fullEntryWithSimpleName.kt")
            public void testFullEntryWithSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/fullEntryWithSimpleName.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("multipleEntriesWithPrefix.kt")
            public void testMultipleEntriesWithPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/multipleEntriesWithPrefix.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSubstring.kt")
            public void testMultipleEntriesWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/multipleEntriesWithSubstring.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSuffix.kt")
            public void testMultipleEntriesWithSuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/multipleEntriesWithSuffix.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("rawTemplateWithSubstring.kt")
            public void testRawTemplateWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/rawTemplateWithSubstring.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("singleEntryPrefix.kt")
            public void testSingleEntryPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/singleEntryPrefix.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("singleEntrySubstring.kt")
            public void testSingleEntrySubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/singleEntrySubstring.kt");
                doIntroduceVariableTest(fileName);
            }

            @TestMetadata("singleEntrySuffix.kt")
            public void testSingleEntrySuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceVariable/stringTemplates/singleEntrySuffix.kt");
                doIntroduceVariableTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/refactoring/extractFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtractFunction extends AbstractExtractionTest {
        public void testAllFilesPresentInExtractFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/basic")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Basic extends AbstractExtractionTest {
            public void testAllFilesPresentInBasic() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/basic"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callWithPlatformTypeReceiver.kt")
            public void testCallWithPlatformTypeReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/callWithPlatformTypeReceiver.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("callableReferenceSelector.kt")
            public void testCallableReferenceSelector() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/callableReferenceSelector.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("calleeExpression.kt")
            public void testCalleeExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/calleeExpression.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("classQualifier.kt")
            public void testClassQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/classQualifier.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("convertBinaryExpression.kt")
            public void testConvertBinaryExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/convertBinaryExpression.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("convertInfixExpression.kt")
            public void testConvertInfixExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/convertInfixExpression.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("delegatingFunction.kt")
            public void testDelegatingFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/delegatingFunction.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("enumQualifier.kt")
            public void testEnumQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/enumQualifier.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("extensionFunForArray.kt")
            public void testExtensionFunForArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/extensionFunForArray.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("extractBlockContent.kt")
            public void testExtractBlockContent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/extractBlockContent.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("extractToEnumClassBody.kt")
            public void testExtractToEnumClassBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/extractToEnumClassBody.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("fakeOverride.kt")
            public void testFakeOverride() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/fakeOverride.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("fragmentWithComment.kt")
            public void testFragmentWithComment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/fragmentWithComment.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("fragmentWithMultilineComment.kt")
            public void testFragmentWithMultilineComment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/fragmentWithMultilineComment.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("identityEquals.kt")
            public void testIdentityEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/identityEquals.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("invisibleType.kt")
            public void testInvisibleType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/invisibleType.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("lineWithSemicolon.kt")
            public void testLineWithSemicolon() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/lineWithSemicolon.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localClassExtraction.kt")
            public void testLocalClassExtraction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localClassExtraction.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localClassFunctionRef.kt")
            public void testLocalClassFunctionRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localClassFunctionRef.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localClassPropertyRef.kt")
            public void testLocalClassPropertyRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localClassPropertyRef.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localExtraction.kt")
            public void testLocalExtraction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localExtraction.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localFunExtraction.kt")
            public void testLocalFunExtraction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localFunExtraction.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localFunctionInTheMiddleSimpleControlFlow.kt")
            public void testLocalFunctionInTheMiddleSimpleControlFlow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localFunctionInTheMiddleSimpleControlFlow.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localFunctionInTheMiddleUnusedVar.kt")
            public void testLocalFunctionInTheMiddleUnusedVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localFunctionInTheMiddleUnusedVar.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localFunctionInTheMiddleUsedVar.kt")
            public void testLocalFunctionInTheMiddleUsedVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localFunctionInTheMiddleUsedVar.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localFunctionRef.kt")
            public void testLocalFunctionRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localFunctionRef.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localObjectRef.kt")
            public void testLocalObjectRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/localObjectRef.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("malformedExpression.kt")
            public void testMalformedExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/malformedExpression.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("malformedStatements.kt")
            public void testMalformedStatements() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/malformedStatements.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("memberValUnderSmartCast.kt")
            public void testMemberValUnderSmartCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/memberValUnderSmartCast.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("memberValUnderSmartCastAndImplicitReceiver.kt")
            public void testMemberValUnderSmartCastAndImplicitReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/memberValUnderSmartCastAndImplicitReceiver.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("misdirectedRef.kt")
            public void testMisdirectedRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/misdirectedRef.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("noConflictWithInnerFunction.kt")
            public void testNoConflictWithInnerFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/noConflictWithInnerFunction.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("objectQualifier.kt")
            public void testObjectQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/objectQualifier.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("packageQualifier.kt")
            public void testPackageQualifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/packageQualifier.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("privateMemberInClassObject.kt")
            public void testPrivateMemberInClassObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/privateMemberInClassObject.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("privateMemberRef.kt")
            public void testPrivateMemberRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/privateMemberRef.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("privateNestedClass.kt")
            public void testPrivateNestedClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/privateNestedClass.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("privateSetter.kt")
            public void testPrivateSetter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/privateSetter.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("refInReturn.kt")
            public void testRefInReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/refInReturn.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("topLevelValUnderSmartCast.kt")
            public void testTopLevelValUnderSmartCast() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/topLevelValUnderSmartCast.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("traitFunction.kt")
            public void testTraitFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/traitFunction.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("unresolvedWrongReceiver.kt")
            public void testUnresolvedWrongReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/basic/unresolvedWrongReceiver.kt");
                doExtractFunctionTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlFlow extends AbstractExtractionTest {
            public void testAllFilesPresentInControlFlow() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ConditionalJumps extends AbstractExtractionTest {
                public void testAllFilesPresentInConditionalJumps() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("conditionalBreakWithIf.kt")
                public void testConditionalBreakWithIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/conditionalBreakWithIf.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("conditionalBreakWithIfAndExtraVars.kt")
                public void testConditionalBreakWithIfAndExtraVars() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/conditionalBreakWithIfAndExtraVars.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("conditionalBreakWithIfElse.kt")
                public void testConditionalBreakWithIfElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/conditionalBreakWithIfElse.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("conditionalBreakWithWhen.kt")
                public void testConditionalBreakWithWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/conditionalBreakWithWhen.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("conditionalReturnWithIf.kt")
                public void testConditionalReturnWithIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/conditionalReturnWithIf.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("conditionalReturnWithIfElse.kt")
                public void testConditionalReturnWithIfElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/conditionalReturnWithIfElse.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("conditionalReturnWithWhen.kt")
                public void testConditionalReturnWithWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/conditionalReturnWithWhen.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("unconditionalBreakWithIf.kt")
                public void testUnconditionalBreakWithIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/unconditionalBreakWithIf.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("unconditionalBreakWithIfElse.kt")
                public void testUnconditionalBreakWithIfElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/unconditionalBreakWithIfElse.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("unconditionalBreakWithWhen.kt")
                public void testUnconditionalBreakWithWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/conditionalJumps/unconditionalBreakWithWhen.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/default")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Default extends AbstractExtractionTest {
                public void testAllFilesPresentInDefault() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/default"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("defaultCF.kt")
                public void testDefaultCF() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/default/defaultCF.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("defaultCFWithExtraVars.kt")
                public void testDefaultCFWithExtraVars() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/default/defaultCFWithExtraVars.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("defaultCFWithJumps.kt")
                public void testDefaultCFWithJumps() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/default/defaultCFWithJumps.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("ignoredReturnValueWithIf.kt")
                public void testIgnoredReturnValueWithIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/default/ignoredReturnValueWithIf.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("ignoredReturnValueWithIfNoBlocks.kt")
                public void testIgnoredReturnValueWithIfNoBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/default/ignoredReturnValueWithIfNoBlocks.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("ignoredReturnValueWithWhen.kt")
                public void testIgnoredReturnValueWithWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/default/ignoredReturnValueWithWhen.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("ignoredReturnValueWithWhenNoBlocks.kt")
                public void testIgnoredReturnValueWithWhenNoBlocks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/default/ignoredReturnValueWithWhenNoBlocks.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DefiniteReturns extends AbstractExtractionTest {
                public void testAllFilesPresentInDefiniteReturns() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("definiteReturnWithIf.kt")
                public void testDefiniteReturnWithIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns/definiteReturnWithIf.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("definiteReturnWithWhen.kt")
                public void testDefiniteReturnWithWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns/definiteReturnWithWhen.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("labeledAndUnlabeledReturn1.kt")
                public void testLabeledAndUnlabeledReturn1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns/labeledAndUnlabeledReturn1.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("labeledAndUnlabeledReturn2.kt")
                public void testLabeledAndUnlabeledReturn2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns/labeledAndUnlabeledReturn2.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("nonLocalReturn.kt")
                public void testNonLocalReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns/nonLocalReturn.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("nonLocalReturnWithLabel.kt")
                public void testNonLocalReturnWithLabel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns/nonLocalReturnWithLabel.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("returnWithLabel.kt")
                public void testReturnWithLabel() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns/returnWithLabel.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("singleDefiniteReturn.kt")
                public void testSingleDefiniteReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/definiteReturns/singleDefiniteReturn.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class EvaluateExpression extends AbstractExtractionTest {
                public void testAllFilesPresentInEvaluateExpression() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("evalExprInIfCondition.kt")
                public void testEvalExprInIfCondition() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalExprInIfCondition.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalExprInIfElse.kt")
                public void testEvalExprInIfElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalExprInIfElse.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalExprInIfThen.kt")
                public void testEvalExprInIfThen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalExprInIfThen.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalExprInWhenBranch.kt")
                public void testEvalExprInWhenBranch() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalExprInWhenBranch.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalExprInWhenCondition.kt")
                public void testEvalExprInWhenCondition() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalExprInWhenCondition.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalExprInWhenSubject.kt")
                public void testEvalExprInWhenSubject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalExprInWhenSubject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalExpressionBodyFunction.kt")
                public void testEvalExpressionBodyFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalExpressionBodyFunction.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalIfExpr.kt")
                public void testEvalIfExpr() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalIfExpr.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalWhenExpr.kt")
                public void testEvalWhenExpr() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/evalWhenExpr.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("simpleEvalExpr.kt")
                public void testSimpleEvalExpr() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/simpleEvalExpr.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("trailingLambdaEmptyArgList.kt")
                public void testTrailingLambdaEmptyArgList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/trailingLambdaEmptyArgList.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("trailingLambdaNoArgList.kt")
                public void testTrailingLambdaNoArgList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/trailingLambdaNoArgList.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("trailingLambdaNonEmptyArgList.kt")
                public void testTrailingLambdaNonEmptyArgList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/trailingLambdaNonEmptyArgList.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("trailingLambdaNonEmptyArgListWithNamedArgs.kt")
                public void testTrailingLambdaNonEmptyArgListWithNamedArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/evaluateExpression/trailingLambdaNonEmptyArgListWithNamedArgs.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExitPointEquivalence extends AbstractExtractionTest {
                public void testAllFilesPresentInExitPointEquivalence() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("breakAndReturn.kt")
                public void testBreakAndReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence/breakAndReturn.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("breakContinueAndDefault.kt")
                public void testBreakContinueAndDefault() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence/breakContinueAndDefault.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("continueAndReturn.kt")
                public void testContinueAndReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence/continueAndReturn.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("defaultAndBreak.kt")
                public void testDefaultAndBreak() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence/defaultAndBreak.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("defaultAndContinue.kt")
                public void testDefaultAndContinue() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence/defaultAndContinue.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("defaultAndReturn.kt")
                public void testDefaultAndReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence/defaultAndReturn.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("defaultAndReturnInWhen.kt")
                public void testDefaultAndReturnInWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence/defaultAndReturnInWhen.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multipleBreaks.kt")
                public void testMultipleBreaks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/exitPointEquivalence/multipleBreaks.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/initializer")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Initializer extends AbstractExtractionTest {
                public void testAllFilesPresentInInitializer() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/initializer"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("propertyWithInitializer.kt")
                public void testPropertyWithInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/initializer/propertyWithInitializer.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("propertyWithInitializerAndExtraVars.kt")
                public void testPropertyWithInitializerAndExtraVars() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/initializer/propertyWithInitializerAndExtraVars.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("propertyWithInitializerAndUnusedVars.kt")
                public void testPropertyWithInitializerAndUnusedVars() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/initializer/propertyWithInitializerAndUnusedVars.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("propertyWithSeparateInitializer.kt")
                public void testPropertyWithSeparateInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/initializer/propertyWithSeparateInitializer.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("valueUsedInAnonymousObject.kt")
                public void testValueUsedInAnonymousObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/initializer/valueUsedInAnonymousObject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("valueUsedInLambda.kt")
                public void testValueUsedInLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/initializer/valueUsedInLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("valueUsedInLocalFunction.kt")
                public void testValueUsedInLocalFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/initializer/valueUsedInLocalFunction.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class OutputValues extends AbstractExtractionTest {
                public void testAllFilesPresentInOutputValues() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/outputValues"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("genericPair.kt")
                public void testGenericPair() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/genericPair.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("initializersAndUpdate.kt")
                public void testInitializersAndUpdate() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/initializersAndUpdate.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("nestedNonInlinableCall.kt")
                public void testNestedNonInlinableCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/nestedNonInlinableCall.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("outputValueWithExpression.kt")
                public void testOutputValueWithExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/outputValueWithExpression.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("outputValueWithReturn.kt")
                public void testOutputValueWithReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/outputValueWithReturn.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("outputValueWithSingleLineExpression.kt")
                public void testOutputValueWithSingleLineExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/outputValueWithSingleLineExpression.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("outputValuesWithExpression.kt")
                public void testOutputValuesWithExpression() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/outputValuesWithExpression.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("pair.kt")
                public void testPair() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/pair.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("pairOfInitalizersWithNonLocalUsages.kt")
                public void testPairOfInitalizersWithNonLocalUsages() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/pairOfInitalizersWithNonLocalUsages.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("pairOfVarInitalizersWithNonLocalUsages.kt")
                public void testPairOfVarInitalizersWithNonLocalUsages() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/pairOfVarInitalizersWithNonLocalUsages.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("pairWithIf.kt")
                public void testPairWithIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/pairWithIf.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("pairWithNameClash.kt")
                public void testPairWithNameClash() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/pairWithNameClash.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("pairWithWhen.kt")
                public void testPairWithWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/pairWithWhen.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("singleOutputValue.kt")
                public void testSingleOutputValue() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/singleOutputValue.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("singleOutputValueWithIf.kt")
                public void testSingleOutputValueWithIf() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/singleOutputValueWithIf.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("singleOutputValueWithIfElse.kt")
                public void testSingleOutputValueWithIfElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/singleOutputValueWithIfElse.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("singleOutputValueWithWhen.kt")
                public void testSingleOutputValueWithWhen() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/singleOutputValueWithWhen.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("singleOutputValueWithWhenElse.kt")
                public void testSingleOutputValueWithWhenElse() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/singleOutputValueWithWhenElse.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("tooManyOutputValues.kt")
                public void testTooManyOutputValues() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/tooManyOutputValues.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("tooManyOutputValuesAsList.kt")
                public void testTooManyOutputValuesAsList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/tooManyOutputValuesAsList.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("triple.kt")
                public void testTriple() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/triple.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("usedAndUnusedOutputValues.kt")
                public void testUsedAndUnusedOutputValues() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/usedAndUnusedOutputValues.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("valAndVarInitalizersWithNonLocalUsages.kt")
                public void testValAndVarInitalizersWithNonLocalUsages() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/valAndVarInitalizersWithNonLocalUsages.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("valuesUsedInLambdaOnly.kt")
                public void testValuesUsedInLambdaOnly() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/valuesUsedInLambdaOnly.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("valuesUsedInNestedBlock.kt")
                public void testValuesUsedInNestedBlock() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/outputValues/valuesUsedInNestedBlock.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/returnTypeCandidates")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReturnTypeCandidates extends AbstractExtractionTest {
                public void testAllFilesPresentInReturnTypeCandidates() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/returnTypeCandidates"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("javaAnnotatedNotNull.kt")
                public void testJavaAnnotatedNotNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/returnTypeCandidates/javaAnnotatedNotNull.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("javaAnnotatedNullable.kt")
                public void testJavaAnnotatedNullable() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/returnTypeCandidates/javaAnnotatedNullable.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("javaNoNullabilityAnnotation.kt")
                public void testJavaNoNullabilityAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/returnTypeCandidates/javaNoNullabilityAnnotation.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/throws")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Throws extends AbstractExtractionTest {
                public void testAllFilesPresentInThrows() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/throws"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("breakWithThrow.kt")
                public void testBreakWithThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/throws/breakWithThrow.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("continueWithThrow.kt")
                public void testContinueWithThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/throws/continueWithThrow.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalExpressionWithThrow.kt")
                public void testEvalExpressionWithThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/throws/evalExpressionWithThrow.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("implicitThrow.kt")
                public void testImplicitThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/throws/implicitThrow.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("nonValuedReturnWithThrow.kt")
                public void testNonValuedReturnWithThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/throws/nonValuedReturnWithThrow.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("outputValueWithThrow.kt")
                public void testOutputValueWithThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/throws/outputValueWithThrow.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("returnWithThrow.kt")
                public void testReturnWithThrow() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/throws/returnWithThrow.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/controlFlow/unextractable")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Unextractable extends AbstractExtractionTest {
                public void testAllFilesPresentInUnextractable() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/controlFlow/unextractable"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("anonymousObject.kt")
                public void testAnonymousObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/unextractable/anonymousObject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("evalExpressionWithReturn.kt")
                public void testEvalExpressionWithReturn() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/unextractable/evalExpressionWithReturn.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("jumpsAndReturns.kt")
                public void testJumpsAndReturns() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/unextractable/jumpsAndReturns.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multipleJumps.kt")
                public void testMultipleJumps() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/unextractable/multipleJumps.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multipleReturnsWithDefault.kt")
                public void testMultipleReturnsWithDefault() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/unextractable/multipleReturnsWithDefault.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("unmatchedReturnTargets.kt")
                public void testUnmatchedReturnTargets() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/unextractable/unmatchedReturnTargets.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("variablesOutOfScope.kt")
                public void testVariablesOutOfScope() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/controlFlow/unextractable/variablesOutOfScope.kt");
                    doExtractFunctionTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/defaultContainer")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DefaultContainer extends AbstractExtractionTest {
            public void testAllFilesPresentInDefaultContainer() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/defaultContainer"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anonymousObject.kt")
            public void testAnonymousObject() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/defaultContainer/anonymousObject.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("classFunction.kt")
            public void testClassFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/defaultContainer/classFunction.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/defaultContainer/lambda.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localClass.kt")
            public void testLocalClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/defaultContainer/localClass.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localFunction.kt")
            public void testLocalFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/defaultContainer/localFunction.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("nestedLambda.kt")
            public void testNestedLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/defaultContainer/nestedLambda.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("topLevelFunction.kt")
            public void testTopLevelFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/defaultContainer/topLevelFunction.kt");
                doExtractFunctionTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/delegation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Delegation extends AbstractExtractionTest {
            public void testAllFilesPresentInDelegation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/delegation"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegationByExpression.kt")
            public void testDelegationByExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/delegation/delegationByExpression.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("delegationByExpressionFull.kt")
            public void testDelegationByExpressionFull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/delegation/delegationByExpressionFull.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("delegationBySuperCall.kt")
            public void testDelegationBySuperCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/delegation/delegationBySuperCall.kt");
                doExtractFunctionTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/duplicates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Duplicates extends AbstractExtractionTest {
            public void testAllFilesPresentInDuplicates() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/duplicates"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("branchingMatch1.kt")
            public void testBranchingMatch1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/branchingMatch1.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("branchingMatch2.kt")
            public void testBranchingMatch2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/branchingMatch2.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("defaultCF.kt")
            public void testDefaultCF() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/defaultCF.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("insertAfterDuplicates.kt")
            public void testInsertAfterDuplicates() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/insertAfterDuplicates.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("insertBeforeDuplicates.kt")
            public void testInsertBeforeDuplicates() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/insertBeforeDuplicates.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("multipleOutputValuesMatching.kt")
            public void testMultipleOutputValuesMatching() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/multipleOutputValuesMatching.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("nestedStrongMatch.kt")
            public void testNestedStrongMatch() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/nestedStrongMatch.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("notNullAssertion.kt")
            public void testNotNullAssertion() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/notNullAssertion.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("outputValueAndUnitMatching.kt")
            public void testOutputValueAndUnitMatching() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/outputValueAndUnitMatching.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("outputValueMatching.kt")
            public void testOutputValueMatching() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/outputValueMatching.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("singleExpression.kt")
            public void testSingleExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/duplicates/singleExpression.kt");
                doExtractFunctionTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/initializers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Initializers extends AbstractExtractionTest {
            public void testAllFilesPresentInInitializers() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/initializers"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/initializers/accessors")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Accessors extends AbstractExtractionTest {
                public void testAllFilesPresentInAccessors() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/initializers/accessors"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("memberProperty.kt")
                public void testMemberProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/accessors/memberProperty.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("memberPropertyWithLambda.kt")
                public void testMemberPropertyWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/accessors/memberPropertyWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("topLevelProperty.kt")
                public void testTopLevelProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/accessors/topLevelProperty.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("topLevelPropertyWithLambda.kt")
                public void testTopLevelPropertyWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/accessors/topLevelPropertyWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/initializers/classes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Classes extends AbstractExtractionTest {
                public void testAllFilesPresentInClasses() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/initializers/classes"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classInitializer.kt")
                public void testClassInitializer() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/classes/classInitializer.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("classInitializerWithLambda.kt")
                public void testClassInitializerWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/classes/classInitializerWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("classParameters.kt")
                public void testClassParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/classes/classParameters.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("classParametersWithLambda.kt")
                public void testClassParametersWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/classes/classParametersWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/initializers/functions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Functions extends AbstractExtractionTest {
                public void testAllFilesPresentInFunctions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/initializers/functions"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("localFunction.kt")
                public void testLocalFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/localFunction.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localFunctionParameters.kt")
                public void testLocalFunctionParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/localFunctionParameters.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localFunctionParametersWithLambda.kt")
                public void testLocalFunctionParametersWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/localFunctionParametersWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localFunctionWithLambda.kt")
                public void testLocalFunctionWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/localFunctionWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("memberFunction.kt")
                public void testMemberFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/memberFunction.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("memberFunctionParameters.kt")
                public void testMemberFunctionParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/memberFunctionParameters.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("memberFunctionParametersWithLambda.kt")
                public void testMemberFunctionParametersWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/memberFunctionParametersWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("memberFunctionWithLambda.kt")
                public void testMemberFunctionWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/memberFunctionWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("topLevelFunction.kt")
                public void testTopLevelFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/topLevelFunction.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("topLevelFunctionParameters.kt")
                public void testTopLevelFunctionParameters() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/topLevelFunctionParameters.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("topLevelFunctionParametersWithLambda.kt")
                public void testTopLevelFunctionParametersWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/topLevelFunctionParametersWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("topLevelFunctionWithLambda.kt")
                public void testTopLevelFunctionWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/functions/topLevelFunctionWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/initializers/properties")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Properties extends AbstractExtractionTest {
                public void testAllFilesPresentInProperties() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/initializers/properties"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("localProperty.kt")
                public void testLocalProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/properties/localProperty.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localPropertyWithLambda.kt")
                public void testLocalPropertyWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/properties/localPropertyWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("memberProperty.kt")
                public void testMemberProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/properties/memberProperty.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("memberPropertyWithLambda.kt")
                public void testMemberPropertyWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/properties/memberPropertyWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multiDeclaration.kt")
                public void testMultiDeclaration() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/properties/multiDeclaration.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("nestedInMultiDeclaration.kt")
                public void testNestedInMultiDeclaration() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/properties/nestedInMultiDeclaration.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("topLevelProperty.kt")
                public void testTopLevelProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/properties/topLevelProperty.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("topLevelPropertyWithLambda.kt")
                public void testTopLevelPropertyWithLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/initializers/properties/topLevelPropertyWithLambda.kt");
                    doExtractFunctionTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/multiline")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Multiline extends AbstractExtractionTest {
            public void testAllFilesPresentInMultiline() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/multiline"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("multilineBinaryExpression.kt")
            public void testMultilineBinaryExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/multiline/multilineBinaryExpression.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("multilineBinaryExpressionWithComments.kt")
            public void testMultilineBinaryExpressionWithComments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/multiline/multilineBinaryExpressionWithComments.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("multilineNestedBinaryExpression1.kt")
            public void testMultilineNestedBinaryExpression1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/multiline/multilineNestedBinaryExpression1.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("multilineNestedBinaryExpression2.kt")
            public void testMultilineNestedBinaryExpression2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/multiline/multilineNestedBinaryExpression2.kt");
                doExtractFunctionTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/parameters")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Parameters extends AbstractExtractionTest {
            public void testAllFilesPresentInParameters() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/parameters"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CandidateTypes extends AbstractExtractionTest {
                public void testAllFilesPresentInCandidateTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/parameters/candidateTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("cantLiftAnonymousToSupertype.kt")
                public void testCantLiftAnonymousToSupertype() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/cantLiftAnonymousToSupertype.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("flexibleTypesWithNull.kt")
                public void testFlexibleTypesWithNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/flexibleTypesWithNull.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("flexibleTypesWithoutNull.kt")
                public void testFlexibleTypesWithoutNull() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/flexibleTypesWithoutNull.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("liftAnonymousToSupertype1.kt")
                public void testLiftAnonymousToSupertype1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/liftAnonymousToSupertype1.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("liftAnonymousToSupertype2.kt")
                public void testLiftAnonymousToSupertype2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/liftAnonymousToSupertype2.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multipleTypes.kt")
                public void testMultipleTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/multipleTypes.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multipleTypes2.kt")
                public void testMultipleTypes2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/multipleTypes2.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multipleTypes3.kt")
                public void testMultipleTypes3() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/multipleTypes3.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multipleTypes4.kt")
                public void testMultipleTypes4() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/multipleTypes4.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("mutablyFlexibleType.kt")
                public void testMutablyFlexibleType() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/mutablyFlexibleType.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("nonNullableTypes.kt")
                public void testNonNullableTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/nonNullableTypes.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("nullableTypes.kt")
                public void testNullableTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/nullableTypes.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("receiverCandidateTypes.kt")
                public void testReceiverCandidateTypes() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/receiverCandidateTypes.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("typeHierarchy1.kt")
                public void testTypeHierarchy1() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/typeHierarchy1.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("typeHierarchy2.kt")
                public void testTypeHierarchy2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/typeHierarchy2.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("typeHierarchy3.kt")
                public void testTypeHierarchy3() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/typeHierarchy3.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("typeHierarchy4.kt")
                public void testTypeHierarchy4() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/candidateTypes/typeHierarchy4.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/parameters/capturedFunctions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CapturedFunctions extends AbstractExtractionTest {
                public void testAllFilesPresentInCapturedFunctions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/parameters/capturedFunctions"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("deeplyLocalFun.kt")
                public void testDeeplyLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/capturedFunctions/deeplyLocalFun.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localExtensionFun.kt")
                public void testLocalExtensionFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/capturedFunctions/localExtensionFun.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localExtensionFunChainedCalls.kt")
                public void testLocalExtensionFunChainedCalls() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/capturedFunctions/localExtensionFunChainedCalls.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localExtensionFunInfixCall.kt")
                public void testLocalExtensionFunInfixCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/capturedFunctions/localExtensionFunInfixCall.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localFun.kt")
                public void testLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/capturedFunctions/localFun.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/parameters/extractSuper")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExtractSuper extends AbstractExtractionTest {
                public void testAllFilesPresentInExtractSuper() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/parameters/extractSuper"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("labeledSuperPropertyCall.kt")
                public void testLabeledSuperPropertyCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractSuper/labeledSuperPropertyCall.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("superFunctionCall.kt")
                public void testSuperFunctionCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractSuper/superFunctionCall.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("superLabeledFunctionCall.kt")
                public void testSuperLabeledFunctionCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractSuper/superLabeledFunctionCall.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("superPropertyCall.kt")
                public void testSuperPropertyCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractSuper/superPropertyCall.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ExtractThis extends AbstractExtractionTest {
                public void testAllFilesPresentInExtractThis() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/parameters/extractThis"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("explicitLabeledThisInMember.kt")
                public void testExplicitLabeledThisInMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/explicitLabeledThisInMember.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("explicitThisInExtension.kt")
                public void testExplicitThisInExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/explicitThisInExtension.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("explicitThisInMember.kt")
                public void testExplicitThisInMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/explicitThisInMember.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("explicitThisWithSmartCast.kt")
                public void testExplicitThisWithSmartCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/explicitThisWithSmartCast.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("implicitAndExplicitLabeledThisInMember.kt")
                public void testImplicitAndExplicitLabeledThisInMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/implicitAndExplicitLabeledThisInMember.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("implicitAndExplicitThisInExtension.kt")
                public void testImplicitAndExplicitThisInExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/implicitAndExplicitThisInExtension.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("implicitThisInExtension.kt")
                public void testImplicitThisInExtension() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/implicitThisInExtension.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("implicitThisInMember.kt")
                public void testImplicitThisInMember() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/implicitThisInMember.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("implicitThisWithSmartCast.kt")
                public void testImplicitThisWithSmartCast() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/implicitThisWithSmartCast.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("javaSyntheticProperty.kt")
                public void testJavaSyntheticProperty() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/javaSyntheticProperty.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("javaSyntheticPropertyWithDelegation.kt")
                public void testJavaSyntheticPropertyWithDelegation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/javaSyntheticPropertyWithDelegation.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("javaSyntheticPropertyWithOverride.kt")
                public void testJavaSyntheticPropertyWithOverride() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/javaSyntheticPropertyWithOverride.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("missingReceiver.kt")
                public void testMissingReceiver() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/missingReceiver.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("paramAsExplicitInvoke.kt")
                public void testParamAsExplicitInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/paramAsExplicitInvoke.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("paramWithExtensionInvoke.kt")
                public void testParamWithExtensionInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/paramWithExtensionInvoke.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("propertyWithExplicitInvoke.kt")
                public void testPropertyWithExplicitInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/propertyWithExplicitInvoke.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("propertyWithImplicitInvoke.kt")
                public void testPropertyWithImplicitInvoke() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/propertyWithImplicitInvoke.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedThis.kt")
                public void testQualifiedThis() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/qualifiedThis.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedThisAsArgument.kt")
                public void testQualifiedThisAsArgument() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/extractThis/qualifiedThisAsArgument.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/parameters/it")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class It extends AbstractExtractionTest {
                public void testAllFilesPresentInIt() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/parameters/it"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerIt.kt")
                public void testInnerIt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/it/innerIt.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("lambdaWithIt.kt")
                public void testLambdaWithIt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/it/lambdaWithIt.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("outerIt.kt")
                public void testOuterIt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/it/outerIt.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("simpleIt.kt")
                public void testSimpleIt() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/it/simpleIt.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/parameters/misc")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Misc extends AbstractExtractionTest {
                @TestMetadata("addPrefixToBackticks.kt")
                public void testAddPrefixToBackticks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/addPrefixToBackticks.kt");
                    doExtractFunctionTest(fileName);
                }

                public void testAllFilesPresentInMisc() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/parameters/misc"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classObject.kt")
                public void testClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/classObject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("extensionLambda.kt")
                public void testExtensionLambda() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/extensionLambda.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("extensionLambdaAsParameter.kt")
                public void testExtensionLambdaAsParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/extensionLambdaAsParameter.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("idWithBackticks.kt")
                public void testIdWithBackticks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/idWithBackticks.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("idWithRequiredBackticks.kt")
                public void testIdWithRequiredBackticks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/idWithRequiredBackticks.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("innerClassObject.kt")
                public void testInnerClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/innerClassObject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("kt5001.kt")
                public void testKt5001() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/kt5001.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multiDeclaration.kt")
                public void testMultiDeclaration() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/multiDeclaration.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("multipleOccurrences.kt")
                public void testMultipleOccurrences() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/multipleOccurrences.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("namedArguments.kt")
                public void testNamedArguments() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/namedArguments.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedAnnotation.kt")
                public void testQualifiedAnnotation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/qualifiedAnnotation.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedClassObject.kt")
                public void testQualifiedClassObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/qualifiedClassObject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedEnum.kt")
                public void testQualifiedEnum() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/qualifiedEnum.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedObject.kt")
                public void testQualifiedObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/qualifiedObject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedPackage.kt")
                public void testQualifiedPackage() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/qualifiedPackage.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedTypeArg.kt")
                public void testQualifiedTypeArg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/qualifiedTypeArg.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedTypeInValueArg.kt")
                public void testQualifiedTypeInValueArg() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/qualifiedTypeInValueArg.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("qualifiedTypeRef.kt")
                public void testQualifiedTypeRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/qualifiedTypeRef.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("reducedParameterList.kt")
                public void testReducedParameterList() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/reducedParameterList.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("replaceWithBackticks.kt")
                public void testReplaceWithBackticks() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/replaceWithBackticks.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("replaceWithBackticks2.kt")
                public void testReplaceWithBackticks2() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/replaceWithBackticks2.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("thisInObject.kt")
                public void testThisInObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/thisInObject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("typeRef.kt")
                public void testTypeRef() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/typeRef.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("usagesInCallArgs.kt")
                public void testUsagesInCallArgs() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/usagesInCallArgs.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("variableAsFunction.kt")
                public void testVariableAsFunction() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/misc/variableAsFunction.kt");
                    doExtractFunctionTest(fileName);
                }
            }

            @TestMetadata("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class NonDenotableTypes extends AbstractExtractionTest {
                public void testAllFilesPresentInNonDenotableTypes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("anonymousObject.kt")
                public void testAnonymousObject() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes/anonymousObject.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("anonymousObjectWithCall.kt")
                public void testAnonymousObjectWithCall() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes/anonymousObjectWithCall.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes/localClass.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localClassWithSuperclass.kt")
                public void testLocalClassWithSuperclass() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes/localClassWithSuperclass.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localClassWithSuperclassParameter.kt")
                public void testLocalClassWithSuperclassParameter() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes/localClassWithSuperclassParameter.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localClassWithSuperclassParameterInLocalFun.kt")
                public void testLocalClassWithSuperclassParameterInLocalFun() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes/localClassWithSuperclassParameterInLocalFun.kt");
                    doExtractFunctionTest(fileName);
                }

                @TestMetadata("localClassWithSuperclassParameterNoApproximation.kt")
                public void testLocalClassWithSuperclassParameterNoApproximation() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/parameters/nonDenotableTypes/localClassWithSuperclassParameterNoApproximation.kt");
                    doExtractFunctionTest(fileName);
                }
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractExtractionTest {
            public void testAllFilesPresentInScript() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/script"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("NotExpression.kts")
            public void testNotExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/script/NotExpression.kts");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("TopLevelExpression.kts")
            public void testTopLevelExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/script/TopLevelExpression.kts");
                doExtractFunctionTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/stringTemplates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringTemplates extends AbstractExtractionTest {
            public void testAllFilesPresentInStringTemplates() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/stringTemplates"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("brokenEntryWithBlockExpr.kt")
            public void testBrokenEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/brokenEntryWithBlockExpr.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("brokenEntryWithExpr.kt")
            public void testBrokenEntryWithExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/brokenEntryWithExpr.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("brokenEscapeEntry.kt")
            public void testBrokenEscapeEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/brokenEscapeEntry.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("extractFalse.kt")
            public void testExtractFalse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/extractFalse.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("extractIntegerLiteral.kt")
            public void testExtractIntegerLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/extractIntegerLiteral.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("extractTrue.kt")
            public void testExtractTrue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/extractTrue.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("fullContent.kt")
            public void testFullContent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/fullContent.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("fullEntryWithBlockExpr.kt")
            public void testFullEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/fullEntryWithBlockExpr.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("fullEntryWithSimpleName.kt")
            public void testFullEntryWithSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/fullEntryWithSimpleName.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("multipleEntriesWithPrefix.kt")
            public void testMultipleEntriesWithPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/multipleEntriesWithPrefix.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSubstring.kt")
            public void testMultipleEntriesWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/multipleEntriesWithSubstring.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSuffix.kt")
            public void testMultipleEntriesWithSuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/multipleEntriesWithSuffix.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("rawTemplateWithSubstring.kt")
            public void testRawTemplateWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/rawTemplateWithSubstring.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("singleEntryPrefix.kt")
            public void testSingleEntryPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/singleEntryPrefix.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("singleEntrySubstring.kt")
            public void testSingleEntrySubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/singleEntrySubstring.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("singleEntrySuffix.kt")
            public void testSingleEntrySuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/stringTemplates/singleEntrySuffix.kt");
                doExtractFunctionTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/extractFunction/typeParameters")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeParameters extends AbstractExtractionTest {
            public void testAllFilesPresentInTypeParameters() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractFunction/typeParameters"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("localClassInBound.kt")
            public void testLocalClassInBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/localClassInBound.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("localClassInTypeConstraint.kt")
            public void testLocalClassInTypeConstraint() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/localClassInTypeConstraint.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("noVarianceInFun.kt")
            public void testNoVarianceInFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/noVarianceInFun.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("simpleTypeParameter.kt")
            public void testSimpleTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/simpleTypeParameter.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("simpleTypeParameterWithConstraint.kt")
            public void testSimpleTypeParameterWithConstraint() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/simpleTypeParameterWithConstraint.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParamInArgument.kt")
            public void testTypeParamInArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParamInArgument.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParameterNotResolvableInTargetScope.kt")
            public void testTypeParameterNotResolvableInTargetScope() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParameterNotResolvableInTargetScope.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParameterRef.kt")
            public void testTypeParameterRef() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParameterRef.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParameterRefCanOmit.kt")
            public void testTypeParameterRefCanOmit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParameterRefCanOmit.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParameterResolvableInTargetScope.kt")
            public void testTypeParameterResolvableInTargetScope() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParameterResolvableInTargetScope.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParametersAndConstraintsCombined1.kt")
            public void testTypeParametersAndConstraintsCombined1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParametersAndConstraintsCombined1.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParametersAndConstraintsCombined2.kt")
            public void testTypeParametersAndConstraintsCombined2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParametersAndConstraintsCombined2.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParametersAndConstraintsCombined3.kt")
            public void testTypeParametersAndConstraintsCombined3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParametersAndConstraintsCombined3.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParametersCombined1.kt")
            public void testTypeParametersCombined1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParametersCombined1.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParametersCombined2.kt")
            public void testTypeParametersCombined2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParametersCombined2.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParametersCombined3.kt")
            public void testTypeParametersCombined3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParametersCombined3.kt");
                doExtractFunctionTest(fileName);
            }

            @TestMetadata("typeParametersCombinedAndThis.kt")
            public void testTypeParametersCombinedAndThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractFunction/typeParameters/typeParametersCombinedAndThis.kt");
                doExtractFunctionTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/refactoring/introduceProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceProperty extends AbstractExtractionTest {
        public void testAllFilesPresentInIntroduceProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceProperty"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("extractExtensionWithInitializer.kt")
        public void testExtractExtensionWithInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractExtensionWithInitializer.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractFromDefaultValueInConstructor.kt")
        public void testExtractFromDefaultValueInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractFromDefaultValueInConstructor.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractFromDefaultValueInFun.kt")
        public void testExtractFromDefaultValueInFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractFromDefaultValueInFun.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractLazyExtension.kt")
        public void testExtractLazyExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractLazyExtension.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractLazyMultipleExpressions.kt")
        public void testExtractLazyMultipleExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractLazyMultipleExpressions.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractLazyToClass.kt")
        public void testExtractLazyToClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractLazyToClass.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractLazyToFile.kt")
        public void testExtractLazyToFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractLazyToFile.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractLazyToTrait.kt")
        public void testExtractLazyToTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractLazyToTrait.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractLazyWithBlock.kt")
        public void testExtractLazyWithBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractLazyWithBlock.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractLazyWithCallSiteReturn.kt")
        public void testExtractLazyWithCallSiteReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractLazyWithCallSiteReturn.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractToClassWithNameClash.kt")
        public void testExtractToClassWithNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractToClassWithNameClash.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractToClassWithNameClashAndAnonymousInitializer.kt")
        public void testExtractToClassWithNameClashAndAnonymousInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractToClassWithNameClashAndAnonymousInitializer.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractToFileWithNameClash.kt")
        public void testExtractToFileWithNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractToFileWithNameClash.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractToFunction.kt")
        public void testExtractToFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractToFunction.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractUnit.kt")
        public void testExtractUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractUnit.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithGetterMultipleExpressions.kt")
        public void testExtractWithGetterMultipleExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithGetterMultipleExpressions.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithGetterToClass.kt")
        public void testExtractWithGetterToClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithGetterToClass.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithGetterToFile.kt")
        public void testExtractWithGetterToFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithGetterToFile.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithGetterToTrait.kt")
        public void testExtractWithGetterToTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithGetterToTrait.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithInitializerAndBlock.kt")
        public void testExtractWithInitializerAndBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithInitializerAndBlock.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithInitializerAndCallSiteReturn.kt")
        public void testExtractWithInitializerAndCallSiteReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithInitializerAndCallSiteReturn.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithInitializerAndSingleElementBlock.kt")
        public void testExtractWithInitializerAndSingleElementBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithInitializerAndSingleElementBlock.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithInitializerMultipleExpressions.kt")
        public void testExtractWithInitializerMultipleExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithInitializerMultipleExpressions.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithInitializerToClass.kt")
        public void testExtractWithInitializerToClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithInitializerToClass.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithInitializerToFile.kt")
        public void testExtractWithInitializerToFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithInitializerToFile.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithInitializerToTrait.kt")
        public void testExtractWithInitializerToTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithInitializerToTrait.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("extractWithParams.kt")
        public void testExtractWithParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/extractWithParams.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("primaryConstructorParameterReference.kt")
        public void testPrimaryConstructorParameterReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/primaryConstructorParameterReference.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("replaceDuplicates.kt")
        public void testReplaceDuplicates() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/replaceDuplicates.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("syntaxErrors.kt")
        public void testSyntaxErrors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/syntaxErrors.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("typeParameterNotResolvableInTargetScope.kt")
        public void testTypeParameterNotResolvableInTargetScope() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/typeParameterNotResolvableInTargetScope.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("typeParameterResolvableInTargetScope.kt")
        public void testTypeParameterResolvableInTargetScope() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/typeParameterResolvableInTargetScope.kt");
            doIntroducePropertyTest(fileName);
        }

        @TestMetadata("idea/testData/refactoring/introduceProperty/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractExtractionTest {
            public void testAllFilesPresentInScript() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceProperty/script"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ClassInScript.kts")
            public void testClassInScript() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/script/ClassInScript.kts");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("ExpressionPart.kts")
            public void testExpressionPart() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/script/ExpressionPart.kts");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("TopLevelExpression.kts")
            public void testTopLevelExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/script/TopLevelExpression.kts");
                doIntroducePropertyTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceProperty/stringTemplates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringTemplates extends AbstractExtractionTest {
            public void testAllFilesPresentInStringTemplates() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceProperty/stringTemplates"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("brokenEntryWithBlockExpr.kt")
            public void testBrokenEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/brokenEntryWithBlockExpr.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("brokenEntryWithExpr.kt")
            public void testBrokenEntryWithExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/brokenEntryWithExpr.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("brokenEscapeEntry.kt")
            public void testBrokenEscapeEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/brokenEscapeEntry.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("extractFalse.kt")
            public void testExtractFalse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/extractFalse.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("extractIntegerLiteral.kt")
            public void testExtractIntegerLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/extractIntegerLiteral.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("extractTrue.kt")
            public void testExtractTrue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/extractTrue.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("fullContent.kt")
            public void testFullContent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/fullContent.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("fullEntryWithBlockExpr.kt")
            public void testFullEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/fullEntryWithBlockExpr.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("fullEntryWithSimpleName.kt")
            public void testFullEntryWithSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/fullEntryWithSimpleName.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("multipleEntriesWithPrefix.kt")
            public void testMultipleEntriesWithPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/multipleEntriesWithPrefix.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSubstring.kt")
            public void testMultipleEntriesWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/multipleEntriesWithSubstring.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSuffix.kt")
            public void testMultipleEntriesWithSuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/multipleEntriesWithSuffix.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("rawTemplateWithSubstring.kt")
            public void testRawTemplateWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/rawTemplateWithSubstring.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("singleEntryPrefix.kt")
            public void testSingleEntryPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/singleEntryPrefix.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("singleEntrySubstring.kt")
            public void testSingleEntrySubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/singleEntrySubstring.kt");
                doIntroducePropertyTest(fileName);
            }

            @TestMetadata("singleEntrySuffix.kt")
            public void testSingleEntrySuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceProperty/stringTemplates/singleEntrySuffix.kt");
                doIntroducePropertyTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/refactoring/introduceParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceParameter extends AbstractExtractionTest {
        public void testAllFilesPresentInIntroduceParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceParameter"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/assignment.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classInAnonymousInitializer.kt")
        public void testClassInAnonymousInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classInAnonymousInitializer.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classInPropertyInitializer.kt")
        public void testClassInPropertyInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classInPropertyInitializer.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classMultipleUsages1.kt")
        public void testClassMultipleUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classMultipleUsages1.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classMultipleUsages2.kt")
        public void testClassMultipleUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classMultipleUsages2.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classMultipleUsagesOutsideScope.kt")
        public void testClassMultipleUsagesOutsideScope() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classMultipleUsagesOutsideScope.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classMultipleUsagesSingleReplace1.kt")
        public void testClassMultipleUsagesSingleReplace1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classMultipleUsagesSingleReplace1.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classMultipleUsagesSingleReplace2.kt")
        public void testClassMultipleUsagesSingleReplace2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classMultipleUsagesSingleReplace2.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classNoParams.kt")
        public void testClassNoParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classNoParams.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classParameterInFunctionBody.kt")
        public void testClassParameterInFunctionBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classParameterInFunctionBody.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classParameterUsedOutside.kt")
        public void testClassParameterUsedOutside() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classParameterUsedOutside.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classUnusedParameter.kt")
        public void testClassUnusedParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classUnusedParameter.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("classUsedParameter.kt")
        public void testClassUsedParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/classUsedParameter.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("defaultValueInParens.kt")
        public void testDefaultValueInParens() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/defaultValueInParens.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("defaultValueNoTempVar.kt")
        public void testDefaultValueNoTempVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/defaultValueNoTempVar.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("forbiddenUsages.kt")
        public void testForbiddenUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/forbiddenUsages.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("foreignParameterRef.kt")
        public void testForeignParameterRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/foreignParameterRef.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("fun.kt")
        public void testFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/fun.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("functionMultipleUnusedParameters.kt")
        public void testFunctionMultipleUnusedParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/functionMultipleUnusedParameters.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("functionMultipleUsages.kt")
        public void testFunctionMultipleUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/functionMultipleUsages.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("functionMultipleUsagesSingleReplace.kt")
        public void testFunctionMultipleUsagesSingleReplace() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/functionMultipleUsagesSingleReplace.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("functionUnusedParameter.kt")
        public void testFunctionUnusedParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/functionUnusedParameter.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("functionUsedParameter.kt")
        public void testFunctionUsedParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/functionUsedParameter.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("functionWithApproximatedType.kt")
        public void testFunctionWithApproximatedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/functionWithApproximatedType.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("functionWithDefaultValue.kt")
        public void testFunctionWithDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/functionWithDefaultValue.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("lambdaArgument.kt")
        public void testLambdaArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/lambdaArgument.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("partialSubstitution.kt")
        public void testPartialSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/partialSubstitution.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("propertyAccessor.kt")
        public void testPropertyAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/propertyAccessor.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("return.kt")
        public void testReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/return.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("secondaryConstructorWithDefaultValue.kt")
        public void testSecondaryConstructorWithDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/secondaryConstructorWithDefaultValue.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("simpleNameWithDefaultValueSubstitution.kt")
        public void testSimpleNameWithDefaultValueSubstitution() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/simpleNameWithDefaultValueSubstitution.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteBinaryExpressions.kt")
        public void testSubstituteBinaryExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteBinaryExpressions.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteCallExpressions.kt")
        public void testSubstituteCallExpressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteCallExpressions.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteDelegationCallsNoTempVar.kt")
        public void testSubstituteDelegationCallsNoTempVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteDelegationCallsNoTempVar.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteDoubleReceiver.kt")
        public void testSubstituteDoubleReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteDoubleReceiver.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteExplicitThisInMember.kt")
        public void testSubstituteExplicitThisInMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteExplicitThisInMember.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteImplicitThisInMember.kt")
        public void testSubstituteImplicitThisInMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteImplicitThisInMember.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteInPrimaryConstructorCall.kt")
        public void testSubstituteInPrimaryConstructorCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteInPrimaryConstructorCall.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteInSecondaryConstructorCall.kt")
        public void testSubstituteInSecondaryConstructorCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteInSecondaryConstructorCall.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteIncrement.kt")
        public void testSubstituteIncrement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteIncrement.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("substituteInfixCall.kt")
        public void testSubstituteInfixCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/substituteInfixCall.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("throw.kt")
        public void testThrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/throw.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("unusedDispatchReceiver.kt")
        public void testUnusedDispatchReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/unusedDispatchReceiver.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("unusedExtensionReceiver.kt")
        public void testUnusedExtensionReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/unusedExtensionReceiver.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("valueAtCallSite.kt")
        public void testValueAtCallSite() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/valueAtCallSite.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("valueAtCallSiteMultipleUsages.kt")
        public void testValueAtCallSiteMultipleUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/valueAtCallSiteMultipleUsages.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("varargs.kt")
        public void testVarargs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/varargs.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("while.kt")
        public void testWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/while.kt");
            doIntroduceSimpleParameterTest(fileName);
        }

        @TestMetadata("idea/testData/refactoring/introduceParameter/multiline")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Multiline extends AbstractExtractionTest {
            public void testAllFilesPresentInMultiline() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceParameter/multiline"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("multilineBinaryExpression.kt")
            public void testMultilineBinaryExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/multiline/multilineBinaryExpression.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("multilineBinaryExpressionWithComments.kt")
            public void testMultilineBinaryExpressionWithComments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/multiline/multilineBinaryExpressionWithComments.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("multilineNestedBinaryExpression1.kt")
            public void testMultilineNestedBinaryExpression1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/multiline/multilineNestedBinaryExpression1.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("multilineNestedBinaryExpression2.kt")
            public void testMultilineNestedBinaryExpression2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/multiline/multilineNestedBinaryExpression2.kt");
                doIntroduceSimpleParameterTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceParameter/script")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Script extends AbstractExtractionTest {
            public void testAllFilesPresentInScript() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceParameter/script"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ExpressionPart.kts")
            public void testExpressionPart() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/script/ExpressionPart.kts");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("FunInScript.kts")
            public void testFunInScript() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/script/FunInScript.kts");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("TopLevelExpression.kts")
            public void testTopLevelExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/script/TopLevelExpression.kts");
                doIntroduceSimpleParameterTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceParameter/stringTemplates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringTemplates extends AbstractExtractionTest {
            public void testAllFilesPresentInStringTemplates() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceParameter/stringTemplates"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("brokenEntryWithBlockExpr.kt")
            public void testBrokenEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/brokenEntryWithBlockExpr.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("brokenEntryWithExpr.kt")
            public void testBrokenEntryWithExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/brokenEntryWithExpr.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("brokenEscapeEntry.kt")
            public void testBrokenEscapeEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/brokenEscapeEntry.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("extractFalse.kt")
            public void testExtractFalse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/extractFalse.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("extractIntegerLiteral.kt")
            public void testExtractIntegerLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/extractIntegerLiteral.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("extractTrue.kt")
            public void testExtractTrue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/extractTrue.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("fullContent.kt")
            public void testFullContent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/fullContent.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("fullEntryWithBlockExpr.kt")
            public void testFullEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/fullEntryWithBlockExpr.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("fullEntryWithSimpleName.kt")
            public void testFullEntryWithSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/fullEntryWithSimpleName.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("multipleEntriesWithPrefix.kt")
            public void testMultipleEntriesWithPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/multipleEntriesWithPrefix.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSubstring.kt")
            public void testMultipleEntriesWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/multipleEntriesWithSubstring.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSuffix.kt")
            public void testMultipleEntriesWithSuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/multipleEntriesWithSuffix.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("rawTemplateWithSubstring.kt")
            public void testRawTemplateWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/rawTemplateWithSubstring.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("singleEntryPrefix.kt")
            public void testSingleEntryPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/singleEntryPrefix.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("singleEntrySubstring.kt")
            public void testSingleEntrySubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/singleEntrySubstring.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("singleEntrySuffix.kt")
            public void testSingleEntrySuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/stringTemplates/singleEntrySuffix.kt");
                doIntroduceSimpleParameterTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceParameter/variableConversion")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class VariableConversion extends AbstractExtractionTest {
            public void testAllFilesPresentInVariableConversion() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceParameter/variableConversion"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("caretAtIdentifier.kt")
            public void testCaretAtIdentifier() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/variableConversion/caretAtIdentifier.kt");
                doIntroduceSimpleParameterTest(fileName);
            }

            @TestMetadata("fullSelection.kt")
            public void testFullSelection() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceParameter/variableConversion/fullSelection.kt");
                doIntroduceSimpleParameterTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/refactoring/introduceLambdaParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceLambdaParameter extends AbstractExtractionTest {
        public void testAllFilesPresentInIntroduceLambdaParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceLambdaParameter"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lambdaArgument.kt")
        public void testLambdaArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaArgument.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("lambdaParamInPrimaryConstructor.kt")
        public void testLambdaParamInPrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaParamInPrimaryConstructor.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("lambdaParamMultiline.kt")
        public void testLambdaParamMultiline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaParamMultiline.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("lambdaParamNoDefaultValue.kt")
        public void testLambdaParamNoDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaParamNoDefaultValue.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("lambdaParamNoDefaultValueSecondLambda.kt")
        public void testLambdaParamNoDefaultValueSecondLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaParamNoDefaultValueSecondLambda.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("lambdaParamNoParams.kt")
        public void testLambdaParamNoParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaParamNoParams.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("lambdaParamOfNothing.kt")
        public void testLambdaParamOfNothing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaParamOfNothing.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("lambdaParamOfUnit.kt")
        public void testLambdaParamOfUnit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaParamOfUnit.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("lambdaParamWithDefaultValue.kt")
        public void testLambdaParamWithDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/lambdaParamWithDefaultValue.kt");
            doIntroduceLambdaParameterTest(fileName);
        }

        @TestMetadata("idea/testData/refactoring/introduceLambdaParameter/multiline")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Multiline extends AbstractExtractionTest {
            public void testAllFilesPresentInMultiline() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceLambdaParameter/multiline"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("multilineBinaryExpression.kt")
            public void testMultilineBinaryExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/multiline/multilineBinaryExpression.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("multilineBinaryExpressionWithComments.kt")
            public void testMultilineBinaryExpressionWithComments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/multiline/multilineBinaryExpressionWithComments.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("multilineNestedBinaryExpression1.kt")
            public void testMultilineNestedBinaryExpression1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/multiline/multilineNestedBinaryExpression1.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("multilineNestedBinaryExpression2.kt")
            public void testMultilineNestedBinaryExpression2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/multiline/multilineNestedBinaryExpression2.kt");
                doIntroduceLambdaParameterTest(fileName);
            }
        }

        @TestMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringTemplates extends AbstractExtractionTest {
            public void testAllFilesPresentInStringTemplates() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceLambdaParameter/stringTemplates"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("brokenEntryWithBlockExpr.kt")
            public void testBrokenEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/brokenEntryWithBlockExpr.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("brokenEntryWithExpr.kt")
            public void testBrokenEntryWithExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/brokenEntryWithExpr.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("brokenEscapeEntry.kt")
            public void testBrokenEscapeEntry() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/brokenEscapeEntry.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("extractFalse.kt")
            public void testExtractFalse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/extractFalse.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("extractIntegerLiteral.kt")
            public void testExtractIntegerLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/extractIntegerLiteral.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("extractTrue.kt")
            public void testExtractTrue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/extractTrue.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("fullContent.kt")
            public void testFullContent() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/fullContent.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("fullEntryWithBlockExpr.kt")
            public void testFullEntryWithBlockExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/fullEntryWithBlockExpr.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("fullEntryWithSimpleName.kt")
            public void testFullEntryWithSimpleName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/fullEntryWithSimpleName.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("multipleEntriesWithPrefix.kt")
            public void testMultipleEntriesWithPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/multipleEntriesWithPrefix.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSubstring.kt")
            public void testMultipleEntriesWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/multipleEntriesWithSubstring.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("multipleEntriesWithSuffix.kt")
            public void testMultipleEntriesWithSuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/multipleEntriesWithSuffix.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("rawTemplateWithSubstring.kt")
            public void testRawTemplateWithSubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/rawTemplateWithSubstring.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("singleEntryPrefix.kt")
            public void testSingleEntryPrefix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/singleEntryPrefix.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("singleEntrySubstring.kt")
            public void testSingleEntrySubstring() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/singleEntrySubstring.kt");
                doIntroduceLambdaParameterTest(fileName);
            }

            @TestMetadata("singleEntrySuffix.kt")
            public void testSingleEntrySuffix() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceLambdaParameter/stringTemplates/singleEntrySuffix.kt");
                doIntroduceLambdaParameterTest(fileName);
            }
        }
    }

    @TestMetadata("idea/testData/refactoring/introduceJavaParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceJavaParameter extends AbstractExtractionTest {
        public void testAllFilesPresentInIntroduceJavaParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceJavaParameter"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("javaMethod.java")
        public void testJavaMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceJavaParameter/javaMethod.java");
            doIntroduceJavaParameterTest(fileName);
        }

        @TestMetadata("javaMethodOverridingKotlinFunctionWithUsages.java")
        public void testJavaMethodOverridingKotlinFunctionWithUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceJavaParameter/javaMethodOverridingKotlinFunctionWithUsages.java");
            doIntroduceJavaParameterTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/introduceTypeParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceTypeParameter extends AbstractExtractionTest {
        public void testAllFilesPresentInIntroduceTypeParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceTypeParameter"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("duplicates.kt")
        public void testDuplicates() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeParameter/duplicates.kt");
            doIntroduceTypeParameterTest(fileName);
        }

        @TestMetadata("functionType.kt")
        public void testFunctionType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeParameter/functionType.kt");
            doIntroduceTypeParameterTest(fileName);
        }

        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeParameter/inClass.kt");
            doIntroduceTypeParameterTest(fileName);
        }

        @TestMetadata("inProperty.kt")
        public void testInProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeParameter/inProperty.kt");
            doIntroduceTypeParameterTest(fileName);
        }

        @TestMetadata("nullableType.kt")
        public void testNullableType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeParameter/nullableType.kt");
            doIntroduceTypeParameterTest(fileName);
        }

        @TestMetadata("userType.kt")
        public void testUserType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeParameter/userType.kt");
            doIntroduceTypeParameterTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/introduceTypeAlias")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceTypeAlias extends AbstractExtractionTest {
        public void testAllFilesPresentInIntroduceTypeAlias() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/introduceTypeAlias"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("emptyName.kt")
        public void testEmptyName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/emptyName.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("entireTypeExtracted.kt")
        public void testEntireTypeExtracted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/entireTypeExtracted.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("equivalentNestedTypeElements.kt")
        public void testEquivalentNestedTypeElements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/equivalentNestedTypeElements.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("existingTypeClash.kt")
        public void testExistingTypeClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/existingTypeClash.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("functionTypeDuplicatesNoTypeParameters.kt")
        public void testFunctionTypeDuplicatesNoTypeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/functionTypeDuplicatesNoTypeParameters.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("functionTypeDuplicatesWithTypeParameters.kt")
        public void testFunctionTypeDuplicatesWithTypeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/functionTypeDuplicatesWithTypeParameters.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("functionalType.kt")
        public void testFunctionalType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/functionalType.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("localTypeAlias.kt")
        public void testLocalTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/localTypeAlias.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("localTypeExtracted.kt")
        public void testLocalTypeExtracted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/localTypeExtracted.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("localWithVisibility.kt")
        public void testLocalWithVisibility() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/localWithVisibility.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("memberTypeAlias.kt")
        public void testMemberTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/memberTypeAlias.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("nestedTypesExtracted.kt")
        public void testNestedTypesExtracted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/nestedTypesExtracted.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("noTypeElement.kt")
        public void testNoTypeElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/noTypeElement.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("nonIdentifierName.kt")
        public void testNonIdentifierName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/nonIdentifierName.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("nullableType.kt")
        public void testNullableType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/nullableType.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("privateTypeAlias.kt")
        public void testPrivateTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/privateTypeAlias.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("protectedInFile.kt")
        public void testProtectedInFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/protectedInFile.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("suggestedName.kt")
        public void testSuggestedName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/suggestedName.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("topLevelTypeAlias.kt")
        public void testTopLevelTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/topLevelTypeAlias.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("typeConstructor.kt")
        public void testTypeConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/typeConstructor.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("typesExtractedWithFunctionalType.kt")
        public void testTypesExtractedWithFunctionalType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/typesExtractedWithFunctionalType.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("userTypeDuplicatesNoTypeParameters.kt")
        public void testUserTypeDuplicatesNoTypeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/userTypeDuplicatesNoTypeParameters.kt");
            doIntroduceTypeAliasTest(fileName);
        }

        @TestMetadata("userTypeDuplicatesWithTypeParameters.kt")
        public void testUserTypeDuplicatesWithTypeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/introduceTypeAlias/userTypeDuplicatesWithTypeParameters.kt");
            doIntroduceTypeAliasTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/extractSuperclass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtractSuperclass extends AbstractExtractionTest {
        @TestMetadata("addSuperclassNoSecondaryConstructors.kt")
        public void testAddSuperclassNoSecondaryConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/addSuperclassNoSecondaryConstructors.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("addSuperclassOnlySecondaryConstructors.kt")
        public void testAddSuperclassOnlySecondaryConstructors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/addSuperclassOnlySecondaryConstructors.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("addSuperclassPrimaryConstructor.kt")
        public void testAddSuperclassPrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/addSuperclassPrimaryConstructor.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("addTypeParameters.kt")
        public void testAddTypeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/addTypeParameters.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("addTypeParametersWithAbstract.kt")
        public void testAddTypeParametersWithAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/addTypeParametersWithAbstract.kt");
            doExtractSuperclassTest(fileName);
        }

        public void testAllFilesPresentInExtractSuperclass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractSuperclass"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotation.kt")
        public void testAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/annotation.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/enum.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("interface.kt")
        public void testInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/interface.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("privateClass.kt")
        public void testPrivateClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/privateClass.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("privateMember.kt")
        public void testPrivateMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/privateMember.kt");
            doExtractSuperclassTest(fileName);
        }

        @TestMetadata("replaceSuperclass.kt")
        public void testReplaceSuperclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractSuperclass/replaceSuperclass.kt");
            doExtractSuperclassTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/extractInterface")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtractInterface extends AbstractExtractionTest {
        @TestMetadata("addInterface.kt")
        public void testAddInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractInterface/addInterface.kt");
            doExtractInterfaceTest(fileName);
        }

        @TestMetadata("addInterfaceWithAbstract.kt")
        public void testAddInterfaceWithAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractInterface/addInterfaceWithAbstract.kt");
            doExtractInterfaceTest(fileName);
        }

        @TestMetadata("addTypeParameters.kt")
        public void testAddTypeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractInterface/addTypeParameters.kt");
            doExtractInterfaceTest(fileName);
        }

        @TestMetadata("addTypeParametersWithAbstract.kt")
        public void testAddTypeParametersWithAbstract() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractInterface/addTypeParametersWithAbstract.kt");
            doExtractInterfaceTest(fileName);
        }

        public void testAllFilesPresentInExtractInterface() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/extractInterface"), Pattern.compile("^(.+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotation.kt")
        public void testAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/extractInterface/annotation.kt");
            doExtractInterfaceTest(fileName);
        }
    }
}
