/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/refactoring/rename")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class RenameTestGenerated extends AbstractRenameTest {
    public void testAllFilesPresentInRename() throws Exception {
        KotlinTestUtils.assertAllTestsPresentInSingleGeneratedClass(this.getClass(), new File("idea/testData/refactoring/rename"), Pattern.compile("^(.+)\\.test$"), TargetBackend.ANY);
    }

    @TestMetadata("ambiguousClassFunImportRenameClass/ambiguousClassFunImportRenameClass.test")
    public void testAmbiguousClassFunImportRenameClass_AmbiguousClassFunImportRenameClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/ambiguousClassFunImportRenameClass/ambiguousClassFunImportRenameClass.test");
        doTest(fileName);
    }

    @TestMetadata("ambiguousClassFunImportRenameFun/ambiguousClassFunImportRenameFun.test")
    public void testAmbiguousClassFunImportRenameFun_AmbiguousClassFunImportRenameFun() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/ambiguousClassFunImportRenameFun/ambiguousClassFunImportRenameFun.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamer/simple.test")
    public void testAutomaticRenamer_Simple() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamer/simple.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerForJavaClass/javaClass.test")
    public void testAutomaticRenamerForJavaClass_JavaClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerForJavaClass/javaClass.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerJavaParameter/parameter.test")
    public void testAutomaticRenamerJavaParameter_Parameter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerJavaParameter/parameter.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerKotlinTestClass/automaticRenamerKotlinTestClass.test")
    public void testAutomaticRenamerKotlinTestClass_AutomaticRenamerKotlinTestClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerKotlinTestClass/automaticRenamerKotlinTestClass.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerKotlinTestClassForFacade/automaticRenamerKotlinTestClassForFacade.test")
    public void testAutomaticRenamerKotlinTestClassForFacade_AutomaticRenamerKotlinTestClassForFacade() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerKotlinTestClassForFacade/automaticRenamerKotlinTestClassForFacade.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerOverloads/package.test")
    public void testAutomaticRenamerOverloads_Package() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerOverloads/package.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerOverloadsAmbiguousImport/automaticRenamerOverloadsAmbiguousImport.test")
    public void testAutomaticRenamerOverloadsAmbiguousImport_AutomaticRenamerOverloadsAmbiguousImport() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerOverloadsAmbiguousImport/automaticRenamerOverloadsAmbiguousImport.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerOverloadsClass/class.test")
    public void testAutomaticRenamerOverloadsClass_Class() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerOverloadsClass/class.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerOverloadsExtensionAndMember/automaticRenamerOverloadsExtensionAndMember.test")
    public void testAutomaticRenamerOverloadsExtensionAndMember_AutomaticRenamerOverloadsExtensionAndMember() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerOverloadsExtensionAndMember/automaticRenamerOverloadsExtensionAndMember.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerOverloadsJavaClass/overloads.test")
    public void testAutomaticRenamerOverloadsJavaClass_Overloads() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerOverloadsJavaClass/overloads.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerOverloadsMemberAndExtension/automaticRenamerOverloadsMemberAndExtension.test")
    public void testAutomaticRenamerOverloadsMemberAndExtension_AutomaticRenamerOverloadsMemberAndExtension() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerOverloadsMemberAndExtension/automaticRenamerOverloadsMemberAndExtension.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerOverloadsObject/object.test")
    public void testAutomaticRenamerOverloadsObject_Object() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerOverloadsObject/object.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerParameter/parameter.test")
    public void testAutomaticRenamerParameter_Parameter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerParameter/parameter.test");
        doTest(fileName);
    }

    @TestMetadata("automaticRenamerParameterInExtension/parameter.test")
    public void testAutomaticRenamerParameterInExtension_Parameter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticRenamerParameterInExtension/parameter.test");
        doTest(fileName);
    }

    @TestMetadata("automaticVariableRenamerWithQuotation/automaticVariableRenamerWithQuotation.test")
    public void testAutomaticVariableRenamerWithQuotation_AutomaticVariableRenamerWithQuotation() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/automaticVariableRenamerWithQuotation/automaticVariableRenamerWithQuotation.test");
        doTest(fileName);
    }

    @TestMetadata("clashOfNestedWithOuterClass/clashOfNestedWithOuterClass.test")
    public void testClashOfNestedWithOuterClass_ClashOfNestedWithOuterClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/clashOfNestedWithOuterClass/clashOfNestedWithOuterClass.test");
        doTest(fileName);
    }

    @TestMetadata("clashParameterWithProperty/clashParameterWithProperty.test")
    public void testClashParameterWithProperty_ClashParameterWithProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/clashParameterWithProperty/clashParameterWithProperty.test");
        doTest(fileName);
    }

    @TestMetadata("clashWithInnerClass/clashWithInnerClass.test")
    public void testClashWithInnerClass_ClashWithInnerClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/clashWithInnerClass/clashWithInnerClass.test");
        doTest(fileName);
    }

    @TestMetadata("clashWithNestedClass/clashWithNestedClass.test")
    public void testClashWithNestedClass_ClashWithNestedClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/clashWithNestedClass/clashWithNestedClass.test");
        doTest(fileName);
    }

    @TestMetadata("clashWithOuterClass/clashWithOuterClass.test")
    public void testClashWithOuterClass_ClashWithOuterClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/clashWithOuterClass/clashWithOuterClass.test");
        doTest(fileName);
    }

    @TestMetadata("classUsagesInTextFiles/classUsagesInTextFiles.test")
    public void testClassUsagesInTextFiles_ClassUsagesInTextFiles() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/classUsagesInTextFiles/classUsagesInTextFiles.test");
        doTest(fileName);
    }

    @TestMetadata("companionObject/companionObject.test")
    public void testCompanionObject_CompanionObject() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/companionObject/companionObject.test");
        doTest(fileName);
    }

    @TestMetadata("companionObjectWithDefaultName/companionObject.test")
    public void testCompanionObjectWithDefaultName_CompanionObject() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/companionObjectWithDefaultName/companionObject.test");
        doTest(fileName);
    }

    @TestMetadata("companionObjectWithNameMatchingClass/companionObject.test")
    public void testCompanionObjectWithNameMatchingClass_CompanionObject() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/companionObjectWithNameMatchingClass/companionObject.test");
        doTest(fileName);
    }

    @TestMetadata("fileNotUnderSourceRootWithNamesakeUnderSourceRoot/fileNotUnderSourceRootWithNamesakeUnderSourceRoot.test")
    public void testFileNotUnderSourceRootWithNamesakeUnderSourceRoot_FileNotUnderSourceRootWithNamesakeUnderSourceRoot() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/fileNotUnderSourceRootWithNamesakeUnderSourceRoot/fileNotUnderSourceRootWithNamesakeUnderSourceRoot.test");
        doTest(fileName);
    }

    @TestMetadata("lambdaParameterRedeclaration/lambdaParameterRedeclaration.test")
    public void testLambdaParameterRedeclaration_LambdaParameterRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/lambdaParameterRedeclaration/lambdaParameterRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("memberFunctionRedeclaration/memberFunctionRedeclaration.test")
    public void testMemberFunctionRedeclaration_MemberFunctionRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/memberFunctionRedeclaration/memberFunctionRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("memberPropertyRedeclaration/memberPropertyRedeclaration.test")
    public void testMemberPropertyRedeclaration_MemberPropertyRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/memberPropertyRedeclaration/memberPropertyRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("memberPropertyShadowedByLocalVar/memberPropertyShadowedByLocalVar.test")
    public void testMemberPropertyShadowedByLocalVar_MemberPropertyShadowedByLocalVar() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/memberPropertyShadowedByLocalVar/memberPropertyShadowedByLocalVar.test");
        doTest(fileName);
    }

    @TestMetadata("memberPropertyWithInnerInstanceProperty/memberPropertyWithInnerInstanceProperty.test")
    public void testMemberPropertyWithInnerInstanceProperty_MemberPropertyWithInnerInstanceProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/memberPropertyWithInnerInstanceProperty/memberPropertyWithInnerInstanceProperty.test");
        doTest(fileName);
    }

    @TestMetadata("memberPropertyWithOuterInstanceProperty/memberPropertyWithOuterInstanceProperty.test")
    public void testMemberPropertyWithOuterInstanceProperty_MemberPropertyWithOuterInstanceProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/memberPropertyWithOuterInstanceProperty/memberPropertyWithOuterInstanceProperty.test");
        doTest(fileName);
    }

    @TestMetadata("nestedClassRedeclaration/nestedClassRedeclaration.test")
    public void testNestedClassRedeclaration_NestedClassRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/nestedClassRedeclaration/nestedClassRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("nonCodePropertyAccessorUsages/nonCodePropertyAccessorUsages.test")
    public void testNonCodePropertyAccessorUsages_NonCodePropertyAccessorUsages() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/nonCodePropertyAccessorUsages/nonCodePropertyAccessorUsages.test");
        doTest(fileName);
    }

    @TestMetadata("noShadowingConflictForSiblingDeclarations/noShadowingConflictForSiblingDeclarations.test")
    public void testNoShadowingConflictForSiblingDeclarations_NoShadowingConflictForSiblingDeclarations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/noShadowingConflictForSiblingDeclarations/noShadowingConflictForSiblingDeclarations.test");
        doTest(fileName);
    }

    @TestMetadata("objectAlias/objectAlias.test")
    public void testObjectAlias_ObjectAlias() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/objectAlias/objectAlias.test");
        doTest(fileName);
    }

    @TestMetadata("objectAliasByRef/objectAliasByRef.test")
    public void testObjectAliasByRef_ObjectAliasByRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/objectAliasByRef/objectAliasByRef.test");
        doTest(fileName);
    }

    @TestMetadata("paramererAsReceiverWithNewNameAsSelector/parameterAsReceiverWithNewNameAsSelector.test")
    public void testParamererAsReceiverWithNewNameAsSelector_ParameterAsReceiverWithNewNameAsSelector() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/paramererAsReceiverWithNewNameAsSelector/parameterAsReceiverWithNewNameAsSelector.test");
        doTest(fileName);
    }

    @TestMetadata("parameterRedeclaration/parameterRedeclaration.test")
    public void testParameterRedeclaration_ParameterRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/parameterRedeclaration/parameterRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("parameterTextOccurrences/parameterTextOccurrences.test")
    public void testParameterTextOccurrences_ParameterTextOccurrences() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/parameterTextOccurrences/parameterTextOccurrences.test");
        doTest(fileName);
    }

    @TestMetadata("parameterWithQuotation/parameterWithQuotation.test")
    public void testParameterWithQuotation_ParameterWithQuotation() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/parameterWithQuotation/parameterWithQuotation.test");
        doTest(fileName);
    }

    @TestMetadata("primaryConstructorParameterRedeclaration/primaryConstructorParameterRedeclaration.test")
    public void testPrimaryConstructorParameterRedeclaration_PrimaryConstructorParameterRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/primaryConstructorParameterRedeclaration/primaryConstructorParameterRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("propertyAccidentalOverrideSubclass/propertyAccidentalOverrideSubclass.test")
    public void testPropertyAccidentalOverrideSubclass_PropertyAccidentalOverrideSubclass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/propertyAccidentalOverrideSubclass/propertyAccidentalOverrideSubclass.test");
        doTest(fileName);
    }

    @TestMetadata("propertyAccidentalOverrideSuperclass/propertyAccidentalOverrideSuperclass.test")
    public void testPropertyAccidentalOverrideSuperclass_PropertyAccidentalOverrideSuperclass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/propertyAccidentalOverrideSuperclass/propertyAccidentalOverrideSuperclass.test");
        doTest(fileName);
    }

    @TestMetadata("propertyParameterAccidentalOverrideSubclass/propertyParameterAccidentalOverrideSubclass.test")
    public void testPropertyParameterAccidentalOverrideSubclass_PropertyParameterAccidentalOverrideSubclass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/propertyParameterAccidentalOverrideSubclass/propertyParameterAccidentalOverrideSubclass.test");
        doTest(fileName);
    }

    @TestMetadata("propertyParameterAccidentalOverrideSuperclass/propertyParameterAccidentalOverrideSuperclass.test")
    public void testPropertyParameterAccidentalOverrideSuperclass_PropertyParameterAccidentalOverrideSuperclass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/propertyParameterAccidentalOverrideSuperclass/propertyParameterAccidentalOverrideSuperclass.test");
        doTest(fileName);
    }

    @TestMetadata("propertyParameterRedeclaredByProperty/propertyParameterRedeclaredByProperty.test")
    public void testPropertyParameterRedeclaredByProperty_PropertyParameterRedeclaredByProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/propertyParameterRedeclaredByProperty/propertyParameterRedeclaredByProperty.test");
        doTest(fileName);
    }

    @TestMetadata("propertyRedeclaredByPropertyParameter/propertyRedeclaredByPropertyParameter.test")
    public void testPropertyRedeclaredByPropertyParameter_PropertyRedeclaredByPropertyParameter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/propertyRedeclaredByPropertyParameter/propertyRedeclaredByPropertyParameter.test");
        doTest(fileName);
    }

    @TestMetadata("renameArgumentsWhenParameterRenamed/parameter.test")
    public void testRenameArgumentsWhenParameterRenamed_Parameter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameArgumentsWhenParameterRenamed/parameter.test");
        doTest(fileName);
    }

    @TestMetadata("renameBundle/renameBundle.test")
    public void testRenameBundle_RenameBundle() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameBundle/renameBundle.test");
        doTest(fileName);
    }

    @TestMetadata("renameBundleProperty/renameBundleProperty.test")
    public void testRenameBundleProperty_RenameBundleProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameBundleProperty/renameBundleProperty.test");
        doTest(fileName);
    }

    @TestMetadata("renameClassByRefInConstructorDelegationCall/renameClassByRefInConstructorDelegationCall.test")
    public void testRenameClassByRefInConstructorDelegationCall_RenameClassByRefInConstructorDelegationCall() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameClassByRefInConstructorDelegationCall/renameClassByRefInConstructorDelegationCall.test");
        doTest(fileName);
    }

    @TestMetadata("renameClassTypeParameterRedeclaration/renameClassTypeParameterRedeclaration.test")
    public void testRenameClassTypeParameterRedeclaration_RenameClassTypeParameterRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameClassTypeParameterRedeclaration/renameClassTypeParameterRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("renameClassTypeParameterRedeclarationWithOuterScope/renameClassTypeParameterRedeclarationWithOuterScope.test")
    public void testRenameClassTypeParameterRedeclarationWithOuterScope_RenameClassTypeParameterRedeclarationWithOuterScope() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameClassTypeParameterRedeclarationWithOuterScope/renameClassTypeParameterRedeclarationWithOuterScope.test");
        doTest(fileName);
    }

    @TestMetadata("renameClassWithAutoVarConventions/renameClassWithAutoVarConventions.test")
    public void testRenameClassWithAutoVarConventions_RenameClassWithAutoVarConventions() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameClassWithAutoVarConventions/renameClassWithAutoVarConventions.test");
        doTest(fileName);
    }

    @TestMetadata("renameCompareTo/compareTo.test")
    public void testRenameCompareTo_CompareTo() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameCompareTo/compareTo.test");
        doTest(fileName);
    }

    @TestMetadata("renameContains/contains.test")
    public void testRenameContains_Contains() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameContains/contains.test");
        doTest(fileName);
    }

    @TestMetadata("renameContainsWithConflicts/containsWithConflicts.test")
    public void testRenameContainsWithConflicts_ContainsWithConflicts() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameContainsWithConflicts/containsWithConflicts.test");
        doTest(fileName);
    }

    @TestMetadata("renamedClassShadowingImplicitlyImportedClassUsage/renamedClassShadowingImplicitlyImportedClassUsage.test")
    public void testRenamedClassShadowingImplicitlyImportedClassUsage_RenamedClassShadowingImplicitlyImportedClassUsage() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renamedClassShadowingImplicitlyImportedClassUsage/renamedClassShadowingImplicitlyImportedClassUsage.test");
        doTest(fileName);
    }

    @TestMetadata("renamedClassShadowingImportedClassUsage/renamedClassShadowingImportedClassUsage.test")
    public void testRenamedClassShadowingImportedClassUsage_RenamedClassShadowingImportedClassUsage() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renamedClassShadowingImportedClassUsage/renamedClassShadowingImportedClassUsage.test");
        doTest(fileName);
    }

    @TestMetadata("renameDefaultJavaAnnotationMethod/renameDefaultJavaAnnotationMethod.test")
    public void testRenameDefaultJavaAnnotationMethod_RenameDefaultJavaAnnotationMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameDefaultJavaAnnotationMethod/renameDefaultJavaAnnotationMethod.test");
        doTest(fileName);
    }

    @TestMetadata("renameDefaultKotlinAnnotationMethod/renameDefaultKotlinAnnotationMethod.test")
    public void testRenameDefaultKotlinAnnotationMethod_RenameDefaultKotlinAnnotationMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameDefaultKotlinAnnotationMethod/renameDefaultKotlinAnnotationMethod.test");
        doTest(fileName);
    }

    @TestMetadata("renameEmptyKotlinFile/renameFile.test")
    public void testRenameEmptyKotlinFile_RenameFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameEmptyKotlinFile/renameFile.test");
        doTest(fileName);
    }

    @TestMetadata("renameEquals/equals.test")
    public void testRenameEquals_Equals() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameEquals/equals.test");
        doTest(fileName);
    }

    @TestMetadata("renameExplicitComponentFunction/explicitComponentFunction.test")
    public void testRenameExplicitComponentFunction_ExplicitComponentFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameExplicitComponentFunction/explicitComponentFunction.test");
        doTest(fileName);
    }

    @TestMetadata("renameFieldIdentifier/fieldIdentifier.test")
    public void testRenameFieldIdentifier_FieldIdentifier() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameFieldIdentifier/fieldIdentifier.test");
        doTest(fileName);
    }

    @TestMetadata("renameFunctionTypeParameterRedeclaration/renameFunctionTypeParameterRedeclaration.test")
    public void testRenameFunctionTypeParameterRedeclaration_RenameFunctionTypeParameterRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameFunctionTypeParameterRedeclaration/renameFunctionTypeParameterRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("renameFunctionTypeParameterRedeclarationWithOuterScope/renameFunctionTypeParameterRedeclarationWithOuterScope.test")
    public void testRenameFunctionTypeParameterRedeclarationWithOuterScope_RenameFunctionTypeParameterRedeclarationWithOuterScope() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameFunctionTypeParameterRedeclarationWithOuterScope/renameFunctionTypeParameterRedeclarationWithOuterScope.test");
        doTest(fileName);
    }

    @TestMetadata("renameGet/get.test")
    public void testRenameGet_Get() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameGet/get.test");
        doTest(fileName);
    }

    @TestMetadata("renameInc/inc.test")
    public void testRenameInc_Inc() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameInc/inc.test");
        doTest(fileName);
    }

    @TestMetadata("renameInvoke/invoke.test")
    public void testRenameInvoke_Invoke() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameInvoke/invoke.test");
        doTest(fileName);
    }

    @TestMetadata("renameIterator/iterator.test")
    public void testRenameIterator_Iterator() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameIterator/iterator.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaClass/renameJavaClass.test")
    public void testRenameJavaClass_RenameJavaClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaClass/renameJavaClass.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaInterface/renameJavaInterface.test")
    public void testRenameJavaInterface_RenameJavaInterface() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaInterface/renameJavaInterface.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaMethod/javaBaseMethod.test")
    public void testRenameJavaMethod_JavaBaseMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaMethod/javaBaseMethod.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaMethod/kotlinOverridenMethod.test")
    public void testRenameJavaMethod_KotlinOverridenMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaMethod/kotlinOverridenMethod.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaMethodToKtKeyword/renameJavaMethodToKtKeyword.test")
    public void testRenameJavaMethodToKtKeyword_RenameJavaMethodToKtKeyword() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaMethodToKtKeyword/renameJavaMethodToKtKeyword.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaSyntheticIsPropertyByGetterRef/renameJavaSyntheticIsPropertyByGetterRef.test")
    public void testRenameJavaSyntheticIsPropertyByGetterRef_RenameJavaSyntheticIsPropertyByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaSyntheticIsPropertyByGetterRef/renameJavaSyntheticIsPropertyByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaSyntheticPropertyByGetterRef/renameJavaSyntheticPropertyByGetterRef.test")
    public void testRenameJavaSyntheticPropertyByGetterRef_RenameJavaSyntheticPropertyByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaSyntheticPropertyByGetterRef/renameJavaSyntheticPropertyByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaSyntheticPropertyByGetterSetterRef/renameJavaSyntheticPropertyByGetterSetterRef.test")
    public void testRenameJavaSyntheticPropertyByGetterSetterRef_RenameJavaSyntheticPropertyByGetterSetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaSyntheticPropertyByGetterSetterRef/renameJavaSyntheticPropertyByGetterSetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameJavaSyntheticPropertyBySetterRef/renameJavaSyntheticPropertyBySetterRef.test")
    public void testRenameJavaSyntheticPropertyBySetterRef_RenameJavaSyntheticPropertyBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameJavaSyntheticPropertyBySetterRef/renameJavaSyntheticPropertyBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinBaseMethod/javaWrapperForBaseFunction.test")
    public void testRenameKotlinBaseMethod_JavaWrapperForBaseFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinBaseMethod/javaWrapperForBaseFunction.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinBaseMethod/javaWrapperForOverridenFunctionWithKotlinBase.test")
    public void testRenameKotlinBaseMethod_JavaWrapperForOverridenFunctionWithKotlinBase() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinBaseMethod/javaWrapperForOverridenFunctionWithKotlinBase.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinBaseMethod/kotlinBaseFunction.test")
    public void testRenameKotlinBaseMethod_KotlinBaseFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinBaseMethod/kotlinBaseFunction.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinClass/javaWrapperForKotlinClass.test")
    public void testRenameKotlinClass_JavaWrapperForKotlinClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinClass/javaWrapperForKotlinClass.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinClass/kotlinClass.test")
    public void testRenameKotlinClass_KotlinClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinClass/kotlinClass.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinClassByConstructorRef/kotlinClass.test")
    public void testRenameKotlinClassByConstructorRef_KotlinClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinClassByConstructorRef/kotlinClass.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinClassConstructor/renameKotlinConstructor.test")
    public void testRenameKotlinClassConstructor_RenameKotlinConstructor() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinClassConstructor/renameKotlinConstructor.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinClassSecondaryConstructor/renameKotlinSecondaryConstructor.test")
    public void testRenameKotlinClassSecondaryConstructor_RenameKotlinSecondaryConstructor() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinClassSecondaryConstructor/renameKotlinSecondaryConstructor.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinClassWithFile/javaClassWrapper.test")
    public void testRenameKotlinClassWithFile_JavaClassWrapper() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinClassWithFile/javaClassWrapper.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinClassWithFile/kotlinClass.test")
    public void testRenameKotlinClassWithFile_KotlinClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinClassWithFile/kotlinClass.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinDataClassParameter/renameKotlinDataClassParameter.test")
    public void testRenameKotlinDataClassParameter_RenameKotlinDataClassParameter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinDataClassParameter/renameKotlinDataClassParameter.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinEnum/renameKotlinEnum.test")
    public void testRenameKotlinEnum_RenameKotlinEnum() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinEnum/renameKotlinEnum.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinEnumConstByJavaRef/renameKotlinEnumConstByJavaRef.test")
    public void testRenameKotlinEnumConstByJavaRef_RenameKotlinEnumConstByJavaRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinEnumConstByJavaRef/renameKotlinEnumConstByJavaRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinEnumEntry/renameKotlinEnumEntry.test")
    public void testRenameKotlinEnumEntry_RenameKotlinEnumEntry() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinEnumEntry/renameKotlinEnumEntry.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFacadeClassViaTopLevelClass/renameKotlinFacadeClassViaTopLevelClass.test")
    public void testRenameKotlinFacadeClassViaTopLevelClass_RenameKotlinFacadeClassViaTopLevelClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFacadeClassViaTopLevelClass/renameKotlinFacadeClassViaTopLevelClass.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFacadeClassWithDefaultNameAndCommentsByRef/renameKotlinFacadeClassWithDefaultNameByRef.test")
    public void testRenameKotlinFacadeClassWithDefaultNameAndCommentsByRef_RenameKotlinFacadeClassWithDefaultNameByRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFacadeClassWithDefaultNameAndCommentsByRef/renameKotlinFacadeClassWithDefaultNameByRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFacadeClassWithDefaultNameAndJvmMultifileClassByRef/renameKotlinFacadeClassWithDefaultNameByRef.test")
    public void testRenameKotlinFacadeClassWithDefaultNameAndJvmMultifileClassByRef_RenameKotlinFacadeClassWithDefaultNameByRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFacadeClassWithDefaultNameAndJvmMultifileClassByRef/renameKotlinFacadeClassWithDefaultNameByRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFacadeClassWithDefaultNameByRef/renameKotlinFacadeClassWithDefaultNameByRef.test")
    public void testRenameKotlinFacadeClassWithDefaultNameByRef_RenameKotlinFacadeClassWithDefaultNameByRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFacadeClassWithDefaultNameByRef/renameKotlinFacadeClassWithDefaultNameByRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFacadeClassWithDefaultNameViaFileNameByRef/renameKotlinFacadeClassWithDefaultNameByRef.test")
    public void testRenameKotlinFacadeClassWithDefaultNameViaFileNameByRef_RenameKotlinFacadeClassWithDefaultNameByRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFacadeClassWithDefaultNameViaFileNameByRef/renameKotlinFacadeClassWithDefaultNameByRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFacadeClassWithJvmNameByRef/renameKotlinFacadeClassWithJvmNameByRef.test")
    public void testRenameKotlinFacadeClassWithJvmNameByRef_RenameKotlinFacadeClassWithJvmNameByRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFacadeClassWithJvmNameByRef/renameKotlinFacadeClassWithJvmNameByRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFacadeClassWithJvmNameToDefaultByRef/renameKotlinFacadeClassWithJvmNameByRef.test")
    public void testRenameKotlinFacadeClassWithJvmNameToDefaultByRef_RenameKotlinFacadeClassWithJvmNameByRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFacadeClassWithJvmNameToDefaultByRef/renameKotlinFacadeClassWithJvmNameByRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFile/renameFile.test")
    public void testRenameKotlinFile_RenameFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFile/renameFile.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFunctionInEnum/renameKotlinFunctionInEnum.test")
    public void testRenameKotlinFunctionInEnum_RenameKotlinFunctionInEnum() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFunctionInEnum/renameKotlinFunctionInEnum.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFunctionInEnum/renameKotlinFunctionInEnumFromSubclass.test")
    public void testRenameKotlinFunctionInEnum_RenameKotlinFunctionInEnumFromSubclass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFunctionInEnum/renameKotlinFunctionInEnumFromSubclass.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFunWithJvmName/renameKotlinFunWithJvmName.test")
    public void testRenameKotlinFunWithJvmName_RenameKotlinFunWithJvmName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFunWithJvmName/renameKotlinFunWithJvmName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFunWithJvmNameByJavaRef/renameKotlinFunWithJvmNameByJavaRef.test")
    public void testRenameKotlinFunWithJvmNameByJavaRef_RenameKotlinFunWithJvmNameByJavaRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFunWithJvmNameByJavaRef/renameKotlinFunWithJvmNameByJavaRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinFunWithJvmNameToDefaultByJavaRef/renameKotlinFunWithJvmNameToDefaultByJavaRef.test")
    public void testRenameKotlinFunWithJvmNameToDefaultByJavaRef_RenameKotlinFunWithJvmNameToDefaultByJavaRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinFunWithJvmNameToDefaultByJavaRef/renameKotlinFunWithJvmNameToDefaultByJavaRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinMethod/javaWrapperForKotlinMethod.test")
    public void testRenameKotlinMethod_JavaWrapperForKotlinMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinMethod/javaWrapperForKotlinMethod.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinMethod/renameKotlinMethod.test")
    public void testRenameKotlinMethod_RenameKotlinMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinMethod/renameKotlinMethod.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinMethodWithEscapedName/renameKotlinMethodWithEscapedName.test")
    public void testRenameKotlinMethodWithEscapedName_RenameKotlinMethodWithEscapedName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinMethodWithEscapedName/renameKotlinMethodWithEscapedName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinMultifileFacadeClassWithJvmNameByRef/renameKotlinMultifileFacadeClassWithJvmName.test")
    public void testRenameKotlinMultifileFacadeClassWithJvmNameByRef_RenameKotlinMultifileFacadeClassWithJvmName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinMultifileFacadeClassWithJvmNameByRef/renameKotlinMultifileFacadeClassWithJvmName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPackage/renameInOtherFile.test")
    public void testRenameKotlinPackage_RenameInOtherFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPackage/renameInOtherFile.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPackage/renameKotlinPackage.test")
    public void testRenameKotlinPackage_RenameKotlinPackage() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPackage/renameKotlinPackage.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPackageFunctionFromJava/renameKotlinPackageFunctionFromJava.test")
    public void testRenameKotlinPackageFunctionFromJava_RenameKotlinPackageFunctionFromJava() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPackageFunctionFromJava/renameKotlinPackageFunctionFromJava.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPackageFunctionFromJavaNewFacade/renameKotlinPackageFunctionFromJava.test")
    public void testRenameKotlinPackageFunctionFromJavaNewFacade_RenameKotlinPackageFunctionFromJava() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPackageFunctionFromJavaNewFacade/renameKotlinPackageFunctionFromJava.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterJvmName/renameKotlinParameterWithGetterJvmName.test")
    public void testRenameKotlinParameterWithGetterJvmName_RenameKotlinParameterWithGetterJvmName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterJvmName/renameKotlinParameterWithGetterJvmName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterJvmNameByGetterRef/renameKotlinParameterWithGetterJvmNameByGetterRef.test")
    public void testRenameKotlinParameterWithGetterJvmNameByGetterRef_RenameKotlinParameterWithGetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterJvmNameByGetterRef/renameKotlinParameterWithGetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterJvmNameBySetterRef/renameKotlinParameterWithGetterJvmNameBySetterRef.test")
    public void testRenameKotlinParameterWithGetterJvmNameBySetterRef_RenameKotlinParameterWithGetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterJvmNameBySetterRef/renameKotlinParameterWithGetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterJvmNameToDefaultByGetterRef/renameKotlinParameterWithGetterJvmNameByGetterRef.test")
    public void testRenameKotlinParameterWithGetterJvmNameToDefaultByGetterRef_RenameKotlinParameterWithGetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterJvmNameToDefaultByGetterRef/renameKotlinParameterWithGetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterSetterJvmName/renameKotlinParameterWithGetterSetterJvmName.test")
    public void testRenameKotlinParameterWithGetterSetterJvmName_RenameKotlinParameterWithGetterSetterJvmName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterSetterJvmName/renameKotlinParameterWithGetterSetterJvmName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterSetterJvmNameByGetterRef/renameKotlinParameterWithGetterSetterJvmNameByGetterRef.test")
    public void testRenameKotlinParameterWithGetterSetterJvmNameByGetterRef_RenameKotlinParameterWithGetterSetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterSetterJvmNameByGetterRef/renameKotlinParameterWithGetterSetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterSetterJvmNameBySetterRef/renameKotlinParameterWithGetterSetterJvmNameBySetterRef.test")
    public void testRenameKotlinParameterWithGetterSetterJvmNameBySetterRef_RenameKotlinParameterWithGetterSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterSetterJvmNameBySetterRef/renameKotlinParameterWithGetterSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterSetterJvmNameToDefaultByGetterRef/renameKotlinParameterWithGetterSetterJvmNameByGetterRef.test")
    public void testRenameKotlinParameterWithGetterSetterJvmNameToDefaultByGetterRef_RenameKotlinParameterWithGetterSetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterSetterJvmNameToDefaultByGetterRef/renameKotlinParameterWithGetterSetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithGetterSetterJvmNameToDefaultBySetterRef/renameKotlinParameterWithGetterSetterJvmNameBySetterRef.test")
    public void testRenameKotlinParameterWithGetterSetterJvmNameToDefaultBySetterRef_RenameKotlinParameterWithGetterSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithGetterSetterJvmNameToDefaultBySetterRef/renameKotlinParameterWithGetterSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithSetterJvmName/renameKotlinParameterWithSetterJvmName.test")
    public void testRenameKotlinParameterWithSetterJvmName_RenameKotlinParameterWithSetterJvmName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithSetterJvmName/renameKotlinParameterWithSetterJvmName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithSetterJvmNameByGetterRef/renameKotlinParameterWithSetterJvmNameByGetterRef.test")
    public void testRenameKotlinParameterWithSetterJvmNameByGetterRef_RenameKotlinParameterWithSetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithSetterJvmNameByGetterRef/renameKotlinParameterWithSetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithSetterJvmNameBySetterRef/renameKotlinParameterWithSetterJvmNameBySetterRef.test")
    public void testRenameKotlinParameterWithSetterJvmNameBySetterRef_RenameKotlinParameterWithSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithSetterJvmNameBySetterRef/renameKotlinParameterWithSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinParameterWithSetterJvmNameToDefaultBySetterRef/renameKotlinParameterWithSetterJvmNameBySetterRef.test")
    public void testRenameKotlinParameterWithSetterJvmNameToDefaultBySetterRef_RenameKotlinParameterWithSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinParameterWithSetterJvmNameToDefaultBySetterRef/renameKotlinParameterWithSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPrimaryConstructorProperty/renameKotlinPrimaryConstructorProperty.test")
    public void testRenameKotlinPrimaryConstructorProperty_RenameKotlinPrimaryConstructorProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPrimaryConstructorProperty/renameKotlinPrimaryConstructorProperty.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPrimaryConstructorPropertyFromOverride/renameKotlinPrimaryConstructorPropertyFromOverride.test")
    public void testRenameKotlinPrimaryConstructorPropertyFromOverride_RenameKotlinPrimaryConstructorPropertyFromOverride() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPrimaryConstructorPropertyFromOverride/renameKotlinPrimaryConstructorPropertyFromOverride.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithCustomGetterSetterJvmNameByGetterRef/renameKotlinPropertyWithCustomGetterSetterJvmNameByGetterRef.test")
    public void testRenameKotlinPropertyWithCustomGetterSetterJvmNameByGetterRef_RenameKotlinPropertyWithCustomGetterSetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithCustomGetterSetterJvmNameByGetterRef/renameKotlinPropertyWithCustomGetterSetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithCustomGetterSetterJvmNameBySetterRef/renameKotlinPropertyWithCustomGetterSetterJvmNameBySetterRef.test")
    public void testRenameKotlinPropertyWithCustomGetterSetterJvmNameBySetterRef_RenameKotlinPropertyWithCustomGetterSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithCustomGetterSetterJvmNameBySetterRef/renameKotlinPropertyWithCustomGetterSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterJvmName/renameKotlinPropertyWithGetterJvmName.test")
    public void testRenameKotlinPropertyWithGetterJvmName_RenameKotlinPropertyWithGetterJvmName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterJvmName/renameKotlinPropertyWithGetterJvmName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterJvmNameByGetterRef/renameKotlinPropertyWithGetterJvmNameByGetterRef.test")
    public void testRenameKotlinPropertyWithGetterJvmNameByGetterRef_RenameKotlinPropertyWithGetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterJvmNameByGetterRef/renameKotlinPropertyWithGetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterJvmNameBySetterRef/renameKotlinPropertyWithGetterJvmNameBySetterRef.test")
    public void testRenameKotlinPropertyWithGetterJvmNameBySetterRef_RenameKotlinPropertyWithGetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterJvmNameBySetterRef/renameKotlinPropertyWithGetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterJvmNameToDefaultByGetterRef/renameKotlinPropertyWithGetterJvmNameByGetterRef.test")
    public void testRenameKotlinPropertyWithGetterJvmNameToDefaultByGetterRef_RenameKotlinPropertyWithGetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterJvmNameToDefaultByGetterRef/renameKotlinPropertyWithGetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterSetterJvmName/renameKotlinPropertyWithGetterSetterJvmName.test")
    public void testRenameKotlinPropertyWithGetterSetterJvmName_RenameKotlinPropertyWithGetterSetterJvmName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterSetterJvmName/renameKotlinPropertyWithGetterSetterJvmName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterSetterJvmNameByGetterRef/renameKotlinPropertyWithGetterSetterJvmNameByGetterRef.test")
    public void testRenameKotlinPropertyWithGetterSetterJvmNameByGetterRef_RenameKotlinPropertyWithGetterSetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterSetterJvmNameByGetterRef/renameKotlinPropertyWithGetterSetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterSetterJvmNameBySetterRef/renameKotlinPropertyWithGetterSetterJvmNameBySetterRef.test")
    public void testRenameKotlinPropertyWithGetterSetterJvmNameBySetterRef_RenameKotlinPropertyWithGetterSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterSetterJvmNameBySetterRef/renameKotlinPropertyWithGetterSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterSetterJvmNameToDefaultByGetterRef/renameKotlinPropertyWithGetterSetterJvmNameByGetterRef.test")
    public void testRenameKotlinPropertyWithGetterSetterJvmNameToDefaultByGetterRef_RenameKotlinPropertyWithGetterSetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterSetterJvmNameToDefaultByGetterRef/renameKotlinPropertyWithGetterSetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithGetterSetterJvmNameToDefaultBySetterRef/renameKotlinPropertyWithGetterSetterJvmNameBySetterRef.test")
    public void testRenameKotlinPropertyWithGetterSetterJvmNameToDefaultBySetterRef_RenameKotlinPropertyWithGetterSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithGetterSetterJvmNameToDefaultBySetterRef/renameKotlinPropertyWithGetterSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithJvmField/renameKotlinPropertyWithJvmField.test")
    public void testRenameKotlinPropertyWithJvmField_RenameKotlinPropertyWithJvmField() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithJvmField/renameKotlinPropertyWithJvmField.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithMatchingGetterSetterJvmNameByGetterRef/renameKotlinPropertyWithMatchingGetterSetterJvmNameByGetterRef.test")
    public void testRenameKotlinPropertyWithMatchingGetterSetterJvmNameByGetterRef_RenameKotlinPropertyWithMatchingGetterSetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithMatchingGetterSetterJvmNameByGetterRef/renameKotlinPropertyWithMatchingGetterSetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithMatchingGetterSetterJvmNameBySetterRef/renameKotlinPropertyWithMatchingGetterSetterJvmNameBySetterRef.test")
    public void testRenameKotlinPropertyWithMatchingGetterSetterJvmNameBySetterRef_RenameKotlinPropertyWithMatchingGetterSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithMatchingGetterSetterJvmNameBySetterRef/renameKotlinPropertyWithMatchingGetterSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithSetterJvmName/renameKotlinPropertyWithSetterJvmName.test")
    public void testRenameKotlinPropertyWithSetterJvmName_RenameKotlinPropertyWithSetterJvmName() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithSetterJvmName/renameKotlinPropertyWithSetterJvmName.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithSetterJvmNameByGetterRef/renameKotlinPropertyWithSetterJvmNameByGetterRef.test")
    public void testRenameKotlinPropertyWithSetterJvmNameByGetterRef_RenameKotlinPropertyWithSetterJvmNameByGetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithSetterJvmNameByGetterRef/renameKotlinPropertyWithSetterJvmNameByGetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithSetterJvmNameBySetterRef/renameKotlinPropertyWithSetterJvmNameBySetterRef.test")
    public void testRenameKotlinPropertyWithSetterJvmNameBySetterRef_RenameKotlinPropertyWithSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithSetterJvmNameBySetterRef/renameKotlinPropertyWithSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinPropertyWithSetterJvmNameToDefaultBySetterRef/renameKotlinPropertyWithSetterJvmNameBySetterRef.test")
    public void testRenameKotlinPropertyWithSetterJvmNameToDefaultBySetterRef_RenameKotlinPropertyWithSetterJvmNameBySetterRef() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinPropertyWithSetterJvmNameToDefaultBySetterRef/renameKotlinPropertyWithSetterJvmNameBySetterRef.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinStaticMethod/renameKotlinStaticMethod.test")
    public void testRenameKotlinStaticMethod_RenameKotlinStaticMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinStaticMethod/renameKotlinStaticMethod.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinStaticMethodWithJvmOverloads/renameKotlinStaticMethodWithJvmOverloads.test")
    public void testRenameKotlinStaticMethodWithJvmOverloads_RenameKotlinStaticMethodWithJvmOverloads() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinStaticMethodWithJvmOverloads/renameKotlinStaticMethodWithJvmOverloads.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinStaticProperty/renameKotlinStaticProperty.test")
    public void testRenameKotlinStaticProperty_RenameKotlinStaticProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinStaticProperty/renameKotlinStaticProperty.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinTopLevelVarProperty/renameTopLevelVarProperty.test")
    public void testRenameKotlinTopLevelVarProperty_RenameTopLevelVarProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinTopLevelVarProperty/renameTopLevelVarProperty.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinValProperty/renameAsJavaGetterForExplicitGetter.test")
    public void testRenameKotlinValProperty_RenameAsJavaGetterForExplicitGetter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinValProperty/renameAsJavaGetterForExplicitGetter.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinValProperty/renameBase.test")
    public void testRenameKotlinValProperty_RenameBase() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinValProperty/renameBase.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinValProperty/renameOverriden.test")
    public void testRenameKotlinValProperty_RenameOverriden() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinValProperty/renameOverriden.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinValPropertyInCompanionObject/renameKotlinValPropertyInCompanionObject.test")
    public void testRenameKotlinValPropertyInCompanionObject_RenameKotlinValPropertyInCompanionObject() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinValPropertyInCompanionObject/renameKotlinValPropertyInCompanionObject.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinValPropertyInObject/renameKotlinValPropertyInObject.test")
    public void testRenameKotlinValPropertyInObject_RenameKotlinValPropertyInObject() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinValPropertyInObject/renameKotlinValPropertyInObject.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinVarProperty/renameAsJavaGetter.test")
    public void testRenameKotlinVarProperty_RenameAsJavaGetter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinVarProperty/renameAsJavaGetter.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinVarProperty/renameAsJavaSetter.test")
    public void testRenameKotlinVarProperty_RenameAsJavaSetter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinVarProperty/renameAsJavaSetter.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinVarProperty/renameBase.test")
    public void testRenameKotlinVarProperty_RenameBase() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinVarProperty/renameBase.test");
        doTest(fileName);
    }

    @TestMetadata("renameKotlinVarProperty/renameOverriden.test")
    public void testRenameKotlinVarProperty_RenameOverriden() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameKotlinVarProperty/renameOverriden.test");
        doTest(fileName);
    }

    @TestMetadata("renameOverriddenPropertyViaJavaGetter/renameOverriddenPropertyViaJavaGetter.test")
    public void testRenameOverriddenPropertyViaJavaGetter_RenameOverriddenPropertyViaJavaGetter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameOverriddenPropertyViaJavaGetter/renameOverriddenPropertyViaJavaGetter.test");
        doTest(fileName);
    }

    @TestMetadata("renameOverriddenPropertyViaJavaSetter/renameOverriddenPropertyViaJavaSetter.test")
    public void testRenameOverriddenPropertyViaJavaSetter_RenameOverriddenPropertyViaJavaSetter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameOverriddenPropertyViaJavaSetter/renameOverriddenPropertyViaJavaSetter.test");
        doTest(fileName);
    }

    @TestMetadata("renamePackageWithQuotation/renamePackageWithQuotation.test")
    public void testRenamePackageWithQuotation_RenamePackageWithQuotation() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renamePackageWithQuotation/renamePackageWithQuotation.test");
        doTest(fileName);
    }

    @TestMetadata("renamePlus/plus.test")
    public void testRenamePlus_Plus() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renamePlus/plus.test");
        doTest(fileName);
    }

    @TestMetadata("renamePlusAssign/plusAssign.test")
    public void testRenamePlusAssign_PlusAssign() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renamePlusAssign/plusAssign.test");
        doTest(fileName);
    }

    @TestMetadata("renamePropertyInEnumCompanionWithEntryConflict/renameKotlinPropertyInEnumCompanionWithEntryConflict.test")
    public void testRenamePropertyInEnumCompanionWithEntryConflict_RenameKotlinPropertyInEnumCompanionWithEntryConflict() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renamePropertyInEnumCompanionWithEntryConflict/renameKotlinPropertyInEnumCompanionWithEntryConflict.test");
        doTest(fileName);
    }

    @TestMetadata("renameSet/set.test")
    public void testRenameSet_Set() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameSet/set.test");
        doTest(fileName);
    }

    @TestMetadata("renameSynthesizedComponentFunction/synthesizedComponentFunction.test")
    public void testRenameSynthesizedComponentFunction_SynthesizedComponentFunction() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameSynthesizedComponentFunction/synthesizedComponentFunction.test");
        doTest(fileName);
    }

    @TestMetadata("renameUnaryMinus/unaryMinus.test")
    public void testRenameUnaryMinus_UnaryMinus() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/renameUnaryMinus/unaryMinus.test");
        doTest(fileName);
    }

    @TestMetadata("secondaryCnstructorParameterRedeclaration/secondaryConstructorParameterRedeclaration.test")
    public void testSecondaryCnstructorParameterRedeclaration_SecondaryConstructorParameterRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/secondaryCnstructorParameterRedeclaration/secondaryConstructorParameterRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("syntheticPropertyUsages1/renameGetMethod.test")
    public void testSyntheticPropertyUsages1_RenameGetMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/syntheticPropertyUsages1/renameGetMethod.test");
        doTest(fileName);
    }

    @TestMetadata("syntheticPropertyUsages2/renameSetMethod.test")
    public void testSyntheticPropertyUsages2_RenameSetMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/syntheticPropertyUsages2/renameSetMethod.test");
        doTest(fileName);
    }

    @TestMetadata("syntheticPropertyUsages3/renameSetMethod.test")
    public void testSyntheticPropertyUsages3_RenameSetMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/syntheticPropertyUsages3/renameSetMethod.test");
        doTest(fileName);
    }

    @TestMetadata("topLevelClassRedeclaration/topLevelClassRedeclaration.test")
    public void testTopLevelClassRedeclaration_TopLevelClassRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/topLevelClassRedeclaration/topLevelClassRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("topLevelFunctionRedeclaration/topLevelFunctionRedeclaration.test")
    public void testTopLevelFunctionRedeclaration_TopLevelFunctionRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/topLevelFunctionRedeclaration/topLevelFunctionRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("topLevelPropertyRedeclaration/topLevelPropertyRedeclaration.test")
    public void testTopLevelPropertyRedeclaration_TopLevelPropertyRedeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/topLevelPropertyRedeclaration/topLevelPropertyRedeclaration.test");
        doTest(fileName);
    }

    @TestMetadata("varInDoWhile/varInDoWhile.test")
    public void testVarInDoWhile_VarInDoWhile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/rename/varInDoWhile/varInDoWhile.test");
        doTest(fileName);
    }
}
