/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class SafeDeleteTestGenerated extends AbstractSafeDeleteTest {
    @TestMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinClass extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("class1.kt")
        public void testClass1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/class1.kt");
            doClassTest(fileName);
        }

        @TestMetadata("class2.kt")
        public void testClass2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/class2.kt");
            doClassTest(fileName);
        }

        @TestMetadata("classInString.kt")
        public void testClassInString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/classInString.kt");
            doClassTest(fileName);
        }

        @TestMetadata("classWithExternalConstructructorUsage.kt")
        public void testClassWithExternalConstructructorUsage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/classWithExternalConstructructorUsage.kt");
            doClassTest(fileName);
        }

        @TestMetadata("classWithInternalConstructructorUsage.kt")
        public void testClassWithInternalConstructructorUsage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/classWithInternalConstructructorUsage.kt");
            doClassTest(fileName);
        }

        @TestMetadata("enumEntry.kt")
        public void testEnumEntry() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/enumEntry.kt");
            doClassTest(fileName);
        }

        @TestMetadata("localClass1.kt")
        public void testLocalClass1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/localClass1.kt");
            doClassTest(fileName);
        }

        @TestMetadata("localClass2.kt")
        public void testLocalClass2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/localClass2.kt");
            doClassTest(fileName);
        }

        @TestMetadata("nestedClass1.kt")
        public void testNestedClass1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/nestedClass1.kt");
            doClassTest(fileName);
        }

        @TestMetadata("nestedClass2.kt")
        public void testNestedClass2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/nestedClass2.kt");
            doClassTest(fileName);
        }

        @TestMetadata("noUsages.kt")
        public void testNoUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/noUsages.kt");
            doClassTest(fileName);
        }

        @TestMetadata("trait1.kt")
        public void testTrait1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/trait1.kt");
            doClassTest(fileName);
        }

        @TestMetadata("trait2.kt")
        public void testTrait2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/trait2.kt");
            doClassTest(fileName);
        }

        @TestMetadata("unsafeImport.kt")
        public void testUnsafeImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClass/unsafeImport.kt");
            doClassTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClassWithJava")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinClassWithJava extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinClassWithJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteClass/kotlinClassWithJava"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classWithDelegationCalls.kt")
        public void testClassWithDelegationCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/kotlinClassWithJava/classWithDelegationCalls.kt");
            doClassTestWithJava(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteClass/javaClassWithKotlin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JavaClassWithKotlin extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInJavaClassWithKotlin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteClass/javaClassWithKotlin"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("javaInterfaceInSuperTypeList.java")
        public void testJavaInterfaceInSuperTypeList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/javaClassWithKotlin/javaInterfaceInSuperTypeList.java");
            doJavaClassTest(fileName);
        }

        @TestMetadata("javaInterfaceInSuperTypeListLast.java")
        public void testJavaInterfaceInSuperTypeListLast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteClass/javaClassWithKotlin/javaInterfaceInSuperTypeListLast.java");
            doJavaClassTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinObject extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinObject() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObject.kt")
        public void testAnonymousObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/anonymousObject.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("companionObject.kt")
        public void testCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/companionObject.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("localObject1.kt")
        public void testLocalObject1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/localObject1.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("localObject2.kt")
        public void testLocalObject2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/localObject2.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("nestedObject1.kt")
        public void testNestedObject1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/nestedObject1.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("nestedObject2.kt")
        public void testNestedObject2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/nestedObject2.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("noUsages.kt")
        public void testNoUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/noUsages.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("object1.kt")
        public void testObject1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/object1.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("object2.kt")
        public void testObject2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/object2.kt");
            doObjectTest(fileName);
        }

        @TestMetadata("unsafeImport.kt")
        public void testUnsafeImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteObject/kotlinObject/unsafeImport.kt");
            doObjectTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinFunction extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fun1.kt")
        public void testFun1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/fun1.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("fun2.kt")
        public void testFun2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/fun2.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("funExt1.kt")
        public void testFunExt1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/funExt1.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("funExt2.kt")
        public void testFunExt2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/funExt2.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("implement1.kt")
        public void testImplement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/implement1.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("implement2.kt")
        public void testImplement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/implement2.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("localFun1.kt")
        public void testLocalFun1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/localFun1.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("localFun2.kt")
        public void testLocalFun2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/localFun2.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("localFunExt1.kt")
        public void testLocalFunExt1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/localFunExt1.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("localFunExt2.kt")
        public void testLocalFunExt2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/localFunExt2.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("noUsages.kt")
        public void testNoUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/noUsages.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("override1.kt")
        public void testOverride1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/override1.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("override2.kt")
        public void testOverride2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/override2.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("overrideAndImplement1.kt")
        public void testOverrideAndImplement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/overrideAndImplement1.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("overrideAndImplement2.kt")
        public void testOverrideAndImplement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/overrideAndImplement2.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("overrideAndImplement3.kt")
        public void testOverrideAndImplement3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/overrideAndImplement3.kt");
            doFunctionTest(fileName);
        }

        @TestMetadata("overrideWithUsages.kt")
        public void testOverrideWithUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunction/overrideWithUsages.kt");
            doFunctionTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinFunctionWithJava extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinFunctionWithJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("funExt.kt")
        public void testFunExt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/funExt.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("implement1.kt")
        public void testImplement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/implement1.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("implement2.kt")
        public void testImplement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/implement2.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("implement3.kt")
        public void testImplement3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/implement3.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("implement4.kt")
        public void testImplement4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/implement4.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("override1.kt")
        public void testOverride1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/override1.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("override2.kt")
        public void testOverride2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/override2.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("override3.kt")
        public void testOverride3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/override3.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("overrideAndImplement1.kt")
        public void testOverrideAndImplement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/overrideAndImplement1.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("overrideAndImplement2.kt")
        public void testOverrideAndImplement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/overrideAndImplement2.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/secondaryConstructor.kt");
            doFunctionTestWithJava(fileName);
        }

        @TestMetadata("usageInOverrideToDelete.kt")
        public void testUsageInOverrideToDelete() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/kotlinFunctionWithJava/usageInOverrideToDelete.kt");
            doFunctionTestWithJava(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteFunction/javaFunctionWithKotlin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JavaFunctionWithKotlin extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInJavaFunctionWithKotlin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteFunction/javaFunctionWithKotlin"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("mixedHierarchy1.kt")
        public void testMixedHierarchy1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/javaFunctionWithKotlin/mixedHierarchy1.kt");
            doJavaMethodTest(fileName);
        }

        @TestMetadata("mixedHierarchy2.kt")
        public void testMixedHierarchy2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteFunction/javaFunctionWithKotlin/mixedHierarchy2.kt");
            doJavaMethodTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinProperty extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("implement1.kt")
        public void testImplement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/implement1.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("implement2.kt")
        public void testImplement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/implement2.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("implement3.kt")
        public void testImplement3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/implement3.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("implement4.kt")
        public void testImplement4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/implement4.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("implement5.kt")
        public void testImplement5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/implement5.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("implement6.kt")
        public void testImplement6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/implement6.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("implement7.kt")
        public void testImplement7() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/implement7.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("implement8.kt")
        public void testImplement8() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/implement8.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("noUsages.kt")
        public void testNoUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/noUsages.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("override1.kt")
        public void testOverride1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/override1.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("override2.kt")
        public void testOverride2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/override2.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("override3.kt")
        public void testOverride3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/override3.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("override4.kt")
        public void testOverride4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/override4.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("overrideAndImplement1.kt")
        public void testOverrideAndImplement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/overrideAndImplement1.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("overrideAndImplement2.kt")
        public void testOverrideAndImplement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/overrideAndImplement2.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("overrideAndImplement3.kt")
        public void testOverrideAndImplement3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/overrideAndImplement3.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("overrideAndImplement4.kt")
        public void testOverrideAndImplement4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/overrideAndImplement4.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("overrideWithUsages.kt")
        public void testOverrideWithUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/overrideWithUsages.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("property1.kt")
        public void testProperty1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/property1.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("property2.kt")
        public void testProperty2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/property2.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("propertyExt1.kt")
        public void testPropertyExt1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/propertyExt1.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("propertyExt2.kt")
        public void testPropertyExt2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/propertyExt2.kt");
            doPropertyTest(fileName);
        }

        @TestMetadata("propertyInLocalObject.kt")
        public void testPropertyInLocalObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinProperty/propertyInLocalObject.kt");
            doPropertyTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinPropertyWithJava extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinPropertyWithJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("implement1.kt")
        public void testImplement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/implement1.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("implement2.kt")
        public void testImplement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/implement2.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("implement3.kt")
        public void testImplement3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/implement3.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("implement4.kt")
        public void testImplement4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/implement4.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("override1.kt")
        public void testOverride1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/override1.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("override2.kt")
        public void testOverride2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/override2.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("override3.kt")
        public void testOverride3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/override3.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("override4.kt")
        public void testOverride4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/override4.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("overrideAndImplement1.kt")
        public void testOverrideAndImplement1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/overrideAndImplement1.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("overrideAndImplement2.kt")
        public void testOverrideAndImplement2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/overrideAndImplement2.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("propertyExt.kt")
        public void testPropertyExt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/propertyExt.kt");
            doPropertyTestWithJava(fileName);
        }

        @TestMetadata("usageInOverrideToDelete.kt")
        public void testUsageInOverrideToDelete() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/kotlinPropertyWithJava/usageInOverrideToDelete.kt");
            doPropertyTestWithJava(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteProperty/javaPropertyWithKotlin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JavaPropertyWithKotlin extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInJavaPropertyWithKotlin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteProperty/javaPropertyWithKotlin"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("middleJava1.kt")
        public void testMiddleJava1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/javaPropertyWithKotlin/middleJava1.kt");
            doJavaPropertyTest(fileName);
        }

        @TestMetadata("middleJava2.kt")
        public void testMiddleJava2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/javaPropertyWithKotlin/middleJava2.kt");
            doJavaPropertyTest(fileName);
        }

        @TestMetadata("middleJava3.kt")
        public void testMiddleJava3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/javaPropertyWithKotlin/middleJava3.kt");
            doJavaPropertyTest(fileName);
        }

        @TestMetadata("middleJava4.kt")
        public void testMiddleJava4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/javaPropertyWithKotlin/middleJava4.kt");
            doJavaPropertyTest(fileName);
        }

        @TestMetadata("middleJava5.kt")
        public void testMiddleJava5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/javaPropertyWithKotlin/middleJava5.kt");
            doJavaPropertyTest(fileName);
        }

        @TestMetadata("middleJava6.kt")
        public void testMiddleJava6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteProperty/javaPropertyWithKotlin/middleJava6.kt");
            doJavaPropertyTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinTypeParameter extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinTypeParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("internalUsages1.kt")
        public void testInternalUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/internalUsages1.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("internalUsages2.kt")
        public void testInternalUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/internalUsages2.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("internalUsages3.kt")
        public void testInternalUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/internalUsages3.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("internalUsages4.kt")
        public void testInternalUsages4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/internalUsages4.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("internalUsages5.kt")
        public void testInternalUsages5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/internalUsages5.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("safeUsagesWithConstraint1.kt")
        public void testSafeUsagesWithConstraint1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/safeUsagesWithConstraint1.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("safeUsagesWithConstraint2.kt")
        public void testSafeUsagesWithConstraint2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/safeUsagesWithConstraint2.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subclass1.kt")
        public void testSubclass1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subclass1.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subclass2.kt")
        public void testSubclass2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subclass2.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subst1.kt")
        public void testSubst1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subst1.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subst2.kt")
        public void testSubst2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subst2.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subst3.kt")
        public void testSubst3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subst3.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subst4.kt")
        public void testSubst4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subst4.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subst5.kt")
        public void testSubst5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subst5.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subst6.kt")
        public void testSubst6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subst6.kt");
            doTypeParameterTest(fileName);
        }

        @TestMetadata("subst7.kt")
        public void testSubst7() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameter/subst7.kt");
            doTypeParameterTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinTypeParameterWithJava extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinTypeParameterWithJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("internalUsages1.kt")
        public void testInternalUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/internalUsages1.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("internalUsages2.kt")
        public void testInternalUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/internalUsages2.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("internalUsages3.kt")
        public void testInternalUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/internalUsages3.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("internalUsages4.kt")
        public void testInternalUsages4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/internalUsages4.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("internalUsages5.kt")
        public void testInternalUsages5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/internalUsages5.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("rawType.kt")
        public void testRawType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/rawType.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("safeUsagesWithConstraint1.kt")
        public void testSafeUsagesWithConstraint1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/safeUsagesWithConstraint1.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("safeUsagesWithConstraint2.kt")
        public void testSafeUsagesWithConstraint2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/safeUsagesWithConstraint2.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subclass1.kt")
        public void testSubclass1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subclass1.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subclass2.kt")
        public void testSubclass2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subclass2.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subst1.kt")
        public void testSubst1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subst1.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subst2.kt")
        public void testSubst2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subst2.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subst3.kt")
        public void testSubst3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subst3.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subst4.kt")
        public void testSubst4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subst4.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subst5.kt")
        public void testSubst5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subst5.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subst6.kt")
        public void testSubst6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subst6.kt");
            doTypeParameterTestWithJava(fileName);
        }

        @TestMetadata("subst7.kt")
        public void testSubst7() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteTypeParameter/kotlinTypeParameterWithJava/subst7.kt");
            doTypeParameterTestWithJava(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinValueParameter extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinValueParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dataClassComponent.kt")
        public void testDataClassComponent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/dataClassComponent.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("defaultParam1.kt")
        public void testDefaultParam1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/defaultParam1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("defaultParam2.kt")
        public void testDefaultParam2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/defaultParam2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("extNamedParam1.kt")
        public void testExtNamedParam1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/extNamedParam1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("extNamedParam2.kt")
        public void testExtNamedParam2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/extNamedParam2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages1.kt")
        public void testHierarchyWithSafeUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithSafeUsages1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages2.kt")
        public void testHierarchyWithSafeUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithSafeUsages2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages3.kt")
        public void testHierarchyWithSafeUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithSafeUsages3.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages4.kt")
        public void testHierarchyWithSafeUsages4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithSafeUsages4.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages5.kt")
        public void testHierarchyWithSafeUsages5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithSafeUsages5.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages1.kt")
        public void testHierarchyWithUnsafeUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithUnsafeUsages1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages2.kt")
        public void testHierarchyWithUnsafeUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithUnsafeUsages2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages3.kt")
        public void testHierarchyWithUnsafeUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithUnsafeUsages3.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages4.kt")
        public void testHierarchyWithUnsafeUsages4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithUnsafeUsages4.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages5.kt")
        public void testHierarchyWithUnsafeUsages5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithUnsafeUsages5.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages6.kt")
        public void testHierarchyWithUnsafeUsages6() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithUnsafeUsages6.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages7.kt")
        public void testHierarchyWithUnsafeUsages7() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithUnsafeUsages7.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages8.kt")
        public void testHierarchyWithUnsafeUsages8() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/hierarchyWithUnsafeUsages8.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("internalUsage1.kt")
        public void testInternalUsage1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/internalUsage1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("internalUsage2.kt")
        public void testInternalUsage2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/internalUsage2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("lambdaArg.kt")
        public void testLambdaArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/lambdaArg.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("lambdaArgExt.kt")
        public void testLambdaArgExt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/lambdaArgExt.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("namedParam1.kt")
        public void testNamedParam1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/namedParam1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("namedParam2.kt")
        public void testNamedParam2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/namedParam2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("propertyParam1.kt")
        public void testPropertyParam1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/propertyParam1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("propertyParam2.kt")
        public void testPropertyParam2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/propertyParam2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("safeUsages1.kt")
        public void testSafeUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/safeUsages1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("safeUsages2.kt")
        public void testSafeUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/safeUsages2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("safeUsages3.kt")
        public void testSafeUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/safeUsages3.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("safeUsagesExt1.kt")
        public void testSafeUsagesExt1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/safeUsagesExt1.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("safeUsagesExt2.kt")
        public void testSafeUsagesExt2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/safeUsagesExt2.kt");
            doValueParameterTest(fileName);
        }

        @TestMetadata("setter.kt")
        public void testSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameter/setter.kt");
            doValueParameterTest(fileName);
        }
    }

    @TestMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinValueParameterWithJava extends AbstractSafeDeleteTest {
        public void testAllFilesPresentInKotlinValueParameterWithJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dataClassComponent.kt")
        public void testDataClassComponent() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/dataClassComponent.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages1.kt")
        public void testHierarchyWithSafeUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithSafeUsages1.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages2.kt")
        public void testHierarchyWithSafeUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithSafeUsages2.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages3.kt")
        public void testHierarchyWithSafeUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithSafeUsages3.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages4.kt")
        public void testHierarchyWithSafeUsages4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithSafeUsages4.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithSafeUsages5.kt")
        public void testHierarchyWithSafeUsages5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithSafeUsages5.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages1.kt")
        public void testHierarchyWithUnsafeUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithUnsafeUsages1.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages2.kt")
        public void testHierarchyWithUnsafeUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithUnsafeUsages2.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages3.kt")
        public void testHierarchyWithUnsafeUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithUnsafeUsages3.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages4.kt")
        public void testHierarchyWithUnsafeUsages4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithUnsafeUsages4.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("hierarchyWithUnsafeUsages5.kt")
        public void testHierarchyWithUnsafeUsages5() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/hierarchyWithUnsafeUsages5.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("internalUsage1.kt")
        public void testInternalUsage1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/internalUsage1.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("internalUsage2.kt")
        public void testInternalUsage2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/internalUsage2.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("lambdaArg.kt")
        public void testLambdaArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/lambdaArg.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("lambdaArgExt.kt")
        public void testLambdaArgExt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/lambdaArgExt.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("mixedHierarchy1.kt")
        public void testMixedHierarchy1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/mixedHierarchy1.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("mixedHierarchy2.kt")
        public void testMixedHierarchy2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/mixedHierarchy2.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("mixedHierarchy3.kt")
        public void testMixedHierarchy3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/mixedHierarchy3.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("mixedHierarchyWithUnsafeUsages1.kt")
        public void testMixedHierarchyWithUnsafeUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/mixedHierarchyWithUnsafeUsages1.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("mixedHierarchyWithUnsafeUsages2.kt")
        public void testMixedHierarchyWithUnsafeUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/mixedHierarchyWithUnsafeUsages2.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("mixedHierarchyWithUnsafeUsages3.kt")
        public void testMixedHierarchyWithUnsafeUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/mixedHierarchyWithUnsafeUsages3.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("propertyParam1.kt")
        public void testPropertyParam1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/propertyParam1.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("propertyParam2.kt")
        public void testPropertyParam2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/propertyParam2.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("safeUsages1.kt")
        public void testSafeUsages1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/safeUsages1.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("safeUsages2.kt")
        public void testSafeUsages2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/safeUsages2.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("safeUsages3.kt")
        public void testSafeUsages3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/safeUsages3.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("safeUsagesExt1.kt")
        public void testSafeUsagesExt1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/safeUsagesExt1.kt");
            doValueParameterTestWithJava(fileName);
        }

        @TestMetadata("safeUsagesExt2.kt")
        public void testSafeUsagesExt2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("idea/testData/refactoring/safeDelete/deleteValueParameter/kotlinValueParameterWithJava/safeUsagesExt2.kt");
            doValueParameterTestWithJava(fileName);
        }
    }
}
