/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.repl;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/repl/completion")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IdeReplCompletionTestGenerated extends AbstractIdeReplCompletionTest {
    public void testAllFilesPresentInCompletion() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/repl/completion"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("builtInMember.kt")
    public void testBuiltInMember() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/repl/completion/builtInMember.kt");
        doTest(fileName);
    }

    @TestMetadata("definedClass.kt")
    public void testDefinedClass() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/repl/completion/definedClass.kt");
        doTest(fileName);
    }

    @TestMetadata("definedClassMember.kt")
    public void testDefinedClassMember() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/repl/completion/definedClassMember.kt");
        doTest(fileName);
    }

    @TestMetadata("definedExtension.kt")
    public void testDefinedExtension() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/repl/completion/definedExtension.kt");
        doTest(fileName);
    }

    @TestMetadata("functions.kt")
    public void testFunctions() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/repl/completion/functions.kt");
        doTest(fileName);
    }

    @TestMetadata("stdlib.kt")
    public void testStdlib() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/repl/completion/stdlib.kt");
        doTest(fileName);
    }

    @TestMetadata("variables.kt")
    public void testVariables() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/repl/completion/variables.kt");
        doTest(fileName);
    }
}
