/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.resolve;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/resolve/additionalLazyResolve")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AdditionalResolveDescriptorRendererTestGenerated extends AbstractAdditionalResolveDescriptorRendererTest {
    public void testAllFilesPresentInAdditionalLazyResolve() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/resolve/additionalLazyResolve"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("anonymousObjectInClassInitializer.kt")
    public void testAnonymousObjectInClassInitializer() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/additionalLazyResolve/anonymousObjectInClassInitializer.kt");
        doTest(fileName);
    }

    @TestMetadata("anonymousObjectInClassParameterInitializer.kt")
    public void testAnonymousObjectInClassParameterInitializer() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/additionalLazyResolve/anonymousObjectInClassParameterInitializer.kt");
        doTest(fileName);
    }

    @TestMetadata("localClassInClassInitializer.kt")
    public void testLocalClassInClassInitializer() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/additionalLazyResolve/localClassInClassInitializer.kt");
        doTest(fileName);
    }

    @TestMetadata("localClassInClosureInClassParameterInitializer.kt")
    public void testLocalClassInClosureInClassParameterInitializer() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/additionalLazyResolve/localClassInClosureInClassParameterInitializer.kt");
        doTest(fileName);
    }

    @TestMetadata("localObjectInClassInitializer.kt")
    public void testLocalObjectInClassInitializer() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/additionalLazyResolve/localObjectInClassInitializer.kt");
        doTest(fileName);
    }

    @TestMetadata("localObjectInClosureInClassParameterInitializer.kt")
    public void testLocalObjectInClosureInClassParameterInitializer() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/additionalLazyResolve/localObjectInClosureInClassParameterInitializer.kt");
        doTest(fileName);
    }
}
