/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.resolve;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/resolve/referenceWithLib")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class ReferenceResolveWithLibTestGenerated extends AbstractReferenceResolveWithLibTest {
    public void testAllFilesPresentInReferenceWithLib() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/resolve/referenceWithLib"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, false);
    }

    @TestMetadata("delegatedPropertyWithTypeParameters.kt")
    public void testDelegatedPropertyWithTypeParameters() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/delegatedPropertyWithTypeParameters.kt");
        doTest(fileName);
    }

    @TestMetadata("fakeOverride.kt")
    public void testFakeOverride() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/fakeOverride.kt");
        doTest(fileName);
    }

    @TestMetadata("fakeOverride2.kt")
    public void testFakeOverride2() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/fakeOverride2.kt");
        doTest(fileName);
    }

    @TestMetadata("innerClassFromLib.kt")
    public void testInnerClassFromLib() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/innerClassFromLib.kt");
        doTest(fileName);
    }

    @TestMetadata("iteratorWithTypeParameter.kt")
    public void testIteratorWithTypeParameter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/iteratorWithTypeParameter.kt");
        doTest(fileName);
    }

    @TestMetadata("multiDeclarationWithTypeParameters.kt")
    public void testMultiDeclarationWithTypeParameters() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/multiDeclarationWithTypeParameters.kt");
        doTest(fileName);
    }

    @TestMetadata("nestedClassFromLib.kt")
    public void testNestedClassFromLib() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/nestedClassFromLib.kt");
        doTest(fileName);
    }

    @TestMetadata("overridingFunctionWithSamAdapter.kt")
    public void testOverridingFunctionWithSamAdapter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/overridingFunctionWithSamAdapter.kt");
        doTest(fileName);
    }

    @TestMetadata("packageOfLibDeclaration.kt")
    public void testPackageOfLibDeclaration() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/packageOfLibDeclaration.kt");
        doTest(fileName);
    }

    @TestMetadata("referenceToRootJavaClassFromLib.kt")
    public void testReferenceToRootJavaClassFromLib() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/referenceToRootJavaClassFromLib.kt");
        doTest(fileName);
    }

    @TestMetadata("sameNameInLib.kt")
    public void testSameNameInLib() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/sameNameInLib.kt");
        doTest(fileName);
    }

    @TestMetadata("setWithTypeParameters.kt")
    public void testSetWithTypeParameters() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("idea/testData/resolve/referenceWithLib/setWithTypeParameters.kt");
        doTest(fileName);
    }
}
