/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.jps.build;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class ExperimentalIncrementalJpsTestGenerated extends AbstractExperimentalIncrementalJpsTest {
    @TestMetadata("jps-plugin/testData/incremental/multiModule")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiModule extends AbstractExperimentalIncrementalJpsTest {
        public void testAllFilesPresentInMultiModule() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/multiModule"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("circularDependencyClasses")
        public void testCircularDependencyClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/circularDependencyClasses/");
            doTest(fileName);
        }

        @TestMetadata("circularDependencySamePackageUnchanged")
        public void testCircularDependencySamePackageUnchanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/circularDependencySamePackageUnchanged/");
            doTest(fileName);
        }

        @TestMetadata("circularDependencyTopLevelFunctions")
        public void testCircularDependencyTopLevelFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/circularDependencyTopLevelFunctions/");
            doTest(fileName);
        }

        @TestMetadata("circularDependencyWithAccessToInternal")
        public void testCircularDependencyWithAccessToInternal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/circularDependencyWithAccessToInternal/");
            doTest(fileName);
        }

        @TestMetadata("classAdded")
        public void testClassAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/classAdded/");
            doTest(fileName);
        }

        @TestMetadata("classRemoved")
        public void testClassRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/classRemoved/");
            doTest(fileName);
        }

        @TestMetadata("constantValueChanged")
        public void testConstantValueChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/constantValueChanged/");
            doTest(fileName);
        }

        @TestMetadata("copyFileToAnotherModule")
        public void testCopyFileToAnotherModule() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/copyFileToAnotherModule/");
            doTest(fileName);
        }

        @TestMetadata("defaultParameterAdded")
        public void testDefaultParameterAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/defaultParameterAdded/");
            doTest(fileName);
        }

        @TestMetadata("defaultParameterAddedForTopLevelFun")
        public void testDefaultParameterAddedForTopLevelFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/defaultParameterAddedForTopLevelFun/");
            doTest(fileName);
        }

        @TestMetadata("defaultParameterRemoved")
        public void testDefaultParameterRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/defaultParameterRemoved/");
            doTest(fileName);
        }

        @TestMetadata("defaultParameterRemovedForTopLevelFun")
        public void testDefaultParameterRemovedForTopLevelFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/defaultParameterRemovedForTopLevelFun/");
            doTest(fileName);
        }

        @TestMetadata("inlineFunctionInlined")
        public void testInlineFunctionInlined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/inlineFunctionInlined/");
            doTest(fileName);
        }

        @TestMetadata("inlineFunctionTwoPackageParts")
        public void testInlineFunctionTwoPackageParts() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/inlineFunctionTwoPackageParts/");
            doTest(fileName);
        }

        @TestMetadata("moveFileToAnotherModule")
        public void testMoveFileToAnotherModule() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/moveFileToAnotherModule/");
            doTest(fileName);
        }

        @TestMetadata("simpleDependency")
        public void testSimpleDependency() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/simpleDependency/");
            doTest(fileName);
        }

        @TestMetadata("simpleDependencyErrorOnAccessToInternal1")
        public void testSimpleDependencyErrorOnAccessToInternal1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/simpleDependencyErrorOnAccessToInternal1/");
            doTest(fileName);
        }

        @TestMetadata("simpleDependencyErrorOnAccessToInternal2")
        public void testSimpleDependencyErrorOnAccessToInternal2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/simpleDependencyErrorOnAccessToInternal2/");
            doTest(fileName);
        }

        @TestMetadata("simpleDependencyUnchanged")
        public void testSimpleDependencyUnchanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/simpleDependencyUnchanged/");
            doTest(fileName);
        }

        @TestMetadata("transitiveDependency")
        public void testTransitiveDependency() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/transitiveDependency/");
            doTest(fileName);
        }

        @TestMetadata("transitiveInlining")
        public void testTransitiveInlining() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/transitiveInlining/");
            doTest(fileName);
        }

        @TestMetadata("twoDependants")
        public void testTwoDependants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/multiModule/twoDependants/");
            doTest(fileName);
        }

    }

    @TestMetadata("jps-plugin/testData/incremental/pureKotlin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PureKotlin extends AbstractExperimentalIncrementalJpsTest {
        @TestMetadata("accessingFunctionsViaPackagePart")
        public void testAccessingFunctionsViaPackagePart() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/accessingFunctionsViaPackagePart/");
            doTest(fileName);
        }

        @TestMetadata("accessingFunctionsViaRenamedFileClass")
        public void testAccessingFunctionsViaRenamedFileClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/accessingFunctionsViaRenamedFileClass/");
            doTest(fileName);
        }

        @TestMetadata("accessingPropertiesViaField")
        public void testAccessingPropertiesViaField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/accessingPropertiesViaField/");
            doTest(fileName);
        }

        @TestMetadata("addClass")
        public void testAddClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/addClass/");
            doTest(fileName);
        }

        @TestMetadata("addFileWithFunctionOverload")
        public void testAddFileWithFunctionOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/addFileWithFunctionOverload/");
            doTest(fileName);
        }

        @TestMetadata("addMemberTypeAlias")
        public void testAddMemberTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/addMemberTypeAlias/");
            doTest(fileName);
        }

        @TestMetadata("addTopLevelTypeAlias")
        public void testAddTopLevelTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/addTopLevelTypeAlias/");
            doTest(fileName);
        }

        @TestMetadata("allConstants")
        public void testAllConstants() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/allConstants/");
            doTest(fileName);
        }

        public void testAllFilesPresentInPureKotlin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/pureKotlin"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
        }

        @TestMetadata("annotations")
        public void testAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/annotations/");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectChanged")
        public void testAnonymousObjectChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/anonymousObjectChanged/");
            doTest(fileName);
        }

        @TestMetadata("changeTypeImplicitlyWithCircularDependency")
        public void testChangeTypeImplicitlyWithCircularDependency() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/changeTypeImplicitlyWithCircularDependency/");
            doTest(fileName);
        }

        @TestMetadata("changeWithRemovingUsage")
        public void testChangeWithRemovingUsage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/changeWithRemovingUsage/");
            doTest(fileName);
        }

        @TestMetadata("classInlineFunctionChanged")
        public void testClassInlineFunctionChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/classInlineFunctionChanged/");
            doTest(fileName);
        }

        @TestMetadata("classObjectConstantChanged")
        public void testClassObjectConstantChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/classObjectConstantChanged/");
            doTest(fileName);
        }

        @TestMetadata("classRecreated")
        public void testClassRecreated() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/classRecreated/");
            doTest(fileName);
        }

        @TestMetadata("classRedeclaration")
        public void testClassRedeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/classRedeclaration/");
            doTest(fileName);
        }

        @TestMetadata("classSignatureChanged")
        public void testClassSignatureChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/classSignatureChanged/");
            doTest(fileName);
        }

        @TestMetadata("classSignatureUnchanged")
        public void testClassSignatureUnchanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/classSignatureUnchanged/");
            doTest(fileName);
        }

        @TestMetadata("compilationErrorThenFixedOtherPackage")
        public void testCompilationErrorThenFixedOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedOtherPackage/");
            doTest(fileName);
        }

        @TestMetadata("compilationErrorThenFixedSamePackage")
        public void testCompilationErrorThenFixedSamePackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedSamePackage/");
            doTest(fileName);
        }

        @TestMetadata("compilationErrorThenFixedWithPhantomPart")
        public void testCompilationErrorThenFixedWithPhantomPart() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedWithPhantomPart/");
            doTest(fileName);
        }

        @TestMetadata("compilationErrorThenFixedWithPhantomPart2")
        public void testCompilationErrorThenFixedWithPhantomPart2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedWithPhantomPart2/");
            doTest(fileName);
        }

        @TestMetadata("compilationErrorThenFixedWithPhantomPart3")
        public void testCompilationErrorThenFixedWithPhantomPart3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/compilationErrorThenFixedWithPhantomPart3/");
            doTest(fileName);
        }

        @TestMetadata("conflictingPlatformDeclarations")
        public void testConflictingPlatformDeclarations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/conflictingPlatformDeclarations/");
            doTest(fileName);
        }

        @TestMetadata("constantRemoved")
        public void testConstantRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/constantRemoved/");
            doTest(fileName);
        }

        @TestMetadata("constantsUnchanged")
        public void testConstantsUnchanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/constantsUnchanged/");
            doTest(fileName);
        }

        @TestMetadata("defaultArgumentInConstructorAdded")
        public void testDefaultArgumentInConstructorAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultArgumentInConstructorAdded/");
            doTest(fileName);
        }

        @TestMetadata("defaultArgumentInConstructorRemoved")
        public void testDefaultArgumentInConstructorRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultArgumentInConstructorRemoved/");
            doTest(fileName);
        }

        @TestMetadata("defaultValueAdded")
        public void testDefaultValueAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultValueAdded/");
            doTest(fileName);
        }

        @TestMetadata("defaultValueChanged")
        public void testDefaultValueChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultValueChanged/");
            doTest(fileName);
        }

        @TestMetadata("defaultValueInConstructorAdded")
        public void testDefaultValueInConstructorAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultValueInConstructorAdded/");
            doTest(fileName);
        }

        @TestMetadata("defaultValueInConstructorChanged")
        public void testDefaultValueInConstructorChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultValueInConstructorChanged/");
            doTest(fileName);
        }

        @TestMetadata("defaultValueInConstructorRemoved")
        public void testDefaultValueInConstructorRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultValueInConstructorRemoved/");
            doTest(fileName);
        }

        @TestMetadata("defaultValueRemoved1")
        public void testDefaultValueRemoved1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultValueRemoved1/");
            doTest(fileName);
        }

        @TestMetadata("defaultValueRemoved2")
        public void testDefaultValueRemoved2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/defaultValueRemoved2/");
            doTest(fileName);
        }

        @TestMetadata("delegatedPropertyInlineExtensionAccessor")
        public void testDelegatedPropertyInlineExtensionAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/delegatedPropertyInlineExtensionAccessor/");
            doTest(fileName);
        }

        @TestMetadata("delegatedPropertyInlineMethodAccessor")
        public void testDelegatedPropertyInlineMethodAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/delegatedPropertyInlineMethodAccessor/");
            doTest(fileName);
        }

        @TestMetadata("dependencyClassReferenced")
        public void testDependencyClassReferenced() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/dependencyClassReferenced/");
            doTest(fileName);
        }

        @TestMetadata("fileWithConstantRemoved")
        public void testFileWithConstantRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/fileWithConstantRemoved/");
            doTest(fileName);
        }

        @TestMetadata("fileWithInlineFunctionRemoved")
        public void testFileWithInlineFunctionRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/fileWithInlineFunctionRemoved/");
            doTest(fileName);
        }

        @TestMetadata("filesExchangePackages")
        public void testFilesExchangePackages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/filesExchangePackages/");
            doTest(fileName);
        }

        @TestMetadata("funRedeclaration")
        public void testFunRedeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/funRedeclaration/");
            doTest(fileName);
        }

        @TestMetadata("funVsConstructorOverloadConflict")
        public void testFunVsConstructorOverloadConflict() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/funVsConstructorOverloadConflict/");
            doTest(fileName);
        }

        @TestMetadata("functionBecameInline")
        public void testFunctionBecameInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/functionBecameInline/");
            doTest(fileName);
        }

        @TestMetadata("independentClasses")
        public void testIndependentClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/independentClasses/");
            doTest(fileName);
        }

        @TestMetadata("inlinFunctionUsageAdded")
        public void testInlinFunctionUsageAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlinFunctionUsageAdded/");
            doTest(fileName);
        }

        @TestMetadata("inlineClassValProperty")
        public void testInlineClassValProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineClassValProperty/");
            doTest(fileName);
        }

        @TestMetadata("inlineClassVarProperty")
        public void testInlineClassVarProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineClassVarProperty/");
            doTest(fileName);
        }

        @TestMetadata("inlineFunctionRemoved")
        public void testInlineFunctionRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineFunctionRemoved/");
            doTest(fileName);
        }

        @TestMetadata("inlineFunctionsCircularDependency")
        public void testInlineFunctionsCircularDependency() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineFunctionsCircularDependency/");
            doTest(fileName);
        }

        @TestMetadata("inlineFunctionsUnchanged")
        public void testInlineFunctionsUnchanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineFunctionsUnchanged/");
            doTest(fileName);
        }

        @TestMetadata("inlineLinesChanged")
        public void testInlineLinesChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineLinesChanged/");
            doTest(fileName);
        }

        @TestMetadata("inlineModifiedWithUsage")
        public void testInlineModifiedWithUsage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineModifiedWithUsage/");
            doTest(fileName);
        }

        @TestMetadata("inlinePrivateFunctionAdded")
        public void testInlinePrivateFunctionAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlinePrivateFunctionAdded/");
            doTest(fileName);
        }

        @TestMetadata("inlineTopLevelFunctionWithJvmName")
        public void testInlineTopLevelFunctionWithJvmName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineTopLevelFunctionWithJvmName/");
            doTest(fileName);
        }

        @TestMetadata("inlineTopLevelValProperty")
        public void testInlineTopLevelValProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineTopLevelValProperty/");
            doTest(fileName);
        }

        @TestMetadata("inlineTopLevelValPropertyWithJvmName")
        public void testInlineTopLevelValPropertyWithJvmName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineTopLevelValPropertyWithJvmName/");
            doTest(fileName);
        }

        @TestMetadata("inlineTopLevelVarProperty")
        public void testInlineTopLevelVarProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineTopLevelVarProperty/");
            doTest(fileName);
        }

        @TestMetadata("inlineTwoFunctionsOneChanged")
        public void testInlineTwoFunctionsOneChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineTwoFunctionsOneChanged/");
            doTest(fileName);
        }

        @TestMetadata("inlineUsedWhereDeclared")
        public void testInlineUsedWhereDeclared() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/inlineUsedWhereDeclared/");
            doTest(fileName);
        }

        @TestMetadata("internalClassChanged")
        public void testInternalClassChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/internalClassChanged/");
            doTest(fileName);
        }

        @TestMetadata("internalMemberInClassChanged")
        public void testInternalMemberInClassChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/internalMemberInClassChanged/");
            doTest(fileName);
        }

        @TestMetadata("localClassChanged")
        public void testLocalClassChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/localClassChanged/");
            doTest(fileName);
        }

        @TestMetadata("mainRedeclaration")
        public void testMainRedeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/mainRedeclaration/");
            doTest(fileName);
        }

        @TestMetadata("moveClass")
        public void testMoveClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/moveClass/");
            doTest(fileName);
        }

        @TestMetadata("moveFileWithChangingPackage")
        public void testMoveFileWithChangingPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/moveFileWithChangingPackage/");
            doTest(fileName);
        }

        @TestMetadata("moveFileWithoutChangingPackage")
        public void testMoveFileWithoutChangingPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/moveFileWithoutChangingPackage/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassAddTopLevelFunWithDefault")
        public void testMultifileClassAddTopLevelFunWithDefault() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassAddTopLevelFunWithDefault/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassFileAdded")
        public void testMultifileClassFileAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassFileAdded/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassFileChanged")
        public void testMultifileClassFileChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassFileChanged/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassFileMovedToAnotherMultifileClass")
        public void testMultifileClassFileMovedToAnotherMultifileClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassFileMovedToAnotherMultifileClass/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassInlineFunction")
        public void testMultifileClassInlineFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassInlineFunction/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassInlineFunctionAccessingField")
        public void testMultifileClassInlineFunctionAccessingField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassInlineFunctionAccessingField/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassRecreated")
        public void testMultifileClassRecreated() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassRecreated/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassRecreatedAfterRenaming")
        public void testMultifileClassRecreatedAfterRenaming() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassRecreatedAfterRenaming/");
            doTest(fileName);
        }

        @TestMetadata("multifileClassRemoved")
        public void testMultifileClassRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multifileClassRemoved/");
            doTest(fileName);
        }

        @TestMetadata("multiplePackagesModified")
        public void testMultiplePackagesModified() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/multiplePackagesModified/");
            doTest(fileName);
        }

        @TestMetadata("objectConstantChanged")
        public void testObjectConstantChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/objectConstantChanged/");
            doTest(fileName);
        }

        @TestMetadata("optionalParameter")
        public void testOptionalParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/optionalParameter/");
            doTest(fileName);
        }

        @TestMetadata("ourClassReferenced")
        public void testOurClassReferenced() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/ourClassReferenced/");
            doTest(fileName);
        }

        @TestMetadata("packageConstantChanged")
        public void testPackageConstantChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageConstantChanged/");
            doTest(fileName);
        }

        @TestMetadata("packageFileAdded")
        public void testPackageFileAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageFileAdded/");
            doTest(fileName);
        }

        @TestMetadata("packageFileChangedPackage")
        public void testPackageFileChangedPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageFileChangedPackage/");
            doTest(fileName);
        }

        @TestMetadata("packageFileChangedThenOtherRemoved")
        public void testPackageFileChangedThenOtherRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageFileChangedThenOtherRemoved/");
            doTest(fileName);
        }

        @TestMetadata("packageFileRemoved")
        public void testPackageFileRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageFileRemoved/");
            doTest(fileName);
        }

        @TestMetadata("packageFilesChangedInTurn")
        public void testPackageFilesChangedInTurn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageFilesChangedInTurn/");
            doTest(fileName);
        }

        @TestMetadata("packageInlineFunctionAccessingField")
        public void testPackageInlineFunctionAccessingField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageInlineFunctionAccessingField/");
            doTest(fileName);
        }

        @TestMetadata("packageInlineFunctionFromOurPackage")
        public void testPackageInlineFunctionFromOurPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageInlineFunctionFromOurPackage/");
            doTest(fileName);
        }

        @TestMetadata("packageMultifileClassOneFileWithPublicChanges")
        public void testPackageMultifileClassOneFileWithPublicChanges() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageMultifileClassOneFileWithPublicChanges/");
            doTest(fileName);
        }

        @TestMetadata("packageMultifileClassPrivateOnlyChanged")
        public void testPackageMultifileClassPrivateOnlyChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageMultifileClassPrivateOnlyChanged/");
            doTest(fileName);
        }

        @TestMetadata("packagePrivateOnlyChanged")
        public void testPackagePrivateOnlyChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packagePrivateOnlyChanged/");
            doTest(fileName);
        }

        @TestMetadata("packageRecreated")
        public void testPackageRecreated() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageRecreated/");
            doTest(fileName);
        }

        @TestMetadata("packageRecreatedAfterRenaming")
        public void testPackageRecreatedAfterRenaming() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageRecreatedAfterRenaming/");
            doTest(fileName);
        }

        @TestMetadata("packageRemoved")
        public void testPackageRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/packageRemoved/");
            doTest(fileName);
        }

        @TestMetadata("privateConstantsChanged")
        public void testPrivateConstantsChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateConstantsChanged/");
            doTest(fileName);
        }

        @TestMetadata("privateMethodAdded")
        public void testPrivateMethodAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateMethodAdded/");
            doTest(fileName);
        }

        @TestMetadata("privateMethodDeleted")
        public void testPrivateMethodDeleted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateMethodDeleted/");
            doTest(fileName);
        }

        @TestMetadata("privateMethodSignatureChanged")
        public void testPrivateMethodSignatureChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateMethodSignatureChanged/");
            doTest(fileName);
        }

        @TestMetadata("privateSecondaryConstructorAdded")
        public void testPrivateSecondaryConstructorAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateSecondaryConstructorAdded/");
            doTest(fileName);
        }

        @TestMetadata("privateSecondaryConstructorDeleted")
        public void testPrivateSecondaryConstructorDeleted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateSecondaryConstructorDeleted/");
            doTest(fileName);
        }

        @TestMetadata("privateValAccessorChanged")
        public void testPrivateValAccessorChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateValAccessorChanged/");
            doTest(fileName);
        }

        @TestMetadata("privateValAdded")
        public void testPrivateValAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateValAdded/");
            doTest(fileName);
        }

        @TestMetadata("privateValDeleted")
        public void testPrivateValDeleted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateValDeleted/");
            doTest(fileName);
        }

        @TestMetadata("privateValSignatureChanged")
        public void testPrivateValSignatureChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateValSignatureChanged/");
            doTest(fileName);
        }

        @TestMetadata("privateVarAdded")
        public void testPrivateVarAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateVarAdded/");
            doTest(fileName);
        }

        @TestMetadata("privateVarDeleted")
        public void testPrivateVarDeleted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateVarDeleted/");
            doTest(fileName);
        }

        @TestMetadata("privateVarSignatureChanged")
        public void testPrivateVarSignatureChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/privateVarSignatureChanged/");
            doTest(fileName);
        }

        @TestMetadata("propertyRedeclaration")
        public void testPropertyRedeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/propertyRedeclaration/");
            doTest(fileName);
        }

        @TestMetadata("publicPropertyWithPrivateSetter")
        public void testPublicPropertyWithPrivateSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/publicPropertyWithPrivateSetter/");
            doTest(fileName);
        }

        @TestMetadata("publicPropertyWithPrivateSetterMultiFileFacade")
        public void testPublicPropertyWithPrivateSetterMultiFileFacade() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/publicPropertyWithPrivateSetterMultiFileFacade/");
            doTest(fileName);
        }

        @TestMetadata("removeAndRestoreCompanion")
        public void testRemoveAndRestoreCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/removeAndRestoreCompanion/");
            doTest(fileName);
        }

        @TestMetadata("removeAndRestoreCompanionWithImplicitUsages")
        public void testRemoveAndRestoreCompanionWithImplicitUsages() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/removeAndRestoreCompanionWithImplicitUsages/");
            doTest(fileName);
        }

        @TestMetadata("removeClass")
        public void testRemoveClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/removeClass/");
            doTest(fileName);
        }

        @TestMetadata("removeClassInDefaultPackage")
        public void testRemoveClassInDefaultPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/removeClassInDefaultPackage/");
            doTest(fileName);
        }

        @TestMetadata("removeFileWithFunctionOverload")
        public void testRemoveFileWithFunctionOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/removeFileWithFunctionOverload/");
            doTest(fileName);
        }

        @TestMetadata("removeMemberTypeAlias")
        public void testRemoveMemberTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/removeMemberTypeAlias/");
            doTest(fileName);
        }

        @TestMetadata("removeTopLevelTypeAlias")
        public void testRemoveTopLevelTypeAlias() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/removeTopLevelTypeAlias/");
            doTest(fileName);
        }

        @TestMetadata("renameClass")
        public void testRenameClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/renameClass/");
            doTest(fileName);
        }

        @TestMetadata("renameFileWithFunctionOverload")
        public void testRenameFileWithFunctionOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/renameFileWithFunctionOverload/");
            doTest(fileName);
        }

        @TestMetadata("returnTypeChanged")
        public void testReturnTypeChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/returnTypeChanged/");
            doTest(fileName);
        }

        @TestMetadata("simpleClassDependency")
        public void testSimpleClassDependency() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/simpleClassDependency/");
            doTest(fileName);
        }

        @TestMetadata("soleFileChangesPackage")
        public void testSoleFileChangesPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/soleFileChangesPackage/");
            doTest(fileName);
        }

        @TestMetadata("subpackage")
        public void testSubpackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/subpackage/");
            doTest(fileName);
        }

        @TestMetadata("topLevelFunctionSameSignature")
        public void testTopLevelFunctionSameSignature() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/topLevelFunctionSameSignature/");
            doTest(fileName);
        }

        @TestMetadata("topLevelFunctionWithJvmName")
        public void testTopLevelFunctionWithJvmName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/topLevelFunctionWithJvmName/");
            doTest(fileName);
        }

        @TestMetadata("topLevelMembersInTwoFiles")
        public void testTopLevelMembersInTwoFiles() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/topLevelMembersInTwoFiles/");
            doTest(fileName);
        }

        @TestMetadata("topLevelPrivateValUsageAdded")
        public void testTopLevelPrivateValUsageAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/topLevelPrivateValUsageAdded/");
            doTest(fileName);
        }

        @TestMetadata("topLevelPropertyWithJvmName")
        public void testTopLevelPropertyWithJvmName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/topLevelPropertyWithJvmName/");
            doTest(fileName);
        }

        @TestMetadata("traitClassObjectConstantChanged")
        public void testTraitClassObjectConstantChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/traitClassObjectConstantChanged/");
            doTest(fileName);
        }

        @TestMetadata("valAddCustomAccessor")
        public void testValAddCustomAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/valAddCustomAccessor/");
            doTest(fileName);
        }

        @TestMetadata("valRemoveCustomAccessor")
        public void testValRemoveCustomAccessor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/pureKotlin/valRemoveCustomAccessor/");
            doTest(fileName);
        }
    }

    @TestMetadata("jps-plugin/testData/incremental/withJava")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WithJava extends AbstractExperimentalIncrementalJpsTest {
        public void testAllFilesPresentInWithJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertBetweenJavaAndKotlin extends AbstractExperimentalIncrementalJpsTest {
            public void testAllFilesPresentInConvertBetweenJavaAndKotlin() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("javaToKotlin")
            public void testJavaToKotlin() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlin/");
                doTest(fileName);
            }

            @TestMetadata("javaToKotlinAndBack")
            public void testJavaToKotlinAndBack() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlinAndBack/");
                doTest(fileName);
            }

            @TestMetadata("javaToKotlinAndRemove")
            public void testJavaToKotlinAndRemove() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/javaToKotlinAndRemove/");
                doTest(fileName);
            }

            @TestMetadata("kotlinToJava")
            public void testKotlinToJava() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/convertBetweenJavaAndKotlin/kotlinToJava/");
                doTest(fileName);
            }

        }

        @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaUsedInKotlin extends AbstractExperimentalIncrementalJpsTest {
            public void testAllFilesPresentInJavaUsedInKotlin() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeNotUsedSignature")
            public void testChangeNotUsedSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeNotUsedSignature/");
                doTest(fileName);
            }

            @TestMetadata("changeSignature")
            public void testChangeSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/changeSignature/");
                doTest(fileName);
            }

            @TestMetadata("constantChanged")
            public void testConstantChanged() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/constantChanged/");
                doTest(fileName);
            }

            @TestMetadata("constantUnchanged")
            public void testConstantUnchanged() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/constantUnchanged/");
                doTest(fileName);
            }

            @TestMetadata("enumEntryAdded")
            public void testEnumEntryAdded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/enumEntryAdded/");
                doTest(fileName);
            }

            @TestMetadata("enumEntryRemoved")
            public void testEnumEntryRemoved() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/enumEntryRemoved/");
                doTest(fileName);
            }

            @TestMetadata("javaAndKotlinChangedSimultaneously")
            public void testJavaAndKotlinChangedSimultaneously() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/javaAndKotlinChangedSimultaneously/");
                doTest(fileName);
            }

            @TestMetadata("methodAddedInSuper")
            public void testMethodAddedInSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/methodAddedInSuper/");
                doTest(fileName);
            }

            @TestMetadata("methodRenamed")
            public void testMethodRenamed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/methodRenamed/");
                doTest(fileName);
            }

            @TestMetadata("notChangeSignature")
            public void testNotChangeSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/notChangeSignature/");
                doTest(fileName);
            }

            @TestMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class SamConversions extends AbstractExperimentalIncrementalJpsTest {
                public void testAllFilesPresentInSamConversions() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("methodAdded")
                public void testMethodAdded() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodAdded/");
                    doTest(fileName);
                }

                @TestMetadata("methodSignatureChanged")
                public void testMethodSignatureChanged() throws Exception {
                    String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/javaUsedInKotlin/samConversions/methodSignatureChanged/");
                    doTest(fileName);
                }

            }
        }

        @TestMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KotlinUsedInJava extends AbstractExperimentalIncrementalJpsTest {
            @TestMetadata("addOptionalParameter")
            public void testAddOptionalParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/addOptionalParameter/");
                doTest(fileName);
            }

            public void testAllFilesPresentInKotlinUsedInJava() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/withJava/kotlinUsedInJava"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeNotUsedSignature")
            public void testChangeNotUsedSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/changeNotUsedSignature/");
                doTest(fileName);
            }

            @TestMetadata("changeSignature")
            public void testChangeSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/changeSignature/");
                doTest(fileName);
            }

            @TestMetadata("constantChanged")
            public void testConstantChanged() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/constantChanged/");
                doTest(fileName);
            }

            @TestMetadata("constantUnchanged")
            public void testConstantUnchanged() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/constantUnchanged/");
                doTest(fileName);
            }

            @TestMetadata("funRenamed")
            public void testFunRenamed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/funRenamed/");
                doTest(fileName);
            }

            @TestMetadata("jvmFieldChanged")
            public void testJvmFieldChanged() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/jvmFieldChanged/");
                doTest(fileName);
            }

            @TestMetadata("jvmFieldUnchanged")
            public void testJvmFieldUnchanged() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/jvmFieldUnchanged/");
                doTest(fileName);
            }

            @TestMetadata("methodAddedInSuper")
            public void testMethodAddedInSuper() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/methodAddedInSuper/");
                doTest(fileName);
            }

            @TestMetadata("notChangeSignature")
            public void testNotChangeSignature() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/notChangeSignature/");
                doTest(fileName);
            }

            @TestMetadata("onlyTopLevelFunctionInFileRemoved")
            public void testOnlyTopLevelFunctionInFileRemoved() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/onlyTopLevelFunctionInFileRemoved/");
                doTest(fileName);
            }

            @TestMetadata("packageFileAdded")
            public void testPackageFileAdded() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/packageFileAdded/");
                doTest(fileName);
            }

            @TestMetadata("privateChanges")
            public void testPrivateChanges() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/privateChanges/");
                doTest(fileName);
            }

            @TestMetadata("propertyRenamed")
            public void testPropertyRenamed() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/withJava/kotlinUsedInJava/propertyRenamed/");
                doTest(fileName);
            }

        }
    }

    @TestMetadata("jps-plugin/testData/incremental/inlineFunCallSite")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineFunCallSite extends AbstractExperimentalIncrementalJpsTest {
        public void testAllFilesPresentInInlineFunCallSite() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/inlineFunCallSite"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classProperty")
        public void testClassProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/classProperty/");
            doTest(fileName);
        }

        @TestMetadata("companionObjectProperty")
        public void testCompanionObjectProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/companionObjectProperty/");
            doTest(fileName);
        }

        @TestMetadata("coroutine")
        public void testCoroutine() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/coroutine/");
            doTest(fileName);
        }

        @TestMetadata("function")
        public void testFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/function/");
            doTest(fileName);
        }

        @TestMetadata("getter")
        public void testGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/getter/");
            doTest(fileName);
        }

        @TestMetadata("lambda")
        public void testLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/lambda/");
            doTest(fileName);
        }

        @TestMetadata("localFun")
        public void testLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/localFun/");
            doTest(fileName);
        }

        @TestMetadata("method")
        public void testMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/method/");
            doTest(fileName);
        }

        @TestMetadata("parameterDefaultValue")
        public void testParameterDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/parameterDefaultValue/");
            doTest(fileName);
        }

        @TestMetadata("primaryConstructorParameterDefaultValue")
        public void testPrimaryConstructorParameterDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/primaryConstructorParameterDefaultValue/");
            doTest(fileName);
        }

        @TestMetadata("superCall")
        public void testSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/superCall/");
            doTest(fileName);
        }

        @TestMetadata("thisCall")
        public void testThisCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/thisCall/");
            doTest(fileName);
        }

        @TestMetadata("topLevelObjectProperty")
        public void testTopLevelObjectProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/topLevelObjectProperty/");
            doTest(fileName);
        }

        @TestMetadata("topLevelProperty")
        public void testTopLevelProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/inlineFunCallSite/topLevelProperty/");
            doTest(fileName);
        }

    }

    @TestMetadata("jps-plugin/testData/incremental/classHierarchyAffected")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassHierarchyAffected extends AbstractExperimentalIncrementalJpsTest {
        public void testAllFilesPresentInClassHierarchyAffected() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("jps-plugin/testData/incremental/classHierarchyAffected"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationFlagRemoved")
        public void testAnnotationFlagRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/annotationFlagRemoved/");
            doTest(fileName);
        }

        @TestMetadata("annotationListChanged")
        public void testAnnotationListChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/annotationListChanged/");
            doTest(fileName);
        }

        @TestMetadata("bridgeGenerated")
        public void testBridgeGenerated() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/bridgeGenerated/");
            doTest(fileName);
        }

        @TestMetadata("classBecameFinal")
        public void testClassBecameFinal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classBecameFinal/");
            doTest(fileName);
        }

        @TestMetadata("classBecameInterface")
        public void testClassBecameInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classBecameInterface/");
            doTest(fileName);
        }

        @TestMetadata("classBecamePrivate")
        public void testClassBecamePrivate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classBecamePrivate/");
            doTest(fileName);
        }

        @TestMetadata("classRemoved")
        public void testClassRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classRemoved/");
            doTest(fileName);
        }

        @TestMetadata("classRemovedAndRestored")
        public void testClassRemovedAndRestored() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classRemovedAndRestored/");
            doTest(fileName);
        }

        @TestMetadata("classToPackageFacade")
        public void testClassToPackageFacade() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/classToPackageFacade/");
            doTest(fileName);
        }

        @TestMetadata("companionObjectInheritedMemberChanged")
        public void testCompanionObjectInheritedMemberChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectInheritedMemberChanged/");
            doTest(fileName);
        }

        @TestMetadata("companionObjectMemberChanged")
        public void testCompanionObjectMemberChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectMemberChanged/");
            doTest(fileName);
        }

        @TestMetadata("companionObjectNameChanged")
        public void testCompanionObjectNameChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectNameChanged/");
            doTest(fileName);
        }

        @TestMetadata("companionObjectToSimpleObject")
        public void testCompanionObjectToSimpleObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/companionObjectToSimpleObject/");
            doTest(fileName);
        }

        @TestMetadata("constructorVisibilityChanged")
        public void testConstructorVisibilityChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/constructorVisibilityChanged/");
            doTest(fileName);
        }

        @TestMetadata("enumEntryAdded")
        public void testEnumEntryAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/enumEntryAdded/");
            doTest(fileName);
        }

        @TestMetadata("enumEntryRemoved")
        public void testEnumEntryRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/enumEntryRemoved/");
            doTest(fileName);
        }

        @TestMetadata("enumMemberChanged")
        public void testEnumMemberChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/enumMemberChanged/");
            doTest(fileName);
        }

        @TestMetadata("flagsAndMemberInDifferentClassesChanged")
        public void testFlagsAndMemberInDifferentClassesChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/flagsAndMemberInDifferentClassesChanged/");
            doTest(fileName);
        }

        @TestMetadata("flagsAndMemberInSameClassChanged")
        public void testFlagsAndMemberInSameClassChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/flagsAndMemberInSameClassChanged/");
            doTest(fileName);
        }

        @TestMetadata("implcitUpcast")
        public void testImplcitUpcast() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/implcitUpcast/");
            doTest(fileName);
        }

        @TestMetadata("inferredTypeArgumentChanged")
        public void testInferredTypeArgumentChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/inferredTypeArgumentChanged/");
            doTest(fileName);
        }

        @TestMetadata("inferredTypeChanged")
        public void testInferredTypeChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/inferredTypeChanged/");
            doTest(fileName);
        }

        @TestMetadata("jvmNameChanged")
        public void testJvmNameChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/jvmNameChanged/");
            doTest(fileName);
        }

        @TestMetadata("lambdaParameterAffected")
        public void testLambdaParameterAffected() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/lambdaParameterAffected/");
            doTest(fileName);
        }

        @TestMetadata("methodAdded")
        public void testMethodAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodAdded/");
            doTest(fileName);
        }

        @TestMetadata("methodAnnotationAdded")
        public void testMethodAnnotationAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodAnnotationAdded/");
            doTest(fileName);
        }

        @TestMetadata("methodNullabilityChanged")
        public void testMethodNullabilityChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodNullabilityChanged/");
            doTest(fileName);
        }

        @TestMetadata("methodParameterWithDefaultValueAdded")
        public void testMethodParameterWithDefaultValueAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodParameterWithDefaultValueAdded/");
            doTest(fileName);
        }

        @TestMetadata("methodRemoved")
        public void testMethodRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/methodRemoved/");
            doTest(fileName);
        }

        @TestMetadata("multiModuleCircular")
        public void testMultiModuleCircular() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/multiModuleCircular/");
            doTest(fileName);
        }

        @TestMetadata("multiModuleDefaultArgumentInConstructorRemoved")
        public void testMultiModuleDefaultArgumentInConstructorRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/multiModuleDefaultArgumentInConstructorRemoved/");
            doTest(fileName);
        }

        @TestMetadata("multiModuleDefaultValueInConstructorRemoved")
        public void testMultiModuleDefaultValueInConstructorRemoved() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/multiModuleDefaultValueInConstructorRemoved/");
            doTest(fileName);
        }

        @TestMetadata("multiModuleExported")
        public void testMultiModuleExported() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/multiModuleExported/");
            doTest(fileName);
        }

        @TestMetadata("multiModuleSimple")
        public void testMultiModuleSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/multiModuleSimple/");
            doTest(fileName);
        }

        @TestMetadata("multifilePackagePartMethodAdded")
        public void testMultifilePackagePartMethodAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/multifilePackagePartMethodAdded/");
            doTest(fileName);
        }

        @TestMetadata("overrideExplicit")
        public void testOverrideExplicit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/overrideExplicit/");
            doTest(fileName);
        }

        @TestMetadata("overrideImplicit")
        public void testOverrideImplicit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/overrideImplicit/");
            doTest(fileName);
        }

        @TestMetadata("packageFacadeToClass")
        public void testPackageFacadeToClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/packageFacadeToClass/");
            doTest(fileName);
        }

        @TestMetadata("propertyNullabilityChanged")
        public void testPropertyNullabilityChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/propertyNullabilityChanged/");
            doTest(fileName);
        }

        @TestMetadata("sealedClassImplAdded")
        public void testSealedClassImplAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/sealedClassImplAdded/");
            doTest(fileName);
        }

        @TestMetadata("secondaryConstructorAdded")
        public void testSecondaryConstructorAdded() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/secondaryConstructorAdded/");
            doTest(fileName);
        }

        @TestMetadata("starProjectionUpperBoundChanged")
        public void testStarProjectionUpperBoundChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/starProjectionUpperBoundChanged/");
            doTest(fileName);
        }

        @TestMetadata("supertypesListChanged")
        public void testSupertypesListChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/supertypesListChanged/");
            doTest(fileName);
        }

        @TestMetadata("typeParameterListChanged")
        public void testTypeParameterListChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/typeParameterListChanged/");
            doTest(fileName);
        }

        @TestMetadata("varianceChanged")
        public void testVarianceChanged() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("jps-plugin/testData/incremental/classHierarchyAffected/varianceChanged/");
            doTest(fileName);
        }

    }
}
