/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.js.test.semantics;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("js/js.translator/testData/box")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BoxJsTestGenerated extends AbstractBoxJsTest {
    public void testAllFilesPresentInBox() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("js/js.translator/testData/box/annotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotation extends AbstractBoxJsTest {
        public void testAllFilesPresentInAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/annotation"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationClass.kt")
        public void testAnnotationClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/annotation/annotationClass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractBoxJsTest {
        public void testAllFilesPresentInCallableReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/callableReference"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("js/js.translator/testData/box/callableReference/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractBoxJsTest {
            @TestMetadata("abstractClassMember.kt")
            public void testAbstractClassMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/abstractClassMember.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/callableReference/function"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classMemberAndExtension.kt")
            public void testClassMemberAndExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberAndExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberAndNonExtensionCompatibility.kt")
            public void testClassMemberAndNonExtensionCompatibility() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberAndNonExtensionCompatibility.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromClass.kt")
            public void testClassMemberFromClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberFromClass.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromExtension.kt")
            public void testClassMemberFromExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberFromExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromTopLevelStringNoArgs.kt")
            public void testClassMemberFromTopLevelStringNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberFromTopLevelStringNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromTopLevelStringOneStringArg.kt")
            public void testClassMemberFromTopLevelStringOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberFromTopLevelStringOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromTopLevelUnitNoArgs.kt")
            public void testClassMemberFromTopLevelUnitNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberFromTopLevelUnitNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberFromTopLevelUnitOneStringArg.kt")
            public void testClassMemberFromTopLevelUnitOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberFromTopLevelUnitOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("classMemberOverridden.kt")
            public void testClassMemberOverridden() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/classMemberOverridden.kt");
                doTest(fileName);
            }

            @TestMetadata("closureWithSideEffect.kt")
            public void testClosureWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/closureWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorFromTopLevelNoArgs.kt")
            public void testConstructorFromTopLevelNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/constructorFromTopLevelNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorFromTopLevelOneStringArg.kt")
            public void testConstructorFromTopLevelOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/constructorFromTopLevelOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("constructorsWithArgs.kt")
            public void testConstructorsWithArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/constructorsWithArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extension.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromClass.kt")
            public void testExtensionFromClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionFromClass.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromExtension.kt")
            public void testExtensionFromExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionFromExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevel.kt")
            public void testExtensionFromTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionFromTopLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevelStringNoArgs.kt")
            public void testExtensionFromTopLevelStringNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionFromTopLevelStringNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevelStringOneStringArg.kt")
            public void testExtensionFromTopLevelStringOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionFromTopLevelStringOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevelUnitNoArgs.kt")
            public void testExtensionFromTopLevelUnitNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionFromTopLevelUnitNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionFromTopLevelUnitOneStringArg.kt")
            public void testExtensionFromTopLevelUnitOneStringArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionFromTopLevelUnitOneStringArg.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionToPrimitive.kt")
            public void testExtensionToPrimitive() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionToPrimitive.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionWithClosure.kt")
            public void testExtensionWithClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/extensionWithClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("localAndTopLevelExtensions.kt")
            public void testLocalAndTopLevelExtensions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/localAndTopLevelExtensions.kt");
                doTest(fileName);
            }

            @TestMetadata("localLocal.kt")
            public void testLocalLocal() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/localLocal.kt");
                doTest(fileName);
            }

            @TestMetadata("recursiveClosure.kt")
            public void testRecursiveClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/recursiveClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/simple.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleClosure.kt")
            public void testSimpleClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/simpleClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleWithArg.kt")
            public void testSimpleWithArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/simpleWithArg.kt");
                doTest(fileName);
            }

            @TestMetadata("stringNativeExtension.kt")
            public void testStringNativeExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/stringNativeExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromClass.kt")
            public void testTopLevelFromClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/topLevelFromClass.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromExtension.kt")
            public void testTopLevelFromExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/topLevelFromExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromTopLevelStringNoArgs.kt")
            public void testTopLevelFromTopLevelStringNoArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/topLevelFromTopLevelStringNoArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelFromTopLevelWithArg.kt")
            public void testTopLevelFromTopLevelWithArg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/topLevelFromTopLevelWithArg.kt");
                doTest(fileName);
            }

            @TestMetadata("unitWithSideEffect.kt")
            public void testUnitWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/function/unitWithSideEffect.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/callableReference/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractBoxJsTest {
            @TestMetadata("accessViaSubclass.kt")
            public void testAccessViaSubclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/accessViaSubclass.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/callableReference/property"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegated.kt")
            public void testDelegated() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/delegated.kt");
                doTest(fileName);
            }

            @TestMetadata("delegatedMutable.kt")
            public void testDelegatedMutable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/delegatedMutable.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionProperty.kt")
            public void testExtensionProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/extensionProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("kClassInstanceIsInitializedFirst.kt")
            public void testKClassInstanceIsInitializedFirst() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/kClassInstanceIsInitializedFirst.kt");
                doTest(fileName);
            }

            @TestMetadata("memberProperty.kt")
            public void testMemberProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/memberProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("overriddenInSubclass.kt")
            public void testOverriddenInSubclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/overriddenInSubclass.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/simpleExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMember.kt")
            public void testSimpleMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/simpleMember.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMutableExtension.kt")
            public void testSimpleMutableExtension() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/simpleMutableExtension.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMutableMember.kt")
            public void testSimpleMutableMember() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/simpleMutableMember.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleMutableTopLevel.kt")
            public void testSimpleMutableTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/simpleMutableTopLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("simpleTopLevel.kt")
            public void testSimpleTopLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/simpleTopLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("topLevelVar.kt")
            public void testTopLevelVar() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/callableReference/property/topLevelVar.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("js/js.translator/testData/box/char")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Char extends AbstractBoxJsTest {
        public void testAllFilesPresentInChar() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/char"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("charBinaryOperations.kt")
        public void testCharBinaryOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/char/charBinaryOperations.kt");
            doTest(fileName);
        }

        @TestMetadata("charCompareToIntrinsic.kt")
        public void testCharCompareToIntrinsic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/char/charCompareToIntrinsic.kt");
            doTest(fileName);
        }

        @TestMetadata("charConstantByUnicodeId.kt")
        public void testCharConstantByUnicodeId() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/char/charConstantByUnicodeId.kt");
            doTest(fileName);
        }

        @TestMetadata("charConversions.kt")
        public void testCharConversions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/char/charConversions.kt");
            doTest(fileName);
        }

        @TestMetadata("charEquals.kt")
        public void testCharEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/char/charEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("charIsCheck.kt")
        public void testCharIsCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/char/charIsCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("charRanges.kt")
        public void testCharRanges() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/char/charRanges.kt");
            doTest(fileName);
        }

        @TestMetadata("charUnaryOperations.kt")
        public void testCharUnaryOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/char/charUnaryOperations.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/classObject")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassObject extends AbstractBoxJsTest {
        @TestMetadata("accessing.kt")
        public void testAccessing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/accessing.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInClassObject() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/classObject"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("defaultObjectSameNamesAsInOuter.kt")
        public void testDefaultObjectSameNamesAsInOuter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/defaultObjectSameNamesAsInOuter.kt");
            doTest(fileName);
        }

        @TestMetadata("enumCompanionObject.kt")
        public void testEnumCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/enumCompanionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("inTrait.kt")
        public void testInTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/inTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("invokeOperatorInCompanionObject.kt")
        public void testInvokeOperatorInCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/invokeOperatorInCompanionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("namedClassObject.kt")
        public void testNamedClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/namedClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInCompanionObject.kt")
        public void testObjectInCompanionObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/objectInCompanionObject.kt");
            doTest(fileName);
        }

        @TestMetadata("setVar.kt")
        public void testSetVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/setVar.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("withInheritance.kt")
        public void testWithInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/classObject/withInheritance.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/closure")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Closure extends AbstractBoxJsTest {
        public void testAllFilesPresentInClosure() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/closure"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("closureArrayListInstance.kt")
        public void testClosureArrayListInstance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureArrayListInstance.kt");
            doTest(fileName);
        }

        @TestMetadata("closureFunctionAsArgument.kt")
        public void testClosureFunctionAsArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureFunctionAsArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("closureFunctionByInnerFunction.kt")
        public void testClosureFunctionByInnerFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureFunctionByInnerFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("closureGenericTypeValue.kt")
        public void testClosureGenericTypeValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureGenericTypeValue.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInFewFunctionWithDifferentName.kt")
        public void testClosureInFewFunctionWithDifferentName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureInFewFunctionWithDifferentName.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInNestedFunctions.kt")
        public void testClosureInNestedFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureInNestedFunctions.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInNestedFunctionsInMethod.kt")
        public void testClosureInNestedFunctionsInMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureInNestedFunctionsInMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInNestedFunctionsWhichMixedWithObject.kt")
        public void testClosureInNestedFunctionsWhichMixedWithObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureInNestedFunctionsWhichMixedWithObject.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInNestedLambdasInObject.kt")
        public void testClosureInNestedLambdasInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureInNestedLambdasInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInObject.kt")
        public void testClosureInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInWithInsideWith.kt")
        public void testClosureInWithInsideWith() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureInWithInsideWith.kt");
            doTest(fileName);
        }

        @TestMetadata("closureLambdaVarInLambda.kt")
        public void testClosureLambdaVarInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureLambdaVarInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("closureLocalFunction.kt")
        public void testClosureLocalFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureLocalFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("closureLocalFunctionByInnerFunction.kt")
        public void testClosureLocalFunctionByInnerFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureLocalFunctionByInnerFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("closureLocalFunctionByInnerFunctionInConstructor.kt")
        public void testClosureLocalFunctionByInnerFunctionInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureLocalFunctionByInnerFunctionInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("closureLocalInNestedObject.kt")
        public void testClosureLocalInNestedObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureLocalInNestedObject.kt");
            doTest(fileName);
        }

        @TestMetadata("closureLocalLiteralFunction.kt")
        public void testClosureLocalLiteralFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureLocalLiteralFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("closureReceiverInLocalExtFunByLocalExtFun.kt")
        public void testClosureReceiverInLocalExtFunByLocalExtFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureReceiverInLocalExtFunByLocalExtFun.kt");
            doTest(fileName);
        }

        @TestMetadata("closureReferencingMember.kt")
        public void testClosureReferencingMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureReferencingMember.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisAndClassObject.kt")
        public void testClosureThisAndClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisAndClassObject.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisAndReceiver.kt")
        public void testClosureThisAndReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisAndReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisByUsingMethodFromParentClass.kt")
        public void testClosureThisByUsingMethodFromParentClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisByUsingMethodFromParentClass.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisInConstructor.kt")
        public void testClosureThisInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisInExtLambdaInsideMethod.kt")
        public void testClosureThisInExtLambdaInsideMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisInExtLambdaInsideMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisInFunctionWhichNamedSameAsParentClass.kt")
        public void testClosureThisInFunctionWhichNamedSameAsParentClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisInFunctionWhichNamedSameAsParentClass.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisInLambdaInsideMethod.kt")
        public void testClosureThisInLambdaInsideMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisInLambdaInsideMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisInLambdaInsideObject.kt")
        public void testClosureThisInLambdaInsideObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisInLambdaInsideObject.kt");
            doTest(fileName);
        }

        @TestMetadata("closureThisInLocalFunction.kt")
        public void testClosureThisInLocalFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureThisInLocalFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("closureValToScopeWithSameNameDeclaration.kt")
        public void testClosureValToScopeWithSameNameDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureValToScopeWithSameNameDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("closureVarToScopeWithSameNameDeclaration.kt")
        public void testClosureVarToScopeWithSameNameDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/closureVarToScopeWithSameNameDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("deepInnerClassInLocalClass.kt")
        public void testDeepInnerClassInLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/deepInnerClassInLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("deepInnerClassInLocalClassFromExtension.kt")
        public void testDeepInnerClassInLocalClassFromExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/deepInnerClassInLocalClassFromExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("enclosingClassFromInnerLocalClass.kt")
        public void testEnclosingClassFromInnerLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/enclosingClassFromInnerLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("enclosingClassFromLocalClass.kt")
        public void testEnclosingClassFromLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/enclosingClassFromLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitGenericReceiverInExtensionInLocalClass.kt")
        public void testImplicitGenericReceiverInExtensionInLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/implicitGenericReceiverInExtensionInLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratingCallbacks.kt")
        public void testIteratingCallbacks() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/iteratingCallbacks.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaInLocalFun.kt")
        public void testLambdaInLocalFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/lambdaInLocalFun.kt");
            doTest(fileName);
        }

        @TestMetadata("localConstructorAndMethod.kt")
        public void testLocalConstructorAndMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/localConstructorAndMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("localParameterInCallback.kt")
        public void testLocalParameterInCallback() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/localParameterInCallback.kt");
            doTest(fileName);
        }

        @TestMetadata("objectWithInvokeOperator.kt")
        public void testObjectWithInvokeOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/objectWithInvokeOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveExtFunction.kt")
        public void testRecursiveExtFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/recursiveExtFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveFunction.kt")
        public void testRecursiveFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/recursiveFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("recursiveFunctionWithSameNameDeclaration.kt")
        public void testRecursiveFunctionWithSameNameDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/recursiveFunctionWithSameNameDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("withManyClosuresInNestedFunctionsAndObjects.kt")
        public void testWithManyClosuresInNestedFunctionsAndObjects() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/withManyClosuresInNestedFunctionsAndObjects.kt");
            doTest(fileName);
        }

        @TestMetadata("wrappedVariableInExtensionFun.kt")
        public void testWrappedVariableInExtensionFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/closure/wrappedVariableInExtensionFun.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/crossModuleRef")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CrossModuleRef extends AbstractBoxJsTest {
        public void testAllFilesPresentInCrossModuleRef() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/crossModuleRef"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callableObjectRef.kt")
        public void testCallableObjectRef() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/callableObjectRef.kt");
            doTest(fileName);
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/constructor.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/inheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/lambda.kt");
            doTest(fileName);
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/object.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInInlineClosure.kt")
        public void testObjectInInlineClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/objectInInlineClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("objectIsObject.kt")
        public void testObjectIsObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/objectIsObject.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelExtension.kt")
        public void testTopLevelExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/topLevelExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelFunction.kt")
        public void testTopLevelFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/topLevelFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelMutableProperty.kt")
        public void testTopLevelMutableProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/topLevelMutableProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/crossModuleRef/topLevelProperty.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/dataClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DataClass extends AbstractBoxJsTest {
        public void testAllFilesPresentInDataClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/dataClass"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("components.kt")
        public void testComponents() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dataClass/components.kt");
            doTest(fileName);
        }

        @TestMetadata("copy.kt")
        public void testCopy() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dataClass/copy.kt");
            doTest(fileName);
        }

        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dataClass/equals.kt");
            doTest(fileName);
        }

        @TestMetadata("hashcode.kt")
        public void testHashcode() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dataClass/hashcode.kt");
            doTest(fileName);
        }

        @TestMetadata("keyrole.kt")
        public void testKeyrole() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dataClass/keyrole.kt");
            doTest(fileName);
        }

        @TestMetadata("override.kt")
        public void testOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dataClass/override.kt");
            doTest(fileName);
        }

        @TestMetadata("privateFields.kt")
        public void testPrivateFields() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dataClass/privateFields.kt");
            doTest(fileName);
        }

        @TestMetadata("tostring.kt")
        public void testTostring() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dataClass/tostring.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DefaultArguments extends AbstractBoxJsTest {
        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/defaultArguments"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexExpressionAsDefaultArgument.kt")
        public void testComplexExpressionAsDefaultArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/complexExpressionAsDefaultArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorCallWithDefArg1.kt")
        public void testConstructorCallWithDefArg1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/constructorCallWithDefArg1.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorCallWithDefArg2.kt")
        public void testConstructorCallWithDefArg2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/constructorCallWithDefArg2.kt");
            doTest(fileName);
        }

        @TestMetadata("defArgsWithSuperCall.kt")
        public void testDefArgsWithSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/defArgsWithSuperCall.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultArgumentsInFunctionWithExpressionAsBody.kt")
        public void testDefaultArgumentsInFunctionWithExpressionAsBody() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/defaultArgumentsInFunctionWithExpressionAsBody.kt");
            doTest(fileName);
        }

        @TestMetadata("enumSuperConstructor.kt")
        public void testEnumSuperConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/enumSuperConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("enumWithDefArg.kt")
        public void testEnumWithDefArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/enumWithDefArg.kt");
            doTest(fileName);
        }

        @TestMetadata("enumWithOneDefArg.kt")
        public void testEnumWithOneDefArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/enumWithOneDefArg.kt");
            doTest(fileName);
        }

        @TestMetadata("enumWithTwoDefArgs.kt")
        public void testEnumWithTwoDefArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/enumWithTwoDefArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionFunWithDefArgs.kt")
        public void testExtensionFunWithDefArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/extensionFunWithDefArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("funInAbstractClassWithDefArg.kt")
        public void testFunInAbstractClassWithDefArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/funInAbstractClassWithDefArg.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadFunWithDefArg.kt")
        public void testOverloadFunWithDefArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/overloadFunWithDefArg.kt");
            doTest(fileName);
        }

        @TestMetadata("primarySuperConstructor.kt")
        public void testPrimarySuperConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/primarySuperConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("secondarySuperConstructor.kt")
        public void testSecondarySuperConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/secondarySuperConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("virtualCallWithDefArg.kt")
        public void testVirtualCallWithDefArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/defaultArguments/virtualCallWithDefArg.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/delegateProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DelegateProperty extends AbstractBoxJsTest {
        public void testAllFilesPresentInDelegateProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/delegateProperty"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("capturedLocalVal.kt")
        public void testCapturedLocalVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/capturedLocalVal.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLocalValNoInline.kt")
        public void testCapturedLocalValNoInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/capturedLocalValNoInline.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLocalVar.kt")
        public void testCapturedLocalVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/capturedLocalVar.kt");
            doTest(fileName);
        }

        @TestMetadata("capturedLocalVarNoInline.kt")
        public void testCapturedLocalVarNoInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/capturedLocalVarNoInline.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateByExtensionProperty.kt")
        public void testDelegateByExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/delegateByExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateByTopLevelFun.kt")
        public void testDelegateByTopLevelFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/delegateByTopLevelFun.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateByTopLevelProperty.kt")
        public void testDelegateByTopLevelProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/delegateByTopLevelProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("delegateWithPropertyAccess.kt")
        public void testDelegateWithPropertyAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/delegateWithPropertyAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("getAsExtensionFun.kt")
        public void testGetAsExtensionFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/getAsExtensionFun.kt");
            doTest(fileName);
        }

        @TestMetadata("localVal.kt")
        public void testLocalVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/localVal.kt");
            doTest(fileName);
        }

        @TestMetadata("localVar.kt")
        public void testLocalVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/localVar.kt");
            doTest(fileName);
        }

        @TestMetadata("localVarInc.kt")
        public void testLocalVarInc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/localVarInc.kt");
            doTest(fileName);
        }

        @TestMetadata("localVarPlusAssign.kt")
        public void testLocalVarPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/localVarPlusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyMetadata.kt")
        public void testPropertyMetadata() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/propertyMetadata.kt");
            doTest(fileName);
        }

        @TestMetadata("setAsExtensionFun.kt")
        public void testSetAsExtensionFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/setAsExtensionFun.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelVal.kt")
        public void testTopLevelVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/topLevelVal.kt");
            doTest(fileName);
        }

        @TestMetadata("topLevelVar.kt")
        public void testTopLevelVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/topLevelVar.kt");
            doTest(fileName);
        }

        @TestMetadata("withGenerics.kt")
        public void testWithGenerics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegateProperty/withGenerics.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/delegation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Delegation extends AbstractBoxJsTest {
        public void testAllFilesPresentInDelegation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/delegation"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexDelegation.kt")
        public void testComplexDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/complexDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("delegation2.kt")
        public void testDelegation2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegation2.kt");
            doTest(fileName);
        }

        @TestMetadata("delegation3.kt")
        public void testDelegation3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegation3.kt");
            doTest(fileName);
        }

        @TestMetadata("delegation4.kt")
        public void testDelegation4() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegation4.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationByArg.kt")
        public void testDelegationByArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationByArg.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationByExprWithArgs.kt")
        public void testDelegationByExprWithArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationByExprWithArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationByFunExpr.kt")
        public void testDelegationByFunExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationByFunExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationByIfExpr.kt")
        public void testDelegationByIfExpr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationByIfExpr.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationByInh.kt")
        public void testDelegationByInh() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationByInh.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationByNewInstance.kt")
        public void testDelegationByNewInstance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationByNewInstance.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationChain.kt")
        public void testDelegationChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationChain.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationEvaluationOrder1.kt")
        public void testDelegationEvaluationOrder1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationEvaluationOrder1.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationEvaluationOrder2.kt")
        public void testDelegationEvaluationOrder2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationEvaluationOrder2.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationExtFun1.kt")
        public void testDelegationExtFun1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationExtFun1.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationExtFun2.kt")
        public void testDelegationExtFun2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationExtFun2.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationExtProp.kt")
        public void testDelegationExtProp() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationExtProp.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationExtensionPropertyDelegated.kt")
        public void testDelegationExtensionPropertyDelegated() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationExtensionPropertyDelegated.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationGenericArg.kt")
        public void testDelegationGenericArg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationGenericArg.kt");
            doTest(fileName);
        }

        @TestMetadata("delegationMethodsWithArgs.kt")
        public void testDelegationMethodsWithArgs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/delegationMethodsWithArgs.kt");
            doTest(fileName);
        }

        @TestMetadata("jsNamePropertyDelegation.kt")
        public void testJsNamePropertyDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/jsNamePropertyDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("onObject.kt")
        public void testOnObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/delegation/onObject.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/dynamic")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Dynamic extends AbstractBoxJsTest {
        public void testAllFilesPresentInDynamic() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/dynamic"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("binaryOperations.kt")
        public void testBinaryOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/binaryOperations.kt");
            doTest(fileName);
        }

        @TestMetadata("callGetMethod.kt")
        public void testCallGetMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/callGetMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("callMethods.kt")
        public void testCallMethods() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/callMethods.kt");
            doTest(fileName);
        }

        @TestMetadata("callSetMethod.kt")
        public void testCallSetMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/callSetMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("compareTo.kt")
        public void testCompareTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/compareTo.kt");
            doTest(fileName);
        }

        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/equals.kt");
            doTest(fileName);
        }

        @TestMetadata("getByBrackets.kt")
        public void testGetByBrackets() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/getByBrackets.kt");
            doTest(fileName);
        }

        @TestMetadata("identityEquals.kt")
        public void testIdentityEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/identityEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/in.kt");
            doTest(fileName);
        }

        @TestMetadata("incrementAndDecrement.kt")
        public void testIncrementAndDecrement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/incrementAndDecrement.kt");
            doTest(fileName);
        }

        @TestMetadata("infixCall.kt")
        public void testInfixCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/infixCall.kt");
            doTest(fileName);
        }

        @TestMetadata("invoke.kt")
        public void testInvoke() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/invoke.kt");
            doTest(fileName);
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/is.kt");
            doTest(fileName);
        }

        @TestMetadata("isJsPrimitiveType.kt")
        public void testIsJsPrimitiveType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/isJsPrimitiveType.kt");
            doTest(fileName);
        }

        @TestMetadata("iterator.kt")
        public void testIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/iterator.kt");
            doTest(fileName);
        }

        @TestMetadata("nameClashing.kt")
        public void testNameClashing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/nameClashing.kt");
            doTest(fileName);
        }

        @TestMetadata("operationsWithAssignment.kt")
        public void testOperationsWithAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/operationsWithAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccess.kt")
        public void testPropertyAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/propertyAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("setByBrackets.kt")
        public void testSetByBrackets() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/setByBrackets.kt");
            doTest(fileName);
        }

        @TestMetadata("unaryOperations.kt")
        public void testUnaryOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/dynamic/unaryOperations.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractBoxJsTest {
        @TestMetadata("accessing.kt")
        public void testAccessing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/accessing.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/enum"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("enumInheritedFromTrait.kt")
        public void testEnumInheritedFromTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/enumInheritedFromTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("enumIsComparable.kt")
        public void testEnumIsComparable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/enumIsComparable.kt");
            doTest(fileName);
        }

        @TestMetadata("enumWithInheritance.kt")
        public void testEnumWithInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/enumWithInheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/equals.kt");
            doTest(fileName);
        }

        @TestMetadata("implementsComparable.kt")
        public void testImplementsComparable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/implementsComparable.kt");
            doTest(fileName);
        }

        @TestMetadata("initializationOrder.kt")
        public void testInitializationOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/initializationOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("nativeEnum.kt")
        public void testNativeEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/nativeEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/simpleEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("standardMethods.kt")
        public void testStandardMethods() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/standardMethods.kt");
            doTest(fileName);
        }

        @TestMetadata("superCallInEnumLiteral.kt")
        public void testSuperCallInEnumLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/enum/superCallInEnumLiteral.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/examples")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Examples extends AbstractBoxJsTest {
        public void testAllFilesPresentInExamples() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/examples"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basicmethod.kt")
        public void testBasicmethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/basicmethod.kt");
            doTest(fileName);
        }

        @TestMetadata("basicproperty.kt")
        public void testBasicproperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/basicproperty.kt");
            doTest(fileName);
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/classObject.kt");
            doTest(fileName);
        }

        @TestMetadata("closureWithParameter.kt")
        public void testClosureWithParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/closureWithParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("closureWithParameterAndBoxing.kt")
        public void testClosureWithParameterAndBoxing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/closureWithParameterAndBoxing.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleEnclosedLocalVariable.kt")
        public void testDoubleEnclosedLocalVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/doubleEnclosedLocalVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("enclosed.kt")
        public void testEnclosed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/enclosed.kt");
            doTest(fileName);
        }

        @TestMetadata("enclosingLocalVariable.kt")
        public void testEnclosingLocalVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/enclosingLocalVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionClosure.kt")
        public void testExtensionClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/extensionClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("funDelegation.kt")
        public void testFunDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/funDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("incrementProperty.kt")
        public void testIncrementProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/incrementProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/inheritance.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedInnerClass.kt")
        public void testInheritedInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/inheritedInnerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritedMethod.kt")
        public void testInheritedMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/inheritedMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("initializerBlock.kt")
        public void testInitializerBlock() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/initializerBlock.kt");
            doTest(fileName);
        }

        @TestMetadata("initializerBlockDImpl.kt")
        public void testInitializerBlockDImpl() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/initializerBlockDImpl.kt");
            doTest(fileName);
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/innerClass.kt");
            doTest(fileName);
        }

        @TestMetadata("kt242.kt")
        public void testKt242() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/kt242.kt");
            doTest(fileName);
        }

        @TestMetadata("newInstanceDefaultConstructor.kt")
        public void testNewInstanceDefaultConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/newInstanceDefaultConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadBinaryOperator.kt")
        public void testOverloadBinaryOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/overloadBinaryOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusAssignReturn.kt")
        public void testOverloadPlusAssignReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/overloadPlusAssignReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusToPlusAssign.kt")
        public void testOverloadPlusToPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/overloadPlusToPlusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadUnaryOperator.kt")
        public void testOverloadUnaryOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/overloadUnaryOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyDelegation.kt")
        public void testPropertyDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/propertyDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyInInitializer.kt")
        public void testPropertyInInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/propertyInInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("rightHandOverride.kt")
        public void testRightHandOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/rightHandOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("simplestClosure.kt")
        public void testSimplestClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/simplestClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("simplestClosureAndBoxing.kt")
        public void testSimplestClosureAndBoxing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/simplestClosureAndBoxing.kt");
            doTest(fileName);
        }

        @TestMetadata("traitproperty.kt")
        public void testTraitproperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/examples/traitproperty.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/expression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expression extends AbstractBoxJsTest {
        public void testAllFilesPresentInExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("js/js.translator/testData/box/expression/cast")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Cast extends AbstractBoxJsTest {
            public void testAllFilesPresentInCast() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/cast"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("castExtensionToKMutableProperty.kt")
            public void testCastExtensionToKMutableProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castExtensionToKMutableProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("castExtensionToKProperty1.kt")
            public void testCastExtensionToKProperty1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castExtensionToKProperty1.kt");
                doTest(fileName);
            }

            @TestMetadata("castToAny.kt")
            public void testCastToAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToAny.kt");
                doTest(fileName);
            }

            @TestMetadata("castToArray.kt")
            public void testCastToArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToArray.kt");
                doTest(fileName);
            }

            @TestMetadata("castToFunction.kt")
            public void testCastToFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("castToGenericType.kt")
            public void testCastToGenericType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToGenericType.kt");
                doTest(fileName);
            }

            @TestMetadata("castToGenericTypeWithMultipleUpperBounds.kt")
            public void testCastToGenericTypeWithMultipleUpperBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToGenericTypeWithMultipleUpperBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("castToGenericTypeWithUpperBound.kt")
            public void testCastToGenericTypeWithUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToGenericTypeWithUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("castToKMutableProperty0.kt")
            public void testCastToKMutableProperty0() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToKMutableProperty0.kt");
                doTest(fileName);
            }

            @TestMetadata("castToKMutableProperty1.kt")
            public void testCastToKMutableProperty1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToKMutableProperty1.kt");
                doTest(fileName);
            }

            @TestMetadata("castToKProperty0.kt")
            public void testCastToKProperty0() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToKProperty0.kt");
                doTest(fileName);
            }

            @TestMetadata("castToKProperty1.kt")
            public void testCastToKProperty1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToKProperty1.kt");
                doTest(fileName);
            }

            @TestMetadata("castToNotNull.kt")
            public void testCastToNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("castToNullable.kt")
            public void testCastToNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/castToNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("implicitCastToLong.kt")
            public void testImplicitCastToLong() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/implicitCastToLong.kt");
                doTest(fileName);
            }

            @TestMetadata("noRuntimeTypeCheck.kt")
            public void testNoRuntimeTypeCheck() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/noRuntimeTypeCheck.kt");
                doTest(fileName);
            }

            @TestMetadata("primitiveToClass.kt")
            public void testPrimitiveToClass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/primitiveToClass.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedToNotNull.kt")
            public void testReifiedToNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/reifiedToNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedToNullable1.kt")
            public void testReifiedToNullable1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/reifiedToNullable1.kt");
                doTest(fileName);
            }

            @TestMetadata("reifiedToNullable2.kt")
            public void testReifiedToNullable2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/reifiedToNullable2.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCastToGenericTypeWithUpperBound.kt")
            public void testSafeCastToGenericTypeWithUpperBound() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/safeCastToGenericTypeWithUpperBound.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCastToNotNull.kt")
            public void testSafeCastToNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/safeCastToNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCastToNullable.kt")
            public void testSafeCastToNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/safeCastToNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCastToReifiedNotNull.kt")
            public void testSafeCastToReifiedNotNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/safeCastToReifiedNotNull.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCastToReifiedNullable.kt")
            public void testSafeCastToReifiedNullable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/safeCastToReifiedNullable.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastInExtensionFunction.kt")
            public void testSmartCastInExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/smartCastInExtensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("smartCastInFunction.kt")
            public void testSmartCastInFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/cast/smartCastInFunction.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/compareTo")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CompareTo extends AbstractBoxJsTest {
            public void testAllFilesPresentInCompareTo() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/compareTo"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("customCompareToMethod.kt")
            public void testCustomCompareToMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/compareTo/customCompareToMethod.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/dollarParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DollarParameter extends AbstractBoxJsTest {
            public void testAllFilesPresentInDollarParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/dollarParameter"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dollarParameter.kt")
            public void testDollarParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/dollarParameter/dollarParameter.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/equals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Equals extends AbstractBoxJsTest {
            public void testAllFilesPresentInEquals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/equals"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrays.kt")
            public void testArrays() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/arrays.kt");
                doTest(fileName);
            }

            @TestMetadata("compareNullableListWithNull.kt")
            public void testCompareNullableListWithNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/compareNullableListWithNull.kt");
                doTest(fileName);
            }

            @TestMetadata("compareNullablesWithCustomEquals.kt")
            public void testCompareNullablesWithCustomEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/compareNullablesWithCustomEquals.kt");
                doTest(fileName);
            }

            @TestMetadata("compareToNullWithCustomEquals.kt")
            public void testCompareToNullWithCustomEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/compareToNullWithCustomEquals.kt");
                doTest(fileName);
            }

            @TestMetadata("customEqualsMethod.kt")
            public void testCustomEqualsMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/customEqualsMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("customEqualsMethodOnAny.kt")
            public void testCustomEqualsMethodOnAny() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/customEqualsMethodOnAny.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsBehaviorOnNull.kt")
            public void testEqualsBehaviorOnNull() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/equalsBehaviorOnNull.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsNullOrUndefined.kt")
            public void testEqualsNullOrUndefined() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/equalsNullOrUndefined.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitEqualsMethod.kt")
            public void testExplicitEqualsMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/explicitEqualsMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("explicitEqualsMethodForPrimitives.kt")
            public void testExplicitEqualsMethodForPrimitives() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/explicitEqualsMethodForPrimitives.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2370.kt")
            public void testKt2370() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/kt2370.kt");
                doTest(fileName);
            }

            @TestMetadata("stringsEqual.kt")
            public void testStringsEqual() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/stringsEqual.kt");
                doTest(fileName);
            }

            @TestMetadata("superEquals.kt")
            public void testSuperEquals() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/equals/superEquals.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/evaluationOrder")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EvaluationOrder extends AbstractBoxJsTest {
            @TestMetadata("2dangerousInExpression.kt")
            public void test2dangerousInExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/2dangerousInExpression.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInEvaluationOrder() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/evaluationOrder"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("andAndWithBreakContinueReturn.kt")
            public void testAndAndWithBreakContinueReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/andAndWithBreakContinueReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("andAndWithSideEffect.kt")
            public void testAndAndWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/andAndWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("assignToArrayElementWithSideEffect.kt")
            public void testAssignToArrayElementWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/assignToArrayElementWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("assignToDotQualifiedWithSideEffect.kt")
            public void testAssignToDotQualifiedWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/assignToDotQualifiedWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("callArgs.kt")
            public void testCallArgs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/callArgs.kt");
                doTest(fileName);
            }

            @TestMetadata("callVarargs.kt")
            public void testCallVarargs() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/callVarargs.kt");
                doTest(fileName);
            }

            @TestMetadata("callWithBreakContinueReturn.kt")
            public void testCallWithBreakContinueReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/callWithBreakContinueReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("castWithBreakContinueReturn.kt")
            public void testCastWithBreakContinueReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/castWithBreakContinueReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("compareToIntrinsicWithSideEffect.kt")
            public void testCompareToIntrinsicWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/compareToIntrinsicWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("dangerousInline.kt")
            public void testDangerousInline() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/dangerousInline.kt");
                doTest(fileName);
            }

            @TestMetadata("dangerousInsideDangerous.kt")
            public void testDangerousInsideDangerous() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/dangerousInsideDangerous.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisComplex.kt")
            public void testElvisComplex() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/elvisComplex.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisWithBreakContinueReturn.kt")
            public void testElvisWithBreakContinueReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/elvisWithBreakContinueReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("equalsIntrinsicWithSideEffect.kt")
            public void testEqualsIntrinsicWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/equalsIntrinsicWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("evaluationOrder1.kt")
            public void testEvaluationOrder1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/evaluationOrder1.kt");
                doTest(fileName);
            }

            @TestMetadata("evaluationOrder2.kt")
            public void testEvaluationOrder2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/evaluationOrder2.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAsFunArgument.kt")
            public void testIfAsFunArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/ifAsFunArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("ifAsPlusArgument.kt")
            public void testIfAsPlusArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/ifAsPlusArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("ifWithComplex.kt")
            public void testIfWithComplex() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/ifWithComplex.kt");
                doTest(fileName);
            }

            @TestMetadata("intrinsicComplex.kt")
            public void testIntrinsicComplex() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/intrinsicComplex.kt");
                doTest(fileName);
            }

            @TestMetadata("intrinsicWithBreakContinueReturn.kt")
            public void testIntrinsicWithBreakContinueReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/intrinsicWithBreakContinueReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("literalFunctionAsArgumentWithSideEffect.kt")
            public void testLiteralFunctionAsArgumentWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/literalFunctionAsArgumentWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("loopWithBreakContinueReturnInCondition.kt")
            public void testLoopWithBreakContinueReturnInCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/loopWithBreakContinueReturnInCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("orOrWithBreakContinueReturn.kt")
            public void testOrOrWithBreakContinueReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/orOrWithBreakContinueReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("orOrWithSideEffect.kt")
            public void testOrOrWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/orOrWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("reassignmentLhsCaching.kt")
            public void testReassignmentLhsCaching() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/reassignmentLhsCaching.kt");
                doTest(fileName);
            }

            @TestMetadata("whenAsMinusArgument.kt")
            public void testWhenAsMinusArgument() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/whenAsMinusArgument.kt");
                doTest(fileName);
            }

            @TestMetadata("whenJsLiteralWithSideEffect.kt")
            public void testWhenJsLiteralWithSideEffect() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/whenJsLiteralWithSideEffect.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithComplexConditions.kt")
            public void testWhenWithComplexConditions() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/evaluationOrder/whenWithComplexConditions.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/for")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class For extends AbstractBoxJsTest {
            public void testAllFilesPresentInFor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/for"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("forIteratesOverArray.kt")
            public void testForIteratesOverArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forIteratesOverArray.kt");
                doTest(fileName);
            }

            @TestMetadata("forIteratesOverLiteralRange.kt")
            public void testForIteratesOverLiteralRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forIteratesOverLiteralRange.kt");
                doTest(fileName);
            }

            @TestMetadata("forIteratesOverNonLiteralRange.kt")
            public void testForIteratesOverNonLiteralRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forIteratesOverNonLiteralRange.kt");
                doTest(fileName);
            }

            @TestMetadata("forIteratesOverSomethingWithIterator.kt")
            public void testForIteratesOverSomethingWithIterator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forIteratesOverSomethingWithIterator.kt");
                doTest(fileName);
            }

            @TestMetadata("forIteratesOverTypeParameter.kt")
            public void testForIteratesOverTypeParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forIteratesOverTypeParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("forOnEmptyArray.kt")
            public void testForOnEmptyArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forOnEmptyArray.kt");
                doTest(fileName);
            }

            @TestMetadata("forWithComplexOneStatement.kt")
            public void testForWithComplexOneStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forWithComplexOneStatement.kt");
                doTest(fileName);
            }

            @TestMetadata("forWithEmptyBody.kt")
            public void testForWithEmptyBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forWithEmptyBody.kt");
                doTest(fileName);
            }

            @TestMetadata("forWithSideEffectImElementAccessAndWithEmptyBody.kt")
            public void testForWithSideEffectImElementAccessAndWithEmptyBody() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/forWithSideEffectImElementAccessAndWithEmptyBody.kt");
                doTest(fileName);
            }

            @TestMetadata("labeledFor.kt")
            public void testLabeledFor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/labeledFor.kt");
                doTest(fileName);
            }

            @TestMetadata("labeledForWithContinue.kt")
            public void testLabeledForWithContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/labeledForWithContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("labeledForWithWhile.kt")
            public void testLabeledForWithWhile() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/for/labeledForWithWhile.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractBoxJsTest {
            @TestMetadata("adderClosure.kt")
            public void testAdderClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/adderClosure.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/function"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callFunInInit.kt")
            public void testCallFunInInit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/callFunInInit.kt");
                doTest(fileName);
            }

            @TestMetadata("closureWithParameter.kt")
            public void testClosureWithParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/closureWithParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("closureWithParameterAndBoxing.kt")
            public void testClosureWithParameterAndBoxing() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/closureWithParameterAndBoxing.kt");
                doTest(fileName);
            }

            @TestMetadata("defaultParameters.kt")
            public void testDefaultParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/defaultParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("enclosingThis.kt")
            public void testEnclosingThis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/enclosingThis.kt");
                doTest(fileName);
            }

            @TestMetadata("expressionAsExtFunction.kt")
            public void testExpressionAsExtFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/expressionAsExtFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("expressionAsFunction.kt")
            public void testExpressionAsFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/expressionAsFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("functionExpression.kt")
            public void testFunctionExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/functionExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("functionInsideFunction.kt")
            public void testFunctionInsideFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/functionInsideFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteral.kt")
            public void testFunctionLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/functionLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralAsLastParameter.kt")
            public void testFunctionLiteralAsLastParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/functionLiteralAsLastParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("functionLiteralAsParameter.kt")
            public void testFunctionLiteralAsParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/functionLiteralAsParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("functionUsedBeforeDeclaration.kt")
            public void testFunctionUsedBeforeDeclaration() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/functionUsedBeforeDeclaration.kt");
                doTest(fileName);
            }

            @TestMetadata("functionWithTwoParametersCall.kt")
            public void testFunctionWithTwoParametersCall() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/functionWithTwoParametersCall.kt");
                doTest(fileName);
            }

            @TestMetadata("implicitItParameter.kt")
            public void testImplicitItParameter() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/implicitItParameter.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-921.kt")
            public void testKT_921() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/KT-921.kt");
                doTest(fileName);
            }

            @TestMetadata("lambdaOrLocalFunInsideEnumMethod.kt")
            public void testLambdaOrLocalFunInsideEnumMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/lambdaOrLocalFunInsideEnumMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("localExtFunction.kt")
            public void testLocalExtFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/localExtFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("localInInitBlock.kt")
            public void testLocalInInitBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/localInInitBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("loopClosure.kt")
            public void testLoopClosure() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/loopClosure.kt");
                doTest(fileName);
            }

            @TestMetadata("mangling.kt")
            public void testMangling() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/mangling.kt");
                doTest(fileName);
            }

            @TestMetadata("manglingAnyMethods.kt")
            public void testManglingAnyMethods() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/manglingAnyMethods.kt");
                doTest(fileName);
            }

            @TestMetadata("manglingClashFunctionsAndClasses.kt")
            public void testManglingClashFunctionsAndClasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/manglingClashFunctionsAndClasses.kt");
                doTest(fileName);
            }

            @TestMetadata("manglingClashWithFunctionsWithoutParameters.kt")
            public void testManglingClashWithFunctionsWithoutParameters() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/manglingClashWithFunctionsWithoutParameters.kt");
                doTest(fileName);
            }

            @TestMetadata("manglingStability.kt")
            public void testManglingStability() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/manglingStability.kt");
                doTest(fileName);
            }

            @TestMetadata("namedArguments.kt")
            public void testNamedArguments() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/namedArguments.kt");
                doTest(fileName);
            }

            @TestMetadata("overloadClassConstructorByFactoryMethod.kt")
            public void testOverloadClassConstructorByFactoryMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/overloadClassConstructorByFactoryMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("overloadOverridenFun.kt")
            public void testOverloadOverridenFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/overloadOverridenFun.kt");
                doTest(fileName);
            }

            @TestMetadata("overloadingWithInheritance.kt")
            public void testOverloadingWithInheritance() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/overloadingWithInheritance.kt");
                doTest(fileName);
            }

            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/vararg.kt");
                doTest(fileName);
            }

            @TestMetadata("whenFunction.kt")
            public void testWhenFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/function/whenFunction.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/identifierClash")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IdentifierClash extends AbstractBoxJsTest {
            public void testAllFilesPresentInIdentifierClash() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/identifierClash"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("overloadedFun.kt")
            public void testOverloadedFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/identifierClash/overloadedFun.kt");
                doTest(fileName);
            }

            @TestMetadata("useVariableOfNameOfFunction.kt")
            public void testUseVariableOfNameOfFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/identifierClash/useVariableOfNameOfFunction.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/identityEquals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IdentityEquals extends AbstractBoxJsTest {
            public void testAllFilesPresentInIdentityEquals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/identityEquals"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("identityEqualsMethod.kt")
            public void testIdentityEqualsMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/identityEquals/identityEqualsMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("identityEqualsMethodForPrimitives.kt")
            public void testIdentityEqualsMethodForPrimitives() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/identityEquals/identityEqualsMethodForPrimitives.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/if")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class If extends AbstractBoxJsTest {
            public void testAllFilesPresentInIf() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/if"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ifElseAsExpressionWithThrow.kt")
            public void testIfElseAsExpressionWithThrow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/if/ifElseAsExpressionWithThrow.kt");
                doTest(fileName);
            }

            @TestMetadata("ifInsideLambda.kt")
            public void testIfInsideLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/if/ifInsideLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("nestedIf.kt")
            public void testNestedIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/if/nestedIf.kt");
                doTest(fileName);
            }

            @TestMetadata("withEmptyBlocks.kt")
            public void testWithEmptyBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/if/withEmptyBlocks.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/invoke")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Invoke extends AbstractBoxJsTest {
            public void testAllFilesPresentInInvoke() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/invoke"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("explicitInvokeLambda.kt")
            public void testExplicitInvokeLambda() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/explicitInvokeLambda.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionInvoke.kt")
            public void testExtensionInvoke() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/extensionInvoke.kt");
                doTest(fileName);
            }

            @TestMetadata("inheritFromFunctionTraits.kt")
            public void testInheritFromFunctionTraits() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/inheritFromFunctionTraits.kt");
                doTest(fileName);
            }

            @TestMetadata("internalFunctionFromSuperclass.kt")
            public void testInternalFunctionFromSuperclass() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/internalFunctionFromSuperclass.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeInExtensionFunctionLiteral.kt")
            public void testInvokeInExtensionFunctionLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/invokeInExtensionFunctionLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeInFunctionLiteral.kt")
            public void testInvokeInFunctionLiteral() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/invokeInFunctionLiteral.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeMethod.kt")
            public void testInvokeMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/invokeMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeOnExprByConvention.kt")
            public void testInvokeOnExprByConvention() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/invokeOnExprByConvention.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeWithDispatchAndExtensionReceivers.kt")
            public void testInvokeWithDispatchAndExtensionReceivers() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/invokeWithDispatchAndExtensionReceivers.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeWithDispatchReceiver.kt")
            public void testInvokeWithDispatchReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/invokeWithDispatchReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeWithExtensionReceiver.kt")
            public void testInvokeWithExtensionReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/invokeWithExtensionReceiver.kt");
                doTest(fileName);
            }

            @TestMetadata("invokeWithImplicitDispatchReceiverAndExtensionReceiver.kt")
            public void testInvokeWithImplicitDispatchReceiverAndExtensionReceiver() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/invoke/invokeWithImplicitDispatchReceiverAndExtensionReceiver.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/misc")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Misc extends AbstractBoxJsTest {
            public void testAllFilesPresentInMisc() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/misc"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("classWithoutPackage.kt")
            public void testClassWithoutPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/classWithoutPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("elvis.kt")
            public void testElvis() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/elvis.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisReturnNested.kt")
            public void testElvisReturnNested() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/elvisReturnNested.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisReturnSimple.kt")
            public void testElvisReturnSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/elvisReturnSimple.kt");
                doTest(fileName);
            }

            @TestMetadata("elvisWithThrow.kt")
            public void testElvisWithThrow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/elvisWithThrow.kt");
                doTest(fileName);
            }

            @TestMetadata("exclExcl.kt")
            public void testExclExcl() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/exclExcl.kt");
                doTest(fileName);
            }

            @TestMetadata("exclExclResultIsComputedOnce.kt")
            public void testExclExclResultIsComputedOnce() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/exclExclResultIsComputedOnce.kt");
                doTest(fileName);
            }

            @TestMetadata("exclExclThrows.kt")
            public void testExclExclThrows() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/exclExclThrows.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionLiteralCalledInsideExtensionFunction.kt")
            public void testExtensionLiteralCalledInsideExtensionFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/extensionLiteralCalledInsideExtensionFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("extensionLiteralCreatedAtPackageLevel.kt")
            public void testExtensionLiteralCreatedAtPackageLevel() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/extensionLiteralCreatedAtPackageLevel.kt");
                doTest(fileName);
            }

            @TestMetadata("funInConstructor.kt")
            public void testFunInConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/funInConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("funInConstructorBlock.kt")
            public void testFunInConstructorBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/funInConstructorBlock.kt");
                doTest(fileName);
            }

            @TestMetadata("inheritFromJetIterator.kt")
            public void testInheritFromJetIterator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/inheritFromJetIterator.kt");
                doTest(fileName);
            }

            @TestMetadata("intRange.kt")
            public void testIntRange() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/intRange.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-1052.kt")
            public void testKT_1052() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-1052.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-1052-2.kt")
            public void testKT_1052_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-1052-2.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-1361-1.kt")
            public void testKT_1361_1() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-1361-1.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-1361-2.kt")
            public void testKT_1361_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-1361-2.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-1865.kt")
            public void testKT_1865() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-1865.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-2314.kt")
            public void testKT_2314() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-2314.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-5058.kt")
            public void testKT_5058() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-5058.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-740.kt")
            public void testKT_740() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-740.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-740-2.kt")
            public void testKT_740_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-740-2.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-740-3.kt")
            public void testKT_740_3() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-740-3.kt");
                doTest(fileName);
            }

            @TestMetadata("KT-817.kt")
            public void testKT_817() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/KT-817.kt");
                doTest(fileName);
            }

            @TestMetadata("kt9443.kt")
            public void testKt9443() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/kt9443.kt");
                doTest(fileName);
            }

            @TestMetadata("lazyProperty.kt")
            public void testLazyProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/lazyProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("localProperty.kt")
            public void testLocalProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/localProperty.kt");
                doTest(fileName);
            }

            @TestMetadata("localVarAsFunction.kt")
            public void testLocalVarAsFunction() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/localVarAsFunction.kt");
                doTest(fileName);
            }

            @TestMetadata("packageLevelVarInPackage.kt")
            public void testPackageLevelVarInPackage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/packageLevelVarInPackage.kt");
                doTest(fileName);
            }

            @TestMetadata("packageLevelVarInRoot.kt")
            public void testPackageLevelVarInRoot() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/packageLevelVarInRoot.kt");
                doTest(fileName);
            }

            @TestMetadata("packagePropertyCalledAsFun.kt")
            public void testPackagePropertyCalledAsFun() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/packagePropertyCalledAsFun.kt");
                doTest(fileName);
            }

            @TestMetadata("propertiesWithExplicitlyDefinedAccessorsWithoutBodies.kt")
            public void testPropertiesWithExplicitlyDefinedAccessorsWithoutBodies() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/propertiesWithExplicitlyDefinedAccessorsWithoutBodies.kt");
                doTest(fileName);
            }

            @TestMetadata("propertyAsFunCalledOnConstructor.kt")
            public void testPropertyAsFunCalledOnConstructor() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/propertyAsFunCalledOnConstructor.kt");
                doTest(fileName);
            }

            @TestMetadata("rightAssocForGeneratedConditionalOperator.kt")
            public void testRightAssocForGeneratedConditionalOperator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/rightAssocForGeneratedConditionalOperator.kt");
                doTest(fileName);
            }

            @TestMetadata("safeCallComputesExpressionOnlyOnce.kt")
            public void testSafeCallComputesExpressionOnlyOnce() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/safeCallComputesExpressionOnlyOnce.kt");
                doTest(fileName);
            }

            @TestMetadata("stringInterpolationEvaluationOrder.kt")
            public void testStringInterpolationEvaluationOrder() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/stringInterpolationEvaluationOrder.kt");
                doTest(fileName);
            }

            @TestMetadata("temporaryVariableCreatedInPackageInitializer.kt")
            public void testTemporaryVariableCreatedInPackageInitializer() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/temporaryVariableCreatedInPackageInitializer.kt");
                doTest(fileName);
            }

            @TestMetadata("throwThrow.kt")
            public void testThrowThrow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/throwThrow.kt");
                doTest(fileName);
            }

            @TestMetadata("toGeneratorInStdlib.kt")
            public void testToGeneratorInStdlib() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/toGeneratorInStdlib.kt");
                doTest(fileName);
            }

            @TestMetadata("whenReturnedWithoutBlock.kt")
            public void testWhenReturnedWithoutBlock() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/misc/whenReturnedWithoutBlock.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/stringClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringClass extends AbstractBoxJsTest {
            public void testAllFilesPresentInStringClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/stringClass"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("extensionMethods.kt")
            public void testExtensionMethods() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/extensionMethods.kt");
                doTest(fileName);
            }

            @TestMetadata("intInTemplate.kt")
            public void testIntInTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/intInTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2227.kt")
            public void testKt2227() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/kt2227.kt");
                doTest(fileName);
            }

            @TestMetadata("kt2227_2.kt")
            public void testKt2227_2() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/kt2227_2.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleExpressionsInTemplate.kt")
            public void testMultipleExpressionsInTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/multipleExpressionsInTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("nullableTypeInStringTemplate.kt")
            public void testNullableTypeInStringTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/nullableTypeInStringTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("numbersInTemplate.kt")
            public void testNumbersInTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/numbersInTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("objectToStringCallInTemplate.kt")
            public void testObjectToStringCallInTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/objectToStringCallInTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("stringAssignment.kt")
            public void testStringAssignment() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/stringAssignment.kt");
                doTest(fileName);
            }

            @TestMetadata("stringConstant.kt")
            public void testStringConstant() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/stringConstant.kt");
                doTest(fileName);
            }

            @TestMetadata("stringInTemplate.kt")
            public void testStringInTemplate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/stringInTemplate.kt");
                doTest(fileName);
            }

            @TestMetadata("stringNotEqualToNumber.kt")
            public void testStringNotEqualToNumber() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/stringNotEqualToNumber.kt");
                doTest(fileName);
            }

            @TestMetadata("stringSplit.kt")
            public void testStringSplit() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/stringSplit.kt");
                doTest(fileName);
            }

            @TestMetadata("subSequence.kt")
            public void testSubSequence() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringClass/subSequence.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/stringTemplates")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StringTemplates extends AbstractBoxJsTest {
            public void testAllFilesPresentInStringTemplates() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/stringTemplates"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("objectWithToString.kt")
            public void testObjectWithToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringTemplates/objectWithToString.kt");
                doTest(fileName);
            }

            @TestMetadata("stringValues.kt")
            public void testStringValues() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/stringTemplates/stringValues.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/try")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Try extends AbstractBoxJsTest {
            public void testAllFilesPresentInTry() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/try"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("exceptionToString.kt")
            public void testExceptionToString() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/try/exceptionToString.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleCatchBlocks.kt")
            public void testMultipleCatchBlocks() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/try/multipleCatchBlocks.kt");
                doTest(fileName);
            }

            @TestMetadata("rethrowExceptionIfNotCaught.kt")
            public void testRethrowExceptionIfNotCaught() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/try/rethrowExceptionIfNotCaught.kt");
                doTest(fileName);
            }

            @TestMetadata("tryCatchCorrectForSubclasses.kt")
            public void testTryCatchCorrectForSubclasses() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/try/tryCatchCorrectForSubclasses.kt");
                doTest(fileName);
            }

            @TestMetadata("tryCatchExpr.kt")
            public void testTryCatchExpr() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/try/tryCatchExpr.kt");
                doTest(fileName);
            }

            @TestMetadata("tryCatchExpressionWithMessage.kt")
            public void testTryCatchExpressionWithMessage() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/try/tryCatchExpressionWithMessage.kt");
                doTest(fileName);
            }

            @TestMetadata("tryCatchThrowable.kt")
            public void testTryCatchThrowable() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/try/tryCatchThrowable.kt");
                doTest(fileName);
            }

            @TestMetadata("tryCatchWithDifferentParameterNames.kt")
            public void testTryCatchWithDifferentParameterNames() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/try/tryCatchWithDifferentParameterNames.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/when")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class When extends AbstractBoxJsTest {
            public void testAllFilesPresentInWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/when"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("doWhileWithOneStmWhen.kt")
            public void testDoWhileWithOneStmWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/doWhileWithOneStmWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("empty.kt")
            public void testEmpty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/empty.kt");
                doTest(fileName);
            }

            @TestMetadata("forWithOneStmWhen.kt")
            public void testForWithOneStmWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/forWithOneStmWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("ifInWhen.kt")
            public void testIfInWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/ifInWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("ifInWhenDanglingElseIssue.kt")
            public void testIfInWhenDanglingElseIssue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/ifInWhenDanglingElseIssue.kt");
                doTest(fileName);
            }

            @TestMetadata("ifWithOneStmWhen.kt")
            public void testIfWithOneStmWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/ifWithOneStmWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("kt1665.kt")
            public void testKt1665() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/kt1665.kt");
                doTest(fileName);
            }

            @TestMetadata("matchNullableType.kt")
            public void testMatchNullableType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/matchNullableType.kt");
                doTest(fileName);
            }

            @TestMetadata("multipleCases.kt")
            public void testMultipleCases() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/multipleCases.kt");
                doTest(fileName);
            }

            @TestMetadata("whenAsExpression.kt")
            public void testWhenAsExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenAsExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("whenAsExpressionWithThrow.kt")
            public void testWhenAsExpressionWithThrow() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenAsExpressionWithThrow.kt");
                doTest(fileName);
            }

            @TestMetadata("whenConditionWithReturn.kt")
            public void testWhenConditionWithReturn() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenConditionWithReturn.kt");
                doTest(fileName);
            }

            @TestMetadata("whenEqualsPattern.kt")
            public void testWhenEqualsPattern() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenEqualsPattern.kt");
                doTest(fileName);
            }

            @TestMetadata("whenEvaluatesArgumentOnlyOnce.kt")
            public void testWhenEvaluatesArgumentOnlyOnce() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenEvaluatesArgumentOnlyOnce.kt");
                doTest(fileName);
            }

            @TestMetadata("whenExecutesOnlyOnce.kt")
            public void testWhenExecutesOnlyOnce() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenExecutesOnlyOnce.kt");
                doTest(fileName);
            }

            @TestMetadata("whenNotType.kt")
            public void testWhenNotType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenNotType.kt");
                doTest(fileName);
            }

            @TestMetadata("whenStatementWithRangeClause.kt")
            public void testWhenStatementWithRangeClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenStatementWithRangeClause.kt");
                doTest(fileName);
            }

            @TestMetadata("whenType.kt")
            public void testWhenType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenType.kt");
                doTest(fileName);
            }

            @TestMetadata("whenValue.kt")
            public void testWhenValue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenValue.kt");
                doTest(fileName);
            }

            @TestMetadata("whenValueOrType.kt")
            public void testWhenValueOrType() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenValueOrType.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithCharRangeClause.kt")
            public void testWhenWithCharRangeClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithCharRangeClause.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithCustomRangeClause.kt")
            public void testWhenWithCustomRangeClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithCustomRangeClause.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithIf.kt")
            public void testWhenWithIf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithIf.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithIfConditionAndOnlyElse.kt")
            public void testWhenWithIfConditionAndOnlyElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithIfConditionAndOnlyElse.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithLongRangeClause.kt")
            public void testWhenWithLongRangeClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithLongRangeClause.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithOneStmWhen.kt")
            public void testWhenWithOneStmWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithOneStmWhen.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithOnlyElse.kt")
            public void testWhenWithOnlyElse() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithOnlyElse.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithRangeClause.kt")
            public void testWhenWithRangeClause() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithRangeClause.kt");
                doTest(fileName);
            }

            @TestMetadata("whenWithoutExpression.kt")
            public void testWhenWithoutExpression() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whenWithoutExpression.kt");
                doTest(fileName);
            }

            @TestMetadata("whileWithOneStmWhen.kt")
            public void testWhileWithOneStmWhen() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/when/whileWithOneStmWhen.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/expression/while")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class While extends AbstractBoxJsTest {
            public void testAllFilesPresentInWhile() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/expression/while"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("doWhileWithComplexCondition.kt")
            public void testDoWhileWithComplexCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/while/doWhileWithComplexCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("doWhileWithComplexConditionAndContinue.kt")
            public void testDoWhileWithComplexConditionAndContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/while/doWhileWithComplexConditionAndContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("whileWithComplexCondition.kt")
            public void testWhileWithComplexCondition() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/while/whileWithComplexCondition.kt");
                doTest(fileName);
            }

            @TestMetadata("whileWithComplexConditionAndContinue.kt")
            public void testWhileWithComplexConditionAndContinue() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/while/whileWithComplexConditionAndContinue.kt");
                doTest(fileName);
            }

            @TestMetadata("whileWithComplexOneStatement.kt")
            public void testWhileWithComplexOneStatement() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/expression/while/whileWithComplexOneStatement.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("js/js.translator/testData/box/extensionFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionFunction extends AbstractBoxJsTest {
        public void testAllFilesPresentInExtensionFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/extensionFunction"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("extensionForSuperclass.kt")
        public void testExtensionForSuperclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionForSuperclass.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionFunctionCalledFromExtensionFunction.kt")
        public void testExtensionFunctionCalledFromExtensionFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionFunctionCalledFromExtensionFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionFunctionCalledFromFor.kt")
        public void testExtensionFunctionCalledFromFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionFunctionCalledFromFor.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionFunctionOnExpression.kt")
        public void testExtensionFunctionOnExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionFunctionOnExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionInsideFunctionLiteral.kt")
        public void testExtensionInsideFunctionLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionInsideFunctionLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionLiteralPassedToFunction.kt")
        public void testExtensionLiteralPassedToFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionLiteralPassedToFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionOnClassWithExplicitAndImplicitReceiver.kt")
        public void testExtensionOnClassWithExplicitAndImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionOnClassWithExplicitAndImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionPropertyOnClassWithExplicitAndImplicitReceiver.kt")
        public void testExtensionPropertyOnClassWithExplicitAndImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionPropertyOnClassWithExplicitAndImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionUsedInsideClass.kt")
        public void testExtensionUsedInsideClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionUsedInsideClass.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionWithImplicitReceiver.kt")
        public void testExtensionWithImplicitReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/extensionWithImplicitReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/generic.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitReceiverInExtension.kt")
        public void testImplicitReceiverInExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/implicitReceiverInExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("intExtension.kt")
        public void testIntExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/intExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("superClassMemberInExtension.kt")
        public void testSuperClassMemberInExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/superClassMemberInExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("virtualExtension.kt")
        public void testVirtualExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/virtualExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("virtualExtensionOverride.kt")
        public void testVirtualExtensionOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionFunction/virtualExtensionOverride.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/extensionProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtensionProperty extends AbstractBoxJsTest {
        @TestMetadata("absExtension.kt")
        public void testAbsExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionProperty/absExtension.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInExtensionProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/extensionProperty"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("externalExtensionProperty.kt")
        public void testExternalExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionProperty/externalExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionProperty/inClass.kt");
            doTest(fileName);
        }

        @TestMetadata("privateExtensionProperty.kt")
        public void testPrivateExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionProperty/privateExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithGetterAndSetter.kt")
        public void testPropertyWithGetterAndSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionProperty/propertyWithGetterAndSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("simplePropertyWithGetter.kt")
        public void testSimplePropertyWithGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/extensionProperty/simplePropertyWithGetter.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/inheritance")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inheritance extends AbstractBoxJsTest {
        @TestMetadata("abstractVarOverride.kt")
        public void testAbstractVarOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/abstractVarOverride.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInInheritance() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/inheritance"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("baseCall.kt")
        public void testBaseCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/baseCall.kt");
            doTest(fileName);
        }

        @TestMetadata("baseCallOrder.kt")
        public void testBaseCallOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/baseCallOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("baseClassDefinedAfterDerived.kt")
        public void testBaseClassDefinedAfterDerived() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/baseClassDefinedAfterDerived.kt");
            doTest(fileName);
        }

        @TestMetadata("complexInitializationOrder.kt")
        public void testComplexInitializationOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/complexInitializationOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("definitionOrder.kt")
        public void testDefinitionOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/definitionOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("fromFakeClasses.kt")
        public void testFromFakeClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/fromFakeClasses.kt");
            doTest(fileName);
        }

        @TestMetadata("fromNativeInterface.kt")
        public void testFromNativeInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/fromNativeInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("fromNestedNativeClass.kt")
        public void testFromNestedNativeClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/fromNestedNativeClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritFromCharIterator.kt")
        public void testInheritFromCharIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/inheritFromCharIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("initializationOrder.kt")
        public void testInitializationOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/initializationOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("initializersOfBasicClassExecute.kt")
        public void testInitializersOfBasicClassExecute() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/initializersOfBasicClassExecute.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3499.kt")
        public void testKt3499() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/kt3499.kt");
            doTest(fileName);
        }

        @TestMetadata("methodOverride.kt")
        public void testMethodOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/methodOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("nativeNativeKotlin.kt")
        public void testNativeNativeKotlin() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/nativeNativeKotlin.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideAnyMethods.kt")
        public void testOverrideAnyMethods() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/overrideAnyMethods.kt");
            doTest(fileName);
        }

        @TestMetadata("valOverride.kt")
        public void testValOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/valOverride.kt");
            doTest(fileName);
        }

        @TestMetadata("valuePassedToAncestorConstructor.kt")
        public void testValuePassedToAncestorConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/valuePassedToAncestorConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("withInitializeMethod.kt")
        public void testWithInitializeMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/withInitializeMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("js/js.translator/testData/box/inheritance/interfaces")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Interfaces extends AbstractBoxJsTest {
            @TestMetadata("abstractClassInheritingDefaultMethod.kt")
            public void testAbstractClassInheritingDefaultMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/interfaces/abstractClassInheritingDefaultMethod.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInInterfaces() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/inheritance/interfaces"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("withDefaultMethod.kt")
            public void testWithDefaultMethod() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/interfaces/withDefaultMethod.kt");
                doTest(fileName);
            }

            @TestMetadata("withDefaultMethodFromSuperInterface.kt")
            public void testWithDefaultMethodFromSuperInterface() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/interfaces/withDefaultMethodFromSuperInterface.kt");
                doTest(fileName);
            }

            @TestMetadata("withDefaultProperty.kt")
            public void testWithDefaultProperty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inheritance/interfaces/withDefaultProperty.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("js/js.translator/testData/box/initialize")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Initialize extends AbstractBoxJsTest {
        public void testAllFilesPresentInInitialize() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/initialize"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classInitializer.kt")
        public void testClassInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/initialize/classInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("complexPropertyInitializer.kt")
        public void testComplexPropertyInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/initialize/complexPropertyInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("complexTopLevelPropertyInitializer.kt")
        public void testComplexTopLevelPropertyInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/initialize/complexTopLevelPropertyInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("declarationInitializedWithThrow.kt")
        public void testDeclarationInitializedWithThrow() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/initialize/declarationInitializedWithThrow.kt");
            doTest(fileName);
        }

        @TestMetadata("rootPackageValInit.kt")
        public void testRootPackageValInit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/initialize/rootPackageValInit.kt");
            doTest(fileName);
        }

        @TestMetadata("rootValInit.kt")
        public void testRootValInit() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/initialize/rootValInit.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/inline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inline extends AbstractBoxJsTest {
        public void testAllFilesPresentInInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/inline"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousFunction.kt")
        public void testAnonymousFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/anonymousFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectInlineMethod.kt")
        public void testAnonymousObjectInlineMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/anonymousObjectInlineMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayLiteralAliasing.kt")
        public void testArrayLiteralAliasing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/arrayLiteralAliasing.kt");
            doTest(fileName);
        }

        @TestMetadata("astCopy.kt")
        public void testAstCopy() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/astCopy.kt");
            doTest(fileName);
        }

        @TestMetadata("callInlineFunctionOnTopLevel.kt")
        public void testCallInlineFunctionOnTopLevel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/callInlineFunctionOnTopLevel.kt");
            doTest(fileName);
        }

        @TestMetadata("callInlineFunctionOnTopLevelSimple.kt")
        public void testCallInlineFunctionOnTopLevelSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/callInlineFunctionOnTopLevelSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("callableReference.kt")
        public void testCallableReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/callableReference.kt");
            doTest(fileName);
        }

        @TestMetadata("callableReferenceOfLocalInline.kt")
        public void testCallableReferenceOfLocalInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/callableReferenceOfLocalInline.kt");
            doTest(fileName);
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/classObject.kt");
            doTest(fileName);
        }

        @TestMetadata("dontInlineFunctionCall.kt")
        public void testDontInlineFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/dontInlineFunctionCall.kt");
            doTest(fileName);
        }

        @TestMetadata("expressionBodyWithLambdaCall.kt")
        public void testExpressionBodyWithLambdaCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/expressionBodyWithLambdaCall.kt");
            doTest(fileName);
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/extension.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionWithManyArguments.kt")
        public void testExtensionWithManyArguments() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/extensionWithManyArguments.kt");
            doTest(fileName);
        }

        @TestMetadata("identityEquals.kt")
        public void testIdentityEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/identityEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("incrementProperty.kt")
        public void testIncrementProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/incrementProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineCallNoInline.kt")
        public void testInlineCallNoInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineCallNoInline.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineCapturingThis.kt")
        public void testInlineCapturingThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineCapturingThis.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineChain.kt")
        public void testInlineChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineChain.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineChainWithFewStatements.kt")
        public void testInlineChainWithFewStatements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineChainWithFewStatements.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineDefaultArgument.kt")
        public void testInlineDefaultArgument() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineDefaultArgument.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineFunctionInLambda.kt")
        public void testInlineFunctionInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineFunctionInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineGenericSimple.kt")
        public void testInlineGenericSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineGenericSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineIf.kt")
        public void testInlineIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineIf.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineInc.kt")
        public void testInlineInc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineInc.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineIntSimple.kt")
        public void testInlineIntSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineIntSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineLambdaNoCapture.kt")
        public void testInlineLambdaNoCapture() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineLambdaNoCapture.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineLambdaWithCapture.kt")
        public void testInlineLambdaWithCapture() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineLambdaWithCapture.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineMethod.kt")
        public void testInlineMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineNoReturn.kt")
        public void testInlineNoReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineNoReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineOrder.kt")
        public void testInlineOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineSimpleAssignment.kt")
        public void testInlineSimpleAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/inlineSimpleAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("innerOuterThis.kt")
        public void testInnerOuterThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/innerOuterThis.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratorOnInlineFunctionResult.kt")
        public void testIteratorOnInlineFunctionResult() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/iteratorOnInlineFunctionResult.kt");
            doTest(fileName);
        }

        @TestMetadata("jsCode.kt")
        public void testJsCode() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/jsCode.kt");
            doTest(fileName);
        }

        @TestMetadata("jsCodeVarDeclared.kt")
        public void testJsCodeVarDeclared() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/jsCodeVarDeclared.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaInLambda.kt")
        public void testLambdaInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/lambdaInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaReassignment.kt")
        public void testLambdaReassignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/lambdaReassignment.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaReassignmentWithCapture.kt")
        public void testLambdaReassignmentWithCapture() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/lambdaReassignmentWithCapture.kt");
            doTest(fileName);
        }

        @TestMetadata("localInlineExtensionFunction.kt")
        public void testLocalInlineExtensionFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/localInlineExtensionFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("localInlineFunction.kt")
        public void testLocalInlineFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/localInlineFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("localInlineFunctionComplex.kt")
        public void testLocalInlineFunctionComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/localInlineFunctionComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("localInlineFunctionDeclaredInLambda.kt")
        public void testLocalInlineFunctionDeclaredInLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/localInlineFunctionDeclaredInLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("localInlineFunctionNameClash.kt")
        public void testLocalInlineFunctionNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/localInlineFunctionNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("localInlineFunctionReference.kt")
        public void testLocalInlineFunctionReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/localInlineFunctionReference.kt");
            doTest(fileName);
        }

        @TestMetadata("metadataForPublicFunction.kt")
        public void testMetadataForPublicFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/metadataForPublicFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("multiDeclaration.kt")
        public void testMultiDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/multiDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("noInlineLambda.kt")
        public void testNoInlineLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/noInlineLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("params.kt")
        public void testParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/params.kt");
            doTest(fileName);
        }

        @TestMetadata("rootConstructor.kt")
        public void testRootConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/rootConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/safeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("severalClosures.kt")
        public void testSeveralClosures() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/severalClosures.kt");
            doTest(fileName);
        }

        @TestMetadata("severalUsage.kt")
        public void testSeveralUsage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/severalUsage.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleDouble.kt")
        public void testSimpleDouble() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/simpleDouble.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/simpleEnum.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInt.kt")
        public void testSimpleInt() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/simpleInt.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleLambda.kt")
        public void testSimpleLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/simpleLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/simpleObject.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleReturnFunctionWithResultUnused.kt")
        public void testSimpleReturnFunctionWithResultUnused() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/simpleReturnFunctionWithResultUnused.kt");
            doTest(fileName);
        }

        @TestMetadata("statementsAfterReturn.kt")
        public void testStatementsAfterReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/statementsAfterReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("thisImplicitlyCaptured.kt")
        public void testThisImplicitlyCaptured() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/thisImplicitlyCaptured.kt");
            doTest(fileName);
        }

        @TestMetadata("thisLiteralAliasing.kt")
        public void testThisLiteralAliasing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/thisLiteralAliasing.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inline/vararg.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/inlineEvaluationOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineEvaluationOrder extends AbstractBoxJsTest {
        public void testAllFilesPresentInInlineEvaluationOrder() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/inlineEvaluationOrder"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentOfCall.kt")
        public void testArgumentOfCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/argumentOfCall.kt");
            doTest(fileName);
        }

        @TestMetadata("argumentOfCallMultipleInlineCalls.kt")
        public void testArgumentOfCallMultipleInlineCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/argumentOfCallMultipleInlineCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("argumentOfInlineCall.kt")
        public void testArgumentOfInlineCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/argumentOfInlineCall.kt");
            doTest(fileName);
        }

        @TestMetadata("argumentOfNew.kt")
        public void testArgumentOfNew() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/argumentOfNew.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayAccess1.kt")
        public void testArrayAccess1() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/arrayAccess1.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayAccess2.kt")
        public void testArrayAccess2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/arrayAccess2.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayAccess3.kt")
        public void testArrayAccess3() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/arrayAccess3.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayAccessLhsDecomposed.kt")
        public void testArrayAccessLhsDecomposed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/arrayAccessLhsDecomposed.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayLiteral.kt")
        public void testArrayLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/arrayLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayLiteralMultipleInlineCalls.kt")
        public void testArrayLiteralMultipleInlineCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/arrayLiteralMultipleInlineCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayLiteralNested.kt")
        public void testArrayLiteralNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/arrayLiteralNested.kt");
            doTest(fileName);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/assignment.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryOperator.kt")
        public void testBinaryOperator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/binaryOperator.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryOperatorMultipleInlineCalls.kt")
        public void testBinaryOperatorMultipleInlineCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/binaryOperatorMultipleInlineCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("callQualifier.kt")
        public void testCallQualifier() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/callQualifier.kt");
            doTest(fileName);
        }

        @TestMetadata("callQualifierComplex.kt")
        public void testCallQualifierComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/callQualifierComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("conditional.kt")
        public void testConditional() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/conditional.kt");
            doTest(fileName);
        }

        @TestMetadata("conditionalElvis.kt")
        public void testConditionalElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/conditionalElvis.kt");
            doTest(fileName);
        }

        @TestMetadata("conditionalNested.kt")
        public void testConditionalNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/conditionalNested.kt");
            doTest(fileName);
        }

        @TestMetadata("conditionalTestExpression.kt")
        public void testConditionalTestExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/conditionalTestExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("conditionalTestExpressionElvis.kt")
        public void testConditionalTestExpressionElvis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/conditionalTestExpressionElvis.kt");
            doTest(fileName);
        }

        @TestMetadata("continueInExtractedDoWhile.kt")
        public void testContinueInExtractedDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/continueInExtractedDoWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/doWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhileComplex.kt")
        public void testDoWhileComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/doWhileComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("for.kt")
        public void testFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/for.kt");
            doTest(fileName);
        }

        @TestMetadata("if.kt")
        public void testIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/if.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineFunctionAsParameterOfQualifiedCall.kt")
        public void testInlineFunctionAsParameterOfQualifiedCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/inlineFunctionAsParameterOfQualifiedCall.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaPropertyExtracted.kt")
        public void testLambdaPropertyExtracted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/lambdaPropertyExtracted.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithClosure.kt")
        public void testLambdaWithClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/lambdaWithClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("logicalAnd.kt")
        public void testLogicalAnd() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/logicalAnd.kt");
            doTest(fileName);
        }

        @TestMetadata("logicalAndOrMultipleInlineCalls.kt")
        public void testLogicalAndOrMultipleInlineCalls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/logicalAndOrMultipleInlineCalls.kt");
            doTest(fileName);
        }

        @TestMetadata("logicalOr.kt")
        public void testLogicalOr() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/logicalOr.kt");
            doTest(fileName);
        }

        @TestMetadata("methodCallQualifierWithSideEffect.kt")
        public void testMethodCallQualifierWithSideEffect() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/methodCallQualifierWithSideEffect.kt");
            doTest(fileName);
        }

        @TestMetadata("methodDecomposedWithBind.kt")
        public void testMethodDecomposedWithBind() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/methodDecomposedWithBind.kt");
            doTest(fileName);
        }

        @TestMetadata("methodInlineCallQualifierWithSideEffect.kt")
        public void testMethodInlineCallQualifierWithSideEffect() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/methodInlineCallQualifierWithSideEffect.kt");
            doTest(fileName);
        }

        @TestMetadata("multiDeclaration.kt")
        public void testMultiDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/multiDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("multiDeclarationComplex.kt")
        public void testMultiDeclarationComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/multiDeclarationComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedContinueInExtractedDoWhile.kt")
        public void testNestedContinueInExtractedDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/nestedContinueInExtractedDoWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedInlineCall.kt")
        public void testNestedInlineCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/nestedInlineCall.kt");
            doTest(fileName);
        }

        @TestMetadata("propertiesInitializationOrder.kt")
        public void testPropertiesInitializationOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/propertiesInitializationOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("propertiesInitializationOrderSimple.kt")
        public void testPropertiesInitializationOrderSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/propertiesInitializationOrderSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessAfterModification.kt")
        public void testPropertyAccessAfterModification() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/propertyAccessAfterModification.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessAndInitializer.kt")
        public void testPropertyAccessAndInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/propertyAccessAndInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccessWithSideEffect.kt")
        public void testPropertyAccessWithSideEffect() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/propertyAccessWithSideEffect.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithSideEffectExtracted.kt")
        public void testPropertyWithSideEffectExtracted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/propertyWithSideEffectExtracted.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyWithSideEffectPassedToInlineFunction.kt")
        public void testPropertyWithSideEffectPassedToInlineFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/propertyWithSideEffectPassedToInlineFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("ternaryConditional.kt")
        public void testTernaryConditional() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/ternaryConditional.kt");
            doTest(fileName);
        }

        @TestMetadata("while.kt")
        public void testWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/while.kt");
            doTest(fileName);
        }

        @TestMetadata("whileComplex.kt")
        public void testWhileComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/whileComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("whileConditionExtracted.kt")
        public void testWhileConditionExtracted() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineEvaluationOrder/whileConditionExtracted.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/inlineMultiFile")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineMultiFile extends AbstractBoxJsTest {
        public void testAllFilesPresentInInlineMultiFile() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/inlineMultiFile"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObjectOnCallSite.kt")
        public void testAnonymousObjectOnCallSite() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/anonymousObjectOnCallSite.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectOnCallSiteSuperParams.kt")
        public void testAnonymousObjectOnCallSiteSuperParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/anonymousObjectOnCallSiteSuperParams.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectOnDeclarationSite.kt")
        public void testAnonymousObjectOnDeclarationSite() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/anonymousObjectOnDeclarationSite.kt");
            doTest(fileName);
        }

        @TestMetadata("anonymousObjectOnDeclarationSiteSuperParams.kt")
        public void testAnonymousObjectOnDeclarationSiteSuperParams() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/anonymousObjectOnDeclarationSiteSuperParams.kt");
            doTest(fileName);
        }

        @TestMetadata("builders.kt")
        public void testBuilders() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/builders.kt");
            doTest(fileName);
        }

        @TestMetadata("buildersAndLambdaCapturing.kt")
        public void testBuildersAndLambdaCapturing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/buildersAndLambdaCapturing.kt");
            doTest(fileName);
        }

        @TestMetadata("captureInlinable.kt")
        public void testCaptureInlinable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/captureInlinable.kt");
            doTest(fileName);
        }

        @TestMetadata("captureInlinableAndOther.kt")
        public void testCaptureInlinableAndOther() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/captureInlinableAndOther.kt");
            doTest(fileName);
        }

        @TestMetadata("captureThisAndReceiver.kt")
        public void testCaptureThisAndReceiver() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/captureThisAndReceiver.kt");
            doTest(fileName);
        }

        @TestMetadata("closureChain.kt")
        public void testClosureChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/closureChain.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultMethod.kt")
        public void testDefaultMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/defaultMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/generics.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineInDefaultParameter.kt")
        public void testInlineInDefaultParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/inlineInDefaultParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineMultiFileSimple.kt")
        public void testInlineMultiFileSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/inlineMultiFileSimple.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaCloning.kt")
        public void testLambdaCloning() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/lambdaCloning.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaInLambda2.kt")
        public void testLambdaInLambda2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/lambdaInLambda2.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaInLambdaNoInline.kt")
        public void testLambdaInLambdaNoInline() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/lambdaInLambdaNoInline.kt");
            doTest(fileName);
        }

        @TestMetadata("regeneratedLambdaName.kt")
        public void testRegeneratedLambdaName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/regeneratedLambdaName.kt");
            doTest(fileName);
        }

        @TestMetadata("sameCaptured.kt")
        public void testSameCaptured() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/sameCaptured.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleCapturingInClass.kt")
        public void testSimpleCapturingInClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/simpleCapturingInClass.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleCapturingInPackage.kt")
        public void testSimpleCapturingInPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/simpleCapturingInPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleDefaultMethod.kt")
        public void testSimpleDefaultMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/simpleDefaultMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("trait.kt")
        public void testTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/trait.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/tryCatch.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatch2.kt")
        public void testTryCatch2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/tryCatch2.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/tryCatchFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("use.kt")
        public void testUse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/use.kt");
            doTest(fileName);
        }

        @TestMetadata("with.kt")
        public void testWith() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiFile/with.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/inlineMultiModule")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineMultiModule extends AbstractBoxJsTest {
        public void testAllFilesPresentInInlineMultiModule() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/inlineMultiModule"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anotherModuleValInClosure.kt")
        public void testAnotherModuleValInClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/anotherModuleValInClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("callableReference.kt")
        public void testCallableReference() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/callableReference.kt");
            doTest(fileName);
        }

        @TestMetadata("calledByFqName.kt")
        public void testCalledByFqName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/calledByFqName.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionLambda.kt")
        public void testExtensionLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/extensionLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("externalInlineCallDecomposed.kt")
        public void testExternalInlineCallDecomposed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/externalInlineCallDecomposed.kt");
            doTest(fileName);
        }

        @TestMetadata("externalInlineNewDecomposed.kt")
        public void testExternalInlineNewDecomposed() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/externalInlineNewDecomposed.kt");
            doTest(fileName);
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/lambda.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaCalledInObjectLiteral.kt")
        public void testLambdaCalledInObjectLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/lambdaCalledInObjectLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaWithClosure.kt")
        public void testLambdaWithClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/lambdaWithClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("localNameClash.kt")
        public void testLocalNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/localNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("method.kt")
        public void testMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/method.kt");
            doTest(fileName);
        }

        @TestMetadata("parameterWithDefaultValue.kt")
        public void testParameterWithDefaultValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/parameterWithDefaultValue.kt");
            doTest(fileName);
        }

        @TestMetadata("property.kt")
        public void testProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/property.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("typealiases.kt")
        public void testTypealiases() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineMultiModule/typealiases.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/inlineSizeReduction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineSizeReduction extends AbstractBoxJsTest {
        public void testAllFilesPresentInInlineSizeReduction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/inlineSizeReduction"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inlineImportCleanup.kt")
        public void testInlineImportCleanup() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/inlineImportCleanup.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineLambdaCleanup.kt")
        public void testInlineLambdaCleanup() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/inlineLambdaCleanup.kt");
            doTest(fileName);
        }

        @TestMetadata("inlineOrder.kt")
        public void testInlineOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/inlineOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("lastBreak.kt")
        public void testLastBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/lastBreak.kt");
            doTest(fileName);
        }

        @TestMetadata("noDuplicateVariableDeclaration.kt")
        public void testNoDuplicateVariableDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/noDuplicateVariableDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("oneTopLevelReturn.kt")
        public void testOneTopLevelReturn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/oneTopLevelReturn.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAssignment.kt")
        public void testPropertyAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/propertyAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyReferenceDoesNotProduceSideEffect.kt")
        public void testPropertyReferenceDoesNotProduceSideEffect() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/propertyReferenceDoesNotProduceSideEffect.kt");
            doTest(fileName);
        }

        @TestMetadata("returnInlineCall.kt")
        public void testReturnInlineCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/returnInlineCall.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleReturnFunction.kt")
        public void testSimpleReturnFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/simpleReturnFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("ternaryConditional.kt")
        public void testTernaryConditional() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/ternaryConditional.kt");
            doTest(fileName);
        }

        @TestMetadata("this.kt")
        public void testThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/this.kt");
            doTest(fileName);
        }

        @TestMetadata("valAssignment.kt")
        public void testValAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/valAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("valDeclaration.kt")
        public void testValDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineSizeReduction/valDeclaration.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/inlineStdlib")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineStdlib extends AbstractBoxJsTest {
        public void testAllFilesPresentInInlineStdlib() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/inlineStdlib"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callNameClash.kt")
        public void testCallNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineStdlib/callNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("callableRefToFunInCurrentModule.kt")
        public void testCallableRefToFunInCurrentModule() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineStdlib/callableRefToFunInCurrentModule.kt");
            doTest(fileName);
        }

        @TestMetadata("closure.kt")
        public void testClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineStdlib/closure.kt");
            doTest(fileName);
        }

        @TestMetadata("closureInObjectLiteral.kt")
        public void testClosureInObjectLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineStdlib/closureInObjectLiteral.kt");
            doTest(fileName);
        }

        @TestMetadata("closureNested.kt")
        public void testClosureNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineStdlib/closureNested.kt");
            doTest(fileName);
        }

        @TestMetadata("localNamesClash.kt")
        public void testLocalNamesClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineStdlib/localNamesClash.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineStdlib/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("thisInExtension.kt")
        public void testThisInExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/inlineStdlib/thisInExtension.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/java")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Java extends AbstractBoxJsTest {
        public void testAllFilesPresentInJava() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/java"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("js/js.translator/testData/box/java/abstractList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AbstractList extends AbstractBoxJsTest {
            public void testAllFilesPresentInAbstractList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/java/abstractList"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("iterator.kt")
            public void testIterator() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/abstractList/iterator.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/java/arrayList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ArrayList extends AbstractBoxJsTest {
            @TestMetadata("access.kt")
            public void testAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/access.kt");
                doTest(fileName);
            }

            public void testAllFilesPresentInArrayList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/java/arrayList"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayAccess.kt")
            public void testArrayAccess() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/arrayAccess.kt");
                doTest(fileName);
            }

            @TestMetadata("constructWithCapacity.kt")
            public void testConstructWithCapacity() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/constructWithCapacity.kt");
                doTest(fileName);
            }

            @TestMetadata("constructWithSideEffectParam.kt")
            public void testConstructWithSideEffectParam() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/constructWithSideEffectParam.kt");
                doTest(fileName);
            }

            @TestMetadata("containsAll.kt")
            public void testContainsAll() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/containsAll.kt");
                doTest(fileName);
            }

            @TestMetadata("emptyList.kt")
            public void testEmptyList() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/emptyList.kt");
                doTest(fileName);
            }

            @TestMetadata("indexOOB.kt")
            public void testIndexOOB() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/indexOOB.kt");
                doTest(fileName);
            }

            @TestMetadata("indexOf.kt")
            public void testIndexOf() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/indexOf.kt");
                doTest(fileName);
            }

            @TestMetadata("isEmpty.kt")
            public void testIsEmpty() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/isEmpty.kt");
                doTest(fileName);
            }

            @TestMetadata("iterate.kt")
            public void testIterate() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/iterate.kt");
                doTest(fileName);
            }

            @TestMetadata("misc.kt")
            public void testMisc() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/misc.kt");
                doTest(fileName);
            }

            @TestMetadata("remove.kt")
            public void testRemove() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/remove.kt");
                doTest(fileName);
            }

            @TestMetadata("removeAll.kt")
            public void testRemoveAll() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/removeAll.kt");
                doTest(fileName);
            }

            @TestMetadata("removeWithIndexOutOfBounds.kt")
            public void testRemoveWithIndexOutOfBounds() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/removeWithIndexOutOfBounds.kt");
                doTest(fileName);
            }

            @TestMetadata("retainAll.kt")
            public void testRetainAll() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/retainAll.kt");
                doTest(fileName);
            }

            @TestMetadata("toArray.kt")
            public void testToArray() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/java/arrayList/toArray.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("js/js.translator/testData/box/jsCode")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JsCode extends AbstractBoxJsTest {
        public void testAllFilesPresentInJsCode() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/jsCode"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("break.kt")
        public void testBreak() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/break.kt");
            doTest(fileName);
        }

        @TestMetadata("catchScope.kt")
        public void testCatchScope() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/catchScope.kt");
            doTest(fileName);
        }

        @TestMetadata("codeFromVariable.kt")
        public void testCodeFromVariable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/codeFromVariable.kt");
            doTest(fileName);
        }

        @TestMetadata("continue.kt")
        public void testContinue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/continue.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/doWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("for.kt")
        public void testFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/for.kt");
            doTest(fileName);
        }

        @TestMetadata("forIn.kt")
        public void testForIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/forIn.kt");
            doTest(fileName);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/function.kt");
            doTest(fileName);
        }

        @TestMetadata("if.kt")
        public void testIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/if.kt");
            doTest(fileName);
        }

        @TestMetadata("invocation.kt")
        public void testInvocation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/invocation.kt");
            doTest(fileName);
        }

        @TestMetadata("label.kt")
        public void testLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/label.kt");
            doTest(fileName);
        }

        @TestMetadata("labelNestedClash.kt")
        public void testLabelNestedClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/labelNestedClash.kt");
            doTest(fileName);
        }

        @TestMetadata("labelNestedClashWithKotlin.kt")
        public void testLabelNestedClashWithKotlin() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/labelNestedClashWithKotlin.kt");
            doTest(fileName);
        }

        @TestMetadata("labelSiblingClash.kt")
        public void testLabelSiblingClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/labelSiblingClash.kt");
            doTest(fileName);
        }

        @TestMetadata("literal.kt")
        public void testLiteral() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/literal.kt");
            doTest(fileName);
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/object.kt");
            doTest(fileName);
        }

        @TestMetadata("objectScopes.kt")
        public void testObjectScopes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/objectScopes.kt");
            doTest(fileName);
        }

        @TestMetadata("operators.kt")
        public void testOperators() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/operators.kt");
            doTest(fileName);
        }

        @TestMetadata("quotes.kt")
        public void testQuotes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/quotes.kt");
            doTest(fileName);
        }

        @TestMetadata("switch.kt")
        public void testSwitch() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/switch.kt");
            doTest(fileName);
        }

        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/tryCatchFinally.kt");
            doTest(fileName);
        }

        @TestMetadata("while.kt")
        public void testWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsCode/while.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/jsName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JsName extends AbstractBoxJsTest {
        public void testAllFilesPresentInJsName() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/jsName"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("avoidNameClash.kt")
        public void testAvoidNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/avoidNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("classes.kt")
        public void testClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/classes.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritFromRenamedNativeClass.kt")
        public void testInheritFromRenamedNativeClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/inheritFromRenamedNativeClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritFromRenamedNativeClassMultimodule.kt")
        public void testInheritFromRenamedNativeClassMultimodule() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/inheritFromRenamedNativeClassMultimodule.kt");
            doTest(fileName);
        }

        @TestMetadata("jsName.kt")
        public void testJsName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/jsName.kt");
            doTest(fileName);
        }

        @TestMetadata("jsNamePropertyAccessors.kt")
        public void testJsNamePropertyAccessors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/jsNamePropertyAccessors.kt");
            doTest(fileName);
        }

        @TestMetadata("overriddenMethod.kt")
        public void testOverriddenMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/overriddenMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("overridenFromInterface.kt")
        public void testOverridenFromInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/overridenFromInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("privateMethod.kt")
        public void testPrivateMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/privateMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/secondaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleJsName.kt")
        public void testSimpleJsName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/jsName/simpleJsName.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/labels")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Labels extends AbstractBoxJsTest {
        public void testAllFilesPresentInLabels() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/labels"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("labelOnExpression.kt")
        public void testLabelOnExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/labelOnExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("labelWithVariableClashing.kt")
        public void testLabelWithVariableClashing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/labelWithVariableClashing.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedInlineLabels.kt")
        public void testNestedInlineLabels() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/nestedInlineLabels.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedLabels.kt")
        public void testNestedLabels() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/nestedLabels.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedLabelsInlinedClashing.kt")
        public void testNestedLabelsInlinedClashing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/nestedLabelsInlinedClashing.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedLabelsInlinedClashingAtFunctionsWithClosure.kt")
        public void testNestedLabelsInlinedClashingAtFunctionsWithClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/nestedLabelsInlinedClashingAtFunctionsWithClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("siblingLabels.kt")
        public void testSiblingLabels() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/siblingLabels.kt");
            doTest(fileName);
        }

        @TestMetadata("siblingLabelsInlined.kt")
        public void testSiblingLabelsInlined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/siblingLabelsInlined.kt");
            doTest(fileName);
        }

        @TestMetadata("siblingLabelsInlinedClashing.kt")
        public void testSiblingLabelsInlinedClashing() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/siblingLabelsInlinedClashing.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleLabel.kt")
        public void testSimpleLabel() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/simpleLabel.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleLabelInlined.kt")
        public void testSimpleLabelInlined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/labels/simpleLabelInlined.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/multiFile")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiFile extends AbstractBoxJsTest {
        public void testAllFilesPresentInMultiFile() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multiFile"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classOfTheSameNameInAnotherPackage.kt")
        public void testClassOfTheSameNameInAnotherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiFile/classOfTheSameNameInAnotherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("classesInheritedFromOtherFile.kt")
        public void testClassesInheritedFromOtherFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiFile/classesInheritedFromOtherFile.kt");
            doTest(fileName);
        }

        @TestMetadata("functionsVisibleFromOtherFile.kt")
        public void testFunctionsVisibleFromOtherFile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiFile/functionsVisibleFromOtherFile.kt");
            doTest(fileName);
        }

        @TestMetadata("importedDeclarationMangling.kt")
        public void testImportedDeclarationMangling() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiFile/importedDeclarationMangling.kt");
            doTest(fileName);
        }

        @TestMetadata("packageAndMangledMethodDoNotClash.kt")
        public void testPackageAndMangledMethodDoNotClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiFile/packageAndMangledMethodDoNotClash.kt");
            doTest(fileName);
        }

        @TestMetadata("packageAndPrivateDeclarationDoNotClash.kt")
        public void testPackageAndPrivateDeclarationDoNotClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiFile/packageAndPrivateDeclarationDoNotClash.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/multiModule")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiModule extends AbstractBoxJsTest {
        public void testAllFilesPresentInMultiModule() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multiModule"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("moduleAndVariableNameClash.kt")
        public void testModuleAndVariableNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModule/moduleAndVariableNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("privateInterfaceNameClash.kt")
        public void testPrivateInterfaceNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModule/privateInterfaceNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("privateNameClash.kt")
        public void testPrivateNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModule/privateNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("useElementsFromDefaultPackageInAnotherModule.kt")
        public void testUseElementsFromDefaultPackageInAnotherModule() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModule/useElementsFromDefaultPackageInAnotherModule.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/multiModuleWrappers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiModuleWrappers extends AbstractBoxJsTest {
        public void testAllFilesPresentInMultiModuleWrappers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multiModuleWrappers"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("js/js.translator/testData/box/multiModuleWrappers/amd")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Amd extends AbstractBoxJsTest {
            public void testAllFilesPresentInAmd() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multiModuleWrappers/amd"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("moduleWithNonIdentifierName.kt")
            public void testModuleWithNonIdentifierName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModuleWrappers/amd/moduleWithNonIdentifierName.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModuleWrappers/amd/simple.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/multiModuleWrappers/common_js")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Common_js extends AbstractBoxJsTest {
            public void testAllFilesPresentInCommon_js() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multiModuleWrappers/common_js"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("moduleWithNonIdentifierName.kt")
            public void testModuleWithNonIdentifierName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModuleWrappers/common_js/moduleWithNonIdentifierName.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModuleWrappers/common_js/simple.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/multiModuleWrappers/plain")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Plain extends AbstractBoxJsTest {
            public void testAllFilesPresentInPlain() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multiModuleWrappers/plain"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("moduleWithNonIdentifierName.kt")
            public void testModuleWithNonIdentifierName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModuleWrappers/plain/moduleWithNonIdentifierName.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModuleWrappers/plain/simple.kt");
                doTest(fileName);
            }
        }

        @TestMetadata("js/js.translator/testData/box/multiModuleWrappers/umd")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Umd extends AbstractBoxJsTest {
            public void testAllFilesPresentInUmd() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multiModuleWrappers/umd"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("moduleWithNonIdentifierName.kt")
            public void testModuleWithNonIdentifierName() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModuleWrappers/umd/moduleWithNonIdentifierName.kt");
                doTest(fileName);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiModuleWrappers/umd/simple.kt");
                doTest(fileName);
            }
        }
    }

    @TestMetadata("js/js.translator/testData/box/multiPackage")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultiPackage extends AbstractBoxJsTest {
        public void testAllFilesPresentInMultiPackage() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multiPackage"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classesInheritedFromOtherPackage.kt")
        public void testClassesInheritedFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/classesInheritedFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("createClassFromOtherPackage.kt")
        public void testCreateClassFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/createClassFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("createClassFromOtherPackageUsingImport.kt")
        public void testCreateClassFromOtherPackageUsingImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/createClassFromOtherPackageUsingImport.kt");
            doTest(fileName);
        }

        @TestMetadata("functionsVisibleFromOtherPackage.kt")
        public void testFunctionsVisibleFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/functionsVisibleFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedPackageFunctionCalledFromOtherPackage.kt")
        public void testNestedPackageFunctionCalledFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/nestedPackageFunctionCalledFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("packageVariableVisibleFromOtherPackage.kt")
        public void testPackageVariableVisibleFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/packageVariableVisibleFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("reflectionFromOtherPackage.kt")
        public void testReflectionFromOtherPackage() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/reflectionFromOtherPackage.kt");
            doTest(fileName);
        }

        @TestMetadata("subpackagesWithClashingNames.kt")
        public void testSubpackagesWithClashingNames() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/subpackagesWithClashingNames.kt");
            doTest(fileName);
        }

        @TestMetadata("subpackagesWithClashingNamesUsingImport.kt")
        public void testSubpackagesWithClashingNamesUsingImport() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multiPackage/subpackagesWithClashingNamesUsingImport.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/multideclaration")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Multideclaration extends AbstractBoxJsTest {
        public void testAllFilesPresentInMultideclaration() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/multideclaration"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multiValForArray.kt")
        public void testMultiValForArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multideclaration/multiValForArray.kt");
            doTest(fileName);
        }

        @TestMetadata("multiValForMap.kt")
        public void testMultiValForMap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multideclaration/multiValForMap.kt");
            doTest(fileName);
        }

        @TestMetadata("multiValForRange.kt")
        public void testMultiValForRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multideclaration/multiValForRange.kt");
            doTest(fileName);
        }

        @TestMetadata("multiValInFor.kt")
        public void testMultiValInFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multideclaration/multiValInFor.kt");
            doTest(fileName);
        }

        @TestMetadata("multiValInIntFor.kt")
        public void testMultiValInIntFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multideclaration/multiValInIntFor.kt");
            doTest(fileName);
        }

        @TestMetadata("multiValInIntRangeFor.kt")
        public void testMultiValInIntRangeFor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multideclaration/multiValInIntRangeFor.kt");
            doTest(fileName);
        }

        @TestMetadata("multiValOrVar.kt")
        public void testMultiValOrVar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/multideclaration/multiValOrVar.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/nameClashes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NameClashes extends AbstractBoxJsTest {
        public void testAllFilesPresentInNameClashes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/nameClashes"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classAndCompanionObjectMembers.kt")
        public void testClassAndCompanionObjectMembers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/classAndCompanionObjectMembers.kt");
            doTest(fileName);
        }

        @TestMetadata("differenceInCapitalization.kt")
        public void testDifferenceInCapitalization() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/differenceInCapitalization.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionFunctionAndProperty.kt")
        public void testExtensionFunctionAndProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/extensionFunctionAndProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionPropertiesWithDifferentReceivers.kt")
        public void testExtensionPropertiesWithDifferentReceivers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/extensionPropertiesWithDifferentReceivers.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionPropertyAndMethod.kt")
        public void testExtensionPropertyAndMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/extensionPropertyAndMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("jsNameAndPrivate.kt")
        public void testJsNameAndPrivate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/jsNameAndPrivate.kt");
            doTest(fileName);
        }

        @TestMetadata("methodAndPrivateProperty.kt")
        public void testMethodAndPrivateProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/methodAndPrivateProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("methodOverload.kt")
        public void testMethodOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/methodOverload.kt");
            doTest(fileName);
        }

        @TestMetadata("methodOverloadInClassWithTwoUpperBounds.kt")
        public void testMethodOverloadInClassWithTwoUpperBounds() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/methodOverloadInClassWithTwoUpperBounds.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadExtension.kt")
        public void testOverloadExtension() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/overloadExtension.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAndNativeMethod.kt")
        public void testPropertyAndNativeMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nameClashes/propertyAndNativeMethod.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/native")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Native extends AbstractBoxJsTest {
        public void testAllFilesPresentInNative() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/native"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("class.kt")
        public void testClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/class.kt");
            doTest(fileName);
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/classObject.kt");
            doTest(fileName);
        }

        @TestMetadata("eval.kt")
        public void testEval() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/eval.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritanceFromNativeClass.kt")
        public void testInheritanceFromNativeClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/inheritanceFromNativeClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritanceFromNativeTrait.kt")
        public void testInheritanceFromNativeTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/inheritanceFromNativeTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritanceInNativeClass.kt")
        public void testInheritanceInNativeClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/inheritanceInNativeClass.kt");
            doTest(fileName);
        }

        @TestMetadata("kt1519.kt")
        public void testKt1519() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/kt1519.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2209.kt")
        public void testKt2209() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/kt2209.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2323.kt")
        public void testKt2323() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/kt2323.kt");
            doTest(fileName);
        }

        @TestMetadata("library.kt")
        public void testLibrary() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/library.kt");
            doTest(fileName);
        }

        @TestMetadata("nativeExtensionLikeMember.kt")
        public void testNativeExtensionLikeMember() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/nativeExtensionLikeMember.kt");
            doTest(fileName);
        }

        @TestMetadata("nativeGetterAndNativeSetter.kt")
        public void testNativeGetterAndNativeSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/nativeGetterAndNativeSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("nativeInvoke.kt")
        public void testNativeInvoke() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/nativeInvoke.kt");
            doTest(fileName);
        }

        @TestMetadata("nativePropertyWithCustomName.kt")
        public void testNativePropertyWithCustomName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/nativePropertyWithCustomName.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedElements.kt")
        public void testNestedElements() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/nestedElements.kt");
            doTest(fileName);
        }

        @TestMetadata("passExtLambdaFromNative.kt")
        public void testPassExtLambdaFromNative() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/passExtLambdaFromNative.kt");
            doTest(fileName);
        }

        @TestMetadata("passExtLambdaToNative.kt")
        public void testPassExtLambdaToNative() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/passExtLambdaToNative.kt");
            doTest(fileName);
        }

        @TestMetadata("passMemberOrExtFromNative.kt")
        public void testPassMemberOrExtFromNative() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/passMemberOrExtFromNative.kt");
            doTest(fileName);
        }

        @TestMetadata("passMemberOrExtToNative.kt")
        public void testPassMemberOrExtToNative() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/passMemberOrExtToNative.kt");
            doTest(fileName);
        }

        @TestMetadata("passTopLevelFunctionFromNative.kt")
        public void testPassTopLevelFunctionFromNative() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/passTopLevelFunctionFromNative.kt");
            doTest(fileName);
        }

        @TestMetadata("passTopLevelOrLocalFunctionToNative.kt")
        public void testPassTopLevelOrLocalFunctionToNative() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/passTopLevelOrLocalFunctionToNative.kt");
            doTest(fileName);
        }

        @TestMetadata("print.kt")
        public void testPrint() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/print.kt");
            doTest(fileName);
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/secondaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/simple.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleUndefined.kt")
        public void testSimpleUndefined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/simpleUndefined.kt");
            doTest(fileName);
        }

        @TestMetadata("typeof.kt")
        public void testTypeof() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/typeof.kt");
            doTest(fileName);
        }

        @TestMetadata("undefined.kt")
        public void testUndefined() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/undefined.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/native/vararg.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/nestedTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NestedTypes extends AbstractBoxJsTest {
        public void testAllFilesPresentInNestedTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/nestedTypes"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("implicitOuterThisFromLambda.kt")
        public void testImplicitOuterThisFromLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/implicitOuterThisFromLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("implicitOuterThisFromLocalClass.kt")
        public void testImplicitOuterThisFromLocalClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/implicitOuterThisFromLocalClass.kt");
            doTest(fileName);
        }

        @TestMetadata("inheritanceFromNestedBuiltIn.kt")
        public void testInheritanceFromNestedBuiltIn() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/inheritanceFromNestedBuiltIn.kt");
            doTest(fileName);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/inner.kt");
            doTest(fileName);
        }

        @TestMetadata("innerObjectRefFromConstructor.kt")
        public void testInnerObjectRefFromConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/innerObjectRefFromConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("innerReferenceFromChild.kt")
        public void testInnerReferenceFromChild() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/innerReferenceFromChild.kt");
            doTest(fileName);
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/nested.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedInInterface.kt")
        public void testNestedInInterface() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/nestedInInterface.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedObjectLazyInitialized.kt")
        public void testNestedObjectLazyInitialized() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/nestedObjectLazyInitialized.kt");
            doTest(fileName);
        }

        @TestMetadata("outerClassReferenceFromSecondaryConstructor.kt")
        public void testOuterClassReferenceFromSecondaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/outerClassReferenceFromSecondaryConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("outerCompanion.kt")
        public void testOuterCompanion() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/outerCompanion.kt");
            doTest(fileName);
        }

        @TestMetadata("outerNative.kt")
        public void testOuterNative() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/outerNative.kt");
            doTest(fileName);
        }

        @TestMetadata("outerObject.kt")
        public void testOuterObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/outerObject.kt");
            doTest(fileName);
        }

        @TestMetadata("outerThis.kt")
        public void testOuterThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/outerThis.kt");
            doTest(fileName);
        }

        @TestMetadata("privateFieldNotOverridenInNestedSubclass.kt")
        public void testPrivateFieldNotOverridenInNestedSubclass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/privateFieldNotOverridenInNestedSubclass.kt");
            doTest(fileName);
        }

        @TestMetadata("receivers.kt")
        public void testReceivers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/nestedTypes/receivers.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/number")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Number extends AbstractBoxJsTest {
        public void testAllFilesPresentInNumber() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/number"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("byteAndShortConversions.kt")
        public void testByteAndShortConversions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/byteAndShortConversions.kt");
            doTest(fileName);
        }

        @TestMetadata("conversionsWithTruncation.kt")
        public void testConversionsWithTruncation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/conversionsWithTruncation.kt");
            doTest(fileName);
        }

        @TestMetadata("conversionsWithoutTruncation.kt")
        public void testConversionsWithoutTruncation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/conversionsWithoutTruncation.kt");
            doTest(fileName);
        }

        @TestMetadata("division.kt")
        public void testDivision() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/division.kt");
            doTest(fileName);
        }

        @TestMetadata("doubleConversions.kt")
        public void testDoubleConversions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/doubleConversions.kt");
            doTest(fileName);
        }

        @TestMetadata("hexadecimalConstant.kt")
        public void testHexadecimalConstant() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/hexadecimalConstant.kt");
            doTest(fileName);
        }

        @TestMetadata("intConversions.kt")
        public void testIntConversions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/intConversions.kt");
            doTest(fileName);
        }

        @TestMetadata("intDivFloat.kt")
        public void testIntDivFloat() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/intDivFloat.kt");
            doTest(fileName);
        }

        @TestMetadata("kt2342.kt")
        public void testKt2342() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/kt2342.kt");
            doTest(fileName);
        }

        @TestMetadata("longArray.kt")
        public void testLongArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/longArray.kt");
            doTest(fileName);
        }

        @TestMetadata("longBinaryOperations.kt")
        public void testLongBinaryOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/longBinaryOperations.kt");
            doTest(fileName);
        }

        @TestMetadata("longBitOperations.kt")
        public void testLongBitOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/longBitOperations.kt");
            doTest(fileName);
        }

        @TestMetadata("longCompareToIntrinsic.kt")
        public void testLongCompareToIntrinsic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/longCompareToIntrinsic.kt");
            doTest(fileName);
        }

        @TestMetadata("longEqualsIntrinsic.kt")
        public void testLongEqualsIntrinsic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/longEqualsIntrinsic.kt");
            doTest(fileName);
        }

        @TestMetadata("longHashCode.kt")
        public void testLongHashCode() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/longHashCode.kt");
            doTest(fileName);
        }

        @TestMetadata("longUnaryOperations.kt")
        public void testLongUnaryOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/longUnaryOperations.kt");
            doTest(fileName);
        }

        @TestMetadata("numberCompareTo.kt")
        public void testNumberCompareTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/numberCompareTo.kt");
            doTest(fileName);
        }

        @TestMetadata("numberConversions.kt")
        public void testNumberConversions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/numberConversions.kt");
            doTest(fileName);
        }

        @TestMetadata("numberIncDec.kt")
        public void testNumberIncDec() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/numberIncDec.kt");
            doTest(fileName);
        }

        @TestMetadata("numberIsCheck.kt")
        public void testNumberIsCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/number/numberIsCheck.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/objectDeclaration")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ObjectDeclaration extends AbstractBoxJsTest {
        public void testAllFilesPresentInObjectDeclaration() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/objectDeclaration"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dontPolluteObject.kt")
        public void testDontPolluteObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/dontPolluteObject.kt");
            doTest(fileName);
        }

        @TestMetadata("kt3684.kt")
        public void testKt3684() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/kt3684.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaInObjectInsideObject.kt")
        public void testLambdaInObjectInsideObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/lambdaInObjectInsideObject.kt");
            doTest(fileName);
        }

        @TestMetadata("objectDeclaration.kt")
        public void testObjectDeclaration() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/objectDeclaration.kt");
            doTest(fileName);
        }

        @TestMetadata("objectDeclarationWithVars.kt")
        public void testObjectDeclarationWithVars() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/objectDeclarationWithVars.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInMethod.kt")
        public void testObjectInMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/objectInMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInObject.kt")
        public void testObjectInObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/objectInObject.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInObjectWithClosure.kt")
        public void testObjectInObjectWithClosure() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/objectInObjectWithClosure.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInheritingFromATrait.kt")
        public void testObjectInheritingFromATrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/objectInheritingFromATrait.kt");
            doTest(fileName);
        }

        @TestMetadata("objectInheritingFromClass.kt")
        public void testObjectInheritingFromClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/objectInheritingFromClass.kt");
            doTest(fileName);
        }

        @TestMetadata("objectWithMethods.kt")
        public void testObjectWithMethods() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/objectDeclaration/objectWithMethods.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/operatorOverloading")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class OperatorOverloading extends AbstractBoxJsTest {
        public void testAllFilesPresentInOperatorOverloading() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/operatorOverloading"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("augmentedAssignmentLhs.kt")
        public void testAugmentedAssignmentLhs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/augmentedAssignmentLhs.kt");
            doTest(fileName);
        }

        @TestMetadata("binaryDivOverload.kt")
        public void testBinaryDivOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/binaryDivOverload.kt");
            doTest(fileName);
        }

        @TestMetadata("compareTo.kt")
        public void testCompareTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/compareTo.kt");
            doTest(fileName);
        }

        @TestMetadata("compareToByName.kt")
        public void testCompareToByName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/compareToByName.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaRhs.kt")
        public void testLambdaRhs() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/lambdaRhs.kt");
            doTest(fileName);
        }

        @TestMetadata("notOverload.kt")
        public void testNotOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/notOverload.kt");
            doTest(fileName);
        }

        @TestMetadata("operatorOverloadOnPropertyCallGetterAndSetterOnlyOnce.kt")
        public void testOperatorOverloadOnPropertyCallGetterAndSetterOnlyOnce() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/operatorOverloadOnPropertyCallGetterAndSetterOnlyOnce.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusAssignArrayList.kt")
        public void testOverloadPlusAssignArrayList() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/overloadPlusAssignArrayList.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusAssignViaExtensionFunction.kt")
        public void testOverloadPlusAssignViaExtensionFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/overloadPlusAssignViaExtensionFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusAssignViaPlusExtensionFunction.kt")
        public void testOverloadPlusAssignViaPlusExtensionFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/overloadPlusAssignViaPlusExtensionFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPlusViaExtensionFunction.kt")
        public void testOverloadPlusViaExtensionFunction() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/overloadPlusViaExtensionFunction.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadUnaryOperationsViaExtensionFunctions.kt")
        public void testOverloadUnaryOperationsViaExtensionFunctions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/overloadUnaryOperationsViaExtensionFunctions.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadedCallOnProperty.kt")
        public void testOverloadedCallOnProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/overloadedCallOnProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("plusAndMinusAsAnExpression.kt")
        public void testPlusAndMinusAsAnExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/plusAndMinusAsAnExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("plusAssignNoReassign.kt")
        public void testPlusAssignNoReassign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/plusAssignNoReassign.kt");
            doTest(fileName);
        }

        @TestMetadata("plusOverload.kt")
        public void testPlusOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/plusOverload.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixInc.kt")
        public void testPostfixInc() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/postfixInc.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixOnProperty.kt")
        public void testPostfixOnProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/postfixOnProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixDecOverload.kt")
        public void testPrefixDecOverload() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/prefixDecOverload.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixIncReturnsCorrectValue.kt")
        public void testPrefixIncReturnsCorrectValue() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/prefixIncReturnsCorrectValue.kt");
            doTest(fileName);
        }

        @TestMetadata("unaryOnIntProperty.kt")
        public void testUnaryOnIntProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/unaryOnIntProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("unaryOnIntPropertyAsStatement.kt")
        public void testUnaryOnIntPropertyAsStatement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/unaryOnIntPropertyAsStatement.kt");
            doTest(fileName);
        }

        @TestMetadata("usingModInCaseModAssignNotAvailable.kt")
        public void testUsingModInCaseModAssignNotAvailable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/operatorOverloading/usingModInCaseModAssignNotAvailable.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/propertyAccess")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PropertyAccess extends AbstractBoxJsTest {
        @TestMetadata("accessToInstanceProperty.kt")
        public void testAccessToInstanceProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/accessToInstanceProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("accessorsWithJsName.kt")
        public void testAccessorsWithJsName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/accessorsWithJsName.kt");
            doTest(fileName);
        }

        public void testAllFilesPresentInPropertyAccess() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/propertyAccess"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classUsesPackageProperties.kt")
        public void testClassUsesPackageProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/classUsesPackageProperties.kt");
            doTest(fileName);
        }

        @TestMetadata("customGetter.kt")
        public void testCustomGetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/customGetter.kt");
            doTest(fileName);
        }

        @TestMetadata("customSetter.kt")
        public void testCustomSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/customSetter.kt");
            doTest(fileName);
        }

        @TestMetadata("defaultAccessorsWithJsName.kt")
        public void testDefaultAccessorsWithJsName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/defaultAccessorsWithJsName.kt");
            doTest(fileName);
        }

        @TestMetadata("enumerable.kt")
        public void testEnumerable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/enumerable.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionLiteralSafeCall.kt")
        public void testExtensionLiteralSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/extensionLiteralSafeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("field.kt")
        public void testField() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/field.kt");
            doTest(fileName);
        }

        @TestMetadata("initInstanceProperties.kt")
        public void testInitInstanceProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/initInstanceProperties.kt");
            doTest(fileName);
        }

        @TestMetadata("initValInConstructor.kt")
        public void testInitValInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/initValInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("nativePropertiesNameClashes.kt")
        public void testNativePropertiesNameClashes() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/nativePropertiesNameClashes.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadedOverriddenFunctionPropertyName.kt")
        public void testOverloadedOverriddenFunctionPropertyName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/overloadedOverriddenFunctionPropertyName.kt");
            doTest(fileName);
        }

        @TestMetadata("packageCustomAccessors.kt")
        public void testPackageCustomAccessors() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/packageCustomAccessors.kt");
            doTest(fileName);
        }

        @TestMetadata("packagePropertyInitializer.kt")
        public void testPackagePropertyInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/packagePropertyInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("packagePropertySet.kt")
        public void testPackagePropertySet() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/packagePropertySet.kt");
            doTest(fileName);
        }

        @TestMetadata("privatePropertyAccessFromMethod.kt")
        public void testPrivatePropertyAccessFromMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/privatePropertyAccessFromMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAssignment.kt")
        public void testPropertyAssignment() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/propertyAssignment.kt");
            doTest(fileName);
        }

        @TestMetadata("setter.kt")
        public void testSetter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/setter.kt");
            doTest(fileName);
        }

        @TestMetadata("staticAccessorsWithJsName.kt")
        public void testStaticAccessorsWithJsName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/staticAccessorsWithJsName.kt");
            doTest(fileName);
        }

        @TestMetadata("subclassAccessorsWithJsNameInSuper.kt")
        public void testSubclassAccessorsWithJsNameInSuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/subclassAccessorsWithJsNameInSuper.kt");
            doTest(fileName);
        }

        @TestMetadata("twoClassesWithProperties.kt")
        public void testTwoClassesWithProperties() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyAccess/twoClassesWithProperties.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/propertyOverride")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PropertyOverride extends AbstractBoxJsTest {
        public void testAllFilesPresentInPropertyOverride() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/propertyOverride"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("checkSupertypeOrder.kt")
        public void testCheckSupertypeOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/checkSupertypeOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("initOverrideInConstructor.kt")
        public void testInitOverrideInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/initOverrideInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("initOverrideInConstructorComplex.kt")
        public void testInitOverrideInConstructorComplex() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/initOverrideInConstructorComplex.kt");
            doTest(fileName);
        }

        @TestMetadata("initOverrideInConstructorExplicitThis.kt")
        public void testInitOverrideInConstructorExplicitThis() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/initOverrideInConstructorExplicitThis.kt");
            doTest(fileName);
        }

        @TestMetadata("initOverrideVarInConstructor.kt")
        public void testInitOverrideVarInConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/initOverrideVarInConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("overloadPrivateVal.kt")
        public void testOverloadPrivateVal() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/overloadPrivateVal.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideExtensionProperty.kt")
        public void testOverrideExtensionProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/overrideExtensionProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideNotDirectlySuper.kt")
        public void testOverrideNotDirectlySuper() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/overrideNotDirectlySuper.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideValFromTraits.kt")
        public void testOverrideValFromTraits() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/overrideValFromTraits.kt");
            doTest(fileName);
        }

        @TestMetadata("overrideValWithBackendFiled.kt")
        public void testOverrideValWithBackendFiled() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/overrideValWithBackendFiled.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleOverride.kt")
        public void testSimpleOverride() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/propertyOverride/simpleOverride.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/range")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Range extends AbstractBoxJsTest {
        public void testAllFilesPresentInRange() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/range"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("creatingProgressions.kt")
        public void testCreatingProgressions() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/creatingProgressions.kt");
            doTest(fileName);
        }

        @TestMetadata("explicitRange.kt")
        public void testExplicitRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/explicitRange.kt");
            doTest(fileName);
        }

        @TestMetadata("intDownTo.kt")
        public void testIntDownTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/intDownTo.kt");
            doTest(fileName);
        }

        @TestMetadata("intInRange.kt")
        public void testIntInRange() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/intInRange.kt");
            doTest(fileName);
        }

        @TestMetadata("intUpTo.kt")
        public void testIntUpTo() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/intUpTo.kt");
            doTest(fileName);
        }

        @TestMetadata("iteratingOverRanges.kt")
        public void testIteratingOverRanges() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/iteratingOverRanges.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeEquals.kt")
        public void testRangeEquals() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/rangeEquals.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeSugarSyntax.kt")
        public void testRangeSugarSyntax() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/rangeSugarSyntax.kt");
            doTest(fileName);
        }

        @TestMetadata("rangeToDoesNotIterate.kt")
        public void testRangeToDoesNotIterate() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/rangeToDoesNotIterate.kt");
            doTest(fileName);
        }

        @TestMetadata("reverse.kt")
        public void testReverse() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/range/reverse.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/reflection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reflection extends AbstractBoxJsTest {
        public void testAllFilesPresentInReflection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/reflection"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("jsClass.kt")
        public void testJsClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/jsClass.kt");
            doTest(fileName);
        }

        @TestMetadata("jsClassName.kt")
        public void testJsClassName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/jsClassName.kt");
            doTest(fileName);
        }

        @TestMetadata("jsClassOnReifiedType.kt")
        public void testJsClassOnReifiedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/jsClassOnReifiedType.kt");
            doTest(fileName);
        }

        @TestMetadata("jsClassSimpleName.kt")
        public void testJsClassSimpleName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/jsClassSimpleName.kt");
            doTest(fileName);
        }

        @TestMetadata("kClass.kt")
        public void testKClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/kClass.kt");
            doTest(fileName);
        }

        @TestMetadata("kClassIsInstance.kt")
        public void testKClassIsInstance() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/kClassIsInstance.kt");
            doTest(fileName);
        }

        @TestMetadata("kClassOnReifiedType.kt")
        public void testKClassOnReifiedType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/kClassOnReifiedType.kt");
            doTest(fileName);
        }

        @TestMetadata("kClassSimpleName.kt")
        public void testKClassSimpleName() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/kClassSimpleName.kt");
            doTest(fileName);
        }

        @TestMetadata("kClassToAndFromJsClass.kt")
        public void testKClassToAndFromJsClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reflection/kClassToAndFromJsClass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/regression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Regression extends AbstractBoxJsTest {
        public void testAllFilesPresentInRegression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/regression"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt2470.kt")
        public void testKt2470() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/regression/kt2470.kt");
            doTest(fileName);
        }

        @TestMetadata("tmpInsidePrimaryConstructor.kt")
        public void testTmpInsidePrimaryConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/regression/tmpInsidePrimaryConstructor.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/reified")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Reified extends AbstractBoxJsTest {
        public void testAllFilesPresentInReified() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/reified"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callChain.kt")
        public void testCallChain() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/callChain.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionFun.kt")
        public void testExtensionFun() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/extensionFun.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionLambda.kt")
        public void testExtensionLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/extensionLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("extensionMethod.kt")
        public void testExtensionMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/extensionMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("innerObject.kt")
        public void testInnerObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/innerObject.kt");
            doTest(fileName);
        }

        @TestMetadata("isBool.kt")
        public void testIsBool() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/isBool.kt");
            doTest(fileName);
        }

        @TestMetadata("isChar.kt")
        public void testIsChar() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/isChar.kt");
            doTest(fileName);
        }

        @TestMetadata("isClass.kt")
        public void testIsClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/isClass.kt");
            doTest(fileName);
        }

        @TestMetadata("isNumber.kt")
        public void testIsNumber() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/isNumber.kt");
            doTest(fileName);
        }

        @TestMetadata("isString.kt")
        public void testIsString() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/isString.kt");
            doTest(fileName);
        }

        @TestMetadata("isTNullable.kt")
        public void testIsTNullable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/isTNullable.kt");
            doTest(fileName);
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/lambda.kt");
            doTest(fileName);
        }

        @TestMetadata("lambdaNameClash.kt")
        public void testLambdaNameClash() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/lambdaNameClash.kt");
            doTest(fileName);
        }

        @TestMetadata("method.kt")
        public void testMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/method.kt");
            doTest(fileName);
        }

        @TestMetadata("multipleTypeParameters.kt")
        public void testMultipleTypeParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/multipleTypeParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("noValueParameters.kt")
        public void testNoValueParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/noValueParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("parameterSwap.kt")
        public void testParameterSwap() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/parameterSwap.kt");
            doTest(fileName);
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/vararg.kt");
            doTest(fileName);
        }

        @TestMetadata("withInlineTurnedOff.kt")
        public void testWithInlineTurnedOff() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/reified/withInlineTurnedOff.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/rtti")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Rtti extends AbstractBoxJsTest {
        public void testAllFilesPresentInRtti() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/rtti"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("collectionClassesIsCheck.kt")
        public void testCollectionClassesIsCheck() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/collectionClassesIsCheck.kt");
            doTest(fileName);
        }

        @TestMetadata("isComparable.kt")
        public void testIsComparable() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/isComparable.kt");
            doTest(fileName);
        }

        @TestMetadata("isJsPrimitiveType.kt")
        public void testIsJsPrimitiveType() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/isJsPrimitiveType.kt");
            doTest(fileName);
        }

        @TestMetadata("isObject.kt")
        public void testIsObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/isObject.kt");
            doTest(fileName);
        }

        @TestMetadata("isReifiedObject.kt")
        public void testIsReifiedObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/isReifiedObject.kt");
            doTest(fileName);
        }

        @TestMetadata("isSameClass.kt")
        public void testIsSameClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/isSameClass.kt");
            doTest(fileName);
        }

        @TestMetadata("notIsOtherClass.kt")
        public void testNotIsOtherClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/notIsOtherClass.kt");
            doTest(fileName);
        }

        @TestMetadata("objectExpression.kt")
        public void testObjectExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/objectExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("onNativeObject.kt")
        public void testOnNativeObject() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/onNativeObject.kt");
            doTest(fileName);
        }

        @TestMetadata("rttiForClass.kt")
        public void testRttiForClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/rttiForClass.kt");
            doTest(fileName);
        }

        @TestMetadata("rttiForTrait.kt")
        public void testRttiForTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/rttiForTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("rttiForTrait2.kt")
        public void testRttiForTrait2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/rttiForTrait2.kt");
            doTest(fileName);
        }

        @TestMetadata("sideEffectMethod.kt")
        public void testSideEffectMethod() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/sideEffectMethod.kt");
            doTest(fileName);
        }

        @TestMetadata("sideEffectProperty.kt")
        public void testSideEffectProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/sideEffectProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("stdlibEmptyListClass.kt")
        public void testStdlibEmptyListClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/rtti/stdlibEmptyListClass.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/safeCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SafeCall extends AbstractBoxJsTest {
        public void testAllFilesPresentInSafeCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/safeCall"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("safeAccess.kt")
        public void testSafeAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/safeCall/safeAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/safeCall/safeCall.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallAndIntrinsic.kt")
        public void testSafeCallAndIntrinsic() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/safeCall/safeCallAndIntrinsic.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallAndSideEffect.kt")
        public void testSafeCallAndSideEffect() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/safeCall/safeCallAndSideEffect.kt");
            doTest(fileName);
        }

        @TestMetadata("safeCallReturnsNullIfFails.kt")
        public void testSafeCallReturnsNullIfFails() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/safeCall/safeCallReturnsNullIfFails.kt");
            doTest(fileName);
        }

        @TestMetadata("safeExtensionFunctionCall.kt")
        public void testSafeExtensionFunctionCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/safeCall/safeExtensionFunctionCall.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/simple")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Simple extends AbstractBoxJsTest {
        public void testAllFilesPresentInSimple() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/simple"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assign.kt")
        public void testAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/assign.kt");
            doTest(fileName);
        }

        @TestMetadata("breakDoWhile.kt")
        public void testBreakDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/breakDoWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("breakWhile.kt")
        public void testBreakWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/breakWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("classInstantiation.kt")
        public void testClassInstantiation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/classInstantiation.kt");
            doTest(fileName);
        }

        @TestMetadata("comparison.kt")
        public void testComparison() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/comparison.kt");
            doTest(fileName);
        }

        @TestMetadata("complexExpressionAsConstructorParameter.kt")
        public void testComplexExpressionAsConstructorParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/complexExpressionAsConstructorParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorWithParameter.kt")
        public void testConstructorWithParameter() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/constructorWithParameter.kt");
            doTest(fileName);
        }

        @TestMetadata("constructorWithPropertiesAsParameters.kt")
        public void testConstructorWithPropertiesAsParameters() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/constructorWithPropertiesAsParameters.kt");
            doTest(fileName);
        }

        @TestMetadata("continueDoWhile.kt")
        public void testContinueDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/continueDoWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("continueWhile.kt")
        public void testContinueWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/continueWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/doWhile.kt");
            doTest(fileName);
        }

        @TestMetadata("doWhile2.kt")
        public void testDoWhile2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/doWhile2.kt");
            doTest(fileName);
        }

        @TestMetadata("elseif.kt")
        public void testElseif() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/elseif.kt");
            doTest(fileName);
        }

        @TestMetadata("if.kt")
        public void testIf() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/if.kt");
            doTest(fileName);
        }

        @TestMetadata("ifElseAsExpression.kt")
        public void testIfElseAsExpression() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/ifElseAsExpression.kt");
            doTest(fileName);
        }

        @TestMetadata("methodDeclarationAndCall.kt")
        public void testMethodDeclarationAndCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/methodDeclarationAndCall.kt");
            doTest(fileName);
        }

        @TestMetadata("minusAssignOnProperty.kt")
        public void testMinusAssignOnProperty() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/minusAssignOnProperty.kt");
            doTest(fileName);
        }

        @TestMetadata("notBoolean.kt")
        public void testNotBoolean() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/notBoolean.kt");
            doTest(fileName);
        }

        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/plusAssign.kt");
            doTest(fileName);
        }

        @TestMetadata("positiveAndNegativeNumbers.kt")
        public void testPositiveAndNegativeNumbers() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/positiveAndNegativeNumbers.kt");
            doTest(fileName);
        }

        @TestMetadata("postfixIntOperations.kt")
        public void testPostfixIntOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/postfixIntOperations.kt");
            doTest(fileName);
        }

        @TestMetadata("prefixIntOperations.kt")
        public void testPrefixIntOperations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/prefixIntOperations.kt");
            doTest(fileName);
        }

        @TestMetadata("propertiesAsParametersInitialized.kt")
        public void testPropertiesAsParametersInitialized() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/propertiesAsParametersInitialized.kt");
            doTest(fileName);
        }

        @TestMetadata("propertyAccess.kt")
        public void testPropertyAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/propertyAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("simpleInitializer.kt")
        public void testSimpleInitializer() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/simpleInitializer.kt");
            doTest(fileName);
        }

        @TestMetadata("while.kt")
        public void testWhile() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/while.kt");
            doTest(fileName);
        }

        @TestMetadata("while2.kt")
        public void testWhile2() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/simple/while2.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/standardClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StandardClasses extends AbstractBoxJsTest {
        public void testAllFilesPresentInStandardClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/standardClasses"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/array.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayAccess.kt")
        public void testArrayAccess() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/arrayAccess.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayConstructorsWithLambda.kt")
        public void testArrayConstructorsWithLambda() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/arrayConstructorsWithLambda.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayFactoryMethods.kt")
        public void testArrayFactoryMethods() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/arrayFactoryMethods.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayFunctionConstructor.kt")
        public void testArrayFunctionConstructor() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/arrayFunctionConstructor.kt");
            doTest(fileName);
        }

        @TestMetadata("arrayIsFilledWithNulls.kt")
        public void testArrayIsFilledWithNulls() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/arrayIsFilledWithNulls.kt");
            doTest(fileName);
        }

        @TestMetadata("arraySize.kt")
        public void testArraySize() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/arraySize.kt");
            doTest(fileName);
        }

        @TestMetadata("arraysIterator.kt")
        public void testArraysIterator() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/arraysIterator.kt");
            doTest(fileName);
        }

        @TestMetadata("hashMapTypeOfElement.kt")
        public void testHashMapTypeOfElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/hashMapTypeOfElement.kt");
            doTest(fileName);
        }

        @TestMetadata("hashSetTypeOfElement.kt")
        public void testHashSetTypeOfElement() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/hashSetTypeOfElement.kt");
            doTest(fileName);
        }

        @TestMetadata("mutableMapRemoveWithCollision.kt")
        public void testMutableMapRemoveWithCollision() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/mutableMapRemoveWithCollision.kt");
            doTest(fileName);
        }

        @TestMetadata("stringBuilder.kt")
        public void testStringBuilder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/standardClasses/stringBuilder.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/superCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SuperCall extends AbstractBoxJsTest {
        public void testAllFilesPresentInSuperCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/superCall"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classSuperCall.kt")
        public void testClassSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/superCall/classSuperCall.kt");
            doTest(fileName);
        }

        @TestMetadata("nativeSuperClass.kt")
        public void testNativeSuperClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/superCall/nativeSuperClass.kt");
            doTest(fileName);
        }

        @TestMetadata("traitSuperCall.kt")
        public void testTraitSuperCall() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/superCall/traitSuperCall.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("js/js.translator/testData/box/trait")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Trait extends AbstractBoxJsTest {
        public void testAllFilesPresentInTrait() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("js/js.translator/testData/box/trait"), Pattern.compile("^([^_](.+))\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("checkImplementationCharacteristics.kt")
        public void testCheckImplementationCharacteristics() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/checkImplementationCharacteristics.kt");
            doTest(fileName);
        }

        @TestMetadata("classDerivesFromClassAndTrait.kt")
        public void testClassDerivesFromClassAndTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/classDerivesFromClassAndTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("classDerivesFromTraitAndClass.kt")
        public void testClassDerivesFromTraitAndClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/classDerivesFromTraitAndClass.kt");
            doTest(fileName);
        }

        @TestMetadata("definitionOrder.kt")
        public void testDefinitionOrder() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/definitionOrder.kt");
            doTest(fileName);
        }

        @TestMetadata("example.kt")
        public void testExample() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/example.kt");
            doTest(fileName);
        }

        @TestMetadata("funDelegation.kt")
        public void testFunDelegation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/funDelegation.kt");
            doTest(fileName);
        }

        @TestMetadata("traitAddsFunctionsToClass.kt")
        public void testTraitAddsFunctionsToClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/traitAddsFunctionsToClass.kt");
            doTest(fileName);
        }

        @TestMetadata("traitExtendsTrait.kt")
        public void testTraitExtendsTrait() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/traitExtendsTrait.kt");
            doTest(fileName);
        }

        @TestMetadata("traitExtendsTwoTraits.kt")
        public void testTraitExtendsTwoTraits() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("js/js.translator/testData/box/trait/traitExtendsTwoTraits.kt");
            doTest(fileName);
        }
    }
}
