/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.annotation;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/annotation-collector/testData/collectToFile")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AnnotationProcessorBoxTestGenerated extends AbstractAnnotationProcessorBoxTest {
    public void testAllFilesPresentInCollectToFile() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("plugins/annotation-collector/testData/collectToFile"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
    }

    @TestMetadata("annotatedGettersSetters")
    public void testAnnotatedGettersSetters() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/annotatedGettersSetters/");
        doTest(fileName);
    }

    @TestMetadata("annotationInSameFile")
    public void testAnnotationInSameFile() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/annotationInSameFile/");
        doTest(fileName);
    }

    @TestMetadata("anonymousClasses")
    public void testAnonymousClasses() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/anonymousClasses/");
        doTest(fileName);
    }

    @TestMetadata("classAnnotations")
    public void testClassAnnotations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/classAnnotations/");
        doTest(fileName);
    }

    @TestMetadata("constructors")
    public void testConstructors() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/constructors/");
        doTest(fileName);
    }

    @TestMetadata("defaultPackage")
    public void testDefaultPackage() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/defaultPackage/");
        doTest(fileName);
    }

    @TestMetadata("fieldAnnotations")
    public void testFieldAnnotations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/fieldAnnotations/");
        doTest(fileName);
    }

    @TestMetadata("inheritedComplex")
    public void testInheritedComplex() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/inheritedComplex/");
        doTest(fileName);
    }

    @TestMetadata("inheritedSimple")
    public void testInheritedSimple() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/inheritedSimple/");
        doTest(fileName);
    }

    @TestMetadata("inheritedTopLevel")
    public void testInheritedTopLevel() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/inheritedTopLevel/");
        doTest(fileName);
    }

    @TestMetadata("localClasses")
    public void testLocalClasses() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/localClasses/");
        doTest(fileName);
    }

    @TestMetadata("localFunctions")
    public void testLocalFunctions() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/localFunctions/");
        doTest(fileName);
    }

    @TestMetadata("methodAnnotations")
    public void testMethodAnnotations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/methodAnnotations/");
        doTest(fileName);
    }

    @TestMetadata("multiFileTopLevelAnnotated")
    public void testMultiFileTopLevelAnnotated() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/multiFileTopLevelAnnotated/");
        doTest(fileName);
    }

    @TestMetadata("nestedClasses")
    public void testNestedClasses() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/nestedClasses/");
        doTest(fileName);
    }

    @TestMetadata("platformStatic")
    public void testPlatformStatic() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/platformStatic/");
        doTest(fileName);
    }

    @TestMetadata("retentionPoliciesJavaAnnotations")
    public void testRetentionPoliciesJavaAnnotations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/retentionPoliciesJavaAnnotations/");
        doTest(fileName);
    }

    @TestMetadata("retentionPoliciesJavaAnnotationsStubs")
    public void testRetentionPoliciesJavaAnnotationsStubs() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/retentionPoliciesJavaAnnotationsStubs/");
        doTest(fileName);
    }

    @TestMetadata("retentionPoliciesKotlinAnnotations")
    public void testRetentionPoliciesKotlinAnnotations() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/retentionPoliciesKotlinAnnotations/");
        doTest(fileName);
    }

    @TestMetadata("retentionPoliciesKotlinAnnotationsStubs")
    public void testRetentionPoliciesKotlinAnnotationsStubs() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/retentionPoliciesKotlinAnnotationsStubs/");
        doTest(fileName);
    }

    @TestMetadata("topLevelAnnotated")
    public void testTopLevelAnnotated() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-collector/testData/collectToFile/topLevelAnnotated/");
        doTest(fileName);
    }
}
