/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.annotation.processing.test.wrappers;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/annotation-processing/testData/wrappers")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AnnotationProcessingTestGenerated extends AbstractAnnotationProcessingTest {
    public void testAllFilesPresentInWrappers() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("plugins/annotation-processing/testData/wrappers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("plugins/annotation-processing/testData/wrappers/javaWrappers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JavaWrappers extends AbstractAnnotationProcessingTest {
        public void testAllFilesPresentInJavaWrappers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("plugins/annotation-processing/testData/wrappers/javaWrappers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("EnumClass.kt")
        public void testEnumClass() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/javaWrappers/EnumClass.kt");
            doTest(fileName);
        }

        @TestMetadata("MetaAnnotation.kt")
        public void testMetaAnnotation() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/javaWrappers/MetaAnnotation.kt");
            doTest(fileName);
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/javaWrappers/Simple.kt");
            doTest(fileName);
        }

        @TestMetadata("WithNested.kt")
        public void testWithNested() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/javaWrappers/WithNested.kt");
            doTest(fileName);
        }
    }

    @TestMetadata("plugins/annotation-processing/testData/wrappers/kotlinWrappers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinWrappers extends AbstractAnnotationProcessingTest {
        public void testAllFilesPresentInKotlinWrappers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("plugins/annotation-processing/testData/wrappers/kotlinWrappers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotations.kt")
        public void testAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/kotlinWrappers/annotations.kt");
            doTest(fileName);
        }

        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/kotlinWrappers/enum.kt");
            doTest(fileName);
        }

        @TestMetadata("kotlinAnnotations.kt")
        public void testKotlinAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/kotlinWrappers/kotlinAnnotations.kt");
            doTest(fileName);
        }

        @TestMetadata("metaAnnotations.kt")
        public void testMetaAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/kotlinWrappers/metaAnnotations.kt");
            doTest(fileName);
        }

        @TestMetadata("nestedClasses.kt")
        public void testNestedClasses() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/kotlinWrappers/nestedClasses.kt");
            doTest(fileName);
        }

        @TestMetadata("repeatableAnnotations.kt")
        public void testRepeatableAnnotations() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/kotlinWrappers/repeatableAnnotations.kt");
            doTest(fileName);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            String fileName = KotlinTestUtils.navigationMetadata("plugins/annotation-processing/testData/wrappers/kotlinWrappers/simple.kt");
            doTest(fileName);
        }
    }
}
