/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.idea.spring.tests.gutter;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("ultimate/testData/spring/core/gutter")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class SpringClassAnnotatorTestGenerated extends AbstractSpringClassAnnotatorTest {
    public void testAllFilesPresentInGutter() throws Exception {
        KotlinTestUtils.assertAllTestsPresentInSingleGeneratedClass(this.getClass(), new File("ultimate/testData/spring/core/gutter"), Pattern.compile("^(.+)\\.test$"), TargetBackend.ANY);
    }

    @TestMetadata("autowiredBeanCandidates/autowiredBeanCandidates.test")
    public void testAutowiredBeanCandidates_AutowiredBeanCandidates() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/autowiredBeanCandidates/autowiredBeanCandidates.test");
        doTest(fileName);
    }

    @TestMetadata("autowiredProperty/autowiredProperty.test")
    public void testAutowiredProperty_AutowiredProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/autowiredProperty/autowiredProperty.test");
        doTest(fileName);
    }

    @TestMetadata("autowiredSetter/autowiredSetter.test")
    public void testAutowiredSetter_AutowiredSetter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/autowiredSetter/autowiredSetter.test");
        doTest(fileName);
    }

    @TestMetadata("classGutter/classGutter.test")
    public void testClassGutter_ClassGutter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/classGutter/classGutter.test");
        doTest(fileName);
    }

    @TestMetadata("classGutterAbstractShowMappedInheritors/classGutterAbstractShowMappedInheritors.test")
    public void testClassGutterAbstractShowMappedInheritors_ClassGutterAbstractShowMappedInheritors() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/classGutterAbstractShowMappedInheritors/classGutterAbstractShowMappedInheritors.test");
        doTest(fileName);
    }

    @TestMetadata("componentScan/componentScan.test")
    public void testComponentScan_ComponentScan() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/componentScan/componentScan.test");
        doTest(fileName);
    }

    @TestMetadata("componentScanWithBasePackageClasses/componentScanWithBasePackageClasses.test")
    public void testComponentScanWithBasePackageClasses_ComponentScanWithBasePackageClasses() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/componentScanWithBasePackageClasses/componentScanWithBasePackageClasses.test");
        doTest(fileName);
    }

    @TestMetadata("componentScanWithBasePackages/componentScanWithBasePackages.test")
    public void testComponentScanWithBasePackages_ComponentScanWithBasePackages() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/componentScanWithBasePackages/componentScanWithBasePackages.test");
        doTest(fileName);
    }

    @TestMetadata("contextBeanInjectionPoints/contextBeanInjectionPoints.test")
    public void testContextBeanInjectionPoints_ContextBeanInjectionPoints() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/contextBeanInjectionPoints/contextBeanInjectionPoints.test");
        doTest(fileName);
    }

    @TestMetadata("contextBeanWithQualifierInjectionPoints/contextBeanWithQualifierInjectionPoints.test")
    public void testContextBeanWithQualifierInjectionPoints_ContextBeanWithQualifierInjectionPoints() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/contextBeanWithQualifierInjectionPoints/contextBeanWithQualifierInjectionPoints.test");
        doTest(fileName);
    }

    @TestMetadata("importConfigClasses/importConfigClasses.test")
    public void testImportConfigClasses_ImportConfigClasses() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/importConfigClasses/importConfigClasses.test");
        doTest(fileName);
    }

    @TestMetadata("innerBean/innerBean.test")
    public void testInnerBean_InnerBean() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/innerBean/innerBean.test");
        doTest(fileName);
    }

    @TestMetadata("methodTypeDefaultInitMethod/methodTypeDefaultInitMethod.test")
    public void testMethodTypeDefaultInitMethod_MethodTypeDefaultInitMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/methodTypeDefaultInitMethod/methodTypeDefaultInitMethod.test");
        doTest(fileName);
    }

    @TestMetadata("methodTypeFactory/methodTypeFactory.test")
    public void testMethodTypeFactory_MethodTypeFactory() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/methodTypeFactory/methodTypeFactory.test");
        doTest(fileName);
    }

    @TestMetadata("methodTypeInitMethod/methodTypeInitMethod.test")
    public void testMethodTypeInitMethod_MethodTypeInitMethod() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/methodTypeInitMethod/methodTypeInitMethod.test");
        doTest(fileName);
    }

    @TestMetadata("methodTypeMultiple/methodTypeMultiple.test")
    public void testMethodTypeMultiple_MethodTypeMultiple() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/methodTypeMultiple/methodTypeMultiple.test");
        doTest(fileName);
    }

    @TestMetadata("propertyGutterForProperty/propertyGutterForProperty.test")
    public void testPropertyGutterForProperty_PropertyGutterForProperty() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/propertyGutterForProperty/propertyGutterForProperty.test");
        doTest(fileName);
    }

    @TestMetadata("propertyGutterForSetter/propertyGutterForSetter.test")
    public void testPropertyGutterForSetter_PropertyGutterForSetter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/propertyGutterForSetter/propertyGutterForSetter.test");
        doTest(fileName);
    }

    @TestMetadata("resourceGutter/resourceGutter.test")
    public void testResourceGutter_ResourceGutter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/gutter/resourceGutter/resourceGutter.test");
        doTest(fileName);
    }
}
