/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.InvertedCMYKColorSpace;
import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.clib.InputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGMetadata;
import com.sun.media.imageioimpl.plugins.jpeg.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jpeg.Decoder;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

final class CLibJPEGImageReader
extends CLibImageReader {
    private static final boolean DEBUG = false;
    private mediaLibImage infoImage = null;
    private int infoImageIndex = -1;
    private byte[] iccProfileData = null;
    private IIOMetadata imageMetadata = null;
    private int imageMetadataIndex = -1;
    private HashMap imageTypes = new HashMap();
    private int bitDepth;

    CLibJPEGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected final synchronized mediaLibImage decode(InputStream inputStream) throws IOException {
        mediaLibImage mediaLibImage2 = null;
        Decoder decoder = null;
        try {
            int n;
            if (inputStream instanceof InputStreamAdapter) {
                ImageInputStream imageInputStream = ((InputStreamAdapter)inputStream).getWrappedStream();
                decoder = new Decoder(imageInputStream);
            } else {
                decoder = new Decoder(inputStream);
            }
            mediaLibImage2 = decoder.decode(null);
            this.iccProfileData = decoder.getEmbeddedICCProfile();
            if (this.iccProfileData != null && mediaLibImage2.getType() == 1 && ((n = mediaLibImage2.getFormat()) == 11 || n == 14)) {
                long l = System.currentTimeMillis();
                byte[] byArray = mediaLibImage2.getByteData();
                int n2 = byArray.length;
                for (int i = mediaLibImage2.getOffset(); i < n2; ++i) {
                    byArray[i] = (byte)(255 - byArray[i] & 0xFF);
                }
            }
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        if (mediaLibImage2 == null) {
            throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
        }
        try {
            this.bitDepth = decoder.getDepth();
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        decoder.dispose();
        return mediaLibImage2;
    }

    private synchronized mediaLibImage getInfoImage(int n) throws IOException {
        if (this.infoImage == null || n != this.infoImageIndex) {
            if (n == this.getImageIndex()) {
                this.infoImage = this.getImage(n);
                this.infoImageIndex = n;
                return this.infoImage;
            }
            if (this.input == null) {
                throw new IllegalStateException("input == null");
            }
            ImageInputStream imageInputStream = null;
            if (!(this.input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
            }
            imageInputStream = (ImageInputStream)this.input;
            this.seekToImage(n);
            imageInputStream.mark();
            Decoder decoder = null;
            try {
                decoder = new Decoder(imageInputStream);
                this.infoImage = decoder.getSize();
                this.iccProfileData = decoder.getEmbeddedICCProfile();
            }
            catch (Throwable throwable) {
                throw new IIOException("codecLib error", throwable);
            }
            if (this.infoImage == null || this.infoImage.getFormat() == 0 && (this.infoImage = this.getImage(n)) == null) {
                throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
            }
            this.infoImageIndex = n;
            try {
                this.bitDepth = decoder.getDepth();
            }
            catch (Throwable throwable) {
                throw new IIOException("codecLib error", throwable);
            }
            imageInputStream.reset();
            decoder.dispose();
        }
        return this.infoImage;
    }

    public int getWidth(int n) throws IOException {
        return this.getInfoImage(n).getWidth();
    }

    public int getHeight(int n) throws IOException {
        return this.getInfoImage(n).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getImageTypes(int n) throws IOException {
        this.seekToImage(n);
        ArrayList arrayList = null;
        HashMap hashMap = this.imageTypes;
        synchronized (hashMap) {
            Integer n2 = new Integer(n);
            if (this.imageTypes.containsKey(n2)) {
                arrayList = (ArrayList)this.imageTypes.get(n2);
            } else {
                ColorSpace colorSpace;
                arrayList = new ArrayList();
                mediaLibImage mediaLibImage2 = this.getInfoImage(n);
                if (this.iccProfileData != null) {
                    ICC_Profile iCC_Profile = ICC_Profile.getInstance(this.iccProfileData);
                    colorSpace = new ICC_ColorSpace(iCC_Profile);
                    arrayList.add(CLibJPEGImageReader.createImageType(mediaLibImage2, colorSpace, this.bitDepth, null, null, null, null));
                }
                colorSpace = mediaLibImage2.getFormat() == 11 ? InvertedCMYKColorSpace.getInstance() : null;
                arrayList.add(CLibJPEGImageReader.createImageType(mediaLibImage2, colorSpace, this.bitDepth, null, null, null, null));
            }
        }
        return arrayList.iterator();
    }

    public synchronized IIOMetadata getImageMetadata(int n) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        if (this.imageMetadata == null || n != this.imageMetadataIndex) {
            this.seekToImage(n);
            ImageInputStream imageInputStream = (ImageInputStream)this.input;
            long l = imageInputStream.getStreamPosition();
            try {
                this.imageMetadata = new CLibJPEGMetadata(imageInputStream);
                this.imageMetadataIndex = n;
            }
            catch (IIOException iIOException) {
                throw iIOException;
            }
            finally {
                imageInputStream.seek(l);
            }
        }
        return this.imageMetadata;
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    public int getNumThumbnails(int n) throws IOException {
        CLibJPEGMetadata cLibJPEGMetadata = (CLibJPEGMetadata)this.getImageMetadata(n);
        return cLibJPEGMetadata.getNumThumbnails();
    }

    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        CLibJPEGMetadata cLibJPEGMetadata = (CLibJPEGMetadata)this.getImageMetadata(n);
        return cLibJPEGMetadata.getThumbnail(n2);
    }

    protected void resetLocal() {
        this.infoImage = null;
        this.infoImageIndex = -1;
        this.iccProfileData = null;
        this.imageMetadata = null;
        this.imageMetadataIndex = -1;
        this.imageTypes.clear();
        super.resetLocal();
    }
}

