/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class CLibJPEGImageReaderSpi
extends ImageReaderSpi {
    private static final String[] names = new String[]{"jpeg", "JPEG", "jpg", "JPG", "jfif", "JFIF", "jpeg-lossless", "JPEG-LOSSLESS", "jpeg-ls", "JPEG-LS"};
    private static final String[] suffixes = new String[]{"jpeg", "jpg", "jfif", "jls"};
    private static final String[] MIMETypes = new String[]{"image/jpeg"};
    private static final String readerClassName = "com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader";
    private static final String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriterSpi"};
    private boolean registered = false;

    public CLibJPEGImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, readerClassName, STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, "javax_imageio_jpeg_image_1.0", "com.sun.imageio.plugins.jpeg.JPEGImageMetadataFormat", new String[]{"com_sun_media_imageio_plugins_tiff_image_1.0"}, new String[]{"com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadataFormat"});
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            serviceRegistry.deregisterServiceProvider(this);
        } else {
            List list2 = ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, "JPEG", true);
            for (int i = 0; i < list2.size(); ++i) {
                serviceRegistry.setOrdering(clazz, this, list2.get(i));
            }
        }
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " natively-accelerated JPEG Image Reader";
        return string;
    }

    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        int n = imageInputStream.read();
        int n2 = imageInputStream.read();
        if (n != 255 || n2 != 216) {
            imageInputStream.reset();
            return false;
        }
        block0: while (true) {
            n = imageInputStream.read();
            n2 = imageInputStream.read();
            if (n != 255 || n2 == 218) break;
            if (n2 == 194) {
                imageInputStream.reset();
                return false;
            }
            if (n2 >= 192 && n2 <= 195) break;
            int n3 = imageInputStream.read() << 8;
            n3 += imageInputStream.read();
            n3 -= 2;
            while (true) {
                if (n3 <= 0) continue block0;
                n3 -= imageInputStream.skipBytes(n3);
            }
            break;
        }
        imageInputStream.reset();
        return true;
    }

    public ImageReader createReaderInstance(Object object) throws IIOException {
        return new CLibJPEGImageReader(this);
    }
}

