/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibJPEGImageWriterSpi
extends ImageWriterSpi {
    private static final String[] names = new String[]{"jpeg", "JPEG", "jpg", "JPG", "jfif", "JFIF", "jpeg-lossless", "JPEG-LOSSLESS", "jpeg-ls", "JPEG-LS"};
    private static final String[] suffixes = new String[]{"jpeg", "jpg", "jfif", "jls"};
    private static final String[] MIMETypes = new String[]{"image/jpeg"};
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter";
    private static final String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReaderSpi"};
    private boolean registered = false;

    public CLibJPEGImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, writerClassName, STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            serviceRegistry.deregisterServiceProvider(this);
        } else {
            List list2 = ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, "JPEG", false);
            for (int i = 0; i < list2.size(); ++i) {
                serviceRegistry.setOrdering(clazz, this, list2.get(i));
            }
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        int n;
        int[] nArray;
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        if (colorModel != null) {
            nArray = colorModel.getComponentSize();
            n = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] == n) continue;
                return false;
            }
        } else {
            nArray = sampleModel.getSampleSize();
            n = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] == n) continue;
                return false;
            }
        }
        if (n > 16) {
            return false;
        }
        int n2 = sampleModel.getNumBands();
        return n2 >= 1 && n2 <= 4;
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " natively-accelerated JPEG Image Writer";
        return string;
    }

    public ImageWriter createWriterInstance(Object object) throws IOException {
        return new CLibJPEGImageWriter(this);
    }
}

