/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageReader;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class CLibPNGImageReaderSpi
extends ImageReaderSpi {
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String readerClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGImageReader";
    private static final String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriterSpi"};
    private boolean registered = false;

    public CLibPNGImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, readerClassName, STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.media.imageioimpl.plugins.png.CLibPNGMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            serviceRegistry.deregisterServiceProvider(this);
        } else {
            List list2 = ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, "PNG", true);
            for (int i = 0; i < list2.size(); ++i) {
                serviceRegistry.setOrdering(clazz, this, list2.get(i));
            }
        }
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " natively-accelerated PNG Image Reader";
        return string;
    }

    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        byte[] byArray = new byte[8];
        imageInputStream.mark();
        imageInputStream.readFully(byArray);
        imageInputStream.reset();
        return byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10;
    }

    public ImageReader createReaderInstance(Object object) throws IIOException {
        return new CLibPNGImageReader(this);
    }
}

