/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibPNGImageWriterSpi
extends ImageWriterSpi {
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter";
    private static final String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.png.CLibPNGImageReaderSpi"};
    private boolean registered = false;

    public CLibPNGImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, writerClassName, STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.media.imageioimpl.plugins.png.CLibPNGMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            serviceRegistry.deregisterServiceProvider(this);
        } else {
            List list2 = ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, "PNG", false);
            for (int i = 0; i < list2.size(); ++i) {
                serviceRegistry.setOrdering(clazz, this, list2.get(i));
            }
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        boolean bl;
        int n;
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        int[] nArray = sampleModel.getSampleSize();
        int n2 = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n] == n2) continue;
            return false;
        }
        if (n2 != 1 && n2 != 8 && n2 != 16) {
            return false;
        }
        n = sampleModel.getNumBands();
        if (n < 1 || n > 4) {
            return false;
        }
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        boolean bl2 = bl = colorModel != null && colorModel.hasAlpha();
        if ((n == 1 || n == 3) && bl) {
            return false;
        }
        return n != 2 && n != 4 || bl;
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " natively-accelerated PNG Image Writer";
        return string;
    }

    public ImageWriter createWriterInstance(Object object) {
        return new CLibPNGImageWriter(this);
    }
}

