/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import java.util.Arrays;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class TIFFFieldNode
extends IIOMetadataNode {
    private boolean isIFD;
    private Boolean isInitialized = Boolean.FALSE;
    private TIFFField field;

    private static String getNodeName(TIFFField tIFFField) {
        return tIFFField.getData() instanceof TIFFDirectory ? "TIFFIFD" : "TIFFField";
    }

    public TIFFFieldNode(TIFFField tIFFField) {
        super(TIFFFieldNode.getNodeName(tIFFField));
        this.isIFD = tIFFField.getData() instanceof TIFFDirectory;
        this.field = tIFFField;
        TIFFTag tIFFTag = tIFFField.getTag();
        int n = tIFFTag.getNumber();
        String string = tIFFTag.getName();
        if (this.isIFD) {
            TIFFDirectory tIFFDirectory;
            TIFFTagSet[] tIFFTagSetArray;
            if (n != 0) {
                this.setAttribute("parentTagNumber", Integer.toString(n));
            }
            if (string != null) {
                this.setAttribute("parentTagName", string);
            }
            if ((tIFFTagSetArray = (tIFFDirectory = (TIFFDirectory)tIFFField.getData()).getTagSets()) != null) {
                String string2 = "";
                for (int i = 0; i < tIFFTagSetArray.length; ++i) {
                    string2 = string2 + tIFFTagSetArray[i].getClass().getName();
                    if (i == tIFFTagSetArray.length - 1) continue;
                    string2 = string2 + ",";
                }
                this.setAttribute("tagSets", string2);
            }
        } else {
            this.setAttribute("number", Integer.toString(n));
            this.setAttribute("name", string);
        }
    }

    private synchronized void initialize() {
        if (this.isInitialized == Boolean.TRUE) {
            return;
        }
        if (this.isIFD) {
            TIFFDirectory tIFFDirectory = (TIFFDirectory)this.field.getData();
            TIFFField[] tIFFFieldArray = tIFFDirectory.getTIFFFields();
            if (tIFFFieldArray != null) {
                TIFFTagSet[] tIFFTagSetArray = tIFFDirectory.getTagSets();
                List<TIFFTagSet> list2 = Arrays.asList(tIFFTagSetArray);
                int n = tIFFFieldArray.length;
                for (int i = 0; i < n; ++i) {
                    TIFFField tIFFField = tIFFFieldArray[i];
                    int n2 = tIFFField.getTagNumber();
                    TIFFTag tIFFTag = TIFFIFD.getTag(n2, list2);
                    Node node = tIFFField.getAsNativeNode();
                    if (node == null) continue;
                    this.appendChild(node);
                }
            }
        } else {
            IIOMetadataNode iIOMetadataNode;
            int n = this.field.getCount();
            if (this.field.getType() == 7) {
                iIOMetadataNode = new IIOMetadataNode("TIFFUndefined");
                byte[] byArray = this.field.getAsBytes();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(Integer.toString(byArray[i] & 0xFF));
                    if (i >= n - 1) continue;
                    stringBuffer.append(",");
                }
                iIOMetadataNode.setAttribute("value", stringBuffer.toString());
            } else {
                iIOMetadataNode = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()) + "s");
                TIFFTag tIFFTag = this.field.getTag();
                for (int i = 0; i < n; ++i) {
                    int n3;
                    String string;
                    IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()));
                    iIOMetadataNode2.setAttribute("value", this.field.getValueAsString(i));
                    if (tIFFTag.hasValueNames() && this.field.isIntegral() && (string = tIFFTag.getValueName(n3 = this.field.getAsInt(i))) != null) {
                        iIOMetadataNode2.setAttribute("description", string);
                    }
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                }
            }
            this.appendChild(iIOMetadataNode);
        }
        this.isInitialized = Boolean.TRUE;
    }

    public Node appendChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        return super.insertBefore(node, null);
    }

    public boolean hasChildNodes() {
        this.initialize();
        return super.hasChildNodes();
    }

    public int getLength() {
        this.initialize();
        return super.getLength();
    }

    public Node getFirstChild() {
        this.initialize();
        return super.getFirstChild();
    }

    public Node getLastChild() {
        this.initialize();
        return super.getLastChild();
    }

    public Node getPreviousSibling() {
        this.initialize();
        return super.getPreviousSibling();
    }

    public Node getNextSibling() {
        this.initialize();
        return super.getNextSibling();
    }

    public Node insertBefore(Node node, Node node2) {
        this.initialize();
        return super.insertBefore(node, node2);
    }

    public Node replaceChild(Node node, Node node2) {
        this.initialize();
        return super.replaceChild(node, node2);
    }

    public Node removeChild(Node node) {
        this.initialize();
        return super.removeChild(node);
    }

    public Node cloneNode(boolean bl) {
        this.initialize();
        return super.cloneNode(bl);
    }
}

