/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.opimage.FCT;
import com.sun.media.jai.util.MathJAI;
import com.sun.medialib.mlib.Image;
import java.util.Arrays;

public class FCTmediaLib
extends FCT {
    private int length;
    private boolean lengthIsSet = false;
    private double[] wr;
    private double[] wi;
    protected double[] real;
    protected double[] imag;

    public FCTmediaLib(boolean bl, int n) {
        this.isForwardTransform = bl;
        this.setLength(n);
    }

    public void setLength(int n) {
        if (this.lengthIsSet && n == this.length) {
            return;
        }
        if (!MathJAI.isPositivePowerOf2(n)) {
            throw new RuntimeException(JaiI18N.getString("FCTmediaLib0"));
        }
        this.length = n;
        if (this.real == null || n != this.real.length) {
            this.real = new double[n];
            this.imag = new double[n];
        }
        this.calculateFCTLUTs();
        this.lengthIsSet = true;
    }

    private void calculateFCTLUTs() {
        this.wr = new double[this.length];
        this.wi = new double[this.length];
        int n = 0;
        while (n < this.length) {
            double d = n == 0 ? Math.sqrt(1.0 / (double)this.length) : Math.sqrt(2.0 / (double)this.length);
            double d2 = Math.PI * (double)n / (2.0 * (double)this.length);
            this.wr[n] = d * Math.cos(d2);
            this.wi[n] = d * Math.sin(d2);
            ++n;
        }
    }

    public void setData(int n, Object object, int n2, int n3, int n4) {
        if (this.isForwardTransform) {
            this.setFCTData(n, object, n2, n3, n4);
        } else {
            this.setIFCTData(n, object, n2, n3, n4);
        }
    }

    public void getData(int n, Object object, int n2, int n3) {
        if (this.isForwardTransform) {
            this.getFCTData(n, object, n2, n3);
        } else {
            this.getIFCTData(n, object, n2, n3);
        }
    }

    private void setFCTData(int n, Object object, int n2, int n3, int n4) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n5 = 0;
                while (n5 < n4) {
                    this.imag[n5] = fArray[n2];
                    n2 += n3;
                    ++n5;
                }
                int n6 = n4;
                while (n6 < this.length) {
                    this.imag[n6] = 0.0;
                    ++n6;
                }
                int n7 = this.length - 1;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n7) {
                    this.real[n9] = this.imag[n8++];
                    this.real[n7--] = this.imag[n8++];
                    ++n9;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n10 = 0;
                while (n10 < n4) {
                    this.imag[n10] = dArray[n2];
                    n2 += n3;
                    ++n10;
                }
                int n11 = n4;
                while (n11 < this.length) {
                    this.imag[n11] = 0.0;
                    ++n11;
                }
                int n12 = this.length - 1;
                int n13 = 0;
                int n14 = 0;
                while (n14 < n12) {
                    this.real[n14] = this.imag[n13++];
                    this.real[n12--] = this.imag[n13++];
                    ++n14;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FCTmediaLib1"));
            }
        }
        Arrays.fill(this.imag, 0, this.length, 0.0);
    }

    private void getFCTData(int n, Object object, int n2, int n3) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n4 = 0;
                while (n4 < this.length) {
                    fArray[n2] = (float)(this.wr[n4] * this.real[n4] + this.wi[n4] * this.imag[n4]);
                    n2 += n3;
                    ++n4;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n5 = 0;
                while (n5 < this.length) {
                    dArray[n2] = this.wr[n5] * this.real[n5] + this.wi[n5] * this.imag[n5];
                    n2 += n3;
                    ++n5;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FCTmediaLib1"));
            }
        }
    }

    private void setIFCTData(int n, Object object, int n2, int n3, int n4) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n5 = 0;
                while (n5 < n4) {
                    float f = fArray[n2];
                    this.real[n5] = (double)f * this.wr[n5];
                    this.imag[n5] = (double)f * this.wi[n5];
                    n2 += n3;
                    ++n5;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n6 = 0;
                while (n6 < n4) {
                    double d = dArray[n2];
                    this.real[n6] = d * this.wr[n6];
                    this.imag[n6] = d * this.wi[n6];
                    n2 += n3;
                    ++n6;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FCTmediaLib1"));
            }
        }
        if (n4 < this.length) {
            Arrays.fill(this.real, n4, this.length, 0.0);
            Arrays.fill(this.imag, n4, this.length, 0.0);
        }
    }

    private void getIFCTData(int n, Object object, int n2, int n3) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n4 = this.length - 1;
                int n5 = 0;
                while (n5 < n4) {
                    fArray[n2] = (float)this.real[n5];
                    fArray[n2 += n3] = (float)this.real[n4--];
                    n2 += n3;
                    ++n5;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n6 = this.length - 1;
                int n7 = 0;
                while (n7 < n6) {
                    dArray[n2] = (float)this.real[n7];
                    dArray[n2 += n3] = (float)this.real[n6--];
                    n2 += n3;
                    ++n7;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FCTmediaLib1"));
            }
        }
    }

    public void transform() {
        if (this.isForwardTransform) {
            Image.FFT_1(this.real, this.imag);
        } else {
            Image.IFFT_2(this.real, this.imag);
        }
    }
}

