/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.opimage.FilteredSubsampleOpImage;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;

final class MlibFilteredSubsampleOpImage
extends FilteredSubsampleOpImage {
    protected double[] m_hKernel;
    protected double[] m_vKernel;
    private static final boolean DEBUG = false;

    public MlibFilteredSubsampleOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, int n, int n2, float[] fArray, Interpolation interpolation) {
        super(renderedImage, borderExtender, map, imageLayout, n, n2, fArray, interpolation);
        this.m_hKernel = new double[this.hKernel.length];
        this.m_vKernel = new double[this.vKernel.length];
        int n3 = 0;
        while (n3 < this.hKernel.length) {
            this.m_hKernel[n3] = this.hKernel[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.vKernel.length) {
            this.m_vKernel[n4] = this.vKernel[n4];
            ++n4;
        }
    }

    public void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster, rectangle, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(rasterArray[0], this.mapDestRect(rectangle, 0), n);
        int n2 = this.m_hKernel.length - (this.scaleX + 1) / 2 - this.hParity * (1 + this.scaleX) % 2;
        int n3 = this.m_vKernel.length - (this.scaleY + 1) / 2 - this.vParity * (1 + this.scaleY) % 2;
        switch (mediaLibAccessor.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor2.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor.getMediaLibImages();
                int n4 = 0;
                while (n4 < mediaLibImageArray2.length) {
                    Image.FilteredSubsample(mediaLibImageArray2[n4], mediaLibImageArray[n4], this.scaleX, this.scaleY, n2, n3, this.m_hKernel, this.m_vKernel, this.hParity, this.vParity, 0);
                    ++n4;
                }
                break;
            }
            case 4: 
            case 5: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor2.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray3 = mediaLibAccessor.getMediaLibImages();
                int n5 = 0;
                while (n5 < mediaLibImageArray3.length) {
                    Image.FilteredSubsample_Fp(mediaLibImageArray3[n5], mediaLibImageArray[n5], this.scaleX, this.scaleY, n2, n3, this.m_hKernel, this.m_vKernel, this.hParity, this.vParity, 0);
                    ++n5;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor.isDataCopy()) {
            mediaLibAccessor.clampDataArrays();
            mediaLibAccessor.copyDataToRaster();
        }
    }
}

