/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.operator.MinFilterDescriptor;
import javax.media.jai.operator.MinFilterShape;

final class MlibMinFilterOpImage
extends AreaOpImage {
    protected int maskType;
    protected int maskSize;

    public MlibMinFilterOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, MinFilterShape minFilterShape, int n) {
        super(renderedImage, imageLayout, map, true, borderExtender, (n - 1) / 2, (n - 1) / 2, n / 2, n / 2);
        this.maskSize = n;
    }

    private static int mapToMlibMaskType(MinFilterShape minFilterShape) {
        if (minFilterShape.equals(MinFilterDescriptor.MIN_MASK_SQUARE)) {
            return 0;
        }
        if (minFilterShape.equals(MinFilterDescriptor.MIN_MASK_PLUS)) {
            return 1;
        }
        if (minFilterShape.equals(MinFilterDescriptor.MIN_MASK_X)) {
            return 2;
        }
        if (minFilterShape.equals(MinFilterDescriptor.MIN_MASK_SQUARE_SEPARABLE)) {
            return 3;
        }
        throw new RuntimeException(JaiI18N.getString("MinFilterOpImage0"));
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        int n2 = this.getSampleModel().getNumBands();
        int n3 = (1 << n2) - 1;
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n4 = 0;
        while (n4 < mediaLibImageArray2.length) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.maskSize == 3) {
                        Image.MinFilter3x3(mediaLibImageArray2[n4], mediaLibImageArray[n4]);
                        break;
                    }
                    if (this.maskSize == 5) {
                        Image.MinFilter5x5(mediaLibImageArray2[n4], mediaLibImageArray[n4]);
                        break;
                    }
                    if (this.maskSize != 7) break;
                    Image.MinFilter7x7(mediaLibImageArray2[n4], mediaLibImageArray[n4]);
                    break;
                }
                case 4: 
                case 5: {
                    if (this.maskSize == 3) {
                        Image.MinFilter3x3_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4]);
                        break;
                    }
                    if (this.maskSize == 5) {
                        Image.MinFilter5x5_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4]);
                        break;
                    }
                    if (this.maskSize != 7) break;
                    Image.MinFilter7x7_Fp(mediaLibImageArray2[n4], mediaLibImageArray[n4]);
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
            ++n4;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

