/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.opimage.MosaicOpImage;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

final class MlibMosaicOpImage
extends MosaicOpImage {
    private int[] glow;
    private int[] ghigh;
    private int shift;

    public MlibMosaicOpImage(Vector vector2, ImageLayout imageLayout, Map map, MosaicType mosaicType, PlanarImage[] planarImageArray, ROI[] rOIArray, double[][] dArray, double[] dArray2) {
        super(vector2, imageLayout, map, mosaicType, planarImageArray, rOIArray, dArray, dArray2);
        int n;
        int n2 = vector2.size();
        int n3 = this.sampleModel.getDataType();
        if (n3 == 4 || n3 == 5) {
            throw new UnsupportedOperationException(JaiI18N.getString("MlibMosaicOpImage0"));
        }
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < this.numBands) {
                int[] nArray = this.threshold[n4];
                int n5 = n++;
                nArray[n5] = nArray[n5] - 1;
            }
            ++n4;
        }
        n = -2147483647;
        int n6 = Integer.MAX_VALUE;
        switch (n3) {
            case 0: {
                n = 0;
                n6 = 255;
                this.shift = 8;
                break;
            }
            case 1: {
                n = 0;
                n6 = 65535;
                this.shift = 16;
                break;
            }
            case 2: {
                n = Short.MIN_VALUE;
                n6 = Short.MAX_VALUE;
                this.shift = 16;
                break;
            }
            case 3: {
                n = Integer.MIN_VALUE;
                n6 = Integer.MAX_VALUE;
                this.shift = 32;
                break;
            }
        }
        this.glow = new int[this.numBands];
        Arrays.fill(this.glow, n);
        this.ghigh = new int[this.numBands];
        Arrays.fill(this.ghigh, n6);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle, Raster[] rasterArray2, Raster[] rasterArray3) {
        int n = rasterArray.length;
        ArrayList<Raster> arrayList = new ArrayList<Raster>(n);
        int n2 = 0;
        while (n2 < n) {
            if (rasterArray[n2] != null) {
                arrayList.add(rasterArray[n2]);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        Raster[] rasterArray4 = null;
        if (n3 != 0) {
            rasterArray4 = new Raster[n3];
            arrayList.toArray(rasterArray4);
        }
        int n4 = MediaLibAccessor.findCompatibleTag(rasterArray4, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster, rectangle, n4);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        int[] nArray = mediaLibAccessor.getIntParameters(0, this.background);
        if (n3 == 0) {
            Image.Clear(mediaLibImageArray[0], nArray);
            return;
        }
        MediaLibAccessor[] mediaLibAccessorArray = new MediaLibAccessor[n];
        int n5 = 0;
        while (n5 < n) {
            if (rasterArray[n5] != null) {
                mediaLibAccessorArray[n5] = new MediaLibAccessor(rasterArray[n5], rectangle, n4);
            }
            ++n5;
        }
        int[][] nArrayArray = new int[n][];
        mediaLibImage[][] mediaLibImageArrayArray = new mediaLibImage[n][];
        int n6 = 0;
        while (n6 < n) {
            if (mediaLibAccessorArray[n6] != null) {
                mediaLibImageArrayArray[n6] = mediaLibAccessorArray[n6].getMediaLibImages();
                nArrayArray[n6] = mediaLibAccessorArray[n6].getIntParameters(0, this.threshold[n6]);
            }
            ++n6;
        }
        mediaLibImage mediaLibImage2 = null;
        mediaLibImage mediaLibImage3 = null;
        mediaLibImage[] mediaLibImageArray2 = new mediaLibImage[]{mediaLibImage2};
        mediaLibImage[] mediaLibImageArray3 = new mediaLibImage[]{mediaLibImage3};
        if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
            Image.Clear(mediaLibImageArray[0], nArray);
            int n7 = n - 1;
            while (n7 >= 0) {
                if (mediaLibImageArrayArray[n7] != null) {
                    mediaLibImage mediaLibImage4 = this.getWeightImage(rectangle, n4, mediaLibImageArray[0], mediaLibImageArrayArray[n7][0], this.sourceAlpha != null && this.sourceAlpha[n7] != null ? rasterArray2[n7] : null, this.sourceROI != null && this.sourceROI[n7] != null ? rasterArray3[n7] : null, nArrayArray[n7], mediaLibImageArray2, mediaLibImageArray3);
                    Image.Blend2(mediaLibImageArray[0], mediaLibImageArrayArray[n7][0], mediaLibImage4);
                }
                --n7;
            }
        } else if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_BLEND) {
            mediaLibImage2 = new mediaLibImage(mediaLibImageArray[0].getType(), 1, mediaLibImageArray[0].getWidth(), mediaLibImageArray[0].getHeight());
            mediaLibImage3 = new mediaLibImage(mediaLibImageArray[0].getType(), mediaLibImageArray[0].getChannels(), mediaLibImageArray[0].getWidth(), mediaLibImageArray[0].getHeight());
            mediaLibImage[] mediaLibImageArray4 = new mediaLibImage[n3];
            mediaLibImage[] mediaLibImageArray5 = new mediaLibImage[n3];
            int n8 = 0;
            int n9 = 0;
            while (n9 < n) {
                if (mediaLibImageArrayArray[n9] != null) {
                    mediaLibImageArray5[n8] = mediaLibImageArrayArray[n9][0];
                    mediaLibImageArray4[n8] = this.getWeightImage(rectangle, n4, mediaLibImageArray[0], mediaLibImageArrayArray[n9][0], this.sourceAlpha != null && this.sourceAlpha[n9] != null ? rasterArray2[n9] : null, this.sourceROI != null && this.sourceROI[n9] != null ? rasterArray3[n9] : null, nArrayArray[n9], null, null);
                    ++n8;
                }
                ++n9;
            }
            if (n8 != n3) {
                mediaLibImage[] mediaLibImageArray6 = new mediaLibImage[n8];
                System.arraycopy(mediaLibImageArray5, 0, mediaLibImageArray6, 0, n8);
                mediaLibImageArray5 = mediaLibImageArray6;
                mediaLibImage[] mediaLibImageArray7 = new mediaLibImage[n8];
                System.arraycopy(mediaLibImageArray4, 0, mediaLibImageArray7, 0, n8);
                mediaLibImageArray4 = mediaLibImageArray7;
            }
            Image.BlendMulti(mediaLibImageArray[0], mediaLibImageArray5, mediaLibImageArray4, nArray);
        }
        if (mediaLibAccessor.isDataCopy()) {
            mediaLibAccessor.clampDataArrays();
            mediaLibAccessor.copyDataToRaster();
        }
    }

    private mediaLibImage getWeightImage(Rectangle rectangle, int n, mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, Raster raster, Raster raster2, int[] nArray, mediaLibImage[] mediaLibImageArray, mediaLibImage[] mediaLibImageArray2) {
        mediaLibImage mediaLibImage4 = null;
        if (raster != null) {
            MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle, n);
            mediaLibImage[] mediaLibImageArray3 = mediaLibAccessor.getMediaLibImages();
            if (this.isAlphaBitmask) {
                if (mediaLibImageArray == null) {
                    mediaLibImageArray = new mediaLibImage[]{null};
                }
                if (mediaLibImageArray[0] == null) {
                    mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
                }
                Image.Thresh1(mediaLibImageArray[0], mediaLibImageArray3[0], new int[]{0}, new int[]{this.ghigh[0]}, new int[]{this.glow[0]});
                mediaLibImage4 = mediaLibImageArray[0];
            } else {
                mediaLibImage4 = mediaLibImageArray3[0];
            }
        } else if (raster2 != null) {
            int n2 = MediaLibAccessor.findCompatibleTag(null, raster2);
            MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster2, rectangle, n2, true);
            mediaLibImage[] mediaLibImageArray4 = mediaLibAccessor.getMediaLibImages();
            if (mediaLibImageArray == null) {
                mediaLibImageArray = new mediaLibImage[]{null};
            }
            if (mediaLibImageArray[0] == null) {
                mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
            }
            if (mediaLibImageArray[0].getType() != mediaLibImageArray4[0].getType()) {
                if (mediaLibImageArray[0] == null) {
                    mediaLibImageArray[0] = new mediaLibImage(mediaLibImage3.getType(), 1, mediaLibImage3.getWidth(), mediaLibImage3.getHeight());
                }
                Image.DataTypeConvert(mediaLibImageArray[0], mediaLibImageArray4[0]);
            } else {
                mediaLibImageArray[0] = mediaLibImageArray4[0];
            }
            Image.Thresh1(mediaLibImageArray[0], new int[]{0}, new int[]{this.ghigh[0]}, new int[]{this.glow[0]});
            mediaLibImage4 = mediaLibImageArray[0];
        } else {
            if (mediaLibImageArray2 == null) {
                mediaLibImageArray2 = new mediaLibImage[]{null};
            }
            if (mediaLibImageArray2[0] == null) {
                mediaLibImageArray2[0] = mediaLibImage2.createCompatibleImage();
            }
            mediaLibImage4 = mediaLibImageArray2[0];
            Image.Thresh1(mediaLibImage4, mediaLibImage3, nArray, this.ghigh, this.glow);
        }
        return mediaLibImage4;
    }
}

