/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibScaleOpImage;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;

final class MlibScaleBicubicOpImage
extends MlibScaleOpImage {
    public MlibScaleBicubicOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, borderExtender, map, imageLayout, f, f2, f3, f4, interpolation, true);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = 2;
        if (this.interp instanceof InterpolationBicubic2) {
            n = 3;
        }
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n2);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        double d = (double)this.scaleXRationalNum / (double)this.scaleXRationalDenom;
        double d2 = (double)this.scaleYRationalNum / (double)this.scaleYRationalDenom;
        long l = this.scaleXRationalDenom * this.transXRationalDenom;
        long l2 = this.scaleYRationalDenom * this.transYRationalDenom;
        long l3 = (long)rectangle2.x * this.scaleXRationalNum * this.transXRationalDenom + this.transXRationalNum * this.scaleXRationalDenom - (long)rectangle.x * l;
        long l4 = (long)rectangle2.y * this.scaleYRationalNum * this.transYRationalDenom + this.transYRationalNum * this.scaleYRationalDenom - (long)rectangle.y * l2;
        double d3 = (double)l3 / (double)l;
        double d4 = (double)l4 / (double)l2;
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    Image.ZoomTranslate(mediaLibImageArray2[n3], mediaLibImageArray[n3], d, d2, d3, d4, n, 0);
                    ++n3;
                }
                break;
            }
            case 4: 
            case 5: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray3 = mediaLibAccessor2.getMediaLibImages();
                int n4 = 0;
                while (n4 < mediaLibImageArray3.length) {
                    Image.ZoomTranslate_Fp(mediaLibImageArray3[n4], mediaLibImageArray[n4], d, d2, d3, d4, n, 0);
                    ++n4;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

