/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.RMIServerProxy;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;

public final class JAIRMIUtil {
    public static Vector replaceIdWithSources(Vector vector2, Hashtable hashtable, String string, RenderingHints renderingHints) {
        Vector<Object> vector3 = new Vector<Object>();
        int n = 0;
        while (n < vector2.size()) {
            Object object;
            Object e = vector2.elementAt(n);
            if (e instanceof String) {
                boolean bl;
                object = (String)e;
                int n2 = ((String)object).indexOf("::");
                boolean bl2 = bl = n2 != -1;
                if (bl) {
                    vector3.add(new RMIServerProxy((String)object, string, renderingHints));
                } else {
                    vector3.add(hashtable.get(Long.valueOf((String)object)));
                }
            } else {
                object = PlanarImage.wrapRenderedImage((RenderedImage)e);
                vector3.add(object);
            }
            ++n;
        }
        return vector3;
    }

    public static Vector replaceSourcesWithId(Vector vector2, String string) {
        Vector<Object> vector3 = new Vector<Object>();
        int n = 0;
        while (n < vector2.size()) {
            Object object;
            RenderedImage renderedImage;
            Object e = vector2.elementAt(n);
            if (e instanceof RMIServerProxy) {
                renderedImage = (RMIServerProxy)e;
                if (((PlanarImageServerProxy)renderedImage).getServerName().equalsIgnoreCase(string)) {
                    vector3.add(((RMIServerProxy)renderedImage).getRMIID().toString());
                } else {
                    object = new String(((PlanarImageServerProxy)renderedImage).getServerName() + "::" + ((RMIServerProxy)renderedImage).getRMIID());
                    vector3.add(object);
                }
            } else if (e instanceof RemoteRenderedOp) {
                RenderedImage renderedImage2;
                renderedImage = (RemoteRenderedOp)e;
                object = ((RenderedOp)renderedImage).getRendering();
                if (object instanceof RMIServerProxy) {
                    renderedImage2 = (RMIServerProxy)object;
                    if (((PlanarImageServerProxy)renderedImage2).getServerName().equalsIgnoreCase(string)) {
                        vector3.add(((RMIServerProxy)renderedImage2).getRMIID().toString());
                    } else {
                        String string2 = new String(((PlanarImageServerProxy)renderedImage2).getServerName() + "::" + ((RMIServerProxy)renderedImage2).getRMIID());
                        vector3.add(string2);
                    }
                } else {
                    renderedImage2 = (RenderedImage)object;
                    vector3.add(new SerializableRenderedImage(renderedImage2));
                }
            } else if (e instanceof RenderedOp) {
                renderedImage = (RenderedOp)e;
                vector3.add(new SerializableRenderedImage(((RenderedOp)renderedImage).getRendering()));
            } else if (e instanceof Serializable) {
                vector3.add(e);
            } else if (e instanceof RenderedImage) {
                renderedImage = (RenderedImage)e;
                vector3.add(new SerializableRenderedImage(renderedImage));
            }
            ++n;
        }
        return vector3;
    }

    public static Object replaceImage(RenderedImage renderedImage, String string) {
        if (renderedImage instanceof RMIServerProxy) {
            RMIServerProxy rMIServerProxy = (RMIServerProxy)renderedImage;
            if (rMIServerProxy.getServerName().equalsIgnoreCase(string)) {
                return "::" + rMIServerProxy.getRMIID();
            }
            return rMIServerProxy.getServerName() + "::" + rMIServerProxy.getRMIID() + ";;" + rMIServerProxy.getOperationName();
        }
        if (renderedImage instanceof RenderedOp) {
            PlanarImage planarImage = ((RenderedOp)renderedImage).getRendering();
            return JAIRMIUtil.replaceImage(planarImage, string);
        }
        if (renderedImage instanceof RenderedImage) {
            if (renderedImage instanceof Serializable) {
                return renderedImage;
            }
            return new SerializableRenderedImage(renderedImage);
        }
        return renderedImage;
    }

    public static void checkClientParameters(ParameterBlock parameterBlock, String string) {
        if (parameterBlock == null) {
            return;
        }
        int n = parameterBlock.getNumParameters();
        Vector<Object> vector2 = parameterBlock.getParameters();
        int n2 = 0;
        while (n2 < n) {
            Object object = vector2.elementAt(n2);
            if (object != null && object instanceof RenderedImage) {
                parameterBlock.set(JAIRMIUtil.replaceImage((RenderedImage)object, string), n2);
            }
            ++n2;
        }
    }

    public static void checkClientParameters(Vector vector2, String string) {
        if (vector2 == null) {
            return;
        }
        int n = 0;
        while (n < vector2.size()) {
            Object e = vector2.elementAt(n);
            if (e != null && e instanceof RenderedImage) {
                vector2.set(n, JAIRMIUtil.replaceImage((RenderedImage)e, string));
            }
            ++n;
        }
    }

    public static Object replaceStringWithImage(String string, Hashtable hashtable) {
        int n = string.indexOf("::");
        int n2 = string.indexOf(";;");
        if (n == -1) {
            return string;
        }
        if (n2 == -1) {
            Long l = Long.valueOf(string.substring(n + 2));
            return hashtable.get(l);
        }
        Long l = Long.valueOf(string.substring(n + 2, n2));
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + 2);
        return new RMIServerProxy(string2 + "::" + l, string3, null);
    }

    public static void checkServerParameters(ParameterBlock parameterBlock, Hashtable hashtable) {
        if (parameterBlock == null) {
            return;
        }
        int n = parameterBlock.getNumParameters();
        Vector<Object> vector2 = parameterBlock.getParameters();
        int n2 = 0;
        while (n2 < n) {
            Object object = vector2.elementAt(n2);
            if (object != null && object instanceof String) {
                parameterBlock.set(JAIRMIUtil.replaceStringWithImage((String)object, hashtable), n2);
            }
            ++n2;
        }
    }

    public static void checkServerParameters(Vector vector2, Hashtable hashtable) {
        if (vector2 == null) {
            return;
        }
        int n = 0;
        while (n < vector2.size()) {
            Object e = vector2.elementAt(n);
            if (e != null && e instanceof String) {
                vector2.set(n, JAIRMIUtil.replaceStringWithImage((String)e, hashtable));
            }
            ++n;
        }
    }
}

