/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.SerializableStateImpl;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class RenderingHintsState
extends SerializableStateImpl {
    private static final Class[] KEY_CLASSES = new Class[]{class$java$awt$RenderingHints == null ? (class$java$awt$RenderingHints = RenderingHintsState.class$("java.awt.RenderingHints")) : class$java$awt$RenderingHints, class$javax$media$jai$JAI == null ? (class$javax$media$jai$JAI = RenderingHintsState.class$("javax.media.jai.JAI")) : class$javax$media$jai$JAI};
    private static final Object[] SUPPRESSED_KEYS = new Object[]{JAI.KEY_OPERATION_REGISTRY, JAI.KEY_TILE_CACHE, JAI.KEY_RETRY_INTERVAL, JAI.KEY_NUM_RETRIES, JAI.KEY_NEGOTIATION_PREFERENCES};
    private static SoftReference suppressedKeyReference = null;
    private static SoftReference hintTableReference = null;
    static /* synthetic */ Class class$java$awt$RenderingHints;
    static /* synthetic */ Class class$javax$media$jai$JAI;

    public static Class[] getSupportedClasses() {
        return new Class[]{class$java$awt$RenderingHints == null ? (class$java$awt$RenderingHints = RenderingHintsState.class$("java.awt.RenderingHints")) : class$java$awt$RenderingHints};
    }

    public RenderingHintsState(Class clazz, Object object, RenderingHints renderingHints) {
        super(clazz, object, renderingHints);
    }

    private static synchronized Vector getSuppressedKeys() {
        Vector<Object> vector2 = null;
        if (SUPPRESSED_KEYS != null) {
            Vector<Object> vector3 = vector2 = suppressedKeyReference != null ? (Vector<Object>)suppressedKeyReference.get() : null;
            if (vector2 == null) {
                int n = SUPPRESSED_KEYS.length;
                vector2 = new Vector<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    vector2.add(SUPPRESSED_KEYS[n2]);
                    ++n2;
                }
                suppressedKeyReference = new SoftReference(vector2);
            }
        }
        return vector2;
    }

    static synchronized Hashtable getHintTable() {
        Hashtable<Object, HintElement> hashtable;
        Hashtable<Object, HintElement> hashtable2 = hashtable = hintTableReference != null ? (Hashtable<Object, HintElement>)hintTableReference.get() : null;
        if (hashtable == null) {
            hashtable = new Hashtable<Object, HintElement>();
            int n = 0;
            while (n < KEY_CLASSES.length) {
                Class clazz = KEY_CLASSES[n];
                Field[] fieldArray = clazz.getFields();
                int n2 = 0;
                while (n2 < fieldArray.length) {
                    Field field = fieldArray[n2];
                    int n3 = field.getModifiers();
                    if (Modifier.isPublic(n3) && Modifier.isStatic(n3)) {
                        try {
                            Object object = field.get(null);
                            hashtable.put(object, new HintElement(clazz, field));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            hintTableReference = new SoftReference(hashtable);
        }
        return hashtable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Set<Object> set;
        RenderingHints renderingHints = (RenderingHints)this.theObject;
        Hashtable<SerializableState, HintElement> hashtable = new Hashtable<SerializableState, HintElement>();
        if (renderingHints != null && !renderingHints.isEmpty() && !(set = renderingHints.keySet()).isEmpty()) {
            Iterator<Object> iterator = set.iterator();
            Hashtable hashtable2 = RenderingHintsState.getHintTable();
            Vector vector2 = RenderingHintsState.getSuppressedKeys();
            while (iterator.hasNext()) {
                SerializableState serializableState;
                Object object = iterator.next();
                if (vector2 != null && vector2.indexOf(object) != -1 || (serializableState = SerializerFactory.getState(object, null)) == null) continue;
                Object object2 = renderingHints.get(object);
                HintElement hintElement = null;
                try {
                    hintElement = new HintElement(object2);
                }
                catch (NotSerializableException notSerializableException) {
                    hintElement = (HintElement)hashtable2.get(object2);
                }
                if (hintElement == null) continue;
                hashtable.put(serializableState, hintElement);
            }
        }
        objectOutputStream.writeObject(hashtable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        RenderingHints renderingHints = new RenderingHints(null);
        this.theObject = renderingHints;
        if (hashtable.isEmpty()) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            SerializableState serializableState = (SerializableState)enumeration.nextElement();
            Object object = serializableState.getObject();
            HintElement hintElement = (HintElement)hashtable.get(serializableState);
            Object object2 = hintElement.getObject();
            renderingHints.put(object, object2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class HintElement
    implements Serializable {
        private static final int TYPE_OBJECT = 1;
        private static final int TYPE_FIELD = 2;
        private int type;
        private Object obj;
        private String className;
        private String fieldName;

        public HintElement(Object object) throws NotSerializableException {
            if (!(object instanceof Serializable)) {
                throw new NotSerializableException();
            }
            this.type = 1;
            this.obj = object;
        }

        public HintElement(Class clazz, Field field) {
            this.type = 2;
            this.className = clazz.getName();
            this.fieldName = field.getName();
        }

        public Object getObject() {
            Object object = null;
            if (this.type == 1) {
                object = this.obj;
            } else if (this.type == 2) {
                try {
                    Class<?> clazz = Class.forName(this.className);
                    Field field = clazz.getField(this.fieldName);
                    object = field.get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }
    }
}

