/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.DeferredData;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class ImageUtil {
    private static final float FLOAT_MIN = -3.4028235E38f;
    private static long counter;
    public static final int BYTE_MASK = 255;
    public static final int USHORT_MASK = 65535;
    static /* synthetic */ Class class$java$awt$image$ColorModel;
    static /* synthetic */ Class class$java$awt$image$SampleModel;
    static /* synthetic */ Class class$com$sun$media$jai$util$ImageUtil;

    public static final byte clampByte(int n) {
        return n > 255 ? (byte)-1 : (n >= 0 ? (byte)n : (byte)0);
    }

    public static final short clampUShort(int n) {
        return n > 65535 ? (short)-1 : (n >= 0 ? (short)n : (short)0);
    }

    public static final short clampShort(int n) {
        return (short)(n > Short.MAX_VALUE ? Short.MAX_VALUE : (n >= Short.MIN_VALUE ? (int)n : Short.MIN_VALUE));
    }

    public static final int clampInt(long l) {
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l >= Integer.MIN_VALUE ? (int)l : Integer.MIN_VALUE);
    }

    public static final float clampFloat(double d) {
        return d > 3.4028234663852886E38 ? Float.MAX_VALUE : (d >= -3.4028234663852886E38 ? (float)d : -3.4028235E38f);
    }

    public static final byte clampRoundByte(float f) {
        return f > 255.0f ? (byte)-1 : (f >= 0.0f ? (byte)(f + 0.5f) : (byte)0);
    }

    public static final byte clampRoundByte(double d) {
        return d > 255.0 ? (byte)-1 : (d >= 0.0 ? (byte)(d + 0.5) : (byte)0);
    }

    public static final short clampRoundUShort(float f) {
        return f > 65535.0f ? (short)-1 : (f >= 0.0f ? (short)(f + 0.5f) : (short)0);
    }

    public static final short clampRoundUShort(double d) {
        return d > 65535.0 ? (short)-1 : (d >= 0.0 ? (short)(d + 0.5) : (short)0);
    }

    public static final short clampRoundShort(float f) {
        return (short)(f > 32767.0f ? Short.MAX_VALUE : (f >= -32768.0f ? (int)((int)Math.floor(f + 0.5f)) : Short.MIN_VALUE));
    }

    public static final short clampRoundShort(double d) {
        return (short)(d > 32767.0 ? Short.MAX_VALUE : (d >= -32768.0 ? (int)((int)Math.floor(d + 0.5)) : Short.MIN_VALUE));
    }

    public static final int clampRoundInt(float f) {
        return f > 2.1474836E9f ? Integer.MAX_VALUE : (f >= -2.1474836E9f ? (int)Math.floor(f + 0.5f) : Integer.MIN_VALUE);
    }

    public static final int clampRoundInt(double d) {
        return d > 2.147483647E9 ? Integer.MAX_VALUE : (d >= -2.147483648E9 ? (int)Math.floor(d + 0.5) : Integer.MIN_VALUE);
    }

    public static final byte clampBytePositive(int n) {
        return (byte)(n > 255 ? -1 : (byte)n);
    }

    public static final byte clampByteNegative(int n) {
        return n < 0 ? (byte)0 : (byte)n;
    }

    public static final short clampUShortPositive(int n) {
        return (short)(n > 65535 ? -1 : (short)n);
    }

    public static final short clampUShortNegative(int n) {
        return n < 0 ? (short)0 : (short)n;
    }

    public static final void copyRaster(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getPixelStride();
        int n4 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getWidth() * n3;
        int n6 = rasterAccessor2.getHeight() * n4;
        int n7 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                byte[][] byArray = rasterAccessor.getByteDataArrays();
                byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
                int n8 = 0;
                while (n8 < n7) {
                    byte[] byArray3 = byArray[n8];
                    byte[] byArray4 = byArray2[n8];
                    int n9 = nArray2[n8] + n6;
                    int n10 = nArray2[n8];
                    int n11 = nArray[n8];
                    while (n10 < n9) {
                        int n12 = n10 + n5;
                        int n13 = n10;
                        int n14 = n11;
                        while (n13 < n12) {
                            byArray4[n13] = byArray3[n14];
                            n13 += n3;
                            n14 += n;
                        }
                        n10 += n4;
                        n11 += n2;
                    }
                    ++n8;
                }
                break;
            }
            case 1: 
            case 2: {
                short[][] sArray = rasterAccessor.getShortDataArrays();
                short[][] sArray2 = rasterAccessor2.getShortDataArrays();
                int n15 = 0;
                while (n15 < n7) {
                    short[] sArray3 = sArray[n15];
                    short[] sArray4 = sArray2[n15];
                    int n16 = nArray2[n15] + n6;
                    int n17 = nArray2[n15];
                    int n18 = nArray[n15];
                    while (n17 < n16) {
                        int n19 = n17 + n5;
                        int n20 = n17;
                        int n21 = n18;
                        while (n20 < n19) {
                            sArray4[n20] = sArray3[n21];
                            n20 += n3;
                            n21 += n;
                        }
                        n17 += n4;
                        n18 += n2;
                    }
                    ++n15;
                }
                break;
            }
            case 3: {
                int[][] nArray3 = rasterAccessor.getIntDataArrays();
                int[][] nArray4 = rasterAccessor2.getIntDataArrays();
                int n22 = 0;
                while (n22 < n7) {
                    int[] nArray5 = nArray3[n22];
                    int[] nArray6 = nArray4[n22];
                    int n23 = nArray2[n22] + n6;
                    int n24 = nArray2[n22];
                    int n25 = nArray[n22];
                    while (n24 < n23) {
                        int n26 = n24 + n5;
                        int n27 = n24;
                        int n28 = n25;
                        while (n27 < n26) {
                            nArray6[n27] = nArray5[n28];
                            n27 += n3;
                            n28 += n;
                        }
                        n24 += n4;
                        n25 += n2;
                    }
                    ++n22;
                }
                break;
            }
            case 4: {
                float[][] fArray = rasterAccessor.getFloatDataArrays();
                float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
                int n29 = 0;
                while (n29 < n7) {
                    float[] fArray3 = fArray[n29];
                    float[] fArray4 = fArray2[n29];
                    int n30 = nArray2[n29] + n6;
                    int n31 = nArray2[n29];
                    int n32 = nArray[n29];
                    while (n31 < n30) {
                        int n33 = n31 + n5;
                        int n34 = n31;
                        int n35 = n32;
                        while (n34 < n33) {
                            fArray4[n34] = fArray3[n35];
                            n34 += n3;
                            n35 += n;
                        }
                        n31 += n4;
                        n32 += n2;
                    }
                    ++n29;
                }
                break;
            }
            case 5: {
                double[][] dArray = rasterAccessor.getDoubleDataArrays();
                double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
                int n36 = 0;
                while (n36 < n7) {
                    double[] dArray3 = dArray[n36];
                    double[] dArray4 = dArray2[n36];
                    int n37 = nArray2[n36] + n6;
                    int n38 = nArray2[n36];
                    int n39 = nArray[n36];
                    while (n38 < n37) {
                        int n40 = n38 + n5;
                        int n41 = n38;
                        int n42 = n39;
                        while (n41 < n40) {
                            dArray4[n41] = dArray3[n42];
                            n41 += n3;
                            n42 += n;
                        }
                        n38 += n4;
                        n39 += n2;
                    }
                    ++n36;
                }
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    public boolean areEqualSampleModels(SampleModel sampleModel, SampleModel sampleModel2) {
        if (sampleModel == sampleModel2) {
            return true;
        }
        if (sampleModel.getClass() == sampleModel2.getClass() && sampleModel.getDataType() == sampleModel2.getDataType() && sampleModel.getTransferType() == sampleModel2.getTransferType() && sampleModel.getWidth() == sampleModel2.getWidth() && sampleModel.getHeight() == sampleModel2.getHeight()) {
            if (sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)sampleModel2;
                return componentSampleModel.getPixelStride() == componentSampleModel2.getPixelStride() && componentSampleModel.getScanlineStride() == componentSampleModel2.getScanlineStride() && Arrays.equals(componentSampleModel.getBankIndices(), componentSampleModel2.getBankIndices()) && Arrays.equals(componentSampleModel.getBandOffsets(), componentSampleModel2.getBandOffsets());
            }
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)sampleModel2;
                return multiPixelPackedSampleModel.getPixelBitStride() == multiPixelPackedSampleModel2.getPixelBitStride() && multiPixelPackedSampleModel.getScanlineStride() == multiPixelPackedSampleModel2.getScanlineStride() && multiPixelPackedSampleModel.getDataBitOffset() == multiPixelPackedSampleModel2.getDataBitOffset();
            }
            if (sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)sampleModel2;
                return singlePixelPackedSampleModel.getScanlineStride() == singlePixelPackedSampleModel2.getScanlineStride() && Arrays.equals(singlePixelPackedSampleModel.getBitMasks(), singlePixelPackedSampleModel2.getBitMasks());
            }
        }
        return false;
    }

    public static boolean isBinary(SampleModel sampleModel) {
        return sampleModel instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride() == 1 && sampleModel.getNumBands() == 1;
    }

    public static byte[] getPackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block29: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block27: {
                block30: {
                    block28: {
                        SampleModel sampleModel = raster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                        }
                        int n7 = rectangle.x;
                        int n8 = rectangle.y;
                        n6 = rectangle.width;
                        n5 = rectangle.height;
                        dataBuffer = raster.getDataBuffer();
                        int n9 = n7 - raster.getSampleModelTranslateX();
                        int n10 = n8 - raster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n4 = multiPixelPackedSampleModel.getScanlineStride();
                        n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                        n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                        n = (n6 + 7) / 8;
                        if (dataBuffer instanceof DataBufferByte && n3 == 0 && n2 == 0 && n == n4 && ((DataBufferByte)dataBuffer).getData().length == n * n5) {
                            return ((DataBufferByte)dataBuffer).getData();
                        }
                        byArray = new byte[n * n5];
                        int n11 = 0;
                        if (n2 != 0) break block27;
                        if (!(dataBuffer instanceof DataBufferByte)) break block28;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        int n12 = n;
                        int n13 = 0;
                        int n14 = 0;
                        while (n14 < n5) {
                            System.arraycopy(byArray2, n3, byArray, n13, n12);
                            n13 += n12;
                            n3 += n4;
                            ++n14;
                        }
                        break block29;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block30;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    int n15 = 0;
                    while (n15 < n5) {
                        int n16 = n6;
                        int n17 = n3;
                        while (n16 > 8) {
                            short s = sArray[n17++];
                            byArray[n11++] = (byte)(s >>> 8 & 0xFF);
                            byArray[n11++] = (byte)(s & 0xFF);
                            n16 -= 16;
                        }
                        if (n16 > 0) {
                            byArray[n11++] = (byte)(sArray[n17] >>> 8 & 0xFF);
                        }
                        n3 += n4;
                        ++n15;
                    }
                    break block29;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block29;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n18 = 0;
                while (n18 < n5) {
                    int n19;
                    int n20 = n6;
                    int n21 = n3;
                    while (n20 > 24) {
                        n19 = nArray[n21++];
                        byArray[n11++] = (byte)(n19 >>> 24 & 0xFF);
                        byArray[n11++] = (byte)(n19 >>> 16 & 0xFF);
                        byArray[n11++] = (byte)(n19 >>> 8 & 0xFF);
                        byArray[n11++] = (byte)(n19 & 0xFF);
                        n20 -= 32;
                    }
                    n19 = 24;
                    while (n20 > 0) {
                        byArray[n11++] = (byte)(nArray[n21] >>> n19 & 0xFF);
                        n19 -= 8;
                        n20 -= 8;
                    }
                    n3 += n4;
                    ++n18;
                }
                break block29;
            }
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n2 & 7) == 0) {
                    int n22 = n;
                    int n23 = 0;
                    int n24 = 0;
                    while (n24 < n5) {
                        System.arraycopy(byArray3, n3, byArray, n23, n22);
                        n23 += n22;
                        n3 += n4;
                        ++n24;
                    }
                } else {
                    int n25 = n2 & 7;
                    int n26 = 8 - n25;
                    int n27 = 0;
                    while (n27 < n5) {
                        int n28 = n3;
                        int n29 = n6;
                        while (n29 > 0) {
                            byArray[n11++] = n29 > n26 ? (byte)((byArray3[n28++] & 0xFF) << n25 | (byArray3[n28] & 0xFF) >>> n26) : (byte)((byArray3[n28] & 0xFF) << n25);
                            n29 -= 8;
                        }
                        n3 += n4;
                        ++n27;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n30 = 0;
                while (n30 < n5) {
                    int n31 = n2;
                    int n32 = 0;
                    while (n32 < n6) {
                        int n33 = n3 + n31 / 16;
                        int n34 = n31 % 16;
                        int n35 = sArray[n33] & 0xFFFF;
                        if (n34 <= 8) {
                            byArray[n11++] = (byte)(n35 >>> 8 - n34);
                        } else {
                            int n36 = n34 - 8;
                            int n37 = sArray[n33 + 1] & 0xFFFF;
                            byArray[n11++] = (byte)(n35 << n36 | n37 >>> 16 - n36);
                        }
                        n32 += 8;
                        n31 += 8;
                    }
                    n3 += n4;
                    ++n30;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n38 = 0;
                while (n38 < n5) {
                    int n39 = n2;
                    int n40 = 0;
                    while (n40 < n6) {
                        int n41 = n3 + n39 / 32;
                        int n42 = n39 % 32;
                        int n43 = nArray[n41];
                        if (n42 <= 24) {
                            byArray[n11++] = (byte)(n43 >>> 24 - n42);
                        } else {
                            int n44 = n42 - 24;
                            int n45 = nArray[n41 + 1];
                            byArray[n11++] = (byte)(n43 << n44 | n45 >>> 32 - n44);
                        }
                        n40 += 8;
                        n39 += 8;
                    }
                    n3 += n4;
                    ++n38;
                }
            }
        }
        return byArray;
    }

    public static byte[] getUnpackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block8: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            int n6;
            int n7;
            block9: {
                block7: {
                    SampleModel sampleModel = raster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                    }
                    n7 = rectangle.x;
                    n6 = rectangle.y;
                    int n8 = rectangle.width;
                    int n9 = rectangle.height;
                    dataBuffer = raster.getDataBuffer();
                    int n10 = n7 - raster.getSampleModelTranslateX();
                    int n11 = n6 - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n5 = multiPixelPackedSampleModel.getScanlineStride();
                    n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                    n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                    byArray = new byte[n8 * n9];
                    n2 = n6 + n9;
                    n = n7 + n8;
                    int n12 = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block7;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    int n13 = n6;
                    while (n13 < n2) {
                        int n14 = n4 * 8 + n3;
                        int n15 = n7;
                        while (n15 < n) {
                            byte by = byArray2[n14 / 8];
                            byArray[n12++] = (byte)(by >>> (7 - n14 & 7) & 1);
                            ++n14;
                            ++n15;
                        }
                        n4 += n5;
                        ++n13;
                    }
                    break block8;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block9;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n16 = n6;
                while (n16 < n2) {
                    int n17 = n4 * 16 + n3;
                    int n18 = n7;
                    while (n18 < n) {
                        short s = sArray[n17 / 16];
                        byArray[n12++] = (byte)(s >>> 15 - n17 % 16 & 1);
                        ++n17;
                        ++n18;
                    }
                    n4 += n5;
                    ++n16;
                }
                break block8;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block8;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            int n19 = n6;
            while (n19 < n2) {
                int n20 = n4 * 32 + n3;
                int n21 = n7;
                while (n21 < n) {
                    int n22 = nArray[n20 / 32];
                    byArray[n12++] = (byte)(n22 >>> 31 - n20 % 32 & 1);
                    ++n20;
                    ++n21;
                }
                n4 += n5;
                ++n19;
            }
        }
        return byArray;
    }

    public static void setPackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block43: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block41: {
                block44: {
                    block42: {
                        SampleModel sampleModel = writableRaster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                        }
                        int n7 = rectangle.x;
                        int n8 = rectangle.y;
                        n6 = rectangle.width;
                        n5 = rectangle.height;
                        dataBuffer = writableRaster.getDataBuffer();
                        int n9 = n7 - writableRaster.getSampleModelTranslateX();
                        int n10 = n8 - writableRaster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n4 = multiPixelPackedSampleModel.getScanlineStride();
                        n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                        n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                        n = 0;
                        if (n2 != 0) break block41;
                        if (!(dataBuffer instanceof DataBufferByte)) break block42;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        if (byArray2 == byArray) {
                            return;
                        }
                        int n11 = (n6 + 7) / 8;
                        int n12 = 0;
                        int n13 = 0;
                        while (n13 < n5) {
                            System.arraycopy(byArray, n12, byArray2, n3, n11);
                            n12 += n11;
                            n3 += n4;
                            ++n13;
                        }
                        break block43;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block44;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    int n14 = 0;
                    while (n14 < n5) {
                        int n15 = n6;
                        int n16 = n3;
                        while (n15 > 8) {
                            sArray[n16++] = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                            n15 -= 16;
                        }
                        if (n15 > 0) {
                            sArray[n16++] = (short)((byArray[n++] & 0xFF) << 8);
                        }
                        n3 += n4;
                        ++n14;
                    }
                    break block43;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block43;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n17 = 0;
                while (n17 < n5) {
                    int n18 = n6;
                    int n19 = n3;
                    while (n18 > 24) {
                        nArray[n19++] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                        n18 -= 32;
                    }
                    int n20 = 24;
                    while (n18 > 0) {
                        int n21 = n19;
                        nArray[n21] = nArray[n21] | (byArray[n++] & 0xFF) << n20;
                        n20 -= 8;
                        n18 -= 8;
                    }
                    n3 += n4;
                    ++n17;
                }
                break block43;
            }
            int n22 = (n6 + 7) / 8;
            int n23 = 0;
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n2 & 7) == 0) {
                    int n24 = 0;
                    while (n24 < n5) {
                        System.arraycopy(byArray, n23, byArray3, n3, n22);
                        n23 += n22;
                        n3 += n4;
                        ++n24;
                    }
                } else {
                    int n25 = n2 & 7;
                    int n26 = 8 - n25;
                    int n27 = 8 + n26;
                    byte by = (byte)(255 << n26);
                    byte by2 = ~by;
                    int n28 = 0;
                    while (n28 < n5) {
                        int n29 = n3;
                        int n30 = n6;
                        while (n30 > 0) {
                            byte by3 = byArray[n++];
                            if (n30 > n27) {
                                byArray3[n29] = (byte)(byArray3[n29] & by | (by3 & 0xFF) >>> n25);
                                byArray3[++n29] = (byte)((by3 & 0xFF) << n26);
                            } else if (n30 > n26) {
                                byArray3[n29] = (byte)(byArray3[n29] & by | (by3 & 0xFF) >>> n25);
                                byArray3[++n29] = (byte)(byArray3[n29] & by2 | (by3 & 0xFF) << n26);
                            } else {
                                int n31 = (1 << n26 - n30) - 1;
                                byArray3[n29] = (byte)(byArray3[n29] & (by | n31) | (by3 & 0xFF) >>> n25 & ~n31);
                            }
                            n30 -= 8;
                        }
                        n3 += n4;
                        ++n28;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n32 = n2 & 7;
                int n33 = 8 - n32;
                int n34 = 16 + n33;
                short s = (short)(~(255 << n33));
                short s2 = (short)(65535 << n33);
                short s3 = ~s2;
                int n35 = 0;
                while (n35 < n5) {
                    int n36 = n2;
                    int n37 = n6;
                    int n38 = 0;
                    while (n38 < n6) {
                        int n39 = n3 + (n36 >> 4);
                        int n40 = n36 & 0xF;
                        int n41 = byArray[n++] & 0xFF;
                        if (n40 <= 8) {
                            if (n37 < 8) {
                                n41 &= 255 << 8 - n37;
                            }
                            sArray[n39] = (short)(sArray[n39] & s | n41 << n33);
                        } else if (n37 > n34) {
                            sArray[n39] = (short)(sArray[n39] & s2 | n41 >>> n32 & 0xFFFF);
                            sArray[++n39] = (short)(n41 << n33 & 0xFFFF);
                        } else if (n37 > n33) {
                            sArray[n39] = (short)(sArray[n39] & s2 | n41 >>> n32 & 0xFFFF);
                            sArray[++n39] = (short)(sArray[n39] & s3 | n41 << n33 & 0xFFFF);
                        } else {
                            int n42 = (1 << n33 - n37) - 1;
                            sArray[n39] = (short)(sArray[n39] & (s2 | n42) | n41 >>> n32 & 0xFFFF & ~n42);
                        }
                        n38 += 8;
                        n36 += 8;
                        n37 -= 8;
                    }
                    n3 += n4;
                    ++n35;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n43 = n2 & 7;
                int n44 = 8 - n43;
                int n45 = 32 + n44;
                int n46 = -1 << n44;
                int n47 = ~n46;
                int n48 = 0;
                while (n48 < n5) {
                    int n49 = n2;
                    int n50 = n6;
                    int n51 = 0;
                    while (n51 < n6) {
                        int n52;
                        int n53 = n3 + (n49 >> 5);
                        int n54 = n49 & 0x1F;
                        int n55 = byArray[n++] & 0xFF;
                        if (n54 <= 24) {
                            n52 = 24 - n54;
                            if (n50 < 8) {
                                n55 &= 255 << 8 - n50;
                            }
                            nArray[n53] = nArray[n53] & ~(255 << n52) | n55 << n52;
                        } else if (n50 > n45) {
                            nArray[n53] = nArray[n53] & n46 | n55 >>> n43;
                            nArray[++n53] = n55 << n44;
                        } else if (n50 > n44) {
                            nArray[n53] = nArray[n53] & n46 | n55 >>> n43;
                            nArray[++n53] = nArray[n53] & n47 | n55 << n44;
                        } else {
                            n52 = (1 << n44 - n50) - 1;
                            nArray[n53] = nArray[n53] & (n46 | n52) | n55 >>> n43 & ~n52;
                        }
                        n51 += 8;
                        n49 += 8;
                        n50 -= 8;
                    }
                    n3 += n4;
                    ++n48;
                }
            }
        }
    }

    public static void setUnpackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block11: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block12: {
                block10: {
                    SampleModel sampleModel = writableRaster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                    }
                    int n7 = rectangle.x;
                    int n8 = rectangle.y;
                    n6 = rectangle.width;
                    n5 = rectangle.height;
                    dataBuffer = writableRaster.getDataBuffer();
                    int n9 = n7 - writableRaster.getSampleModelTranslateX();
                    int n10 = n8 - writableRaster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n4 = multiPixelPackedSampleModel.getScanlineStride();
                    n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                    n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                    n = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block10;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    int n11 = 0;
                    while (n11 < n5) {
                        int n12 = n3 * 8 + n2;
                        int n13 = 0;
                        while (n13 < n6) {
                            if (byArray[n++] != 0) {
                                int n14 = n12 / 8;
                                byArray2[n14] = (byte)(byArray2[n14] | (byte)(1 << (7 - n12 & 7)));
                            }
                            ++n12;
                            ++n13;
                        }
                        n3 += n4;
                        ++n11;
                    }
                    break block11;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block12;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n15 = 0;
                while (n15 < n5) {
                    int n16 = n3 * 16 + n2;
                    int n17 = 0;
                    while (n17 < n6) {
                        if (byArray[n++] != 0) {
                            int n18 = n16 / 16;
                            sArray[n18] = (short)(sArray[n18] | (short)(1 << 15 - n16 % 16));
                        }
                        ++n16;
                        ++n17;
                    }
                    n3 += n4;
                    ++n15;
                }
                break block11;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block11;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            int n19 = 0;
            while (n19 < n5) {
                int n20 = n3 * 32 + n2;
                int n21 = 0;
                while (n21 < n6) {
                    if (byArray[n++] != 0) {
                        int n22 = n20 / 32;
                        nArray[n22] = nArray[n22] | 1 << 31 - n20 % 32;
                    }
                    ++n20;
                    ++n21;
                }
                n3 += n4;
                ++n19;
            }
        }
    }

    public static void fillBackground(WritableRaster writableRaster, Rectangle rectangle, double[] dArray) {
        block41: {
            PixelAccessor pixelAccessor;
            block40: {
                rectangle = rectangle.intersection(writableRaster.getBounds());
                int n = writableRaster.getSampleModel().getNumBands();
                SampleModel sampleModel = writableRaster.getSampleModel();
                pixelAccessor = new PixelAccessor(sampleModel, null);
                if (!ImageUtil.isBinary(sampleModel)) break block40;
                byte by = (byte)((int)dArray[0] & 1);
                if (by == 0) {
                    return;
                }
                int n2 = rectangle.x;
                int n3 = rectangle.y;
                int n4 = rectangle.width;
                int n5 = rectangle.height;
                int n6 = n2 - writableRaster.getSampleModelTranslateX();
                int n7 = n3 - writableRaster.getSampleModelTranslateY();
                DataBuffer dataBuffer = writableRaster.getDataBuffer();
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                int n8 = multiPixelPackedSampleModel.getScanlineStride();
                int n9 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n6, n7);
                int n10 = multiPixelPackedSampleModel.getBitOffset(n6);
                switch (sampleModel.getDataType()) {
                    case 0: {
                        byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                        int n11 = n10 & 7;
                        int n12 = n11 == 0 ? 0 : 8 - n11;
                        byte by2 = (byte)(255 >> n11);
                        int n13 = (n4 - n12) / 8;
                        int n14 = n4 - n12 & 7;
                        byte by3 = (byte)(255 << 8 - n14);
                        int n15 = 0;
                        while (n15 < n5) {
                            int n16 = n9;
                            if (n11 != 0) {
                                byArray[n16++] = by2;
                            }
                            int n17 = n16 + n13;
                            while (n16 < n17) {
                                byArray[n16++] = -1;
                            }
                            if (n14 != 0) {
                                byArray[n16++] = by3;
                            }
                            n9 += n8;
                            ++n15;
                        }
                        break block41;
                    }
                    case 1: 
                    case 2: {
                        short[] sArray = ((DataBufferShort)dataBuffer).getData();
                        int n18 = n10 & 0xF;
                        int n19 = n18 == 0 ? 0 : 16 - n18;
                        short s = (short)(65535 >> n18);
                        int n20 = (n4 - n19) / 16;
                        int n21 = n4 - n19 & 0xF;
                        short s2 = (short)(65535 << 16 - n21);
                        int n22 = 0;
                        while (n22 < n5) {
                            int n23 = n9;
                            if (n18 != 0) {
                                sArray[n23++] = s;
                            }
                            int n24 = n23 + n20;
                            while (n23 < n24) {
                                sArray[n23++] = -1;
                            }
                            if (n21 != 0) {
                                sArray[n23++] = s2;
                            }
                            n9 += n8;
                            ++n22;
                        }
                        break block41;
                    }
                    case 3: {
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n25 = n10 & 0x1F;
                        int n26 = n25 == 0 ? 0 : 32 - n25;
                        short s = (short)(-1 >> n25);
                        int n27 = (n4 - n26) / 32;
                        int n28 = n4 - n26 & 0x1F;
                        short s3 = (short)(-1 << 32 - n28);
                        int n29 = 0;
                        while (n29 < n5) {
                            int n30 = n9;
                            if (n25 != 0) {
                                nArray[n30++] = s;
                            }
                            int n31 = n30 + n27;
                            while (n30 < n31) {
                                nArray[n30++] = -1;
                            }
                            if (n28 != 0) {
                                nArray[n30++] = s3;
                            }
                            n9 += n8;
                            ++n29;
                        }
                        break block41;
                    }
                }
                break block41;
            }
            int n = pixelAccessor.sampleType == -1 ? 0 : pixelAccessor.sampleType;
            UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n, false);
            rectangle = unpackedImageData.rect;
            int n32 = unpackedImageData.lineStride;
            int n33 = unpackedImageData.pixelStride;
            switch (unpackedImageData.type) {
                case 0: {
                    byte[][] byArray = unpackedImageData.getByteData();
                    int n34 = 0;
                    while (n34 < pixelAccessor.numBands) {
                        byte by = (byte)dArray[n34];
                        byte[] byArray2 = byArray[n34];
                        int n35 = unpackedImageData.bandOffsets[n34] + rectangle.height * n32;
                        int n36 = unpackedImageData.bandOffsets[n34];
                        while (n36 < n35) {
                            int n37 = n36 + rectangle.width * n33;
                            int n38 = n36;
                            while (n38 < n37) {
                                byArray2[n38] = by;
                                n38 += n33;
                            }
                            n36 += n32;
                        }
                        ++n34;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = unpackedImageData.getShortData();
                    int n39 = 0;
                    while (n39 < pixelAccessor.numBands) {
                        short s = (short)dArray[n39];
                        short[] sArray2 = sArray[n39];
                        int n40 = unpackedImageData.bandOffsets[n39] + rectangle.height * n32;
                        int n41 = unpackedImageData.bandOffsets[n39];
                        while (n41 < n40) {
                            int n42 = n41 + rectangle.width * n33;
                            int n43 = n41;
                            while (n43 < n42) {
                                sArray2[n43] = s;
                                n43 += n33;
                            }
                            n41 += n32;
                        }
                        ++n39;
                    }
                    break;
                }
                case 3: {
                    int[][] nArray = unpackedImageData.getIntData();
                    int n44 = 0;
                    while (n44 < pixelAccessor.numBands) {
                        int n45 = (int)dArray[n44];
                        int[] nArray2 = nArray[n44];
                        int n46 = unpackedImageData.bandOffsets[n44] + rectangle.height * n32;
                        int n47 = unpackedImageData.bandOffsets[n44];
                        while (n47 < n46) {
                            int n48 = n47 + rectangle.width * n33;
                            int n49 = n47;
                            while (n49 < n48) {
                                nArray2[n49] = n45;
                                n49 += n33;
                            }
                            n47 += n32;
                        }
                        ++n44;
                    }
                    break;
                }
                case 4: {
                    float[][] fArray = unpackedImageData.getFloatData();
                    int n50 = 0;
                    while (n50 < pixelAccessor.numBands) {
                        float f = (float)dArray[n50];
                        float[] fArray2 = fArray[n50];
                        int n51 = unpackedImageData.bandOffsets[n50] + rectangle.height * n32;
                        int n52 = unpackedImageData.bandOffsets[n50];
                        while (n52 < n51) {
                            int n53 = n52 + rectangle.width * n33;
                            int n54 = n52;
                            while (n54 < n53) {
                                fArray2[n54] = f;
                                n54 += n33;
                            }
                            n52 += n32;
                        }
                        ++n50;
                    }
                    break;
                }
                case 5: {
                    double[][] dArray2 = unpackedImageData.getDoubleData();
                    int n55 = 0;
                    while (n55 < pixelAccessor.numBands) {
                        double d = dArray[n55];
                        double[] dArray3 = dArray2[n55];
                        int n56 = unpackedImageData.bandOffsets[n55] + rectangle.height * n32;
                        int n57 = unpackedImageData.bandOffsets[n55];
                        while (n57 < n56) {
                            int n58 = n57 + rectangle.width * n33;
                            int n59 = n57;
                            while (n59 < n58) {
                                dArray3[n59] = d;
                                n59 += n33;
                            }
                            n57 += n32;
                        }
                        ++n55;
                    }
                    break;
                }
            }
        }
    }

    public static void fillBordersWithBackgroundValues(Rectangle rectangle, Rectangle rectangle2, WritableRaster writableRaster, double[] dArray) {
        Rectangle rectangle3;
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle2.x + rectangle2.width;
        int n4 = rectangle2.y + rectangle2.height;
        if (rectangle.x < rectangle2.x) {
            rectangle3 = new Rectangle(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, n2 - rectangle2.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (rectangle.y < rectangle2.y) {
            rectangle3 = new Rectangle(rectangle.x, rectangle.y, n3 - rectangle.x, rectangle2.y - rectangle.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (n > n3) {
            rectangle3 = new Rectangle(n3, rectangle.y, n - n3, n4 - rectangle.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (n2 > n4) {
            rectangle3 = new Rectangle(rectangle2.x, n4, n - rectangle2.x, n2 - n4);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
    }

    public static KernelJAI getUnsharpMaskEquivalentKernel(KernelJAI kernelJAI, float f) {
        int n = kernelJAI.getWidth();
        int n2 = kernelJAI.getHeight();
        int n3 = kernelJAI.getXOrigin();
        int n4 = kernelJAI.getYOrigin();
        float[] fArray = kernelJAI.getKernelData();
        float[] fArray2 = new float[fArray.length];
        int n5 = 0;
        while (n5 < n * n2) {
            fArray2[n5] = -f * fArray[n5];
            ++n5;
        }
        n5 = n4 * n + n3;
        fArray2[n5] = 1.0f + f * (1.0f - fArray[n5]);
        return new KernelJAI(n, n2, n3, n4, fArray2);
    }

    public static final Point[] getTileIndices(int n, int n2, int n3, int n4) {
        if (n > n2 || n3 > n4) {
            return null;
        }
        Point[] pointArray = new Point[(n2 - n + 1) * (n4 - n3 + 1)];
        int n5 = 0;
        int n6 = n3;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n2) {
                pointArray[n5++] = new Point(n7, n6);
                ++n7;
            }
            ++n6;
        }
        return pointArray;
    }

    public static Vector evaluateParameters(Vector vector2) {
        if (vector2 == null) {
            throw new IllegalArgumentException();
        }
        Vector vector3 = vector2;
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector2.get(n2);
            if (e instanceof DeferredData) {
                if (vector3 == vector2) {
                    vector3 = (Vector)vector2.clone();
                }
                vector3.set(n2, ((DeferredData)e).getData());
            }
            ++n2;
        }
        return vector3;
    }

    public static ParameterBlock evaluateParameters(ParameterBlock parameterBlock) {
        if (parameterBlock == null) {
            throw new IllegalArgumentException();
        }
        Vector<Object> vector2 = parameterBlock.getParameters();
        Vector vector3 = ImageUtil.evaluateParameters(vector2);
        return vector3 == vector2 ? parameterBlock : new ParameterBlock(parameterBlock.getSources(), vector3);
    }

    public static ColorModel getCompatibleColorModel(SampleModel sampleModel, Map map) {
        ColorModel colorModel = null;
        if (map == null || !Boolean.FALSE.equals(map.get(JAI.KEY_DEFAULT_COLOR_MODEL_ENABLED))) {
            if (map != null && map.containsKey(JAI.KEY_DEFAULT_COLOR_MODEL_METHOD)) {
                Method method = (Method)map.get(JAI.KEY_DEFAULT_COLOR_MODEL_METHOD);
                Class<?>[] classArray = method.getParameterTypes();
                if ((method.getModifiers() & 8) != 8) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil1"));
                }
                if (method.getReturnType() != (class$java$awt$image$ColorModel == null ? (class$java$awt$image$ColorModel = ImageUtil.class$("java.awt.image.ColorModel")) : class$java$awt$image$ColorModel)) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil2"));
                }
                if (classArray.length != 1 || !classArray[0].equals(class$java$awt$image$SampleModel == null ? (class$java$awt$image$SampleModel = ImageUtil.class$("java.awt.image.SampleModel")) : class$java$awt$image$SampleModel)) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil3"));
                }
                try {
                    Object[] objectArray = new Object[]{sampleModel};
                    colorModel = (ColorModel)method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    String string = JaiI18N.getString("ImageUtil4") + method.getName();
                    ImageUtil.sendExceptionToListener(string, new ImagingException(string, exception));
                }
            } else {
                colorModel = PlanarImage.createColorModel(sampleModel);
            }
        }
        return colorModel;
    }

    public static String getStackTraceString(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public static ImagingListener getImagingListener(RenderingHints renderingHints) {
        ImagingListener imagingListener = null;
        if (renderingHints != null) {
            imagingListener = (ImagingListener)renderingHints.get(JAI.KEY_IMAGING_LISTENER);
        }
        if (imagingListener == null) {
            imagingListener = JAI.getDefaultInstance().getImagingListener();
        }
        return imagingListener;
    }

    public static ImagingListener getImagingListener(RenderContext renderContext) {
        return ImageUtil.getImagingListener(renderContext.getRenderingHints());
    }

    public static synchronized Object generateID(Object object) {
        Class<?> clazz = object.getClass();
        ++counter;
        byte[] byArray = new byte[32];
        int n = 0;
        int n2 = 7;
        int n3 = 0;
        while (n2 >= 0) {
            byArray[n++] = (byte)(counter >> n3);
            --n2;
            n3 += 8;
        }
        int n4 = clazz.hashCode();
        int n5 = 3;
        int n6 = 0;
        while (n5 >= 0) {
            byArray[n++] = (byte)(n4 >> n6);
            --n5;
            n6 += 8;
        }
        n4 = object.hashCode();
        int n7 = 3;
        int n8 = 0;
        while (n7 >= 0) {
            byArray[n++] = (byte)(n4 >> n8);
            --n7;
            n8 += 8;
        }
        long l = System.currentTimeMillis();
        int n9 = 7;
        int n10 = 0;
        while (n9 >= 0) {
            byArray[n++] = (byte)(l >> n10);
            --n9;
            n10 += 8;
        }
        long l2 = Double.doubleToLongBits(new Double(Math.random()));
        int n11 = 7;
        int n12 = 0;
        while (n11 >= 0) {
            byArray[n++] = (byte)(l2 >> n12);
            --n11;
            n12 += 8;
        }
        return new BigInteger(byArray);
    }

    static void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
        imagingListener.errorOccurred(string, exception, class$com$sun$media$jai$util$ImageUtil == null ? (class$com$sun$media$jai$util$ImageUtil = ImageUtil.class$("com.sun.media.jai.util.ImageUtil")) : class$com$sun$media$jai$util$ImageUtil, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

