/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.net;

import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.SystemUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class MIMEUtil {
    private static Map<String, List<String>> sExtToMIME = new HashMap<String, List<String>>();
    private static Map<String, List<String>> sUnmodifiableExtToMIME = Collections.unmodifiableMap(sExtToMIME);
    private static Map<String, List<String>> sMIMEToExt = new HashMap<String, List<String>>();
    private static Map<String, List<String>> sUnmodifiableMIMEToExt = Collections.unmodifiableMap(sMIMEToExt);

    private MIMEUtil() {
    }

    public static String getMIMEType(String string) {
        List<String> list2 = sExtToMIME.get(StringUtil.toLowerCase(string));
        return list2 == null || list2.isEmpty() ? null : list2.get(0);
    }

    public static List<String> getMIMETypes(String string) {
        List<String> list2 = sExtToMIME.get(StringUtil.toLowerCase(string));
        return MIMEUtil.maskNull(list2);
    }

    public static Map<String, List<String>> getMIMETypeMappings() {
        return sUnmodifiableExtToMIME;
    }

    public static String getExtension(String string) {
        String string2 = MIMEUtil.bareMIME(StringUtil.toLowerCase(string));
        List<String> list2 = sMIMEToExt.get(string2);
        return list2 == null || list2.isEmpty() ? null : list2.get(0);
    }

    public static List<String> getExtensions(String string) {
        String string2 = MIMEUtil.bareMIME(StringUtil.toLowerCase(string));
        if (string2.endsWith("/*")) {
            return MIMEUtil.getExtensionForWildcard(string2);
        }
        List<String> list2 = sMIMEToExt.get(string2);
        return MIMEUtil.maskNull(list2);
    }

    private static List<String> getExtensionForWildcard(String string) {
        String string2 = string.substring(0, string.length() - 1);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Map.Entry<String, List<String>> entry : sMIMEToExt.entrySet()) {
            if (!"*/".equals(string2) && !entry.getKey().startsWith(string2)) continue;
            linkedHashSet.addAll(entry.getValue());
        }
        return Collections.unmodifiableList(new ArrayList(linkedHashSet));
    }

    public static Map<String, List<String>> getExtensionMappings() {
        return sUnmodifiableMIMEToExt;
    }

    static boolean includes(String string, String string2) {
        String string3 = MIMEUtil.bareMIME(string2);
        return string3.equals(string) || "*/*".equals(string) || string.endsWith("/*") && string.startsWith(string3.substring(0, string3.indexOf(47)));
    }

    public static String bareMIME(String string) {
        int n;
        if (string != null && (n = string.indexOf(59)) >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private static List<String> maskNull(List<String> list2) {
        return list2 == null ? Collections.emptyList() : list2;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        Object object;
        Iterator<String> iterator;
        Object[] objectArray;
        Object object2;
        if (stringArray.length > 1) {
            object2 = stringArray[0];
            objectArray = stringArray[1];
            boolean n = MIMEUtil.includes((String)objectArray, (String)object2);
            System.out.println("Mime type family " + (String)objectArray + (n ? " includes " : " does not include ") + "type " + (String)object2);
        }
        if (stringArray.length > 0) {
            object2 = stringArray[0];
            if (((String)object2).indexOf(47) >= 0) {
                objectArray = MIMEUtil.getExtension((String)object2);
                System.out.println("Default extension for MIME type '" + (String)object2 + "' is " + (objectArray != null ? ": '" + (String)objectArray + "'" : "unknown") + ".");
                System.out.println("All possible: " + MIMEUtil.getExtensions((String)object2));
            } else {
                objectArray = MIMEUtil.getMIMEType((String)object2);
                System.out.println("Default MIME type for extension '" + (String)object2 + "' is " + (objectArray != null ? ": '" + (String)objectArray + "'" : "unknown") + ".");
                System.out.println("All possible: " + MIMEUtil.getMIMETypes((String)object2));
            }
            return;
        }
        object2 = sMIMEToExt.keySet();
        objectArray = new String[object2.size()];
        boolean bl = false;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            void var3_5;
            iterator = (String)iterator2.next();
            objectArray[var3_5] = iterator;
            ++var3_5;
        }
        Arrays.sort(objectArray);
        System.out.println("Known MIME types (" + objectArray.length + "):");
        for (int i = 0; i < objectArray.length; ++i) {
            iterator = objectArray[i];
            if (i != 0) {
                System.out.print(", ");
            }
            System.out.print((String)((Object)iterator));
        }
        System.out.println("\n");
        object2 = sExtToMIME.keySet();
        Object[] objectArray2 = new String[object2.size()];
        boolean bl2 = false;
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            void var3_7;
            objectArray2[var3_7] = object = iterator.next();
            ++var3_7;
        }
        Arrays.sort(objectArray2);
        System.out.println("Known file types (" + objectArray2.length + "):");
        for (int i = 0; i < objectArray2.length; ++i) {
            object = objectArray2[i];
            if (i != 0) {
                System.out.print(", ");
            }
            System.out.print((String)object);
        }
        System.out.println();
    }

    static {
        try {
            Properties properties = SystemUtil.loadProperties(MIMEUtil.class);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = StringUtil.toLowerCase((String)entry.getKey());
                List<String> list2 = Collections.unmodifiableList(Arrays.asList(StringUtil.toStringArray(string, ";, ")));
                String string2 = StringUtil.toLowerCase((String)entry.getValue());
                List<String> list3 = Collections.unmodifiableList(Arrays.asList(StringUtil.toStringArray(string2, ";, ")));
                for (String string3 : list2) {
                    sExtToMIME.put(string3, list3);
                }
                for (String string3 : list3) {
                    sMIMEToExt.put(string3, list2);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not read properties for MIMEUtil: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

