/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.cr2;

import it.tidalwave.imageio.cr2.CR2ImageReader;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;

public class CR2ImageReaderSpi
extends RAWImageReaderSpiSupport {
    private static final String CLASS = CR2ImageReaderSpi.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public CR2ImageReaderSpi() {
        super("CR2", "cr2", "image/x-canon-cr2", CR2ImageReader.class);
    }

    public String getDescription(Locale locale) {
        return "Standard CR2 Image Reader";
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new CR2ImageReader(this);
    }

    public boolean canDecodeInput(RAWImageInputStream iis) throws IOException {
        iis.seek(0L);
        long ifdOffset = TIFFImageReaderSupport.processHeader(iis, null);
        IFD primaryIFD = new IFD();
        primaryIFD.load(iis, ifdOffset);
        if (primaryIFD.isDNGVersionAvailable()) {
            return false;
        }
        String make = primaryIFD.getMake();
        String model = primaryIFD.getModel();
        if (make == null || !make.toUpperCase().startsWith("CANON") || model == null || !model.toUpperCase().startsWith("CANON EOS")) {
            logger.fine("CR2ImageReaderSpi giving up on: '%s' / %s'", make, model);
            return false;
        }
        return true;
    }
}

