/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.cr2;

import it.tidalwave.imageio.cr2.CR2SensorInfo;
import it.tidalwave.imageio.cr2.CanonCR2MakerNote;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import java.awt.Dimension;
import javax.annotation.Nonnull;

public class CR2Metadata
extends TIFFMetadataSupport {
    public CR2Metadata(@Nonnull Directory primaryIFD, @Nonnull RAWImageInputStream iis, @Nonnull HeaderProcessor headerProcessor) {
        super(primaryIFD, iis, headerProcessor);
    }

    @Nonnull
    public CanonCR2MakerNote getCanonMakerNote() {
        return (CanonCR2MakerNote)this.getMakerNote();
    }

    @Nonnull
    protected Dimension getImageSize() {
        CR2SensorInfo sensorInfo = this.getCanonMakerNote().getSensorInfo();
        return new Dimension(sensorInfo.getWidth(), sensorInfo.getHeight());
    }

    protected boolean isRasterIFD(@Nonnull IFD ifd) {
        return ifd.isCanon50648Available();
    }

    protected boolean isThumbnailIFD(@Nonnull IFD ifd) {
        return !ifd.isCanon50648Available();
    }
}

