/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class RAFRasterReader
extends RasterReader {
    private int cfaWidth;
    private int cfaHeight;
    private boolean fujiLayout;
    private int offset;
    private int topMargin;
    private int leftMargin;

    public void setCFAHeight(int cfaHeight) {
        this.cfaHeight = cfaHeight;
    }

    public void setCFAWidth(int cfaWidth) {
        this.cfaWidth = cfaWidth;
    }

    public void setFujiLayout(boolean fujiLayout) {
        this.fujiLayout = fujiLayout;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    protected boolean isCompressedRaster() {
        return false;
    }

    protected void loadUncompressedRaster(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
        iis.seek(this.rasterOffset);
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = this.offset * (this.fujiLayout ? 1 : 2);
        int pixelStride = 3;
        int scanStride = 3 * raster.getWidth();
        for (int y = 0; y < this.cfaHeight - 1; ++y) {
            if (this.fujiLayout) {
                for (int x = 0; x < width; ++x) {
                    int y0 = this.offset - 1 - x + (y >> 1);
                    int x0 = x + (y + 1 >> 1);
                    int cfaIndex = 2 * (y0 & 1) + (x0 & 1);
                    data[x0 * 3 + y0 * scanStride + this.cfaOffsets[cfaIndex]] = iis.readShort();
                }
            } else {
                int y0 = this.offset + y;
                int x0 = y;
                int scan = x0 * 3 + y0 * scanStride;
                for (int col = 0; col < width; ++col) {
                    if (col % 2 == 0) {
                        --y0;
                        scan -= scanStride;
                    } else {
                        ++x0;
                        scan += 3;
                    }
                    int cfaIndex = 2 * (y0 & 1) + (x0 & 1);
                    data[scan + this.cfaOffsets[cfaIndex]] = iis.readShort();
                }
            }
            iis.skipBytes(2 * (this.cfaWidth - width));
        }
    }
}

