/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.demosaic;

import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;

public abstract class BayerInfo {
    protected int pixelStride;
    protected int scanlineStride;
    protected int redOffset;
    protected int greenOffset;
    protected int blueOffset;
    protected int redSampleStride;
    protected int greenSample1Stride;
    protected int greenSample2Stride;
    protected int blueSampleStride;
    protected int redHInterpStride;
    protected int redVInterpStride;
    protected int redCInterpStride;
    protected int greenInterp1Stride;
    protected int greenInterp2Stride;
    protected int blueHInterpStride;
    protected int blueVInterpStride;
    protected int blueCInterpStride;

    public abstract void computeSampleStrides();

    public final void setSampleModel(SampleModel sampleModel) {
        PixelInterleavedSampleModel sm = (PixelInterleavedSampleModel)sampleModel;
        this.pixelStride = sm.getPixelStride();
        this.scanlineStride = sm.getScanlineStride();
        int[] bo = sm.getBandOffsets();
        this.redOffset = bo[0] % this.pixelStride;
        this.greenOffset = bo[1] % this.pixelStride;
        this.blueOffset = bo[2] % this.pixelStride;
        this.computeSampleStrides();
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getRedOffset() {
        return this.redOffset;
    }

    public int getGreenOffset() {
        return this.greenOffset;
    }

    public int getBlueOffset() {
        return this.blueOffset;
    }

    public int getRedSampleStride() {
        return this.redSampleStride;
    }

    public int getGreenSample1Stride() {
        return this.greenSample1Stride;
    }

    public int getGreenSample2Stride() {
        return this.greenSample2Stride;
    }

    public int getBlueSampleStride() {
        return this.blueSampleStride;
    }

    public int getRedHInterpStride() {
        return this.redHInterpStride;
    }

    public int getRedVInterpStride() {
        return this.redVInterpStride;
    }

    public int getRedCInterpStride() {
        return this.redCInterpStride;
    }

    public int getGreenInterp1Stride() {
        return this.greenInterp1Stride;
    }

    public int getGreenInterp2Stride() {
        return this.greenInterp2Stride;
    }

    public int getBlueHInterpStride() {
        return this.blueHInterpStride;
    }

    public int getBlueVInterpStride() {
        return this.blueVInterpStride;
    }

    public int getBlueCInterpStride() {
        return this.blueCInterpStride;
    }
}

