/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.dng;

import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.CurveOperation;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;

public class DNGCurveOperation
extends CurveOperation {
    private static final String CLASS = "it.tidalwave.imageio.rawprocessor.dng.DNGCurveOperation";
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.rawprocessor.dng.DNGCurveOperation");

    protected int[] getBlackLevel(PipelineArtifact artifact) {
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        double blackLevel = 0.0;
        if (primaryIFD.isBlackLevelAvailable()) {
            blackLevel += DNGCurveOperation.getMeanValue(primaryIFD.getBlackLevel());
        }
        if (primaryIFD.isBlackLevelDeltaHAvailable()) {
            blackLevel += DNGCurveOperation.getMeanValue(primaryIFD.getBlackLevelDeltaH());
        }
        if (primaryIFD.isBlackLevelDeltaVAvailable()) {
            blackLevel += DNGCurveOperation.getMeanValue(primaryIFD.getBlackLevelDeltaV());
        }
        return new int[]{(int)blackLevel, (int)blackLevel, (int)blackLevel};
    }

    protected double getWhiteLevel(PipelineArtifact artifact) {
        double whiteLevel;
        logger.fine("getWhiteLevel()", new Object[0]);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        IFD rasterIFD = metadata.getRasterIFD();
        if (primaryIFD.isWhiteLevelAvailable()) {
            whiteLevel = primaryIFD.getWhiteLevel()[0];
            logger.finer(">>>> whiteLevel from WhiteLevel in primaryIFD: %f", whiteLevel);
        } else if (rasterIFD.isWhiteLevelAvailable()) {
            whiteLevel = rasterIFD.getWhiteLevel()[0];
            logger.finer(">>>> whiteLevel from WhiteLevel in rasterIFD: %f", whiteLevel);
        } else {
            int bitsPerSample = rasterIFD.getBitsPerSample()[0];
            whiteLevel = (1 << bitsPerSample) - 1;
            logger.finer(">>>> whiteLevel from BitsPerSample: %f", whiteLevel);
        }
        return whiteLevel;
    }
}

