/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.dng;

import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import javax.annotation.Nonnull;

public class DNGSizeOperation
extends SizeOperation {
    private static final String CLASS = DNGSizeOperation.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Nonnull
    protected Insets getCrop(@Nonnull PipelineArtifact artifact) {
        logger.fine("getCrop(%s)", artifact);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD rasterIFD = metadata.getRasterIFD();
        TagRational[] cropOrigin = rasterIFD.getDefaultCropOrigin();
        TagRational[] cropSize = rasterIFD.getDefaultCropSize();
        int imageWidth = artifact.getImage().getWidth();
        int imageHeight = artifact.getImage().getHeight();
        int left = (int)Math.round(cropOrigin[0].doubleValue());
        int top = (int)Math.round(cropOrigin[1].doubleValue());
        int cropWidth = (int)Math.round(cropSize[0].doubleValue());
        int cropHeight = (int)Math.round(cropSize[1].doubleValue());
        int rotation = this.normalizedAngle(artifact.getRotation());
        if (rotation == 90 || rotation == 270) {
            int temp = cropWidth;
            cropWidth = cropHeight;
            cropHeight = temp;
            temp = left;
            left = top;
            top = temp;
        }
        logger.finest(">>>> getCrop(): width: %d, height: %d, left: %d, top: %d, cropWidth: %d, cropHeight: %d", imageWidth, imageHeight, left, top, cropWidth, cropHeight);
        Insets crop = new Insets(top, left, imageHeight - top - cropHeight, imageWidth - left - cropWidth);
        logger.finer(">>>> returning %s", crop);
        return crop;
    }

    @Nonnull
    protected Dimension getSize(@Nonnull PipelineArtifact artifact) {
        logger.fine("getSize(%s)", artifact);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD rasterIFD = metadata.getRasterIFD();
        TagRational[] cropSize = rasterIFD.getDefaultCropSize();
        TagRational[] scale = rasterIFD.isDefaultScaleAvailable() ? rasterIFD.getDefaultScale() : SCALE_UNCHANGED;
        int cropWidth = (int)Math.round(cropSize[0].doubleValue());
        int cropHeight = (int)Math.round(cropSize[1].doubleValue());
        int width = (int)Math.round((double)cropWidth * scale[0].doubleValue());
        int height = (int)Math.round((double)cropHeight * scale[1].doubleValue());
        int rotation = this.normalizedAngle(artifact.getRotation());
        Dimension size = DNGSizeOperation.rotate(new Dimension(width, height), rotation);
        logger.finer(">>>> returning %s", size);
        return size;
    }
}

