/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.orf;

import it.tidalwave.imageio.orf.ImageProcessing;
import it.tidalwave.imageio.orf.ORFMetadata;
import it.tidalwave.imageio.orf.OlympusMakerNote;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;

public class ORFSizeOperation
extends SizeOperation {
    private static final Logger logger = ORFSizeOperation.getLogger(ORFSizeOperation.class);

    @Nonnull
    protected Insets getCrop(@Nonnull PipelineArtifact artifact) {
        BufferedImage bufferedImage = artifact.getImage();
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        Dimension newSize = this.getSize(artifact);
        Insets crop = NULL_CROP;
        if (newSize == null) {
            logger.warning("Can't find a crop", new Object[0]);
        } else {
            int top = (height - newSize.height) / 2;
            int left = (width - newSize.width) / 2;
            int bottom = height - newSize.height - top;
            int right = width - newSize.width - left;
            crop = new Insets(top, left, bottom, right);
        }
        logger.finer(">>>> returning %s", crop);
        return crop;
    }

    @Nonnull
    protected Dimension getSize(@Nonnull PipelineArtifact artifact) {
        ImageProcessing imageProcessing;
        logger.fine("getSize(%s)", artifact);
        Dimension size = null;
        ORFMetadata metadata = (ORFMetadata)artifact.getRAWMetadata();
        OlympusMakerNote makerNote = metadata.getOlympusMakerNote();
        if (makerNote.isImageWidthAvailable()) {
            size = new Dimension(makerNote.getImageWidth(), makerNote.getImageHeight());
        }
        if (size == null && makerNote.isImageProcessingAvailable() && (imageProcessing = makerNote.getOlympusImageProcessing()).isImageWidthAvailable()) {
            size = new Dimension(imageProcessing.getImageWidth(), imageProcessing.getImageHeight());
        }
        logger.finer(">>>> returning %s", size);
        return size;
    }
}

